/**
 * @license
 * Pixi.JS - v1.0.0
 * Copyright (c) 2012, Mat Groves
 * http://goodboydigital.com/
 *
 * Compiled: 2013-04-26
 *
 * Pixi.JS is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license.php
 */
function HEXtoRGB(t){return[(255&t>>16)/255,(255&t>>8)/255,(255&t)/255]}function determineMatrixArrayType(){return PIXI.Matrix="undefined"!=typeof Float32Array?Float32Array:Array,PIXI.Matrix}var PIXI=PIXI||{};PIXI.Point=function(t,e){this.x=t||0,this.y=e||0},PIXI.Point.clone=function(){return new PIXI.Point(this.x,this.y)},PIXI.Point.constructor=PIXI.Point,PIXI.Rectangle=function(t,e,i,r){this.x=t||0,this.y=e||0,this.width=i||0,this.height=r||0},PIXI.Rectangle.clone=function(){return new PIXI.Rectangle(this.x,this.y,this.width,this.height)},PIXI.Rectangle.constructor=PIXI.Rectangle,PIXI.DisplayObject=function(){this.position=new PIXI.Point,this.scale=new PIXI.Point(1,1),this.rotation=0,this.alpha=1,this.visible=!0,this.cacheVisible=!1,this.parent=null,this.stage=null,this.hitArea=null,this.worldAlpha=1,this.color=[],this.worldTransform=PIXI.mat3.create(),this.localTransform=PIXI.mat3.create(),this.dynamic=!0,this._sr=0,this._cr=1,this.renderable=!1,this.interactive=!1,this.buttonMode=!1},PIXI.DisplayObject.constructor=PIXI.DisplayObject,PIXI.DisplayObject.prototype.setInteractive=function(t){this.interactive=t,this.stage&&(this.stage.dirty=!0)},PIXI.DisplayObject.prototype.updateTransform=function(){this.rotation!=this.rotationCache&&(this.rotationCache=this.rotation,this._sr=Math.sin(this.rotation),this._cr=Math.cos(this.rotation));var t=this.localTransform,e=this.parent.worldTransform,i=this.worldTransform;t[0]=this._cr*this.scale.x,t[1]=-this._sr*this.scale.y,t[3]=this._sr*this.scale.x,t[4]=this._cr*this.scale.y,t[2]=this.position.x,t[5]=this.position.y;var r=t[0],s=t[1],n=t[2],o=t[3],h=t[4],a=t[5],c=e[0],u=e[1],d=e[2],l=e[3],I=e[4],f=e[5];i[0]=c*r+u*o,i[1]=c*s+u*h,i[2]=c*n+u*a+d,i[3]=l*r+I*o,i[4]=l*s+I*h,i[5]=l*n+I*a+f,this.worldAlpha=this.alpha*this.parent.worldAlpha},PIXI.DisplayObjectContainer=function(){PIXI.DisplayObject.call(this),this.children=[],this.renderable=!1},PIXI.DisplayObjectContainer.constructor=PIXI.DisplayObjectContainer,PIXI.DisplayObjectContainer.prototype=Object.create(PIXI.DisplayObject.prototype),PIXI.DisplayObjectContainer.prototype.addChild=function(t){void 0!=t.parent&&t.parent.removeChild(t),t.parent=this,t.childIndex=this.children.length,this.children.push(t),this.stage&&this.stage.__addChild(t)},PIXI.DisplayObjectContainer.prototype.addChildAt=function(t,e){if(!(e>=0&&this.children.length>=e))throw Error(t+" The index "+e+" supplied is out of bounds "+this.children.length);void 0!=t.parent&&t.parent.removeChild(t),e==this.children.length?this.children.push(t):this.children.splice(e,0,t),t.parent=this,t.childIndex=e;for(var i=this.children.length,r=e;i>r;r++)this.children[r].childIndex=r;this.stage&&this.stage.__addChild(t)},PIXI.DisplayObjectContainer.prototype.swapChildren=function(t,e){var i=this.children.indexOf(t),r=this.children.indexOf(e);if(-1===i||-1===r)throw Error(t+" Both the supplied DisplayObjects must be a child of the caller "+this);this.stage&&(this.stage.__removeChild(t),this.stage.__removeChild(e),this.stage.__addChild(t),this.stage.__addChild(e)),t.childIndex=r,e.childIndex=i,this.children[i]=e,this.children[r]=t},PIXI.DisplayObjectContainer.prototype.getChildAt=function(t){if(t>=0&&this.children.length>t)return this.children[t];throw Error(child+" Both the supplied DisplayObjects must be a child of the caller "+this)},PIXI.DisplayObjectContainer.prototype.removeChild=function(t){var e=this.children.indexOf(t);if(-1===e)throw Error(t+" The supplied DisplayObject must be a child of the caller "+this);this.stage&&this.stage.__removeChild(t),t.parent=void 0,this.children.splice(e,1);for(var i=e,r=this.children.length;r>i;i++)this.children[i].childIndex-=1},PIXI.DisplayObjectContainer.prototype.updateTransform=function(){if(this.visible){PIXI.DisplayObject.prototype.updateTransform.call(this);for(var t=0,e=this.children.length;e>t;t++)this.children[t].updateTransform()}},PIXI.blendModes={},PIXI.blendModes.NORMAL=0,PIXI.blendModes.SCREEN=1,PIXI.Sprite=function(t){PIXI.DisplayObjectContainer.call(this),this.anchor=new PIXI.Point,this.texture=t,this.blendMode=PIXI.blendModes.NORMAL,this._width=0,this._height=0,t.baseTexture.hasLoaded?this.updateFrame=!0:(this.onTextureUpdateBind=this.onTextureUpdate.bind(this),this.texture.addEventListener("update",this.onTextureUpdateBind)),this.renderable=!0},PIXI.Sprite.constructor=PIXI.Sprite,PIXI.Sprite.prototype=Object.create(PIXI.DisplayObjectContainer.prototype),Object.defineProperty(PIXI.Sprite.prototype,"width",{get:function(){return this.scale.x*this.texture.frame.width},set:function(t){this.scale.x=t/this.texture.frame.width,this._width=t}}),Object.defineProperty(PIXI.Sprite.prototype,"height",{get:function(){return this.scale.y*this.texture.frame.height},set:function(t){this.scale.y=t/this.texture.frame.height,this._height=t}}),PIXI.Sprite.prototype.setTexture=function(t){this.texture.baseTexture!=t.baseTexture&&(this.textureChange=!0),this.texture=t,this.updateFrame=!0},PIXI.Sprite.prototype.onTextureUpdate=function(){this._width&&(this.scale.x=this._width/this.texture.frame.width),this._height&&(this.scale.y=this._height/this.texture.frame.height),this.updateFrame=!0},PIXI.Sprite.fromFrame=function(t){var e=PIXI.TextureCache[t];if(!e)throw Error("The frameId '"+t+"' does not exist in the texture cache"+this);return new PIXI.Sprite(e)},PIXI.Sprite.fromImage=function(t){var e=PIXI.Texture.fromImage(t);return new PIXI.Sprite(e)},PIXI.MovieClip=function(t){PIXI.Sprite.call(this,t[0]),this.textures=t,this.currentFrame=0,this.animationSpeed=1,this.loop=!0,this.onComplete=null,this.playing},PIXI.MovieClip.constructor=PIXI.MovieClip,PIXI.MovieClip.prototype=Object.create(PIXI.Sprite.prototype),PIXI.MovieClip.prototype.stop=function(){this.playing=!1},PIXI.MovieClip.prototype.play=function(){this.playing=!0},PIXI.MovieClip.prototype.gotoAndStop=function(t){this.playing=!1,this.currentFrame=t;var e=0|this.currentFrame+.5;this.setTexture(this.textures[e%this.textures.length])},PIXI.MovieClip.prototype.gotoAndPlay=function(t){this.currentFrame=t,this.playing=!0},PIXI.MovieClip.prototype.updateTransform=function(){if(PIXI.Sprite.prototype.updateTransform.call(this),this.playing){this.currentFrame+=this.animationSpeed;var t=0|this.currentFrame+.5;this.loop||this.textures.length>t?this.setTexture(this.textures[t%this.textures.length]):t>=this.textures.length&&(this.gotoAndStop(this.textures.length-1),this.onComplete&&this.onComplete())}},PIXI.Text=function(t,e,i,r,s){this.canvas=document.createElement("canvas"),this.context=this.canvas.getContext("2d"),this.setText(t),this.setStyle(e,i,r,s),this.updateText(),PIXI.Sprite.call(this,PIXI.Texture.fromCanvas(this.canvas))},PIXI.Text.constructor=PIXI.Text,PIXI.Text.prototype=Object.create(PIXI.Sprite.prototype),PIXI.Text.prototype.setText=function(t){this.text=t||" ",this.dirty=!0},PIXI.Text.prototype.setStyle=function(t,e,i,r){this.fontStyle=t||"bold 20pt Arial",this.fillStyle=e,this.strokeStyle=i,this.strokeThickness=r||0,this.dirty=!0},PIXI.Text.prototype.updateText=function(){this.context.font=this.fontStyle,this.canvas.width=this.context.measureText(this.text).width+this.strokeThickness,this.canvas.height=this.determineFontHeight("font: "+this.fontStyle+";")+this.strokeThickness,this.context.fillStyle=this.fillStyle,this.context.font=this.fontStyle,this.context.strokeStyle=this.strokeStyle,this.context.lineWidth=this.strokeThickness,this.context.textBaseline="top",this.strokeStyle&&this.strokeThickness&&this.context.strokeText(this.text,this.strokeThickness/2,this.strokeThickness/2),this.fillStyle&&this.context.fillText(this.text,this.strokeThickness/2,this.strokeThickness/2)},PIXI.Text.prototype.updateTransform=function(){this.dirty&&(this.updateText(),this.texture.baseTexture.width=this.canvas.width,this.texture.baseTexture.height=this.canvas.height,this.texture.frame.width=this.canvas.width,this.texture.frame.height=this.canvas.height,PIXI.texturesToUpdate.push(this.texture.baseTexture),this.dirty=!1),PIXI.Sprite.prototype.updateTransform.call(this)},PIXI.Text.prototype.determineFontHeight=function(t){var e=PIXI.Text.heightCache[t];if(!e){var i=document.getElementsByTagName("body")[0],r=document.createElement("div"),s=document.createTextNode("M");r.appendChild(s),r.setAttribute("style",t),i.appendChild(r),e=r.offsetHeight,PIXI.Text.heightCache[t]=e,i.removeChild(r)}return e},PIXI.Text.prototype.destroy=function(t){t&&this.texture.destroy()},PIXI.Text.heightCache={},PIXI.InteractionManager=function(t){this.stage=t,this.tempPoint=new PIXI.Point,this.mouseoverEnabled=!0,this.mouse=new PIXI.InteractionData,this.touchs={},this.pool=[],this.interactiveItems=[],this.last=0},PIXI.InteractionManager.constructor=PIXI.InteractionManager,PIXI.InteractionManager.prototype.collectInteractiveSprite=function(t,e){for(var i=t.children,r=i.length,s=r-1;s>=0;s--){var n=i[s];n.interactive?(e.interactiveChildren=!0,this.interactiveItems.push(n),n.children.length>0&&this.collectInteractiveSprite(n,n)):(n.__iParent=null,n.children.length>0&&this.collectInteractiveSprite(n,e))}},PIXI.InteractionManager.prototype.setTarget=function(t){window.navigator.msPointerEnabled&&(t.view.style["-ms-content-zooming"]="none",t.view.style["-ms-touch-action"]="none"),this.target=t,t.view.addEventListener("mousemove",this.onMouseMove.bind(this),!0),t.view.addEventListener("mousedown",this.onMouseDown.bind(this),!0),document.body.addEventListener("mouseup",this.onMouseUp.bind(this),!0),t.view.addEventListener("mouseout",this.onMouseUp.bind(this),!0),t.view.addEventListener("touchstart",this.onTouchStart.bind(this),!0),t.view.addEventListener("touchend",this.onTouchEnd.bind(this),!0),t.view.addEventListener("touchmove",this.onTouchMove.bind(this),!0)},PIXI.InteractionManager.prototype.update=function(){var t=Date.now(),e=t-this.last;if(e=30*e/1e3,!(1>e)){if(this.last=t,this.dirty){this.dirty=!1,this.interactiveItems.length;for(var i=0;this.interactiveItems.length>i;i++)this.interactiveItems[i].interactiveChildren=!0;this.interactiveItems=[],this.stage.interactive&&this.interactiveItems.push(this.stage),this.collectInteractiveSprite(this.stage,this.stage)}for(var r=this.interactiveItems.length,i=0;r>i;i++){var s=this.interactiveItems[i];s.visible&&(s.mouseover||s.mouseout||s.buttonMode)&&(s.__hit=this.hitTest(s,this.mouse),s.__hit?s.__isOver||(s.buttonMode&&(this.target.view.style.cursor="pointer"),s.mouseover&&s.mouseover(this.mouse),s.__isOver=!0):s.__isOver&&(s.buttonMode&&(this.target.view.style.cursor="default"),s.mouseout&&s.mouseout(this.mouse),s.__isOver=!1))}}},PIXI.InteractionManager.prototype.onMouseMove=function(t){t.preventDefault();var e=this.target.view.getBoundingClientRect();this.mouse.global.x=(t.clientX-e.left)*(this.target.width/e.width),this.mouse.global.y=(t.clientY-e.top)*(this.target.height/e.height);var i=this.interactiveItems.length;this.mouse.global;for(var r=0;i>r;r++){var s=this.interactiveItems[r];s.mousemove&&s.mousemove(this.mouse)}},PIXI.InteractionManager.prototype.onMouseDown=function(t){t.preventDefault();var e=this.interactiveItems.length;this.mouse.global,this.stage;for(var i=0;e>i;i++){var r=this.interactiveItems[i];if((r.mousedown||r.click)&&(r.__mouseIsDown=!0,r.__hit=this.hitTest(r,this.mouse),r.__hit&&(r.mousedown&&r.mousedown(this.mouse),r.__isDown=!0,!r.interactiveChildren)))break}},PIXI.InteractionManager.prototype.onMouseUp=function(t){t.preventDefault(),this.mouse.global;for(var e=this.interactiveItems.length,i=!1,r=0;e>r;r++){var s=this.interactiveItems[r];(s.mouseup||s.mouseupoutside||s.click)&&(s.__hit=this.hitTest(s,this.mouse),s.__hit&&!i?(s.mouseup&&s.mouseup(this.mouse),s.__isDown&&s.click&&s.click(this.mouse),s.interactiveChildren||(i=!0)):s.__isDown&&s.mouseupoutside&&s.mouseupoutside(this.mouse),s.__isDown=!1)}},PIXI.InteractionManager.prototype.hitTest=function(t,e){var i=e.global;if(!t.visible)return!1;if(t instanceof PIXI.Sprite){var r=t.worldTransform,s=r[0],n=r[1],o=r[2],h=r[3],a=r[4],c=r[5],u=1/(s*a+n*-h),d=a*u*i.x+-n*u*i.y+(c*n-o*a)*u,l=s*u*i.y+-h*u*i.x+(-c*s+o*h)*u,I=t.texture.frame.width,f=t.texture.frame.height,p=-I*t.anchor.x;if(d>p&&p+I>d){var v=-f*t.anchor.y;if(l>v&&v+f>l)return!0}}else if(t.hitArea){var r=t.worldTransform,x=t.hitArea,s=r[0],n=r[1],o=r[2],h=r[3],a=r[4],c=r[5],u=1/(s*a+n*-h),d=a*u*i.x+-n*u*i.y+(c*n-o*a)*u,l=s*u*i.y+-h*u*i.x+(-c*s+o*h)*u,p=x.x;if(d>p&&p+x.width>d){var v=x.y;if(l>v&&v+x.height>l)return!0}}for(var g=t.children.length,P=0;g>P;P++){var b=t.children[P],T=this.hitTest(b,e);if(T)return!0}return!1},PIXI.InteractionManager.prototype.onTouchMove=function(t){t.preventDefault();for(var e=this.target.view.getBoundingClientRect(),i=t.changedTouches,r=0;i.length>r;r++){var s=i[r],n=this.touchs[s.identifier];n.global.x=(s.clientX-e.left)*(this.target.width/e.width),n.global.y=(s.clientY-e.top)*(this.target.height/e.height)}for(var o=this.interactiveItems.length,r=0;o>r;r++){var h=this.interactiveItems[r];h.touchmove&&h.touchmove(n)}},PIXI.InteractionManager.prototype.onTouchStart=function(t){t.preventDefault();for(var e=this.target.view.getBoundingClientRect(),i=t.changedTouches,r=0;i.length>r;r++){var s=i[r],n=this.pool.pop();n||(n=new PIXI.InteractionData),this.touchs[s.identifier]=n,n.global.x=(s.clientX-e.left)*(this.target.width/e.width),n.global.y=(s.clientY-e.top)*(this.target.height/e.height);for(var o=this.interactiveItems.length,h=0;o>h;h++){var a=this.interactiveItems[h];if((a.touchstart||a.tap)&&(a.__hit=this.hitTest(a,n),a.__hit&&(a.touchstart&&a.touchstart(n),a.__isDown=!0,a.__touchData=n,!a.interactiveChildren)))break}}},PIXI.InteractionManager.prototype.onTouchEnd=function(t){t.preventDefault();for(var e=this.target.view.getBoundingClientRect(),i=t.changedTouches,r=0;i.length>r;r++){var s=i[r],n=this.touchs[s.identifier],o=!1;n.global.x=(s.clientX-e.left)*(this.target.width/e.width),n.global.y=(s.clientY-e.top)*(this.target.height/e.height);for(var h=this.interactiveItems.length,a=0;h>a;a++){var c=this.interactiveItems[a],u=c.__touchData;c.__hit=this.hitTest(c,n),u==n&&((c.touchend||c.tap)&&(c.__hit&&!o?(c.touchend&&c.touchend(n),c.__isDown&&c.tap&&c.tap(n),c.interactiveChildren||(o=!0)):c.__isDown&&c.touchendoutside&&c.touchendoutside(n),c.__isDown=!1),c.__touchData=null)}this.pool.push(n),this.touchs[s.identifier]=null}},PIXI.InteractionData=function(){this.global=new PIXI.Point,this.local=new PIXI.Point,this.target},PIXI.InteractionData.prototype.getLocalPosition=function(t){var e=t.worldTransform,i=this.global,r=e[0],s=e[1],n=e[2],o=e[3],h=e[4],a=e[5],c=1/(r*h+s*-o);return new PIXI.Point(h*c*i.x+-s*c*i.y+(a*s-n*h)*c,r*c*i.y+-o*c*i.x+(-a*r+n*o)*c)},PIXI.InteractionData.constructor=PIXI.InteractionData,PIXI.Stage=function(t,e){PIXI.DisplayObjectContainer.call(this),this.worldTransform=PIXI.mat3.create(),this.__childrenAdded=[],this.__childrenRemoved=[],this.childIndex=0,this.stage=this,this.stage.hitArea=new PIXI.Rectangle(0,0,1e5,1e5),this.interactive=!!e,this.interactionManager=new PIXI.InteractionManager(this),this.setBackgroundColor(t)},PIXI.Stage.constructor=PIXI.Stage,PIXI.Stage.prototype=Object.create(PIXI.DisplayObjectContainer.prototype),PIXI.Stage.prototype.updateTransform=function(){this.worldAlpha=1;for(var t=0,e=this.children.length;e>t;t++)this.children[t].updateTransform();this.dirty&&(this.dirty=!1,this.interactionManager.dirty=!0),this.interactive&&this.interactionManager.update()},PIXI.Stage.prototype.setBackgroundColor=function(t){this.backgroundColor=t||0,this.backgroundColorSplit=HEXtoRGB(this.backgroundColor),this.backgroundColorString="#"+this.backgroundColor.toString(16)},PIXI.Stage.prototype.getMousePosition=function(){return this.interactionManager.mouse.global},PIXI.Stage.prototype.__addChild=function(t){if(t.interactive&&(this.dirty=!0),t.stage=this,t.children)for(var e=0;t.children.length>e;e++)this.__addChild(t.children[e])},PIXI.Stage.prototype.__removeChild=function(t){if(t.interactive&&(this.dirty=!0),this.__childrenRemoved.push(t),t.stage=void 0,t.children)for(var e=0,i=t.children.length;i>e;e++)this.__removeChild(t.children[e])},window.requestAnimFrame=function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(t){window.setTimeout(t,1e3/60)}}(),"function"!=typeof Function.prototype.bind&&(Function.prototype.bind=function(){var t=Array.prototype.slice;return function(e){function i(){var n=s.concat(t.call(arguments));r.apply(this instanceof i?this:e,n)}var r=this,s=t.call(arguments,1);if("function"!=typeof r)throw new TypeError;return i.prototype=function n(t){return t&&(n.prototype=t),this instanceof n?void 0:new n}(r.prototype),i}}());var AjaxRequest=function(){var t=["Msxml2.XMLHTTP","Microsoft.XMLHTTP"];if(!window.ActiveXObject)return window.XMLHttpRequest?new XMLHttpRequest:!1;for(var e=0;t.length>e;e++)try{return new ActiveXObject(t[e])}catch(i){}};PIXI.EventTarget=function(){var t={};this.addEventListener=this.on=function(e,i){void 0===t[e]&&(t[e]=[]),-1===t[e].indexOf(i)&&t[e].push(i)},this.dispatchEvent=this.emit=function(e){for(var i in t[e.type])t[e.type][i](e)},this.removeEventListener=this.off=function(e,i){var r=t[e].indexOf(i);-1!==r&&t[e].splice(r,1)}},determineMatrixArrayType(),PIXI.mat3={},PIXI.mat3.create=function(){var t=new PIXI.Matrix(9);return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},PIXI.mat4={},PIXI.mat4.create=function(){var t=new PIXI.Matrix(16);return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},PIXI.mat3.multiply=function(t,e,i){i||(i=t);var r=t[0],s=t[1],n=t[2],o=t[3],h=t[4],a=t[5],c=t[6],u=t[7],d=t[8],l=e[0],I=e[1],f=e[2],p=e[3],v=e[4],x=e[5],g=e[6],P=e[7],b=e[8];return i[0]=l*r+I*o+f*c,i[1]=l*s+I*h+f*u,i[2]=l*n+I*a+f*d,i[3]=p*r+v*o+x*c,i[4]=p*s+v*h+x*u,i[5]=p*n+v*a+x*d,i[6]=g*r+P*o+b*c,i[7]=g*s+P*h+b*u,i[8]=g*n+P*a+b*d,i},PIXI.mat3.toMat4=function(t,e){return e||(e=PIXI.mat4.create()),e[15]=1,e[14]=0,e[13]=0,e[12]=0,e[11]=0,e[10]=t[8],e[9]=t[7],e[8]=t[6],e[7]=0,e[6]=t[5],e[5]=t[4],e[4]=t[3],e[3]=0,e[2]=t[2],e[1]=t[1],e[0]=t[0],e},PIXI.mat4.create=function(){var t=new PIXI.Matrix(16);return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},PIXI.mat4.transpose=function(t,e){if(!e||t===e){var i=t[1],r=t[2],s=t[3],n=t[6],o=t[7],h=t[11];return t[1]=t[4],t[2]=t[8],t[3]=t[12],t[4]=i,t[6]=t[9],t[7]=t[13],t[8]=r,t[9]=n,t[11]=t[14],t[12]=s,t[13]=o,t[14]=h,t}return e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=t[1],e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=t[2],e[9]=t[6],e[10]=t[10],e[11]=t[14],e[12]=t[3],e[13]=t[7],e[14]=t[11],e[15]=t[15],e},PIXI.mat4.multiply=function(t,e,i){i||(i=t);var r=t[0],s=t[1],n=t[2],o=t[3],h=t[4],a=t[5],c=t[6],u=t[7],d=t[8],l=t[9],I=t[10],f=t[11],p=t[12],v=t[13],x=t[14],g=t[15],P=e[0],b=e[1],T=e[2],_=e[3];return i[0]=P*r+b*h+T*d+_*p,i[1]=P*s+b*a+T*l+_*v,i[2]=P*n+b*c+T*I+_*x,i[3]=P*o+b*u+T*f+_*g,P=e[4],b=e[5],T=e[6],_=e[7],i[4]=P*r+b*h+T*d+_*p,i[5]=P*s+b*a+T*l+_*v,i[6]=P*n+b*c+T*I+_*x,i[7]=P*o+b*u+T*f+_*g,P=e[8],b=e[9],T=e[10],_=e[11],i[8]=P*r+b*h+T*d+_*p,i[9]=P*s+b*a+T*l+_*v,i[10]=P*n+b*c+T*I+_*x,i[11]=P*o+b*u+T*f+_*g,P=e[12],b=e[13],T=e[14],_=e[15],i[12]=P*r+b*h+T*d+_*p,i[13]=P*s+b*a+T*l+_*v,i[14]=P*n+b*c+T*I+_*x,i[15]=P*o+b*u+T*f+_*g,i},PIXI.autoDetectRenderer=function(t,e,i,r){t||(t=800),e||(e=600);var s=function(){try{return!!window.WebGLRenderingContext&&!!document.createElement("canvas").getContext("experimental-webgl")}catch(t){return!1}}();return s?new PIXI.WebGLRenderer(t,e,i,r):new PIXI.CanvasRenderer(t,e,i,r)},PIXI.shaderFragmentSrc=["precision mediump float;","varying vec2 vTextureCoord;","varying float vColor;","uniform sampler2D uSampler;","void main(void) {","gl_FragColor = texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y));","gl_FragColor = gl_FragColor * vColor;","}"],PIXI.shaderVertexSrc=["attribute vec2 aVertexPosition;","attribute vec2 aTextureCoord;","attribute float aColor;","uniform mat4 uMVMatrix;","varying vec2 vTextureCoord;","varying float vColor;","void main(void) {","gl_Position = uMVMatrix * vec4(aVertexPosition, 1.0, 1.0);","vTextureCoord = aTextureCoord;","vColor = aColor;","}"],PIXI.CompileVertexShader=function(t,e){return PIXI._CompileShader(t,e,t.VERTEX_SHADER)},PIXI.CompileFragmentShader=function(t,e){return PIXI._CompileShader(t,e,t.FRAGMENT_SHADER)},PIXI._CompileShader=function(t,e,i){var r=e.join("\n"),s=t.createShader(i);return t.shaderSource(s,r),t.compileShader(s),t.getShaderParameter(s,t.COMPILE_STATUS)?s:(alert(t.getShaderInfoLog(s)),null)},PIXI._defaultFrame=new PIXI.Rectangle(0,0,1,1),PIXI.WebGLRenderer=function(t,e,i,r){this.transparent=!!r,this.width=t||800,this.height=e||600,this.view=i||document.createElement("canvas"),this.view.width=this.width,this.view.height=this.height;var s=this;this.view.addEventListener("webglcontextlost",function(t){s.handleContextLost(t)},!1),this.view.addEventListener("webglcontextrestored",function(t){s.handleContextRestored(t)},!1),this.batchs=[];try{this.gl=this.view.getContext("experimental-webgl",{alpha:this.transparent,antialias:!1,premultipliedAlpha:!0})}catch(n){throw Error(" This browser does not support webGL. Try using the canvas renderer"+this)}this.initShaders();var o=this.gl;this.batch=new PIXI.WebGLBatch(o),o.disable(o.DEPTH_TEST),o.enable(o.BLEND),o.colorMask(!0,!0,!0,this.transparent),this.projectionMatrix=PIXI.mat4.create(),this.resize(this.width,this.height),this.contextLost=!1},PIXI.WebGLRenderer.constructor=PIXI.WebGLRenderer,PIXI.WebGLRenderer.prototype.getBatch=function(){return 0==PIXI._batchs.length?new PIXI.WebGLBatch(this.gl):PIXI._batchs.pop()},PIXI.WebGLRenderer.prototype.returnBatch=function(t){t.clean(),PIXI._batchs.push(t)},PIXI.WebGLRenderer.prototype.initShaders=function(){var t=this.gl,e=PIXI.CompileFragmentShader(t,PIXI.shaderFragmentSrc),i=PIXI.CompileVertexShader(t,PIXI.shaderVertexSrc);this.shaderProgram=t.createProgram();var r=this.shaderProgram;t.attachShader(r,i),t.attachShader(r,e),t.linkProgram(r),t.getProgramParameter(r,t.LINK_STATUS)||alert("Could not initialise shaders"),t.useProgram(r),r.vertexPositionAttribute=t.getAttribLocation(r,"aVertexPosition"),t.enableVertexAttribArray(r.vertexPositionAttribute),r.textureCoordAttribute=t.getAttribLocation(r,"aTextureCoord"),t.enableVertexAttribArray(r.textureCoordAttribute),r.colorAttribute=t.getAttribLocation(r,"aColor"),t.enableVertexAttribArray(r.colorAttribute),r.mvMatrixUniform=t.getUniformLocation(r,"uMVMatrix"),r.samplerUniform=t.getUniformLocation(r,"uSampler"),PIXI.shaderProgram=this.shaderProgram},PIXI.WebGLRenderer.prototype.checkVisibility=function(t,e){for(var i=t.children,r=0;i.length>r;r++){var s=i[r],n=s.visible&&e;s.textureChange&&(s.textureChange=!1,n&&(this.removeDisplayObject(s),this.addDisplayObject(s))),s.cacheVisible!=n&&(s.cacheVisible=n,s.cacheVisible?this.addDisplayObject(s):this.removeDisplayObject(s)),s.children.length>0&&this.checkVisibility(s,n)}},PIXI.WebGLRenderer.prototype.render=function(t){if(!this.contextLost){this.__stage!==t&&(this.__stage&&this.checkVisibility(this.__stage,!1),this.__stage=t);for(var e=0;t.__childrenRemoved.length>e;e++)this.removeDisplayObject(t.__childrenRemoved[e]);for(var e=0;PIXI.texturesToUpdate.length>e;e++)this.updateTexture(PIXI.texturesToUpdate[e]);for(var e=0;PIXI.texturesToDestroy.length>e;e++)this.destroyTexture(PIXI.texturesToDestroy[e]);t.__childrenRemoved=[],t.__childrenAdded=[],PIXI.texturesToUpdate=[],PIXI.texturesToDestroy=[],this.checkVisibility(t,!0),t.updateTransform();var i=this.gl;i.clear(i.COLOR_BUFFER_BIT),i.clearColor(t.backgroundColorSplit[0],t.backgroundColorSplit[1],t.backgroundColorSplit[2],0),i.blendFunc(i.ONE,i.ONE_MINUS_SRC_ALPHA),i.uniformMatrix4fv(this.shaderProgram.mvMatrixUniform,!1,this.projectionMatrix);for(var r,e=0;this.batchs.length>e;e++)r=this.batchs[e],r instanceof PIXI.WebGLBatch?this.batchs[e].render():r instanceof PIXI.TilingSprite?r.visible&&this.renderTilingSprite(r):r instanceof PIXI.Strip&&r.visible&&this.renderStrip(r);if(t.interactive&&(t._interactiveEventsAdded||(t._interactiveEventsAdded=!0,t.interactionManager.setTarget(this))),PIXI.Texture.frameUpdates.length>0){for(var e=0;PIXI.Texture.frameUpdates.length>e;e++)PIXI.Texture.frameUpdates[e].updateFrame=!1;PIXI.Texture.frameUpdates=[]}}},PIXI.WebGLRenderer.prototype.updateTexture=function(t){var e=this.gl;t._glTexture||(t._glTexture=e.createTexture()),t.hasLoaded&&(e.bindTexture(e.TEXTURE_2D,t._glTexture),e.pixelStorei(e.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!0),e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,t.source),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),t._powerOf2?(e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.REPEAT)):(e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE)),e.bindTexture(e.TEXTURE_2D,null)),this.refreshBatchs=!0},PIXI.WebGLRenderer.prototype.destroyTexture=function(t){var e=this.gl;t._glTexture&&(t._glTexture=e.createTexture(),e.deleteTexture(e.TEXTURE_2D,t._glTexture))},PIXI.WebGLRenderer.prototype.addDisplayObject=function(t){if(t.stage&&!t.__inWebGL&&(t.batch=null,t.renderable)){t.__inWebGL=!0;var e=t;do{if(0==e.childIndex)e=e.parent;else for(e=e.parent.children[e.childIndex-1];0!=e.children.length;)e=e.children[e.children.length-1];if(e==t.stage)break}while(!e.renderable||!e.__inWebGL);var i=t;do{if(0==i.children.length){for(;i.childIndex==i.parent.children.length-1;)if(i=i.parent,i==t.stage){i=null;break}i&&(i=i.parent.children[i.childIndex+1])}else i=i.children[0];if(!i)break}while(!i.renderable||!i.__inWebGL);if(t instanceof PIXI.Sprite){var r,s;if(e instanceof PIXI.Sprite){if(r=e.batch,r&&r.texture==t.texture.baseTexture&&r.blendMode==t.blendMode)return r.insertAfter(t,e),void 0}else r=e;if(i)if(i instanceof PIXI.Sprite){if(s=i.batch){if(s.texture==t.texture.baseTexture&&s.blendMode==t.blendMode)return s.insertBefore(t,i),void 0;if(s==r){var n=r.split(i),o=this.getBatch(),h=this.batchs.indexOf(r);return o.init(t),this.batchs.splice(h+1,0,o,n),void 0}}}else s=i;var o=this.getBatch();if(o.init(t),r){var h=this.batchs.indexOf(r);this.batchs.splice(h+1,0,o)}else this.batchs.push(o)}else t instanceof PIXI.TilingSprite?(this.initTilingSprite(t),this.batchs.push(t)):t instanceof PIXI.Strip&&(this.initStrip(t),this.batchs.push(t));this.batchUpdate=!0}},PIXI.WebGLRenderer.prototype.removeDisplayObject=function(t){if(t.cacheVisible=!1,t.renderable){t.__inWebGL=!1;var e;if(t instanceof PIXI.Sprite){var i=t.batch;if(!i)return;i.remove(t),0==i.size&&(e=i)}else e=t;if(e){var r=this.batchs.indexOf(e);if(-1==r)return;if(0==r||r==this.batchs.length-1)return this.batchs.splice(r,1),e instanceof PIXI.WebGLBatch&&this.returnBatch(e),void 0;if(this.batchs[r-1]instanceof PIXI.WebGLBatch&&this.batchs[r+1]instanceof PIXI.WebGLBatch&&this.batchs[r-1].texture==this.batchs[r+1].texture&&this.batchs[r-1].blendMode==this.batchs[r+1].blendMode)return this.batchs[r-1].merge(this.batchs[r+1]),e instanceof PIXI.WebGLBatch&&this.returnBatch(e),this.returnBatch(this.batchs[r+1]),this.batchs.splice(r,2),void 0;this.batchs.splice(r,1),e instanceof PIXI.WebGLBatch&&this.returnBatch(e)}}},PIXI.WebGLRenderer.prototype.resize=function(t,e){this.width=t,this.height=e,this.view.width=t,this.view.height=e,this.gl.viewport(0,0,this.width,this.height);var i=this.projectionMatrix;i[0]=2/this.width,i[5]=-2/this.height,i[12]=-1,i[13]=1},PIXI.WebGLRenderer.prototype.initTilingSprite=function(t){var e=this.gl;t.verticies=new Float32Array([0,0,t.width,0,t.width,t.height,0,t.height]),t.uvs=new Float32Array([0,0,1,0,1,1,0,1]),t.colors=new Float32Array([1,1,1,1]),t.indices=new Uint16Array([0,1,3,2]),t._vertexBuffer=e.createBuffer(),t._indexBuffer=e.createBuffer(),t._uvBuffer=e.createBuffer(),t._colorBuffer=e.createBuffer(),e.bindBuffer(e.ARRAY_BUFFER,t._vertexBuffer),e.bufferData(e.ARRAY_BUFFER,t.verticies,e.STATIC_DRAW),e.bindBuffer(e.ARRAY_BUFFER,t._uvBuffer),e.bufferData(e.ARRAY_BUFFER,t.uvs,e.DYNAMIC_DRAW),e.bindBuffer(e.ARRAY_BUFFER,t._colorBuffer),e.bufferData(e.ARRAY_BUFFER,t.colors,e.STATIC_DRAW),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t._indexBuffer),e.bufferData(e.ELEMENT_ARRAY_BUFFER,t.indices,e.STATIC_DRAW),t.texture.baseTexture._glTexture?(e.bindTexture(e.TEXTURE_2D,t.texture.baseTexture._glTexture),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.REPEAT),t.texture.baseTexture._powerOf2=!0):t.texture.baseTexture._powerOf2=!0},PIXI.WebGLRenderer.prototype.renderTilingSprite=function(t){var e=this.gl;this.shaderProgram;var i=t.tilePosition,r=t.tileScale,s=i.x/t.texture.baseTexture.width,n=i.y/t.texture.baseTexture.height,o=t.width/t.texture.baseTexture.width/r.x,h=t.height/t.texture.baseTexture.height/r.y;t.uvs[0]=0+s,t.uvs[1]=0-n,t.uvs[2]=1*o+s,t.uvs[3]=0-n,t.uvs[4]=1*o+s,t.uvs[5]=1*h-n,t.uvs[6]=0+s,t.uvs[7]=1*h-n,e.bindBuffer(e.ARRAY_BUFFER,t._uvBuffer),e.bufferSubData(e.ARRAY_BUFFER,0,t.uvs),this.renderStrip(t)},PIXI.WebGLRenderer.prototype.initStrip=function(t){var e=this.gl;this.shaderProgram,t._vertexBuffer=e.createBuffer(),t._indexBuffer=e.createBuffer(),t._uvBuffer=e.createBuffer(),t._colorBuffer=e.createBuffer(),e.bindBuffer(e.ARRAY_BUFFER,t._vertexBuffer),e.bufferData(e.ARRAY_BUFFER,t.verticies,e.DYNAMIC_DRAW),e.bindBuffer(e.ARRAY_BUFFER,t._uvBuffer),e.bufferData(e.ARRAY_BUFFER,t.uvs,e.STATIC_DRAW),e.bindBuffer(e.ARRAY_BUFFER,t._colorBuffer),e.bufferData(e.ARRAY_BUFFER,t.colors,e.STATIC_DRAW),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t._indexBuffer),e.bufferData(e.ELEMENT_ARRAY_BUFFER,t.indices,e.STATIC_DRAW)},PIXI.WebGLRenderer.prototype.renderStrip=function(t){var e=this.gl,i=this.shaderProgram,r=PIXI.mat3.toMat4(t.worldTransform);PIXI.mat4.transpose(r),PIXI.mat4.multiply(this.projectionMatrix,r,r),e.uniformMatrix4fv(this.shaderProgram.mvMatrixUniform,!1,r),t.blendMode==PIXI.blendModes.NORMAL?e.blendFunc(e.ONE,e.ONE_MINUS_SRC_ALPHA):e.blendFunc(e.ONE,e.ONE_MINUS_SRC_COLOR),t.dirty?(t.dirty=!1,e.bindBuffer(e.ARRAY_BUFFER,t._vertexBuffer),e.bufferData(e.ARRAY_BUFFER,t.verticies,e.STATIC_DRAW),e.vertexAttribPointer(i.vertexPositionAttribute,2,e.FLOAT,!1,0,0),e.bindBuffer(e.ARRAY_BUFFER,t._uvBuffer),e.bufferData(e.ARRAY_BUFFER,t.uvs,e.STATIC_DRAW),e.vertexAttribPointer(i.textureCoordAttribute,2,e.FLOAT,!1,0,0),e.activeTexture(e.TEXTURE0),e.bindTexture(e.TEXTURE_2D,t.texture.baseTexture._glTexture),e.bindBuffer(e.ARRAY_BUFFER,t._colorBuffer),e.bufferData(e.ARRAY_BUFFER,t.colors,e.STATIC_DRAW),e.vertexAttribPointer(i.colorAttribute,1,e.FLOAT,!1,0,0),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t._indexBuffer),e.bufferData(e.ELEMENT_ARRAY_BUFFER,t.indices,e.STATIC_DRAW)):(e.bindBuffer(e.ARRAY_BUFFER,t._vertexBuffer),e.bufferSubData(e.ARRAY_BUFFER,0,t.verticies),e.vertexAttribPointer(i.vertexPositionAttribute,2,e.FLOAT,!1,0,0),e.bindBuffer(e.ARRAY_BUFFER,t._uvBuffer),e.vertexAttribPointer(i.textureCoordAttribute,2,e.FLOAT,!1,0,0),e.activeTexture(e.TEXTURE0),e.bindTexture(e.TEXTURE_2D,t.texture.baseTexture._glTexture),e.bindBuffer(e.ARRAY_BUFFER,t._colorBuffer),e.vertexAttribPointer(i.colorAttribute,1,e.FLOAT,!1,0,0),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t._indexBuffer)),e.drawElements(e.TRIANGLE_STRIP,t.indices.length,e.UNSIGNED_SHORT,0),e.uniformMatrix4fv(this.shaderProgram.mvMatrixUniform,!1,this.projectionMatrix)},PIXI.WebGLRenderer.prototype.handleContextLost=function(t){t.preventDefault(),this.contextLost=!0},PIXI.WebGLRenderer.prototype.handleContextRestored=function(){this.gl=this.view.getContext("experimental-webgl",{alpha:!0}),this.initShaders();for(var t=0;PIXI.TextureCache.length>t;t++)this.updateTexture(PIXI.TextureCache[t]);for(var t=0;this.batchs.length>t;t++)this.batchs[t].restoreLostContext(this.gl),this.batchs[t].dirty=!0;PIXI._restoreBatchs(this.gl),this.contextLost=!1
},PIXI._batchs=[],PIXI._getBatch=function(t){return 0==PIXI._batchs.length?new PIXI.WebGLBatch(t):PIXI._batchs.pop()},PIXI._returnBatch=function(t){t.clean(),PIXI._batchs.push(t)},PIXI._restoreBatchs=function(t){for(var e=0;PIXI._batchs.length>e;e++)PIXI._batchs[e].restoreLostContext(t)},PIXI.WebGLBatch=function(t){this.gl=t,this.size=0,this.vertexBuffer=t.createBuffer(),this.indexBuffer=t.createBuffer(),this.uvBuffer=t.createBuffer(),this.colorBuffer=t.createBuffer(),this.blendMode=PIXI.blendModes.NORMAL,this.dynamicSize=1},PIXI.WebGLBatch.constructor=PIXI.WebGLBatch,PIXI.WebGLBatch.prototype.clean=function(){this.verticies=[],this.uvs=[],this.indices=[],this.colors=[],this.dynamicSize=1,this.texture=null,this.last=null,this.size=0,this.head,this.tail},PIXI.WebGLBatch.prototype.restoreLostContext=function(t){this.gl=t,this.vertexBuffer=t.createBuffer(),this.indexBuffer=t.createBuffer(),this.uvBuffer=t.createBuffer(),this.colorBuffer=t.createBuffer()},PIXI.WebGLBatch.prototype.init=function(t){t.batch=this,this.dirty=!0,this.blendMode=t.blendMode,this.texture=t.texture.baseTexture,this.head=t,this.tail=t,this.size=1,this.growBatch()},PIXI.WebGLBatch.prototype.insertBefore=function(t,e){this.size++,t.batch=this,this.dirty=!0;var i=e.__prev;e.__prev=t,t.__next=e,i?(t.__prev=i,i.__next=t):this.head=t},PIXI.WebGLBatch.prototype.insertAfter=function(t,e){this.size++,t.batch=this,this.dirty=!0;var i=e.__next;e.__next=t,t.__prev=e,i?(t.__next=i,i.__prev=t):this.tail=t},PIXI.WebGLBatch.prototype.remove=function(t){return this.size--,0==this.size?(t.batch=null,t.__prev=null,t.__next=null,void 0):(t.__prev?t.__prev.__next=t.__next:(this.head=t.__next,this.head.__prev=null),t.__next?t.__next.__prev=t.__prev:(this.tail=t.__prev,this.tail.__next=null),t.batch=null,t.__next=null,t.__prev=null,this.dirty=!0,void 0)},PIXI.WebGLBatch.prototype.split=function(t){this.dirty=!0;var e=new PIXI.WebGLBatch(this.gl);e.init(t),e.tail=this.tail,this.tail=t.__prev,this.tail.__next=null,t.__prev=null;for(var i=0;t;)i++,t.batch=e,t=t.__next;return e.size=i,this.size-=i,e},PIXI.WebGLBatch.prototype.merge=function(t){this.dirty=!0,this.tail.__next=t.head,t.head.__prev=this.tail,this.size+=t.size,this.tail=t.tail;for(var e=t.head;e;)e.batch=this,e=e.__next},PIXI.WebGLBatch.prototype.growBatch=function(){var t=this.gl;this.dynamicSize=1==this.size?1:1.5*this.size,this.verticies=new Float32Array(8*this.dynamicSize),t.bindBuffer(t.ARRAY_BUFFER,this.vertexBuffer),t.bufferData(t.ARRAY_BUFFER,this.verticies,t.DYNAMIC_DRAW),this.uvs=new Float32Array(8*this.dynamicSize),t.bindBuffer(t.ARRAY_BUFFER,this.uvBuffer),t.bufferData(t.ARRAY_BUFFER,this.uvs,t.DYNAMIC_DRAW),this.dirtyUVS=!0,this.colors=new Float32Array(4*this.dynamicSize),t.bindBuffer(t.ARRAY_BUFFER,this.colorBuffer),t.bufferData(t.ARRAY_BUFFER,this.colors,t.DYNAMIC_DRAW),this.dirtyColors=!0,this.indices=new Uint16Array(6*this.dynamicSize);for(var e=this.indices.length/6,i=0;e>i;i++){var r=6*i,s=4*i;this.indices[r+0]=s+0,this.indices[r+1]=s+1,this.indices[r+2]=s+2,this.indices[r+3]=s+0,this.indices[r+4]=s+2,this.indices[r+5]=s+3}t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,this.indexBuffer),t.bufferData(t.ELEMENT_ARRAY_BUFFER,this.indices,t.STATIC_DRAW)},PIXI.WebGLBatch.prototype.refresh=function(){this.gl,this.dynamicSize<this.size&&this.growBatch();for(var t,e=0,i=this.head;i;){t=8*e;var r=i.texture,s=r.frame,n=r.baseTexture.width,o=r.baseTexture.height;this.uvs[t+0]=s.x/n,this.uvs[t+1]=s.y/o,this.uvs[t+2]=(s.x+s.width)/n,this.uvs[t+3]=s.y/o,this.uvs[t+4]=(s.x+s.width)/n,this.uvs[t+5]=(s.y+s.height)/o,this.uvs[t+6]=s.x/n,this.uvs[t+7]=(s.y+s.height)/o,i.updateFrame=!1,colorIndex=4*e,this.colors[colorIndex]=this.colors[colorIndex+1]=this.colors[colorIndex+2]=this.colors[colorIndex+3]=i.worldAlpha,i=i.__next,e++}this.dirtyUVS=!0,this.dirtyColors=!0},PIXI.WebGLBatch.prototype.update=function(){this.gl;for(var t,e,i,r,s,n,o,h,a,c,u,d,l,I,f,p,v=0,x=this.head;x;){if(e=x.texture.frame.width,i=x.texture.frame.height,r=x.anchor.x-x.texture.trim.x,s=x.anchor.y-x.texture.trim.y,n=e*(1-r),o=e*-r,h=i*(1-s),a=i*-s,c=8*v,t=x.worldTransform,u=t[0],d=t[3],l=t[1],I=t[4],f=t[2],p=t[5],this.verticies[c+0]=u*o+l*a+f,this.verticies[c+1]=I*a+d*o+p,this.verticies[c+2]=u*n+l*a+f,this.verticies[c+3]=I*a+d*n+p,this.verticies[c+4]=u*n+l*h+f,this.verticies[c+5]=I*h+d*n+p,this.verticies[c+6]=u*o+l*h+f,this.verticies[c+7]=I*h+d*o+p,x.updateFrame||x.texture.updateFrame){this.dirtyUVS=!0;var g=x.texture,P=g.frame,b=g.baseTexture.width,T=g.baseTexture.height;this.uvs[c+0]=P.x/b,this.uvs[c+1]=P.y/T,this.uvs[c+2]=(P.x+P.width)/b,this.uvs[c+3]=P.y/T,this.uvs[c+4]=(P.x+P.width)/b,this.uvs[c+5]=(P.y+P.height)/T,this.uvs[c+6]=P.x/b,this.uvs[c+7]=(P.y+P.height)/T,x.updateFrame=!1}if(x.cacheAlpha!=x.worldAlpha){x.cacheAlpha=x.worldAlpha;var _=4*v;this.colors[_]=this.colors[_+1]=this.colors[_+2]=this.colors[_+3]=x.worldAlpha,this.dirtyColors=!0}v++,x=x.__next}},PIXI.WebGLBatch.prototype.render=function(){if(this.dirty&&(this.refresh(),this.dirty=!1),0!=this.size){this.update();var t=this.gl;this.blendMode==PIXI.blendModes.NORMAL?t.blendFunc(t.ONE,t.ONE_MINUS_SRC_ALPHA):t.blendFunc(t.ONE,t.ONE_MINUS_SRC_COLOR);var e=PIXI.shaderProgram;t.bindBuffer(t.ARRAY_BUFFER,this.vertexBuffer),t.bufferSubData(t.ARRAY_BUFFER,0,this.verticies),t.vertexAttribPointer(e.vertexPositionAttribute,2,t.FLOAT,!1,0,0),t.bindBuffer(t.ARRAY_BUFFER,this.uvBuffer),this.dirtyUVS&&(this.dirtyUVS=!1,t.bufferSubData(t.ARRAY_BUFFER,0,this.uvs)),t.vertexAttribPointer(e.textureCoordAttribute,2,t.FLOAT,!1,0,0),t.activeTexture(t.TEXTURE0),t.bindTexture(t.TEXTURE_2D,this.texture._glTexture),t.bindBuffer(t.ARRAY_BUFFER,this.colorBuffer),this.dirtyColors&&(this.dirtyColors=!1,t.bufferSubData(t.ARRAY_BUFFER,0,this.colors)),t.vertexAttribPointer(e.colorAttribute,1,t.FLOAT,!1,0,0),t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,this.indexBuffer),t.drawElements(t.TRIANGLES,6*this.size,t.UNSIGNED_SHORT,0)}},PIXI.CanvasRenderer=function(t,e,i,r){this.transparent=r,this.width=t||800,this.height=e||600,this.refresh=!0,this.view=i||document.createElement("canvas"),this.view.width=this.width,this.view.height=this.height,this.count=0,this.context=this.view.getContext("2d")},PIXI.CanvasRenderer.constructor=PIXI.CanvasRenderer,PIXI.CanvasRenderer.prototype.render=function(t){t.__childrenAdded=[],t.__childrenRemoved=[],PIXI.texturesToUpdate=[],PIXI.texturesToDestroy=[],this.context.setTransform(1,0,0,1,0,0),t.updateTransform(),this.context.setTransform(1,0,0,1,0,0),this.view.style.backgroundColor==t.backgroundColorString||this.transparent||(this.view.style.backgroundColor=t.backgroundColorString),this.context.clearRect(0,0,this.width,this.height),this.renderDisplayObject(t),t.interactive&&(t._interactiveEventsAdded||(t._interactiveEventsAdded=!0,t.interactionManager.setTarget(this))),PIXI.Texture.frameUpdates.length>0&&(PIXI.Texture.frameUpdates=[])},PIXI.CanvasRenderer.prototype.resize=function(t,e){this.width=t,this.height=e,this.view.width=t,this.view.height=e},PIXI.CanvasRenderer.prototype.renderDisplayObject=function(t){var e=t.worldTransform,i=this.context;i.globalCompositeOperation="source-over";var r=!1;if(t.visible){if(t instanceof PIXI.Sprite){var s=t.texture.frame;s&&(i.globalAlpha=t.worldAlpha,r=!1,i.setTransform(e[0],e[3],e[1],e[4],e[2],e[5]),i.drawImage(t.texture.baseTexture.source,s.x,s.y,s.width,s.height,(t.anchor.x-t.texture.trim.x)*-s.width,(t.anchor.y-t.texture.trim.y)*-s.height,s.width,s.height))}else t instanceof PIXI.Strip?(i.setTransform(e[0],e[3],e[1],e[4],e[2],e[5]),this.renderStrip(t)):t instanceof PIXI.TilingSprite&&(i.setTransform(e[0],e[3],e[1],e[4],e[2],e[5]),this.renderTilingSprite(t));for(var n=0;t.children.length>n;n++)this.renderDisplayObject(t.children[n])}},PIXI.CanvasRenderer.prototype.renderStripFlat=function(t){var e=this.context,i=t.verticies;t.uvs;var r=i.length/2;this.count++,e.beginPath();for(var s=1;r-2>s;s++){var n=2*s,o=i[n],h=i[n+2],a=i[n+4],c=i[n+1],u=i[n+3],d=i[n+5];e.moveTo(o,c),e.lineTo(h,u),e.lineTo(a,d)}e.fillStyle="#FF0000",e.fill(),e.closePath()},PIXI.CanvasRenderer.prototype.renderTilingSprite=function(t){var e=this.context;t.__tilePattern||(t.__tilePattern=e.createPattern(t.texture.baseTexture.source,"repeat")),e.beginPath();var i=t.tilePosition,r=t.tileScale;e.scale(r.x,r.y),e.translate(i.x,i.y),e.fillStyle=t.__tilePattern,e.fillRect(-i.x,-i.y,t.width/r.x,t.height/r.y),e.scale(1/r.x,1/r.y),e.translate(-i.x,-i.y),e.closePath()},PIXI.CanvasRenderer.prototype.renderStrip=function(t){var e=this.context,i=t.verticies,r=t.uvs,s=i.length/2;this.count++;for(var n=1;s-2>n;n++){var o=2*n,h=i[o],a=i[o+2],c=i[o+4],u=i[o+1],d=i[o+3],l=i[o+5],I=r[o]*t.texture.width,f=r[o+2]*t.texture.width,p=r[o+4]*t.texture.width,v=r[o+1]*t.texture.height,x=r[o+3]*t.texture.height,g=r[o+5]*t.texture.height;e.save(),e.beginPath(),e.moveTo(h,u),e.lineTo(a,d),e.lineTo(c,l),e.closePath(),e.clip();var P=I*x+v*p+f*g-x*p-v*f-I*g,b=h*x+v*c+a*g-x*c-v*a-h*g,T=I*a+h*p+f*c-a*p-h*f-I*c,_=I*x*c+v*a*p+h*f*g-h*x*p-v*f*c-I*a*g,m=u*x+v*l+d*g-x*l-v*d-u*g,X=I*d+u*p+f*l-d*p-u*f-I*l,y=I*x*l+v*d*p+u*f*g-u*x*p-v*f*l-I*d*g;e.transform(b/P,m/P,T/P,X/P,_/P,y/P),e.drawImage(t.texture.baseTexture.source,0,0),e.restore()}},PIXI.Strip=function(t,e,i){PIXI.DisplayObjectContainer.call(this),this.texture=t,this.blendMode=PIXI.blendModes.NORMAL;try{this.uvs=new Float32Array([0,1,1,1,1,0,0,1]),this.verticies=new Float32Array([0,0,0,0,0,0,0,0,0]),this.colors=new Float32Array([1,1,1,1]),this.indices=new Uint16Array([0,1,2,3])}catch(r){this.uvs=[0,1,1,1,1,0,0,1],this.verticies=[0,0,0,0,0,0,0,0,0],this.colors=[1,1,1,1],this.indices=[0,1,2,3]}this.width=e,this.height=i,t.baseTexture.hasLoaded?(this.width=this.texture.frame.width,this.height=this.texture.frame.height,this.updateFrame=!0):(this.onTextureUpdateBind=this.onTextureUpdate.bind(this),this.texture.addEventListener("update",this.onTextureUpdateBind)),this.renderable=!0},PIXI.Strip.constructor=PIXI.Strip,PIXI.Strip.prototype=Object.create(PIXI.DisplayObjectContainer.prototype),PIXI.Strip.prototype.setTexture=function(t){this.texture=t,this.width=t.frame.width,this.height=t.frame.height,this.updateFrame=!0},PIXI.Strip.prototype.onTextureUpdate=function(){this.updateFrame=!0},PIXI.Rope=function(t,e){PIXI.Strip.call(this,t),this.points=e;try{this.verticies=new Float32Array(4*e.length),this.uvs=new Float32Array(4*e.length),this.colors=new Float32Array(2*e.length),this.indices=new Uint16Array(2*e.length)}catch(i){this.verticies=verticies,this.uvs=uvs,this.colors=colors,this.indices=indices}this.refresh()},PIXI.Rope.constructor=PIXI.Rope,PIXI.Rope.prototype=Object.create(PIXI.Strip.prototype),PIXI.Rope.prototype.refresh=function(){var t=this.points;if(!(1>t.length)){var e=this.uvs,i=this.indices,r=this.colors,s=t[0],n=t[0];this.count-=.2,e[0]=0,e[1]=1,e[2]=0,e[3]=1,r[0]=1,r[1]=1,i[0]=0,i[1]=1;for(var o=t.length,h=1;o>h;h++){var n=t[h],a=4*h,c=h/(o-1);h%2?(e[a]=c,e[a+1]=0,e[a+2]=c,e[a+3]=1):(e[a]=c,e[a+1]=0,e[a+2]=c,e[a+3]=1),a=2*h,r[a]=1,r[a+1]=1,a=2*h,i[a]=a,i[a+1]=a+1,s=n}}},PIXI.Rope.prototype.updateTransform=function(){var t=this.points;if(!(1>t.length)){var e,i=this.verticies,r=t[0],s={x:0,y:0},n=t[0];this.count-=.2,i[0]=n.x+s.x,i[1]=n.y+s.y,i[2]=n.x-s.x,i[3]=n.y-s.y;for(var o=t.length,h=1;o>h;h++){var n=t[h],a=4*h;e=t.length-1>h?t[h+1]:n,s.y=-(e.x-r.x),s.x=e.y-r.y;var c=10*(1-h/(o-1));c>1&&(c=1);var u=Math.sqrt(s.x*s.x+s.y*s.y),d=this.texture.height/2;s.x/=u,s.y/=u,s.x*=d,s.y*=d,i[a]=n.x+s.x,i[a+1]=n.y+s.y,i[a+2]=n.x-s.x,i[a+3]=n.y-s.y,r=n}PIXI.DisplayObjectContainer.prototype.updateTransform.call(this)}},PIXI.Rope.prototype.setTexture=function(t){this.texture=t,this.updateFrame=!0},PIXI.TilingSprite=function(t,e,i){PIXI.DisplayObjectContainer.call(this),this.texture=t,this.width=e,this.height=i,this.renderable=!0,this.tileScale=new PIXI.Point(2,1),this.tilePosition=new PIXI.Point(0,0),this.blendMode=PIXI.blendModes.NORMAL},PIXI.TilingSprite.constructor=PIXI.TilingSprite,PIXI.TilingSprite.prototype=Object.create(PIXI.DisplayObjectContainer.prototype),PIXI.TilingSprite.prototype.setTexture=function(t){this.texture=t,this.updateFrame=!0},PIXI.TilingSprite.prototype.onTextureUpdate=function(){this.updateFrame=!0},PIXI.BaseTextureCache={},PIXI.texturesToUpdate=[],PIXI.texturesToDestroy=[],PIXI.BaseTexture=function(t){if(PIXI.EventTarget.call(this),this.width=100,this.height=100,this.source=t,this.source instanceof Image)if(this.source.complete)this.hasLoaded=!0,this.width=this.source.width,this.height=this.source.height,PIXI.texturesToUpdate.push(this);else{var e=this;this.source.onload=function(){e.hasLoaded=!0,e.width=e.source.width,e.height=e.source.height,PIXI.texturesToUpdate.push(e),e.dispatchEvent({type:"loaded",content:e})}}else this.hasLoaded=!0,this.width=this.source.width,this.height=this.source.height,PIXI.texturesToUpdate.push(this);this._powerOf2=!1},PIXI.BaseTexture.constructor=PIXI.BaseTexture,PIXI.BaseTexture.prototype.destroy=function(){this.source instanceof Image&&(this.source.src=null),this.source=null,PIXI.texturesToDestroy.push(this)},PIXI.BaseTexture.fromImage=function(t,e){var i=PIXI.BaseTextureCache[t];if(!i){var r=new Image;e&&(r.crossOrigin=""),r.src=t,i=new PIXI.BaseTexture(r),PIXI.BaseTextureCache[t]=i}return i},PIXI.TextureCache={},PIXI.FrameCache={},PIXI.Texture=function(t,e){if(PIXI.EventTarget.call(this),e||(this.noFrame=!0,e=new PIXI.Rectangle(0,0,1,1)),this.trim=new PIXI.Point,t instanceof PIXI.Texture&&(t=t.baseTexture),this.baseTexture=t,this.frame=e,this.scope=this,t.hasLoaded)this.noFrame&&(e=new PIXI.Rectangle(0,0,t.width,t.height)),this.setFrame(e);else{var i=this;t.addEventListener("loaded",function(){i.onBaseTextureLoaded()})}},PIXI.Texture.constructor=PIXI.Texture,PIXI.Texture.prototype.onBaseTextureLoaded=function(){var t=this.baseTexture;t.removeEventListener("loaded",this.onLoaded),this.noFrame&&(this.frame=new PIXI.Rectangle(0,0,t.width,t.height)),this.noFrame=!1,this.width=this.frame.width,this.height=this.frame.height,this.scope.dispatchEvent({type:"update",content:this})},PIXI.Texture.prototype.destroy=function(t){t&&this.baseTexture.destroy()},PIXI.Texture.prototype.setFrame=function(t){if(this.frame=t,this.width=t.width,this.height=t.height,t.x+t.width>this.baseTexture.width||t.y+t.height>this.baseTexture.height)throw Error("Texture Error: frame does not fit inside the base Texture dimensions "+this);this.updateFrame=!0,PIXI.Texture.frameUpdates.push(this)},PIXI.Texture.fromImage=function(t,e){var i=PIXI.TextureCache[t];return i||(i=new PIXI.Texture(PIXI.BaseTexture.fromImage(t,e)),PIXI.TextureCache[t]=i),i},PIXI.Texture.fromFrame=function(t){var e=PIXI.TextureCache[t];if(!e)throw Error("The frameId '"+t+"' does not exist in the texture cache "+this);return e},PIXI.Texture.fromCanvas=function(t){var e=new PIXI.BaseTexture(t);return new PIXI.Texture(e)},PIXI.Texture.addTextureToCache=function(t,e){PIXI.TextureCache[e]=t},PIXI.Texture.removeTextureFromCache=function(t){var e=PIXI.TextureCache[t];return PIXI.TextureCache[t]=null,e},PIXI.Texture.frameUpdates=[],PIXI.SpriteSheetLoader=function(t){PIXI.EventTarget.call(this),this.url=t,this.baseUrl=t.replace(/[^\/]*$/,""),this.texture,this.frames={},this.crossorigin=!1},PIXI.SpriteSheetLoader.constructor=PIXI.SpriteSheetLoader,PIXI.SpriteSheetLoader.prototype.load=function(){this.ajaxRequest=new AjaxRequest;var t=this;this.ajaxRequest.onreadystatechange=function(){t.onLoaded()},this.ajaxRequest.open("GET",this.url,!0),this.ajaxRequest.overrideMimeType&&this.ajaxRequest.overrideMimeType("application/json"),this.ajaxRequest.send(null)},PIXI.SpriteSheetLoader.prototype.onLoaded=function(){if(4==this.ajaxRequest.readyState&&(200==this.ajaxRequest.status||-1==window.location.href.indexOf("http"))){var jsondata=eval("("+this.ajaxRequest.responseText+")"),textureUrl=this.baseUrl+jsondata.meta.image;this.texture=PIXI.Texture.fromImage(textureUrl,this.crossorigin).baseTexture;var frameData=jsondata.frames;for(var i in frameData){var rect=frameData[i].frame;rect&&(PIXI.TextureCache[i]=new PIXI.Texture(this.texture,{x:rect.x,y:rect.y,width:rect.w,height:rect.h}),frameData[i].trimmed&&(PIXI.TextureCache[i].realSize=frameData[i].spriteSourceSize,PIXI.TextureCache[i].trim.x=0))}if(this.texture.hasLoaded)this.dispatchEvent({type:"loaded",content:this});else{var scope=this;this.texture.addEventListener("loaded",function(){scope.dispatchEvent({type:"loaded",content:scope})})}}},PIXI.AssetLoader=function(t){PIXI.EventTarget.call(this),this.assetURLs=t,this.assets=[],this.crossorigin=!1},PIXI.AssetLoader.constructor=PIXI.AssetLoader,PIXI.AssetLoader.prototype.load=function(){this.loadCount=this.assetURLs.length;for(var t=["jpeg","jpg","png","gif"],e=["json"],i=0;this.assetURLs.length>i;i++){for(var r=this.assetURLs[i],s=r.split(".").pop().toLowerCase(),n=null,o=0;t.length>o;o++)if(s==t[o]){n="img";break}if("img"!=n)for(var o=0;e.length>o;o++)if(s==e[o]){n="atlas";break}if("img"==n){var h=PIXI.Texture.fromImage(r,this.crossorigin);if(h.baseTexture.hasLoaded)this.loadCount--,0==this.loadCount&&(this.dispatchEvent({type:"onComplete",content:this}),this.onComplete&&this.onComplete());else{var a=this;h.baseTexture.addEventListener("loaded",function(){a.onAssetLoaded()}),this.assets.push(h)}}else{if("atlas"!=n)throw Error(r+" is an unsupported file type "+this);var c=new PIXI.SpriteSheetLoader(r);c.crossorigin=this.crossorigin,this.assets.push(c);var a=this;c.addEventListener("loaded",function(){a.onAssetLoaded()}),c.load()}}},PIXI.AssetLoader.prototype.onAssetLoaded=function(){this.loadCount--,this.dispatchEvent({type:"onProgress",content:this}),this.onProgress&&this.onProgress(),0==this.loadCount&&(this.dispatchEvent({type:"onComplete",content:this}),this.onComplete&&this.onComplete())};