// smallworld.js - A small utility for generating small world maps.
// @version v0.1.0
// @link https://github.com/mikefowler/smallworld.js
// @license MIT
!function(t,i){"use strict";"function"==typeof define&&define.amd?define(["exports"],function(e){t.Smallworld=i(t,e)}):"undefined"!=typeof exports?i(t,exports):t.Smallworld=i(t)}(this,function(t){"use strict";function i(t){for(var i=1;i<arguments.length;i++){var e=arguments[i];for(var o in e)void 0===t[o]&&(t[o]=e[o])}return t}t.requestAnimFrame=function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||function(t){window.setTimeout(t,1e3/60)}}();var e={zoom:0,center:[0,0],waterColor:"#b3d1ff",landColor:"#fff",markerColor:"#333",markerSize:5},o=function(t,s){if(!t)throw new Error("A DOM element is required for Smallworld to initialize");if(this.el=t,this.options=i(s||{},e,o.defaults),!this.options.geojson)throw new Error("A GeoJSON source is required for Smallworld to initialize");this.initialize.apply(this),this.draw()};return o.defaults={},o.prototype={initialize:function(){this.width=this.el.clientWidth,this.height=this.el.clientHeight,this.tile=new o.Tile(this.options),this.map=this.createMap(this.width,this.height),this.context=this.map.getContext("2d"),this.el.appendChild(this.map),this.draw()},createMap:function(t,i){var e=document.createElement("canvas");return e.width=t,e.height=i,e.style.position="absolute",e.style.top=0,e.style.left=0,e},getTile:function(){return new o.Tile(arguments)},resize:function(){this.map.width=this.width,this.map.height=this.height},draw:function(){var t,i,e,o,s;for(this.context.fillStyle=this.options.waterColor,this.context.fillRect(0,0,this.width,this.height),t=Math.ceil(this.width/2-this.tile.center.x),i=Math.ceil(this.height/2-this.tile.center.y),e=Math.ceil(t/this.tile.width),o=Math.ceil((this.width-(t+this.tile.width))/this.tile.width),s=1;e>=s;s++)this.context.drawImage(this.tile.el,t-this.tile.width*s,i);for(s=1;o>=s;s++)this.context.drawImage(this.tile.el,t+this.tile.width*s,i);if(this.context.drawImage(this.tile.el,t,i),this.options.marker)this.tile.addMarker(this.options.marker===!0?this.options.center:this.options.marker);else if(this.options.markers)for(var n=0;n<this.options.markers.length;n++)this.tile.addMarker(this.options.markers[n])}},o.Tile=function(t){this.options=i(t||{},e),this.initialize.apply(this)},o.Tile.prototype={initialize:function(){this.geojson=this.options.geojson.features||this.options.geojson,this.scale=Math.pow(2,parseInt(this.options.zoom)),this.bounds=this.getBounds(),this.width=Math.ceil(256*this.scale),this.height=Math.ceil(this.width/1.041975309),this.center=this.coordinateToPoint(this.options.center[0],this.options.center[1]),this.el=document.createElement("canvas"),this.el.width=this.width,this.el.height=this.height,this.context=this.el.getContext("2d"),this.draw()},getBounds:function(){for(var t,i,e={},o=0;o<this.geojson.length;o++){t=this.geojson[o].geometry.coordinates[0];for(var s=0;s<t.length;s++)i=this.projectCoordinate(t[s][1],t[s][0]),e.xMin=e.xMin<i.x?e.xMin:i.x,e.xMax=e.xMax>i.x?e.xMax:i.x,e.yMin=e.yMin<i.y?e.yMin:i.y,e.yMax=e.yMax>i.y?e.yMax:i.y}return e},draw:function(){this.context.fillStyle=this.options.landColor;for(var t=0;t<this.geojson.length;t++){for(var i=this.geojson[t].geometry.coordinates[0],e=0;e<i.length;e++){var o=this.coordinateToPoint(i[e][1],i[e][0]);0===e?(this.context.beginPath(),this.context.moveTo(o.x,o.y)):this.context.lineTo(o.x,o.y)}this.context.fill()}},coordinateToPoint:function(t,i){var e=this.projectCoordinate(t,i),o=this.width/Math.abs(this.bounds.xMax-this.bounds.xMin),s=this.height/Math.abs(this.bounds.yMax-this.bounds.yMin),n=s>o?o:s;return{x:(e.x-this.bounds.xMin)*n,y:(this.bounds.yMax-e.y)*n}},projectCoordinate:function(t,i){var e=o.Projection.mercator(t,i);return e.x=e.x*this.scale,e.y=e.y*this.scale,e},addMarker:function(t,i){i=i||{};var e=this.coordinateToPoint(t[0],t[1]);this.context.beginPath(),this.context.arc(e.x,e.y,this.options.markerSize,0,2*Math.PI,!1),this.context.fillStyle=this.options.markerColor,this.context.fill()}},o.Projection={RADIUS:6378137,MAX:85.0511287798,RADIANS:Math.PI/180,mercator:function(t,i){var e={};return e.x=this.RADIUS*i*this.RADIANS,e.y=Math.max(Math.min(this.MAX,t),-this.MAX)*this.RADIANS,e.y=this.RADIUS*Math.log(Math.tan(Math.PI/4+e.y/2)),e}},o});