var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));

// external-cesium:Cesium
var require_Cesium = __commonJS({
  "external-cesium:Cesium"(exports, module) {
    module.exports = Cesium;
  }
});

// node_modules/mersenne-twister/src/mersenne-twister.js
var require_mersenne_twister = __commonJS({
  "node_modules/mersenne-twister/src/mersenne-twister.js"(exports, module) {
    var MersenneTwister2 = function(seed) {
      if (seed == void 0) {
        seed = (/* @__PURE__ */ new Date()).getTime();
      }
      this.N = 624;
      this.M = 397;
      this.MATRIX_A = 2567483615;
      this.UPPER_MASK = 2147483648;
      this.LOWER_MASK = 2147483647;
      this.mt = new Array(this.N);
      this.mti = this.N + 1;
      if (seed.constructor == Array) {
        this.init_by_array(seed, seed.length);
      } else {
        this.init_seed(seed);
      }
    };
    MersenneTwister2.prototype.init_seed = function(s) {
      this.mt[0] = s >>> 0;
      for (this.mti = 1; this.mti < this.N; this.mti++) {
        var s = this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30;
        this.mt[this.mti] = (((s & 4294901760) >>> 16) * 1812433253 << 16) + (s & 65535) * 1812433253 + this.mti;
        this.mt[this.mti] >>>= 0;
      }
    };
    MersenneTwister2.prototype.init_by_array = function(init_key, key_length) {
      var i, j, k;
      this.init_seed(19650218);
      i = 1;
      j = 0;
      k = this.N > key_length ? this.N : key_length;
      for (; k; k--) {
        var s = this.mt[i - 1] ^ this.mt[i - 1] >>> 30;
        this.mt[i] = (this.mt[i] ^ (((s & 4294901760) >>> 16) * 1664525 << 16) + (s & 65535) * 1664525) + init_key[j] + j;
        this.mt[i] >>>= 0;
        i++;
        j++;
        if (i >= this.N) {
          this.mt[0] = this.mt[this.N - 1];
          i = 1;
        }
        if (j >= key_length)
          j = 0;
      }
      for (k = this.N - 1; k; k--) {
        var s = this.mt[i - 1] ^ this.mt[i - 1] >>> 30;
        this.mt[i] = (this.mt[i] ^ (((s & 4294901760) >>> 16) * 1566083941 << 16) + (s & 65535) * 1566083941) - i;
        this.mt[i] >>>= 0;
        i++;
        if (i >= this.N) {
          this.mt[0] = this.mt[this.N - 1];
          i = 1;
        }
      }
      this.mt[0] = 2147483648;
    };
    MersenneTwister2.prototype.random_int = function() {
      var y;
      var mag01 = new Array(0, this.MATRIX_A);
      if (this.mti >= this.N) {
        var kk;
        if (this.mti == this.N + 1)
          this.init_seed(5489);
        for (kk = 0; kk < this.N - this.M; kk++) {
          y = this.mt[kk] & this.UPPER_MASK | this.mt[kk + 1] & this.LOWER_MASK;
          this.mt[kk] = this.mt[kk + this.M] ^ y >>> 1 ^ mag01[y & 1];
        }
        for (; kk < this.N - 1; kk++) {
          y = this.mt[kk] & this.UPPER_MASK | this.mt[kk + 1] & this.LOWER_MASK;
          this.mt[kk] = this.mt[kk + (this.M - this.N)] ^ y >>> 1 ^ mag01[y & 1];
        }
        y = this.mt[this.N - 1] & this.UPPER_MASK | this.mt[0] & this.LOWER_MASK;
        this.mt[this.N - 1] = this.mt[this.M - 1] ^ y >>> 1 ^ mag01[y & 1];
        this.mti = 0;
      }
      y = this.mt[this.mti++];
      y ^= y >>> 11;
      y ^= y << 7 & 2636928640;
      y ^= y << 15 & 4022730752;
      y ^= y >>> 18;
      return y >>> 0;
    };
    MersenneTwister2.prototype.random_int31 = function() {
      return this.random_int() >>> 1;
    };
    MersenneTwister2.prototype.random_incl = function() {
      return this.random_int() * (1 / 4294967295);
    };
    MersenneTwister2.prototype.random = function() {
      return this.random_int() * (1 / 4294967296);
    };
    MersenneTwister2.prototype.random_excl = function() {
      return (this.random_int() + 0.5) * (1 / 4294967296);
    };
    MersenneTwister2.prototype.random_long = function() {
      var a = this.random_int() >>> 5, b = this.random_int() >>> 6;
      return (a * 67108864 + b) * (1 / 9007199254740992);
    };
    module.exports = MersenneTwister2;
  }
});

// node_modules/urijs/src/punycode.js
var require_punycode = __commonJS({
  "node_modules/urijs/src/punycode.js"(exports, module) {
    (function(root) {
      var freeExports = typeof exports == "object" && exports && !exports.nodeType && exports;
      var freeModule = typeof module == "object" && module && !module.nodeType && module;
      var freeGlobal = typeof global == "object" && global;
      if (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal || freeGlobal.self === freeGlobal) {
        root = freeGlobal;
      }
      var punycode, maxInt = 2147483647, base = 36, tMin = 1, tMax = 26, skew = 38, damp = 700, initialBias = 72, initialN = 128, delimiter = "-", regexPunycode = /^xn--/, regexNonASCII = /[^\x20-\x7E]/, regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, errors = {
        "overflow": "Overflow: input needs wider integers to process",
        "not-basic": "Illegal input >= 0x80 (not a basic code point)",
        "invalid-input": "Invalid input"
      }, baseMinusTMin = base - tMin, floor = Math.floor, stringFromCharCode = String.fromCharCode, key;
      function error(type) {
        throw new RangeError(errors[type]);
      }
      function map(array, fn) {
        var length2 = array.length;
        var result = [];
        while (length2--) {
          result[length2] = fn(array[length2]);
        }
        return result;
      }
      function mapDomain(string, fn) {
        var parts = string.split("@");
        var result = "";
        if (parts.length > 1) {
          result = parts[0] + "@";
          string = parts[1];
        }
        string = string.replace(regexSeparators, ".");
        var labels = string.split(".");
        var encoded = map(labels, fn).join(".");
        return result + encoded;
      }
      function ucs2decode(string) {
        var output = [], counter2 = 0, length2 = string.length, value, extra;
        while (counter2 < length2) {
          value = string.charCodeAt(counter2++);
          if (value >= 55296 && value <= 56319 && counter2 < length2) {
            extra = string.charCodeAt(counter2++);
            if ((extra & 64512) == 56320) {
              output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
            } else {
              output.push(value);
              counter2--;
            }
          } else {
            output.push(value);
          }
        }
        return output;
      }
      function ucs2encode(array) {
        return map(array, function(value) {
          var output = "";
          if (value > 65535) {
            value -= 65536;
            output += stringFromCharCode(value >>> 10 & 1023 | 55296);
            value = 56320 | value & 1023;
          }
          output += stringFromCharCode(value);
          return output;
        }).join("");
      }
      function basicToDigit(codePoint) {
        if (codePoint - 48 < 10) {
          return codePoint - 22;
        }
        if (codePoint - 65 < 26) {
          return codePoint - 65;
        }
        if (codePoint - 97 < 26) {
          return codePoint - 97;
        }
        return base;
      }
      function digitToBasic(digit, flag) {
        return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
      }
      function adapt(delta, numPoints, firstTime) {
        var k = 0;
        delta = firstTime ? floor(delta / damp) : delta >> 1;
        delta += floor(delta / numPoints);
        for (; delta > baseMinusTMin * tMax >> 1; k += base) {
          delta = floor(delta / baseMinusTMin);
        }
        return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
      }
      function decode(input) {
        var output = [], inputLength = input.length, out, i = 0, n = initialN, bias = initialBias, basic, j, index, oldi, w, k, digit, t, baseMinusT;
        basic = input.lastIndexOf(delimiter);
        if (basic < 0) {
          basic = 0;
        }
        for (j = 0; j < basic; ++j) {
          if (input.charCodeAt(j) >= 128) {
            error("not-basic");
          }
          output.push(input.charCodeAt(j));
        }
        for (index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
          for (oldi = i, w = 1, k = base; ; k += base) {
            if (index >= inputLength) {
              error("invalid-input");
            }
            digit = basicToDigit(input.charCodeAt(index++));
            if (digit >= base || digit > floor((maxInt - i) / w)) {
              error("overflow");
            }
            i += digit * w;
            t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
            if (digit < t) {
              break;
            }
            baseMinusT = base - t;
            if (w > floor(maxInt / baseMinusT)) {
              error("overflow");
            }
            w *= baseMinusT;
          }
          out = output.length + 1;
          bias = adapt(i - oldi, out, oldi == 0);
          if (floor(i / out) > maxInt - n) {
            error("overflow");
          }
          n += floor(i / out);
          i %= out;
          output.splice(i++, 0, n);
        }
        return ucs2encode(output);
      }
      function encode(input) {
        var n, delta, handledCPCount, basicLength, bias, j, m, q, k, t, currentValue, output = [], inputLength, handledCPCountPlusOne, baseMinusT, qMinusT;
        input = ucs2decode(input);
        inputLength = input.length;
        n = initialN;
        delta = 0;
        bias = initialBias;
        for (j = 0; j < inputLength; ++j) {
          currentValue = input[j];
          if (currentValue < 128) {
            output.push(stringFromCharCode(currentValue));
          }
        }
        handledCPCount = basicLength = output.length;
        if (basicLength) {
          output.push(delimiter);
        }
        while (handledCPCount < inputLength) {
          for (m = maxInt, j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue >= n && currentValue < m) {
              m = currentValue;
            }
          }
          handledCPCountPlusOne = handledCPCount + 1;
          if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
            error("overflow");
          }
          delta += (m - n) * handledCPCountPlusOne;
          n = m;
          for (j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue < n && ++delta > maxInt) {
              error("overflow");
            }
            if (currentValue == n) {
              for (q = delta, k = base; ; k += base) {
                t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                if (q < t) {
                  break;
                }
                qMinusT = q - t;
                baseMinusT = base - t;
                output.push(
                  stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
                );
                q = floor(qMinusT / baseMinusT);
              }
              output.push(stringFromCharCode(digitToBasic(q, 0)));
              bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
              delta = 0;
              ++handledCPCount;
            }
          }
          ++delta;
          ++n;
        }
        return output.join("");
      }
      function toUnicode(input) {
        return mapDomain(input, function(string) {
          return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
        });
      }
      function toASCII(input) {
        return mapDomain(input, function(string) {
          return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
        });
      }
      punycode = {
        /**
         * A string representing the current Punycode.js version number.
         * @memberOf punycode
         * @type String
         */
        "version": "1.3.2",
        /**
         * An object of methods to convert from JavaScript's internal character
         * representation (UCS-2) to Unicode code points, and back.
         * @see <https://mathiasbynens.be/notes/javascript-encoding>
         * @memberOf punycode
         * @type Object
         */
        "ucs2": {
          "decode": ucs2decode,
          "encode": ucs2encode
        },
        "decode": decode,
        "encode": encode,
        "toASCII": toASCII,
        "toUnicode": toUnicode
      };
      if (typeof define == "function" && typeof define.amd == "object" && define.amd) {
        define("punycode", function() {
          return punycode;
        });
      } else if (freeExports && freeModule) {
        if (module.exports == freeExports) {
          freeModule.exports = punycode;
        } else {
          for (key in punycode) {
            punycode.hasOwnProperty(key) && (freeExports[key] = punycode[key]);
          }
        }
      } else {
        root.punycode = punycode;
      }
    })(exports);
  }
});

// node_modules/urijs/src/IPv6.js
var require_IPv6 = __commonJS({
  "node_modules/urijs/src/IPv6.js"(exports, module) {
    (function(root, factory) {
      "use strict";
      if (typeof module === "object" && module.exports) {
        module.exports = factory();
      } else if (typeof define === "function" && define.amd) {
        define(factory);
      } else {
        root.IPv6 = factory(root);
      }
    })(exports, function(root) {
      "use strict";
      var _IPv6 = root && root.IPv6;
      function bestPresentation(address) {
        var _address = address.toLowerCase();
        var segments = _address.split(":");
        var length2 = segments.length;
        var total = 8;
        if (segments[0] === "" && segments[1] === "" && segments[2] === "") {
          segments.shift();
          segments.shift();
        } else if (segments[0] === "" && segments[1] === "") {
          segments.shift();
        } else if (segments[length2 - 1] === "" && segments[length2 - 2] === "") {
          segments.pop();
        }
        length2 = segments.length;
        if (segments[length2 - 1].indexOf(".") !== -1) {
          total = 7;
        }
        var pos;
        for (pos = 0; pos < length2; pos++) {
          if (segments[pos] === "") {
            break;
          }
        }
        if (pos < total) {
          segments.splice(pos, 1, "0000");
          while (segments.length < total) {
            segments.splice(pos, 0, "0000");
          }
        }
        var _segments;
        for (var i = 0; i < total; i++) {
          _segments = segments[i].split("");
          for (var j = 0; j < 3; j++) {
            if (_segments[0] === "0" && _segments.length > 1) {
              _segments.splice(0, 1);
            } else {
              break;
            }
          }
          segments[i] = _segments.join("");
        }
        var best = -1;
        var _best = 0;
        var _current = 0;
        var current = -1;
        var inzeroes = false;
        for (i = 0; i < total; i++) {
          if (inzeroes) {
            if (segments[i] === "0") {
              _current += 1;
            } else {
              inzeroes = false;
              if (_current > _best) {
                best = current;
                _best = _current;
              }
            }
          } else {
            if (segments[i] === "0") {
              inzeroes = true;
              current = i;
              _current = 1;
            }
          }
        }
        if (_current > _best) {
          best = current;
          _best = _current;
        }
        if (_best > 1) {
          segments.splice(best, _best, "");
        }
        length2 = segments.length;
        var result = "";
        if (segments[0] === "") {
          result = ":";
        }
        for (i = 0; i < length2; i++) {
          result += segments[i];
          if (i === length2 - 1) {
            break;
          }
          result += ":";
        }
        if (segments[length2 - 1] === "") {
          result += ":";
        }
        return result;
      }
      function noConflict() {
        if (root.IPv6 === this) {
          root.IPv6 = _IPv6;
        }
        return this;
      }
      return {
        best: bestPresentation,
        noConflict
      };
    });
  }
});

// node_modules/urijs/src/SecondLevelDomains.js
var require_SecondLevelDomains = __commonJS({
  "node_modules/urijs/src/SecondLevelDomains.js"(exports, module) {
    (function(root, factory) {
      "use strict";
      if (typeof module === "object" && module.exports) {
        module.exports = factory();
      } else if (typeof define === "function" && define.amd) {
        define(factory);
      } else {
        root.SecondLevelDomains = factory(root);
      }
    })(exports, function(root) {
      "use strict";
      var _SecondLevelDomains = root && root.SecondLevelDomains;
      var SLD = {
        // list of known Second Level Domains
        // converted list of SLDs from https://github.com/gavingmiller/second-level-domains
        // ----
        // publicsuffix.org is more current and actually used by a couple of browsers internally.
        // downside is it also contains domains like "dyndns.org" - which is fine for the security
        // issues browser have to deal with (SOP for cookies, etc) - but is way overboard for URI.js
        // ----
        list: {
          "ac": " com gov mil net org ",
          "ae": " ac co gov mil name net org pro sch ",
          "af": " com edu gov net org ",
          "al": " com edu gov mil net org ",
          "ao": " co ed gv it og pb ",
          "ar": " com edu gob gov int mil net org tur ",
          "at": " ac co gv or ",
          "au": " asn com csiro edu gov id net org ",
          "ba": " co com edu gov mil net org rs unbi unmo unsa untz unze ",
          "bb": " biz co com edu gov info net org store tv ",
          "bh": " biz cc com edu gov info net org ",
          "bn": " com edu gov net org ",
          "bo": " com edu gob gov int mil net org tv ",
          "br": " adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg ",
          "bs": " com edu gov net org ",
          "bz": " du et om ov rg ",
          "ca": " ab bc mb nb nf nl ns nt nu on pe qc sk yk ",
          "ck": " biz co edu gen gov info net org ",
          "cn": " ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj ",
          "co": " com edu gov mil net nom org ",
          "cr": " ac c co ed fi go or sa ",
          "cy": " ac biz com ekloges gov ltd name net org parliament press pro tm ",
          "do": " art com edu gob gov mil net org sld web ",
          "dz": " art asso com edu gov net org pol ",
          "ec": " com edu fin gov info med mil net org pro ",
          "eg": " com edu eun gov mil name net org sci ",
          "er": " com edu gov ind mil net org rochest w ",
          "es": " com edu gob nom org ",
          "et": " biz com edu gov info name net org ",
          "fj": " ac biz com info mil name net org pro ",
          "fk": " ac co gov net nom org ",
          "fr": " asso com f gouv nom prd presse tm ",
          "gg": " co net org ",
          "gh": " com edu gov mil org ",
          "gn": " ac com gov net org ",
          "gr": " com edu gov mil net org ",
          "gt": " com edu gob ind mil net org ",
          "gu": " com edu gov net org ",
          "hk": " com edu gov idv net org ",
          "hu": " 2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video ",
          "id": " ac co go mil net or sch web ",
          "il": " ac co gov idf k12 muni net org ",
          "in": " ac co edu ernet firm gen gov i ind mil net nic org res ",
          "iq": " com edu gov i mil net org ",
          "ir": " ac co dnssec gov i id net org sch ",
          "it": " edu gov ",
          "je": " co net org ",
          "jo": " com edu gov mil name net org sch ",
          "jp": " ac ad co ed go gr lg ne or ",
          "ke": " ac co go info me mobi ne or sc ",
          "kh": " com edu gov mil net org per ",
          "ki": " biz com de edu gov info mob net org tel ",
          "km": " asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire ",
          "kn": " edu gov net org ",
          "kr": " ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan ",
          "kw": " com edu gov net org ",
          "ky": " com edu gov net org ",
          "kz": " com edu gov mil net org ",
          "lb": " com edu gov net org ",
          "lk": " assn com edu gov grp hotel int ltd net ngo org sch soc web ",
          "lr": " com edu gov net org ",
          "lv": " asn com conf edu gov id mil net org ",
          "ly": " com edu gov id med net org plc sch ",
          "ma": " ac co gov m net org press ",
          "mc": " asso tm ",
          "me": " ac co edu gov its net org priv ",
          "mg": " com edu gov mil nom org prd tm ",
          "mk": " com edu gov inf name net org pro ",
          "ml": " com edu gov net org presse ",
          "mn": " edu gov org ",
          "mo": " com edu gov net org ",
          "mt": " com edu gov net org ",
          "mv": " aero biz com coop edu gov info int mil museum name net org pro ",
          "mw": " ac co com coop edu gov int museum net org ",
          "mx": " com edu gob net org ",
          "my": " com edu gov mil name net org sch ",
          "nf": " arts com firm info net other per rec store web ",
          "ng": " biz com edu gov mil mobi name net org sch ",
          "ni": " ac co com edu gob mil net nom org ",
          "np": " com edu gov mil net org ",
          "nr": " biz com edu gov info net org ",
          "om": " ac biz co com edu gov med mil museum net org pro sch ",
          "pe": " com edu gob mil net nom org sld ",
          "ph": " com edu gov i mil net ngo org ",
          "pk": " biz com edu fam gob gok gon gop gos gov net org web ",
          "pl": " art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora ",
          "pr": " ac biz com edu est gov info isla name net org pro prof ",
          "ps": " com edu gov net org plo sec ",
          "pw": " belau co ed go ne or ",
          "ro": " arts com firm info nom nt org rec store tm www ",
          "rs": " ac co edu gov in org ",
          "sb": " com edu gov net org ",
          "sc": " com edu gov net org ",
          "sh": " co com edu gov net nom org ",
          "sl": " com edu gov net org ",
          "st": " co com consulado edu embaixada gov mil net org principe saotome store ",
          "sv": " com edu gob org red ",
          "sz": " ac co org ",
          "tr": " av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web ",
          "tt": " aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel ",
          "tw": " club com ebiz edu game gov idv mil net org ",
          "mu": " ac co com gov net or org ",
          "mz": " ac co edu gov org ",
          "na": " co com ",
          "nz": " ac co cri geek gen govt health iwi maori mil net org parliament school ",
          "pa": " abo ac com edu gob ing med net nom org sld ",
          "pt": " com edu gov int net nome org publ ",
          "py": " com edu gov mil net org ",
          "qa": " com edu gov mil net org ",
          "re": " asso com nom ",
          "ru": " ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk ",
          "rw": " ac co com edu gouv gov int mil net ",
          "sa": " com edu gov med net org pub sch ",
          "sd": " com edu gov info med net org tv ",
          "se": " a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z ",
          "sg": " com edu gov idn net org per ",
          "sn": " art com edu gouv org perso univ ",
          "sy": " com edu gov mil net news org ",
          "th": " ac co go in mi net or ",
          "tj": " ac biz co com edu go gov info int mil name net nic org test web ",
          "tn": " agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism ",
          "tz": " ac co go ne or ",
          "ua": " biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt ",
          "ug": " ac co go ne or org sc ",
          "uk": " ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc ",
          "us": " dni fed isa kids nsn ",
          "uy": " com edu gub mil net org ",
          "ve": " co com edu gob info mil net org web ",
          "vi": " co com k12 net org ",
          "vn": " ac biz com edu gov health info int name net org pro ",
          "ye": " co com gov ltd me net org plc ",
          "yu": " ac co edu gov org ",
          "za": " ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web ",
          "zm": " ac co com edu gov net org sch ",
          // https://en.wikipedia.org/wiki/CentralNic#Second-level_domains
          "com": "ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za ",
          "net": "gb jp se uk ",
          "org": "ae",
          "de": "com "
        },
        // gorhill 2013-10-25: Using indexOf() instead Regexp(). Significant boost
        // in both performance and memory footprint. No initialization required.
        // http://jsperf.com/uri-js-sld-regex-vs-binary-search/4
        // Following methods use lastIndexOf() rather than array.split() in order
        // to avoid any memory allocations.
        has: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return false;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
            return false;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return false;
          }
          return sldList.indexOf(" " + domain.slice(sldOffset + 1, tldOffset) + " ") >= 0;
        },
        is: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return false;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset >= 0) {
            return false;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return false;
          }
          return sldList.indexOf(" " + domain.slice(0, tldOffset) + " ") >= 0;
        },
        get: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return null;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
            return null;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return null;
          }
          if (sldList.indexOf(" " + domain.slice(sldOffset + 1, tldOffset) + " ") < 0) {
            return null;
          }
          return domain.slice(sldOffset + 1);
        },
        noConflict: function() {
          if (root.SecondLevelDomains === this) {
            root.SecondLevelDomains = _SecondLevelDomains;
          }
          return this;
        }
      };
      return SLD;
    });
  }
});

// node_modules/urijs/src/URI.js
var require_URI = __commonJS({
  "node_modules/urijs/src/URI.js"(exports, module) {
    (function(root, factory) {
      "use strict";
      if (typeof module === "object" && module.exports) {
        module.exports = factory(require_punycode(), require_IPv6(), require_SecondLevelDomains());
      } else if (typeof define === "function" && define.amd) {
        define(["./punycode", "./IPv6", "./SecondLevelDomains"], factory);
      } else {
        root.URI = factory(root.punycode, root.IPv6, root.SecondLevelDomains, root);
      }
    })(exports, function(punycode, IPv6, SLD, root) {
      "use strict";
      var _URI = root && root.URI;
      function URI(url, base) {
        var _urlSupplied = arguments.length >= 1;
        var _baseSupplied = arguments.length >= 2;
        if (!(this instanceof URI)) {
          if (_urlSupplied) {
            if (_baseSupplied) {
              return new URI(url, base);
            }
            return new URI(url);
          }
          return new URI();
        }
        if (url === void 0) {
          if (_urlSupplied) {
            throw new TypeError("undefined is not a valid argument for URI");
          }
          if (typeof location !== "undefined") {
            url = location.href + "";
          } else {
            url = "";
          }
        }
        if (url === null) {
          if (_urlSupplied) {
            throw new TypeError("null is not a valid argument for URI");
          }
        }
        this.href(url);
        if (base !== void 0) {
          return this.absoluteTo(base);
        }
        return this;
      }
      function isInteger(value) {
        return /^[0-9]+$/.test(value);
      }
      URI.version = "1.19.11";
      var p = URI.prototype;
      var hasOwn = Object.prototype.hasOwnProperty;
      function escapeRegEx(string) {
        return string.replace(/([.*+?^=!:${}()|[\]\/\\])/g, "\\$1");
      }
      function getType(value) {
        if (value === void 0) {
          return "Undefined";
        }
        return String(Object.prototype.toString.call(value)).slice(8, -1);
      }
      function isArray(obj) {
        return getType(obj) === "Array";
      }
      function filterArrayValues(data, value) {
        var lookup = {};
        var i, length2;
        if (getType(value) === "RegExp") {
          lookup = null;
        } else if (isArray(value)) {
          for (i = 0, length2 = value.length; i < length2; i++) {
            lookup[value[i]] = true;
          }
        } else {
          lookup[value] = true;
        }
        for (i = 0, length2 = data.length; i < length2; i++) {
          var _match = lookup && lookup[data[i]] !== void 0 || !lookup && value.test(data[i]);
          if (_match) {
            data.splice(i, 1);
            length2--;
            i--;
          }
        }
        return data;
      }
      function arrayContains(list, value) {
        var i, length2;
        if (isArray(value)) {
          for (i = 0, length2 = value.length; i < length2; i++) {
            if (!arrayContains(list, value[i])) {
              return false;
            }
          }
          return true;
        }
        var _type = getType(value);
        for (i = 0, length2 = list.length; i < length2; i++) {
          if (_type === "RegExp") {
            if (typeof list[i] === "string" && list[i].match(value)) {
              return true;
            }
          } else if (list[i] === value) {
            return true;
          }
        }
        return false;
      }
      function arraysEqual(one, two) {
        if (!isArray(one) || !isArray(two)) {
          return false;
        }
        if (one.length !== two.length) {
          return false;
        }
        one.sort();
        two.sort();
        for (var i = 0, l = one.length; i < l; i++) {
          if (one[i] !== two[i]) {
            return false;
          }
        }
        return true;
      }
      function trimSlashes(text) {
        var trim_expression = /^\/+|\/+$/g;
        return text.replace(trim_expression, "");
      }
      URI._parts = function() {
        return {
          protocol: null,
          username: null,
          password: null,
          hostname: null,
          urn: null,
          port: null,
          path: null,
          query: null,
          fragment: null,
          // state
          preventInvalidHostname: URI.preventInvalidHostname,
          duplicateQueryParameters: URI.duplicateQueryParameters,
          escapeQuerySpace: URI.escapeQuerySpace
        };
      };
      URI.preventInvalidHostname = false;
      URI.duplicateQueryParameters = false;
      URI.escapeQuerySpace = true;
      URI.protocol_expression = /^[a-z][a-z0-9.+-]*$/i;
      URI.idn_expression = /[^a-z0-9\._-]/i;
      URI.punycode_expression = /(xn--)/i;
      URI.ip4_expression = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
      URI.ip6_expression = /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
      URI.find_uri_expression = /\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/ig;
      URI.findUri = {
        // valid "scheme://" or "www."
        start: /\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,
        // everything up to the next whitespace
        end: /[\s\r\n]|$/,
        // trim trailing punctuation captured by end RegExp
        trim: /[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,
        // balanced parens inclusion (), [], {}, <>
        parens: /(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g
      };
      URI.leading_whitespace_expression = /^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/;
      URI.ascii_tab_whitespace = /[\u0009\u000A\u000D]+/g;
      URI.defaultPorts = {
        http: "80",
        https: "443",
        ftp: "21",
        gopher: "70",
        ws: "80",
        wss: "443"
      };
      URI.hostProtocols = [
        "http",
        "https"
      ];
      URI.invalid_hostname_characters = /[^a-zA-Z0-9\.\-:_]/;
      URI.domAttributes = {
        "a": "href",
        "blockquote": "cite",
        "link": "href",
        "base": "href",
        "script": "src",
        "form": "action",
        "img": "src",
        "area": "href",
        "iframe": "src",
        "embed": "src",
        "source": "src",
        "track": "src",
        "input": "src",
        // but only if type="image"
        "audio": "src",
        "video": "src"
      };
      URI.getDomAttribute = function(node) {
        if (!node || !node.nodeName) {
          return void 0;
        }
        var nodeName = node.nodeName.toLowerCase();
        if (nodeName === "input" && node.type !== "image") {
          return void 0;
        }
        return URI.domAttributes[nodeName];
      };
      function escapeForDumbFirefox36(value) {
        return escape(value);
      }
      function strictEncodeURIComponent(string) {
        return encodeURIComponent(string).replace(/[!'()*]/g, escapeForDumbFirefox36).replace(/\*/g, "%2A");
      }
      URI.encode = strictEncodeURIComponent;
      URI.decode = decodeURIComponent;
      URI.iso8859 = function() {
        URI.encode = escape;
        URI.decode = unescape;
      };
      URI.unicode = function() {
        URI.encode = strictEncodeURIComponent;
        URI.decode = decodeURIComponent;
      };
      URI.characters = {
        pathname: {
          encode: {
            // RFC3986 2.1: For consistency, URI producers and normalizers should
            // use uppercase hexadecimal digits for all percent-encodings.
            expression: /%(24|26|2B|2C|3B|3D|3A|40)/ig,
            map: {
              // -._~!'()*
              "%24": "$",
              "%26": "&",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "=",
              "%3A": ":",
              "%40": "@"
            }
          },
          decode: {
            expression: /[\/\?#]/g,
            map: {
              "/": "%2F",
              "?": "%3F",
              "#": "%23"
            }
          }
        },
        reserved: {
          encode: {
            // RFC3986 2.1: For consistency, URI producers and normalizers should
            // use uppercase hexadecimal digits for all percent-encodings.
            expression: /%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,
            map: {
              // gen-delims
              "%3A": ":",
              "%2F": "/",
              "%3F": "?",
              "%23": "#",
              "%5B": "[",
              "%5D": "]",
              "%40": "@",
              // sub-delims
              "%21": "!",
              "%24": "$",
              "%26": "&",
              "%27": "'",
              "%28": "(",
              "%29": ")",
              "%2A": "*",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "="
            }
          }
        },
        urnpath: {
          // The characters under `encode` are the characters called out by RFC 2141 as being acceptable
          // for usage in a URN. RFC2141 also calls out "-", ".", and "_" as acceptable characters, but
          // these aren't encoded by encodeURIComponent, so we don't have to call them out here. Also
          // note that the colon character is not featured in the encoding map; this is because URI.js
          // gives the colons in URNs semantic meaning as the delimiters of path segements, and so it
          // should not appear unencoded in a segment itself.
          // See also the note above about RFC3986 and capitalalized hex digits.
          encode: {
            expression: /%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/ig,
            map: {
              "%21": "!",
              "%24": "$",
              "%27": "'",
              "%28": "(",
              "%29": ")",
              "%2A": "*",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "=",
              "%40": "@"
            }
          },
          // These characters are the characters called out by RFC2141 as "reserved" characters that
          // should never appear in a URN, plus the colon character (see note above).
          decode: {
            expression: /[\/\?#:]/g,
            map: {
              "/": "%2F",
              "?": "%3F",
              "#": "%23",
              ":": "%3A"
            }
          }
        }
      };
      URI.encodeQuery = function(string, escapeQuerySpace) {
        var escaped = URI.encode(string + "");
        if (escapeQuerySpace === void 0) {
          escapeQuerySpace = URI.escapeQuerySpace;
        }
        return escapeQuerySpace ? escaped.replace(/%20/g, "+") : escaped;
      };
      URI.decodeQuery = function(string, escapeQuerySpace) {
        string += "";
        if (escapeQuerySpace === void 0) {
          escapeQuerySpace = URI.escapeQuerySpace;
        }
        try {
          return URI.decode(escapeQuerySpace ? string.replace(/\+/g, "%20") : string);
        } catch (e) {
          return string;
        }
      };
      var _parts = { "encode": "encode", "decode": "decode" };
      var _part;
      var generateAccessor = function(_group, _part2) {
        return function(string) {
          try {
            return URI[_part2](string + "").replace(URI.characters[_group][_part2].expression, function(c) {
              return URI.characters[_group][_part2].map[c];
            });
          } catch (e) {
            return string;
          }
        };
      };
      for (_part in _parts) {
        URI[_part + "PathSegment"] = generateAccessor("pathname", _parts[_part]);
        URI[_part + "UrnPathSegment"] = generateAccessor("urnpath", _parts[_part]);
      }
      var generateSegmentedPathFunction = function(_sep, _codingFuncName, _innerCodingFuncName) {
        return function(string) {
          var actualCodingFunc;
          if (!_innerCodingFuncName) {
            actualCodingFunc = URI[_codingFuncName];
          } else {
            actualCodingFunc = function(string2) {
              return URI[_codingFuncName](URI[_innerCodingFuncName](string2));
            };
          }
          var segments = (string + "").split(_sep);
          for (var i = 0, length2 = segments.length; i < length2; i++) {
            segments[i] = actualCodingFunc(segments[i]);
          }
          return segments.join(_sep);
        };
      };
      URI.decodePath = generateSegmentedPathFunction("/", "decodePathSegment");
      URI.decodeUrnPath = generateSegmentedPathFunction(":", "decodeUrnPathSegment");
      URI.recodePath = generateSegmentedPathFunction("/", "encodePathSegment", "decode");
      URI.recodeUrnPath = generateSegmentedPathFunction(":", "encodeUrnPathSegment", "decode");
      URI.encodeReserved = generateAccessor("reserved", "encode");
      URI.parse = function(string, parts) {
        var pos;
        if (!parts) {
          parts = {
            preventInvalidHostname: URI.preventInvalidHostname
          };
        }
        string = string.replace(URI.leading_whitespace_expression, "");
        string = string.replace(URI.ascii_tab_whitespace, "");
        pos = string.indexOf("#");
        if (pos > -1) {
          parts.fragment = string.substring(pos + 1) || null;
          string = string.substring(0, pos);
        }
        pos = string.indexOf("?");
        if (pos > -1) {
          parts.query = string.substring(pos + 1) || null;
          string = string.substring(0, pos);
        }
        string = string.replace(/^(https?|ftp|wss?)?:+[/\\]*/i, "$1://");
        string = string.replace(/^[/\\]{2,}/i, "//");
        if (string.substring(0, 2) === "//") {
          parts.protocol = null;
          string = string.substring(2);
          string = URI.parseAuthority(string, parts);
        } else {
          pos = string.indexOf(":");
          if (pos > -1) {
            parts.protocol = string.substring(0, pos) || null;
            if (parts.protocol && !parts.protocol.match(URI.protocol_expression)) {
              parts.protocol = void 0;
            } else if (string.substring(pos + 1, pos + 3).replace(/\\/g, "/") === "//") {
              string = string.substring(pos + 3);
              string = URI.parseAuthority(string, parts);
            } else {
              string = string.substring(pos + 1);
              parts.urn = true;
            }
          }
        }
        parts.path = string;
        return parts;
      };
      URI.parseHost = function(string, parts) {
        if (!string) {
          string = "";
        }
        string = string.replace(/\\/g, "/");
        var pos = string.indexOf("/");
        var bracketPos;
        var t;
        if (pos === -1) {
          pos = string.length;
        }
        if (string.charAt(0) === "[") {
          bracketPos = string.indexOf("]");
          parts.hostname = string.substring(1, bracketPos) || null;
          parts.port = string.substring(bracketPos + 2, pos) || null;
          if (parts.port === "/") {
            parts.port = null;
          }
        } else {
          var firstColon = string.indexOf(":");
          var firstSlash = string.indexOf("/");
          var nextColon = string.indexOf(":", firstColon + 1);
          if (nextColon !== -1 && (firstSlash === -1 || nextColon < firstSlash)) {
            parts.hostname = string.substring(0, pos) || null;
            parts.port = null;
          } else {
            t = string.substring(0, pos).split(":");
            parts.hostname = t[0] || null;
            parts.port = t[1] || null;
          }
        }
        if (parts.hostname && string.substring(pos).charAt(0) !== "/") {
          pos++;
          string = "/" + string;
        }
        if (parts.preventInvalidHostname) {
          URI.ensureValidHostname(parts.hostname, parts.protocol);
        }
        if (parts.port) {
          URI.ensureValidPort(parts.port);
        }
        return string.substring(pos) || "/";
      };
      URI.parseAuthority = function(string, parts) {
        string = URI.parseUserinfo(string, parts);
        return URI.parseHost(string, parts);
      };
      URI.parseUserinfo = function(string, parts) {
        var _string = string;
        var firstBackSlash = string.indexOf("\\");
        if (firstBackSlash !== -1) {
          string = string.replace(/\\/g, "/");
        }
        var firstSlash = string.indexOf("/");
        var pos = string.lastIndexOf("@", firstSlash > -1 ? firstSlash : string.length - 1);
        var t;
        if (pos > -1 && (firstSlash === -1 || pos < firstSlash)) {
          t = string.substring(0, pos).split(":");
          parts.username = t[0] ? URI.decode(t[0]) : null;
          t.shift();
          parts.password = t[0] ? URI.decode(t.join(":")) : null;
          string = _string.substring(pos + 1);
        } else {
          parts.username = null;
          parts.password = null;
        }
        return string;
      };
      URI.parseQuery = function(string, escapeQuerySpace) {
        if (!string) {
          return {};
        }
        string = string.replace(/&+/g, "&").replace(/^\?*&*|&+$/g, "");
        if (!string) {
          return {};
        }
        var items = {};
        var splits = string.split("&");
        var length2 = splits.length;
        var v2, name, value;
        for (var i = 0; i < length2; i++) {
          v2 = splits[i].split("=");
          name = URI.decodeQuery(v2.shift(), escapeQuerySpace);
          value = v2.length ? URI.decodeQuery(v2.join("="), escapeQuerySpace) : null;
          if (name === "__proto__") {
            continue;
          } else if (hasOwn.call(items, name)) {
            if (typeof items[name] === "string" || items[name] === null) {
              items[name] = [items[name]];
            }
            items[name].push(value);
          } else {
            items[name] = value;
          }
        }
        return items;
      };
      URI.build = function(parts) {
        var t = "";
        var requireAbsolutePath = false;
        if (parts.protocol) {
          t += parts.protocol + ":";
        }
        if (!parts.urn && (t || parts.hostname)) {
          t += "//";
          requireAbsolutePath = true;
        }
        t += URI.buildAuthority(parts) || "";
        if (typeof parts.path === "string") {
          if (parts.path.charAt(0) !== "/" && requireAbsolutePath) {
            t += "/";
          }
          t += parts.path;
        }
        if (typeof parts.query === "string" && parts.query) {
          t += "?" + parts.query;
        }
        if (typeof parts.fragment === "string" && parts.fragment) {
          t += "#" + parts.fragment;
        }
        return t;
      };
      URI.buildHost = function(parts) {
        var t = "";
        if (!parts.hostname) {
          return "";
        } else if (URI.ip6_expression.test(parts.hostname)) {
          t += "[" + parts.hostname + "]";
        } else {
          t += parts.hostname;
        }
        if (parts.port) {
          t += ":" + parts.port;
        }
        return t;
      };
      URI.buildAuthority = function(parts) {
        return URI.buildUserinfo(parts) + URI.buildHost(parts);
      };
      URI.buildUserinfo = function(parts) {
        var t = "";
        if (parts.username) {
          t += URI.encode(parts.username);
        }
        if (parts.password) {
          t += ":" + URI.encode(parts.password);
        }
        if (t) {
          t += "@";
        }
        return t;
      };
      URI.buildQuery = function(data, duplicateQueryParameters, escapeQuerySpace) {
        var t = "";
        var unique, key, i, length2;
        for (key in data) {
          if (key === "__proto__") {
            continue;
          } else if (hasOwn.call(data, key)) {
            if (isArray(data[key])) {
              unique = {};
              for (i = 0, length2 = data[key].length; i < length2; i++) {
                if (data[key][i] !== void 0 && unique[data[key][i] + ""] === void 0) {
                  t += "&" + URI.buildQueryParameter(key, data[key][i], escapeQuerySpace);
                  if (duplicateQueryParameters !== true) {
                    unique[data[key][i] + ""] = true;
                  }
                }
              }
            } else if (data[key] !== void 0) {
              t += "&" + URI.buildQueryParameter(key, data[key], escapeQuerySpace);
            }
          }
        }
        return t.substring(1);
      };
      URI.buildQueryParameter = function(name, value, escapeQuerySpace) {
        return URI.encodeQuery(name, escapeQuerySpace) + (value !== null ? "=" + URI.encodeQuery(value, escapeQuerySpace) : "");
      };
      URI.addQuery = function(data, name, value) {
        if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              URI.addQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          if (data[name] === void 0) {
            data[name] = value;
            return;
          } else if (typeof data[name] === "string") {
            data[name] = [data[name]];
          }
          if (!isArray(value)) {
            value = [value];
          }
          data[name] = (data[name] || []).concat(value);
        } else {
          throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
        }
      };
      URI.setQuery = function(data, name, value) {
        if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              URI.setQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          data[name] = value === void 0 ? null : value;
        } else {
          throw new TypeError("URI.setQuery() accepts an object, string as the name parameter");
        }
      };
      URI.removeQuery = function(data, name, value) {
        var i, length2, key;
        if (isArray(name)) {
          for (i = 0, length2 = name.length; i < length2; i++) {
            data[name[i]] = void 0;
          }
        } else if (getType(name) === "RegExp") {
          for (key in data) {
            if (name.test(key)) {
              data[key] = void 0;
            }
          }
        } else if (typeof name === "object") {
          for (key in name) {
            if (hasOwn.call(name, key)) {
              URI.removeQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          if (value !== void 0) {
            if (getType(value) === "RegExp") {
              if (!isArray(data[name]) && value.test(data[name])) {
                data[name] = void 0;
              } else {
                data[name] = filterArrayValues(data[name], value);
              }
            } else if (data[name] === String(value) && (!isArray(value) || value.length === 1)) {
              data[name] = void 0;
            } else if (isArray(data[name])) {
              data[name] = filterArrayValues(data[name], value);
            }
          } else {
            data[name] = void 0;
          }
        } else {
          throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter");
        }
      };
      URI.hasQuery = function(data, name, value, withinArray) {
        switch (getType(name)) {
          case "String":
            break;
          case "RegExp":
            for (var key in data) {
              if (hasOwn.call(data, key)) {
                if (name.test(key) && (value === void 0 || URI.hasQuery(data, key, value))) {
                  return true;
                }
              }
            }
            return false;
          case "Object":
            for (var _key in name) {
              if (hasOwn.call(name, _key)) {
                if (!URI.hasQuery(data, _key, name[_key])) {
                  return false;
                }
              }
            }
            return true;
          default:
            throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter");
        }
        switch (getType(value)) {
          case "Undefined":
            return name in data;
          case "Boolean":
            var _booly = Boolean(isArray(data[name]) ? data[name].length : data[name]);
            return value === _booly;
          case "Function":
            return !!value(data[name], name, data);
          case "Array":
            if (!isArray(data[name])) {
              return false;
            }
            var op = withinArray ? arrayContains : arraysEqual;
            return op(data[name], value);
          case "RegExp":
            if (!isArray(data[name])) {
              return Boolean(data[name] && data[name].match(value));
            }
            if (!withinArray) {
              return false;
            }
            return arrayContains(data[name], value);
          case "Number":
            value = String(value);
          case "String":
            if (!isArray(data[name])) {
              return data[name] === value;
            }
            if (!withinArray) {
              return false;
            }
            return arrayContains(data[name], value);
          default:
            throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter");
        }
      };
      URI.joinPaths = function() {
        var input = [];
        var segments = [];
        var nonEmptySegments = 0;
        for (var i = 0; i < arguments.length; i++) {
          var url = new URI(arguments[i]);
          input.push(url);
          var _segments = url.segment();
          for (var s = 0; s < _segments.length; s++) {
            if (typeof _segments[s] === "string") {
              segments.push(_segments[s]);
            }
            if (_segments[s]) {
              nonEmptySegments++;
            }
          }
        }
        if (!segments.length || !nonEmptySegments) {
          return new URI("");
        }
        var uri = new URI("").segment(segments);
        if (input[0].path() === "" || input[0].path().slice(0, 1) === "/") {
          uri.path("/" + uri.path());
        }
        return uri.normalize();
      };
      URI.commonPath = function(one, two) {
        var length2 = Math.min(one.length, two.length);
        var pos;
        for (pos = 0; pos < length2; pos++) {
          if (one.charAt(pos) !== two.charAt(pos)) {
            pos--;
            break;
          }
        }
        if (pos < 1) {
          return one.charAt(0) === two.charAt(0) && one.charAt(0) === "/" ? "/" : "";
        }
        if (one.charAt(pos) !== "/" || two.charAt(pos) !== "/") {
          pos = one.substring(0, pos).lastIndexOf("/");
        }
        return one.substring(0, pos + 1);
      };
      URI.withinString = function(string, callback, options) {
        options || (options = {});
        var _start = options.start || URI.findUri.start;
        var _end = options.end || URI.findUri.end;
        var _trim = options.trim || URI.findUri.trim;
        var _parens = options.parens || URI.findUri.parens;
        var _attributeOpen = /[a-z0-9-]=["']?$/i;
        _start.lastIndex = 0;
        while (true) {
          var match = _start.exec(string);
          if (!match) {
            break;
          }
          var start = match.index;
          if (options.ignoreHtml) {
            var attributeOpen = string.slice(Math.max(start - 3, 0), start);
            if (attributeOpen && _attributeOpen.test(attributeOpen)) {
              continue;
            }
          }
          var end = start + string.slice(start).search(_end);
          var slice = string.slice(start, end);
          var parensEnd = -1;
          while (true) {
            var parensMatch = _parens.exec(slice);
            if (!parensMatch) {
              break;
            }
            var parensMatchEnd = parensMatch.index + parensMatch[0].length;
            parensEnd = Math.max(parensEnd, parensMatchEnd);
          }
          if (parensEnd > -1) {
            slice = slice.slice(0, parensEnd) + slice.slice(parensEnd).replace(_trim, "");
          } else {
            slice = slice.replace(_trim, "");
          }
          if (slice.length <= match[0].length) {
            continue;
          }
          if (options.ignore && options.ignore.test(slice)) {
            continue;
          }
          end = start + slice.length;
          var result = callback(slice, start, end, string);
          if (result === void 0) {
            _start.lastIndex = end;
            continue;
          }
          result = String(result);
          string = string.slice(0, start) + result + string.slice(end);
          _start.lastIndex = start + result.length;
        }
        _start.lastIndex = 0;
        return string;
      };
      URI.ensureValidHostname = function(v2, protocol) {
        var hasHostname = !!v2;
        var hasProtocol = !!protocol;
        var rejectEmptyHostname = false;
        if (hasProtocol) {
          rejectEmptyHostname = arrayContains(URI.hostProtocols, protocol);
        }
        if (rejectEmptyHostname && !hasHostname) {
          throw new TypeError("Hostname cannot be empty, if protocol is " + protocol);
        } else if (v2 && v2.match(URI.invalid_hostname_characters)) {
          if (!punycode) {
            throw new TypeError('Hostname "' + v2 + '" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');
          }
          if (punycode.toASCII(v2).match(URI.invalid_hostname_characters)) {
            throw new TypeError('Hostname "' + v2 + '" contains characters other than [A-Z0-9.-:_]');
          }
        }
      };
      URI.ensureValidPort = function(v2) {
        if (!v2) {
          return;
        }
        var port = Number(v2);
        if (isInteger(port) && port > 0 && port < 65536) {
          return;
        }
        throw new TypeError('Port "' + v2 + '" is not a valid port');
      };
      URI.noConflict = function(removeAll) {
        if (removeAll) {
          var unconflicted = {
            URI: this.noConflict()
          };
          if (root.URITemplate && typeof root.URITemplate.noConflict === "function") {
            unconflicted.URITemplate = root.URITemplate.noConflict();
          }
          if (root.IPv6 && typeof root.IPv6.noConflict === "function") {
            unconflicted.IPv6 = root.IPv6.noConflict();
          }
          if (root.SecondLevelDomains && typeof root.SecondLevelDomains.noConflict === "function") {
            unconflicted.SecondLevelDomains = root.SecondLevelDomains.noConflict();
          }
          return unconflicted;
        } else if (root.URI === this) {
          root.URI = _URI;
        }
        return this;
      };
      p.build = function(deferBuild) {
        if (deferBuild === true) {
          this._deferred_build = true;
        } else if (deferBuild === void 0 || this._deferred_build) {
          this._string = URI.build(this._parts);
          this._deferred_build = false;
        }
        return this;
      };
      p.clone = function() {
        return new URI(this);
      };
      p.valueOf = p.toString = function() {
        return this.build(false)._string;
      };
      function generateSimpleAccessor(_part2) {
        return function(v2, build) {
          if (v2 === void 0) {
            return this._parts[_part2] || "";
          } else {
            this._parts[_part2] = v2 || null;
            this.build(!build);
            return this;
          }
        };
      }
      function generatePrefixAccessor(_part2, _key) {
        return function(v2, build) {
          if (v2 === void 0) {
            return this._parts[_part2] || "";
          } else {
            if (v2 !== null) {
              v2 = v2 + "";
              if (v2.charAt(0) === _key) {
                v2 = v2.substring(1);
              }
            }
            this._parts[_part2] = v2;
            this.build(!build);
            return this;
          }
        };
      }
      p.protocol = generateSimpleAccessor("protocol");
      p.username = generateSimpleAccessor("username");
      p.password = generateSimpleAccessor("password");
      p.hostname = generateSimpleAccessor("hostname");
      p.port = generateSimpleAccessor("port");
      p.query = generatePrefixAccessor("query", "?");
      p.fragment = generatePrefixAccessor("fragment", "#");
      p.search = function(v2, build) {
        var t = this.query(v2, build);
        return typeof t === "string" && t.length ? "?" + t : t;
      };
      p.hash = function(v2, build) {
        var t = this.fragment(v2, build);
        return typeof t === "string" && t.length ? "#" + t : t;
      };
      p.pathname = function(v2, build) {
        if (v2 === void 0 || v2 === true) {
          var res = this._parts.path || (this._parts.hostname ? "/" : "");
          return v2 ? (this._parts.urn ? URI.decodeUrnPath : URI.decodePath)(res) : res;
        } else {
          if (this._parts.urn) {
            this._parts.path = v2 ? URI.recodeUrnPath(v2) : "";
          } else {
            this._parts.path = v2 ? URI.recodePath(v2) : "/";
          }
          this.build(!build);
          return this;
        }
      };
      p.path = p.pathname;
      p.href = function(href, build) {
        var key;
        if (href === void 0) {
          return this.toString();
        }
        this._string = "";
        this._parts = URI._parts();
        var _URI2 = href instanceof URI;
        var _object = typeof href === "object" && (href.hostname || href.path || href.pathname);
        if (href.nodeName) {
          var attribute = URI.getDomAttribute(href);
          href = href[attribute] || "";
          _object = false;
        }
        if (!_URI2 && _object && href.pathname !== void 0) {
          href = href.toString();
        }
        if (typeof href === "string" || href instanceof String) {
          this._parts = URI.parse(String(href), this._parts);
        } else if (_URI2 || _object) {
          var src = _URI2 ? href._parts : href;
          for (key in src) {
            if (key === "query") {
              continue;
            }
            if (hasOwn.call(this._parts, key)) {
              this._parts[key] = src[key];
            }
          }
          if (src.query) {
            this.query(src.query, false);
          }
        } else {
          throw new TypeError("invalid input");
        }
        this.build(!build);
        return this;
      };
      p.is = function(what) {
        var ip = false;
        var ip4 = false;
        var ip6 = false;
        var name = false;
        var sld = false;
        var idn = false;
        var punycode2 = false;
        var relative = !this._parts.urn;
        if (this._parts.hostname) {
          relative = false;
          ip4 = URI.ip4_expression.test(this._parts.hostname);
          ip6 = URI.ip6_expression.test(this._parts.hostname);
          ip = ip4 || ip6;
          name = !ip;
          sld = name && SLD && SLD.has(this._parts.hostname);
          idn = name && URI.idn_expression.test(this._parts.hostname);
          punycode2 = name && URI.punycode_expression.test(this._parts.hostname);
        }
        switch (what.toLowerCase()) {
          case "relative":
            return relative;
          case "absolute":
            return !relative;
          case "domain":
          case "name":
            return name;
          case "sld":
            return sld;
          case "ip":
            return ip;
          case "ip4":
          case "ipv4":
          case "inet4":
            return ip4;
          case "ip6":
          case "ipv6":
          case "inet6":
            return ip6;
          case "idn":
            return idn;
          case "url":
            return !this._parts.urn;
          case "urn":
            return !!this._parts.urn;
          case "punycode":
            return punycode2;
        }
        return null;
      };
      var _protocol = p.protocol;
      var _port = p.port;
      var _hostname = p.hostname;
      p.protocol = function(v2, build) {
        if (v2) {
          v2 = v2.replace(/:(\/\/)?$/, "");
          if (!v2.match(URI.protocol_expression)) {
            throw new TypeError('Protocol "' + v2 + `" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]`);
          }
        }
        return _protocol.call(this, v2, build);
      };
      p.scheme = p.protocol;
      p.port = function(v2, build) {
        if (this._parts.urn) {
          return v2 === void 0 ? "" : this;
        }
        if (v2 !== void 0) {
          if (v2 === 0) {
            v2 = null;
          }
          if (v2) {
            v2 += "";
            if (v2.charAt(0) === ":") {
              v2 = v2.substring(1);
            }
            URI.ensureValidPort(v2);
          }
        }
        return _port.call(this, v2, build);
      };
      p.hostname = function(v2, build) {
        if (this._parts.urn) {
          return v2 === void 0 ? "" : this;
        }
        if (v2 !== void 0) {
          var x = { preventInvalidHostname: this._parts.preventInvalidHostname };
          var res = URI.parseHost(v2, x);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v2 + '" contains characters other than [A-Z0-9.-]');
          }
          v2 = x.hostname;
          if (this._parts.preventInvalidHostname) {
            URI.ensureValidHostname(v2, this._parts.protocol);
          }
        }
        return _hostname.call(this, v2, build);
      };
      p.origin = function(v2, build) {
        if (this._parts.urn) {
          return v2 === void 0 ? "" : this;
        }
        if (v2 === void 0) {
          var protocol = this.protocol();
          var authority = this.authority();
          if (!authority) {
            return "";
          }
          return (protocol ? protocol + "://" : "") + this.authority();
        } else {
          var origin = URI(v2);
          this.protocol(origin.protocol()).authority(origin.authority()).build(!build);
          return this;
        }
      };
      p.host = function(v2, build) {
        if (this._parts.urn) {
          return v2 === void 0 ? "" : this;
        }
        if (v2 === void 0) {
          return this._parts.hostname ? URI.buildHost(this._parts) : "";
        } else {
          var res = URI.parseHost(v2, this._parts);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v2 + '" contains characters other than [A-Z0-9.-]');
          }
          this.build(!build);
          return this;
        }
      };
      p.authority = function(v2, build) {
        if (this._parts.urn) {
          return v2 === void 0 ? "" : this;
        }
        if (v2 === void 0) {
          return this._parts.hostname ? URI.buildAuthority(this._parts) : "";
        } else {
          var res = URI.parseAuthority(v2, this._parts);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v2 + '" contains characters other than [A-Z0-9.-]');
          }
          this.build(!build);
          return this;
        }
      };
      p.userinfo = function(v2, build) {
        if (this._parts.urn) {
          return v2 === void 0 ? "" : this;
        }
        if (v2 === void 0) {
          var t = URI.buildUserinfo(this._parts);
          return t ? t.substring(0, t.length - 1) : t;
        } else {
          if (v2[v2.length - 1] !== "@") {
            v2 += "@";
          }
          URI.parseUserinfo(v2, this._parts);
          this.build(!build);
          return this;
        }
      };
      p.resource = function(v2, build) {
        var parts;
        if (v2 === void 0) {
          return this.path() + this.search() + this.hash();
        }
        parts = URI.parse(v2);
        this._parts.path = parts.path;
        this._parts.query = parts.query;
        this._parts.fragment = parts.fragment;
        this.build(!build);
        return this;
      };
      p.subdomain = function(v2, build) {
        if (this._parts.urn) {
          return v2 === void 0 ? "" : this;
        }
        if (v2 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var end = this._parts.hostname.length - this.domain().length - 1;
          return this._parts.hostname.substring(0, end) || "";
        } else {
          var e = this._parts.hostname.length - this.domain().length;
          var sub = this._parts.hostname.substring(0, e);
          var replace = new RegExp("^" + escapeRegEx(sub));
          if (v2 && v2.charAt(v2.length - 1) !== ".") {
            v2 += ".";
          }
          if (v2.indexOf(":") !== -1) {
            throw new TypeError("Domains cannot contain colons");
          }
          if (v2) {
            URI.ensureValidHostname(v2, this._parts.protocol);
          }
          this._parts.hostname = this._parts.hostname.replace(replace, v2);
          this.build(!build);
          return this;
        }
      };
      p.domain = function(v2, build) {
        if (this._parts.urn) {
          return v2 === void 0 ? "" : this;
        }
        if (typeof v2 === "boolean") {
          build = v2;
          v2 = void 0;
        }
        if (v2 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var t = this._parts.hostname.match(/\./g);
          if (t && t.length < 2) {
            return this._parts.hostname;
          }
          var end = this._parts.hostname.length - this.tld(build).length - 1;
          end = this._parts.hostname.lastIndexOf(".", end - 1) + 1;
          return this._parts.hostname.substring(end) || "";
        } else {
          if (!v2) {
            throw new TypeError("cannot set domain empty");
          }
          if (v2.indexOf(":") !== -1) {
            throw new TypeError("Domains cannot contain colons");
          }
          URI.ensureValidHostname(v2, this._parts.protocol);
          if (!this._parts.hostname || this.is("IP")) {
            this._parts.hostname = v2;
          } else {
            var replace = new RegExp(escapeRegEx(this.domain()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v2);
          }
          this.build(!build);
          return this;
        }
      };
      p.tld = function(v2, build) {
        if (this._parts.urn) {
          return v2 === void 0 ? "" : this;
        }
        if (typeof v2 === "boolean") {
          build = v2;
          v2 = void 0;
        }
        if (v2 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var pos = this._parts.hostname.lastIndexOf(".");
          var tld = this._parts.hostname.substring(pos + 1);
          if (build !== true && SLD && SLD.list[tld.toLowerCase()]) {
            return SLD.get(this._parts.hostname) || tld;
          }
          return tld;
        } else {
          var replace;
          if (!v2) {
            throw new TypeError("cannot set TLD empty");
          } else if (v2.match(/[^a-zA-Z0-9-]/)) {
            if (SLD && SLD.is(v2)) {
              replace = new RegExp(escapeRegEx(this.tld()) + "$");
              this._parts.hostname = this._parts.hostname.replace(replace, v2);
            } else {
              throw new TypeError('TLD "' + v2 + '" contains characters other than [A-Z0-9]');
            }
          } else if (!this._parts.hostname || this.is("IP")) {
            throw new ReferenceError("cannot set TLD on non-domain host");
          } else {
            replace = new RegExp(escapeRegEx(this.tld()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v2);
          }
          this.build(!build);
          return this;
        }
      };
      p.directory = function(v2, build) {
        if (this._parts.urn) {
          return v2 === void 0 ? "" : this;
        }
        if (v2 === void 0 || v2 === true) {
          if (!this._parts.path && !this._parts.hostname) {
            return "";
          }
          if (this._parts.path === "/") {
            return "/";
          }
          var end = this._parts.path.length - this.filename().length - 1;
          var res = this._parts.path.substring(0, end) || (this._parts.hostname ? "/" : "");
          return v2 ? URI.decodePath(res) : res;
        } else {
          var e = this._parts.path.length - this.filename().length;
          var directory = this._parts.path.substring(0, e);
          var replace = new RegExp("^" + escapeRegEx(directory));
          if (!this.is("relative")) {
            if (!v2) {
              v2 = "/";
            }
            if (v2.charAt(0) !== "/") {
              v2 = "/" + v2;
            }
          }
          if (v2 && v2.charAt(v2.length - 1) !== "/") {
            v2 += "/";
          }
          v2 = URI.recodePath(v2);
          this._parts.path = this._parts.path.replace(replace, v2);
          this.build(!build);
          return this;
        }
      };
      p.filename = function(v2, build) {
        if (this._parts.urn) {
          return v2 === void 0 ? "" : this;
        }
        if (typeof v2 !== "string") {
          if (!this._parts.path || this._parts.path === "/") {
            return "";
          }
          var pos = this._parts.path.lastIndexOf("/");
          var res = this._parts.path.substring(pos + 1);
          return v2 ? URI.decodePathSegment(res) : res;
        } else {
          var mutatedDirectory = false;
          if (v2.charAt(0) === "/") {
            v2 = v2.substring(1);
          }
          if (v2.match(/\.?\//)) {
            mutatedDirectory = true;
          }
          var replace = new RegExp(escapeRegEx(this.filename()) + "$");
          v2 = URI.recodePath(v2);
          this._parts.path = this._parts.path.replace(replace, v2);
          if (mutatedDirectory) {
            this.normalizePath(build);
          } else {
            this.build(!build);
          }
          return this;
        }
      };
      p.suffix = function(v2, build) {
        if (this._parts.urn) {
          return v2 === void 0 ? "" : this;
        }
        if (v2 === void 0 || v2 === true) {
          if (!this._parts.path || this._parts.path === "/") {
            return "";
          }
          var filename = this.filename();
          var pos = filename.lastIndexOf(".");
          var s, res;
          if (pos === -1) {
            return "";
          }
          s = filename.substring(pos + 1);
          res = /^[a-z0-9%]+$/i.test(s) ? s : "";
          return v2 ? URI.decodePathSegment(res) : res;
        } else {
          if (v2.charAt(0) === ".") {
            v2 = v2.substring(1);
          }
          var suffix = this.suffix();
          var replace;
          if (!suffix) {
            if (!v2) {
              return this;
            }
            this._parts.path += "." + URI.recodePath(v2);
          } else if (!v2) {
            replace = new RegExp(escapeRegEx("." + suffix) + "$");
          } else {
            replace = new RegExp(escapeRegEx(suffix) + "$");
          }
          if (replace) {
            v2 = URI.recodePath(v2);
            this._parts.path = this._parts.path.replace(replace, v2);
          }
          this.build(!build);
          return this;
        }
      };
      p.segment = function(segment, v2, build) {
        var separator = this._parts.urn ? ":" : "/";
        var path = this.path();
        var absolute = path.substring(0, 1) === "/";
        var segments = path.split(separator);
        if (segment !== void 0 && typeof segment !== "number") {
          build = v2;
          v2 = segment;
          segment = void 0;
        }
        if (segment !== void 0 && typeof segment !== "number") {
          throw new Error('Bad segment "' + segment + '", must be 0-based integer');
        }
        if (absolute) {
          segments.shift();
        }
        if (segment < 0) {
          segment = Math.max(segments.length + segment, 0);
        }
        if (v2 === void 0) {
          return segment === void 0 ? segments : segments[segment];
        } else if (segment === null || segments[segment] === void 0) {
          if (isArray(v2)) {
            segments = [];
            for (var i = 0, l = v2.length; i < l; i++) {
              if (!v2[i].length && (!segments.length || !segments[segments.length - 1].length)) {
                continue;
              }
              if (segments.length && !segments[segments.length - 1].length) {
                segments.pop();
              }
              segments.push(trimSlashes(v2[i]));
            }
          } else if (v2 || typeof v2 === "string") {
            v2 = trimSlashes(v2);
            if (segments[segments.length - 1] === "") {
              segments[segments.length - 1] = v2;
            } else {
              segments.push(v2);
            }
          }
        } else {
          if (v2) {
            segments[segment] = trimSlashes(v2);
          } else {
            segments.splice(segment, 1);
          }
        }
        if (absolute) {
          segments.unshift("");
        }
        return this.path(segments.join(separator), build);
      };
      p.segmentCoded = function(segment, v2, build) {
        var segments, i, l;
        if (typeof segment !== "number") {
          build = v2;
          v2 = segment;
          segment = void 0;
        }
        if (v2 === void 0) {
          segments = this.segment(segment, v2, build);
          if (!isArray(segments)) {
            segments = segments !== void 0 ? URI.decode(segments) : void 0;
          } else {
            for (i = 0, l = segments.length; i < l; i++) {
              segments[i] = URI.decode(segments[i]);
            }
          }
          return segments;
        }
        if (!isArray(v2)) {
          v2 = typeof v2 === "string" || v2 instanceof String ? URI.encode(v2) : v2;
        } else {
          for (i = 0, l = v2.length; i < l; i++) {
            v2[i] = URI.encode(v2[i]);
          }
        }
        return this.segment(segment, v2, build);
      };
      var q = p.query;
      p.query = function(v2, build) {
        if (v2 === true) {
          return URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        } else if (typeof v2 === "function") {
          var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
          var result = v2.call(this, data);
          this._parts.query = URI.buildQuery(result || data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          this.build(!build);
          return this;
        } else if (v2 !== void 0 && typeof v2 !== "string") {
          this._parts.query = URI.buildQuery(v2, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          this.build(!build);
          return this;
        } else {
          return q.call(this, v2, build);
        }
      };
      p.setQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        if (typeof name === "string" || name instanceof String) {
          data[name] = value !== void 0 ? value : null;
        } else if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              data[key] = name[key];
            }
          }
        } else {
          throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
        }
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.addQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        URI.addQuery(data, name, value === void 0 ? null : value);
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.removeQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        URI.removeQuery(data, name, value);
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.hasQuery = function(name, value, withinArray) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        return URI.hasQuery(data, name, value, withinArray);
      };
      p.setSearch = p.setQuery;
      p.addSearch = p.addQuery;
      p.removeSearch = p.removeQuery;
      p.hasSearch = p.hasQuery;
      p.normalize = function() {
        if (this._parts.urn) {
          return this.normalizeProtocol(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
        }
        return this.normalizeProtocol(false).normalizeHostname(false).normalizePort(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
      };
      p.normalizeProtocol = function(build) {
        if (typeof this._parts.protocol === "string") {
          this._parts.protocol = this._parts.protocol.toLowerCase();
          this.build(!build);
        }
        return this;
      };
      p.normalizeHostname = function(build) {
        if (this._parts.hostname) {
          if (this.is("IDN") && punycode) {
            this._parts.hostname = punycode.toASCII(this._parts.hostname);
          } else if (this.is("IPv6") && IPv6) {
            this._parts.hostname = IPv6.best(this._parts.hostname);
          }
          this._parts.hostname = this._parts.hostname.toLowerCase();
          this.build(!build);
        }
        return this;
      };
      p.normalizePort = function(build) {
        if (typeof this._parts.protocol === "string" && this._parts.port === URI.defaultPorts[this._parts.protocol]) {
          this._parts.port = null;
          this.build(!build);
        }
        return this;
      };
      p.normalizePath = function(build) {
        var _path = this._parts.path;
        if (!_path) {
          return this;
        }
        if (this._parts.urn) {
          this._parts.path = URI.recodeUrnPath(this._parts.path);
          this.build(!build);
          return this;
        }
        if (this._parts.path === "/") {
          return this;
        }
        _path = URI.recodePath(_path);
        var _was_relative;
        var _leadingParents = "";
        var _parent, _pos;
        if (_path.charAt(0) !== "/") {
          _was_relative = true;
          _path = "/" + _path;
        }
        if (_path.slice(-3) === "/.." || _path.slice(-2) === "/.") {
          _path += "/";
        }
        _path = _path.replace(/(\/(\.\/)+)|(\/\.$)/g, "/").replace(/\/{2,}/g, "/");
        if (_was_relative) {
          _leadingParents = _path.substring(1).match(/^(\.\.\/)+/) || "";
          if (_leadingParents) {
            _leadingParents = _leadingParents[0];
          }
        }
        while (true) {
          _parent = _path.search(/\/\.\.(\/|$)/);
          if (_parent === -1) {
            break;
          } else if (_parent === 0) {
            _path = _path.substring(3);
            continue;
          }
          _pos = _path.substring(0, _parent).lastIndexOf("/");
          if (_pos === -1) {
            _pos = _parent;
          }
          _path = _path.substring(0, _pos) + _path.substring(_parent + 3);
        }
        if (_was_relative && this.is("relative")) {
          _path = _leadingParents + _path.substring(1);
        }
        this._parts.path = _path;
        this.build(!build);
        return this;
      };
      p.normalizePathname = p.normalizePath;
      p.normalizeQuery = function(build) {
        if (typeof this._parts.query === "string") {
          if (!this._parts.query.length) {
            this._parts.query = null;
          } else {
            this.query(URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace));
          }
          this.build(!build);
        }
        return this;
      };
      p.normalizeFragment = function(build) {
        if (!this._parts.fragment) {
          this._parts.fragment = null;
          this.build(!build);
        }
        return this;
      };
      p.normalizeSearch = p.normalizeQuery;
      p.normalizeHash = p.normalizeFragment;
      p.iso8859 = function() {
        var e = URI.encode;
        var d = URI.decode;
        URI.encode = escape;
        URI.decode = decodeURIComponent;
        try {
          this.normalize();
        } finally {
          URI.encode = e;
          URI.decode = d;
        }
        return this;
      };
      p.unicode = function() {
        var e = URI.encode;
        var d = URI.decode;
        URI.encode = strictEncodeURIComponent;
        URI.decode = unescape;
        try {
          this.normalize();
        } finally {
          URI.encode = e;
          URI.decode = d;
        }
        return this;
      };
      p.readable = function() {
        var uri = this.clone();
        uri.username("").password("").normalize();
        var t = "";
        if (uri._parts.protocol) {
          t += uri._parts.protocol + "://";
        }
        if (uri._parts.hostname) {
          if (uri.is("punycode") && punycode) {
            t += punycode.toUnicode(uri._parts.hostname);
            if (uri._parts.port) {
              t += ":" + uri._parts.port;
            }
          } else {
            t += uri.host();
          }
        }
        if (uri._parts.hostname && uri._parts.path && uri._parts.path.charAt(0) !== "/") {
          t += "/";
        }
        t += uri.path(true);
        if (uri._parts.query) {
          var q2 = "";
          for (var i = 0, qp = uri._parts.query.split("&"), l = qp.length; i < l; i++) {
            var kv = (qp[i] || "").split("=");
            q2 += "&" + URI.decodeQuery(kv[0], this._parts.escapeQuerySpace).replace(/&/g, "%26");
            if (kv[1] !== void 0) {
              q2 += "=" + URI.decodeQuery(kv[1], this._parts.escapeQuerySpace).replace(/&/g, "%26");
            }
          }
          t += "?" + q2.substring(1);
        }
        t += URI.decodeQuery(uri.hash(), true);
        return t;
      };
      p.absoluteTo = function(base) {
        var resolved = this.clone();
        var properties = ["protocol", "username", "password", "hostname", "port"];
        var basedir, i, p2;
        if (this._parts.urn) {
          throw new Error("URNs do not have any generally defined hierarchical components");
        }
        if (!(base instanceof URI)) {
          base = new URI(base);
        }
        if (resolved._parts.protocol) {
          return resolved;
        } else {
          resolved._parts.protocol = base._parts.protocol;
        }
        if (this._parts.hostname) {
          return resolved;
        }
        for (i = 0; p2 = properties[i]; i++) {
          resolved._parts[p2] = base._parts[p2];
        }
        if (!resolved._parts.path) {
          resolved._parts.path = base._parts.path;
          if (!resolved._parts.query) {
            resolved._parts.query = base._parts.query;
          }
        } else {
          if (resolved._parts.path.substring(-2) === "..") {
            resolved._parts.path += "/";
          }
          if (resolved.path().charAt(0) !== "/") {
            basedir = base.directory();
            basedir = basedir ? basedir : base.path().indexOf("/") === 0 ? "/" : "";
            resolved._parts.path = (basedir ? basedir + "/" : "") + resolved._parts.path;
            resolved.normalizePath();
          }
        }
        resolved.build();
        return resolved;
      };
      p.relativeTo = function(base) {
        var relative = this.clone().normalize();
        var relativeParts, baseParts, common, relativePath, basePath;
        if (relative._parts.urn) {
          throw new Error("URNs do not have any generally defined hierarchical components");
        }
        base = new URI(base).normalize();
        relativeParts = relative._parts;
        baseParts = base._parts;
        relativePath = relative.path();
        basePath = base.path();
        if (relativePath.charAt(0) !== "/") {
          throw new Error("URI is already relative");
        }
        if (basePath.charAt(0) !== "/") {
          throw new Error("Cannot calculate a URI relative to another relative URI");
        }
        if (relativeParts.protocol === baseParts.protocol) {
          relativeParts.protocol = null;
        }
        if (relativeParts.username !== baseParts.username || relativeParts.password !== baseParts.password) {
          return relative.build();
        }
        if (relativeParts.protocol !== null || relativeParts.username !== null || relativeParts.password !== null) {
          return relative.build();
        }
        if (relativeParts.hostname === baseParts.hostname && relativeParts.port === baseParts.port) {
          relativeParts.hostname = null;
          relativeParts.port = null;
        } else {
          return relative.build();
        }
        if (relativePath === basePath) {
          relativeParts.path = "";
          return relative.build();
        }
        common = URI.commonPath(relativePath, basePath);
        if (!common) {
          return relative.build();
        }
        var parents = baseParts.path.substring(common.length).replace(/[^\/]*$/, "").replace(/.*?\//g, "../");
        relativeParts.path = parents + relativeParts.path.substring(common.length) || "./";
        return relative.build();
      };
      p.equals = function(uri) {
        var one = this.clone();
        var two = new URI(uri);
        var one_map = {};
        var two_map = {};
        var checked = {};
        var one_query, two_query, key;
        one.normalize();
        two.normalize();
        if (one.toString() === two.toString()) {
          return true;
        }
        one_query = one.query();
        two_query = two.query();
        one.query("");
        two.query("");
        if (one.toString() !== two.toString()) {
          return false;
        }
        if (one_query.length !== two_query.length) {
          return false;
        }
        one_map = URI.parseQuery(one_query, this._parts.escapeQuerySpace);
        two_map = URI.parseQuery(two_query, this._parts.escapeQuerySpace);
        for (key in one_map) {
          if (hasOwn.call(one_map, key)) {
            if (!isArray(one_map[key])) {
              if (one_map[key] !== two_map[key]) {
                return false;
              }
            } else if (!arraysEqual(one_map[key], two_map[key])) {
              return false;
            }
            checked[key] = true;
          }
        }
        for (key in two_map) {
          if (hasOwn.call(two_map, key)) {
            if (!checked[key]) {
              return false;
            }
          }
        }
        return true;
      };
      p.preventInvalidHostname = function(v2) {
        this._parts.preventInvalidHostname = !!v2;
        return this;
      };
      p.duplicateQueryParameters = function(v2) {
        this._parts.duplicateQueryParameters = !!v2;
        return this;
      };
      p.escapeQuerySpace = function(v2) {
        this._parts.escapeQuerySpace = !!v2;
        return this;
      };
      return URI;
    });
  }
});

// packages/engine/Specs/Renderer/AutomaticUniformSpec.js
var import__ = __toESM(require_Cesium(), 1);

// Specs/createCamera.js
var import_engine = __toESM(require_Cesium(), 1);
function MockScene(canvas) {
  canvas = (0, import_engine.defaultValue)(canvas, {
    clientWidth: 512,
    clientHeight: 384
  });
  this.canvas = canvas;
  this.drawingBufferWidth = canvas.clientWidth * 2;
  this.drawingBufferHeight = canvas.clientHeight * 2;
  this.mapProjection = new import_engine.GeographicProjection();
}
function createCamera(options) {
  options = (0, import_engine.defaultValue)(options, import_engine.defaultValue.EMPTY_OBJECT);
  const scene2 = new MockScene(options.canvas);
  const camera = new import_engine.Camera(scene2);
  camera.frustum.near = (0, import_engine.defaultValue)(options.near, 0.01);
  camera.frustum.far = (0, import_engine.defaultValue)(options.far, 10);
  const offset = (0, import_engine.defaultValue)(options.offset, new import_engine.Cartesian3(-1, 0, 0));
  if ((0, import_engine.defined)(options.target)) {
    camera.lookAt(options.target, offset);
  } else if ((0, import_engine.defined)(options.transform)) {
    camera.lookAtTransform(options.transform, offset);
  } else {
    camera.lookAtTransform(import_engine.Matrix4.IDENTITY, offset);
  }
  return camera;
}
var createCamera_default = createCamera;

// Specs/createContext.js
var import_engine5 = __toESM(require_Cesium(), 1);

// Specs/createCanvas.js
var import_engine2 = __toESM(require_Cesium(), 1);
var canvasCount = 0;
function createCanvas(width, height) {
  width = (0, import_engine2.defaultValue)(width, 1);
  height = (0, import_engine2.defaultValue)(height, 1);
  const canvas = document.createElement("canvas");
  canvas.id = `canvas${canvasCount++}`;
  canvas.setAttribute("width", width);
  canvas.setAttribute("clientWidth", width);
  canvas.setAttribute("height", height);
  canvas.setAttribute("clientHeight", height);
  canvas.innerHTML = "To view this web page, upgrade your browser; it does not support the HTML5 canvas element.";
  document.body.appendChild(canvas);
  return canvas;
}
var createCanvas_default = createCanvas;

// Specs/createFrameState.js
var import_engine3 = __toESM(require_Cesium(), 1);
function createFrameState(context, camera, frameNumber, time2) {
  const frameState2 = new import_engine3.FrameState(
    context,
    new import_engine3.CreditDisplay(
      document.createElement("div"),
      void 0,
      document.createElement("div")
    ),
    new import_engine3.JobScheduler()
  );
  const projection = new import_engine3.GeographicProjection();
  frameState2.mapProjection = projection;
  frameState2.frameNumber = (0, import_engine3.defaultValue)(frameNumber, 1);
  frameState2.time = (0, import_engine3.defaultValue)(
    time2,
    import_engine3.JulianDate.fromDate(/* @__PURE__ */ new Date("January 1, 2011 12:00:00 EST"))
  );
  camera = (0, import_engine3.defaultValue)(
    camera,
    new import_engine3.Camera({
      drawingBufferWidth: 1,
      drawingBufferHeight: 1,
      mapProjection: projection
    })
  );
  frameState2.camera = camera;
  frameState2.cullingVolume = camera.frustum.computeCullingVolume(
    camera.position,
    camera.direction,
    camera.up
  );
  frameState2.terrainExaggeration = 1;
  frameState2.terrainExaggerationRelativeHeight = 0;
  frameState2.passes.render = true;
  frameState2.passes.pick = false;
  frameState2.minimumDisableDepthTestDistance = 0;
  return frameState2;
}
var createFrameState_default = createFrameState;

// Specs/getWebGLStub.js
var import_engine4 = __toESM(require_Cesium(), 1);
function getWebGLStub(canvas, options) {
  const stub = (0, import_engine4.clone)(import_engine4.WebGLConstants);
  stub.canvas = canvas;
  stub.drawingBufferWidth = Math.max(canvas.width, 1);
  stub.drawingBufferHeight = Math.max(canvas.height, 1);
  stub.activeTexture = noop;
  stub.attachShader = noop;
  stub.bindAttribLocation = noop;
  stub.bindBuffer = noop;
  stub.bindFramebuffer = noop;
  stub.bindRenderbuffer = noop;
  stub.bindTexture = noop;
  stub.blendColor = noop;
  stub.blendEquation = noop;
  stub.blendEquationSeparate = noop;
  stub.blendFunc = noop;
  stub.blendFuncSeparate = noop;
  stub.bufferData = noop;
  stub.bufferSubData = noop;
  stub.checkFramebufferStatus = checkFramebufferStatusStub;
  stub.clear = noop;
  stub.clearColor = noop;
  stub.clearDepth = noop;
  stub.clearStencil = noop;
  stub.colorMask = noop;
  stub.compileShader = noop;
  stub.compressedTexImage2D = noop;
  stub.compressedTexSubImage2D = noop;
  stub.copyTexImage2D = noop;
  stub.copyTexSubImage2D = noop;
  stub.createBuffer = createStub;
  stub.createFramebuffer = createStub;
  stub.createProgram = createStub;
  stub.createRenderbuffer = createStub;
  stub.createShader = createStub;
  stub.createTexture = createStub;
  stub.cullFace = noop;
  stub.deleteBuffer = noop;
  stub.deleteFramebuffer = noop;
  stub.deleteProgram = noop;
  stub.deleteRenderbuffer = noop;
  stub.deleteShader = noop;
  stub.deleteTexture = noop;
  stub.depthFunc = noop;
  stub.depthMask = noop;
  stub.depthRange = noop;
  stub.detachShader = noop;
  stub.disable = noop;
  stub.disableVertexAttribArray = noop;
  stub.drawArrays = noop;
  stub.drawElements = noop;
  stub.enable = noop;
  stub.enableVertexAttribArray = noop;
  stub.finish = noop;
  stub.flush = noop;
  stub.framebufferRenderbuffer = noop;
  stub.framebufferTexture2D = noop;
  stub.frontFace = noop;
  stub.generateMipmap = noop;
  stub.getActiveAttrib = getStub;
  stub.getActiveUniform = getStub;
  stub.getAttachedShaders = getStubWarning;
  stub.getAttribLocation = getStub;
  stub.getBufferParameter = getStubWarning;
  stub.getContextAttributes = getContextAttributesStub(options);
  stub.getError = getErrorStub;
  stub.getExtension = getExtensionStub;
  stub.getFramebufferAttachmentParameter = getStubWarning;
  stub.getParameter = getParameterStub(options);
  stub.getProgramParameter = getProgramParameterStub;
  stub.getProgramInfoLog = getStub;
  stub.getRenderbufferParameter = getStubWarning;
  stub.getShaderParameter = getShaderParameterStub;
  stub.getShaderInfoLog = getStub;
  stub.getShaderPrecisionFormat = getShaderPrecisionStub;
  stub.getShaderSource = getStubWarning;
  stub.getSupportedExtensions = getStubWarning;
  stub.getTexParameter = getStubWarning;
  stub.getUniform = getStub;
  stub.getUniformLocation = getStub;
  stub.getVertexAttrib = getStubWarning;
  stub.getVertexAttribOffset = getStubWarning;
  stub.hint = noop;
  stub.isBuffer = getStubWarning;
  stub.isContextLost = getStubWarning;
  stub.isEnabled = getStubWarning;
  stub.isFramebuffer = getStubWarning;
  stub.isProgram = getStubWarning;
  stub.isRenderbuffer = getStubWarning;
  stub.isShader = getStubWarning;
  stub.isTexture = getStubWarning;
  stub.lineWidth = noop;
  stub.linkProgram = noop;
  stub.pixelStorei = noop;
  stub.polygonOffset = noop;
  stub.readPixels = readPixelsStub;
  stub.renderbufferStorage = noop;
  stub.sampleCoverage = noop;
  stub.scissor = noop;
  stub.shaderSource = noop;
  stub.stencilFunc = noop;
  stub.stencilFuncSeparate = noop;
  stub.stencilMask = noop;
  stub.stencilMaskSeparate = noop;
  stub.stencilOp = noop;
  stub.stencilOpSeparate = noop;
  stub.texParameterf = noop;
  stub.texParameteri = noop;
  stub.texImage2D = noop;
  stub.texSubImage2D = noop;
  stub.uniform1f = noop;
  stub.uniform1fv = noop;
  stub.uniform1i = noop;
  stub.uniform1iv = noop;
  stub.uniform2f = noop;
  stub.uniform2fv = noop;
  stub.uniform2i = noop;
  stub.uniform2iv = noop;
  stub.uniform3f = noop;
  stub.uniform3fv = noop;
  stub.uniform3i = noop;
  stub.uniform3iv = noop;
  stub.uniform4f = noop;
  stub.uniform4fv = noop;
  stub.uniform4i = noop;
  stub.uniform4iv = noop;
  stub.uniformMatrix2fv = noop;
  stub.uniformMatrix3fv = noop;
  stub.uniformMatrix4fv = noop;
  stub.useProgram = noop;
  stub.validateProgram = noop;
  stub.vertexAttrib1f = noop;
  stub.vertexAttrib1fv = noop;
  stub.vertexAttrib2f = noop;
  stub.vertexAttrib2fv = noop;
  stub.vertexAttrib3f = noop;
  stub.vertexAttrib3fv = noop;
  stub.vertexAttrib4f = noop;
  stub.vertexAttrib4fv = noop;
  stub.vertexAttribPointer = noop;
  stub.viewport = noop;
  return stub;
}
var instancedArraysStub = {
  drawElementsInstancedANGLE: noop,
  drawArraysInstancedANGLE: noop,
  vertexAttribDivisorANGLE: noop
};
function noop() {
}
function createStub() {
  return {};
}
function getStub() {
  return {};
}
function getStubWarning() {
  throw new import_engine4.DeveloperError(
    "A stub for this get/is function is not defined.  Can it use getStub() or does it need a new one?"
  );
}
function checkFramebufferStatusStub(target) {
  return import_engine4.WebGLConstants.FRAMEBUFFER_COMPLETE;
}
function getContextAttributesStub(options) {
  const contextAttributes = {
    alpha: (0, import_engine4.defaultValue)(options.alpha, true),
    depth: (0, import_engine4.defaultValue)(options.depth, true),
    stencil: (0, import_engine4.defaultValue)(options.stencil, false),
    antialias: (0, import_engine4.defaultValue)(options.antialias, true),
    premultipliedAlpha: (0, import_engine4.defaultValue)(options.premultipliedAlpha, true),
    preserveDrawingBuffer: (0, import_engine4.defaultValue)(options.preserveDrawingBuffer, false),
    powerPreference: (0, import_engine4.defaultValue)(options.powerPreference, false),
    failIfMajorPerformanceCaveat: (0, import_engine4.defaultValue)(
      options.failIfMajorPerformanceCaveat,
      false
    )
  };
  return function() {
    return contextAttributes;
  };
}
function getErrorStub() {
  return import_engine4.WebGLConstants.NO_ERROR;
}
function getExtensionStub(name) {
  if (name === "ANGLE_instanced_arrays") {
    return instancedArraysStub;
  }
  if (name === "OES_texture_float") {
    return {};
  }
  return null;
}
function getParameterStub(options) {
  const parameterStubValues = {};
  parameterStubValues[import_engine4.WebGLConstants.STENCIL_BITS] = options.stencil ? 8 : 0;
  parameterStubValues[import_engine4.WebGLConstants.MAX_COMBINED_TEXTURE_IMAGE_UNITS] = 32;
  parameterStubValues[import_engine4.WebGLConstants.MAX_CUBE_MAP_TEXTURE_SIZE] = 16384;
  parameterStubValues[import_engine4.WebGLConstants.MAX_FRAGMENT_UNIFORM_VECTORS] = 1024;
  parameterStubValues[import_engine4.WebGLConstants.MAX_TEXTURE_IMAGE_UNITS] = 16;
  parameterStubValues[import_engine4.WebGLConstants.MAX_RENDERBUFFER_SIZE] = 16384;
  parameterStubValues[import_engine4.WebGLConstants.MAX_TEXTURE_SIZE] = 16384;
  parameterStubValues[import_engine4.WebGLConstants.MAX_VARYING_VECTORS] = 30;
  parameterStubValues[import_engine4.WebGLConstants.MAX_VERTEX_ATTRIBS] = 16;
  parameterStubValues[import_engine4.WebGLConstants.MAX_VERTEX_TEXTURE_IMAGE_UNITS] = 16;
  parameterStubValues[import_engine4.WebGLConstants.MAX_VERTEX_UNIFORM_VECTORS] = 4096;
  parameterStubValues[import_engine4.WebGLConstants.ALIASED_LINE_WIDTH_RANGE] = [1, 1];
  parameterStubValues[import_engine4.WebGLConstants.ALIASED_POINT_SIZE_RANGE] = [1, 1024];
  parameterStubValues[import_engine4.WebGLConstants.MAX_VIEWPORT_DIMS] = [16384, 16384];
  parameterStubValues[import_engine4.WebGLConstants.MAX_TEXTURE_MAX_ANISOTROPY_EXT] = 16;
  parameterStubValues[import_engine4.WebGLConstants.MAX_DRAW_BUFFERS] = 8;
  parameterStubValues[import_engine4.WebGLConstants.MAX_COLOR_ATTACHMENTS] = 8;
  parameterStubValues[import_engine4.WebGLConstants.MAX_SAMPLES] = 8;
  return function(pname) {
    const value = parameterStubValues[pname];
    if (!(0, import_engine4.defined)(value)) {
      throw new import_engine4.DeveloperError(
        `A WebGL parameter stub for ${pname} is not defined. Add it.`
      );
    }
    return value;
  };
}
function getProgramParameterStub(program, pname) {
  if (pname === import_engine4.WebGLConstants.LINK_STATUS || pname === import_engine4.WebGLConstants.VALIDATE_STATUS) {
    return true;
  }
  if (pname === import_engine4.WebGLConstants.ACTIVE_UNIFORMS || pname === import_engine4.WebGLConstants.ACTIVE_ATTRIBUTES) {
    return 0;
  }
  throw new import_engine4.DeveloperError(
    `A WebGL parameter stub for ${pname} is not defined. Add it.`
  );
}
function getShaderParameterStub(shader, pname) {
  if (pname !== import_engine4.WebGLConstants.COMPILE_STATUS) {
    throw new import_engine4.DeveloperError(
      `A WebGL parameter stub for ${pname} is not defined. Add it.`
    );
  }
  return true;
}
function getShaderPrecisionStub(shadertype, precisiontype) {
  if (shadertype !== import_engine4.WebGLConstants.FRAGMENT_SHADER) {
    throw new import_engine4.DeveloperError(
      "getShaderPrecision only has a stub for FRAGMENT_SHADER. Update it."
    );
  }
  if (precisiontype !== import_engine4.WebGLConstants.HIGH_FLOAT && precisiontype !== import_engine4.WebGLConstants.HIGH_INT) {
    throw new import_engine4.DeveloperError(
      "getShaderPrecision only has a stub for HIGH_FLOAT and HIGH_INT. Update it."
    );
  }
  if (precisiontype === import_engine4.WebGLConstants.HIGH_FLOAT) {
    return {
      rangeMin: 127,
      rangeMax: 127,
      precision: 23
    };
  }
  return {
    rangeMin: 31,
    rangeMax: 30,
    precision: 0
  };
}
function readPixelsStub(x, y, width, height, format, type, pixels) {
  return [0, 0, 0, 0];
}
var getWebGLStub_default = getWebGLStub;

// Specs/createContext.js
function createContext(options, canvasWidth, canvasHeight) {
  options = (0, import_engine5.clone)((0, import_engine5.defaultValue)(options, {}));
  options.webgl = (0, import_engine5.clone)((0, import_engine5.defaultValue)(options.webgl, {}));
  options.webgl.antialias = (0, import_engine5.defaultValue)(options.webgl.antialias, false);
  if (!!window.webglStub) {
    options.getWebGLStub = getWebGLStub_default;
  }
  const canvas = createCanvas_default(canvasWidth, canvasHeight);
  const context = new import_engine5.Context(canvas, options);
  if (!!window.webglValidation) {
    context.validateShaderProgram = true;
    context.validateFramebuffer = true;
    context.logShaderCompilation = true;
    context.throwOnWebGLError = true;
  }
  const us = context.uniformState;
  us.update(createFrameState_default(context));
  context.destroyForSpecs = function() {
    document.body.removeChild(context.canvas);
    return context.destroy();
  };
  return context;
}
var createContext_default = createContext;

// packages/engine/Specs/Renderer/AutomaticUniformSpec.js
describe(
  "Renderer/AutomaticUniforms",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    function createMockCamera(view, projection, infiniteProjection, position, direction, right, up) {
      return {
        viewMatrix: (0, import__.defaultValue)(view, import__.Matrix4.clone(import__.Matrix4.IDENTITY)),
        inverseViewMatrix: import__.Matrix4.inverseTransformation(
          (0, import__.defaultValue)(view, import__.Matrix4.clone(import__.Matrix4.IDENTITY)),
          new import__.Matrix4()
        ),
        frustum: {
          near: 1,
          far: 1e3,
          top: 2,
          bottom: -2,
          left: -1,
          right: 1,
          projectionMatrix: (0, import__.defaultValue)(
            projection,
            import__.Matrix4.clone(import__.Matrix4.IDENTITY)
          ),
          infiniteProjectionMatrix: (0, import__.defaultValue)(
            infiniteProjection,
            import__.Matrix4.clone(import__.Matrix4.IDENTITY)
          ),
          computeCullingVolume: function() {
            return void 0;
          },
          getPixelSize: function() {
            return new import__.Cartesian2(1, 0.1);
          }
        },
        position: (0, import__.defaultValue)(position, import__.Cartesian3.clone(import__.Cartesian3.ZERO)),
        positionWC: (0, import__.defaultValue)(position, import__.Cartesian3.clone(import__.Cartesian3.ZERO)),
        directionWC: (0, import__.defaultValue)(
          direction,
          import__.Cartesian3.clone(import__.Cartesian3.UNIT_Z)
        ),
        rightWC: (0, import__.defaultValue)(right, import__.Cartesian3.clone(import__.Cartesian3.UNIT_X)),
        upWC: (0, import__.defaultValue)(up, import__.Cartesian3.clone(import__.Cartesian3.UNIT_Y)),
        positionCartographic: new import__.Cartographic(0, 0, 10)
      };
    }
    it("can declare automatic uniforms", function() {
      const fs = "void main() {   out_FragColor = vec4((czm_viewport.x == 0.0) && (czm_viewport.y == 0.0) && (czm_viewport.z == 1.0) && (czm_viewport.w == 1.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_viewport", function() {
      const fs = "void main() {   out_FragColor = vec4((czm_viewport.x == 0.0) && (czm_viewport.y == 0.0) && (czm_viewport.z == 1.0) && (czm_viewport.w == 1.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_viewportOrthographic", function() {
      const fs = "void main() {   bool b0 = (czm_viewportOrthographic[0][0] != 0.0) && (czm_viewportOrthographic[1][0] == 0.0) && (czm_viewportOrthographic[2][0] == 0.0) && (czm_viewportOrthographic[3][0] != 0.0);   bool b1 = (czm_viewportOrthographic[0][1] == 0.0) && (czm_viewportOrthographic[1][1] != 0.0) && (czm_viewportOrthographic[2][1] == 0.0) && (czm_viewportOrthographic[3][1] != 0.0);   bool b2 = (czm_viewportOrthographic[0][2] == 0.0) && (czm_viewportOrthographic[1][2] == 0.0) && (czm_viewportOrthographic[2][2] != 0.0) && (czm_viewportOrthographic[3][2] != 0.0);   bool b3 = (czm_viewportOrthographic[0][3] == 0.0) && (czm_viewportOrthographic[1][3] == 0.0) && (czm_viewportOrthographic[2][3] == 0.0) && (czm_viewportOrthographic[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_viewportTransformation", function() {
      const fs = "void main() {   bool b0 = (czm_viewportTransformation[0][0] != 0.0) && (czm_viewportTransformation[1][0] == 0.0) && (czm_viewportTransformation[2][0] == 0.0) && (czm_viewportTransformation[3][0] != 0.0);   bool b1 = (czm_viewportTransformation[0][1] == 0.0) && (czm_viewportTransformation[1][1] != 0.0) && (czm_viewportTransformation[2][1] == 0.0) && (czm_viewportTransformation[3][1] != 0.0);   bool b2 = (czm_viewportTransformation[0][2] == 0.0) && (czm_viewportTransformation[1][2] == 0.0) && (czm_viewportTransformation[2][2] != 0.0) && (czm_viewportTransformation[3][2] != 0.0);   bool b3 = (czm_viewportTransformation[0][3] == 0.0) && (czm_viewportTransformation[1][3] == 0.0) && (czm_viewportTransformation[2][3] == 0.0) && (czm_viewportTransformation[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_globeDepthTexture", function() {
      context.uniformState.globeDepthTexture = new import__.Texture({
        context,
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([255, 255, 255, 255])
        }
      });
      const fs = "void main() {   out_FragColor = vec4(texture(czm_globeDepthTexture, vec2(0.5, 0.5)).r == 1.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_model", function() {
      const fs = "void main() {   bool b0 = (czm_model[0][0] ==  1.0) && (czm_model[1][0] ==  2.0) && (czm_model[2][0] ==  3.0) && (czm_model[3][0] ==  4.0);   bool b1 = (czm_model[0][1] ==  5.0) && (czm_model[1][1] ==  6.0) && (czm_model[2][1] ==  7.0) && (czm_model[3][1] ==  8.0);   bool b2 = (czm_model[0][2] ==  9.0) && (czm_model[1][2] == 10.0) && (czm_model[2][2] == 11.0) && (czm_model[3][2] == 12.0);   bool b3 = (czm_model[0][3] == 13.0) && (czm_model[1][3] == 14.0) && (czm_model[2][3] == 15.0) && (czm_model[3][3] == 16.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        1,
        2,
        3,
        4,
        5,
        6,
        7,
        8,
        9,
        10,
        11,
        12,
        13,
        14,
        15,
        16
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_inverseModel", function() {
      const fs = "void main() {   bool b0 = (czm_inverseModel[0][0] ==  0.0) && (czm_inverseModel[1][0] == 1.0) && (czm_inverseModel[2][0] == 0.0) && (czm_inverseModel[3][0] == -2.0);   bool b1 = (czm_inverseModel[0][1] == -1.0) && (czm_inverseModel[1][1] == 0.0) && (czm_inverseModel[2][1] == 0.0) && (czm_inverseModel[3][1] ==  1.0);   bool b2 = (czm_inverseModel[0][2] ==  0.0) && (czm_inverseModel[1][2] == 0.0) && (czm_inverseModel[2][2] == 1.0) && (czm_inverseModel[3][2] ==  0.0);   bool b3 = (czm_inverseModel[0][3] ==  0.0) && (czm_inverseModel[1][3] == 0.0) && (czm_inverseModel[2][3] == 0.0) && (czm_inverseModel[3][3] ==  1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        0,
        -1,
        0,
        1,
        1,
        0,
        0,
        2,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_view", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              9,
              10,
              11,
              12,
              13,
              14,
              15,
              16
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_view[0][0] ==  1.0) && (czm_view[1][0] ==  2.0) && (czm_view[2][0] ==  3.0) && (czm_view[3][0] ==  4.0);   bool b1 = (czm_view[0][1] ==  5.0) && (czm_view[1][1] ==  6.0) && (czm_view[2][1] ==  7.0) && (czm_view[3][1] ==  8.0);   bool b2 = (czm_view[0][2] ==  9.0) && (czm_view[1][2] == 10.0) && (czm_view[2][2] == 11.0) && (czm_view[3][2] == 12.0);   bool b3 = (czm_view[0][3] == 13.0) && (czm_view[1][3] == 14.0) && (czm_view[2][3] == 15.0) && (czm_view[3][3] == 16.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_view3D", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              9,
              10,
              11,
              12,
              13,
              14,
              15,
              16
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_view3D[0][0] ==  1.0) && (czm_view3D[1][0] ==  2.0) && (czm_view3D[2][0] ==  3.0) && (czm_view3D[3][0] ==  4.0);   bool b1 = (czm_view3D[0][1] ==  5.0) && (czm_view3D[1][1] ==  6.0) && (czm_view3D[2][1] ==  7.0) && (czm_view3D[3][1] ==  8.0);   bool b2 = (czm_view3D[0][2] ==  9.0) && (czm_view3D[1][2] == 10.0) && (czm_view3D[2][2] == 11.0) && (czm_view3D[3][2] == 12.0);   bool b3 = (czm_view3D[0][3] == 13.0) && (czm_view3D[1][3] == 14.0) && (czm_view3D[2][3] == 15.0) && (czm_view3D[3][3] == 16.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_viewRotation", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              9,
              10,
              11,
              12,
              13,
              14,
              15,
              16
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_viewRotation[0][0] ==  1.0) && (czm_viewRotation[1][0] ==  2.0) && (czm_viewRotation[2][0] ==  3.0);   bool b1 = (czm_viewRotation[0][1] ==  5.0) && (czm_viewRotation[1][1] ==  6.0) && (czm_viewRotation[2][1] ==  7.0);   bool b2 = (czm_viewRotation[0][2] ==  9.0) && (czm_viewRotation[1][2] == 10.0) && (czm_viewRotation[2][2] == 11.0);   out_FragColor = vec4(b0 && b1 && b2); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_viewRotation3D", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              9,
              10,
              11,
              12,
              13,
              14,
              15,
              16
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_viewRotation3D[0][0] ==  1.0) && (czm_viewRotation3D[1][0] ==  2.0) && (czm_viewRotation3D[2][0] ==  3.0);   bool b1 = (czm_viewRotation3D[0][1] ==  5.0) && (czm_viewRotation3D[1][1] ==  6.0) && (czm_viewRotation3D[2][1] ==  7.0);   bool b2 = (czm_viewRotation3D[0][2] ==  9.0) && (czm_viewRotation3D[1][2] == 10.0) && (czm_viewRotation3D[2][2] == 11.0);   out_FragColor = vec4(b0 && b1 && b2); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseView", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              0,
              -1,
              0,
              7,
              1,
              0,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   out_FragColor = vec4(    (czm_inverseView[0][0] ==  0.0) && (czm_inverseView[1][0] == 1.0) && (czm_inverseView[2][0] == 0.0) && (czm_inverseView[3][0] == -8.0) &&    (czm_inverseView[0][1] == -1.0) && (czm_inverseView[1][1] == 0.0) && (czm_inverseView[2][1] == 0.0) && (czm_inverseView[3][1] ==  7.0) &&    (czm_inverseView[0][2] ==  0.0) && (czm_inverseView[1][2] == 0.0) && (czm_inverseView[2][2] == 1.0) && (czm_inverseView[3][2] ==  0.0)  ); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseView3D", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              0,
              -1,
              0,
              7,
              1,
              0,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   out_FragColor = vec4(    (czm_inverseView3D[0][0] ==  0.0) && (czm_inverseView3D[1][0] == 1.0) && (czm_inverseView3D[2][0] == 0.0) && (czm_inverseView3D[3][0] == -8.0) &&    (czm_inverseView3D[0][1] == -1.0) && (czm_inverseView3D[1][1] == 0.0) && (czm_inverseView3D[2][1] == 0.0) && (czm_inverseView3D[3][1] ==  7.0) &&    (czm_inverseView3D[0][2] ==  0.0) && (czm_inverseView3D[1][2] == 0.0) && (czm_inverseView3D[2][2] == 1.0) && (czm_inverseView3D[3][2] ==  0.0)  ); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseViewRotation", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              0,
              -1,
              0,
              7,
              1,
              0,
              0,
              8,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   out_FragColor = vec4(    (czm_inverseViewRotation[0][0] ==  0.0) && (czm_inverseViewRotation[1][0] == 1.0) && (czm_inverseViewRotation[2][0] == 0.0) &&     (czm_inverseViewRotation[0][1] == -1.0) && (czm_inverseViewRotation[1][1] == 0.0) && (czm_inverseViewRotation[2][1] == 0.0) &&     (czm_inverseViewRotation[0][2] ==  0.0) && (czm_inverseViewRotation[1][2] == 0.0) && (czm_inverseViewRotation[2][2] == 1.0)   ); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseViewRotation3D", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              0,
              -1,
              0,
              7,
              1,
              0,
              0,
              8,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   out_FragColor = vec4(    (czm_inverseViewRotation3D[0][0] ==  0.0) && (czm_inverseViewRotation3D[1][0] == 1.0) && (czm_inverseViewRotation3D[2][0] == 0.0) &&     (czm_inverseViewRotation3D[0][1] == -1.0) && (czm_inverseViewRotation3D[1][1] == 0.0) && (czm_inverseViewRotation3D[2][1] == 0.0) &&     (czm_inverseViewRotation3D[0][2] ==  0.0) && (czm_inverseViewRotation3D[1][2] == 0.0) && (czm_inverseViewRotation3D[2][2] == 1.0)   ); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_projection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            void 0,
            new import__.Matrix4(
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              9,
              10,
              11,
              12,
              13,
              14,
              15,
              16
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_projection[0][0] ==  1.0) && (czm_projection[1][0] ==  2.0) && (czm_projection[2][0] ==  3.0) && (czm_projection[3][0] ==  4.0);   bool b1 = (czm_projection[0][1] ==  5.0) && (czm_projection[1][1] ==  6.0) && (czm_projection[2][1] ==  7.0) && (czm_projection[3][1] ==  8.0);   bool b2 = (czm_projection[0][2] ==  9.0) && (czm_projection[1][2] == 10.0) && (czm_projection[2][2] == 11.0) && (czm_projection[3][2] == 12.0);   bool b3 = (czm_projection[0][3] == 13.0) && (czm_projection[1][3] == 14.0) && (czm_projection[2][3] == 15.0) && (czm_projection[3][3] == 16.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseProjection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            void 0,
            new import__.Matrix4(
              0,
              -1,
              0,
              1,
              1,
              0,
              0,
              2,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_inverseProjection[0][0] ==  0.0) && (czm_inverseProjection[1][0] == 1.0) && (czm_inverseProjection[2][0] == 0.0) && (czm_inverseProjection[3][0] == -2.0);   bool b1 = (czm_inverseProjection[0][1] == -1.0) && (czm_inverseProjection[1][1] == 0.0) && (czm_inverseProjection[2][1] == 0.0) && (czm_inverseProjection[3][1] ==  1.0);   bool b2 = (czm_inverseProjection[0][2] ==  0.0) && (czm_inverseProjection[1][2] == 0.0) && (czm_inverseProjection[2][2] == 1.0) && (czm_inverseProjection[3][2] ==  0.0);   bool b3 = (czm_inverseProjection[0][3] ==  0.0) && (czm_inverseProjection[1][3] == 0.0) && (czm_inverseProjection[2][3] == 0.0) && (czm_inverseProjection[3][3] ==  1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseProjection in 2D", function() {
      const frameState2 = createFrameState_default(
        context,
        createMockCamera(
          void 0,
          new import__.Matrix4(
            0,
            -1,
            0,
            1,
            1,
            0,
            0,
            2,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            1
          )
        )
      );
      frameState2.mode = import__.SceneMode.SCENE2D;
      const us = context.uniformState;
      us.update(frameState2);
      const fs = "void main() {   bool b0 = (czm_inverseProjection[0][0] == 0.0) && (czm_inverseProjection[1][0] == 0.0) && (czm_inverseProjection[2][0] == 0.0) && (czm_inverseProjection[3][0] == 0.0);   bool b1 = (czm_inverseProjection[0][1] == 0.0) && (czm_inverseProjection[1][1] == 0.0) && (czm_inverseProjection[2][1] == 0.0) && (czm_inverseProjection[3][1] == 0.0);   bool b2 = (czm_inverseProjection[0][2] == 0.0) && (czm_inverseProjection[1][2] == 0.0) && (czm_inverseProjection[2][2] == 0.0) && (czm_inverseProjection[3][2] == 0.0);   bool b3 = (czm_inverseProjection[0][3] == 0.0) && (czm_inverseProjection[1][3] == 0.0) && (czm_inverseProjection[2][3] == 0.0) && (czm_inverseProjection[3][3] == 0.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseProjection in 3D with orthographic projection", function() {
      const frameState2 = createFrameState_default(
        context,
        createMockCamera(
          void 0,
          new import__.Matrix4(
            0,
            -1,
            0,
            1,
            1,
            0,
            0,
            2,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            1
          )
        )
      );
      const frustum = new import__.OrthographicFrustum();
      frustum.aspectRatio = 1;
      frustum.width = 1;
      frameState2.camera.frustum = frustum;
      const us = context.uniformState;
      us.update(frameState2);
      const fs = "void main() {   bool b0 = (czm_inverseProjection[0][0] == 0.0) && (czm_inverseProjection[1][0] == 0.0) && (czm_inverseProjection[2][0] == 0.0) && (czm_inverseProjection[3][0] == 0.0);   bool b1 = (czm_inverseProjection[0][1] == 0.0) && (czm_inverseProjection[1][1] == 0.0) && (czm_inverseProjection[2][1] == 0.0) && (czm_inverseProjection[3][1] == 0.0);   bool b2 = (czm_inverseProjection[0][2] == 0.0) && (czm_inverseProjection[1][2] == 0.0) && (czm_inverseProjection[2][2] == 0.0) && (czm_inverseProjection[3][2] == 0.0);   bool b3 = (czm_inverseProjection[0][3] == 0.0) && (czm_inverseProjection[1][3] == 0.0) && (czm_inverseProjection[2][3] == 0.0) && (czm_inverseProjection[3][3] == 0.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_infiniteProjection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            void 0,
            void 0,
            new import__.Matrix4(
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              9,
              10,
              11,
              12,
              13,
              14,
              15,
              16
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_infiniteProjection[0][0] ==  1.0) && (czm_infiniteProjection[1][0] ==  2.0) && (czm_infiniteProjection[2][0] ==  3.0) && (czm_infiniteProjection[3][0] ==  4.0);   bool b1 = (czm_infiniteProjection[0][1] ==  5.0) && (czm_infiniteProjection[1][1] ==  6.0) && (czm_infiniteProjection[2][1] ==  7.0) && (czm_infiniteProjection[3][1] ==  8.0);   bool b2 = (czm_infiniteProjection[0][2] ==  9.0) && (czm_infiniteProjection[1][2] == 10.0) && (czm_infiniteProjection[2][2] == 11.0) && (czm_infiniteProjection[3][2] == 12.0);   bool b3 = (czm_infiniteProjection[0][3] == 13.0) && (czm_infiniteProjection[1][3] == 14.0) && (czm_infiniteProjection[2][3] == 15.0) && (czm_infiniteProjection[3][3] == 16.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_modelView", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              1,
              0,
              1,
              0,
              1,
              0,
              0,
              1,
              1,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_modelView[0][0] == 2.0) && (czm_modelView[1][0] == 0.0) && (czm_modelView[2][0] == 0.0) && (czm_modelView[3][0] == 1.0);   bool b1 = (czm_modelView[0][1] == 0.0) && (czm_modelView[1][1] == 2.0) && (czm_modelView[2][1] == 0.0) && (czm_modelView[3][1] == 1.0);   bool b2 = (czm_modelView[0][2] == 0.0) && (czm_modelView[1][2] == 0.0) && (czm_modelView[2][2] == 2.0) && (czm_modelView[3][2] == 1.0);   bool b3 = (czm_modelView[0][3] == 0.0) && (czm_modelView[1][3] == 0.0) && (czm_modelView[2][3] == 0.0) && (czm_modelView[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        2,
        0,
        0,
        0,
        0,
        2,
        0,
        0,
        0,
        0,
        2,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_modelView3D", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              1,
              0,
              1,
              0,
              1,
              0,
              0,
              1,
              1,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_modelView3D[0][0] == 2.0) && (czm_modelView3D[1][0] == 0.0) && (czm_modelView3D[2][0] == 0.0) && (czm_modelView3D[3][0] == 1.0);   bool b1 = (czm_modelView3D[0][1] == 0.0) && (czm_modelView3D[1][1] == 2.0) && (czm_modelView3D[2][1] == 0.0) && (czm_modelView3D[3][1] == 1.0);   bool b2 = (czm_modelView3D[0][2] == 0.0) && (czm_modelView3D[1][2] == 0.0) && (czm_modelView3D[2][2] == 2.0) && (czm_modelView3D[3][2] == 1.0);   bool b3 = (czm_modelView3D[0][3] == 0.0) && (czm_modelView3D[1][3] == 0.0) && (czm_modelView3D[2][3] == 0.0) && (czm_modelView3D[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        2,
        0,
        0,
        0,
        0,
        2,
        0,
        0,
        0,
        0,
        2,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_modelViewRelativeToEye", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              1,
              0,
              1,
              0,
              1,
              0,
              0,
              1,
              1,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_modelViewRelativeToEye[0][0] == 2.0) && (czm_modelViewRelativeToEye[1][0] == 0.0) && (czm_modelViewRelativeToEye[2][0] == 0.0) && (czm_modelViewRelativeToEye[3][0] == 0.0);   bool b1 = (czm_modelViewRelativeToEye[0][1] == 0.0) && (czm_modelViewRelativeToEye[1][1] == 2.0) && (czm_modelViewRelativeToEye[2][1] == 0.0) && (czm_modelViewRelativeToEye[3][1] == 0.0);   bool b2 = (czm_modelViewRelativeToEye[0][2] == 0.0) && (czm_modelViewRelativeToEye[1][2] == 0.0) && (czm_modelViewRelativeToEye[2][2] == 2.0) && (czm_modelViewRelativeToEye[3][2] == 0.0);   bool b3 = (czm_modelViewRelativeToEye[0][3] == 0.0) && (czm_modelViewRelativeToEye[1][3] == 0.0) && (czm_modelViewRelativeToEye[2][3] == 0.0) && (czm_modelViewRelativeToEye[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        2,
        0,
        0,
        0,
        0,
        2,
        0,
        0,
        0,
        0,
        2,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_inverseModelView", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(import__.Matrix4.clone(import__.Matrix4.IDENTITY))
        )
      );
      const fs = "void main() {   bool b0 = (czm_inverseModelView[0][0] ==  0.0) && (czm_inverseModelView[1][0] == 1.0) && (czm_inverseModelView[2][0] == 0.0) && (czm_inverseModelView[3][0] == -2.0);   bool b1 = (czm_inverseModelView[0][1] == -1.0) && (czm_inverseModelView[1][1] == 0.0) && (czm_inverseModelView[2][1] == 0.0) && (czm_inverseModelView[3][1] ==  1.0);   bool b2 = (czm_inverseModelView[0][2] ==  0.0) && (czm_inverseModelView[1][2] == 0.0) && (czm_inverseModelView[2][2] == 1.0) && (czm_inverseModelView[3][2] ==  0.0);   bool b3 = (czm_inverseModelView[0][3] ==  0.0) && (czm_inverseModelView[1][3] == 0.0) && (czm_inverseModelView[2][3] == 0.0) && (czm_inverseModelView[3][3] ==  1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        0,
        -1,
        0,
        1,
        1,
        0,
        0,
        2,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_inverseModelView3D", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(import__.Matrix4.clone(import__.Matrix4.IDENTITY))
        )
      );
      const fs = "void main() {   bool b0 = (czm_inverseModelView3D[0][0] ==  0.0) && (czm_inverseModelView3D[1][0] == 1.0) && (czm_inverseModelView3D[2][0] == 0.0) && (czm_inverseModelView3D[3][0] == -2.0);   bool b1 = (czm_inverseModelView3D[0][1] == -1.0) && (czm_inverseModelView3D[1][1] == 0.0) && (czm_inverseModelView3D[2][1] == 0.0) && (czm_inverseModelView3D[3][1] ==  1.0);   bool b2 = (czm_inverseModelView3D[0][2] ==  0.0) && (czm_inverseModelView3D[1][2] == 0.0) && (czm_inverseModelView3D[2][2] == 1.0) && (czm_inverseModelView3D[3][2] ==  0.0);   bool b3 = (czm_inverseModelView3D[0][3] ==  0.0) && (czm_inverseModelView3D[1][3] == 0.0) && (czm_inverseModelView3D[2][3] == 0.0) && (czm_inverseModelView3D[3][3] ==  1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        0,
        -1,
        0,
        1,
        1,
        0,
        0,
        2,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_viewProjection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            ),
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_viewProjection[0][0] == 1.0) && (czm_viewProjection[1][0] == 0.0) && (czm_viewProjection[2][0] == 0.0) && (czm_viewProjection[3][0] == 0.0);   bool b1 = (czm_viewProjection[0][1] == 0.0) && (czm_viewProjection[1][1] == 1.0) && (czm_viewProjection[2][1] == 0.0) && (czm_viewProjection[3][1] == 8.0);   bool b2 = (czm_viewProjection[0][2] == 0.0) && (czm_viewProjection[1][2] == 0.0) && (czm_viewProjection[2][2] == 1.0) && (czm_viewProjection[3][2] == 9.0);   bool b3 = (czm_viewProjection[0][3] == 0.0) && (czm_viewProjection[1][3] == 0.0) && (czm_viewProjection[2][3] == 0.0) && (czm_viewProjection[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseViewProjection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            ),
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_inverseViewProjection[0][0] == 1.0) && (czm_inverseViewProjection[1][0] == 0.0) && (czm_inverseViewProjection[2][0] == 0.0) && (czm_inverseViewProjection[3][0] ==  0.0);   bool b1 = (czm_inverseViewProjection[0][1] == 0.0) && (czm_inverseViewProjection[1][1] == 1.0) && (czm_inverseViewProjection[2][1] == 0.0) && (czm_inverseViewProjection[3][1] == -8.0);   bool b2 = (czm_inverseViewProjection[0][2] == 0.0) && (czm_inverseViewProjection[1][2] == 0.0) && (czm_inverseViewProjection[2][2] == 1.0) && (czm_inverseViewProjection[3][2] == -9.0);   bool b3 = (czm_inverseViewProjection[0][3] == 0.0) && (czm_inverseViewProjection[1][3] == 0.0) && (czm_inverseViewProjection[2][3] == 0.0) && (czm_inverseViewProjection[3][3] ==  1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_modelViewProjection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            ),
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_modelViewProjection[0][0] == 1.0) && (czm_modelViewProjection[1][0] == 0.0) && (czm_modelViewProjection[2][0] == 0.0) && (czm_modelViewProjection[3][0] == 7.0);   bool b1 = (czm_modelViewProjection[0][1] == 0.0) && (czm_modelViewProjection[1][1] == 1.0) && (czm_modelViewProjection[2][1] == 0.0) && (czm_modelViewProjection[3][1] == 8.0);   bool b2 = (czm_modelViewProjection[0][2] == 0.0) && (czm_modelViewProjection[1][2] == 0.0) && (czm_modelViewProjection[2][2] == 1.0) && (czm_modelViewProjection[3][2] == 9.0);   bool b3 = (czm_modelViewProjection[0][3] == 0.0) && (czm_modelViewProjection[1][3] == 0.0) && (czm_modelViewProjection[2][3] == 0.0) && (czm_modelViewProjection[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        1,
        0,
        0,
        7,
        0,
        1,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_inverseModelViewProjection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            ),
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_inverseModelViewProjection[0][0] == 1.0) && (czm_inverseModelViewProjection[1][0] == 0.0) && (czm_inverseModelViewProjection[2][0] == 0.0) && (czm_inverseModelViewProjection[3][0] == -7.0);   bool b1 = (czm_inverseModelViewProjection[0][1] == 0.0) && (czm_inverseModelViewProjection[1][1] == 1.0) && (czm_inverseModelViewProjection[2][1] == 0.0) && (czm_inverseModelViewProjection[3][1] == -8.0);   bool b2 = (czm_inverseModelViewProjection[0][2] == 0.0) && (czm_inverseModelViewProjection[1][2] == 0.0) && (czm_inverseModelViewProjection[2][2] == 1.0) && (czm_inverseModelViewProjection[3][2] == -9.0);   bool b3 = (czm_inverseModelViewProjection[0][3] == 0.0) && (czm_inverseModelViewProjection[1][3] == 0.0) && (czm_inverseModelViewProjection[2][3] == 0.0) && (czm_inverseModelViewProjection[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        1,
        0,
        0,
        7,
        0,
        1,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_modelViewProjectionRelativeToEye", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            ),
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_modelViewProjectionRelativeToEye[0][0] == 1.0) && (czm_modelViewProjectionRelativeToEye[1][0] == 0.0) && (czm_modelViewProjectionRelativeToEye[2][0] == 0.0) && (czm_modelViewProjectionRelativeToEye[3][0] == 0.0);   bool b1 = (czm_modelViewProjectionRelativeToEye[0][1] == 0.0) && (czm_modelViewProjectionRelativeToEye[1][1] == 1.0) && (czm_modelViewProjectionRelativeToEye[2][1] == 0.0) && (czm_modelViewProjectionRelativeToEye[3][1] == 0.0);   bool b2 = (czm_modelViewProjectionRelativeToEye[0][2] == 0.0) && (czm_modelViewProjectionRelativeToEye[1][2] == 0.0) && (czm_modelViewProjectionRelativeToEye[2][2] == 1.0) && (czm_modelViewProjectionRelativeToEye[3][2] == 9.0);   bool b3 = (czm_modelViewProjectionRelativeToEye[0][3] == 0.0) && (czm_modelViewProjectionRelativeToEye[1][3] == 0.0) && (czm_modelViewProjectionRelativeToEye[2][3] == 0.0) && (czm_modelViewProjectionRelativeToEye[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        1,
        0,
        0,
        7,
        0,
        1,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_modelViewInfiniteProjection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            ),
            void 0,
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_modelViewInfiniteProjection[0][0] == 1.0) && (czm_modelViewInfiniteProjection[1][0] == 0.0) && (czm_modelViewInfiniteProjection[2][0] == 0.0) && (czm_modelViewInfiniteProjection[3][0] == 7.0);   bool b1 = (czm_modelViewInfiniteProjection[0][1] == 0.0) && (czm_modelViewInfiniteProjection[1][1] == 1.0) && (czm_modelViewInfiniteProjection[2][1] == 0.0) && (czm_modelViewInfiniteProjection[3][1] == 8.0);   bool b2 = (czm_modelViewInfiniteProjection[0][2] == 0.0) && (czm_modelViewInfiniteProjection[1][2] == 0.0) && (czm_modelViewInfiniteProjection[2][2] == 1.0) && (czm_modelViewInfiniteProjection[3][2] == 9.0);   bool b3 = (czm_modelViewInfiniteProjection[0][3] == 0.0) && (czm_modelViewInfiniteProjection[1][3] == 0.0) && (czm_modelViewInfiniteProjection[2][3] == 0.0) && (czm_modelViewInfiniteProjection[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        1,
        0,
        0,
        7,
        0,
        1,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_normal", function() {
      const fs = "void main() {   out_FragColor = vec4(    (czm_normal[0][0] == 1.0) && (czm_normal[1][0] == 0.0) && (czm_normal[2][0] == 0.0) &&     (czm_normal[0][1] == 0.0) && (czm_normal[1][1] == 1.0) && (czm_normal[2][1] == 0.0) &&     (czm_normal[0][2] == 0.0) && (czm_normal[1][2] == 0.0) && (czm_normal[2][2] == 1.0)   ); }";
      const m = new import__.Matrix4(
        1,
        0,
        0,
        7,
        0,
        1,
        0,
        8,
        0,
        0,
        1,
        9,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_inverseNormal", function() {
      const fs = "void main() {   out_FragColor = vec4(    (czm_inverseNormal[0][0] ==  0.0) && (czm_inverseNormal[1][0] == 1.0) && (czm_inverseNormal[2][0] == 0.0) &&     (czm_inverseNormal[0][1] == -1.0) && (czm_inverseNormal[1][1] == 0.0) && (czm_inverseNormal[2][1] == 0.0) &&     (czm_inverseNormal[0][2] ==  0.0) && (czm_inverseNormal[1][2] == 0.0) && (czm_inverseNormal[2][2] == 1.0)   ); }";
      const m = new import__.Matrix4(
        0,
        -1,
        0,
        7,
        1,
        0,
        0,
        8,
        0,
        0,
        1,
        9,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_normal3D", function() {
      const fs = "void main() {   out_FragColor = vec4(    (czm_normal3D[0][0] == 1.0) && (czm_normal3D[1][0] == 0.0) && (czm_normal3D[2][0] == 0.0) &&     (czm_normal3D[0][1] == 0.0) && (czm_normal3D[1][1] == 1.0) && (czm_normal3D[2][1] == 0.0) &&     (czm_normal3D[0][2] == 0.0) && (czm_normal3D[1][2] == 0.0) && (czm_normal3D[2][2] == 1.0)   ); }";
      const m = new import__.Matrix4(
        1,
        0,
        0,
        7,
        0,
        1,
        0,
        8,
        0,
        0,
        1,
        9,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_inverseNormal3D", function() {
      const fs = "void main() {   out_FragColor = vec4(    (czm_inverseNormal3D[0][0] ==  0.0) && (czm_inverseNormal3D[1][0] == 1.0) && (czm_inverseNormal3D[2][0] == 0.0) &&     (czm_inverseNormal3D[0][1] == -1.0) && (czm_inverseNormal3D[1][1] == 0.0) && (czm_inverseNormal3D[2][1] == 0.0) &&     (czm_inverseNormal3D[0][2] ==  0.0) && (czm_inverseNormal3D[1][2] == 0.0) && (czm_inverseNormal3D[2][2] == 1.0)   ); }";
      const m = new import__.Matrix4(
        0,
        -1,
        0,
        7,
        1,
        0,
        0,
        8,
        0,
        0,
        1,
        9,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_encodedCameraPositionMCHigh and czm_encodedCameraPositionMCLow", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            void 0,
            void 0,
            void 0,
            new import__.Cartesian3(-1e3, 0, 1e5)
          )
        )
      );
      const fs = "void main() {   bool b = (czm_encodedCameraPositionMCHigh + czm_encodedCameraPositionMCLow == vec3(-1000.0, 0.0, 100000.0));   out_FragColor = vec4(b); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_entireFrustum", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4((czm_entireFrustum.x == 1.0) && (czm_entireFrustum.y == 1000.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_frustumPlanes", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4(equal(czm_frustumPlanes, vec4(2.0, -2.0, -1.0, 1.0))); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sunPositionWC", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4(czm_sunPositionWC != vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sunPositionColumbusView", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4(czm_sunPositionColumbusView != vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sunDirectionEC", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4(czm_sunDirectionEC != vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sunDirectionWC", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4(czm_sunDirectionWC != vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_moonDirectionEC", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4(czm_moonDirectionEC != vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_viewerPositionWC", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4(czm_viewerPositionWC == vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_frameNumber", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_frameNumber != 0.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_morphTime", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_morphTime == 1.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_temeToPseudoFixed", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() {   out_FragColor = vec4(    (czm_temeToPseudoFixed[0][0] != 0.0) && (czm_temeToPseudoFixed[1][0] != 0.0) && (czm_temeToPseudoFixed[2][0] == 0.0) &&     (czm_temeToPseudoFixed[0][1] != 0.0) && (czm_temeToPseudoFixed[1][1] != 0.0) && (czm_temeToPseudoFixed[2][1] == 0.0) &&     (czm_temeToPseudoFixed[0][2] == 0.0) && (czm_temeToPseudoFixed[1][2] == 0.0) && (czm_temeToPseudoFixed[2][2] == 1.0)   ); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passEnvironment", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.ENVIRONMENT);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passEnvironment);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passCompute", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.COMPUTE);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passCompute);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passGlobe", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.GLOBE);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passGlobe);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passTerrainClassification", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.TERRAIN_CLASSIFICATION);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passTerrainClassification);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passCesium3DTileClassification", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.CESIUM_3D_TILE_CLASSIFICATION);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passCesium3DTileClassification);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passOpaque", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.OPAQUE);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passOpaque);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passTranslucent", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.TRANSLUCENT);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passTranslucent);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passOverlay", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.OVERLAY);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passOverlay);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sceneMode", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_sceneMode == 3.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sceneMode2D", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_sceneMode2D == 2.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sceneModeColumbusView", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_sceneModeColumbusView == 1.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sceneMode3D", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_sceneMode3D == 3.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sceneModeMorphing", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_sceneModeMorphing == 0.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_eyeHeight", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      context.uniformState.update(frameState2);
      const fs = "void main() {   out_FragColor = vec4(czm_eyeHeight == 10.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_eyeHeight2D == 0,0 in Scene3D", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_eyeHeight2D.x == 0.0, czm_eyeHeight2D.y == 0.0, 1.0, 1.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_eyeHeight2D in Scene2D", function() {
      const us = context.uniformState;
      const camera = createCamera_default();
      const frustum = new import__.OrthographicOffCenterFrustum();
      frustum.near = 1;
      frustum.far = 2;
      frustum.left = -2;
      frustum.right = 2;
      frustum.top = 1;
      frustum.bottom = -1;
      camera.frustum = frustum;
      const frameState2 = createFrameState_default(context, camera);
      frameState2.mode = import__.SceneMode.SCENE2D;
      us.update(frameState2);
      const fs = "void main() {   out_FragColor = vec4(czm_eyeHeight2D.x == 2.0, czm_eyeHeight2D.y == 4.0, 1.0, 1.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_splitPosition", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_splitPosition == 0.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_backgroundColor", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      frameState2.backgroundColor = new import__.Color(0, 0.25, 0.75, 1);
      context.uniformState.update(frameState2);
      const fs = "void main() {   out_FragColor = vec4(czm_backgroundColor.r == 0.0, czm_backgroundColor.g == 0.25, czm_backgroundColor.b == 0.75, czm_backgroundColor.a == 1.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_minimumDisableDepthTestDistance", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      context.uniformState.update(frameState2);
      const fs = "void main() {  out_FragColor = vec4(czm_minimumDisableDepthTestDistance == 0.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_orthographicIn3D", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      context.uniformState.update(frameState2);
      let fs = "void main() {  out_FragColor = vec4(czm_orthographicIn3D == 0.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
      const frustum = new import__.OrthographicFrustum();
      frustum.aspectRatio = 1;
      frustum.width = 1;
      frameState2.camera.frustum = frustum;
      context.uniformState.update(frameState2);
      fs = "void main() {  out_FragColor = vec4(czm_orthographicIn3D == 1.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_gamma", function() {
      context.uniformState.gamma = 1;
      const fs = "void main() {  out_FragColor = vec4(czm_gamma == 1.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_lightDirectionEC", function() {
      const us = context.uniformState;
      const frameState2 = createFrameState_default(context, createMockCamera());
      frameState2.light = new import__.DirectionalLight({
        direction: new import__.Cartesian3(0, 0, 1)
      });
      us.update(frameState2);
      const fs = "void main() { out_FragColor = vec4(czm_lightDirectionEC != vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_lightDirectionWC", function() {
      const us = context.uniformState;
      const frameState2 = createFrameState_default(context, createMockCamera());
      frameState2.light = new import__.DirectionalLight({
        direction: new import__.Cartesian3(0, 0, 1)
      });
      us.update(frameState2);
      const fs = "void main() { out_FragColor = vec4(czm_lightDirectionWC == vec3(0.0, 0.0, -1.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_lightColor", function() {
      const us = context.uniformState;
      const frameState2 = createFrameState_default(context, createMockCamera());
      frameState2.light = new import__.DirectionalLight({
        direction: new import__.Cartesian3(0, 0, 1),
        color: new import__.Color(0.25, 0.5, 1),
        intensity: 2
      });
      us.update(frameState2);
      const fs = "void main() {  bool b0 = czm_lightColor.x == 0.25;  bool b1 = czm_lightColor.y == 0.5;  bool b2 = czm_lightColor.z == 1.0;  out_FragColor = vec4(b0 && b1 && b2);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_lightColorHdr", function() {
      const us = context.uniformState;
      const frameState2 = createFrameState_default(context, createMockCamera());
      frameState2.light = new import__.DirectionalLight({
        direction: new import__.Cartesian3(0, 0, 1),
        color: new import__.Color(0.25, 0.5, 1),
        intensity: 2
      });
      us.update(frameState2);
      const fs = "void main() {  bool b0 = czm_lightColorHdr.x == 0.5;  bool b1 = czm_lightColorHdr.y == 1.0;  bool b2 = czm_lightColorHdr.z == 2.0;  out_FragColor = vec4(b0 && b1 && b2);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_ellipsoidRadii", function() {
      const us = context.uniformState;
      const frameState2 = createFrameState_default(context, createMockCamera());
      const ellipsoid = new import__.Ellipsoid(1, 2, 3);
      frameState2.mapProjection = new import__.GeographicProjection(ellipsoid);
      us.update(frameState2);
      const fs = "void main() {  bool b0 = czm_ellipsoidRadii.x == 1.0;  bool b1 = czm_ellipsoidRadii.y == 2.0;  bool b2 = czm_ellipsoidRadii.z == 3.0;  out_FragColor = vec4(b0 && b1 && b2);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_ellipsoidInverseRadii", function() {
      const us = context.uniformState;
      const frameState2 = createFrameState_default(context, createMockCamera());
      const ellipsoid = new import__.Ellipsoid(1, 1 / 2, 1 / 3);
      frameState2.mapProjection = new import__.GeographicProjection(ellipsoid);
      us.update(frameState2);
      const fs = "float roundNumber(float number) { return floor(number + 0.5); }void main() {  bool b0 = roundNumber(czm_ellipsoidInverseRadii.x) == 1.0;  bool b1 = roundNumber(czm_ellipsoidInverseRadii.y) == 2.0;  bool b2 = roundNumber(czm_ellipsoidInverseRadii.z) == 3.0;  out_FragColor = vec4(b0 && b1 && b2);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/BufferSpec.js
var import__2 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Buffer",
  function() {
    createBufferSpecs({});
    const c = createContext_default({});
    if (c.webgl2) {
      createBufferSpecs({});
    }
    c.destroyForSpecs();
    function createBufferSpecs(contextOptions) {
      let context;
      let buffer;
      let buffer2;
      const webglMessage = contextOptions.requestWebgl1 ? "" : ": WebGL 2";
      beforeAll(function() {
        context = createContext_default(contextOptions);
      });
      afterAll(function() {
        context.destroyForSpecs();
      });
      afterEach(function() {
        if (buffer && !buffer.isDestroyed()) {
          buffer = buffer.destroy();
        }
        if (buffer2 && !buffer2.isDestroyed()) {
          buffer2 = buffer2.destroy();
        }
      });
      it(`throws when creating a vertex buffer with no context${webglMessage}`, function() {
        expect(function() {
          buffer = import__2.Buffer.createVertexBuffer({
            sizeInBytes: 4,
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a vertex buffer with an invalid typed array${webglMessage}`, function() {
        expect(function() {
          buffer = import__2.Buffer.createVertexBuffer({
            context,
            typedArray: {},
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a vertex buffer with both a typed array and size in bytes${webglMessage}`, function() {
        expect(function() {
          buffer = import__2.Buffer.createVertexBuffer({
            context,
            typedArray: new Float32Array([0, 0, 0, 1]),
            sizeInBytes: 16,
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a vertex buffer without a typed array or size in bytes${webglMessage}`, function() {
        expect(function() {
          buffer = import__2.Buffer.createVertexBuffer({
            context,
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a vertex buffer with invalid usage${webglMessage}`, function() {
        expect(function() {
          buffer = import__2.Buffer.createVertexBuffer({
            context,
            sizeInBytes: 16,
            usage: 0
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a vertex buffer with size of zero${webglMessage}`, function() {
        expect(function() {
          buffer = import__2.Buffer.createVertexBuffer({
            context,
            sizeInBytes: 0,
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`creates vertex buffer${webglMessage}`, function() {
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 16,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(buffer.sizeInBytes).toEqual(16);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STATIC_DRAW);
      });
      it(`copies array to a vertex buffer${webglMessage}`, function() {
        const sizeInBytes = 3 * Float32Array.BYTES_PER_ELEMENT;
        const vertices = new ArrayBuffer(sizeInBytes);
        const positions = new Float32Array(vertices);
        positions[0] = 1;
        positions[1] = 2;
        positions[2] = 3;
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        buffer.copyFromArrayView(vertices);
      });
      it(`can create a vertex buffer from a typed array${webglMessage}`, function() {
        const typedArray = new Float32Array(3);
        typedArray[0] = 1;
        typedArray[1] = 2;
        typedArray[2] = 3;
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(buffer.sizeInBytes).toEqual(typedArray.byteLength);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STATIC_DRAW);
      });
      it(`can create a vertex buffer from a size in bytes${webglMessage}`, function() {
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(buffer.sizeInBytes).toEqual(4);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STATIC_DRAW);
      });
      it(`throws when creating an index buffer with no context${webglMessage}`, function() {
        expect(function() {
          buffer = import__2.Buffer.createIndexBuffer({
            sizeInBytes: 4,
            usage: import__2.BufferUsage.STATIC_DRAW,
            indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating an index buffer with an invalid typed array${webglMessage}`, function() {
        expect(function() {
          buffer = import__2.Buffer.createIndexBuffer({
            context,
            typedArray: {},
            usage: import__2.BufferUsage.STATIC_DRAW,
            indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating an index buffer with both a typed array and size in bytes${webglMessage}`, function() {
        expect(function() {
          buffer = import__2.Buffer.createIndexBuffer({
            context,
            typedArray: new Uint16Array([0, 1, 2, 0, 2, 3]),
            sizeInBytes: 12,
            usage: import__2.BufferUsage.STATIC_DRAW,
            indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating an index buffer without a typed array or size in bytes${webglMessage}`, function() {
        expect(function() {
          buffer = import__2.Buffer.createIndexBuffer({
            context,
            usage: import__2.BufferUsage.STATIC_DRAW,
            indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating an index buffer with invalid usage${webglMessage}`, function() {
        expect(function() {
          buffer = import__2.Buffer.createIndexBuffer({
            context,
            sizeInBytes: 16,
            usage: "invalid",
            indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating an index buffer with invalid index data type${webglMessage}`, function() {
        expect(function() {
          buffer = import__2.Buffer.createIndexBuffer({
            context,
            sizeInBytes: 16,
            usage: import__2.BufferUsage.STATIC_DRAW,
            indexDatatype: "invalid"
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating an index buffer with size of zero${webglMessage}`, function() {
        expect(function() {
          buffer = import__2.Buffer.createIndexBuffer({
            context,
            sizeInBytes: 0,
            usage: import__2.BufferUsage.STATIC_DRAW,
            indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
          });
        }).toThrowDeveloperError();
      });
      it(`creates index buffer${webglMessage}`, function() {
        buffer = import__2.Buffer.createIndexBuffer({
          context,
          sizeInBytes: 6,
          usage: import__2.BufferUsage.STREAM_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        expect(buffer.sizeInBytes).toEqual(6);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STREAM_DRAW);
        expect(buffer.indexDatatype).toEqual(import__2.IndexDatatype.UNSIGNED_SHORT);
        expect(buffer.bytesPerIndex).toEqual(2);
        expect(buffer.numberOfIndices).toEqual(3);
      });
      it(`copies array to an index buffer${webglMessage}`, function() {
        const sizeInBytes = 3 * Uint16Array.BYTES_PER_ELEMENT;
        const elements = new ArrayBuffer(sizeInBytes);
        const indices = new Uint16Array(elements);
        indices[0] = 1;
        indices[1] = 2;
        indices[2] = 3;
        buffer = import__2.Buffer.createIndexBuffer({
          context,
          sizeInBytes,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        buffer.copyFromArrayView(elements);
      });
      it(`can create an index buffer from a typed array${webglMessage}`, function() {
        const typedArray = new Uint16Array(3);
        typedArray[0] = 1;
        typedArray[1] = 2;
        typedArray[2] = 3;
        buffer = import__2.Buffer.createIndexBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        expect(buffer.sizeInBytes).toEqual(typedArray.byteLength);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STATIC_DRAW);
        expect(buffer.indexDatatype).toEqual(import__2.IndexDatatype.UNSIGNED_SHORT);
      });
      it(`can create an index buffer from a size in bytes${webglMessage}`, function() {
        buffer = import__2.Buffer.createIndexBuffer({
          context,
          sizeInBytes: 6,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        expect(buffer.sizeInBytes).toEqual(6);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STATIC_DRAW);
        expect(buffer.indexDatatype).toEqual(import__2.IndexDatatype.UNSIGNED_SHORT);
      });
      it(`getBufferData throws without WebGL 2${webglMessage}`, function() {
        if (context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const array = new Uint8Array(4);
        expect(function() {
          buffer.getBufferData(array);
        }).toThrowDeveloperError();
      });
      it(`getBufferData throws without arrayView${webglMessage}`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.getBufferData(void 0);
        }).toThrowDeveloperError();
      });
      it(`getBufferData throws with invalid sourceOffset${webglMessage}`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const array = new Uint8Array(4);
        expect(function() {
          buffer.getBufferData(array, -1);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.getBufferData(array, 5);
        }).toThrowDeveloperError();
      });
      it(`getBufferData throws with invalid destinationOffset${webglMessage}`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const array = new Uint8Array(4);
        expect(function() {
          buffer.getBufferData(array, 0, -1);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.getBufferData(array, 0, 5);
        }).toThrowDeveloperError();
      });
      it(`getBufferData throws with invalid length${webglMessage}`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const array = new Uint8Array(4);
        expect(function() {
          buffer.getBufferData(array, 2, 0, 4);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.getBufferData(array, 0, 2, 4);
        }).toThrowDeveloperError();
      });
      it(`getBufferData reads from vertex buffer${webglMessage}`, function() {
        if (!context.webgl2) {
          return;
        }
        const typedArray = new Uint8Array(4);
        typedArray[0] = 1;
        typedArray[1] = 2;
        typedArray[2] = 3;
        typedArray[3] = 4;
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const destArray = new Uint8Array(4);
        buffer.getBufferData(destArray);
        expect(destArray).toEqual(typedArray);
      });
      it(`getBufferData reads from index buffer${webglMessage}`, function() {
        if (!context.webgl2) {
          return;
        }
        const typedArray = new Uint16Array(3);
        typedArray[0] = 1;
        typedArray[1] = 2;
        typedArray[2] = 3;
        buffer = import__2.Buffer.createIndexBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        const destArray = new Uint16Array(3);
        buffer.getBufferData(destArray);
        expect(destArray).toEqual(typedArray);
      });
      it(`copyFromBuffer throws without WebGL 2${webglMessage}`, function() {
        if (context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        buffer2 = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, 0, 4);
        }).toThrowDeveloperError();
      });
      it(`copyFromBuffer throws without readBuffer${webglMessage}`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.copyFromBuffer(void 0, 0, 0, 4);
        }).toThrowDeveloperError();
      });
      it(`copyFromBuffer throws with invalid readOffset${webglMessage}`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        buffer2 = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.copyFromBuffer(buffer2, void 0, 0, 4);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer2, -1, 0, 4);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer2, 5, 0, 4);
        }).toThrowDeveloperError();
      });
      it(`copyFromBuffer throws with invalid writeOffset${webglMessage}`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        buffer2 = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, void 0, 4);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, -1, 4);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, 5, 4);
        }).toThrowDeveloperError();
      });
      it(`copyFromBuffer throws with invalid sizeInBytes${webglMessage}`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        buffer2 = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, 0, void 0);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, 0, -1);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, 0, 0);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, 0, 5);
        }).toThrowDeveloperError();
      });
      it(`copyFromBuffer throws with one index buffer and the other is not an index buffer${webglMessage}`, function() {
        if (!context.webgl2) {
          return;
        }
        const typedArray = new Uint16Array([0, 1, 2, 3, 4]);
        buffer = import__2.Buffer.createIndexBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        const typedArray2 = new Float32Array([5, 6, 7, 8, 9]);
        buffer2 = import__2.Buffer.createVertexBuffer({
          context,
          typedArray: typedArray2,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer2.copyFromBuffer(buffer, 0, 0, typedArray.byteLength);
        }).toThrowDeveloperError();
      });
      it(`copyFromBuffer throws when readBuffer is the same buffer and copy range overlaps${webglMessage}`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.copyFromBuffer(buffer, 0, 1, 2);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer, 1, 0, 2);
        }).toThrowDeveloperError();
      });
      it(`copyFromBuffer with vertex buffers${webglMessage}`, function() {
        if (!context.webgl2) {
          return;
        }
        const typedArray = new Float32Array([0, 1, 2, 3, 4]);
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const typedArray2 = new Float32Array([5, 6, 7, 8, 9]);
        buffer2 = import__2.Buffer.createVertexBuffer({
          context,
          typedArray: typedArray2,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const destArray = new Float32Array(5);
        buffer.getBufferData(destArray);
        expect(destArray).toEqual(typedArray);
        buffer2.getBufferData(destArray);
        expect(destArray).toEqual(typedArray2);
        buffer2.copyFromBuffer(buffer, 0, 0, typedArray.byteLength);
        buffer2.getBufferData(destArray);
        expect(destArray).toEqual(typedArray);
      });
      it(`copyFromBuffer with index buffers${webglMessage}`, function() {
        if (!context.webgl2) {
          return;
        }
        const typedArray = new Uint16Array([0, 1, 2, 3, 4]);
        buffer = import__2.Buffer.createIndexBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        const typedArray2 = new Uint16Array([5, 6, 7, 8, 9]);
        buffer2 = import__2.Buffer.createIndexBuffer({
          context,
          typedArray: typedArray2,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        const destArray = new Uint16Array(5);
        buffer.getBufferData(destArray);
        expect(destArray).toEqual(typedArray);
        buffer2.getBufferData(destArray);
        expect(destArray).toEqual(typedArray2);
        buffer2.copyFromBuffer(buffer, 0, 0, typedArray.byteLength);
        buffer2.getBufferData(destArray);
        expect(destArray).toEqual(typedArray);
      });
      it(`destroys${webglMessage}`, function() {
        const b = import__2.Buffer.createIndexBuffer({
          context,
          sizeInBytes: 3,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_BYTE
        });
        expect(b.isDestroyed()).toEqual(false);
        b.destroy();
        expect(b.isDestroyed()).toEqual(true);
      });
      it(`fails to provide an array view${webglMessage}`, function() {
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 3,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.copyFromArrayView();
        }).toThrowDeveloperError();
      });
      it(`fails to copy a large array view${webglMessage}`, function() {
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 3,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const elements = new ArrayBuffer(3);
        expect(function() {
          buffer.copyFromArrayView(elements, 1);
        }).toThrowDeveloperError();
      });
      it(`fails to destroy${webglMessage}`, function() {
        const b = import__2.Buffer.createIndexBuffer({
          context,
          sizeInBytes: 3,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_BYTE
        });
        b.destroy();
        expect(function() {
          b.destroy();
        }).toThrowDeveloperError();
      });
    }
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/BuiltinFunctionsSpec.js
var import__3 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/BuiltinFunctions",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("has czm_transpose (2x2)", function() {
      const fs = "void main() {   mat2 m = mat2(1.0, 2.0, 3.0, 4.0);   mat2 mt = mat2(1.0, 3.0, 2.0, 4.0);   out_FragColor = vec4(czm_transpose(m) == mt); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_transpose (3x3)", function() {
      const fs = "void main() {   mat3 m = mat3(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);   mat3 mt = mat3(1.0, 4.0, 7.0, 2.0, 5.0, 8.0, 3.0, 6.0, 9.0);   out_FragColor = vec4(czm_transpose(m) == mt); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_transpose (4x4)", function() {
      const fs = "void main() {   mat4 m = mat4(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0);  mat4 mt = mat4(1.0, 5.0, 9.0, 13.0, 2.0, 6.0, 10.0, 14.0, 3.0, 7.0, 11.0, 15.0, 4.0, 8.0, 12.0, 16.0);  out_FragColor = vec4(czm_transpose(m) == mt); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_eyeToWindowCoordinates", function() {
      const camera = createCamera_default();
      camera.frustum.near = 1;
      const canvas = context.canvas;
      const width = canvas.clientWidth;
      const height = canvas.clientHeight;
      const vp = new import__3.BoundingRectangle(0, 0, width, height);
      context.uniformState.viewport = vp;
      context.uniformState.update(createFrameState_default(context, camera));
      const fs = "void main() {   float z = czm_projection[3][2] / czm_projection[2][2];  float x = z / czm_projection[0][0];  float y = z / czm_projection[1][1];  vec4 pointEC = vec4(x, y, z, 1.0);  vec2 fragCoord = vec2(0.0, 0.0);  vec4 actual = czm_eyeToWindowCoordinates(pointEC);  vec2 diff = actual.xy - fragCoord;  out_FragColor = vec4(all(lessThan(diff, vec2(czm_epsilon6))));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_windowToEyeCoordinates", function() {
      const camera = createCamera_default();
      camera.frustum.near = 1;
      const canvas = context.canvas;
      const width = canvas.clientWidth;
      const height = canvas.clientHeight;
      const vp = new import__3.BoundingRectangle(0, 0, width, height);
      context.uniformState.viewport = vp;
      context.uniformState.update(createFrameState_default(context, camera));
      let fs = "void main() {   float z = czm_projection[3][2] / czm_projection[2][2];  float x = z / czm_projection[0][0];  float y = z / czm_projection[1][1];  vec3 pointEC = vec3(x, y, z);  vec4 fragCoord = vec4(0.0, 0.0, 0.0, -z);  vec4 actual = czm_windowToEyeCoordinates(fragCoord);  vec3 diff = actual.xyz - pointEC;  out_FragColor = vec4(all(lessThan(diff, vec3(czm_epsilon6))));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
      fs = "void main() {   float z = czm_projection[3][2] / czm_projection[2][2];  float x = z / czm_projection[0][0];  float y = z / czm_projection[1][1];  vec3 pointEC = vec3(x, y, z);  vec4 actual = czm_windowToEyeCoordinates(vec2(0.0, 0.0), 0.0);  vec3 diff = actual.xyz - pointEC;  out_FragColor = vec4(all(lessThan(diff, vec3(czm_epsilon6))));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_planeDistance", function() {
      let fs = "void main() {   vec4 plane = vec4(1.0, 0.0, 0.0, 0.0);   vec3 point = vec3(1.0, 0.0, 0.0);   float expected = 1.0;   float actual = czm_planeDistance(plane, point);   out_FragColor = vec4(actual == expected); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
      fs = "void main() {   vec4 plane = vec4(1.0, 0.0, 0.0, 0.0);   vec3 point = vec3(1.0, 0.0, 0.0);   float expected = 1.0;   float actual = czm_planeDistance(plane.xyz, plane.w, point);   out_FragColor = vec4(actual == expected); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_lineDistance", function() {
      const fs = "void main() {   vec2 point1 = vec2(0.0, 0.0);   vec2 point2 = vec2(1.0, 0.0);   vec2 point = vec2(0.5, 1.0);   float expected = 1.0;   float actual = czm_lineDistance(point1, point2, point);   out_FragColor = vec4(actual == expected); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_tangentToEyeSpaceMatrix", function() {
      const fs = "void main() {   vec3 tangent = vec3(1.0, 0.0, 0.0);   vec3 bitangent = vec3(0.0, 1.0, 0.0);   vec3 normal = vec3(0.0, 0.0, 1.0);   mat3 expected = mat3(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);   mat3 actual = czm_tangentToEyeSpaceMatrix(normal, tangent, bitangent);   out_FragColor = vec4(actual == expected); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_translateRelativeToEye", function() {
      const camera = createCamera_default({
        offset: new import__3.Cartesian3(1, 2, 3)
      });
      context.uniformState.update(createFrameState_default(context, camera));
      const p = new import__3.Cartesian3(6, 5, 4);
      const encoded = import__3.EncodedCartesian3.fromCartesian(p);
      const uniformMap = {
        u_high: function() {
          return encoded.high;
        },
        u_low: function() {
          return encoded.low;
        }
      };
      const fs = "uniform vec3 u_high;uniform vec3 u_low;void main() {   vec4 p = czm_translateRelativeToEye(u_high, u_low);  out_FragColor = vec4(p == vec4(5.0, 3.0, 1.0, 1.0)); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("has czm_antialias", function() {
      const fs = "void main() {  vec4 color0 = vec4(1.0, 0.0, 0.0, 1.0);  vec4 color1 = vec4(0.0, 1.0, 0.0, 1.0);  vec4 result = czm_antialias(color0, color1, color1, 0.5); out_FragColor = vec4(result == color1);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("czm_pointAlongRay: point at ray origin", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_pointAlongRay(czm_ray(vec3(0.0), vec3(1.0, 0.0, 0.0)), 0.0) == vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("czm_pointAlongRay: point in front of ray origin", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_pointAlongRay(czm_ray(vec3(0.0), vec3(1.0, 0.0, 0.0)), 2.0) == vec3(2.0, 0.0, 0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("czm_pointAlongRay: point behind ray origin", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_pointAlongRay(czm_ray(vec3(0.0), vec3(0.0, 1.0, 0.0)), -2.0) == vec3(0.0, -2.0, 0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_octDecode(vec2)", function() {
      const fs = "void main() {   out_FragColor = vec4(all(lessThanEqual(abs(czm_octDecode(vec2(128.0, 128.0)) - vec3(0.0, 0.0, 1.0)), vec3(0.01)))); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_octDecode(float)", function() {
      const fs = "void main() {   out_FragColor = vec4(all(lessThanEqual(abs(czm_octDecode(32896.0) - vec3(0.0, 0.0, 1.0)), vec3(0.01)))); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_octDecode(vec2, vec3, vec3, vec3)", function() {
      const fs = "void main() {   vec3 a, b, c;  czm_octDecode(vec2(8454016.0, 8421631.0), a, b, c);  bool decoded = all(lessThanEqual(abs(a - vec3(1.0, 0.0, 0.0)), vec3(0.01)));  decoded = decoded && all(lessThanEqual(abs(b - vec3(0.0, 1.0, 0.0)), vec3(0.01)));  decoded = decoded && all(lessThanEqual(abs(c - vec3(0.0, 0.0, 1.0)), vec3(0.01)));  out_FragColor = vec4(decoded);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_decompressTextureCoordinates", function() {
      const fs = "void main() {   vec2 coords = czm_decompressTextureCoordinates(8386559.0);   vec2 expected = vec2(0.4998779, 0.4998779);  out_FragColor = vec4(all(lessThanEqual(abs(coords - expected), vec2(0.00000005)))); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has signNotZero : float", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_signNotZero(0.0) == 1.0,                       czm_signNotZero(5.0) == 1.0,                       czm_signNotZero(-5.0) == -1.0, 1.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has signNotZero : vec2", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_signNotZero(vec2(0.0, 0.0)) == vec2(1.0, 1.0),                       czm_signNotZero(vec2(1.0, 1.0)) == vec2(1.0, 1.0),                       czm_signNotZero(vec2(-1.0, -1.0)) == vec2(-1.0, -1.0),                       czm_signNotZero(vec2(-1.0, 0.0)) == vec2(-1.0, 1.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has signNotZero : vec3", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_signNotZero(vec3(0.0, 0.0, 0.0)) == vec3(1.0, 1.0, 1.0),                       czm_signNotZero(vec3(1.0, 1.0, 1.0)) == vec3(1.0, 1.0, 1.0),                       czm_signNotZero(vec3(-1.0, -1.0, -1.0)) == vec3(-1.0, -1.0, -1.0),                       czm_signNotZero(vec3(-1.0, 0.0, 1.0)) == vec3(-1.0, 1.0, 1.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has signNotZero : vec4", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_signNotZero(vec4(0.0, 0.0, 0.0, 0.0)) == vec4(1.0),                       czm_signNotZero(vec4(1.0, 1.0, 1.0, 1.0)) == vec4(1.0),                       czm_signNotZero(vec4(-1.0, -1.0, -1.0, -1.0)) == vec4(-1.0),                       czm_signNotZero(vec4(-1.0, 0.0, 1.0, -10.0)) == vec4(-1.0, 1.0, 1.0, -1.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_cosineAndSine in all 4 quadrants", function() {
      const fs = "bool isBounded(float value, float min, float max) {   return ((value < max) && (value > min)); }void main() {   out_FragColor = vec4(isBounded(czm_cosineAndSine(czm_piOverFour).x, 0.707106, 0.707107) && isBounded(czm_cosineAndSine(czm_piOverFour).y, 0.707106, 0.707107),                       isBounded(czm_cosineAndSine(czm_pi - czm_piOverFour).x, -0.707107, -0.707106) && isBounded(czm_cosineAndSine(czm_pi - czm_piOverFour).y, 0.707106, 0.707107),                       isBounded(czm_cosineAndSine(-czm_piOverFour).x, 0.707106, 0.707107) && isBounded(czm_cosineAndSine(-czm_piOverFour).y, -0.707107, -0.707106),                       isBounded(czm_cosineAndSine(-czm_pi + czm_piOverFour).x, -0.707107, -0.707106) && isBounded(czm_cosineAndSine(-czm_pi + czm_piOverFour).y, -0.707107, -0.707106)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("can calculate nearFarScalar", function() {
      const fs = "vec4 testNearFarScalar = vec4(10.0, 1.0, 20.0, 0.0);void main() {   out_FragColor = vec4(czm_nearFarScalar(testNearFarScalar, 5.0 * 5.0) == 1.0,                       czm_nearFarScalar(testNearFarScalar, 10.0 * 10.0) == 1.0,                       czm_nearFarScalar(testNearFarScalar, 20.0 * 20.0) == 0.0,                       czm_nearFarScalar(testNearFarScalar, 50.0 * 50.0) == 0.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_cascadeColor", function() {
      const fs = "void main() {   out_FragColor = vec4(all(equal(czm_cascadeColor(vec4(0.5)), vec4(1.0, 0.5, 1.0, 2.0))));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_approximateSphericalCoordinates", function() {
      const fs = "void main() {   out_FragColor = vec4(all(equal(czm_approximateSphericalCoordinates(vec3(1.0, 0.0, 0.0)), vec2(0.0, 0.0))));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_transformPlane", function() {
      const fs = "void main() {   mat4 uniformScale2 = mat4(0.5, 0.0, 0.0, 0.0,                            0.0, 0.5, 0.0, 0.0,                            0.0, 0.0, 0.5, 0.0,                            0.0, 0.0, 0.0, 1.0);  out_FragColor = vec4(all(equal(czm_transformPlane(vec4(1.0, 0.0, 0.0, 10.0), uniformScale2), vec4(1.0, 0.0, 0.0, 20.0))));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_unpackFloat", function() {
      let packed = import__3.Cartesian4.packFloat(1);
      packed = import__3.Cartesian4.divideByScalar(packed, 255, packed);
      const vec4 = `vec4(${packed.x}, ${packed.y}, ${packed.z}, ${packed.w})`;
      const fs = `${"void main() {   out_FragColor = vec4(czm_unpackFloat("}${vec4}));}`;
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_branchFreeTernary", function() {
      let fs = "void main() {   out_FragColor = vec4(czm_branchFreeTernary(true, 1.0, 0.0));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
      fs = "void main() {   out_FragColor = vec4(czm_branchFreeTernary(true, vec2(1.0), vec2(0.0)), 1.0, 1.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
      fs = "void main() {   out_FragColor = vec4(czm_branchFreeTernary(true, vec3(1.0), vec3(0.0)), 1.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
      fs = "void main() {   out_FragColor = czm_branchFreeTernary(true, vec4(1.0), vec4(0.0));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_fastApproximateAtan", function() {
      const fsAtan = "void main() {   out_FragColor = vec4(czm_fastApproximateAtan(0.0) == 0.0);}";
      expect({
        context,
        fragmentShader: fsAtan
      }).contextToRender();
      const fsAtan2 = "void main() {   out_FragColor = vec4(czm_fastApproximateAtan(1.0, 0.0) == 0.0);}";
      expect({
        context,
        fragmentShader: fsAtan2
      }).contextToRender();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/ClearCommandSpec.js
var import__4 = __toESM(require_Cesium(), 1);
describe("Renderer/ClearCommand", function() {
  it("constructs with defaults", function() {
    const c = new import__4.ClearCommand();
    expect(c.color).toBeUndefined();
    expect(c.depth).toBeUndefined();
    expect(c.stencil).toBeUndefined();
    expect(c.renderState).toBeUndefined();
    expect(c.framebuffer).toBeUndefined();
  });
  it("constructs with options", function() {
    const renderState = {};
    const framebuffer2 = {};
    const c = new import__4.ClearCommand({
      color: new import__4.Color(1, 2, 3, 4),
      depth: 1,
      stencil: 2,
      renderState,
      framebuffer: framebuffer2
    });
    expect(c.color).toEqual(new import__4.Color(1, 2, 3, 4));
    expect(c.depth).toEqual(1);
    expect(c.stencil).toEqual(2);
    expect(c.renderState).toBe(renderState);
    expect(c.framebuffer).toBe(framebuffer2);
  });
  it("ClearCommand.ALL to have defaults", function() {
    expect(import__4.ClearCommand.ALL.color).toEqual(new import__4.Color(0, 0, 0, 0));
    expect(import__4.ClearCommand.ALL.depth).toEqual(1);
    expect(import__4.ClearCommand.ALL.stencil).toEqual(0);
    expect(import__4.ClearCommand.ALL.renderState).toBeUndefined();
    expect(import__4.ClearCommand.ALL.framebuffer).toBeUndefined();
  });
});

// packages/engine/Specs/Renderer/ClearSpec.js
var import__5 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Clear",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("default clear", function() {
      import__5.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
    });
    it("clears to white", function() {
      import__5.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__5.ClearCommand({
        color: import__5.Color.WHITE
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("clears with a color mask", function() {
      import__5.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__5.ClearCommand({
        color: import__5.Color.WHITE,
        renderState: import__5.RenderState.fromCache({
          colorMask: {
            red: true,
            green: false,
            blue: true,
            alpha: true
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 0, 255, 255]);
    });
    it("clears with scissor test", function() {
      const command = new import__5.ClearCommand({
        color: import__5.Color.WHITE
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
      command.color = import__5.Color.BLACK;
      command.renderState = import__5.RenderState.fromCache({
        scissorTest: {
          enabled: true,
          rectangle: new import__5.BoundingRectangle()
        }
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
      command.renderState = import__5.RenderState.fromCache({
        scissorTest: {
          enabled: true,
          rectangle: new import__5.BoundingRectangle(0, 0, 1, 1)
        }
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
    });
    it("clears a framebuffer color attachment", function() {
      const colorTexture = new import__5.Texture({
        context,
        width: 1,
        height: 1
      });
      let framebuffer2 = new import__5.Framebuffer({
        context,
        colorTextures: [colorTexture]
      });
      const command = new import__5.ClearCommand({
        color: new import__5.Color(0, 1, 0, 1),
        framebuffer: framebuffer2
      });
      command.execute(context);
      expect({
        context,
        framebuffer: framebuffer2
      }).toReadPixels([0, 255, 0, 255]);
      framebuffer2 = framebuffer2.destroy();
    });
    it("fails to read pixels (width)", function() {
      expect(function() {
        expect(
          context.readPixels({
            width: -1
          })
        ).toEqual([0, 0, 0, 0]);
      }).toThrowDeveloperError();
    });
    it("fails to read pixels (height)", function() {
      expect(function() {
        expect(
          context.readPixels({
            height: -1
          })
        ).toEqual([0, 0, 0, 0]);
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/ComputeCommandSpec.js
var import__6 = __toESM(require_Cesium(), 1);

// Specs/createScene.js
var import_engine6 = __toESM(require_Cesium(), 1);
function createScene(options) {
  options = (0, import_engine6.defaultValue)(options, {});
  const debugWidth = window.debugCanvasWidth;
  const debugHeight = (0, import_engine6.defaultValue)(
    window.debugCanvasHeight,
    window.debugCanvasWidth
  );
  const canvas = (0, import_engine6.defined)(options.canvas) ? options.canvas : createCanvas_default(debugWidth, debugHeight);
  options.canvas = void 0;
  options = (0, import_engine6.clone)(options, true);
  options.canvas = canvas;
  options.contextOptions = (0, import_engine6.defaultValue)(options.contextOptions, {});
  const contextOptions = options.contextOptions;
  contextOptions.webgl = (0, import_engine6.defaultValue)(contextOptions.webgl, {});
  contextOptions.webgl.antialias = (0, import_engine6.defaultValue)(
    contextOptions.webgl.antialias,
    false
  );
  contextOptions.webgl.stencil = (0, import_engine6.defaultValue)(
    contextOptions.webgl.stencil,
    true
  );
  if (!!window.webglStub) {
    contextOptions.getWebGLStub = getWebGLStub_default;
  }
  const scene2 = new import_engine6.Scene(options);
  scene2.highDynamicRange = false;
  if (!!window.webglValidation) {
    const context = scene2.context;
    context.validateShaderProgram = true;
    context.validateFramebuffer = true;
    context.logShaderCompilation = true;
    context.throwOnWebGLError = true;
  }
  scene2.destroyForSpecs = function() {
    const canvas2 = this.canvas;
    this.destroy();
    document.body.removeChild(canvas2);
  };
  scene2.renderForSpecs = function(time2) {
    this.initializeFrame();
    this.render(time2);
  };
  scene2.pickForSpecs = function() {
    this.pick(new import_engine6.Cartesian2(0, 0));
  };
  scene2.rethrowRenderErrors = (0, import_engine6.defaultValue)(options.rethrowRenderErrors, true);
  return scene2;
}
var createScene_default = createScene;

// packages/engine/Specs/Renderer/ComputeCommandSpec.js
describe(
  "Renderer/ComputeCommand",
  function() {
    let scene2;
    let context;
    beforeAll(function() {
      scene2 = createScene_default();
      context = scene2.context;
    });
    afterAll(function() {
      scene2.destroyForSpecs();
    });
    afterEach(function() {
      scene2.primitives.removeAll();
    });
    function CommandMockPrimitive(command) {
      this.update = function(frameState2) {
        frameState2.commandList.push(command);
      };
      this.destroy = function() {
      };
    }
    it("throws if no shader is provided", function() {
      const outputTexture = new import__6.Texture({
        context,
        width: 1,
        height: 1,
        pixelFormat: import__6.PixelFormat.RGBA
      });
      const computeCommand = new import__6.ComputeCommand({
        outputTexture
      });
      scene2.primitives.add(new CommandMockPrimitive(computeCommand));
      expect(function() {
        scene2.renderForSpecs();
      }).toThrowDeveloperError();
    });
    it("throws if no output texture is provided", function() {
      const computeCommand = new import__6.ComputeCommand({
        fragmentShaderSource: "void main() { out_FragColor = vec4(1.0); }"
      });
      scene2.primitives.add(new CommandMockPrimitive(computeCommand));
      expect(function() {
        scene2.renderForSpecs();
      }).toThrowDeveloperError();
    });
    it("renderer resources are preserved or destroyed based on the persists flag", function() {
      const vertexShader = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fragmentShader = "void main() { out_FragColor = vec4(1.0); }";
      const shaderProgram = import__6.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vertexShader,
        fragmentShaderSource: fragmentShader,
        attributeLocations: {
          position: 0
        }
      });
      const vertexArray = new import__6.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__6.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__6.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const outputTexture = new import__6.Texture({
        context,
        width: 1,
        height: 1,
        pixelFormat: import__6.PixelFormat.RGBA
      });
      const computeCommand = new import__6.ComputeCommand({
        vertexArray,
        shaderProgram,
        outputTexture
      });
      computeCommand.persists = true;
      scene2.primitives.add(new CommandMockPrimitive(computeCommand));
      scene2.renderForSpecs();
      context.shaderCache.destroyReleasedShaderPrograms();
      scene2.primitives.removeAll();
      expect(shaderProgram.isDestroyed()).toEqual(false);
      expect(vertexArray.isDestroyed()).toEqual(false);
      expect(outputTexture.isDestroyed()).toEqual(false);
      computeCommand.persists = false;
      scene2.primitives.add(new CommandMockPrimitive(computeCommand));
      scene2.renderForSpecs();
      context.shaderCache.destroyReleasedShaderPrograms();
      scene2.primitives.removeAll();
      expect(shaderProgram.isDestroyed()).toEqual(true);
      expect(vertexArray.isDestroyed()).toEqual(true);
      expect(outputTexture.isDestroyed()).toEqual(false);
    });
    it("renders to a texture and draws that texture to the screen", function() {
      const outputTexture = new import__6.Texture({
        context,
        width: 1,
        height: 1,
        pixelFormat: import__6.PixelFormat.RGBA
      });
      const computeCommand = new import__6.ComputeCommand({
        fragmentShaderSource: "void main() { out_FragColor = vec4(1.0); }",
        outputTexture
      });
      const viewportQuad = new import__6.ViewportQuad();
      viewportQuad.rectangle = new import__6.BoundingRectangle(0, 0, 1, 1);
      viewportQuad.material = import__6.Material.fromType(import__6.Material.ImageType);
      viewportQuad.material.uniforms.image = outputTexture;
      expect(scene2).toRender([0, 0, 0, 255]);
      scene2.primitives.add(new CommandMockPrimitive(computeCommand));
      scene2.primitives.add(viewportQuad);
      expect(scene2).notToRender([0, 0, 0, 255]);
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/ContextSpec.js
var import__7 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Context",
  function() {
    let context;
    const webglStub = !!window.webglStub;
    beforeAll(function() {
      context = createContext_default();
      spyOn(import__7.Context, "_deprecationWarning");
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("has a unique ID", function() {
      const c = createContext_default();
      expect(c.id).toBeDefined();
      expect(c.id).not.toEqual(context.id);
      c.destroyForSpecs();
    });
    it("get canvas", function() {
      expect(context.canvas).not.toBeNull();
    });
    it("get stencilBits", function() {
      expect(context.stencilBits).toBeGreaterThanOrEqual(0);
    });
    it("get maximumCombinedTextureImageUnits", function() {
      expect(
        import__7.ContextLimits.maximumCombinedTextureImageUnits
      ).toBeGreaterThanOrEqual(8);
    });
    it("get maximumCubeMapSize", function() {
      expect(import__7.ContextLimits.maximumCubeMapSize).toBeGreaterThanOrEqual(16);
    });
    it("get maximumFragmentUniformVectors", function() {
      expect(
        import__7.ContextLimits.maximumFragmentUniformVectors
      ).toBeGreaterThanOrEqual(16);
    });
    it("get maximumTextureImageUnits", function() {
      expect(import__7.ContextLimits.maximumTextureImageUnits).toBeGreaterThanOrEqual(8);
    });
    it("get maximumRenderbufferSize", function() {
      expect(import__7.ContextLimits.maximumRenderbufferSize).toBeGreaterThanOrEqual(1);
    });
    it("get maximumTextureSize", function() {
      expect(import__7.ContextLimits.maximumTextureSize).toBeGreaterThanOrEqual(64);
    });
    it("get maximumVaryingVectors", function() {
      expect(import__7.ContextLimits.maximumVaryingVectors).toBeGreaterThanOrEqual(8);
    });
    it("get maximumVertexAttributes", function() {
      expect(import__7.ContextLimits.maximumVertexAttributes).toBeGreaterThanOrEqual(8);
    });
    it("get maximumVertexTextureImageUnits", function() {
      expect(
        import__7.ContextLimits.maximumVertexTextureImageUnits
      ).toBeGreaterThanOrEqual(0);
    });
    it("get maximumVertexUniformVectors", function() {
      expect(import__7.ContextLimits.maximumVertexUniformVectors).toBeGreaterThanOrEqual(
        1
      );
    });
    it("get minimumAliasedLineWidth", function() {
      expect(import__7.ContextLimits.minimumAliasedLineWidth).toBeLessThanOrEqual(1);
    });
    it("get maximumAliasedLineWidth", function() {
      expect(import__7.ContextLimits.maximumAliasedLineWidth).toBeGreaterThanOrEqual(1);
    });
    it("get minimumAliasedPointSize", function() {
      expect(import__7.ContextLimits.minimumAliasedPointSize).toBeLessThanOrEqual(1);
    });
    it("get maximumAliasedPointSize", function() {
      expect(import__7.ContextLimits.maximumAliasedPointSize).toBeGreaterThanOrEqual(1);
    });
    it("get maximumViewportWidth", function() {
      expect(import__7.ContextLimits.maximumViewportWidth).toBeGreaterThan(0);
    });
    it("get maximumViewportHeight", function() {
      expect(import__7.ContextLimits.maximumViewportHeight).toBeGreaterThan(0);
    });
    it("gets antialias", function() {
      const c = createContext_default({
        webgl: {
          antialias: false
        }
      });
      expect(c.antialias).toEqual(false);
      c.destroyForSpecs();
    });
    it("gets the standard derivatives extension", function() {
      let fs = "";
      if (context.standardDerivatives && !context.webgl2) {
        fs += "#extension GL_OES_standard_derivatives : enable\n";
      }
      fs += "void main()\n{\n";
      if (context.standardDerivatives) {
        fs += "  out_FragColor = vec4(dFdx(1.0), dFdy(1.0), 1.0, 1.0);\n";
      } else {
        fs += "  out_FragColor = vec4(1.0);\n";
      }
      fs += "}";
      const expected = context.standardDerivatives ? [0, 0, 255, 255] : [255, 255, 255, 255];
      expect({
        context,
        fragmentShader: fs
      }).contextToRender(expected);
    });
    it("gets the element index uint extension", function() {
      if (context.elementIndexUint) {
        const buffer = import__7.Buffer.createIndexBuffer({
          context,
          sizeInBytes: 6,
          usage: import__7.BufferUsage.STREAM_DRAW,
          indexDatatype: import__7.IndexDatatype.UNSIGNED_INT
        });
        expect(buffer).toBeDefined();
        buffer.destroy();
      } else {
        expect(function() {
          import__7.Buffer.createIndexBuffer({
            context,
            sizeInBytes: 6,
            usage: import__7.BufferUsage.STREAM_DRAW,
            indexDatatype: import__7.IndexDatatype.UNSIGNED_INT
          });
        }).toThrowDeveloperError();
      }
    });
    it("gets the depth texture extension", function() {
      expect(context.depthTexture).toBeDefined();
    });
    it("gets the texture float extension", function() {
      expect(context.floatingPointTexture).toBeDefined();
    });
    it("gets texture filter anisotropic extension", function() {
      expect(context.textureFilterAnisotropic).toBeDefined();
    });
    it("gets texture filter anisotropic extension", function() {
      expect(context.textureFilterAnisotropic).toBeDefined();
    });
    it("gets maximum texture filter anisotropy", function() {
      if (context.textureFilterAnisotropic) {
        expect(
          import__7.ContextLimits.maximumTextureFilterAnisotropy
        ).toBeGreaterThanOrEqual(2);
      } else {
        expect(import__7.ContextLimits.maximumTextureFilterAnisotropy).toEqual(1);
      }
    });
    it("gets vertex array object extension", function() {
      expect(context.vertexArrayObject).toBeDefined();
    });
    it("get the fragment depth extension", function() {
      if (context.fragmentDepth && !context.webgl2) {
        return;
      }
      const fs = "void main()\n{\n  out_FragColor = vec4(1.0, 0.0, 0.0, 1.0);\n}";
      expect({
        context,
        fragmentShader: fs,
        depth: 0.5
      }).contextToRender([255, 0, 0, 255]);
      let fsFragDepth = "#extension GL_EXT_frag_depth : enable\n";
      fsFragDepth += "void main()\n{\n    out_FragColor = vec4(0.0, 1.0, 0.0, 1.0);\n";
      if (context.fragmentDepth) {
        fsFragDepth += "    gl_FragDepth";
        if (!context.webgl2) {
          fsFragDepth += "EXT";
        }
        fsFragDepth += " = 0.0;\n";
      }
      fsFragDepth += "}\n";
      const expected = [0, 255, 0, 255];
      expect({
        context,
        fragmentShader: fsFragDepth,
        depth: 1,
        clear: false
      }).contextToRender(expected);
    });
    it("get the draw buffers extension", function() {
      expect(context.drawBuffers).toBeDefined();
    });
    it("get the maximum number of draw buffers", function() {
      if (context.drawBuffers) {
        expect(import__7.ContextLimits.maximumDrawBuffers).toBeGreaterThanOrEqual(1);
      } else {
        expect(import__7.ContextLimits.maximumDrawBuffers).toEqual(1);
      }
    });
    it("get the maximum number of color attachments", function() {
      if (context.drawBuffers) {
        expect(import__7.ContextLimits.maximumColorAttachments).toBeGreaterThanOrEqual(4);
      } else {
        expect(import__7.ContextLimits.maximumColorAttachments).toEqual(1);
      }
    });
    it("can create a pick ID and retrieve an object by pick color", function() {
      const o = {};
      const pickId = context.createPickId(o);
      expect(pickId).toBeDefined();
      expect(context.getObjectByPickColor(pickId.color)).toBe(o);
    });
    it("throws when creating a pick ID without an object", function() {
      expect(function() {
        context.createPickId(void 0);
      }).toThrowDeveloperError();
    });
    it("returns undefined when retrieving an object by unknown pick color", function() {
      expect(context.getObjectByPickColor(import__7.Color.WHITE)).toBeUndefined();
    });
    it("throws when getObjectByPickColor is called without a color", function() {
      expect(function() {
        context.getObjectByPickColor(void 0);
      }).toThrowDeveloperError();
    });
    it("fails to construct (null canvas)", function() {
      expect(function() {
        return new import__7.Context();
      }).toThrowDeveloperError();
    });
    it("isDestroyed", function() {
      const c = createContext_default();
      expect(c.isDestroyed()).toEqual(false);
      c.destroyForSpecs();
      expect(c.isDestroyed()).toEqual(true);
    });
    it("destroying Context destroys objects in cache", function() {
      const c = createContext_default();
      const destroyableObject = jasmine.createSpyObj("destroyableObject", [
        "destroy"
      ]);
      c.cache.foo = destroyableObject;
      c.destroyForSpecs();
      expect(destroyableObject.destroy).toHaveBeenCalled();
    });
    it("non-destroyable objects are allowed in the cache", function() {
      const c = createContext_default();
      const nonDestroyableObject = {};
      c.cache.foo = nonDestroyableObject;
      c.destroyForSpecs();
    });
    it("returns the underling drawingBufferWidth", function() {
      const c = createContext_default(void 0, 1024, 768);
      expect(c.drawingBufferWidth).toBe(1024);
      c.destroyForSpecs();
    });
    it("returns the underling drawingBufferHeight", function() {
      const c = createContext_default(void 0, 1024, 768);
      expect(c.drawingBufferHeight).toBe(768);
      c.destroyForSpecs();
    });
    it("requestWebgl1 works", function() {
      const c1 = createContext_default({
        requestWebgl1: true
      });
      expect(c1._webgl2).toBe(false);
      if (!webglStub) {
        const c2 = createContext_default({
          requestWebgl1: false
        });
        expect(c2._webgl2).toBe(true);
      }
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/CubeMapSpec.js
var import__8 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/CubeMap",
  function() {
    let context;
    let cubeMap;
    function expectCubeMapFaces(options) {
      const cubeMap2 = options.cubeMap;
      const expectedColors = options.expectedColors;
      const fs = "uniform samplerCube u_texture;uniform mediump vec3 u_direction;void main() { out_FragColor = czm_textureCube(u_texture, normalize(u_direction)); }";
      let faceDirections = options.faceDirections;
      if (!(0, import__8.defined)(faceDirections)) {
        faceDirections = [
          new import__8.Cartesian3(1, 0, 0),
          // +X
          new import__8.Cartesian3(-1, 0, 0),
          // -X
          new import__8.Cartesian3(0, 1, 0),
          // +Y
          new import__8.Cartesian3(0, -1, 0),
          // -Y
          new import__8.Cartesian3(0, 0, 1),
          // +Z
          new import__8.Cartesian3(0, 0, -1)
          // -Z
        ];
      }
      const uniformMap = {
        direction: void 0,
        u_texture: function() {
          return cubeMap2;
        },
        u_direction: function() {
          return this.direction;
        }
      };
      for (let i = 0; i < 6; ++i) {
        uniformMap.direction = faceDirections[i];
        expect({
          context,
          fragmentShader: fs,
          uniformMap,
          epsilon: options.epsilon
        }).contextToRender(expectedColors[i]);
      }
    }
    let greenImage;
    let blueImage;
    let blueAlphaImage;
    let blueOverRedImage;
    let red16x16Image;
    let gammaImage;
    let customColorProfileImage;
    let supportsImageBitmapOptions;
    beforeAll(function() {
      context = createContext_default();
      supportsImageBitmapOptions = import__8.Resource.supportsImageBitmapOptions();
      const promises = [];
      promises.push(
        import__8.Resource.fetchImage("./Data/Images/Green.png").then(function(result) {
          greenImage = result;
        })
      );
      promises.push(
        import__8.Resource.fetchImage("./Data/Images/Blue.png").then(function(result) {
          blueImage = result;
        })
      );
      promises.push(
        import__8.Resource.fetchImage("./Data/Images/BlueAlpha.png").then(function(result) {
          blueAlphaImage = result;
        })
      );
      promises.push(
        import__8.Resource.fetchImage("./Data/Images/BlueOverRed.png").then(function(result) {
          blueOverRedImage = result;
        })
      );
      promises.push(
        import__8.Resource.fetchImage("./Data/Images/Red16x16.png").then(function(result) {
          red16x16Image = result;
        })
      );
      promises.push(
        import__8.Resource.fetchImage("./Data/Images/Gamma.png").then(function(result) {
          gammaImage = result;
        })
      );
      promises.push(
        import__8.Resource.fetchImage("./Data/Images/CustomColorProfile.png").then(
          function(result) {
            customColorProfileImage = result;
          }
        )
      );
      return Promise.all(promises);
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    afterEach(function() {
      cubeMap = cubeMap && cubeMap.destroy();
    });
    it("gets the pixel format", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 16,
        height: 16
      });
      expect(cubeMap.pixelFormat).toEqual(import__8.PixelFormat.RGBA);
      expect(cubeMap.positiveX.pixelFormat).toEqual(import__8.PixelFormat.RGBA);
      expect(cubeMap.negativeX.pixelFormat).toEqual(import__8.PixelFormat.RGBA);
      expect(cubeMap.positiveY.pixelFormat).toEqual(import__8.PixelFormat.RGBA);
      expect(cubeMap.negativeY.pixelFormat).toEqual(import__8.PixelFormat.RGBA);
      expect(cubeMap.positiveZ.pixelFormat).toEqual(import__8.PixelFormat.RGBA);
      expect(cubeMap.negativeZ.pixelFormat).toEqual(import__8.PixelFormat.RGBA);
    });
    it("gets the pixel datatype", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 16,
        height: 16
      });
      expect(cubeMap.pixelDatatype).toEqual(import__8.PixelDatatype.UNSIGNED_BYTE);
      expect(cubeMap.positiveX.pixelDatatype).toEqual(
        import__8.PixelDatatype.UNSIGNED_BYTE
      );
      expect(cubeMap.negativeX.pixelDatatype).toEqual(
        import__8.PixelDatatype.UNSIGNED_BYTE
      );
      expect(cubeMap.positiveY.pixelDatatype).toEqual(
        import__8.PixelDatatype.UNSIGNED_BYTE
      );
      expect(cubeMap.negativeY.pixelDatatype).toEqual(
        import__8.PixelDatatype.UNSIGNED_BYTE
      );
      expect(cubeMap.positiveZ.pixelDatatype).toEqual(
        import__8.PixelDatatype.UNSIGNED_BYTE
      );
      expect(cubeMap.negativeZ.pixelDatatype).toEqual(
        import__8.PixelDatatype.UNSIGNED_BYTE
      );
    });
    it("sets a sampler", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 16,
        height: 16
      });
      const sampler = new import__8.Sampler({
        wrapS: import__8.TextureWrap.REPEAT,
        wrapT: import__8.TextureWrap.MIRRORED_REPEAT,
        minificationFilter: import__8.TextureMinificationFilter.NEAREST,
        magnificationFilter: import__8.TextureMagnificationFilter.NEAREST
      });
      cubeMap.sampler = sampler;
      const s = cubeMap.sampler;
      expect(s.wrapS).toEqual(sampler.wrapS);
      expect(s.wrapT).toEqual(sampler.wrapT);
      expect(s.minificationFilter).toEqual(sampler.minificationFilter);
      expect(s.magnificationFilter).toEqual(sampler.magnificationFilter);
    });
    it("gets width and height", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 16,
        height: 16
      });
      expect(cubeMap.width).toEqual(16);
      expect(cubeMap.height).toEqual(16);
    });
    it("gets size in bytes", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 16,
        height: 16
      });
      expect(cubeMap.sizeInBytes).toEqual(256 * 4 * 6);
    });
    it("gets flip Y", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 16,
        height: 16,
        flipY: true
      });
      expect(cubeMap.flipY).toEqual(true);
    });
    it("draws with a cube map", function() {
      cubeMap = new import__8.CubeMap({
        context,
        source: {
          positiveX: blueImage,
          negativeX: greenImage,
          positiveY: blueImage,
          negativeY: greenImage,
          positiveZ: blueImage,
          negativeZ: greenImage
        }
      });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 0, 255, 255],
          // +X is blue
          [0, 255, 0, 255],
          // -X is green
          [0, 0, 255, 255],
          // +Y is blue
          [0, 255, 0, 255],
          // -Y is green
          [0, 0, 255, 255],
          // +Z is blue
          [0, 255, 0, 255]
          // -Z is green
        ]
      });
    });
    it("draws with a cube map with premultiplied alpha", function() {
      cubeMap = new import__8.CubeMap({
        context,
        source: {
          positiveX: blueAlphaImage,
          negativeX: blueAlphaImage,
          positiveY: blueAlphaImage,
          negativeY: blueAlphaImage,
          positiveZ: blueAlphaImage,
          negativeZ: blueAlphaImage
        },
        preMultiplyAlpha: true
      });
      expect(cubeMap.preMultiplyAlpha).toEqual(true);
      expectCubeMapFaces({
        cubeMap,
        epsilon: 1,
        expectedColors: [
          [0, 0, 127, 255],
          // +X
          [0, 0, 127, 255],
          // -X
          [0, 0, 127, 255],
          // +Y
          [0, 0, 127, 255],
          // -Y
          [0, 0, 127, 255],
          // +Z
          [0, 0, 127, 255]
          // -Z
        ]
      });
    });
    it("draws with a cube map while ignoring color profiles", function() {
      if (!supportsImageBitmapOptions) {
        return;
      }
      cubeMap = new import__8.CubeMap({
        context,
        source: {
          positiveX: gammaImage,
          negativeX: customColorProfileImage,
          positiveY: gammaImage,
          negativeY: customColorProfileImage,
          positiveZ: gammaImage,
          negativeZ: customColorProfileImage
        },
        skipColorSpaceConversion: true
      });
      expectCubeMapFaces({
        cubeMap,
        epsilon: 1,
        expectedColors: [
          [0, 136, 0, 255],
          // +X
          [0, 136, 0, 255],
          // -X
          [0, 136, 0, 255],
          // +Y
          [0, 136, 0, 255],
          // -Y
          [0, 136, 0, 255],
          // +Z
          [0, 136, 0, 255]
          // -Z
        ]
      });
    });
    it("draws with a cube map while allowing color profiles", function() {
      if (!supportsImageBitmapOptions) {
        return;
      }
      cubeMap = new import__8.CubeMap({
        context,
        source: {
          positiveX: gammaImage,
          negativeX: customColorProfileImage,
          positiveY: gammaImage,
          negativeY: customColorProfileImage,
          positiveZ: gammaImage,
          negativeZ: customColorProfileImage
        },
        skipColorSpaceConversion: false
      });
      expectCubeMapFaces({
        cubeMap,
        epsilon: 1,
        expectedColors: [
          [0, 59, 0, 255],
          // +X
          [193, 0, 0, 255],
          // -X
          [0, 59, 0, 255],
          // +Y
          [193, 0, 0, 255],
          // -Y
          [0, 59, 0, 255],
          // +Z
          [193, 0, 0, 255]
          // -Z
        ]
      });
    });
    it("draws the context default cube map", function() {
      expectCubeMapFaces({
        cubeMap: context.defaultCubeMap,
        expectedColors: [
          [255, 255, 255, 255],
          // +X
          [255, 255, 255, 255],
          // -X
          [255, 255, 255, 255],
          // +Y
          [255, 255, 255, 255],
          // -Y
          [255, 255, 255, 255],
          // +Z
          [255, 255, 255, 255]
          // -Z
        ]
      });
    });
    it("creates a cube map with typed arrays", function() {
      cubeMap = new import__8.CubeMap({
        context,
        source: {
          positiveX: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([0, 255, 255, 255])
          },
          negativeX: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([0, 0, 255, 255])
          },
          positiveY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([0, 255, 0, 255])
          },
          negativeY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([255, 0, 0, 255])
          },
          positiveZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([255, 0, 255, 255])
          },
          negativeZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([255, 255, 0, 255])
          }
        }
      });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 255, 255, 255],
          // +X
          [0, 0, 255, 255],
          // -X
          [0, 255, 0, 255],
          // +Y
          [255, 0, 0, 255],
          // -Y
          [255, 0, 255, 255],
          // +Z
          [255, 255, 0, 255]
          // -Z
        ]
      });
    });
    it("creates a cube map with floating-point textures", function() {
      if (!context.floatingPointTexture) {
        return;
      }
      const positiveXColor = new import__8.Color(0, 1, 1, 1);
      const negativeXColor = new import__8.Color(0, 0, 1, 1);
      const positiveYColor = new import__8.Color(0, 1, 0, 1);
      const negativeYColor = new import__8.Color(1, 0, 0, 1);
      const positiveZColor = new import__8.Color(1, 0, 1, 1);
      const negativeZColor = new import__8.Color(1, 1, 0, 1);
      cubeMap = new import__8.CubeMap({
        context,
        source: {
          positiveX: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              positiveXColor.red,
              positiveXColor.green,
              positiveXColor.blue,
              positiveXColor.alpha
            ])
          },
          negativeX: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              negativeXColor.red,
              negativeXColor.green,
              negativeXColor.blue,
              negativeXColor.alpha
            ])
          },
          positiveY: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              positiveYColor.red,
              positiveYColor.green,
              positiveYColor.blue,
              positiveYColor.alpha
            ])
          },
          negativeY: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              negativeYColor.red,
              negativeYColor.green,
              negativeYColor.blue,
              negativeYColor.alpha
            ])
          },
          positiveZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              positiveZColor.red,
              positiveZColor.green,
              positiveZColor.blue,
              positiveZColor.alpha
            ])
          },
          negativeZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              negativeZColor.red,
              negativeZColor.green,
              negativeZColor.blue,
              negativeZColor.alpha
            ])
          }
        },
        pixelDatatype: import__8.PixelDatatype.FLOAT
      });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 255, 255, 255],
          // +X
          [0, 0, 255, 255],
          // -X
          [0, 255, 0, 255],
          // +Y
          [255, 0, 0, 255],
          // -Y
          [255, 0, 255, 255],
          // +Z
          [255, 255, 0, 255]
          // -Z
        ]
      });
    });
    it("creates a cube map with floating-point textures and linear filtering", function() {
      if (!context.floatingPointTexture) {
        return;
      }
      const positiveXColor = new import__8.Color(0, 1, 1, 1);
      const negativeXColor = new import__8.Color(0, 0, 1, 1);
      const positiveYColor = new import__8.Color(0, 1, 0, 1);
      const negativeYColor = new import__8.Color(1, 0, 0, 1);
      const positiveZColor = new import__8.Color(1, 0, 1, 1);
      const negativeZColor = new import__8.Color(1, 1, 0, 1);
      cubeMap = new import__8.CubeMap({
        context,
        source: {
          positiveX: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              positiveXColor.red,
              positiveXColor.green,
              positiveXColor.blue,
              positiveXColor.alpha
            ])
          },
          negativeX: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              negativeXColor.red,
              negativeXColor.green,
              negativeXColor.blue,
              negativeXColor.alpha
            ])
          },
          positiveY: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              positiveYColor.red,
              positiveYColor.green,
              positiveYColor.blue,
              positiveYColor.alpha
            ])
          },
          negativeY: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              negativeYColor.red,
              negativeYColor.green,
              negativeYColor.blue,
              negativeYColor.alpha
            ])
          },
          positiveZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              positiveZColor.red,
              positiveZColor.green,
              positiveZColor.blue,
              positiveZColor.alpha
            ])
          },
          negativeZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              negativeZColor.red,
              negativeZColor.green,
              negativeZColor.blue,
              negativeZColor.alpha
            ])
          }
        },
        pixelDatatype: import__8.PixelDatatype.FLOAT,
        sampler: new import__8.Sampler({
          wrapS: import__8.TextureWrap.CLAMP_TO_EDGE,
          wrapT: import__8.TextureWrap.CLAMP_TO_EDGE,
          minificationFilter: import__8.TextureMinificationFilter.LINEAR,
          magnificationFilter: import__8.TextureMagnificationFilter.LINEAR
        })
      });
      const fs = "uniform samplerCube u_texture;void main() { out_FragColor = czm_textureCube(u_texture, normalize(vec3(1.0, 1.0, 0.0))); }";
      const uniformMap = {
        u_texture: function() {
          return cubeMap;
        }
      };
      if (!context.textureFloatLinear) {
        expect({
          context,
          fragmentShader: fs,
          uniformMap,
          epsilon: 1
        }).contextToRender(positiveYColor.toBytes());
      } else {
        import__8.Color.multiplyByScalar(positiveXColor, 1 - 0.5, positiveXColor);
        import__8.Color.multiplyByScalar(positiveYColor, 0.5, positiveYColor);
        const color = import__8.Color.add(positiveXColor, positiveYColor, positiveXColor);
        expect({
          context,
          fragmentShader: fs,
          uniformMap,
          epsilon: 1
        }).contextToRender(color.toBytes());
      }
    });
    it("creates a cube map with half floating-point textures", function() {
      if (!context.halfFloatingPointTexture) {
        return;
      }
      const positiveXFloats = [12902, 13926, 14541, 15360];
      const negativeXFloats = [13926, 12902, 14541, 15360];
      const positiveYFloats = [14541, 13926, 12902, 15360];
      const negativeYFloats = [12902, 14541, 13926, 15360];
      const positiveZFloats = [13926, 14541, 12902, 15360];
      const negativeZFloats = [14541, 12902, 13926, 15360];
      const positiveXColor = new import__8.Color(0.2, 0.4, 0.6, 1);
      const negativeXColor = new import__8.Color(0.4, 0.2, 0.6, 1);
      const positiveYColor = new import__8.Color(0.6, 0.4, 0.2, 1);
      const negativeYColor = new import__8.Color(0.2, 0.6, 0.4, 1);
      const positiveZColor = new import__8.Color(0.4, 0.6, 0.2, 1);
      const negativeZColor = new import__8.Color(0.6, 0.2, 0.4, 1);
      cubeMap = new import__8.CubeMap({
        context,
        source: {
          positiveX: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(positiveXFloats)
          },
          negativeX: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(negativeXFloats)
          },
          positiveY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(positiveYFloats)
          },
          negativeY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(negativeYFloats)
          },
          positiveZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(positiveZFloats)
          },
          negativeZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(negativeZFloats)
          }
        },
        pixelDatatype: import__8.PixelDatatype.HALF_FLOAT
      });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          positiveXColor.toBytes(),
          negativeXColor.toBytes(),
          positiveYColor.toBytes(),
          negativeYColor.toBytes(),
          positiveZColor.toBytes(),
          negativeZColor.toBytes()
        ]
      });
    });
    it("creates a cube map with half floating-point textures and linear filtering", function() {
      if (!context.halfFloatingPointTexture) {
        return;
      }
      const positiveXFloats = [12902, 13926, 14541, 15360];
      const negativeXFloats = [13926, 12902, 14541, 15360];
      const positiveYFloats = [14541, 13926, 12902, 15360];
      const negativeYFloats = [12902, 14541, 13926, 15360];
      const positiveZFloats = [13926, 14541, 12902, 15360];
      const negativeZFloats = [14541, 12902, 13926, 15360];
      const positiveXColor = new import__8.Color(0.2, 0.4, 0.6, 1);
      const positiveYColor = new import__8.Color(0.6, 0.4, 0.2, 1);
      cubeMap = new import__8.CubeMap({
        context,
        source: {
          positiveX: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(positiveXFloats)
          },
          negativeX: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(negativeXFloats)
          },
          positiveY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(positiveYFloats)
          },
          negativeY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(negativeYFloats)
          },
          positiveZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(positiveZFloats)
          },
          negativeZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(negativeZFloats)
          }
        },
        pixelDatatype: import__8.PixelDatatype.HALF_FLOAT,
        sampler: new import__8.Sampler({
          wrapS: import__8.TextureWrap.CLAMP_TO_EDGE,
          wrapT: import__8.TextureWrap.CLAMP_TO_EDGE,
          minificationFilter: import__8.TextureMinificationFilter.LINEAR,
          magnificationFilter: import__8.TextureMagnificationFilter.LINEAR
        })
      });
      const fs = "uniform samplerCube u_texture;void main() { out_FragColor = czm_textureCube(u_texture, normalize(vec3(1.0, 1.0, 0.0))); }";
      const uniformMap = {
        u_texture: function() {
          return cubeMap;
        }
      };
      if (!context.textureHalfFloatLinear) {
        expect({
          context,
          fragmentShader: fs,
          uniformMap,
          epsilon: 1
        }).contextToRender(positiveYColor.toBytes());
      } else {
        import__8.Color.multiplyByScalar(positiveXColor, 1 - 0.5, positiveXColor);
        import__8.Color.multiplyByScalar(positiveYColor, 0.5, positiveYColor);
        const color = import__8.Color.add(positiveXColor, positiveYColor, positiveXColor);
        expect({
          context,
          fragmentShader: fs,
          uniformMap,
          epsilon: 1
        }).contextToRender(color.toBytes());
      }
    });
    it("creates a cube map with typed arrays and images", function() {
      cubeMap = new import__8.CubeMap({
        context,
        source: {
          positiveX: blueImage,
          negativeX: greenImage,
          positiveY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([0, 255, 0, 255])
          },
          negativeY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([255, 0, 0, 255])
          },
          positiveZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([0, 0, 255, 255])
          },
          negativeZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([255, 255, 0, 255])
          }
        }
      });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 0, 255, 255],
          // +X
          [0, 255, 0, 255],
          // -X
          [0, 255, 0, 255],
          // +Y
          [255, 0, 0, 255],
          // -Y
          [0, 0, 255, 255],
          // +Z
          [255, 255, 0, 255]
          // -Z
        ]
      });
    });
    it("copies to a cube map", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 1,
        height: 1
      });
      cubeMap.positiveX.copyFrom({ source: blueImage });
      cubeMap.negativeX.copyFrom({ source: greenImage });
      cubeMap.positiveY.copyFrom({ source: blueImage });
      cubeMap.negativeY.copyFrom({ source: greenImage });
      cubeMap.positiveZ.copyFrom({ source: blueImage });
      cubeMap.negativeZ.copyFrom({ source: greenImage });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 0, 255, 255],
          // +X
          [0, 255, 0, 255],
          // -X
          [0, 0, 255, 255],
          // +Y
          [0, 255, 0, 255],
          // -Y
          [0, 0, 255, 255],
          // +Z
          [0, 255, 0, 255]
          // -Z
        ]
      });
    });
    it("copies from a typed array", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 1,
        height: 1
      });
      cubeMap.positiveX.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([0, 255, 255, 255])
        }
      });
      cubeMap.negativeX.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([0, 0, 255, 255])
        }
      });
      cubeMap.positiveY.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([0, 255, 0, 255])
        }
      });
      cubeMap.negativeY.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([255, 0, 0, 255])
        }
      });
      cubeMap.positiveZ.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([255, 0, 255, 255])
        }
      });
      cubeMap.negativeZ.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([255, 255, 0, 255])
        }
      });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 255, 255, 255],
          // +X
          [0, 0, 255, 255],
          // -X
          [0, 255, 0, 255],
          // +Y
          [255, 0, 0, 255],
          // -Y
          [255, 0, 255, 255],
          // +Z
          [255, 255, 0, 255]
          // -Z
        ]
      });
    });
    it("sub copies images to a cube map", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 2,
        height: 2
      });
      cubeMap.positiveX.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([0, 255, 255, 255])
        }
      });
      cubeMap.negativeX.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([0, 0, 255, 255])
        }
      });
      cubeMap.positiveY.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([0, 255, 0, 255])
        }
      });
      cubeMap.negativeY.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([255, 0, 0, 255])
        }
      });
      cubeMap.positiveZ.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([255, 0, 255, 255])
        }
      });
      cubeMap.negativeZ.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([0, 255, 0, 255])
        },
        xOffset: 1,
        yOffset: 0
      });
      const negativeZDirection = new import__8.Cartesian3(0.25, 0, -1);
      import__8.Cartesian3.normalize(negativeZDirection, negativeZDirection);
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 64, 64, 255],
          // +X
          [0, 0, 64, 255],
          // -X
          [0, 64, 0, 255],
          // +Y
          [64, 0, 0, 255],
          // -Y
          [64, 0, 64, 255],
          // +Z
          [0, 32, 0, 255]
          // -Z
        ],
        faceDirections: [
          new import__8.Cartesian3(1, 0, 0),
          // +X
          new import__8.Cartesian3(-1, 0, 0),
          // -X
          new import__8.Cartesian3(0, 1, 0),
          // +Y
          new import__8.Cartesian3(0, -1, 0),
          // -Y
          new import__8.Cartesian3(0, 0, 1),
          // +Z
          negativeZDirection
          // -Z
        ]
      });
    });
    it("sub copies array buffers to a cube map", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 2,
        height: 2
      });
      cubeMap.positiveX.copyFrom({
        source: blueImage
      });
      cubeMap.negativeX.copyFrom({
        source: greenImage
      });
      cubeMap.positiveY.copyFrom({
        source: blueImage
      });
      cubeMap.negativeY.copyFrom({
        source: greenImage
      });
      cubeMap.positiveZ.copyFrom({
        source: blueImage
      });
      cubeMap.negativeZ.copyFrom({
        source: greenImage,
        xOffset: 1,
        yOffset: 0
      });
      const negativeZDirection = new import__8.Cartesian3(0.25, 0, -1);
      import__8.Cartesian3.normalize(negativeZDirection, negativeZDirection);
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 0, 64, 255],
          // +X
          [0, 64, 0, 255],
          // -X
          [0, 0, 64, 255],
          // +Y
          [0, 64, 0, 255],
          // -Y
          [0, 0, 64, 255],
          // +Z
          [0, 32, 0, 255]
          // -Z
        ],
        faceDirections: [
          new import__8.Cartesian3(1, 0, 0),
          // +X
          new import__8.Cartesian3(-1, 0, 0),
          // -X
          new import__8.Cartesian3(0, 1, 0),
          // +Y
          new import__8.Cartesian3(0, -1, 0),
          // -Y
          new import__8.Cartesian3(0, 0, 1),
          // +Z
          negativeZDirection
          // -Z
        ]
      });
    });
    it("copies from the framebuffer", function() {
      const cxt = createContext_default({
        webgl: {
          alpha: true
          // Seems to be required for copyFromFramebuffer()
        }
      });
      cubeMap = new import__8.CubeMap({
        context: cxt,
        width: 1,
        height: 1
      });
      cubeMap.positiveX.copyFrom({ source: blueImage });
      const fs = "uniform samplerCube u_cubeMap;void main() { out_FragColor = czm_textureCube(u_cubeMap, vec3(1.0, 0.0, 0.0)); }";
      const uniformMap = {
        u_cubeMap: function() {
          return cubeMap;
        }
      };
      expect({
        context: cxt,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([0, 0, 255, 255]);
      const clearCommand = new import__8.ClearCommand({
        color: new import__8.Color(1, 0, 0, 1)
      });
      clearCommand.execute(cxt);
      expect(cxt).toReadPixels([255, 0, 0, 255]);
      cubeMap.positiveX.copyFromFramebuffer();
      import__8.ClearCommand.ALL.execute(cxt);
      expect(cxt).toReadPixels([0, 0, 0, 0]);
      expect({
        context: cxt,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([255, 0, 0, 255]);
      cxt.destroyForSpecs();
    });
    it("draws with a cube map and a texture", function() {
      cubeMap = new import__8.CubeMap({
        context,
        source: {
          positiveX: greenImage,
          negativeX: greenImage,
          positiveY: greenImage,
          negativeY: greenImage,
          positiveZ: greenImage,
          negativeZ: greenImage
        }
      });
      let texture = new import__8.Texture({
        context,
        source: blueImage
      });
      const fs = "uniform samplerCube u_cubeMap;uniform sampler2D u_texture;void main() { out_FragColor = czm_textureCube(u_cubeMap, vec3(1.0, 0.0, 0.0)) + texture(u_texture, vec2(0.0)); }";
      const uniformMap = {
        u_cubeMap: function() {
          return cubeMap;
        },
        u_texture: function() {
          return texture;
        }
      };
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([0, 255, 255, 255]);
      texture = texture.destroy();
    });
    it("generates mipmaps", function() {
      cubeMap = new import__8.CubeMap({
        context,
        source: {
          positiveX: blueImage,
          negativeX: greenImage,
          positiveY: blueImage,
          negativeY: greenImage,
          positiveZ: blueImage,
          negativeZ: greenImage
        }
      });
      cubeMap.generateMipmap();
      cubeMap.sampler = new import__8.Sampler({
        minificationFilter: import__8.TextureMinificationFilter.NEAREST_MIPMAP_LINEAR
      });
      const fs = "uniform samplerCube u_cubeMap;void main() { out_FragColor = czm_textureCube(u_cubeMap, vec3(1.0, 0.0, 0.0)); }";
      const uniformMap = {
        u_cubeMap: function() {
          return cubeMap;
        }
      };
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([0, 0, 255, 255]);
    });
    it("gets size in bytes for mipmap", function() {
      cubeMap = new import__8.CubeMap({
        context,
        source: {
          positiveX: red16x16Image,
          negativeX: red16x16Image,
          positiveY: red16x16Image,
          negativeY: red16x16Image,
          positiveZ: red16x16Image,
          negativeZ: red16x16Image
        }
      });
      cubeMap.generateMipmap();
      expect(cubeMap.sizeInBytes).toEqualEpsilon(
        (16 * 16 + 8 * 8 + 4 * 4 + 2 * 2 + 1) * 4 * 6,
        10
      );
    });
    it("destroys", function() {
      const c = new import__8.CubeMap({
        context,
        width: 16,
        height: 16
      });
      expect(c.isDestroyed()).toEqual(false);
      c.destroy();
      expect(c.isDestroyed()).toEqual(true);
    });
    it("fails to create (options)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap();
      }).toThrowDeveloperError();
    });
    it("fails to create (source)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (width, no height)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context,
          width: 16
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (width != height)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context,
          width: 16,
          height: 32
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (small width)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context,
          width: 0,
          height: 0
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (large width)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context,
          width: import__8.ContextLimits.maximumCubeMapSize + 1,
          height: import__8.ContextLimits.maximumCubeMapSize + 1
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (PixelFormat)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context,
          width: 16,
          height: 16,
          pixelFormat: "invalid PixelFormat"
        });
      }).toThrowDeveloperError();
    });
    it("throws during creation if pixel format is depth or depth-stencil", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context,
          width: 16,
          height: 16,
          pixelFormat: import__8.PixelFormat.DEPTH_COMPONENT
        });
      }).toThrowDeveloperError();
    });
    it("throws during creation if pixelDatatype is FLOAT, and OES_texture_float is not supported", function() {
      if (!context.floatingPointTexture) {
        expect(function() {
          cubeMap = new import__8.CubeMap({
            context,
            width: 16,
            height: 16,
            pixelDatatype: import__8.PixelDatatype.FLOAT
          });
        }).toThrowDeveloperError();
      }
    });
    it("throws during creation if pixelDatatype is HALF_FLOAT, and OES_texture_half_float is not supported", function() {
      if (!context.halfFloatingPointTexture) {
        expect(function() {
          cubeMap = new import__8.CubeMap({
            context,
            width: 16,
            height: 16,
            pixelDatatype: import__8.PixelDatatype.HALF_FLOAT
          });
        }).toThrowDeveloperError();
      }
    });
    it("fails to create (pixelDatatype)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context,
          width: 16,
          height: 16,
          pixelFormat: import__8.PixelFormat.RGBA,
          pixelDatatype: "invalid pixelDatatype"
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (source)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context,
          source: {}
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (source width and height)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context,
          source: {
            positiveX: greenImage,
            // 1x1
            negativeX: greenImage,
            // 1x1
            positiveY: greenImage,
            // 1x1
            negativeY: greenImage,
            // 1x1
            positiveZ: greenImage,
            // 1x1
            negativeZ: blueOverRedImage
            // 1x2
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to copy from no options", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 16,
        height: 16
      });
      expect(function() {
        cubeMap.positiveX.copyFrom();
      }).toThrowDeveloperError();
    });
    it("fails to copy from no image (source)", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 16,
        height: 16
      });
      expect(function() {
        cubeMap.positiveX.copyFrom({
          xOffset: 0,
          yOffset: 0
        });
      }).toThrowDeveloperError();
    });
    it("fails to copy from an image (xOffset)", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 16,
        height: 16
      });
      const image = new Image();
      expect(function() {
        cubeMap.positiveY.copyFrom({
          source: image,
          xOffset: -1
        });
      }).toThrowDeveloperError();
    });
    it("fails to copy from an image (yOffset)", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 16,
        height: 16
      });
      const image = new Image();
      expect(function() {
        cubeMap.positiveZ.copyFrom({
          source: image,
          xOffset: 0,
          yOffset: -1
        });
      }).toThrowDeveloperError();
    });
    it("fails to copy from an image (width)", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 16,
        height: 16
      });
      const image = new Image();
      image.width = 16 + 1;
      expect(function() {
        cubeMap.negativeX.copyFrom({
          source: image
        });
      }).toThrowDeveloperError();
    });
    it("fails to copy from an image (height)", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 16,
        height: 16
      });
      const image = new Image();
      image.height = 16 + 1;
      expect(function() {
        cubeMap.negativeY.copyFrom({
          source: image
        });
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (invalid data type)", function() {
      if (context.floatingPointTexture) {
        cubeMap = new import__8.CubeMap({
          context,
          width: 1,
          height: 1,
          pixelDatatype: import__8.PixelDatatype.FLOAT
        });
        expect(function() {
          cubeMap.positiveX.copyFromFramebuffer();
        }).toThrowDeveloperError();
      }
    });
    it("fails to copy from the framebuffer (xOffset)", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 1,
        height: 1
      });
      expect(function() {
        cubeMap.positiveX.copyFromFramebuffer(-1);
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (yOffset)", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 1,
        height: 1
      });
      expect(function() {
        cubeMap.positiveY.copyFromFramebuffer(0, -1);
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (framebufferXOffset)", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 1,
        height: 1
      });
      expect(function() {
        cubeMap.positiveZ.copyFromFramebuffer(0, 0, -1);
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (framebufferYOffset)", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 1,
        height: 1
      });
      expect(function() {
        cubeMap.negativeX.copyFromFramebuffer(0, 0, 0, -1);
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (width)", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 1,
        height: 1
      });
      expect(function() {
        cubeMap.negativeY.copyFromFramebuffer(0, 0, 0, 0, cubeMap.width + 1);
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (height)", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 1,
        height: 1
      });
      expect(function() {
        cubeMap.negativeZ.copyFromFramebuffer(
          0,
          0,
          0,
          0,
          0,
          cubeMap.height + 1
        );
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (FLOAT", function() {
      if (!context.floatingPointTexture) {
        return;
      }
      cubeMap = new import__8.CubeMap({
        context,
        width: 1,
        height: 1,
        pixelDatatype: import__8.PixelDatatype.FLOAT
      });
      expect(function() {
        cubeMap.negativeX.copyFromFramebuffer(0, 0, 0, 0, 0, 0);
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (HALF_FLOAT", function() {
      if (!context.halfFloatingPointTexture) {
        return;
      }
      cubeMap = new import__8.CubeMap({
        context,
        width: 1,
        height: 1,
        pixelDatatype: import__8.PixelDatatype.HALF_FLOAT
      });
      expect(function() {
        cubeMap.negativeX.copyFromFramebuffer(0, 0, 0, 0, 0, 0);
      }).toThrowDeveloperError();
    });
    it("fails to generate mipmaps (width)", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 3,
        height: 3
      });
      expect(function() {
        cubeMap.generateMipmap();
      }).toThrowDeveloperError();
    });
    it("fails to generate mipmaps (hint)", function() {
      cubeMap = new import__8.CubeMap({
        context,
        width: 16,
        height: 16
      });
      expect(function() {
        cubeMap.generateMipmap("invalid hint");
      }).toThrowDeveloperError();
    });
    it("fails to destroy", function() {
      const c = new import__8.CubeMap({
        context,
        width: 16,
        height: 16
      });
      c.destroy();
      expect(function() {
        c.destroy();
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/DrawCommandSpec.js
var import__9 = __toESM(require_Cesium(), 1);
describe("Renderer/DrawCommand", function() {
  it("constructs", function() {
    const c = new import__9.DrawCommand();
    expect(c.boundingVolume).toBeUndefined();
    expect(c.orientedBoundingBox).toBeUndefined();
    expect(c.cull).toEqual(true);
    expect(c.occlude).toEqual(true);
    expect(c.modelMatrix).toBeUndefined();
    expect(c.primitiveType).toEqual(import__9.PrimitiveType.TRIANGLES);
    expect(c.vertexArray).toBeUndefined();
    expect(c.count).toBeUndefined();
    expect(c.offset).toEqual(0);
    expect(c.instanceCount).toEqual(0);
    expect(c.shaderProgram).toBeUndefined();
    expect(c.uniformMap).toBeUndefined();
    expect(c.renderState).toBeUndefined();
    expect(c.framebuffer).toBeUndefined();
    expect(c.pass).toBeUndefined();
    expect(c.executeInClosestFrustum).toEqual(false);
    expect(c.owner).toBeUndefined();
    expect(c.debugShowBoundingVolume).toEqual(false);
    expect(c.debugOverlappingFrustums).toEqual(0);
    expect(c.castShadows).toEqual(false);
    expect(c.receiveShadows).toEqual(false);
    expect(c.pickId).toBeUndefined();
    expect(c.pickOnly).toBe(false);
  });
  it("constructs with options", function() {
    const boundingVolume = {};
    const orientedBoundingBox = {};
    const modelMatrix = {};
    const primitiveType = import__9.PrimitiveType.TRIANGLE_FAN;
    const vertexArray = {};
    const shaderProgram = {};
    const uniformMap = {};
    const renderState = {};
    const framebuffer2 = {};
    const pass = import__9.Pass.TRANSLUCENT;
    const owner = {};
    const pickId = {};
    const c = new import__9.DrawCommand({
      boundingVolume,
      orientedBoundingBox,
      cull: false,
      occlude: false,
      modelMatrix,
      primitiveType,
      vertexArray,
      count: 3,
      offset: 3,
      instanceCount: 2,
      shaderProgram,
      uniformMap,
      renderState,
      framebuffer: framebuffer2,
      pass,
      executeInClosestFrustum: true,
      owner,
      debugShowBoundingVolume: true,
      castShadows: true,
      receiveShadows: true,
      pickId,
      pickOnly: true
    });
    expect(c.boundingVolume).toBe(boundingVolume);
    expect(c.orientedBoundingBox).toBe(orientedBoundingBox);
    expect(c.cull).toEqual(false);
    expect(c.occlude).toEqual(false);
    expect(c.modelMatrix).toBe(modelMatrix);
    expect(c.primitiveType).toEqual(primitiveType);
    expect(c.vertexArray).toBe(vertexArray);
    expect(c.count).toEqual(3);
    expect(c.offset).toEqual(3);
    expect(c.instanceCount).toEqual(2);
    expect(c.shaderProgram).toBe(shaderProgram);
    expect(c.uniformMap).toBe(uniformMap);
    expect(c.renderState).toBe(renderState);
    expect(c.framebuffer).toBe(framebuffer2);
    expect(c.pass).toEqual(pass);
    expect(c.executeInClosestFrustum).toEqual(true);
    expect(c.owner).toBe(owner);
    expect(c.debugShowBoundingVolume).toEqual(true);
    expect(c.debugOverlappingFrustums).toEqual(0);
    expect(c.castShadows).toEqual(true);
    expect(c.receiveShadows).toEqual(true);
    expect(c.pickId).toBe(pickId);
    expect(c.pickOnly).toEqual(true);
  });
  it("shallow clones", function() {
    const c = new import__9.DrawCommand({
      boundingVolume: {},
      orientedBoundingBox: {},
      cull: false,
      occlude: false,
      modelMatrix: {},
      primitiveType: import__9.PrimitiveType.TRIANGLE_FAN,
      vertexArray: {},
      count: 3,
      offset: 3,
      instanceCount: 2,
      shaderProgram: {},
      uniformMap: {},
      renderState: {},
      framebuffer: {},
      pass: import__9.Pass.TRANSLUCENT,
      executeInClosestFrustum: true,
      owner: {},
      debugShowBoundingVolume: true,
      castShadows: true,
      receiveShadows: true,
      pickId: {},
      pickOnly: true
    });
    const clone22 = import__9.DrawCommand.shallowClone(c);
    expect(clone22.boundingVolume).toBe(c.boundingVolume);
    expect(clone22.orientedBoundingBox).toBe(c.orientedBoundingBox);
    expect(clone22.cull).toEqual(c.cull);
    expect(clone22.occlude).toEqual(c.occlude);
    expect(clone22.modelMatrix).toBe(c.modelMatrix);
    expect(clone22.primitiveType).toEqual(c.primitiveType);
    expect(clone22.vertexArray).toBe(c.vertexArray);
    expect(clone22.count).toEqual(c.count);
    expect(clone22.offset).toEqual(c.offset);
    expect(clone22.instanceCount).toEqual(c.instanceCount);
    expect(clone22.shaderProgram).toBe(c.shaderProgram);
    expect(clone22.uniformMap).toBe(c.uniformMap);
    expect(clone22.renderState).toBe(c.renderState);
    expect(clone22.framebuffer).toBe(c.framebuffer);
    expect(clone22.pass).toEqual(c.pass);
    expect(clone22.executeInClosestFrustum).toEqual(c.executeInClosestFrustum);
    expect(clone22.owner).toBe(c.owner);
    expect(clone22.debugShowBoundingVolume).toEqual(c.debugShowBoundingVolume);
    expect(clone22.debugOverlappingFrustums).toEqual(c.debugOverlappingFrustums);
    expect(clone22.castShadows).toEqual(c.castShadows);
    expect(clone22.receiveShadows).toEqual(c.receiveShadows);
    expect(clone22.pickId).toBe(c.pickId);
    expect(clone22.pickOnly).toBe(c.pickOnly);
  });
  it("shallow clones with result", function() {
    const c = new import__9.DrawCommand({
      boundingVolume: {},
      orientedBoundingBox: {},
      cull: false,
      occlude: false,
      modelMatrix: {},
      primitiveType: import__9.PrimitiveType.TRIANGLE_FAN,
      vertexArray: {},
      count: 3,
      offset: 3,
      instanceCount: 2,
      shaderProgram: {},
      uniformMap: {},
      renderState: {},
      framebuffer: {},
      pass: import__9.Pass.TRANSLUCENT,
      executeInClosestFrustum: true,
      owner: {},
      debugShowBoundingVolume: true,
      castShadows: true,
      receiveShadows: true,
      pickId: {},
      pickOnly: true
    });
    const result = new import__9.DrawCommand();
    const clone22 = import__9.DrawCommand.shallowClone(c, result);
    expect(result).toBe(clone22);
    expect(clone22.boundingVolume).toBe(c.boundingVolume);
    expect(clone22.orientedBoundingBox).toBe(c.orientedBoundingBox);
    expect(clone22.cull).toEqual(c.cull);
    expect(clone22.occlude).toEqual(c.occlude);
    expect(clone22.modelMatrix).toBe(c.modelMatrix);
    expect(clone22.primitiveType).toEqual(c.primitiveType);
    expect(clone22.vertexArray).toBe(c.vertexArray);
    expect(clone22.count).toEqual(c.count);
    expect(clone22.offset).toEqual(c.offset);
    expect(clone22.instanceCount).toEqual(c.instanceCount);
    expect(clone22.shaderProgram).toBe(c.shaderProgram);
    expect(clone22.uniformMap).toBe(c.uniformMap);
    expect(clone22.renderState).toBe(c.renderState);
    expect(clone22.framebuffer).toBe(c.framebuffer);
    expect(clone22.pass).toEqual(c.pass);
    expect(clone22.executeInClosestFrustum).toEqual(c.executeInClosestFrustum);
    expect(clone22.owner).toBe(c.owner);
    expect(clone22.debugShowBoundingVolume).toEqual(c.debugShowBoundingVolume);
    expect(clone22.debugOverlappingFrustums).toEqual(c.debugOverlappingFrustums);
    expect(clone22.castShadows).toEqual(c.castShadows);
    expect(clone22.receiveShadows).toEqual(c.receiveShadows);
    expect(clone22.pickId).toBe(c.pickId);
    expect(clone22.pickOnly).toBe(c.pickOnly);
  });
  it("shallow clone returns undefined", function() {
    expect(import__9.DrawCommand.shallowClone()).toBeUndefined();
  });
});

// packages/engine/Specs/Renderer/DrawSpec.js
var import__10 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Draw",
  function() {
    let context;
    let sp;
    let va;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    afterEach(function() {
      sp = sp && sp.destroy();
      va = va && va.destroy();
    });
    it("draws a white point", function() {
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("draws a white point with an index buffer", function() {
      const context2 = createContext_default();
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context: context2,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      const indexBuffer = import__10.Buffer.createIndexBuffer({
        context: context2,
        typedArray: new Uint16Array([0, 0]),
        usage: import__10.BufferUsage.STATIC_DRAW,
        indexDatatype: import__10.IndexDatatype.UNSIGNED_SHORT
      });
      va = new import__10.VertexArray({
        context: context2,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context: context2,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ],
        indexBuffer
      });
      import__10.ClearCommand.ALL.execute(context2);
      expect(context2).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va
      });
      command.execute(context2);
      expect(context2).toReadPixels([255, 255, 255, 255]);
      sp = sp.destroy();
      va = va.destroy();
      context2.destroyForSpecs();
    });
    it("draws a red point with two vertex buffers", function() {
      const vs = "in vec4 position;in mediump float intensity;out mediump float fs_intensity;void main() {  gl_PointSize = 1.0;   gl_Position = position;  fs_intensity = intensity;}";
      const fs = "in mediump float fs_intensity; void main() { out_FragColor = vec4(fs_intensity, 0.0, 0.0, 1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0,
          intensity: 1
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          },
          {
            index: 1,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 1
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va
      });
      command.execute(context);
      expect(context).toReadPixels([255, 0, 0, 255]);
    });
    it("draws a red point with one interleaved vertex buffers", function() {
      const vs = "in vec4 position;in mediump float intensity;out mediump float fs_intensity;void main() {  gl_PointSize = 1.0;   gl_Position = position;  fs_intensity = intensity;}";
      const fs = "in mediump float fs_intensity; void main() { out_FragColor = vec4(fs_intensity, 0.0, 0.0, 1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0,
          intensity: 1
        }
      });
      const stride = 5 * Float32Array.BYTES_PER_ELEMENT;
      const vertexBuffer = import__10.Buffer.createVertexBuffer({
        context,
        typedArray: new Float32Array([0, 0, 0, 1, 1]),
        usage: import__10.BufferUsage.STATIC_DRAW
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer,
            componentsPerAttribute: 4,
            offsetInBytes: 0,
            strideInBytes: stride
          },
          {
            index: 1,
            vertexBuffer,
            componentsPerAttribute: 1,
            offsetInBytes: 4 * Float32Array.BYTES_PER_ELEMENT,
            strideInBytes: stride
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va
      });
      command.execute(context);
      expect(context).toReadPixels([255, 0, 0, 255]);
    });
    it("draws with scissor test", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          scissorTest: {
            enabled: true,
            rectangle: new import__10.BoundingRectangle(1, 1, 0, 0)
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          scissorTest: {
            enabled: true,
            rectangle: new import__10.BoundingRectangle(0, 0, 1, 1)
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with color mask", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          colorMask: {
            red: true,
            green: false,
            blue: false,
            alpha: false
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          colorMask: {
            red: false,
            green: false,
            blue: true,
            alpha: false
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 0, 255, 255]);
    });
    it("draws with additive blending", function() {
      const cxt = createContext_default({
        webgl: {
          alpha: true
        }
      });
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(0.5); }";
      const sp2 = import__10.ShaderProgram.fromCache({
        context: cxt,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      const va2 = new import__10.VertexArray({
        context: cxt,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context: cxt,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(cxt);
      expect(cxt).toReadPixels([0, 0, 0, 0]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp2,
        vertexArray: va2,
        renderState: import__10.RenderState.fromCache({
          blending: {
            enabled: true,
            equationRgb: import__10.WebGLConstants.FUNC_ADD,
            // Optional, default
            equationAlpha: import__10.WebGLConstants.FUNC_ADD,
            // Optional, default
            functionSourceRgb: import__10.WebGLConstants.ONE,
            // Optional, default
            functionSourceAlpha: import__10.WebGLConstants.ONE,
            // Optional, default
            functionDestinationRgb: import__10.WebGLConstants.ONE,
            functionDestinationAlpha: import__10.WebGLConstants.ONE
          }
        })
      });
      command.execute(cxt);
      expect({
        context: cxt,
        epsilon: 1
      }).toReadPixels([127, 127, 127, 127]);
      command.execute(cxt);
      expect({
        context: cxt,
        epsilon: 1
      }).toReadPixels([254, 254, 254, 254]);
      sp2.destroy();
      va2.destroy();
      cxt.destroyForSpecs();
    });
    it("draws with alpha blending", function() {
      const cxt = createContext_default({
        webgl: {
          alpha: true
        }
      });
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0, 1.0, 1.0, 0.5); }";
      const sp2 = import__10.ShaderProgram.fromCache({
        context: cxt,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      const va2 = new import__10.VertexArray({
        context: cxt,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context: cxt,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(cxt);
      expect(cxt).toReadPixels([0, 0, 0, 0]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp2,
        vertexArray: va2,
        renderState: import__10.RenderState.fromCache({
          blending: {
            enabled: true,
            equationRgb: import__10.WebGLConstants.FUNC_ADD,
            equationAlpha: import__10.WebGLConstants.FUNC_SUBTRACT,
            // does not actually matter
            functionSourceRgb: import__10.WebGLConstants.SRC_ALPHA,
            functionSourceAlpha: import__10.WebGLConstants.ONE,
            // Don't blend alpha
            functionDestinationRgb: import__10.WebGLConstants.ONE_MINUS_SRC_ALPHA,
            functionDestinationAlpha: import__10.WebGLConstants.ZERO
          }
        })
      });
      command.execute(cxt);
      expect({
        context: cxt,
        epsilon: 1
      }).toReadPixels([127, 127, 127, 127]);
      command.execute(cxt);
      expect({
        context: cxt,
        epsilon: 2
      }).toReadPixels([191, 191, 191, 127]);
      sp2.destroy();
      va2.destroy();
      cxt.destroyForSpecs();
    });
    it("draws with blend color", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0, 1.0, 1.0, 1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          blending: {
            enabled: true,
            color: {
              red: 0.5,
              green: 0.5,
              blue: 0.5,
              alpha: 0.5
            },
            equationRgb: import__10.WebGLConstants.FUNC_SUBTRACT,
            equationAlpha: import__10.WebGLConstants.FUNC_SUBTRACT,
            functionSourceRgb: import__10.WebGLConstants.CONSTANT_COLOR,
            functionSourceAlpha: import__10.WebGLConstants.ONE,
            functionDestinationRgb: import__10.WebGLConstants.ZERO,
            functionDestinationAlpha: import__10.WebGLConstants.ZERO
          }
        })
      });
      command.execute(context);
      expect({
        context,
        epsilon: 1
      }).toReadPixels([128, 128, 128, 255]);
    });
    it("draws with culling", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([
                -1e3,
                -1e3,
                0,
                1,
                1e3,
                -1e3,
                0,
                1,
                -1e3,
                1e3,
                0,
                1,
                1e3,
                1e3,
                0,
                1
              ]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          cull: {
            enabled: true,
            face: import__10.WebGLConstants.FRONT
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          cull: {
            enabled: true,
            face: import__10.WebGLConstants.BACK
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with front face winding order", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([
                -1e3,
                -1e3,
                0,
                1,
                1e3,
                -1e3,
                0,
                1,
                -1e3,
                1e3,
                0,
                1,
                1e3,
                1e3,
                0,
                1
              ]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          frontFace: import__10.WindingOrder.CLOCKWISE,
          cull: {
            enabled: true,
            face: import__10.WebGLConstants.BACK
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          frontFace: import__10.WindingOrder.COUNTER_CLOCKWISE,
          cull: {
            enabled: true,
            face: import__10.WebGLConstants.BACK
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with the depth test", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([
                -1e3,
                -1e3,
                0,
                1,
                1e3,
                -1e3,
                0,
                1,
                -1e3,
                1e3,
                0,
                1,
                1e3,
                1e3,
                0,
                1
              ]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          depthTest: {
            enabled: true,
            func: import__10.WebGLConstants.LEQUAL
          }
        })
      });
      const clearCommand = new import__10.ClearCommand({
        color: new import__10.Color(0, 0, 0, 0),
        depth: 1
      });
      clearCommand.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
      clearCommand.color = new import__10.Color(0, 0, 0, 0);
      clearCommand.depth = 0;
      clearCommand.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
    });
    it("draws with depth range", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(gl_DepthRange.near, gl_DepthRange.far, 0.0, 1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          depthRange: {
            near: 0.25,
            far: 0.75
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([64, 191, 0, 255]);
    });
    it("draws with line width", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([
                -1e3,
                -1e3,
                0,
                1,
                1e3,
                1e3,
                0,
                1
              ]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.LINES,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          lineWidth: import__10.ContextLimits.maximumAliasedLineWidth
          // May only be 1.
        })
      });
      command.execute(context);
      expect(context).notToReadPixels([0, 0, 0, 255]);
    });
    it("draws with polygon offset", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          polygonOffset: {
            enabled: true,
            factor: 1,
            units: 1
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with sample coverage", function() {
      if (!context.antialias) {
        return;
      }
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          sampleCoverage: {
            enabled: true,
            value: 0,
            invert: false
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          sampleCoverage: {
            enabled: false
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with stencil test (front)", function() {
      if (context.stencilBits === 0) {
        return;
      }
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([
                -1e3,
                -1e3,
                0,
                1,
                1e3,
                -1e3,
                0,
                1,
                -1e3,
                1e3,
                0,
                1,
                1e3,
                1e3,
                0,
                1
              ]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const rs = import__10.RenderState.fromCache({
        stencilTest: {
          enabled: true,
          frontFunction: import__10.WebGLConstants.EQUAL,
          reference: 1,
          mask: 1
        }
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: rs
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          colorMask: {
            red: false,
            green: false,
            blue: false,
            alpha: false
          },
          stencilTest: {
            enabled: true,
            frontOperation: {
              zPass: import__10.WebGLConstants.INCR
            }
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: rs
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with stencil test (back)", function() {
      if (context.stencilBits === 0) {
        return;
      }
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([
                -1e3,
                -1e3,
                0,
                1,
                1e3,
                -1e3,
                0,
                1,
                -1e3,
                1e3,
                0,
                1,
                1e3,
                1e3,
                0,
                1
              ]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const rs = import__10.RenderState.fromCache({
        frontFace: import__10.WindingOrder.CLOCKWISE,
        stencilTest: {
          enabled: true,
          backFunction: import__10.WebGLConstants.NOTEQUAL,
          reference: 0
        }
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: rs
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          frontFace: import__10.WindingOrder.CLOCKWISE,
          colorMask: {
            red: false,
            green: false,
            blue: false,
            alpha: false
          },
          stencilTest: {
            enabled: true,
            backOperation: {
              zPass: import__10.WebGLConstants.INVERT
            }
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: rs
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with an offset and count", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, -1, 0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        offset: 0,
        count: 1,
        shaderProgram: sp,
        vertexArray: va
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        offset: 1,
        count: 1,
        shaderProgram: sp,
        vertexArray: va
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws two instances of a point with different per-instance colors", function() {
      const vs = "in vec4 position;in vec4 color;out vec4 v_color;void main() {  gl_PointSize = 1.0;   gl_Position = position;  v_color = color;}";
      const fs = "in vec4 v_color; void main() { out_FragColor = v_color; }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0,
          color: 1
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          },
          {
            index: 1,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Uint8Array([255, 0, 0, 255, 0, 255, 0, 255]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentDatatype: import__10.ComponentDatatype.UNSIGNED_BYTE,
            componentsPerAttribute: 4,
            normalize: true,
            instanceDivisor: 1
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        instanceCount: 2,
        renderState: import__10.RenderState.fromCache({
          blending: import__10.BlendingState.ADDITIVE_BLEND
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 0, 255]);
    });
    it("fails to draw (missing command)", function() {
      expect(function() {
        context.draw();
      }).toThrowDeveloperError();
    });
    it("fails to draw (missing shaderProgram)", function() {
      expect(function() {
        context.draw({
          primitiveType: import__10.PrimitiveType.POINTS
        });
      }).toThrowDeveloperError();
    });
    it("fails to draw (missing primitiveType)", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      expect(function() {
        context.draw({
          shaderProgram: sp
        });
      }).toThrowDeveloperError();
    });
    it("fails to draw (primitiveType)", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      expect(function() {
        context.draw({
          primitiveType: "invalid value",
          shaderProgram: sp
        });
      }).toThrowDeveloperError();
    });
    it("fails to draw (missing vertexArray)", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      expect(function() {
        context.draw({
          primitiveType: import__10.PrimitiveType.POINTS,
          shaderProgram: sp
        });
      }).toThrowDeveloperError();
    });
    it("fails to draw (negative offset)", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      expect(function() {
        context.draw({
          primitiveType: import__10.PrimitiveType.POINTS,
          shaderProgram: sp,
          vertexArray: new import__10.VertexArray({
            context
          }),
          offset: -1,
          count: 1
        });
      }).toThrowDeveloperError();
    });
    it("throws if instanceCount is less than one", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        instanceCount: -1
      });
      expect(function() {
        command.execute(context);
      }).toThrowDeveloperError();
    });
    describe("WebGL1", function() {
      let webgl1Context;
      beforeAll(() => {
        webgl1Context = createContext_default({
          requestWebgl1: true
        });
      });
      afterAll(() => {
        webgl1Context.destroyForSpecs();
      });
      it("throws when instanceCount is greater than one and instancing is disabled", function() {
        const webgl1Context2 = createContext_default({
          requestWebgl1: true
        });
        const instancedArrays = webgl1Context2._instancedArrays;
        webgl1Context2._instancedArrays = void 0;
        const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
        const fs = "void main() { out_FragColor = vec4(1.0); }";
        sp = import__10.ShaderProgram.fromCache({
          context: webgl1Context2,
          vertexShaderSource: vs,
          fragmentShaderSource: fs,
          attributeLocations: {
            position: 0
          }
        });
        va = new import__10.VertexArray({
          context: webgl1Context2,
          attributes: [
            {
              index: 0,
              vertexBuffer: import__10.Buffer.createVertexBuffer({
                context: webgl1Context2,
                typedArray: new Float32Array([0, 0, 0, 1]),
                usage: import__10.BufferUsage.STATIC_DRAW
              }),
              componentsPerAttribute: 4
            }
          ]
        });
        const command = new import__10.DrawCommand({
          primitiveType: import__10.PrimitiveType.POINTS,
          shaderProgram: sp,
          vertexArray: va,
          instanceCount: 2
        });
        expect(function() {
          command.execute(webgl1Context2);
        }).toThrowDeveloperError();
        context._instancedArrays = instancedArrays;
      });
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/FramebufferManagerSpec.js
var import__11 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/FramebufferManager",
  function() {
    let context;
    let fbm;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    afterEach(function() {
      if ((0, import__11.defined)(fbm)) {
        fbm.destroy();
      }
    });
    it("throws when constructor has no enabled attachments", function() {
      expect(function() {
        fbm = new import__11.FramebufferManager({
          color: false
        });
      }).toThrowDeveloperError();
    });
    it("throws when constructor enables depth and depth-stencil attachments", function() {
      expect(function() {
        fbm = new import__11.FramebufferManager({
          depth: true,
          depthStencil: true
        });
      }).toThrowDeveloperError();
    });
    it("throws if update is called without width or height", function() {
      fbm = new import__11.FramebufferManager();
      expect(function() {
        fbm.update(context);
      }).toThrowDeveloperError();
      expect(function() {
        fbm.update(context, 1);
      }).toThrowDeveloperError();
      expect(function() {
        fbm.update(context, void 0, 1);
      }).toThrowDeveloperError();
    });
    it("throws if getting color texture at an invalid index", function() {
      fbm = new import__11.FramebufferManager({
        colorAttachmentsLength: 2,
        createColorAttachments: false
      });
      expect(function() {
        fbm.getColorTexture(2);
      }).toThrowDeveloperError();
    });
    it("throws if setting color texture when createColorAttachments is true", function() {
      fbm = new import__11.FramebufferManager();
      expect(function() {
        fbm.setColorTexture();
      }).toThrowDeveloperError();
    });
    it("throws if setting color texture at an invalid index", function() {
      fbm = new import__11.FramebufferManager({
        colorAttachmentsLength: 2,
        createColorAttachments: false
      });
      expect(function() {
        fbm.setColorTexture({}, 2);
      }).toThrowDeveloperError();
    });
    it("sets color textures", function() {
      fbm = new import__11.FramebufferManager({
        colorAttachmentsLength: 2,
        createColorAttachments: false
      });
      const texture0 = new import__11.Texture({
        context,
        width: 1,
        height: 1,
        pixelFormat: import__11.PixelFormat.RGB
      });
      const texture1 = new import__11.Texture({
        context,
        width: 1,
        height: 1,
        pixelFormat: import__11.PixelFormat.RGBA
      });
      fbm.setColorTexture(texture0, 0);
      fbm.setColorTexture(texture1, 1);
      expect(fbm._colorTextures.length).toEqual(2);
      expect(fbm.getColorTexture(0)).toEqual(texture0);
      expect(fbm.getColorTexture(1)).toEqual(texture1);
      texture0.destroy();
      texture1.destroy();
    });
    it("throws if setting depth attachments when createDepthAttachments is true", function() {
      fbm = new import__11.FramebufferManager();
      expect(function() {
        fbm.setDepthTexture();
      }).toThrowDeveloperError();
      expect(function() {
        fbm.setDepthRenderbuffer();
      }).toThrowDeveloperError();
    });
    it("sets depth attachments", function() {
      fbm = new import__11.FramebufferManager({
        createDepthAttachments: false
      });
      const texture = new import__11.Texture({
        context,
        width: 1,
        height: 1
      });
      fbm.setDepthTexture(texture);
      expect(fbm.getDepthTexture()).toBeDefined();
      expect(fbm.getDepthTexture()).toEqual(texture);
      texture.destroy();
      const renderbuffer = new import__11.Renderbuffer({
        context,
        width: 1,
        height: 1
      });
      fbm.setDepthRenderbuffer(renderbuffer);
      expect(fbm.getDepthRenderbuffer()).toBeDefined();
      expect(fbm.getDepthRenderbuffer()).toEqual(renderbuffer);
      renderbuffer.destroy();
    });
    it("throws if setting depth-stencil attachments when createDepthStencilAttachments is true", function() {
      fbm = new import__11.FramebufferManager();
      expect(function() {
        fbm.setDepthStencilTexture();
      }).toThrowDeveloperError();
      expect(function() {
        fbm.setDepthStencilRenderbuffer();
      }).toThrowDeveloperError();
    });
    it("sets depth-stencil attachments", function() {
      fbm = new import__11.FramebufferManager({
        createDepthAttachments: false
      });
      const texture = new import__11.Texture({
        context,
        width: 1,
        height: 1
      });
      fbm.setDepthStencilTexture(texture);
      expect(fbm.getDepthStencilTexture()).toBeDefined();
      expect(fbm.getDepthStencilTexture()).toEqual(texture);
      texture.destroy();
      const renderbuffer = new import__11.Renderbuffer({
        context,
        width: 1,
        height: 1
      });
      fbm.setDepthStencilRenderbuffer(renderbuffer);
      expect(fbm.getDepthStencilRenderbuffer()).toBeDefined();
      expect(fbm.getDepthStencilRenderbuffer()).toEqual(renderbuffer);
      renderbuffer.destroy();
    });
    it("creates framebuffer", function() {
      fbm = new import__11.FramebufferManager();
      expect(fbm.framebuffer).toBeUndefined();
      fbm.update(context, 1, 1);
      const framebuffer2 = fbm.framebuffer;
      expect(framebuffer2).toBeDefined();
      expect(framebuffer2.numberOfColorAttachments).toEqual(1);
    });
    it("destroyFramebuffer destroys framebuffer", function() {
      fbm = new import__11.FramebufferManager();
      fbm.update(context, 1, 1);
      expect(fbm.framebuffer.isDestroyed()).toEqual(false);
      spyOn(import__11.Framebuffer.prototype, "destroy").and.callThrough();
      fbm.destroyFramebuffer();
      expect(fbm.framebuffer).toBeUndefined();
      expect(import__11.Framebuffer.prototype.destroy).toHaveBeenCalled();
    });
    it("creates single color attachment", function() {
      fbm = new import__11.FramebufferManager();
      fbm.update(context, 1, 1);
      const texture = fbm.getColorTexture();
      expect(texture).toBeDefined();
      expect(texture.width).toEqual(1);
      expect(texture.height).toEqual(1);
      expect(texture.pixelFormat).toEqual(import__11.PixelFormat.RGBA);
      expect(texture.pixelDatatype).toEqual(import__11.PixelDatatype.UNSIGNED_BYTE);
    });
    it("creates multiple color attachments", function() {
      if (!context.drawBuffers) {
        return;
      }
      const length2 = 2;
      fbm = new import__11.FramebufferManager({
        colorAttachmentsLength: length2
      });
      fbm.update(context, 1, 1);
      for (let i = 0; i < length2; ++i) {
        const texture = fbm.getColorTexture(i);
        expect(texture).toBeDefined();
        expect(texture.width).toEqual(1);
        expect(texture.height).toEqual(1);
        expect(texture.pixelFormat).toEqual(import__11.PixelFormat.RGBA);
        expect(texture.pixelDatatype).toEqual(import__11.PixelDatatype.UNSIGNED_BYTE);
      }
    });
    it("creates depth attachments", function() {
      fbm = new import__11.FramebufferManager({
        color: false,
        depth: true,
        supportsDepthTexture: true
      });
      fbm.update(context, 1, 1);
      if (context.depthTexture) {
        const texture = fbm.getDepthTexture();
        expect(texture).toBeDefined();
        expect(texture.width).toEqual(1);
        expect(texture.height).toEqual(1);
        expect(texture.pixelFormat).toEqual(import__11.PixelFormat.DEPTH_COMPONENT);
        expect(texture.pixelDatatype).toEqual(import__11.PixelDatatype.UNSIGNED_INT);
      } else {
        const renderbuffer = fbm.getDepthRenderbuffer();
        expect(renderbuffer).toBeDefined();
        expect(renderbuffer.width).toEqual(1);
        expect(renderbuffer.height).toEqual(1);
        expect(renderbuffer.format).toEqual(
          import__11.RenderbufferFormat.DEPTH_COMPONENT16
        );
      }
    });
    it("creates depth-stencil attachments", function() {
      fbm = new import__11.FramebufferManager({
        color: false,
        depthStencil: true,
        supportsDepthTexture: true
      });
      fbm.update(context, 1, 1);
      if (context.depthTexture) {
        const texture = fbm.getDepthStencilTexture();
        expect(texture).toBeDefined();
        expect(texture.width).toEqual(1);
        expect(texture.height).toEqual(1);
        expect(texture.pixelFormat).toEqual(import__11.PixelFormat.DEPTH_STENCIL);
        expect(texture.pixelDatatype).toEqual(import__11.PixelDatatype.UNSIGNED_INT_24_8);
      } else {
        const renderbuffer = fbm.getDepthStencilRenderbuffer();
        expect(renderbuffer).toBeDefined();
        expect(renderbuffer.width).toEqual(1);
        expect(renderbuffer.height).toEqual(1);
        expect(renderbuffer.format).toEqual(import__11.RenderbufferFormat.DEPTH_STENCIL);
      }
    });
    it("creates renderbuffer depth attachments if supportsDepthTexture is false", function() {
      fbm = new import__11.FramebufferManager({
        depth: true
      });
      fbm.update(context, 1, 1);
      expect(fbm.getDepthTexture()).toBeUndefined();
      expect(fbm.getDepthRenderbuffer()).toBeDefined();
    });
    it("creates renderbuffer depth attachments if supportsDepthTexture is true but context.depthTexture is false", function() {
      fbm = new import__11.FramebufferManager({
        depth: true,
        supportsDepthTexture: true
      });
      const depthTexture = context._depthTexture;
      context._depthTexture = false;
      const webgl2 = context._webgl2;
      context._webgl2 = false;
      fbm.update(context, 1, 1);
      expect(fbm.getDepthTexture()).toBeUndefined();
      expect(fbm.getDepthRenderbuffer()).toBeDefined();
      context._depthTexture = depthTexture;
      context._webgl2 = webgl2;
    });
    it("doesn't create multisample resources if msaa is unsupported", function() {
      fbm = new import__11.FramebufferManager({
        depth: true,
        supportsDepthTexture: true
      });
      const webgl2 = context._webgl2;
      context._webgl2 = false;
      fbm.update(context, 1, 1, 4);
      expect(fbm._multisampleFramebuffer).toBeUndefined();
      context._webgl2 = webgl2;
    });
    it("destroys attachments and framebuffer", function() {
      if (!context.drawBuffers) {
        return;
      }
      fbm = new import__11.FramebufferManager({
        colorAttachmentsLength: 2,
        depth: true
      });
      fbm.update(context, 1, 1);
      expect(fbm.framebuffer).toBeDefined();
      expect(fbm.getColorTexture(0)).toBeDefined();
      expect(fbm.getColorTexture(1)).toBeDefined();
      expect(fbm.getDepthRenderbuffer()).toBeDefined();
      spyOn(import__11.Framebuffer.prototype, "destroy").and.callThrough();
      spyOn(import__11.Renderbuffer.prototype, "destroy").and.callThrough();
      spyOn(import__11.Texture.prototype, "destroy").and.callThrough();
      fbm.destroy();
      expect(import__11.Framebuffer.prototype.destroy.calls.count()).toEqual(1);
      expect(fbm.framebuffer).toBeUndefined();
      expect(import__11.Renderbuffer.prototype.destroy.calls.count()).toEqual(1);
      expect(fbm.getDepthRenderbuffer()).toBeUndefined();
      expect(import__11.Texture.prototype.destroy.calls.count()).toEqual(2);
      expect(fbm.getColorTexture(0)).toBeUndefined();
      expect(fbm.getColorTexture(1)).toBeUndefined();
    });
    it("does not destroy attachments that are not created by FramebufferManager", function() {
      fbm = new import__11.FramebufferManager({
        createColorAttachments: false,
        createDepthAttachments: false
      });
      const colorTexture = new import__11.Texture({
        context,
        width: 1,
        height: 1,
        pixelFormat: import__11.PixelFormat.RGBA
      });
      fbm.setColorTexture(colorTexture, 0);
      const depthRenderbuffer = new import__11.Renderbuffer({
        context,
        width: 1,
        height: 1
      });
      fbm.setDepthRenderbuffer(depthRenderbuffer);
      fbm.update(context, 1, 1);
      fbm.destroy();
      expect(fbm.framebuffer).toBeUndefined();
      expect(fbm.getColorTexture()).toBeDefined();
      expect(fbm.getDepthRenderbuffer()).toBeDefined();
      colorTexture.destroy();
      depthRenderbuffer.destroy();
    });
    it("does not destroy resources if texture dimensions haven't changed", function() {
      fbm = new import__11.FramebufferManager();
      spyOn(import__11.FramebufferManager.prototype, "destroy").and.callThrough();
      fbm.update(context, 1, 1);
      fbm.update(context, 1, 1);
      expect(import__11.FramebufferManager.prototype.destroy.calls.count()).toEqual(1);
    });
    it("destroys resources after texture dimensions change", function() {
      fbm = new import__11.FramebufferManager();
      spyOn(import__11.FramebufferManager.prototype, "destroy").and.callThrough();
      fbm.update(context, 1, 1);
      fbm.update(context, 2, 1);
      expect(import__11.FramebufferManager.prototype.destroy.calls.count()).toEqual(2);
    });
    it("destroys resources after numSamples changes", function() {
      if (!context.webgl2) {
        return;
      }
      fbm = new import__11.FramebufferManager();
      spyOn(import__11.FramebufferManager.prototype, "destroy").and.callThrough();
      fbm.update(context, 1, 1);
      fbm.update(context, 1, 1, 2);
      expect(import__11.FramebufferManager.prototype.destroy.calls.count()).toEqual(2);
    });
    it("destroys resources after pixel datatype changes", function() {
      fbm = new import__11.FramebufferManager({
        pixelDatatype: import__11.PixelDatatype.UNSIGNED_INT
      });
      spyOn(import__11.FramebufferManager.prototype, "destroy").and.callThrough();
      fbm.update(context, 1, 1);
      fbm.update(context, 1, 1, 1, import__11.PixelDatatype.UNSIGNED_BYTE);
      expect(import__11.FramebufferManager.prototype.destroy.calls.count()).toEqual(2);
    });
    it("destroys resources after pixel format changes", function() {
      fbm = new import__11.FramebufferManager({
        pixelFormat: import__11.PixelFormat.RGB
      });
      spyOn(import__11.FramebufferManager.prototype, "destroy").and.callThrough();
      fbm.update(context, 1, 1);
      fbm.update(context, 1, 1, 1, void 0, import__11.PixelFormat.RGBA);
      expect(import__11.FramebufferManager.prototype.destroy.calls.count()).toEqual(2);
    });
    it("destroys resources after new attachment is set", function() {
      fbm = new import__11.FramebufferManager({
        createColorAttachments: false
      });
      const texture = new import__11.Texture({
        context,
        width: 1,
        height: 1
      });
      spyOn(import__11.FramebufferManager.prototype, "destroy").and.callThrough();
      fbm.setColorTexture(texture, 0);
      fbm.update(context, 1, 1);
      fbm.setColorTexture(texture, 0);
      fbm.update(context, 1, 1);
      expect(import__11.FramebufferManager.prototype.destroy.calls.count()).toEqual(1);
    });
    it("executes clear command", function() {
      import__11.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      fbm = new import__11.FramebufferManager();
      fbm.update(context, 1, 1);
      const clearCommand = new import__11.ClearCommand({
        color: new import__11.Color(1, 0, 0, 1)
      });
      fbm.clear(context, clearCommand);
      const fs = "uniform sampler2D u_texture; void main() { out_FragColor = texture(u_texture, vec2(0.0)); }";
      const uniformMap = {
        u_texture: function() {
          return fbm.getColorTexture();
        }
      };
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([255, 0, 0, 255]);
    });
    it("preserves clear command framebuffer after clear()", function() {
      import__11.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      fbm = new import__11.FramebufferManager();
      fbm.update(context, 1, 1);
      const fb = new import__11.Framebuffer({
        context
      });
      const clearCommand = new import__11.ClearCommand({
        color: new import__11.Color(1, 0, 0, 1),
        framebuffer: fb
      });
      fbm.clear(context, clearCommand);
      expect(clearCommand.framebuffer).toBe(fb);
      const fs = "uniform sampler2D u_texture; void main() { out_FragColor = texture(u_texture, vec2(0.0)); }";
      const uniformMap = {
        u_texture: function() {
          return fbm.getColorTexture();
        }
      };
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([255, 0, 0, 255]);
      fb.destroy();
    });
    it("returns framebuffer status", function() {
      fbm = new import__11.FramebufferManager();
      fbm.update(context, 1, 1);
      expect(fbm.status).toEqual(fbm.framebuffer.status);
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/FramebufferSpec.js
var import__12 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Framebuffer",
  function() {
    let context;
    let sp;
    let va;
    let framebuffer2;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    afterEach(function() {
      sp = sp && sp.destroy();
      va = va && va.destroy();
      framebuffer2 = framebuffer2 && framebuffer2.destroy();
    });
    it("has a color texture attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        ]
      });
      expect(framebuffer2.getColorTexture(0)).toBeDefined();
    });
    it("has a color renderbuffer attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorRenderbuffers: [
          new import__12.Renderbuffer({
            context,
            format: import__12.RenderbufferFormat.RGBA4
          })
        ]
      });
      expect(framebuffer2.getColorRenderbuffer(0)).toBeDefined();
    });
    it("has a depth texture attachment", function() {
      if (context.depthTexture) {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthTexture: new import__12.Texture({
            context,
            width: 1,
            height: 1,
            pixelFormat: import__12.PixelFormat.DEPTH_COMPONENT,
            pixelDatatype: import__12.PixelDatatype.UNSIGNED_SHORT
          })
        });
        expect(framebuffer2.depthTexture).toBeDefined();
      }
    });
    it("has a depth renderbuffer attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        depthRenderbuffer: new import__12.Renderbuffer({
          context,
          format: import__12.RenderbufferFormat.DEPTH_COMPONENT16
        })
      });
      expect(framebuffer2.depthRenderbuffer).toBeDefined();
    });
    it("has a stencil renderbuffer attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        stencilRenderbuffer: new import__12.Renderbuffer({
          context,
          format: import__12.RenderbufferFormat.STENCIL_INDEX8
        })
      });
      expect(framebuffer2.stencilRenderbuffer).toBeDefined();
    });
    it("has a depth-stencil texture attachment", function() {
      if (context.depthTexture) {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthStencilTexture: new import__12.Texture({
            context,
            width: 1,
            height: 1,
            pixelFormat: import__12.PixelFormat.DEPTH_STENCIL,
            pixelDatatype: import__12.PixelDatatype.UNSIGNED_INT_24_8
          })
        });
        expect(framebuffer2.depthStencilTexture).toBeDefined();
      }
    });
    it("has a depth-stencil renderbuffer attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        depthStencilRenderbuffer: new import__12.Renderbuffer({
          context,
          format: import__12.RenderbufferFormat.DEPTH_STENCIL
        })
      });
      expect(framebuffer2.depthStencilRenderbuffer).toBeDefined();
    });
    it("has a depth attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context
      });
      expect(framebuffer2.hasDepthAttachment).toEqual(false);
      framebuffer2.destroy();
      framebuffer2 = new import__12.Framebuffer({
        context,
        depthRenderbuffer: new import__12.Renderbuffer({
          context,
          format: import__12.RenderbufferFormat.DEPTH_COMPONENT16
        })
      });
      expect(framebuffer2.hasDepthAttachment).toEqual(true);
    });
    it("clears a color attachment", function() {
      import__12.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const colorTexture = new import__12.Texture({
        context,
        width: 1,
        height: 1
      });
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [colorTexture]
      });
      const clearCommand = new import__12.ClearCommand({
        color: new import__12.Color(0, 1, 0, 1),
        framebuffer: framebuffer2
      });
      clearCommand.execute(context);
      const fs = "uniform sampler2D u_texture; void main() { out_FragColor = texture(u_texture, vec2(0.0)); }";
      const uniformMap = {
        u_texture: function() {
          return colorTexture;
        }
      };
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([0, 255, 0, 255]);
    });
    it("clears a cube map face color attachment", function() {
      let cubeMap = new import__12.CubeMap({
        context,
        width: 1,
        height: 1
      });
      import__12.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [cubeMap.positiveX],
        destroyAttachments: false
      });
      const clearCommand = new import__12.ClearCommand({
        color: new import__12.Color(0, 1, 0, 1),
        framebuffer: framebuffer2
      });
      clearCommand.execute(context);
      const fs = "uniform samplerCube u_cubeMap; void main() { out_FragColor = czm_textureCube(u_cubeMap, vec3(1.0, 0.0, 0.0)); }";
      const uniformMap = {
        u_cubeMap: function() {
          return cubeMap;
        }
      };
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([0, 255, 0, 255]);
      cubeMap = cubeMap.destroy();
    });
    function renderColorTexture(framebuffer3, color, expectedColor) {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "uniform vec4 color; void main() { out_FragColor = color; }";
      sp = import__12.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__12.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__12.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__12.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const uniformMap = {
        color: function() {
          return color;
        }
      };
      const command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        uniformMap,
        framebuffer: framebuffer3
      });
      command.execute(context);
      expect({
        context,
        framebuffer: framebuffer3
      }).toReadPixels(expectedColor);
    }
    it("draws to a color attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        ]
      });
      renderColorTexture(framebuffer2, new import__12.Color(0, 1, 0, 1), [
        0,
        255,
        0,
        255
      ]);
    });
    it("draws to a floating-point color attachment", function() {
      if (!context.colorBufferFloat) {
        return;
      }
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1,
            pixelDatatype: import__12.PixelDatatype.FLOAT
          })
        ]
      });
      renderColorTexture(framebuffer2, new import__12.Color(0.5, 1.5, 2, 1), [
        0.5,
        1.5,
        2,
        1
      ]);
    });
    it("draws to a half floating-point color attachment", function() {
      if (!context.colorBufferHalfFloat) {
        return;
      }
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1,
            pixelDatatype: import__12.PixelDatatype.HALF_FLOAT
          })
        ]
      });
      renderColorTexture(framebuffer2, new import__12.Color(0.5, 1.5, 2, 1), [
        14336,
        15872,
        16384,
        15360
      ]);
    });
    function renderDepthAttachment(framebuffer3, texture) {
      import__12.ClearCommand.ALL.execute(context);
      const framebufferClear = new import__12.ClearCommand({
        depth: 1,
        framebuffer: framebuffer3
      });
      framebufferClear.execute(context);
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(0.0, 1.0, 0.0, 1.0); }";
      sp = import__12.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__12.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__12.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__12.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      let command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        framebuffer: framebuffer3,
        renderState: import__12.RenderState.fromCache({
          depthTest: {
            enabled: true
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const vs2 = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs2 = "uniform sampler2D u_texture; void main() { out_FragColor = texture(u_texture, vec2(0.0)).rrrr; }";
      let sp2 = import__12.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs2,
        fragmentShaderSource: fs2,
        attributeLocations: {
          position: 0
        }
      });
      const uniformMap = {
        u_texture: function() {
          return texture;
        }
      };
      command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp2,
        vertexArray: va,
        uniformMap
      });
      command.execute(context);
      sp2 = sp2.destroy();
      return context.readPixels();
    }
    it("draws to a depth texture attachment", function() {
      if (context.depthTexture) {
        framebuffer2 = new import__12.Framebuffer({
          context,
          colorTextures: [
            new import__12.Texture({
              context,
              width: 1,
              height: 1
            })
          ],
          depthTexture: new import__12.Texture({
            context,
            width: 1,
            height: 1,
            pixelFormat: import__12.PixelFormat.DEPTH_COMPONENT,
            pixelDatatype: import__12.PixelDatatype.UNSIGNED_SHORT
          })
        });
        if (framebuffer2.status === import__12.WebGLConstants.FRAMEBUFFER_COMPLETE) {
          expect(
            renderDepthAttachment(framebuffer2, framebuffer2.depthTexture)
          ).toEqualEpsilon([128, 128, 128, 255], 1);
        }
      }
    });
    it("draws to a depth-stencil texture attachment", function() {
      if (context.depthTexture) {
        framebuffer2 = new import__12.Framebuffer({
          context,
          colorTextures: [
            new import__12.Texture({
              context,
              width: 1,
              height: 1
            })
          ],
          depthStencilTexture: new import__12.Texture({
            context,
            width: 1,
            height: 1,
            pixelFormat: import__12.PixelFormat.DEPTH_STENCIL,
            pixelDatatype: import__12.PixelDatatype.UNSIGNED_INT_24_8
          })
        });
        if (framebuffer2.status === import__12.WebGLConstants.FRAMEBUFFER_COMPLETE) {
          expect(
            renderDepthAttachment(framebuffer2, framebuffer2.depthStencilTexture)
          ).toEqualEpsilon([128, 128, 128, 255], 1);
        }
      }
    });
    it("draws with a depth attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        ],
        depthRenderbuffer: new import__12.Renderbuffer({
          context,
          format: import__12.RenderbufferFormat.DEPTH_COMPONENT16,
          width: 1,
          height: 1
        })
      });
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0, 1.0, 1.0, 1.0); }";
      sp = import__12.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__12.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__12.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__12.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const clearCommand = new import__12.ClearCommand({
        color: new import__12.Color(0, 0, 0, 0),
        depth: 1,
        framebuffer: framebuffer2
      });
      clearCommand.execute(context);
      expect({
        context,
        framebuffer: framebuffer2
      }).toReadPixels([0, 0, 0, 0]);
      let command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        framebuffer: framebuffer2,
        renderState: import__12.RenderState.fromCache({
          depthTest: {
            enabled: true,
            func: import__12.WebGLConstants.NEVER
          }
        })
      });
      command.execute(context);
      expect({
        context,
        framebuffer: framebuffer2
      }).toReadPixels([0, 0, 0, 0]);
      command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        framebuffer: framebuffer2,
        renderState: import__12.RenderState.fromCache({
          depthTest: {
            enabled: true,
            func: import__12.WebGLConstants.ALWAYS
          }
        })
      });
      command.execute(context);
      expect({
        context,
        framebuffer: framebuffer2
      }).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with multiple render targets", function() {
      if (!context.drawBuffers) {
        return;
      }
      const source = new Uint8Array(4);
      const colorTexture0 = new import__12.Texture({
        context,
        source: {
          arrayBufferView: source,
          width: 1,
          height: 1
        }
      });
      const colorTexture1 = new import__12.Texture({
        context,
        source: {
          arrayBufferView: source,
          width: 1,
          height: 1
        }
      });
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [colorTexture0, colorTexture1]
      });
      import__12.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "layout (location = 0) out vec4 out_FragData_0;\n layout (location = 1) out vec4 out_FragData_1; \n void main() { out_FragData_0 = vec4(1.0, 0.0, 0.0, 1.0); out_FragData_1 = vec4(0.0, 1.0, 0.0, 1.0); }";
      sp = import__12.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__12.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__12.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__12.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      let command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        framebuffer: framebuffer2
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const vs2 = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs2 = "uniform sampler2D u_texture0; uniform sampler2D u_texture1; void main() { out_FragColor = texture(u_texture0, vec2(0.0)) + texture(u_texture1, vec2(0.0)); }";
      let sp2 = import__12.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs2,
        fragmentShaderSource: fs2,
        attributeLocations: {
          position: 0
        }
      });
      const uniformMap = {
        u_texture0: function() {
          return colorTexture0;
        },
        u_texture1: function() {
          return colorTexture1;
        }
      };
      command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp2,
        vertexArray: va,
        uniformMap
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 0, 255]);
      const clearCommand = new import__12.ClearCommand({
        color: new import__12.Color(0, 0, 0, 0),
        framebuffer: framebuffer2
      });
      clearCommand.execute(context);
      command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp2,
        vertexArray: va
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      sp2 = sp2.destroy();
    });
    it("gets the status of a complete framebuffer", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        ],
        depthRenderbuffer: new import__12.Renderbuffer({
          context,
          format: import__12.RenderbufferFormat.DEPTH_COMPONENT16,
          width: 1,
          height: 1
        })
      });
      expect(framebuffer2.status).toEqual(import__12.WebGLConstants.FRAMEBUFFER_COMPLETE);
    });
    it("gets the status of a incomplete framebuffer", function() {
      if (!!window.webglStub) {
        return;
      }
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        ],
        depthRenderbuffer: new import__12.Renderbuffer({
          context,
          format: import__12.RenderbufferFormat.RGBA4,
          width: 2,
          height: 2
        })
      });
      expect(framebuffer2.status).not.toEqual(
        import__12.WebGLConstants.FRAMEBUFFER_COMPLETE
      );
    });
    it("destroys", function() {
      const f = new import__12.Framebuffer({
        context
      });
      expect(f.isDestroyed()).toEqual(false);
      f.destroy();
      expect(f.isDestroyed()).toEqual(true);
    });
    it("throws when created with color texture and color renderbuffer attachments", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          colorTextures: "not undefined",
          colorRenderbuffers: "not undefined"
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with depth texture and depth renderbuffer attachments", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthTexture: "not undefined",
          depthRenderbuffer: "not undefined"
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with depth-stencil texture and depth-stencil renderbuffer attachments", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthStencilTexture: "not undefined",
          depthStencilRenderbuffer: "not undefined"
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with depth and depth-stencil attachments", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthRenderbuffer: "not undefined",
          depthStencilRenderbuffer: "not undefined"
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with stencil and depth-stencil attachments", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          stencilRenderbuffer: "not undefined",
          depthStencilRenderbuffer: "not undefined"
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with depth and stencil attachments", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthRenderbuffer: "not undefined",
          stencilRenderbuffer: "not undefined"
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with a color texture with a non-color pixel format", function() {
      if (context.depthTexture) {
        expect(function() {
          framebuffer2 = new import__12.Framebuffer({
            context,
            colorTextures: [
              new import__12.Texture({
                context,
                width: 1,
                height: 1,
                pixelFormat: import__12.PixelFormat.DEPTH_COMPONENT,
                pixelDatatype: import__12.PixelDatatype.UNSIGNED_SHORT
              })
            ]
          });
        }).toThrowDeveloperError();
      }
    });
    it("throws when created with a depth texture without a DEPTH_COMPONENT pixel format", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthTexture: new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with a depth-stencil texture without a DEPTH_STENCIL pixel format", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthStencilTexture: new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        });
      }).toThrowDeveloperError();
    });
    it("throws when the depth test is enabled without an appropriate attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        ]
      });
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0, 1.0, 1.0, 1.0); }";
      sp = import__12.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__12.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__12.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__12.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      expect(function() {
        const command = new import__12.DrawCommand({
          primitiveType: import__12.PrimitiveType.POINTS,
          shaderProgram: sp,
          vertexArray: va,
          framebuffer: framebuffer2,
          renderState: import__12.RenderState.fromCache({
            depthTest: {
              enabled: true
            }
          })
        });
        command.execute(context);
      }).toThrowDeveloperError();
    });
    it("throws when the number of color texture exceeds the number color attachments supported", function() {
      expect(function() {
        return new import__12.Framebuffer({
          context,
          colorTextures: new Array(import__12.ContextLimits.maximumColorAttachments + 1)
        });
      }).toThrowDeveloperError();
    });
    it("throws when the number of color renderbuffers exceeds the number color attachments supported", function() {
      expect(function() {
        return new import__12.Framebuffer({
          context,
          colorRenderbuffers: new Array(
            import__12.ContextLimits.maximumColorAttachments + 1
          )
        });
      }).toThrowDeveloperError();
    });
    it("throws when the index to getColorTexture is out of bounds", function() {
      framebuffer2 = new import__12.Framebuffer({
        context
      });
      expect(function() {
        framebuffer2.getColorTexture();
      }).toThrowDeveloperError();
      expect(function() {
        framebuffer2.getColorTexture(-1);
      }).toThrowDeveloperError();
      expect(function() {
        framebuffer2.getColorTexture(import__12.ContextLimits.maximumColorAttachments + 1);
      }).toThrowDeveloperError();
    });
    it("throws when the index to getColorRenderbuffer is out of bounds", function() {
      framebuffer2 = new import__12.Framebuffer({
        context
      });
      expect(function() {
        framebuffer2.getColorRenderbuffer();
      }).toThrowDeveloperError();
      expect(function() {
        framebuffer2.getColorRenderbuffer(-1);
      }).toThrowDeveloperError();
      expect(function() {
        framebuffer2.getColorRenderbuffer(
          import__12.ContextLimits.maximumColorAttachments + 1
        );
      }).toThrowDeveloperError();
    });
    it("throws when a color attachment has a floating-point datatype but the EXT_color_buffer_float extension is not supported", function() {
      if (context.colorBufferFloat) {
        return;
      }
      expect(function() {
        return new import__12.Framebuffer({
          context,
          colorTextures: [
            new import__12.Texture({
              context,
              width: 1,
              height: 1,
              pixelDatatype: import__12.PixelDatatype.FLOAT
            })
          ]
        });
      }).toThrowDeveloperError();
    });
    it("throws when a color attachment has a half floating-point datatype but the EXT_color_buffer_half_float extension is not supported", function() {
      if (context.colorBufferHalfFloat) {
        return;
      }
      expect(function() {
        return new import__12.Framebuffer({
          context,
          colorTextures: [
            new import__12.Texture({
              context,
              width: 1,
              height: 1,
              pixelDatatype: import__12.PixelDatatype.HALF_FLOAT
            })
          ]
        });
      }).toThrowDeveloperError();
    });
    it("fails to destroy", function() {
      const f = new import__12.Framebuffer({
        context
      });
      f.destroy();
      expect(function() {
        f.destroy();
      }).toThrowDeveloperError();
    });
    it("throws when there is no context", function() {
      expect(function() {
        return new import__12.Framebuffer();
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/MultisampleFramebufferSpec.js
var import__13 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/MultisampleFramebuffer",
  function() {
    let context;
    let sp;
    let va;
    let framebuffer2;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    afterEach(function() {
      sp = sp && sp.destroy();
      va = va && va.destroy();
      framebuffer2 = framebuffer2 && framebuffer2.destroy();
    });
    it("throws when missing a color attachment", function() {
      expect(function() {
        framebuffer2 = new import__13.MultisampleFramebuffer({
          context,
          width: 1,
          height: 1,
          colorTextures: []
        });
      }).toThrowDeveloperError();
      expect(function() {
        framebuffer2 = new import__13.MultisampleFramebuffer({
          context,
          width: 1,
          height: 1,
          colorRenderbuffers: []
        });
      }).toThrowDeveloperError();
    });
    it("throws when missing a depth-stencil attachment", function() {
      expect(function() {
        framebuffer2 = new import__13.MultisampleFramebuffer({
          context,
          width: 1,
          height: 1,
          depthStencilTexture: []
        });
      }).toThrowDeveloperError();
      expect(function() {
        framebuffer2 = new import__13.MultisampleFramebuffer({
          context,
          width: 1,
          height: 1,
          depthStencilRenderbuffer: []
        });
      }).toThrowDeveloperError();
    });
    it("creates read and draw framebuffers", function() {
      if (!context.depthTexture) {
        return;
      }
      framebuffer2 = new import__13.MultisampleFramebuffer({
        context,
        width: 1,
        height: 1,
        colorTextures: [
          new import__13.Texture({
            context,
            width: 1,
            height: 1
          })
        ],
        colorRenderbuffers: [
          new import__13.Renderbuffer({
            context,
            format: import__13.RenderbufferFormat.RGBA8
          })
        ],
        depthStencilTexture: new import__13.Texture({
          context,
          width: 1,
          height: 1,
          pixelFormat: import__13.PixelFormat.DEPTH_STENCIL,
          pixelDatatype: import__13.PixelDatatype.UNSIGNED_INT_24_8
        }),
        depthStencilRenderbuffer: new import__13.Renderbuffer({
          context,
          format: import__13.RenderbufferFormat.DEPTH_STENCIL
        })
      });
      const readFB = framebuffer2.getRenderFramebuffer();
      const drawFB = framebuffer2.getColorFramebuffer();
      expect(readFB).toBeDefined();
      expect(readFB.getColorRenderbuffer(0)).toBeDefined();
      expect(readFB.depthStencilRenderbuffer).toBeDefined();
      expect(drawFB).toBeDefined();
      expect(drawFB.getColorTexture(0)).toBeDefined();
      expect(drawFB.depthStencilTexture).toBeDefined();
    });
    function renderColor(framebuffer3, color) {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "uniform vec4 color; void main() { out_FragColor = color; }";
      sp = import__13.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__13.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__13.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__13.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const uniformMap = {
        color: function() {
          return color;
        }
      };
      const command = new import__13.DrawCommand({
        primitiveType: import__13.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        uniformMap,
        framebuffer: framebuffer3
      });
      command.execute(context);
    }
    it("blits color attachments", function() {
      if (!context.webgl2) {
        return;
      }
      framebuffer2 = new import__13.MultisampleFramebuffer({
        context,
        width: 1,
        height: 1,
        colorTextures: [
          new import__13.Texture({
            context,
            width: 1,
            height: 1
          })
        ],
        colorRenderbuffers: [
          new import__13.Renderbuffer({
            context,
            format: import__13.RenderbufferFormat.RGBA8,
            numSamples: 2
          })
        ]
      });
      const renderFB = framebuffer2.getRenderFramebuffer();
      renderColor(renderFB, new import__13.Color(0, 1, 0, 1));
      framebuffer2.blitFramebuffers(context);
      const colorFB = framebuffer2.getColorFramebuffer();
      expect({
        context,
        framebuffer: colorFB
      }).toReadPixels([0, 255, 0, 255]);
    });
    function renderAndBlitDepthAttachment(framebuffer3) {
      const renderFB = framebuffer3.getRenderFramebuffer();
      const colorFB = framebuffer3.getColorFramebuffer();
      import__13.ClearCommand.ALL.execute(context);
      const framebufferClear = new import__13.ClearCommand({
        depth: 1,
        framebuffer: renderFB
      });
      framebufferClear.execute(context);
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(0.0, 1.0, 0.0, 1.0); }";
      sp = import__13.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__13.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__13.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__13.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      let command = new import__13.DrawCommand({
        primitiveType: import__13.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        framebuffer: renderFB,
        renderState: import__13.RenderState.fromCache({
          depthTest: {
            enabled: true
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      framebuffer3.blitFramebuffers(context);
      const vs2 = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs2 = "uniform sampler2D u_texture; void main() { out_FragColor = texture(u_texture, vec2(0.0)).rrrr; }";
      let sp2 = import__13.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs2,
        fragmentShaderSource: fs2,
        attributeLocations: {
          position: 0
        }
      });
      const uniformMap = {
        u_texture: function() {
          return colorFB.depthStencilTexture;
        }
      };
      command = new import__13.DrawCommand({
        primitiveType: import__13.PrimitiveType.POINTS,
        shaderProgram: sp2,
        vertexArray: va,
        uniformMap
      });
      command.execute(context);
      sp2 = sp2.destroy();
      return context.readPixels();
    }
    it("blits depth-stencil attachments", function() {
      if (!context.webgl2 || !context.depthTexture) {
        return;
      }
      framebuffer2 = new import__13.MultisampleFramebuffer({
        context,
        width: 1,
        height: 1,
        colorTextures: [
          new import__13.Texture({
            context,
            width: 1,
            height: 1
          })
        ],
        colorRenderbuffers: [
          new import__13.Renderbuffer({
            context,
            format: import__13.RenderbufferFormat.RGBA8,
            numSamples: 2
          })
        ],
        depthStencilTexture: new import__13.Texture({
          context,
          width: 1,
          height: 1,
          pixelFormat: import__13.PixelFormat.DEPTH_STENCIL,
          pixelDatatype: import__13.PixelDatatype.UNSIGNED_INT_24_8
        }),
        depthStencilRenderbuffer: new import__13.Renderbuffer({
          context,
          width: 1,
          height: 1,
          format: import__13.RenderbufferFormat.DEPTH24_STENCIL8,
          numSamples: 2
        })
      });
      expect(renderAndBlitDepthAttachment(framebuffer2)).toEqualEpsilon(
        [128, 128, 128, 255],
        1
      );
    });
    it("destroys", function() {
      const f = new import__13.MultisampleFramebuffer({
        context,
        width: 1,
        height: 1
      });
      expect(f.isDestroyed()).toEqual(false);
      f.destroy();
      expect(f.isDestroyed()).toEqual(true);
    });
    it("fails to destroy", function() {
      const f = new import__13.MultisampleFramebuffer({
        context,
        width: 1,
        height: 1
      });
      f.destroy();
      expect(function() {
        f.destroy();
      }).toThrowDeveloperError();
    });
    it("throws when there is no context", function() {
      expect(function() {
        return new import__13.MultisampleFramebuffer();
      }).toThrowDeveloperError();
    });
    it("throws when there is no width or height", function() {
      expect(function() {
        return new import__13.MultisampleFramebuffer({
          context,
          height: 1
        });
      }).toThrowDeveloperError();
      expect(function() {
        return new import__13.MultisampleFramebuffer({
          context,
          width: 1
        });
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/PassStateSpec.js
var import__14 = __toESM(require_Cesium(), 1);
describe("Renderer/PassState", function() {
  it("creates a pass state", function() {
    const context = {};
    const passState = new import__14.PassState(context);
    expect(passState.context).toBe(context);
    expect(passState.framebuffer).not.toBeDefined();
    expect(passState.blendingEnabled).not.toBeDefined();
    expect(passState.scissorTest).not.toBeDefined();
  });
});

// packages/engine/Specs/Renderer/RenderStateSpec.js
var import__15 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/RenderState",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("creates with defaults", function() {
      const defaultRS = {
        frontFace: import__15.WindingOrder.COUNTER_CLOCKWISE,
        cull: {
          enabled: false,
          face: import__15.WebGLConstants.BACK
        },
        lineWidth: 1,
        polygonOffset: {
          enabled: false,
          factor: 0,
          units: 0
        },
        scissorTest: {
          enabled: false,
          rectangle: {
            x: 0,
            y: 0,
            width: 0,
            height: 0
          }
        },
        depthRange: {
          near: 0,
          far: 1
        },
        depthTest: {
          enabled: false,
          func: import__15.WebGLConstants.LESS
        },
        colorMask: {
          red: true,
          green: true,
          blue: true,
          alpha: true
        },
        depthMask: true,
        stencilMask: ~0,
        blending: {
          enabled: false,
          color: {
            red: 0,
            green: 0,
            blue: 0,
            alpha: 0
          },
          equationRgb: import__15.WebGLConstants.FUNC_ADD,
          equationAlpha: import__15.WebGLConstants.FUNC_ADD,
          functionSourceRgb: import__15.WebGLConstants.ONE,
          functionSourceAlpha: import__15.WebGLConstants.ONE,
          functionDestinationRgb: import__15.WebGLConstants.ZERO,
          functionDestinationAlpha: import__15.WebGLConstants.ZERO
        },
        stencilTest: {
          enabled: false,
          frontFunction: import__15.WebGLConstants.ALWAYS,
          backFunction: import__15.WebGLConstants.ALWAYS,
          reference: 0,
          mask: ~0,
          frontOperation: {
            fail: import__15.WebGLConstants.KEEP,
            zFail: import__15.WebGLConstants.KEEP,
            zPass: import__15.WebGLConstants.KEEP
          },
          backOperation: {
            fail: import__15.WebGLConstants.KEEP,
            zFail: import__15.WebGLConstants.KEEP,
            zPass: import__15.WebGLConstants.KEEP
          }
        },
        sampleCoverage: {
          enabled: false,
          value: 1,
          invert: false
        }
      };
      const rs = import__15.RenderState.fromCache();
      expect(rs.frontFace).toEqual(defaultRS.frontFace);
      expect(rs.cull.enabled).toEqual(defaultRS.cull.enabled);
      expect(rs.cull.face).toEqual(defaultRS.cull.face);
      expect(rs.cull.lineWidth).toEqual(defaultRS.cull.lineWidth);
      expect(rs.polygonOffset.enabled).toEqual(defaultRS.polygonOffset.enabled);
      expect(rs.polygonOffset.factor).toEqual(defaultRS.polygonOffset.factor);
      expect(rs.polygonOffset.units).toEqual(defaultRS.polygonOffset.units);
      expect(rs.scissorTest.enabled).toEqual(defaultRS.scissorTest.enabled);
      expect(rs.scissorTest.rectangle.x).toEqual(
        defaultRS.scissorTest.rectangle.x
      );
      expect(rs.scissorTest.rectangle.y).toEqual(
        defaultRS.scissorTest.rectangle.y
      );
      expect(rs.scissorTest.rectangle.width).toEqual(
        defaultRS.scissorTest.rectangle.width
      );
      expect(rs.scissorTest.rectangle.height).toEqual(
        defaultRS.scissorTest.rectangle.height
      );
      expect(rs.depthRange.near).toEqual(defaultRS.depthRange.near);
      expect(rs.depthRange.far).toEqual(defaultRS.depthRange.far);
      expect(rs.depthTest.enabled).toEqual(defaultRS.depthTest.enabled);
      expect(rs.depthTest.func).toEqual(defaultRS.depthTest.func);
      expect(rs.colorMask.red).toEqual(defaultRS.colorMask.red);
      expect(rs.colorMask.green).toEqual(defaultRS.colorMask.green);
      expect(rs.colorMask.blue).toEqual(defaultRS.colorMask.blue);
      expect(rs.colorMask.alpha).toEqual(defaultRS.colorMask.alpha);
      expect(rs.depthMask).toEqual(defaultRS.depthMask);
      expect(rs.stencilMask).toEqual(defaultRS.stencilMask);
      expect(rs.blending.enabled).toEqual(defaultRS.blending.enabled);
      expect(rs.blending.color.red).toEqual(defaultRS.blending.color.red);
      expect(rs.blending.color.green).toEqual(defaultRS.blending.color.green);
      expect(rs.blending.color.blue).toEqual(defaultRS.blending.color.blue);
      expect(rs.blending.color.alpha).toEqual(defaultRS.blending.color.alpha);
      expect(rs.blending.equationRgb).toEqual(defaultRS.blending.equationRgb);
      expect(rs.blending.equationAlpha).toEqual(
        defaultRS.blending.equationAlpha
      );
      expect(rs.blending.functionSourceRgb).toEqual(
        defaultRS.blending.functionSourceRgb
      );
      expect(rs.blending.functionSourceAlpha).toEqual(
        defaultRS.blending.functionSourceAlpha
      );
      expect(rs.blending.functionDestinationRgb).toEqual(
        defaultRS.blending.functionDestinationRgb
      );
      expect(rs.blending.functionDestinationAlpha).toEqual(
        defaultRS.blending.functionDestinationAlpha
      );
      expect(rs.stencilTest.enabled).toEqual(defaultRS.stencilTest.enabled);
      expect(rs.stencilTest.frontFunction).toEqual(
        defaultRS.stencilTest.frontFunction
      );
      expect(rs.stencilTest.backFunction).toEqual(
        defaultRS.stencilTest.backFunction
      );
      expect(rs.stencilTest.reference).toEqual(defaultRS.stencilTest.reference);
      expect(rs.stencilTest.mask).toEqual(defaultRS.stencilTest.mask);
      expect(rs.stencilTest.frontOperation.fail).toEqual(
        defaultRS.stencilTest.frontOperation.fail
      );
      expect(rs.stencilTest.frontOperation.zFail).toEqual(
        defaultRS.stencilTest.frontOperation.zFail
      );
      expect(rs.stencilTest.frontOperation.zPass).toEqual(
        defaultRS.stencilTest.frontOperation.zPass
      );
      expect(rs.stencilTest.backOperation.fail).toEqual(
        defaultRS.stencilTest.backOperation.fail
      );
      expect(rs.stencilTest.backOperation.zFail).toEqual(
        defaultRS.stencilTest.backOperation.zFail
      );
      expect(rs.stencilTest.backOperation.zPass).toEqual(
        defaultRS.stencilTest.backOperation.zPass
      );
      expect(rs.sampleCoverage.enabled).toEqual(
        defaultRS.sampleCoverage.enabled
      );
      expect(rs.sampleCoverage.value).toEqual(defaultRS.sampleCoverage.value);
      expect(rs.sampleCoverage.invert).toEqual(defaultRS.sampleCoverage.invert);
    });
    it("creates with all render states", function() {
      const r = {
        frontFace: import__15.WindingOrder.CLOCKWISE,
        cull: {
          enabled: true,
          face: import__15.WebGLConstants.FRONT
        },
        lineWidth: import__15.ContextLimits.maximumAliasedLineWidth,
        polygonOffset: {
          enabled: false,
          factor: 1,
          units: 1
        },
        scissorTest: {
          enabled: true,
          rectangle: {
            x: 1,
            y: 1,
            width: 2,
            height: 2
          }
        },
        depthRange: {
          near: 0.25,
          far: 0.75
        },
        depthTest: {
          enabled: true,
          func: import__15.WebGLConstants.GREATER
        },
        colorMask: {
          red: false,
          green: false,
          blue: false,
          alpha: false
        },
        depthMask: false,
        stencilMask: 0,
        blending: {
          enabled: true,
          color: {
            red: 1,
            green: 1,
            blue: 1,
            alpha: 1
          },
          equationRgb: import__15.WebGLConstants.FUNC_SUBTRACT,
          equationAlpha: import__15.WebGLConstants.FUNC_SUBTRACT,
          functionSourceRgb: import__15.WebGLConstants.ZERO,
          functionSourceAlpha: import__15.WebGLConstants.ZERO,
          functionDestinationRgb: import__15.WebGLConstants.ONE,
          functionDestinationAlpha: import__15.WebGLConstants.ONE
        },
        stencilTest: {
          enabled: true,
          frontFunction: import__15.WebGLConstants.NEVER,
          backFunction: import__15.WebGLConstants.NEVER,
          reference: 1,
          mask: 0,
          frontOperation: {
            fail: import__15.WebGLConstants.REPLACE,
            zFail: import__15.WebGLConstants.REPLACE,
            zPass: import__15.WebGLConstants.REPLACE
          },
          backOperation: {
            fail: import__15.WebGLConstants.REPLACE,
            zFail: import__15.WebGLConstants.REPLACE,
            zPass: import__15.WebGLConstants.REPLACE
          }
        },
        sampleCoverage: {
          enabled: true,
          value: 0.5,
          invert: true
        }
      };
      const rs = import__15.RenderState.fromCache(r);
      expect(rs.frontFace).toEqual(r.frontFace);
      expect(rs.cull.enabled).toEqual(r.cull.enabled);
      expect(rs.cull.face).toEqual(r.cull.face);
      expect(rs.cull.lineWidth).toEqual(r.cull.lineWidth);
      expect(rs.polygonOffset.enabled).toEqual(r.polygonOffset.enabled);
      expect(rs.polygonOffset.factor).toEqual(r.polygonOffset.factor);
      expect(rs.polygonOffset.units).toEqual(r.polygonOffset.units);
      expect(rs.scissorTest.enabled).toEqual(r.scissorTest.enabled);
      expect(rs.scissorTest.rectangle.x).toEqual(r.scissorTest.rectangle.x);
      expect(rs.scissorTest.rectangle.y).toEqual(r.scissorTest.rectangle.y);
      expect(rs.scissorTest.rectangle.width).toEqual(
        r.scissorTest.rectangle.width
      );
      expect(rs.scissorTest.rectangle.height).toEqual(
        r.scissorTest.rectangle.height
      );
      expect(rs.depthRange.near).toEqual(r.depthRange.near);
      expect(rs.depthRange.far).toEqual(r.depthRange.far);
      expect(rs.depthTest.enabled).toEqual(r.depthTest.enabled);
      expect(rs.depthTest.func).toEqual(r.depthTest.func);
      expect(rs.colorMask.red).toEqual(r.colorMask.red);
      expect(rs.colorMask.green).toEqual(r.colorMask.green);
      expect(rs.colorMask.blue).toEqual(r.colorMask.blue);
      expect(rs.colorMask.alpha).toEqual(r.colorMask.alpha);
      expect(rs.depthMask).toEqual(r.depthMask);
      expect(rs.stencilMask).toEqual(r.stencilMask);
      expect(rs.blending.enabled).toEqual(r.blending.enabled);
      expect(rs.blending.color.red).toEqual(r.blending.color.red);
      expect(rs.blending.color.green).toEqual(r.blending.color.green);
      expect(rs.blending.color.blue).toEqual(r.blending.color.blue);
      expect(rs.blending.color.alpha).toEqual(r.blending.color.alpha);
      expect(rs.blending.equationRgb).toEqual(r.blending.equationRgb);
      expect(rs.blending.equationAlpha).toEqual(r.blending.equationAlpha);
      expect(rs.blending.functionSourceRgb).toEqual(
        r.blending.functionSourceRgb
      );
      expect(rs.blending.functionSourceAlpha).toEqual(
        r.blending.functionSourceAlpha
      );
      expect(rs.blending.functionDestinationRgb).toEqual(
        r.blending.functionDestinationRgb
      );
      expect(rs.blending.functionDestinationAlpha).toEqual(
        r.blending.functionDestinationAlpha
      );
      expect(rs.stencilTest.enabled).toEqual(r.stencilTest.enabled);
      expect(rs.stencilTest.frontFunction).toEqual(r.stencilTest.frontFunction);
      expect(rs.stencilTest.backFunction).toEqual(r.stencilTest.backFunction);
      expect(rs.stencilTest.reference).toEqual(r.stencilTest.reference);
      expect(rs.stencilTest.mask).toEqual(r.stencilTest.mask);
      expect(rs.stencilTest.frontOperation.fail).toEqual(
        r.stencilTest.frontOperation.fail
      );
      expect(rs.stencilTest.frontOperation.zFail).toEqual(
        r.stencilTest.frontOperation.zFail
      );
      expect(rs.stencilTest.frontOperation.zPass).toEqual(
        r.stencilTest.frontOperation.zPass
      );
      expect(rs.stencilTest.backOperation.fail).toEqual(
        r.stencilTest.backOperation.fail
      );
      expect(rs.stencilTest.backOperation.zFail).toEqual(
        r.stencilTest.backOperation.zFail
      );
      expect(rs.stencilTest.backOperation.zPass).toEqual(
        r.stencilTest.backOperation.zPass
      );
      expect(rs.sampleCoverage.enabled).toEqual(r.sampleCoverage.enabled);
      expect(rs.sampleCoverage.value).toEqual(r.sampleCoverage.value);
      expect(rs.sampleCoverage.invert).toEqual(r.sampleCoverage.invert);
    });
    it("creates with some render states", function() {
      const r = {
        frontFace: import__15.WindingOrder.CLOCKWISE,
        depthRange: {
          near: 0.25,
          far: 0.75
        }
      };
      const rs = import__15.RenderState.fromCache(r);
      expect(rs.frontFace).toEqual(r.frontFace);
      expect(rs.depthRange.near).toEqual(r.depthRange.near);
      expect(rs.depthRange.far).toEqual(r.depthRange.far);
      const defaultRS = import__15.RenderState.fromCache();
      expect(rs.cull.enabled).toEqual(defaultRS.cull.enabled);
      expect(rs.cull.face).toEqual(defaultRS.cull.face);
      expect(rs.cull.lineWidth).toEqual(defaultRS.cull.lineWidth);
      expect(rs.polygonOffset.enabled).toEqual(defaultRS.polygonOffset.enabled);
      expect(rs.polygonOffset.factor).toEqual(defaultRS.polygonOffset.factor);
      expect(rs.polygonOffset.units).toEqual(defaultRS.polygonOffset.units);
      expect(rs.scissorTest.enabled).toEqual(defaultRS.scissorTest.enabled);
      expect(rs.scissorTest.rectangle.x).toEqual(
        defaultRS.scissorTest.rectangle.x
      );
      expect(rs.scissorTest.rectangle.y).toEqual(
        defaultRS.scissorTest.rectangle.y
      );
      expect(rs.scissorTest.rectangle.width).toEqual(
        defaultRS.scissorTest.rectangle.width
      );
      expect(rs.scissorTest.rectangle.height).toEqual(
        defaultRS.scissorTest.rectangle.height
      );
      expect(rs.depthTest.enabled).toEqual(defaultRS.depthTest.enabled);
      expect(rs.depthTest.func).toEqual(defaultRS.depthTest.func);
      expect(rs.colorMask.red).toEqual(defaultRS.colorMask.red);
      expect(rs.colorMask.green).toEqual(defaultRS.colorMask.green);
      expect(rs.colorMask.blue).toEqual(defaultRS.colorMask.blue);
      expect(rs.colorMask.alpha).toEqual(defaultRS.colorMask.alpha);
      expect(rs.depthMask).toEqual(defaultRS.depthMask);
      expect(rs.stencilMask).toEqual(defaultRS.stencilMask);
      expect(rs.blending.enabled).toEqual(defaultRS.blending.enabled);
      expect(rs.blending.color.red).toEqual(defaultRS.blending.color.red);
      expect(rs.blending.color.green).toEqual(defaultRS.blending.color.green);
      expect(rs.blending.color.blue).toEqual(defaultRS.blending.color.blue);
      expect(rs.blending.color.alpha).toEqual(defaultRS.blending.color.alpha);
      expect(rs.blending.equationRgb).toEqual(defaultRS.blending.equationRgb);
      expect(rs.blending.equationAlpha).toEqual(
        defaultRS.blending.equationAlpha
      );
      expect(rs.blending.functionSourceRgb).toEqual(
        defaultRS.blending.functionSourceRgb
      );
      expect(rs.blending.functionSourceAlpha).toEqual(
        defaultRS.blending.functionSourceAlpha
      );
      expect(rs.blending.functionDestinationRgb).toEqual(
        defaultRS.blending.functionDestinationRgb
      );
      expect(rs.blending.functionDestinationAlpha).toEqual(
        defaultRS.blending.functionDestinationAlpha
      );
      expect(rs.stencilTest.enabled).toEqual(defaultRS.stencilTest.enabled);
      expect(rs.stencilTest.frontFunction).toEqual(
        defaultRS.stencilTest.frontFunction
      );
      expect(rs.stencilTest.backFunction).toEqual(
        defaultRS.stencilTest.backFunction
      );
      expect(rs.stencilTest.reference).toEqual(defaultRS.stencilTest.reference);
      expect(rs.stencilTest.mask).toEqual(defaultRS.stencilTest.mask);
      expect(rs.stencilTest.frontOperation.fail).toEqual(
        defaultRS.stencilTest.frontOperation.fail
      );
      expect(rs.stencilTest.frontOperation.zFail).toEqual(
        defaultRS.stencilTest.frontOperation.zFail
      );
      expect(rs.stencilTest.frontOperation.zPass).toEqual(
        defaultRS.stencilTest.frontOperation.zPass
      );
      expect(rs.stencilTest.backOperation.fail).toEqual(
        defaultRS.stencilTest.backOperation.fail
      );
      expect(rs.stencilTest.backOperation.zFail).toEqual(
        defaultRS.stencilTest.backOperation.zFail
      );
      expect(rs.stencilTest.backOperation.zPass).toEqual(
        defaultRS.stencilTest.backOperation.zPass
      );
      expect(rs.sampleCoverage.enabled).toEqual(
        defaultRS.sampleCoverage.enabled
      );
      expect(rs.sampleCoverage.value).toEqual(defaultRS.sampleCoverage.value);
      expect(rs.sampleCoverage.invert).toEqual(defaultRS.sampleCoverage.invert);
    });
    it("caches render states", function() {
      const rs = import__15.RenderState.fromCache();
      const rs2 = import__15.RenderState.fromCache();
      const rs3 = import__15.RenderState.fromCache({
        depthTest: {
          enabled: false,
          func: import__15.WebGLConstants.LESS
        }
      });
      const rs4 = import__15.RenderState.fromCache({
        depthTest: {
          enabled: true,
          func: import__15.WebGLConstants.NEVER
        }
      });
      expect(rs2).toBe(rs);
      expect(rs3).toBe(rs);
      expect(rs4).not.toBe(rs);
    });
    it("removes from render cache", function() {
      import__15.RenderState.clearCache();
      const cache = import__15.RenderState.getCache();
      const rs = import__15.RenderState.fromCache();
      const undefinedKey = JSON.stringify(void 0);
      const fullKey = JSON.stringify(new import__15.RenderState());
      expect(cache[fullKey].referenceCount).toEqual(1);
      expect(cache[undefinedKey].referenceCount).toEqual(1);
      const rs2 = import__15.RenderState.fromCache();
      expect(cache[fullKey].referenceCount).toEqual(1);
      expect(cache[undefinedKey].referenceCount).toEqual(2);
      const param = {
        depthTest: {
          enabled: false,
          func: import__15.WebGLConstants.LESS
        }
      };
      const rs3 = import__15.RenderState.fromCache(param);
      const paramKey = JSON.stringify(param);
      expect(rs2).toBe(rs);
      expect(rs3).toBe(rs);
      expect(cache[fullKey].referenceCount).toEqual(2);
      expect(cache[undefinedKey].referenceCount).toEqual(2);
      expect(cache[paramKey].referenceCount).toEqual(1);
      import__15.RenderState.removeFromCache(param);
      expect(cache[fullKey].referenceCount).toEqual(1);
      expect(cache[undefinedKey].referenceCount).toEqual(2);
      expect(cache[paramKey]).not.toBeDefined();
      import__15.RenderState.removeFromCache();
      import__15.RenderState.removeFromCache();
      expect(cache[undefinedKey]).not.toBeDefined();
      expect(cache[fullKey]).not.toBeDefined();
    });
    it("freezes render states", function() {
      const rs = import__15.RenderState.fromCache();
      expect(Object.isFrozen(rs)).toBe(!window.specsUsingRelease);
    });
    it("fails to create (frontFace)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          frontFace: "invalid value"
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (cull.face)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          cull: {
            face: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (small lineWidth)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          lineWidth: import__15.ContextLimits.minimumAliasedLineWidth - 1
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (large lineWidth)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          lineWidth: import__15.ContextLimits.maximumAliasedLineWidth + 1
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (negative scissorTest.rectangle.width)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          scissorTest: {
            rectangle: {
              x: 0,
              y: 0,
              width: -1,
              height: 0
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (negative scissorTest.rectangle.height)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          scissorTest: {
            rectangle: {
              x: 0,
              y: 0,
              width: 0,
              height: -1
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (near > far)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          depthRange: {
            near: 0.75,
            far: 0.25
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (near < 0)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          depthRange: {
            near: -1
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (far > 1)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          depthRange: {
            far: 2
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (depthTest.func)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          depthTest: {
            func: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blending.color < 0)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            color: {
              red: -1,
              green: 0,
              blue: 0,
              alpha: 0
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blending.color > 1)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            color: {
              red: 0,
              green: 0,
              blue: 0,
              alpha: 2
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blend.equationRgb)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            equationRgb: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blend.equationAlpha)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            equationAlpha: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blend.functionSourceRgb)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            functionSourceRgb: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blend.functionSourceAlpha)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            functionSourceAlpha: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blend.functionDestinationRgb)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            functionDestinationRgb: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blend.functionDestinationAlpha)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            functionDestinationAlpha: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.frontFunction)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            frontFunction: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.backFunction)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            backFunction: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.frontOperation.fail)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            frontOperation: {
              fail: "invalid value"
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.frontOperation.zFail)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            frontOperation: {
              zFail: "invalid value"
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.frontOperation.zPass)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            frontOperation: {
              zPass: "invalid value"
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.backOperation.fail)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            backOperation: {
              fail: "invalid value"
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.backOperation.zFail)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            backOperation: {
              zFail: "invalid value"
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.backOperation.zPass)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            backOperation: {
              zPass: "invalid value"
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to get state without renderState", function() {
      expect(function() {
        import__15.RenderState.getState(void 0);
      }).toThrowDeveloperError();
    });
    it("clones", function() {
      const r = {
        frontFace: import__15.WindingOrder.CLOCKWISE,
        cull: {
          enabled: true,
          face: import__15.WebGLConstants.FRONT
        },
        lineWidth: import__15.ContextLimits.maximumAliasedLineWidth,
        polygonOffset: {
          enabled: false,
          factor: 1,
          units: 1
        },
        scissorTest: {
          enabled: true,
          rectangle: {
            x: 1,
            y: 1,
            width: 2,
            height: 2
          }
        },
        depthRange: {
          near: 0.25,
          far: 0.75
        },
        depthTest: {
          enabled: true,
          func: import__15.WebGLConstants.GREATER
        },
        colorMask: {
          red: false,
          green: false,
          blue: false,
          alpha: false
        },
        depthMask: false,
        stencilMask: 0,
        blending: {
          enabled: true,
          color: {
            red: 1,
            green: 1,
            blue: 1,
            alpha: 1
          },
          equationRgb: import__15.WebGLConstants.FUNC_SUBTRACT,
          equationAlpha: import__15.WebGLConstants.FUNC_SUBTRACT,
          functionSourceRgb: import__15.WebGLConstants.ZERO,
          functionSourceAlpha: import__15.WebGLConstants.ZERO,
          functionDestinationRgb: import__15.WebGLConstants.ONE,
          functionDestinationAlpha: import__15.WebGLConstants.ONE
        },
        stencilTest: {
          enabled: true,
          frontFunction: import__15.WebGLConstants.NEVER,
          backFunction: import__15.WebGLConstants.NEVER,
          reference: 1,
          mask: 0,
          frontOperation: {
            fail: import__15.WebGLConstants.REPLACE,
            zFail: import__15.WebGLConstants.REPLACE,
            zPass: import__15.WebGLConstants.REPLACE
          },
          backOperation: {
            fail: import__15.WebGLConstants.REPLACE,
            zFail: import__15.WebGLConstants.REPLACE,
            zPass: import__15.WebGLConstants.REPLACE
          }
        },
        sampleCoverage: {
          enabled: true,
          value: 0.5,
          invert: true
        }
      };
      const rs = import__15.RenderState.fromCache(import__15.RenderState.getState(r));
      expect(rs.frontFace).toEqual(r.frontFace);
      expect(rs.cull.enabled).toEqual(r.cull.enabled);
      expect(rs.cull.face).toEqual(r.cull.face);
      expect(rs.cull.lineWidth).toEqual(r.cull.lineWidth);
      expect(rs.polygonOffset.enabled).toEqual(r.polygonOffset.enabled);
      expect(rs.polygonOffset.factor).toEqual(r.polygonOffset.factor);
      expect(rs.polygonOffset.units).toEqual(r.polygonOffset.units);
      expect(rs.scissorTest.enabled).toEqual(r.scissorTest.enabled);
      expect(rs.scissorTest.rectangle.x).toEqual(r.scissorTest.rectangle.x);
      expect(rs.scissorTest.rectangle.y).toEqual(r.scissorTest.rectangle.y);
      expect(rs.scissorTest.rectangle.width).toEqual(
        r.scissorTest.rectangle.width
      );
      expect(rs.scissorTest.rectangle.height).toEqual(
        r.scissorTest.rectangle.height
      );
      expect(rs.depthRange.near).toEqual(r.depthRange.near);
      expect(rs.depthRange.far).toEqual(r.depthRange.far);
      expect(rs.depthTest.enabled).toEqual(r.depthTest.enabled);
      expect(rs.depthTest.func).toEqual(r.depthTest.func);
      expect(rs.colorMask.red).toEqual(r.colorMask.red);
      expect(rs.colorMask.green).toEqual(r.colorMask.green);
      expect(rs.colorMask.blue).toEqual(r.colorMask.blue);
      expect(rs.colorMask.alpha).toEqual(r.colorMask.alpha);
      expect(rs.depthMask).toEqual(r.depthMask);
      expect(rs.stencilMask).toEqual(r.stencilMask);
      expect(rs.blending.enabled).toEqual(r.blending.enabled);
      expect(rs.blending.color.red).toEqual(r.blending.color.red);
      expect(rs.blending.color.green).toEqual(r.blending.color.green);
      expect(rs.blending.color.blue).toEqual(r.blending.color.blue);
      expect(rs.blending.color.alpha).toEqual(r.blending.color.alpha);
      expect(rs.blending.equationRgb).toEqual(r.blending.equationRgb);
      expect(rs.blending.equationAlpha).toEqual(r.blending.equationAlpha);
      expect(rs.blending.functionSourceRgb).toEqual(
        r.blending.functionSourceRgb
      );
      expect(rs.blending.functionSourceAlpha).toEqual(
        r.blending.functionSourceAlpha
      );
      expect(rs.blending.functionDestinationRgb).toEqual(
        r.blending.functionDestinationRgb
      );
      expect(rs.blending.functionDestinationAlpha).toEqual(
        r.blending.functionDestinationAlpha
      );
      expect(rs.stencilTest.enabled).toEqual(r.stencilTest.enabled);
      expect(rs.stencilTest.frontFunction).toEqual(r.stencilTest.frontFunction);
      expect(rs.stencilTest.backFunction).toEqual(r.stencilTest.backFunction);
      expect(rs.stencilTest.reference).toEqual(r.stencilTest.reference);
      expect(rs.stencilTest.mask).toEqual(r.stencilTest.mask);
      expect(rs.stencilTest.frontOperation.fail).toEqual(
        r.stencilTest.frontOperation.fail
      );
      expect(rs.stencilTest.frontOperation.zFail).toEqual(
        r.stencilTest.frontOperation.zFail
      );
      expect(rs.stencilTest.frontOperation.zPass).toEqual(
        r.stencilTest.frontOperation.zPass
      );
      expect(rs.stencilTest.backOperation.fail).toEqual(
        r.stencilTest.backOperation.fail
      );
      expect(rs.stencilTest.backOperation.zFail).toEqual(
        r.stencilTest.backOperation.zFail
      );
      expect(rs.stencilTest.backOperation.zPass).toEqual(
        r.stencilTest.backOperation.zPass
      );
      expect(rs.sampleCoverage.enabled).toEqual(r.sampleCoverage.enabled);
      expect(rs.sampleCoverage.value).toEqual(r.sampleCoverage.value);
      expect(rs.sampleCoverage.invert).toEqual(r.sampleCoverage.invert);
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/RenderbufferSpec.js
var import__16 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Renderbuffer",
  function() {
    let context;
    let renderbuffer;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    afterEach(function() {
      renderbuffer = renderbuffer && renderbuffer.destroy();
    });
    it("creates", function() {
      renderbuffer = new import__16.Renderbuffer({
        context,
        format: import__16.RenderbufferFormat.DEPTH_COMPONENT16,
        width: 64,
        height: 32
      });
      expect(renderbuffer.format).toEqual(import__16.RenderbufferFormat.DEPTH_COMPONENT16);
      expect(renderbuffer.width).toEqual(64);
      expect(renderbuffer.height).toEqual(32);
    });
    it("creates with defaults", function() {
      renderbuffer = new import__16.Renderbuffer({
        context
      });
      expect(renderbuffer.format).toEqual(import__16.RenderbufferFormat.RGBA4);
      expect(renderbuffer.width).toEqual(context.canvas.clientWidth);
      expect(renderbuffer.height).toEqual(context.canvas.clientHeight);
    });
    it("destroys", function() {
      const r = new import__16.Renderbuffer({
        context
      });
      expect(r.isDestroyed()).toEqual(false);
      r.destroy();
      expect(r.isDestroyed()).toEqual(true);
    });
    it("throws when created with invalid format", function() {
      expect(function() {
        renderbuffer = new import__16.Renderbuffer({
          context,
          format: "invalid format"
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with small width", function() {
      expect(function() {
        renderbuffer = new import__16.Renderbuffer({
          context,
          width: 0
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with large width", function() {
      expect(function() {
        renderbuffer = new import__16.Renderbuffer({
          context,
          width: import__16.ContextLimits.maximumRenderbufferSize + 1
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with small height", function() {
      expect(function() {
        renderbuffer = new import__16.Renderbuffer({
          context,
          height: 0
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with large height", function() {
      expect(function() {
        renderbuffer = new import__16.Renderbuffer({
          context,
          height: import__16.ContextLimits.maximumRenderbufferSize + 1
        });
      }).toThrowDeveloperError();
    });
    it("throws when fails to destroy", function() {
      const r = new import__16.Renderbuffer({
        context
      });
      r.destroy();
      expect(function() {
        r.destroy();
      }).toThrowDeveloperError();
    });
    it("throws when there is no context", function() {
      expect(function() {
        return new import__16.Renderbuffer();
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/SamplerSpec.js
var import__17 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Sampler",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("has expected default values", function() {
      const sampler = new import__17.Sampler();
      expect(sampler.wrapS).toEqual(import__17.TextureWrap.CLAMP_TO_EDGE);
      expect(sampler.wrapT).toEqual(import__17.TextureWrap.CLAMP_TO_EDGE);
      expect(sampler.minificationFilter).toEqual(
        import__17.TextureMinificationFilter.LINEAR
      );
      expect(sampler.magnificationFilter).toEqual(
        import__17.TextureMinificationFilter.LINEAR
      );
      expect(sampler.maximumAnisotropy).toEqual(1);
    });
    it("throws when creating a sampler with invalid wrapS", function() {
      expect(function() {
        return new import__17.Sampler({
          wrapS: "invalid wrap"
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a sampler with invalid wrapT", function() {
      expect(function() {
        return new import__17.Sampler({
          wrapT: "invalid wrap"
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a sampler with invalid minificationFilter", function() {
      expect(function() {
        return new import__17.Sampler({
          minificationFilter: "invalid filter"
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a sampler with invalid magnificationFilter", function() {
      expect(function() {
        return new import__17.Sampler({
          magnificationFilter: "invalid filter"
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a sampler with invalid maximumAnisotropy", function() {
      expect(function() {
        return new import__17.Sampler({
          maximumAnisotropy: 0
        });
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/ShaderBuilderSpec.js
var import__18 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/ShaderBuilder",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    function checkVertexShader(shaderProgram, expectedDefines, expectedSources) {
      expectedSources = [expectedSources.join("\n")];
      const expectedText = new import__18.ShaderSource({
        defines: expectedDefines,
        sources: expectedSources
      }).createCombinedVertexShader(context);
      expect(shaderProgram._vertexShaderText).toEqual(expectedText);
    }
    function checkFragmentShader(shaderProgram, expectedDefines, expectedSources) {
      expectedSources = [expectedSources.join("\n")];
      const expectedText = new import__18.ShaderSource({
        defines: expectedDefines,
        sources: expectedSources
      }).createCombinedFragmentShader(context);
      expect(shaderProgram._fragmentShaderText).toEqual(expectedText);
    }
    it("creates an empty shader by default", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, [], []);
      checkFragmentShader(shaderProgram, [], []);
    });
    it("addDefine throws for undefined identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addDefine(void 0);
      }).toThrowDeveloperError();
    });
    it("addDefine throws for invalid identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addDefine(42);
      }).toThrowDeveloperError();
    });
    it("addDefine defines macros without values", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addDefine("USE_SHADOWS");
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, ["USE_SHADOWS"], []);
      checkFragmentShader(shaderProgram, ["USE_SHADOWS"], []);
    });
    it("addDefine defines macros with values", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addDefine("PI", 3.1415);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, ["PI 3.1415"], []);
      checkFragmentShader(shaderProgram, ["PI 3.1415"], []);
    });
    it("addDefine puts the define in the destination shader(s)", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addDefine("POINT_SIZE", 2, import__18.ShaderDestination.VERTEX);
      shaderBuilder.addDefine("PI", 3.1415, import__18.ShaderDestination.FRAGMENT);
      shaderBuilder.addDefine(
        "USE_FRAGMENT_SHADING",
        1,
        import__18.ShaderDestination.BOTH
      );
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(
        shaderProgram,
        ["POINT_SIZE 2", "USE_FRAGMENT_SHADING 1"],
        []
      );
      checkFragmentShader(
        shaderProgram,
        ["PI 3.1415", "USE_FRAGMENT_SHADING 1"],
        []
      );
    });
    it("addDefine defaults to both shaders", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addDefine("PI", 3.1415);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, ["PI 3.1415"], []);
      checkFragmentShader(shaderProgram, ["PI 3.1415"], []);
    });
    it("addStruct throws for undefined structId", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addStruct(
          void 0,
          "TestStruct",
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addStruct throws for invalid structId", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addStruct(
          {},
          "TestStruct",
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addStruct throws for undefined structName", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addStruct(
          "testStruct",
          void 0,
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addStruct throws for invalid structId", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addStruct(
          "testStruct",
          {},
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addStruct throws for undefined destination", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addStruct("testStruct", "TestStruct", void 0);
      }).toThrowDeveloperError();
    });
    it("addStruct throws for invalid structId", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addStruct("testStruct", "TestStruct", "vertex");
      }).toThrowDeveloperError();
    });
    it("addStruct adds a struct to the shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      shaderBuilder.addStruct(
        "structFS",
        "TestStruct",
        import__18.ShaderDestination.FRAGMENT
      );
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(
        shaderProgram,
        [],
        ["struct TestStruct", "{", "    float _empty;", "};"]
      );
      checkFragmentShader(
        shaderProgram,
        [],
        ["struct TestStruct", "{", "    float _empty;", "};"]
      );
    });
    it("addStructField throws for undefined structId", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addStructField(void 0, "vec3", "positionMC");
      }).toThrowDeveloperError();
    });
    it("addStructField throws for invalid structId", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addStructField(-1, "vec3", "positionMC");
      }).toThrowDeveloperError();
    });
    it("addStructField throws for undefined type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addStructField(
          "structVS",
          void 0,
          "positionMC"
        );
      }).toThrowDeveloperError();
    });
    it("addStructField throws for invalid type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addStructField("structVS", -1, "positionMC");
      }).toThrowDeveloperError();
    });
    it("addStructField throws for undefined identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addStructField("structVS", "vec3", void 0);
      }).toThrowDeveloperError();
    });
    it("addStructField throws for invalid identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addStructField("structVS", "vec3", -1);
      }).toThrowDeveloperError();
    });
    it("addStructField adds a struct field to the shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      shaderBuilder.addStruct(
        "structFS",
        "TestStruct",
        import__18.ShaderDestination.FRAGMENT
      );
      shaderBuilder.addStructField("structVS", "vec3", "positionMC");
      shaderBuilder.addStructField("structFS", "vec3", "positionMC");
      shaderBuilder.addStructField("structFS", "float", "temperature");
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(
        shaderProgram,
        [],
        ["struct TestStruct", "{", "    vec3 positionMC;", "};"]
      );
      checkFragmentShader(
        shaderProgram,
        [],
        [
          "struct TestStruct",
          "{",
          "    vec3 positionMC;",
          "    float temperature;",
          "};"
        ]
      );
    });
    const signature = "float circleMask(float radius)";
    it("addFunction throws for undefined functionName", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFunction(
          void 0,
          signature,
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addFunction throws for invalid functionName", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFunction(
          {},
          signature,
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addFunction throws for undefined signature", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFunction(
          "testFunction",
          void 0,
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addFunction throws for invalid signature", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFunction(
          "testFunction",
          -1,
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addFunction throws for undefined destination", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFunction("testFunction", signature, void 0);
      }).toThrowDeveloperError();
    });
    it("addFunction throws for invalid structId", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFunction("testFunction", signature, "fragment");
      }).toThrowDeveloperError();
    });
    it("addFunction adds a struct to the shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFunction(
        "testFunctionVS",
        signature,
        import__18.ShaderDestination.VERTEX
      );
      shaderBuilder.addFunction(
        "testFunctionFS",
        signature,
        import__18.ShaderDestination.FRAGMENT
      );
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, [], [signature, "{", "}"]);
      checkFragmentShader(shaderProgram, [], [signature, "{", "}"]);
    });
    it("addFunctionLines throws for undefined functionName", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFunction(
        "testFunctionVS",
        signature,
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addFunctionLines(void 0, "return 1.0;");
      }).toThrowDeveloperError();
    });
    it("addFunctionLines throws for invalid functionName", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFunction(
        "testFunctionVS",
        signature,
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addFunctionLines(-1, "return 1.0;");
      }).toThrowDeveloperError();
    });
    it("addFunctionLines throws for undefined lines", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFunction(
        "testFunctionVS",
        signature,
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addFunctionLines("testFunctionVS", void 0);
      }).toThrowDeveloperError();
    });
    it("addFunctionLines throws for invalid lines", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFunction(
        "testFunctionVS",
        signature,
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addFunctionLines("testFunctionVS", -1);
      }).toThrowDeveloperError();
    });
    it("addFunctionLines adds lines to the body of a function", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFunction(
        "testFunctionVS",
        signature,
        import__18.ShaderDestination.VERTEX
      );
      shaderBuilder.addFunction(
        "testFunctionFS",
        signature,
        import__18.ShaderDestination.FRAGMENT
      );
      shaderBuilder.addFunctionLines("testFunctionVS", [
        "v_color = vec3(0.0);",
        "return 1.0;"
      ]);
      shaderBuilder.addFunctionLines("testFunctionFS", [
        "return 1.0 - step(0.3, radius);"
      ]);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(
        shaderProgram,
        [],
        [signature, "{", "    v_color = vec3(0.0);", "    return 1.0;", "}"]
      );
      checkFragmentShader(
        shaderProgram,
        [],
        [signature, "{", "    return 1.0 - step(0.3, radius);", "}"]
      );
    });
    it("addFunctionLines adds a single line to the body of the function", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFunction(
        "testFunctionVS",
        signature,
        import__18.ShaderDestination.VERTEX
      );
      shaderBuilder.addFunction(
        "testFunctionFS",
        signature,
        import__18.ShaderDestination.FRAGMENT
      );
      shaderBuilder.addFunctionLines("testFunctionVS", "return 1.0;");
      shaderBuilder.addFunctionLines("testFunctionFS", "return 2.0;");
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(
        shaderProgram,
        [],
        [signature, "{", "    return 1.0;", "}"]
      );
      checkFragmentShader(
        shaderProgram,
        [],
        [signature, "{", "    return 2.0;", "}"]
      );
    });
    it("addUniform throws for undefined type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addUniform(void 0, "u_time");
      }).toThrowDeveloperError();
    });
    it("addUniform throws for invalid type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addUniform(10, "u_time");
      }).toThrowDeveloperError();
    });
    it("addUniform throws for undefined identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addUniform("vec3");
      }).toThrowDeveloperError();
    });
    it("addUniform throws for invalid identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addUniform("vec3", 0);
      }).toThrowDeveloperError();
    });
    it("addUniform puts the uniform in the destination shader(s)", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addUniform(
        "vec3",
        "u_gridDimensions",
        import__18.ShaderDestination.VERTEX
      );
      shaderBuilder.addUniform(
        "vec2",
        "u_mousePosition",
        import__18.ShaderDestination.FRAGMENT
      );
      shaderBuilder.addUniform("float", "u_time", import__18.ShaderDestination.BOTH);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(
        shaderProgram,
        [],
        ["uniform vec3 u_gridDimensions;", "uniform float u_time;"]
      );
      checkFragmentShader(
        shaderProgram,
        [],
        ["uniform vec2 u_mousePosition;", "uniform float u_time;"]
      );
    });
    it("addUniform defaults to both shaders", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addUniform("float", "u_time");
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, [], ["uniform float u_time;"]);
      checkFragmentShader(shaderProgram, [], ["uniform float u_time;"]);
    });
    it("setPositionAttribute throws for undefined type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.setPositionAttribute(void 0, "a_position");
      }).toThrowDeveloperError();
    });
    it("setPositionAttribute throws for invalid type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.setPositionAttribute(0, "a_position");
      }).toThrowDeveloperError();
    });
    it("setPositionAttribute throws for undefined identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.setPositionAttribute("vec3", void 0);
      }).toThrowDeveloperError();
    });
    it("setPositionAttribute throws for invalid identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.setPositionAttribute("vec3", 0);
      }).toThrowDeveloperError();
    });
    it("setPositionAttribute creates a position attribute in location 0", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      const normalLocation = shaderBuilder.addAttribute("vec3", "a_normal");
      const positionLocation = shaderBuilder.setPositionAttribute(
        "vec3",
        "a_position"
      );
      expect(positionLocation).toBe(0);
      expect(normalLocation).toBe(1);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      const expectedAttributes = ["in vec3 a_position;", "in vec3 a_normal;"];
      checkVertexShader(shaderProgram, [], expectedAttributes);
      checkFragmentShader(shaderProgram, [], []);
      const expectedLocations = {
        a_position: 0,
        a_normal: 1
      };
      expect(shaderBuilder.attributeLocations).toEqual(expectedLocations);
      expect(shaderProgram._attributeLocations).toEqual(expectedLocations);
    });
    it("setPositionAttribute throws if called twice", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      const positionLocation = shaderBuilder.setPositionAttribute(
        "vec3",
        "a_position"
      );
      expect(positionLocation).toBe(0);
      expect(function() {
        return shaderBuilder.setPositionAttribute("vec3", "a_position2");
      }).toThrowDeveloperError();
    });
    it("addAttribute throws for undefined type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addAttribute(void 0, "a_position");
      }).toThrowDeveloperError();
    });
    it("addAttribute throws for invalid type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addAttribute(0, "a_position");
      }).toThrowDeveloperError();
    });
    it("addAttribute throws for undefined identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addAttribute("vec2", void 0);
      }).toThrowDeveloperError();
    });
    it("addAttribute throws for invalid identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addAttribute("vec2", 0);
      }).toThrowDeveloperError();
    });
    it("addAttribute creates an attribute in the vertex shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      const colorLocation = shaderBuilder.addAttribute("vec4", "a_color");
      const normalLocation = shaderBuilder.addAttribute("vec3", "a_normal");
      expect(colorLocation).toBe(1);
      expect(normalLocation).toBe(2);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      const expectedAttributes = ["in vec4 a_color;", "in vec3 a_normal;"];
      checkVertexShader(shaderProgram, [], expectedAttributes);
      checkFragmentShader(shaderProgram, [], []);
      const expectedLocations = {
        a_color: 1,
        a_normal: 2
      };
      expect(shaderBuilder.attributeLocations).toEqual(expectedLocations);
      expect(shaderProgram._attributeLocations).toEqual(expectedLocations);
    });
    it("addAttribute handles matrix attribute locations correctly", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      const matrixLocation = shaderBuilder.addAttribute("mat3", "a_warpMatrix");
      const colorLocation = shaderBuilder.addAttribute("vec3", "a_color");
      expect(matrixLocation).toBe(1);
      expect(colorLocation).toBe(4);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      const expectedAttributes = ["in mat3 a_warpMatrix;", "in vec3 a_color;"];
      checkVertexShader(shaderProgram, [], expectedAttributes);
      checkFragmentShader(shaderProgram, [], []);
      const expectedLocations = {
        a_warpMatrix: 1,
        a_color: 4
      };
      expect(shaderBuilder.attributeLocations).toEqual(expectedLocations);
      expect(shaderProgram._attributeLocations).toEqual(expectedLocations);
    });
    it("addVarying throws for undefined type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addVarying(void 0, "v_uv");
      }).toThrowDeveloperError();
    });
    it("addVarying throws for invalid type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addVarying(0, "v_uv");
      }).toThrowDeveloperError();
    });
    it("addVarying throws for undefined identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addVarying("vec2", void 0);
      }).toThrowDeveloperError();
    });
    it("addVarying throws for invalid identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addVarying("vec2", 0);
      }).toThrowDeveloperError();
    });
    it("addVarying adds varyings to both shaders", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addVarying("vec2", "v_uv");
      const expectedVaryings = ["vec2 v_uv;"];
      const expectedVertexVaryings = expectedVaryings.map(
        (varying) => `out ${varying}`
      );
      const expectedFragmentVaryings = expectedVaryings.map(
        (varying) => `in ${varying}`
      );
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, [], expectedVertexVaryings);
      checkFragmentShader(shaderProgram, [], expectedFragmentVaryings);
    });
    it("addVertexLines throws for undefined lines", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addVertexLines(void 0);
      }).toThrowDeveloperError();
    });
    it("addVertexLines throws for invalid lines", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addVertexLines(-1);
      }).toThrowDeveloperError();
    });
    it("addVertexLines appends lines to the vertex shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      const vertexLines = [
        "void main()",
        "{",
        "    gl_Position = vec4(0.0, 0.0, 0.0, 1.0);",
        "}"
      ];
      shaderBuilder.addVertexLines(vertexLines);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, [], vertexLines);
    });
    it("addVertexLines appends a single line to the shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addVertexLines("float sum;");
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, [], ["float sum;"]);
    });
    it("addFragmentLines throws for undefined lines", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFragmentLines(void 0);
      }).toThrowDeveloperError();
    });
    it("addFragmentLines throws for invalid lines", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFragmentLines(-1);
      }).toThrowDeveloperError();
    });
    it("addFragmentLines appends lines to the fragment shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      const fragmentLines = [
        "void main()",
        "{",
        "    out_FragColor = vec4(1.0, 0.5, 0.0, 1.0);",
        "}"
      ];
      shaderBuilder.addFragmentLines(fragmentLines);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkFragmentShader(shaderProgram, [], fragmentLines);
    });
    it("addFragmentLines appends a single line to the fragment shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFragmentLines("float sum;");
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkFragmentShader(shaderProgram, [], ["float sum;"]);
    });
    it("buildShaderProgram throws for undefined context", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.buildShaderProgram(void 0);
      }).toThrowDeveloperError();
    });
    it("buildShaderProgram creates a shaderProgram", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.setPositionAttribute("vec3", "a_position");
      shaderBuilder.addAttribute("vec3", "a_uv");
      shaderBuilder.addVarying("vec2", "v_uv");
      shaderBuilder.addDefine("BLUE_TINT", 0.5, import__18.ShaderDestination.FRAGMENT);
      const vertexLines = [
        "void main()",
        "{",
        "    v_uv = a_uv",
        "    gl_Position = vec4(a_position, 1.0);",
        "}"
      ];
      shaderBuilder.addVertexLines(vertexLines);
      const fragmentLines = [
        "void main()",
        "{",
        "    out_FragColor = vec4(v_uv, BLUE_TINT, 1.0);",
        "}"
      ];
      shaderBuilder.addFragmentLines(fragmentLines);
      const expectedAttributes = ["in vec3 a_position;", "in vec3 a_uv;"];
      const expectedVaryings = ["vec2 v_uv;"];
      const expectedVertexVaryings = expectedVaryings.map(
        (varying) => `out ${varying}`
      );
      const expectedFragmentVaryings = expectedVaryings.map(
        (varying) => `in ${varying}`
      );
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(
        shaderProgram,
        [],
        expectedAttributes.concat(expectedVertexVaryings, vertexLines)
      );
      checkFragmentShader(
        shaderProgram,
        ["BLUE_TINT 0.5"],
        expectedFragmentVaryings.concat(fragmentLines)
      );
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/ShaderCacheSpec.js
var import__19 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/ShaderCache",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("adds and removes", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      expect(sp._cachedShader.count).toEqual(1);
      expect(cache.numberOfShaders).toEqual(1);
      cache.releaseShaderProgram(sp);
      expect(sp.isDestroyed()).toEqual(false);
      expect(cache.numberOfShaders).toEqual(1);
      cache.destroyReleasedShaderPrograms();
      expect(sp.isDestroyed()).toEqual(true);
      expect(cache.numberOfShaders).toEqual(0);
      cache.destroy();
    });
    it("adds and removes 2", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      expect(sp._cachedShader.count).toEqual(1);
      sp.destroy();
      expect(sp.isDestroyed()).toEqual(false);
      cache.destroyReleasedShaderPrograms();
      expect(sp.isDestroyed()).toEqual(true);
      cache.destroy();
    });
    it("has a cache hit", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      spyOn(
        import__19.ShaderSource.prototype,
        "createCombinedVertexShader"
      ).and.callThrough();
      spyOn(
        import__19.ShaderSource.prototype,
        "createCombinedFragmentShader"
      ).and.callThrough();
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      const sp2 = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      expect(sp).toBe(sp2);
      expect(sp._cachedShader.count).toEqual(2);
      expect(cache.numberOfShaders).toEqual(1);
      expect(
        import__19.ShaderSource.prototype.createCombinedVertexShader
      ).toHaveBeenCalledTimes(1);
      expect(
        import__19.ShaderSource.prototype.createCombinedFragmentShader
      ).toHaveBeenCalledTimes(1);
      sp.destroy();
      sp2.destroy();
      cache.destroyReleasedShaderPrograms();
      expect(sp.isDestroyed()).toEqual(true);
      expect(cache.numberOfShaders).toEqual(0);
      cache.destroy();
    });
    it("cache handles unordered attributeLocations dictionary", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const attributeLocations = {
        position: 0,
        normal: 1,
        color: 2
      };
      const attributeLocationsReordered = {
        color: 2,
        position: 0,
        normal: 1
      };
      spyOn(
        import__19.ShaderSource.prototype,
        "createCombinedVertexShader"
      ).and.callThrough();
      spyOn(
        import__19.ShaderSource.prototype,
        "createCombinedFragmentShader"
      ).and.callThrough();
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations
      });
      const sp2 = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: attributeLocationsReordered
      });
      expect(sp).toBe(sp2);
      expect(sp._cachedShader.count).toEqual(2);
      expect(cache.numberOfShaders).toEqual(1);
      expect(
        import__19.ShaderSource.prototype.createCombinedVertexShader
      ).toHaveBeenCalledTimes(1);
      expect(
        import__19.ShaderSource.prototype.createCombinedFragmentShader
      ).toHaveBeenCalledTimes(1);
      sp.destroy();
      sp2.destroy();
      cache.destroyReleasedShaderPrograms();
      expect(sp.isDestroyed()).toEqual(true);
      expect(cache.numberOfShaders).toEqual(0);
      cache.destroy();
    });
    it("replaces a shader program", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const fs2 = "void main() { out_FragColor = vec4(0.5); }";
      const attributeLocations = {
        position: 0
      };
      const cache = new import__19.ShaderCache(context);
      const sp = cache.replaceShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations
      });
      const sp2 = cache.replaceShaderProgram({
        shaderProgram: sp,
        vertexShaderSource: vs,
        fragmentShaderSource: fs2,
        attributeLocations
      });
      expect(sp._cachedShader.count).toEqual(0);
      expect(sp2._cachedShader.count).toEqual(1);
      cache.destroy();
    });
    it("avoids thrashing", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      sp.destroy();
      const sp2 = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      cache.destroyReleasedShaderPrograms();
      expect(sp.isDestroyed()).toEqual(false);
      expect(sp2.isDestroyed()).toEqual(false);
      sp2.destroy();
      cache.destroyReleasedShaderPrograms();
      expect(sp.isDestroyed()).toEqual(true);
      expect(sp2.isDestroyed()).toEqual(true);
      cache.destroy();
    });
    it("create derived shader program", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      const keyword = "derived";
      let spDerived = cache.getDerivedShaderProgram(sp, keyword);
      expect(spDerived).not.toBeDefined();
      const fsDerived = "void main() { out_FragColor = vec4(vec3(1.0), 0.5); }";
      spDerived = cache.createDerivedShaderProgram(sp, keyword, {
        vertexShaderSource: vs,
        fragmentShaderSource: fsDerived,
        attributeLocations: {
          position: 0
        }
      });
      expect(spDerived).toBeDefined();
      cache.destroy();
    });
    it("replaces derived shader program", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      const derivedKeywords = sp._cachedShader.derivedKeywords;
      const keyword = "derived";
      const fsDerived = "void main() { out_FragColor = vec4(vec3(1.0), 0.5); }";
      const spDerived = cache.replaceDerivedShaderProgram(sp, keyword, {
        vertexShaderSource: vs,
        fragmentShaderSource: fsDerived,
        attributeLocations: {
          position: 0
        }
      });
      expect(spDerived).toBeDefined();
      expect(derivedKeywords.length).toBe(1);
      const fsDerived2 = "void main() { out_FragColor = vec4(vec3(0.5), 0.5); }";
      const spDerived2 = cache.replaceDerivedShaderProgram(sp, keyword, {
        vertexShaderSource: vs,
        fragmentShaderSource: fsDerived2,
        attributeLocations: {
          position: 0
        }
      });
      expect(spDerived.isDestroyed()).toBe(true);
      expect(spDerived2.isDestroyed()).toBe(false);
      expect(derivedKeywords.length).toBe(1);
      cache.destroy();
    });
    it("destroying a shader program destroys its derived shaders", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      const keyword = "derived";
      const fsDerived = "void main() { out_FragColor = vec4(vec3(1.0), 0.5); }";
      const spDerived = cache.createDerivedShaderProgram(sp, keyword, {
        vertexShaderSource: vs,
        fragmentShaderSource: fsDerived,
        attributeLocations: {
          position: 0
        }
      });
      expect(spDerived).toBeDefined();
      sp.destroy();
      cache.destroyReleasedShaderPrograms();
      expect(sp.isDestroyed()).toEqual(true);
      expect(spDerived.isDestroyed()).toEqual(true);
      cache.destroy();
    });
    it("is destroyed", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      cache.destroy();
      expect(sp.isDestroyed()).toEqual(true);
      expect(cache.isDestroyed()).toEqual(true);
    });
    it("is not destroyed", function() {
      const cache = new import__19.ShaderCache(context);
      expect(cache.isDestroyed()).toEqual(false);
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/ShaderDestinationSpec.js
var import__20 = __toESM(require_Cesium(), 1);
describe("Renderer/ShaderDestination", function() {
  it("includesVertexShader throws for undefined destination", function() {
    expect(function() {
      return import__20.ShaderDestination.includesVertexShader(void 0);
    }).toThrowDeveloperError();
  });
  it("includesVertexShader works", function() {
    expect(
      import__20.ShaderDestination.includesVertexShader(import__20.ShaderDestination.VERTEX)
    ).toBe(true);
    expect(
      import__20.ShaderDestination.includesVertexShader(import__20.ShaderDestination.FRAGMENT)
    ).toBe(false);
    expect(import__20.ShaderDestination.includesVertexShader(import__20.ShaderDestination.BOTH)).toBe(
      true
    );
  });
  it("includesFragmentShader throws for undefined destination", function() {
    expect(function() {
      return import__20.ShaderDestination.includesFragmentShader(void 0);
    }).toThrowDeveloperError();
  });
  it("includesFragmentShader works", function() {
    expect(
      import__20.ShaderDestination.includesFragmentShader(import__20.ShaderDestination.VERTEX)
    ).toBe(false);
    expect(
      import__20.ShaderDestination.includesFragmentShader(import__20.ShaderDestination.FRAGMENT)
    ).toBe(true);
    expect(
      import__20.ShaderDestination.includesFragmentShader(import__20.ShaderDestination.BOTH)
    ).toBe(true);
  });
});

// packages/engine/Specs/Renderer/ShaderFunctionSpec.js
var import__21 = __toESM(require_Cesium(), 1);
describe("Renderer/ShaderFunction", function() {
  const signature = "vec3 testFunction(vec3 position)";
  it("constructs", function() {
    const func = new import__21.ShaderFunction(signature);
    expect(func.signature).toEqual(signature);
    expect(func.body).toEqual([]);
  });
  it("addLines throws without lines", function() {
    const func = new import__21.ShaderFunction("TestFunction");
    expect(function() {
      return func.addLines();
    }).toThrowDeveloperError();
  });
  it("addLines throws for invalid lines", function() {
    const func = new import__21.ShaderFunction("TestFunction");
    expect(function() {
      return func.addLines(100);
    }).toThrowDeveloperError();
  });
  it("addLines adds lines to the function body", function() {
    const func = new import__21.ShaderFunction("TestFunction");
    func.addLines(["v_color = a_color;", "return vec3(0.0, 0.0, 1.0);"]);
    expect(func.body).toEqual([
      "    v_color = a_color;",
      "    return vec3(0.0, 0.0, 1.0);"
    ]);
  });
  it("addLines accepts a single string", function() {
    const func = new import__21.ShaderFunction("TestFunction");
    func.addLines("v_color = a_color;");
    expect(func.body).toEqual(["    v_color = a_color;"]);
  });
  it("generateGlslLines generates a function", function() {
    const func = new import__21.ShaderFunction(signature);
    func.addLines(["v_color = a_color;", "return vec3(0.0, 0.0, 1.0);"]);
    expect(func.generateGlslLines()).toEqual([
      signature,
      "{",
      "    v_color = a_color;",
      "    return vec3(0.0, 0.0, 1.0);",
      "}"
    ]);
  });
});

// packages/engine/Specs/Renderer/ShaderProgramSpec.js
var import__22 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/ShaderProgram",
  function() {
    const webglStub = !!window.webglStub;
    let context;
    let sp;
    const injectedTestFunctions = {
      czm_circularDependency1: "void czm_circularDependency1() { czm_circularDependency2(); }",
      czm_circularDependency2: "void czm_circularDependency2() { czm_circularDependency1(); }",
      czm_testFunction3: "void czm_testFunction3(vec4 color) { czm_testFunction2(color); }",
      czm_testFunction2: "void czm_testFunction2(vec4 color) { czm_testFunction1(color); }",
      czm_testFunction1: "void czm_testFunction1(vec4 color) { out_FragColor = color; }",
      czm_testDiamondDependency1: "vec4 czm_testDiamondDependency1(vec4 color) { return czm_testAddAlpha(color); }",
      czm_testDiamondDependency2: "vec4 czm_testDiamondDependency2(vec4 color) { return czm_testAddAlpha(color); }",
      czm_testAddAlpha: "vec4 czm_testAddAlpha(vec4 color) { color.a = clamp(color.a + 0.1, 0.0, 1.0); return color; }",
      czm_testAddRed: "vec4 czm_testAddRed(vec4 color) { color.r = clamp(color.r + 0.1, 0.0, 1.0); return color; }",
      czm_testAddGreen: "vec4 czm_testAddGreen(vec4 color) { color.g = clamp(color.g + 0.1, 0.0, 1.0); return color; }",
      czm_testAddRedGreenAlpha: "vec4 czm_testAddRedGreenAlpha(vec4 color) { color = czm_testAddRed(color); color = czm_testAddGreen(color); color = czm_testAddAlpha(color); return color; }",
      czm_testFunction4: "void czm_testFunction4(vec4 color) { color = czm_testAddAlpha(color); color = czm_testAddRedGreenAlpha(color); czm_testFunction3(color); }",
      czm_testFunctionWithComment: "/**\n czm_circularDependency1()  \n*/\nvoid czm_testFunctionWithComment(vec4 color) { czm_testFunction1(color); }"
    };
    beforeAll(function() {
      context = createContext_default();
      for (const functionName in injectedTestFunctions) {
        if (injectedTestFunctions.hasOwnProperty(functionName)) {
          import__22.ShaderSource._czmBuiltinsAndUniforms[functionName] = injectedTestFunctions[functionName];
        }
      }
    });
    afterAll(function() {
      context.destroyForSpecs();
      for (const functionName in injectedTestFunctions) {
        if (injectedTestFunctions.hasOwnProperty(functionName)) {
          delete import__22.ShaderSource._czmBuiltinsAndUniforms[functionName];
        }
      }
    });
    afterEach(function() {
      sp = sp && sp.destroy();
    });
    it("has vertex and fragment shader source", function() {
      const vs = "void main() { gl_Position = vec4(1.0); }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      const expectedVSText = new import__22.ShaderSource({
        sources: [vs]
      }).createCombinedVertexShader(context);
      expect(sp._vertexShaderText).toEqual(expectedVSText);
      const expectedFSText = new import__22.ShaderSource({
        sources: [fs]
      }).createCombinedFragmentShader(context);
      expect(sp._fragmentShaderText).toEqual(expectedFSText);
    });
    it("has a position vertex attribute", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      if (webglStub) {
        return;
      }
      expect(sp.numberOfVertexAttributes).toEqual(1);
      expect(sp.vertexAttributes.position.name).toEqual("position");
    });
    it("sets attribute indices", function() {
      const vs = "in vec4 position;in vec3 normal;in float heat;void main() { gl_Position = position + vec4(normal, 0.0) + vec4(heat); }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const attributes = {
        position: 3,
        normal: 2,
        heat: 1
      };
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: attributes
      });
      if (webglStub) {
        return;
      }
      expect(sp.numberOfVertexAttributes).toEqual(3);
      expect(sp.vertexAttributes.position.name).toEqual("position");
      expect(sp.vertexAttributes.position.index).toEqual(attributes.position);
      expect(sp.vertexAttributes.normal.name).toEqual("normal");
      expect(sp.vertexAttributes.normal.index).toEqual(attributes.normal);
      expect(sp.vertexAttributes.heat.name).toEqual("heat");
      expect(sp.vertexAttributes.heat.index).toEqual(attributes.heat);
    });
    it("has an automatic uniform", function() {
      const vs = "uniform vec4 u_vec4; void main() { gl_Position = u_vec4; }";
      const fs = "void main() { out_FragColor = vec4((czm_viewport.x == 0.0) && (czm_viewport.y == 0.0) && (czm_viewport.z == 1.0) && (czm_viewport.w == 1.0)); }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      if (webglStub) {
        return;
      }
      expect(sp.allUniforms.u_vec4.name).toEqual("u_vec4");
      expect(sp.allUniforms.czm_viewport.name).toEqual("czm_viewport");
    });
    it("has uniforms of every datatype", function() {
      const d = context;
      const vs = "uniform float u_float;uniform vec2 u_vec2;uniform vec3 u_vec3;uniform vec4 u_vec4;uniform int u_int;uniform ivec2 u_ivec2;uniform ivec3 u_ivec3;uniform ivec4 u_ivec4;uniform bool u_bool;uniform bvec2 u_bvec2;uniform bvec3 u_bvec3;uniform bvec4 u_bvec4;uniform mat2 u_mat2;uniform mat3 u_mat3;uniform mat4 u_mat4;void main() { gl_Position = vec4(u_float) * vec4((u_mat2 * u_vec2), 0.0, 0.0) * vec4((u_mat3 * u_vec3), 0.0) * (u_mat4 * u_vec4) * vec4(u_int) * vec4(u_ivec2, 0.0, 0.0) * vec4(u_ivec3, 0.0) * vec4(u_ivec4) * vec4(u_bool) * vec4(u_bvec2, 0.0, 0.0) * vec4(u_bvec3, 0.0) * vec4(u_bvec4); }";
      const fs = "uniform sampler2D u_sampler2D;uniform samplerCube u_samplerCube;void main() { out_FragColor = texture(u_sampler2D, vec2(0.0)) + czm_textureCube(u_samplerCube, vec3(1.0)); }";
      sp = import__22.ShaderProgram.fromCache({
        context: d,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      if (webglStub) {
        return;
      }
      expect(sp.allUniforms.u_float.name).toEqual("u_float");
      expect(sp.allUniforms.u_vec2.name).toEqual("u_vec2");
      expect(sp.allUniforms.u_vec3.name).toEqual("u_vec3");
      expect(sp.allUniforms.u_vec4.name).toEqual("u_vec4");
      expect(sp.allUniforms.u_int.name).toEqual("u_int");
      expect(sp.allUniforms.u_ivec2.name).toEqual("u_ivec2");
      expect(sp.allUniforms.u_ivec3.name).toEqual("u_ivec3");
      expect(sp.allUniforms.u_ivec4.name).toEqual("u_ivec4");
      expect(sp.allUniforms.u_bool.name).toEqual("u_bool");
      expect(sp.allUniforms.u_bvec2.name).toEqual("u_bvec2");
      expect(sp.allUniforms.u_bvec3.name).toEqual("u_bvec3");
      expect(sp.allUniforms.u_bvec4.name).toEqual("u_bvec4");
      expect(sp.allUniforms.u_mat2.name).toEqual("u_mat2");
      expect(sp.allUniforms.u_mat3.name).toEqual("u_mat3");
      expect(sp.allUniforms.u_mat4.name).toEqual("u_mat4");
      expect(sp.allUniforms.u_sampler2D.name).toEqual("u_sampler2D");
      expect(sp.allUniforms.u_samplerCube.name).toEqual("u_samplerCube");
    });
    it("has a struct uniform", function() {
      const vs = "uniform struct { float f; vec4 v; } u_struct; void main() { gl_Position = u_struct.f * u_struct.v; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      if (webglStub) {
        return;
      }
      expect(sp.allUniforms["u_struct.f"].name).toEqual("u_struct.f");
      expect(sp.allUniforms["u_struct.v"].name).toEqual("u_struct.v");
    });
    it("has uniform arrays of every datatype", function() {
      const d = context;
      const vs = "uniform float u_float[2];uniform vec2 u_vec2[2];uniform vec3 u_vec3[2];uniform vec4 u_vec4[2];uniform int u_int[2];uniform ivec2 u_ivec2[2];uniform ivec3 u_ivec3[2];uniform ivec4 u_ivec4[2];uniform bool u_bool[2];uniform bvec2 u_bvec2[2];uniform bvec3 u_bvec3[2];uniform bvec4 u_bvec4[2];uniform mat2 u_mat2[2];uniform mat3 u_mat3[2];uniform mat4 u_mat4[2];void main() { gl_Position = vec4(u_float[0]) * vec4(u_float[1]) * vec4((u_mat2[0] * u_vec2[0]), 0.0, 0.0) * vec4((u_mat2[1] * u_vec2[1]), 0.0, 0.0) * vec4((u_mat3[0] * u_vec3[0]), 0.0) * vec4((u_mat3[1] * u_vec3[1]), 0.0) * (u_mat4[0] * u_vec4[0]) * (u_mat4[1] * u_vec4[1]) * vec4(u_int[0]) * vec4(u_int[1]) * vec4(u_ivec2[0], 0.0, 0.0) * vec4(u_ivec2[1], 0.0, 0.0) * vec4(u_ivec3[0], 0.0) * vec4(u_ivec3[1], 0.0) * vec4(u_ivec4[0]) * vec4(u_ivec4[1]) * vec4(u_bool[0]) * vec4(u_bool[1]) * vec4(u_bvec2[0], 0.0, 0.0) * vec4(u_bvec2[1], 0.0, 0.0) * vec4(u_bvec3[0], 0.0) * vec4(u_bvec3[1], 0.0) * vec4(u_bvec4[0]) * vec4(u_bvec4[1]); }";
      const fs = "uniform sampler2D u_sampler2D[2];uniform samplerCube u_samplerCube[2];void main() { out_FragColor = texture(u_sampler2D[0], vec2(0.0)) + texture(u_sampler2D[1], vec2(0.0)) + czm_textureCube(u_samplerCube[0], vec3(1.0)) + czm_textureCube(u_samplerCube[1], vec3(1.0)); }";
      sp = import__22.ShaderProgram.fromCache({
        context: d,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      if (webglStub) {
        return;
      }
      expect(sp.allUniforms.u_float.name).toEqual("u_float");
      expect(sp.allUniforms.u_vec2.name).toEqual("u_vec2");
      expect(sp.allUniforms.u_vec3.name).toEqual("u_vec3");
      expect(sp.allUniforms.u_vec4.name).toEqual("u_vec4");
      expect(sp.allUniforms.u_int.name).toEqual("u_int");
      expect(sp.allUniforms.u_ivec2.name).toEqual("u_ivec2");
      expect(sp.allUniforms.u_ivec3.name).toEqual("u_ivec3");
      expect(sp.allUniforms.u_ivec4.name).toEqual("u_ivec4");
      expect(sp.allUniforms.u_bool.name).toEqual("u_bool");
      expect(sp.allUniforms.u_bvec2.name).toEqual("u_bvec2");
      expect(sp.allUniforms.u_bvec3.name).toEqual("u_bvec3");
      expect(sp.allUniforms.u_bvec4.name).toEqual("u_bvec4");
      expect(sp.allUniforms.u_mat2.name).toEqual("u_mat2");
      expect(sp.allUniforms.u_mat3.name).toEqual("u_mat3");
      expect(sp.allUniforms.u_mat4.name).toEqual("u_mat4");
      expect(sp.allUniforms.u_sampler2D.name).toEqual("u_sampler2D");
      expect(sp.allUniforms.u_samplerCube.name).toEqual("u_samplerCube");
      expect(sp.allUniforms.u_float.value.length).toEqual(2);
      expect(sp.allUniforms.u_vec2.value.length).toEqual(2);
      expect(sp.allUniforms.u_vec3.value.length).toEqual(2);
      expect(sp.allUniforms.u_vec4.value.length).toEqual(2);
      expect(sp.allUniforms.u_int.value.length).toEqual(2);
      expect(sp.allUniforms.u_ivec2.value.length).toEqual(2);
      expect(sp.allUniforms.u_ivec3.value.length).toEqual(2);
      expect(sp.allUniforms.u_ivec4.value.length).toEqual(2);
      expect(sp.allUniforms.u_bool.value.length).toEqual(2);
      expect(sp.allUniforms.u_bvec2.value.length).toEqual(2);
      expect(sp.allUniforms.u_bvec3.value.length).toEqual(2);
      expect(sp.allUniforms.u_bvec4.value.length).toEqual(2);
      expect(sp.allUniforms.u_mat2.value.length).toEqual(2);
      expect(sp.allUniforms.u_mat3.value.length).toEqual(2);
      expect(sp.allUniforms.u_mat4.value.length).toEqual(2);
      expect(sp.allUniforms.u_sampler2D.value.length).toEqual(2);
      expect(sp.allUniforms.u_samplerCube.value.length).toEqual(2);
    });
    it("has predefined constants", function() {
      const fs = "void main() {   float f = ((czm_pi > 0.0) && \n    (czm_oneOverPi > 0.0) && \n    (czm_piOverTwo > 0.0) && \n    (czm_piOverThree > 0.0) && \n    (czm_piOverFour > 0.0) && \n    (czm_piOverSix > 0.0) && \n    (czm_threePiOver2 > 0.0) && \n    (czm_twoPi > 0.0) && \n    (czm_oneOverTwoPi > 0.0) && \n    (czm_radiansPerDegree > 0.0) && \n    (czm_degreesPerRadian > 0.0)) ? 1.0 : 0.0; \n  out_FragColor = vec4(f); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has built-in constant, structs, and functions", function() {
      const fs = "void main() { \n  czm_materialInput materialInput; \n  czm_material material = czm_getDefaultMaterial(materialInput); \n  material.diffuse = vec3(1.0, 1.0, 1.0); \n  material.alpha = 1.0; \n  material.diffuse = czm_hue(material.diffuse, czm_twoPi); \n  out_FragColor = vec4(material.diffuse, material.alpha); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("creates duplicate uniforms if precision of uniforms in vertex and fragment shader do not match", function() {
      const highpFloatSupported = import__22.ContextLimits.highpFloatSupported;
      import__22.ContextLimits._highpFloatSupported = false;
      const vs = "in vec4 position; uniform float u_value; out float v_value; void main() { gl_PointSize = 1.0; v_value = u_value * czm_viewport.z; gl_Position = position; }";
      const fs = "uniform float u_value; in float v_value; void main() { out_FragColor = vec4(u_value * v_value * czm_viewport.z); }";
      const uniformMap = {
        u_value: function() {
          return 1;
        }
      };
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      if (!webglStub) {
        expect(sp.allUniforms.u_value).toBeDefined();
        expect(sp.allUniforms.czm_mediump_u_value).toBeDefined();
      }
      expect({
        context,
        vertexShader: vs,
        fragmentShader: fs,
        uniformMap
      }).notContextToRender([0, 0, 0, 0]);
      import__22.ContextLimits._highpFloatSupported = highpFloatSupported;
    });
    it("1 level function dependency", function() {
      const fs = "void main() { \n  czm_testFunction1(vec4(1.0)); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("2 level function dependency", function() {
      const fs = "void main() { \n  czm_testFunction2(vec4(1.0)); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("3 level function dependency", function() {
      const fs = "void main() { \n  czm_testFunction3(vec4(1.0)); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("diamond dependency", function() {
      const fs = "layout (location = 0) out vec4 out_FragColor;\nvoid main() { \n  vec4 color = vec4(1.0, 1.0, 1.0, 0.8); \n  color = czm_testDiamondDependency1(color); \n  color = czm_testDiamondDependency2(color); \n  out_FragColor = color; \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("diamond plus 3 level function dependency", function() {
      const fs = "void main() { \n  vec4 color = vec4(1.0, 1.0, 1.0, 0.8); \n  color = czm_testDiamondDependency1(color); \n  color = czm_testDiamondDependency2(color); \n  czm_testFunction3(color); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("big mess of function dependencies", function() {
      const fs = "void main() { \n  vec4 color = vec4(0.9, 0.9, 1.0, 0.6); \n  color = czm_testDiamondDependency1(color); \n  color = czm_testDiamondDependency2(color); \n  czm_testFunction4(color); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("doc comment with reference to another function", function() {
      const fs = "void main() { \n  vec4 color = vec4(1.0, 1.0, 1.0, 1.0); \n  czm_testFunctionWithComment(color); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("compiles with #version at the top", function() {
      const vs = "#version 100 \nin vec4 position; void main() { gl_Position = position; }";
      const fs = "#version 100 \nlayout (location = 0) out vec4 out_FragColor;\nvoid main() { out_FragColor = vec4(1.0); }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
    });
    it("compiles with #version after whitespace and comments", function() {
      const vs = "// comment before version directive. \n#version 100 \nin vec4 position; void main() { gl_Position = position; }";
      const fs = "\n#version 100 \nlayout (location = 0) out vec4 out_FragColor;\nvoid main() { out_FragColor = vec4(1.0); }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
    });
    it("fails vertex shader compile", function() {
      if (webglStub) {
        return;
      }
      const vs = "does not compile.";
      const fs = "layout (location = 0) out vec4 out_FragColor;\nvoid main() { out_FragColor = vec4(1.0); }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      expect(function() {
        sp._bind();
      }).toThrowError(import__22.RuntimeError);
    });
    it("fails fragment shader compile", function() {
      if (webglStub) {
        return;
      }
      const vs = "void main() { gl_Position = vec4(0.0); }";
      const fs = "does not compile.";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      expect(function() {
        sp._bind();
      }).toThrowError(import__22.RuntimeError);
    });
    it("fails to link", function() {
      if (webglStub) {
        return;
      }
      const vs = "void nomain() { }";
      const fs = "void nomain() { }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      expect(function() {
        sp._bind();
      }).toThrowError(import__22.RuntimeError);
    });
    it("fails with built-in function circular dependency", function() {
      const vs = "void main() { gl_Position = vec4(0.0); }";
      const fs = "layout (location = 0) out vec4 out_FragColor;\nvoid main() { czm_circularDependency1(); out_FragColor = vec4(1.0); }";
      expect(function() {
        sp = import__22.ShaderProgram.fromCache({
          context,
          vertexShaderSource: vs,
          fragmentShaderSource: fs
        });
        sp._bind();
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/ShaderSourceSpec.js
var import__23 = __toESM(require_Cesium(), 1);
describe("Renderer/ShaderSource", function() {
  const mockContext = {
    webgl2: true
  };
  const fragColorDeclarationRegex = /layout\s*\(location\s*=\s*0\)\s*out\s+vec4\s+out_FragColor;/g;
  it("combines #defines", function() {
    const source = new import__23.ShaderSource({
      defines: ["A", "B", ""]
    });
    const shaderText = source.createCombinedVertexShader(mockContext);
    expect(shaderText).toContain("#define A");
    expect(shaderText).toContain("#define B");
    expect(shaderText.match(/#define/g).length).toEqual(2);
  });
  it("combines sources", function() {
    const source = new import__23.ShaderSource({
      sources: ["void func() {}", "void main() {}"]
    });
    const shaderText = source.createCombinedVertexShader(mockContext);
    expect(shaderText).toContain("#line 0\nvoid func() {}");
    expect(shaderText).toContain("#line 0\nvoid main() {}");
  });
  it("combines #defines and sources", function() {
    const source = new import__23.ShaderSource({
      defines: ["A", "B", ""],
      sources: ["void func() {}", "void main() {}"]
    });
    const shaderText = source.createCombinedVertexShader(mockContext);
    expect(shaderText).toContain("#define A");
    expect(shaderText).toContain("#define B");
    expect(shaderText.match(/#define/g).length).toEqual(2);
    expect(shaderText).toContain("#line 0\nvoid func() {}");
    expect(shaderText).toContain("#line 0\nvoid main() {}");
  });
  it("creates a pick shader with a uniform", function() {
    const source = new import__23.ShaderSource({
      sources: ["void main() { out_FragColor = vec4(1.0); }"],
      pickColorQualifier: "uniform"
    });
    const shaderText = source.createCombinedVertexShader(mockContext);
    expect(shaderText).toContain("uniform vec4 czm_pickColor;");
    expect(shaderText).toContain("out_FragColor = czm_pickColor;");
  });
  it("creates a pick shader with a varying", function() {
    const source = new import__23.ShaderSource({
      sources: ["void main() { out_FragColor = vec4(1.0); }"],
      pickColorQualifier: "in"
    });
    const shaderText = source.createCombinedVertexShader(mockContext);
    expect(shaderText).toContain("in vec4 czm_pickColor;");
    expect(shaderText).toContain("out_FragColor = czm_pickColor;");
  });
  it("throws with invalid qualifier", function() {
    expect(function() {
      return new import__23.ShaderSource({
        pickColorQualifier: "const"
      });
    }).toThrowDeveloperError();
  });
  it("combines #version to shader", function() {
    const source = new import__23.ShaderSource({
      sources: ["#version 300 es\nvoid main() {out_FragColor = vec4(1.0); }"]
    });
    const shaderText = source.createCombinedVertexShader(mockContext);
    expect(shaderText).toStartWith("#version 300 es\n");
  });
  it("clones", function() {
    const source = new import__23.ShaderSource({
      defines: ["A"],
      sources: ["void main() { out_FragColor = vec4(1.0); }"],
      pickColorQualifier: "in",
      includeBuiltIns: false
    });
    const clone22 = source.clone();
    expect(clone22.defines).toBeDefined();
    expect(clone22.defines.length).toEqual(1);
    expect(clone22.defines[0]).toEqual(source.defines[0]);
    expect(clone22.sources).toBeDefined();
    expect(clone22.sources.length).toEqual(1);
    expect(clone22.sources[0]).toEqual(source.sources[0]);
    expect(clone22.pickColorQualifier).toEqual(source.pickColorQualifier);
    expect(clone22.includeBuiltIns).toEqual(source.includeBuiltIns);
  });
  it("creates cache key for empty shader", function() {
    const source = new import__23.ShaderSource();
    expect(source.getCacheKey()).toBe(":undefined:true:");
  });
  it("creates cache key", function() {
    const source = new import__23.ShaderSource({
      defines: ["A", "B", "C"],
      sources: ["void main() { out_FragColor = vec4(1.0); }"],
      pickColorQualifier: "in",
      includeBuiltIns: false
    });
    expect(source.getCacheKey()).toBe(
      "A,B,C:in:false:void main() { out_FragColor = vec4(1.0); }"
    );
  });
  it("uses sorted list of defines in cache key", function() {
    const defines1 = ["A", "B", "C"];
    const defines2 = ["B", "C", "A"];
    const source1 = new import__23.ShaderSource({ defines: defines1 });
    const source2 = new import__23.ShaderSource({ defines: defines2 });
    const key1 = source1.getCacheKey();
    expect(key1).toBe(source2.getCacheKey());
    expect(key1).toBe("A,B,C:undefined:true:");
  });
  it("cache key includes all sources", function() {
    const source = new import__23.ShaderSource({
      sources: [
        "vec4 getColor() { return vec4(1.0, 0.0, 0.0, 1.0); }",
        "void main() { out_FragColor = getColor(); }"
      ]
    });
    expect(source.getCacheKey()).toBe(
      ":undefined:true:vec4 getColor() { return vec4(1.0, 0.0, 0.0, 1.0); }\nvoid main() { out_FragColor = getColor(); }"
    );
  });
  it("adds layout declaration for out_FragColor if it does not already exist", function() {
    const source = new import__23.ShaderSource({
      defines: ["A"],
      sources: ["void main() { out_FragColor = vec4(1.0); }"],
      pickColorQualifier: "in",
      includeBuiltIns: false
    });
    const shaderText = source.createCombinedFragmentShader(mockContext);
    const fragColorDeclarations = shaderText.match(fragColorDeclarationRegex) || [];
    expect(fragColorDeclarations.length).toEqual(1);
  });
  it("does not layout declaration for out_FragColor if it already exists", function() {
    const source = new import__23.ShaderSource({
      defines: ["A"],
      sources: [
        "layout (location = 0) out vec4 out_FragColor; void main() { out_FragColor = vec4(1.0); }"
      ],
      pickColorQualifier: "in",
      includeBuiltIns: false
    });
    const shaderText = source.createCombinedFragmentShader(mockContext);
    const fragColorDeclarations = shaderText.match(fragColorDeclarationRegex) || [];
    expect(fragColorDeclarations.length).toEqual(1);
  });
});

// packages/engine/Specs/Renderer/ShaderStructSpec.js
var import__24 = __toESM(require_Cesium(), 1);
describe("Renderer/ShaderStruct", function() {
  it("constructs", function() {
    const struct = new import__24.ShaderStruct("TestStruct");
    expect(struct.name).toEqual("TestStruct");
    expect(struct.fields).toEqual([]);
  });
  it("addField adds fields", function() {
    const struct = new import__24.ShaderStruct("TestStruct");
    struct.addField("vec3", "positionMC");
    struct.addField("float", "weights[4]");
    struct.addField("OtherStruct", "complex");
    expect(struct.fields).toEqual([
      "    vec3 positionMC;",
      "    float weights[4];",
      "    OtherStruct complex;"
    ]);
  });
  it("generateGlslLines generates a struct definition", function() {
    const struct = new import__24.ShaderStruct("TestStruct");
    struct.addField("vec3", "positionMC");
    struct.addField("float", "weights[4]");
    struct.addField("OtherStruct", "complex");
    expect(struct.generateGlslLines()).toEqual([
      "struct TestStruct",
      "{",
      "    vec3 positionMC;",
      "    float weights[4];",
      "    OtherStruct complex;",
      "};"
    ]);
  });
  it("generateGlslLines pads an empty struct definition", function() {
    const struct = new import__24.ShaderStruct("Nothing");
    expect(struct.generateGlslLines()).toEqual([
      "struct Nothing",
      "{",
      "    float _empty;",
      "};"
    ]);
  });
});

// packages/engine/Specs/Renderer/TextureCacheSpec.js
var import__25 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/TextureCache",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("adds and removes", function() {
      const cache = new import__25.TextureCache();
      const keyword = "texture";
      const texture = new import__25.Texture({
        context,
        width: 1,
        height: 1
      });
      cache.addTexture(keyword, texture);
      expect(cache._textures[keyword].count).toEqual(1);
      expect(cache.numberOfTextures).toEqual(1);
      texture.destroy();
      expect(texture.isDestroyed()).toEqual(false);
      expect(cache.numberOfTextures).toEqual(1);
      cache.destroyReleasedTextures();
      expect(texture.isDestroyed()).toEqual(true);
      expect(cache.numberOfTextures).toEqual(0);
      cache.destroy();
    });
    it("has a cache hit", function() {
      const cache = new import__25.TextureCache(context);
      const keyword = "texture";
      const texture = new import__25.Texture({
        context,
        width: 1,
        height: 1
      });
      cache.addTexture(keyword, texture);
      const texture2 = cache.getTexture(keyword);
      expect(texture2).toBeDefined();
      expect(texture).toBe(texture2);
      expect(cache._textures[keyword].count).toEqual(2);
      expect(cache.numberOfTextures).toEqual(1);
      texture.destroy();
      texture2.destroy();
      cache.destroyReleasedTextures();
      expect(texture.isDestroyed()).toEqual(true);
      expect(cache.numberOfTextures).toEqual(0);
      cache.destroy();
    });
    it("avoids thrashing", function() {
      const cache = new import__25.TextureCache();
      const keyword = "texture";
      const texture = new import__25.Texture({
        context,
        width: 1,
        height: 1
      });
      cache.addTexture(keyword, texture);
      texture.destroy();
      const texture2 = cache.getTexture(keyword);
      cache.destroyReleasedTextures();
      expect(texture.isDestroyed()).toEqual(false);
      expect(texture2.isDestroyed()).toEqual(false);
      texture2.destroy();
      cache.destroyReleasedTextures();
      expect(texture.isDestroyed()).toEqual(true);
      expect(texture2.isDestroyed()).toEqual(true);
      cache.destroy();
    });
    it("is destroyed", function() {
      const cache = new import__25.TextureCache();
      const keyword = "texture";
      const texture = new import__25.Texture({
        context,
        width: 1,
        height: 1
      });
      cache.addTexture(keyword, texture);
      cache.destroy();
      expect(texture.isDestroyed()).toEqual(true);
      expect(cache.isDestroyed()).toEqual(true);
    });
    it("is not destroyed", function() {
      const cache = new import__25.TextureCache();
      expect(cache.isDestroyed()).toEqual(false);
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/TextureSpec.js
var import__26 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Texture",
  function() {
    let context;
    let greenImage;
    let blueImage;
    let blueAlphaImage;
    let blueOverRedImage;
    let blueOverRedFlippedImage;
    let red16x16Image;
    let greenKTX2Image;
    let greenBasisKTX2Image;
    const fs = "uniform sampler2D u_texture;void main() { out_FragColor = texture(u_texture, vec2(0.0)); }";
    const fsLuminanceAlpha = "uniform sampler2D u_texture;void main() { out_FragColor = vec4(texture(u_texture, vec2(0.0)).ra, 0.0, 1.0); }";
    let texture;
    const uniformMap = {
      u_texture: function() {
        return texture;
      }
    };
    beforeAll(function() {
      context = createContext_default();
      const promises = [];
      promises.push(
        import__26.Resource.fetchImage("./Data/Images/Green.png").then(function(image) {
          greenImage = image;
        })
      );
      promises.push(
        import__26.Resource.fetchImage("./Data/Images/Blue.png").then(function(image) {
          blueImage = image;
        })
      );
      promises.push(
        import__26.Resource.fetchImage("./Data/Images/BlueAlpha.png").then(function(image) {
          blueAlphaImage = image;
        })
      );
      promises.push(
        import__26.Resource.fetchImage("./Data/Images/BlueOverRed.png").then(function(image) {
          blueOverRedImage = image;
        })
      );
      promises.push(
        import__26.Resource.fetchImage({
          url: "./Data/Images/BlueOverRed.png",
          preferImageBitmap: true
        }).then(function(image) {
          blueOverRedFlippedImage = image;
        })
      );
      promises.push(
        import__26.Resource.fetchImage("./Data/Images/Red16x16.png").then(function(image) {
          red16x16Image = image;
        })
      );
      const resource = import__26.Resource.createIfNeeded("./Data/Images/Green4x4.ktx2");
      const loadPromise = resource.fetchArrayBuffer();
      promises.push(
        loadPromise.then(function(buffer) {
          const promise = import__26.KTX2Transcoder.transcode(buffer, {});
          return promise.then(function(result) {
            greenKTX2Image = result;
          });
        })
      );
      if (context.supportsBasis) {
        promises.push(
          (0, import__26.loadKTX2)("./Data/Images/Green4x4_ETC1S.ktx2").then(function(image) {
            greenBasisKTX2Image = image;
          })
        );
      }
      return Promise.all(promises);
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    afterEach(function() {
      texture = texture && texture.destroy();
    });
    it("has expected default values for pixel format and datatype", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage
      });
      expect(texture.id).toBeDefined();
      expect(texture.pixelFormat).toEqual(import__26.PixelFormat.RGBA);
      expect(texture.pixelDatatype).toEqual(import__26.PixelDatatype.UNSIGNED_BYTE);
    });
    it("can create a texture from the framebuffer", function() {
      const command = new import__26.ClearCommand({
        color: import__26.Color.RED
      });
      command.execute(context);
      texture = import__26.Texture.fromFramebuffer({
        context
      });
      const expectedWidth = context.canvas.clientWidth;
      const expectedHeight = context.canvas.clientHeight;
      expect(texture.width).toEqual(expectedWidth);
      expect(texture.height).toEqual(expectedHeight);
      expect(texture.sizeInBytes).toEqual(
        expectedWidth * expectedHeight * import__26.PixelFormat.componentsLength(texture.pixelFormat)
      );
      command.color = import__26.Color.WHITE;
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([255, 0, 0, 255]);
    });
    it("can copy from the framebuffer", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage,
        pixelFormat: import__26.PixelFormat.RGB
      });
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([0, 0, 255, 255]);
      const command = new import__26.ClearCommand({
        color: import__26.Color.RED
      });
      command.execute(context);
      expect(context).toReadPixels(import__26.Color.RED.toBytes());
      texture.copyFromFramebuffer();
      const expectedWidth = context.canvas.clientWidth;
      const expectedHeight = context.canvas.clientHeight;
      expect(texture.width).toEqual(expectedWidth);
      expect(texture.height).toEqual(expectedHeight);
      expect(texture.sizeInBytes).toEqual(
        expectedWidth * expectedHeight * import__26.PixelFormat.componentsLength(texture.pixelFormat)
      );
      command.color = import__26.Color.WHITE;
      command.execute(context);
      expect(context).toReadPixels(import__26.Color.WHITE.toBytes());
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([255, 0, 0, 255]);
    });
    it("draws the expected texture color", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage,
        pixelFormat: import__26.PixelFormat.RGBA
      });
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([0, 0, 255, 255]);
    });
    it("cannot flip texture when using ImageBitmap", function() {
      const topColor = new import__26.Color(0, 0, 1, 1);
      let bottomColor = new import__26.Color(1, 0, 0, 1);
      return import__26.Resource.supportsImageBitmapOptions().then(function(supportsImageBitmapOptions) {
        if (supportsImageBitmapOptions) {
          bottomColor = topColor;
        }
        texture = new import__26.Texture({
          context,
          source: blueOverRedFlippedImage,
          pixelFormat: import__26.PixelFormat.RGBA,
          flipY: false
        });
        expect({
          context,
          fragmentShader: fs,
          uniformMap
        }).contextToRender(topColor.toBytes());
        texture = new import__26.Texture({
          context,
          source: blueOverRedFlippedImage,
          pixelFormat: import__26.PixelFormat.RGBA,
          flipY: true
        });
        expect({
          context,
          fragmentShader: fs,
          uniformMap
        }).contextToRender(bottomColor.toBytes());
      });
    });
    it("draws the expected floating-point texture color", function() {
      if (!context.floatingPointTexture) {
        return;
      }
      const color = new import__26.Color(0.2, 0.4, 0.6, 1);
      const floats = new Float32Array([
        color.red,
        color.green,
        color.blue,
        color.alpha
      ]);
      texture = new import__26.Texture({
        context,
        pixelFormat: import__26.PixelFormat.RGBA,
        pixelDatatype: import__26.PixelDatatype.FLOAT,
        source: {
          width: 1,
          height: 1,
          arrayBufferView: floats
        }
      });
      expect(texture.sizeInBytes).toEqual(16);
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender(color.toBytes());
    });
    it("draws the expected floating-point texture color with linear filtering", function() {
      if (!context.floatingPointTexture) {
        return;
      }
      const color0 = new import__26.Color(0.2, 0.4, 0.6, 1);
      const color1 = new import__26.Color(0.1, 0.3, 0.5, 1);
      const floats = new Float32Array([
        color0.red,
        color0.green,
        color0.blue,
        color0.alpha,
        color1.red,
        color1.green,
        color1.blue,
        color1.alpha
      ]);
      texture = new import__26.Texture({
        context,
        pixelFormat: import__26.PixelFormat.RGBA,
        pixelDatatype: import__26.PixelDatatype.FLOAT,
        source: {
          width: 2,
          height: 1,
          arrayBufferView: floats
        },
        sampler: new import__26.Sampler({
          wrapS: import__26.TextureWrap.CLAMP_TO_EDGE,
          wrapT: import__26.TextureWrap.CLAMP_TO_EDGE,
          minificationFilter: import__26.TextureMinificationFilter.LINEAR,
          magnificationFilter: import__26.TextureMagnificationFilter.LINEAR
        })
      });
      expect(texture.sizeInBytes).toEqual(32);
      const fs2 = "uniform sampler2D u_texture;void main() { out_FragColor = texture(u_texture, vec2(0.5, 0.0)); }";
      if (!context.textureFloatLinear) {
        expect({
          context,
          fragmentShader: fs2,
          uniformMap,
          epsilon: 1
        }).contextToRender(color1.toBytes());
      } else {
        import__26.Color.multiplyByScalar(color0, 1 - 0.5, color0);
        import__26.Color.multiplyByScalar(color1, 0.5, color1);
        import__26.Color.add(color0, color1, color1);
        expect({
          context,
          fragmentShader: fs2,
          uniformMap
        }).contextToRender(color1.toBytes());
      }
    });
    it("draws the expected half floating-point texture color", function() {
      if (!context.halfFloatingPointTexture) {
        return;
      }
      const color = new import__26.Color(0.2, 0.4, 0.6, 1);
      const floats = new Uint16Array([12902, 13926, 14541, 15360]);
      texture = new import__26.Texture({
        context,
        pixelFormat: import__26.PixelFormat.RGBA,
        pixelDatatype: import__26.PixelDatatype.HALF_FLOAT,
        source: {
          width: 1,
          height: 1,
          arrayBufferView: floats
        },
        flipY: false
      });
      expect(texture.sizeInBytes).toEqual(8);
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender(color.toBytes());
    });
    it("draws the expected half floating-point texture color with linear filtering", function() {
      if (!context.halfFloatingPointTexture) {
        return;
      }
      const color0 = new import__26.Color(0.2, 0.4, 0.6, 1);
      const color1 = new import__26.Color(0.1, 0.3, 0.5, 1);
      const floats = new Uint16Array([
        12902,
        13926,
        14541,
        15360,
        11878,
        13517,
        14336,
        15360
      ]);
      texture = new import__26.Texture({
        context,
        pixelFormat: import__26.PixelFormat.RGBA,
        pixelDatatype: import__26.PixelDatatype.HALF_FLOAT,
        source: {
          width: 2,
          height: 1,
          arrayBufferView: floats
        },
        flipY: false
      });
      expect(texture.sizeInBytes).toEqual(16);
      const fs2 = "uniform sampler2D u_texture;void main() { out_FragColor = texture(u_texture, vec2(0.5, 0.0)); }";
      if (!context.textureHalfFloatLinear) {
        expect({
          context,
          fragmentShader: fs2,
          uniformMap,
          epsilon: 1
        }).contextToRender(color1.toBytes());
      } else {
        import__26.Color.multiplyByScalar(color0, 1 - 0.5, color0);
        import__26.Color.multiplyByScalar(color1, 0.5, color1);
        import__26.Color.add(color0, color1, color1);
        expect({
          context,
          fragmentShader: fs2,
          uniformMap
        }).contextToRender(color1.toBytes());
      }
    });
    it("draws the expected Basis compressed texture color", function() {
      if (!context.supportsBasis) {
        return;
      }
      texture = new import__26.Texture({
        context,
        pixelFormat: greenBasisKTX2Image.internalFormat,
        source: {
          width: greenBasisKTX2Image.width,
          height: greenBasisKTX2Image.height,
          arrayBufferView: greenBasisKTX2Image.bufferView
        }
      });
      expect(texture.sizeInBytes).toBe(8);
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRenderAndCall(function(color) {
        return expect(color).toEqualEpsilon([2, 255, 2, 255], 2);
      });
    });
    it("draws the expected KTX2 uncompressed texture color", function() {
      texture = new import__26.Texture({
        context,
        pixelFormat: greenKTX2Image.internalFormat,
        source: {
          width: greenKTX2Image.width,
          height: greenKTX2Image.height,
          arrayBufferView: greenKTX2Image.bufferView
        }
      });
      expect(texture.sizeInBytes).toBe(48);
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRenderAndCall(function(color) {
        return expect(color).toEqualEpsilon([0, 255, 24, 255], 2);
      });
    });
    it("renders with premultiplied alpha", function() {
      const cxt = createContext_default({
        webgl: {
          alpha: true
        }
      });
      const texture2 = new import__26.Texture({
        context: cxt,
        source: blueAlphaImage,
        pixelFormat: import__26.PixelFormat.RGBA,
        preMultiplyAlpha: true
      });
      const uniformMap2 = {
        u_texture: function() {
          return texture2;
        }
      };
      expect(texture2.preMultiplyAlpha).toEqual(true);
      expect({
        context: cxt,
        fragmentShader: fs,
        uniformMap: uniformMap2,
        epsilon: 1
      }).contextToRender([0, 0, 127, 127]);
      texture2.destroy();
      cxt.destroyForSpecs();
    });
    it("draws textured blue and red points", function() {
      texture = new import__26.Texture({
        context,
        source: blueOverRedImage,
        pixelFormat: import__26.PixelFormat.RGBA
      });
      let fragmentShaderSource = "";
      fragmentShaderSource += "uniform sampler2D u_texture;";
      fragmentShaderSource += "uniform mediump vec2 u_txCoords;";
      fragmentShaderSource += "void main() { out_FragColor = texture(u_texture, u_txCoords); }";
      let txCoords;
      const um = {
        u_texture: function() {
          return texture;
        },
        u_txCoords: function() {
          return txCoords;
        }
      };
      txCoords = new import__26.Cartesian2(0.5, 0.75);
      expect({
        context,
        fragmentShader: fragmentShaderSource,
        uniformMap: um
      }).contextToRender([0, 0, 255, 255]);
      txCoords = new import__26.Cartesian2(0.5, 0.25);
      expect({
        context,
        fragmentShader: fragmentShaderSource,
        uniformMap: um
      }).contextToRender([255, 0, 0, 255]);
    });
    it("draws the expected luminance texture color", function() {
      const color = new import__26.Color(0.6, 0.6, 0.6, 1);
      const arrayBufferView = new Uint8Array([153]);
      texture = new import__26.Texture({
        context,
        pixelFormat: import__26.PixelFormat.LUMINANCE,
        pixelDatatype: import__26.PixelDatatype.UNSIGNED_BYTE,
        source: {
          width: 1,
          height: 1,
          arrayBufferView
        },
        flipY: false
      });
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender(color.toBytes());
    });
    it("draws the expected luminance alpha texture color", function() {
      const color = new import__26.Color(0.6, 0.8, 0, 1);
      const arrayBufferView = new Uint8Array([153, 204]);
      texture = new import__26.Texture({
        context,
        pixelFormat: import__26.PixelFormat.LUMINANCE_ALPHA,
        pixelDatatype: import__26.PixelDatatype.UNSIGNED_BYTE,
        source: {
          width: 1,
          height: 1,
          arrayBufferView
        },
        flipY: false
      });
      expect({
        context,
        fragmentShader: fsLuminanceAlpha,
        uniformMap
      }).contextToRender(color.toBytes());
    });
    it("can be created from a typed array", function() {
      const bytes = new Uint8Array([0, 255, 0, 255]);
      texture = new import__26.Texture({
        context,
        pixelFormat: import__26.PixelFormat.RGBA,
        pixelDatatype: import__26.PixelDatatype.UNSIGNED_BYTE,
        source: {
          width: 1,
          height: 1,
          arrayBufferView: bytes
        }
      });
      expect(texture.width).toEqual(1);
      expect(texture.height).toEqual(1);
      expect(texture.sizeInBytes).toEqual(4);
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([0, 255, 0, 255]);
    });
    it("can copy from a typed array", function() {
      texture = new import__26.Texture({
        context,
        pixelFormat: import__26.PixelFormat.RGBA,
        pixelDatatype: import__26.PixelDatatype.UNSIGNED_BYTE,
        width: 1,
        height: 1
      });
      const bytes = new Uint8Array(import__26.Color.NAVY.toBytes());
      texture.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: bytes
        }
      });
      expect(texture.width).toEqual(1);
      expect(texture.height).toEqual(1);
      expect(texture.sizeInBytes).toEqual(4);
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender(import__26.Color.NAVY.toBytes());
    });
    it("can copy from a DOM element", function() {
      texture = new import__26.Texture({
        context,
        pixelFormat: import__26.PixelFormat.RGB,
        pixelDatatype: import__26.PixelDatatype.UNSIGNED_BYTE,
        width: blueImage.width,
        height: blueImage.height
      });
      texture.copyFrom({
        source: blueImage
      });
      expect({
        context,
        fragmentShader: fs,
        uniformMap,
        epsilon: 1
      }).contextToRender([0, 0, 255, 255]);
    });
    it("can replace a subset of a texture", function() {
      texture = new import__26.Texture({
        context,
        source: blueOverRedImage,
        pixelFormat: import__26.PixelFormat.RGBA
      });
      let fragmentShaderSource = "";
      fragmentShaderSource += "uniform sampler2D u_texture;";
      fragmentShaderSource += "uniform mediump vec2 u_txCoords;";
      fragmentShaderSource += "void main() { out_FragColor = texture(u_texture, u_txCoords); }";
      let txCoords;
      const um = {
        u_texture: function() {
          return texture;
        },
        u_txCoords: function() {
          return txCoords;
        }
      };
      txCoords = new import__26.Cartesian2(0.5, 0.75);
      expect({
        context,
        fragmentShader: fragmentShaderSource,
        uniformMap: um
      }).contextToRender([0, 0, 255, 255]);
      txCoords = new import__26.Cartesian2(0.5, 0.25);
      expect({
        context,
        fragmentShader: fragmentShaderSource,
        uniformMap: um
      }).contextToRender([255, 0, 0, 255]);
      texture.copyFrom({
        source: greenImage,
        xOffset: 0,
        yOffset: 1
      });
      txCoords = new import__26.Cartesian2(0.5, 0.75);
      expect({
        context,
        fragmentShader: fragmentShaderSource,
        uniformMap: um
      }).contextToRender(import__26.Color.LIME.toBytes());
      txCoords = new import__26.Cartesian2(0.5, 0.25);
      expect({
        context,
        fragmentShader: fragmentShaderSource,
        uniformMap: um
      }).contextToRender([255, 0, 0, 255]);
    });
    it("can generate mipmaps", function() {
      texture = new import__26.Texture({
        context,
        source: red16x16Image,
        pixelFormat: import__26.PixelFormat.RGBA,
        sampler: new import__26.Sampler({
          minificationFilter: import__26.TextureMinificationFilter.NEAREST_MIPMAP_LINEAR
        })
      });
      texture.generateMipmap();
      expect(texture.sizeInBytes).toEqualEpsilon(
        (16 * 16 + 8 * 8 + 4 * 4 + 2 * 2 + 1) * 4,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([255, 0, 0, 255]);
    });
    it("can set a sampler property", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage,
        pixelFormat: import__26.PixelFormat.RGBA
      });
      const sampler = new import__26.Sampler({
        wrapS: import__26.TextureWrap.REPEAT,
        wrapT: import__26.TextureWrap.MIRRORED_REPEAT,
        minificationFilter: import__26.TextureMinificationFilter.NEAREST,
        magnificationFilter: import__26.TextureMagnificationFilter.NEAREST,
        maximumAnisotropy: 2
      });
      texture.sampler = sampler;
      const s = texture.sampler;
      expect(s.wrapS).toEqual(sampler.wrapS);
      expect(s.wrapT).toEqual(sampler.wrapT);
      expect(s.minificationFilter).toEqual(sampler.minificationFilter);
      expect(s.magnificationFilter).toEqual(sampler.magnificationFilter);
      expect(s.maximumAnisotropy).toEqual(2);
    });
    it("can set sampler at construction", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage,
        pixelFormat: import__26.PixelFormat.RGBA,
        sampler: new import__26.Sampler({
          wrapS: import__26.TextureWrap.REPEAT,
          wrapT: import__26.TextureWrap.MIRRORED_REPEAT,
          minificationFilter: import__26.TextureMinificationFilter.NEAREST,
          magnificationFilter: import__26.TextureMagnificationFilter.NEAREST,
          maximumAnisotropy: 2
        })
      });
      const s = texture.sampler;
      expect(s.wrapS).toEqual(import__26.TextureWrap.REPEAT);
      expect(s.wrapT).toEqual(import__26.TextureWrap.MIRRORED_REPEAT);
      expect(s.minificationFilter).toEqual(import__26.TextureMinificationFilter.NEAREST);
      expect(s.magnificationFilter).toEqual(import__26.TextureMagnificationFilter.NEAREST);
      expect(s.maximumAnisotropy).toEqual(2);
    });
    it("can get width and height", function() {
      texture = new import__26.Texture({
        context,
        source: blueOverRedImage,
        pixelFormat: import__26.PixelFormat.RGBA
      });
      expect(texture.width).toEqual(1);
      expect(texture.height).toEqual(2);
    });
    it("can get whether Y is flipped", function() {
      texture = new import__26.Texture({
        context,
        source: blueOverRedImage,
        pixelFormat: import__26.PixelFormat.RGBA,
        flipY: true
      });
      expect(texture.flipY).toEqual(true);
    });
    it("can get the dimensions of a texture", function() {
      texture = new import__26.Texture({
        context,
        width: 64,
        height: 16
      });
      expect(texture.dimensions).toEqual(new import__26.Cartesian2(64, 16));
    });
    function expectTextureByteSize(width, height, pixelFormat, pixelDatatype, expectedSize) {
      texture = new import__26.Texture({
        context,
        width,
        height,
        pixelFormat,
        pixelDatatype
      });
      expect(texture.sizeInBytes).toBe(expectedSize);
      texture = texture && texture.destroy();
    }
    it("can get the size in bytes of a texture", function() {
      if (context.depthTexture) {
        expectTextureByteSize(
          16,
          16,
          import__26.PixelFormat.DEPTH_COMPONENT,
          import__26.PixelDatatype.UNSIGNED_SHORT,
          256 * 2
        );
        expectTextureByteSize(
          16,
          16,
          import__26.PixelFormat.DEPTH_COMPONENT,
          import__26.PixelDatatype.UNSIGNED_INT,
          256 * 4
        );
        expectTextureByteSize(
          16,
          16,
          import__26.PixelFormat.DEPTH_STENCIL,
          import__26.PixelDatatype.UNSIGNED_INT_24_8,
          256 * 4
        );
      }
      expectTextureByteSize(
        16,
        16,
        import__26.PixelFormat.ALPHA,
        import__26.PixelDatatype.UNSIGNED_BYTE,
        256
      );
      expectTextureByteSize(
        16,
        16,
        import__26.PixelFormat.RGB,
        import__26.PixelDatatype.UNSIGNED_BYTE,
        256 * 3
      );
      expectTextureByteSize(
        16,
        16,
        import__26.PixelFormat.RGBA,
        import__26.PixelDatatype.UNSIGNED_BYTE,
        256 * 4
      );
      expectTextureByteSize(
        16,
        16,
        import__26.PixelFormat.LUMINANCE,
        import__26.PixelDatatype.UNSIGNED_BYTE,
        256
      );
      expectTextureByteSize(
        16,
        16,
        import__26.PixelFormat.LUMINANCE_ALPHA,
        import__26.PixelDatatype.UNSIGNED_BYTE,
        256 * 2
      );
    });
    it("can be destroyed", function() {
      const t = new import__26.Texture({
        context,
        source: blueImage,
        pixelFormat: import__26.PixelFormat.RGBA
      });
      expect(t.isDestroyed()).toEqual(false);
      t.destroy();
      expect(t.isDestroyed()).toEqual(true);
    });
    it("throws when creating a texture without a options", function() {
      expect(function() {
        texture = new import__26.Texture();
      }).toThrowDeveloperError();
    });
    it("throws when creating a texture without a source", function() {
      expect(function() {
        texture = new import__26.Texture({
          context
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a texture with width and no height", function() {
      expect(function() {
        texture = new import__26.Texture({
          context,
          width: 16
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a texture with height and no width", function() {
      expect(function() {
        texture = new import__26.Texture({
          context,
          height: 16
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a texture with zero width", function() {
      expect(function() {
        texture = new import__26.Texture({
          context,
          width: 0,
          height: 16
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a texture with width larger than the maximum texture size", function() {
      expect(function() {
        texture = new import__26.Texture({
          context,
          width: import__26.ContextLimits.maximumTextureSize + 1,
          height: 16
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a texture with zero height", function() {
      expect(function() {
        texture = new import__26.Texture({
          context,
          width: 16,
          height: 0
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a texture with height larger than the maximum texture size", function() {
      expect(function() {
        texture = new import__26.Texture({
          context,
          width: 16,
          height: import__26.ContextLimits.maximumTextureSize + 1
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a texture with an invalid pixel format", function() {
      expect(function() {
        texture = new import__26.Texture({
          context,
          source: blueImage,
          pixelFormat: "invalid PixelFormat"
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a texture with an invalid pixel datatype", function() {
      expect(function() {
        texture = new import__26.Texture({
          context,
          source: blueImage,
          pixelFormat: import__26.PixelFormat.RGBA,
          pixelDatatype: "invalid pixelDatatype"
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating if pixelFormat is DEPTH_COMPONENT and pixelDatatype is not UNSIGNED_SHORT or UNSIGNED_INT", function() {
      expect(function() {
        texture = new import__26.Texture({
          context,
          pixelFormat: import__26.PixelFormat.DEPTH_COMPONENT,
          pixelDatatype: import__26.PixelDatatype.UNSIGNED_BYTE
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating if pixelFormat is DEPTH_STENCIL and pixelDatatype is not UNSIGNED_INT_24_8", function() {
      expect(function() {
        texture = new import__26.Texture({
          context,
          pixelFormat: import__26.PixelFormat.DEPTH_STENCIL,
          pixelDatatype: import__26.PixelDatatype.UNSIGNED_BYTE
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating if pixelFormat is DEPTH_COMPONENT or DEPTH_STENCIL, and source is provided", function() {
      expect(function() {
        texture = new import__26.Texture({
          context,
          source: blueImage,
          pixelFormat: import__26.PixelFormat.DEPTH_COMPONENT,
          pixelDatatype: import__26.PixelDatatype.UNSIGNED_SHORT
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating if pixelFormat is DEPTH_COMPONENT or DEPTH_STENCIL, and WEBGL_depth_texture is not supported", function() {
      if (!context.depthTexture) {
        expect(function() {
          texture = new import__26.Texture({
            context,
            width: 1,
            height: 1,
            pixelFormat: import__26.PixelFormat.DEPTH_COMPONENT,
            pixelDatatype: import__26.PixelDatatype.UNSIGNED_SHORT
          });
        }).toThrowDeveloperError();
      }
    });
    it("throws when creating if pixelDatatype is FLOAT, and OES_texture_float is not supported", function() {
      if (!context.floatingPointTexture) {
        expect(function() {
          texture = new import__26.Texture({
            context,
            width: 1,
            height: 1,
            pixelFormat: import__26.PixelFormat.RGBA,
            pixelDatatype: import__26.PixelDatatype.FLOAT
          });
        }).toThrowDeveloperError();
      }
    });
    it("throws when creating if pixelDatatype = HALF_FLOAT, and OES_texture_half_float is not supported", function() {
      if (!context.halfFloatingPointTexture) {
        expect(function() {
          texture = new import__26.Texture({
            context,
            width: 1,
            height: 1,
            pixelFormat: import__26.PixelDatatype.RGBA,
            pixelDatatype: import__26.PixelDatatype.HALF_FLOAT
          });
        }).toThrowDeveloperError();
      }
    });
    it("throws when creating compressed texture and the array buffer source is undefined", function() {
      expect(function() {
        texture = new import__26.Texture({
          context,
          width: 4,
          height: 4,
          pixelFormat: import__26.PixelFormat.RGBA_DXT3
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating from the framebuffer with an invalid pixel format", function() {
      expect(function() {
        texture = import__26.Texture.fromFramebuffer({
          context,
          pixelFormat: "invalid PixelFormat"
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating from the framebuffer if PixelFormat is DEPTH_COMPONENT or DEPTH_STENCIL", function() {
      expect(function() {
        texture = import__26.Texture.fromFramebuffer({
          context,
          pixelFormat: import__26.PixelFormat.DEPTH_COMPONENT
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating from the framebuffer with a negative framebufferXOffset", function() {
      expect(function() {
        texture = import__26.Texture.fromFramebuffer({
          context,
          pixelFormat: import__26.PixelFormat.RGB,
          framebufferXOffset: -1
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating from the framebuffer with a negative framebufferYOffset", function() {
      expect(function() {
        texture = import__26.Texture.fromFramebuffer({
          context,
          pixelFormat: import__26.PixelFormat.RGB,
          framebufferXOffset: 0,
          framebufferYOffset: -1
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating from the framebuffer with a width greater than the canvas clientWidth", function() {
      expect(function() {
        texture = import__26.Texture.fromFramebuffer({
          context,
          pixelFormat: import__26.PixelFormat.RGB,
          framebufferXOffset: 0,
          framebufferYOffset: 0,
          width: context.canvas.clientWidth + 1
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating from the framebuffer with a height greater than the canvas clientHeight", function() {
      expect(function() {
        texture = import__26.Texture.fromFramebuffer({
          context,
          pixelFormat: import__26.PixelFormat.RGB,
          framebufferXOffset: 0,
          framebufferYOffset: 0,
          width: 1,
          height: context.canvas.clientHeight + 1
        });
      }).toThrowDeveloperError();
    });
    it("throws when copying to a texture from the framebuffer with a DEPTH_COMPONENT or DEPTH_STENCIL pixel format", function() {
      if (context.depthTexture) {
        texture = new import__26.Texture({
          context,
          width: 1,
          height: 1,
          pixelFormat: import__26.PixelFormat.DEPTH_COMPONENT,
          pixelDatatype: import__26.PixelDatatype.UNSIGNED_SHORT
        });
        expect(function() {
          texture.copyFromFramebuffer();
        }).toThrowDeveloperError();
      }
    });
    it("throws when copying to a texture from the framebuffer with a compressed pixel format", function() {
      if (context.supportsBasis) {
        texture = new import__26.Texture({
          context,
          width: greenBasisKTX2Image.width,
          height: greenBasisKTX2Image.height,
          pixelFormat: greenBasisKTX2Image.internalFormat,
          source: {
            arrayBufferView: greenBasisKTX2Image.bufferView
          }
        });
        expect(function() {
          texture.copyFromFramebuffer();
        }).toThrowDeveloperError();
      }
    });
    it("throws when copying to a texture from the framebuffer with a FLOAT pixel data type", function() {
      if (context.floatingPointTexture) {
        texture = new import__26.Texture({
          context,
          width: 1,
          height: 1,
          pixelFormat: import__26.PixelFormat.RGBA,
          pixelDatatype: import__26.PixelDatatype.FLOAT
        });
        expect(function() {
          texture.copyFromFramebuffer();
        }).toThrowDeveloperError();
      }
    });
    it("throws when copying to a texture from the framebuffer with a HALF_FLOAT pixel data type", function() {
      if (context.halfFloatingPointTexture) {
        texture = new import__26.Texture({
          context,
          width: 1,
          height: 1,
          pixelFormat: import__26.PixelFormat.RGBA,
          pixelDatatype: import__26.PixelDatatype.HALF_FLOAT
        });
        expect(function() {
          texture.copyFromFramebuffer();
        }).toThrowDeveloperError();
      }
    });
    it("throws when copying from the framebuffer with a negative xOffset", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage
      });
      expect(function() {
        texture.copyFromFramebuffer(-1);
      }).toThrowDeveloperError();
    });
    it("throws when copying from the framebuffer with a negative yOffset", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage
      });
      expect(function() {
        texture.copyFromFramebuffer(0, -1);
      }).toThrowDeveloperError();
    });
    it("throws when copying from the framebuffer with a negative framebufferXOffset", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage
      });
      expect(function() {
        texture.copyFromFramebuffer(0, 0, -1);
      }).toThrowDeveloperError();
    });
    it("throws when copying from the framebuffer with a negative framebufferYOffset", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage
      });
      expect(function() {
        texture.copyFromFramebuffer(0, 0, 0, -1);
      }).toThrowDeveloperError();
    });
    it("throws when copying from the framebuffer with a larger width", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage
      });
      expect(function() {
        texture.copyFromFramebuffer(0, 0, 0, 0, texture.width + 1);
      }).toThrowDeveloperError();
    });
    it("throws when copying from the framebuffer with a larger height", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage
      });
      expect(function() {
        texture.copyFromFramebuffer(0, 0, 0, 0, 0, texture.height + 1);
      }).toThrowDeveloperError();
    });
    it("throws when copying to a texture with a DEPTH_COMPONENT or DEPTH_STENCIL pixel format", function() {
      if (context.depthTexture) {
        texture = new import__26.Texture({
          context,
          width: 1,
          height: 1,
          pixelFormat: import__26.PixelFormat.DEPTH_COMPONENT,
          pixelDatatype: import__26.PixelDatatype.UNSIGNED_SHORT
        });
        expect(function() {
          texture.copyFrom({
            source: {
              arrayBufferView: new Uint16Array([0]),
              width: 1,
              height: 1
            }
          });
        }).toThrowDeveloperError();
      }
    });
    it("throws when copyFrom is not given any options", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage
      });
      expect(function() {
        texture.copyFrom();
      }).toThrowDeveloperError();
    });
    it("throws when copyFrom is not given a source", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage
      });
      expect(function() {
        texture.copyFrom({
          xOffset: 0,
          yOffset: 2
        });
      }).toThrowDeveloperError();
    });
    it("throws when copyFrom is given a negative xOffset", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage
      });
      expect(function() {
        texture.copyFrom({
          source: blueImage,
          xOffset: -1
        });
      }).toThrowDeveloperError();
    });
    it("throws when copyFrom is given a negative yOffset", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage
      });
      expect(function() {
        texture.copyFrom({
          source: blueImage,
          xOffset: 0,
          yOffset: -1
        });
      }).toThrowDeveloperError();
    });
    it("throws when copyFrom is given a source with larger width", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage
      });
      const image = new Image();
      image.width = blueImage.width + 1;
      expect(function() {
        texture.copyFrom({
          source: image
        });
      }).toThrowDeveloperError();
    });
    it("throws when copyFrom is given a source with larger height", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage
      });
      const image = new Image();
      image.height = blueImage.height + 1;
      expect(function() {
        texture.copyFrom({
          source: image
        });
      }).toThrowDeveloperError();
    });
    it("throws when copyFrom is given a source with a compressed pixel format", function() {
      if (context.supportsBasis) {
        texture = new import__26.Texture({
          context,
          width: greenBasisKTX2Image.width,
          height: greenBasisKTX2Image.height,
          pixelFormat: greenBasisKTX2Image.internalFormat,
          source: {
            arrayBufferView: greenBasisKTX2Image.bufferView
          }
        });
        const image = new Image();
        expect(function() {
          texture.copyFrom({
            source: image
          });
        }).toThrowDeveloperError();
      }
    });
    it("throws when generating mipmaps with a DEPTH_COMPONENT or DEPTH_STENCIL pixel format", function() {
      if (context.depthTexture) {
        texture = new import__26.Texture({
          context,
          width: 1,
          height: 1,
          pixelFormat: import__26.PixelFormat.DEPTH_COMPONENT,
          pixelDatatype: import__26.PixelDatatype.UNSIGNED_SHORT
        });
        expect(function() {
          texture.generateMipmap();
        }).toThrowDeveloperError();
      }
    });
    it("throws when generating mipmaps with a compressed pixel format", function() {
      if (context.supportsBasis) {
        texture = new import__26.Texture({
          context,
          width: greenBasisKTX2Image.width,
          height: greenBasisKTX2Image.height,
          pixelFormat: greenBasisKTX2Image.internalFormat,
          source: {
            arrayBufferView: greenBasisKTX2Image.bufferView
          }
        });
        expect(function() {
          texture.generateMipmap();
        }).toThrowDeveloperError();
      }
    });
    describe("WebGL1", function() {
      let webgl1Context;
      beforeAll(() => {
        webgl1Context = createContext_default({
          requestWebgl1: true
        });
      });
      afterAll(() => {
        webgl1Context.destroyForSpecs();
      });
      it("throws when generating mipmaps with a non-power of two width", function() {
        texture = new import__26.Texture({
          context: webgl1Context,
          width: 3,
          height: 2
        });
        expect(function() {
          texture.generateMipmap();
        }).toThrowDeveloperError();
      });
      it("throws when generating mipmaps with a non-power of two height", function() {
        texture = new import__26.Texture({
          context: webgl1Context,
          width: 2,
          height: 3
        });
        expect(function() {
          texture.generateMipmap();
        }).toThrowDeveloperError();
      });
    });
    it("throws when generating mipmaps with an invalid hint", function() {
      texture = new import__26.Texture({
        context,
        source: blueImage
      });
      expect(function() {
        texture.generateMipmap("invalid hint");
      }).toThrowDeveloperError();
    });
    it("throws when destroy is called after destroying", function() {
      const t = new import__26.Texture({
        context,
        source: blueImage,
        pixelFormat: import__26.PixelFormat.RGBA
      });
      t.destroy();
      expect(function() {
        t.destroy();
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/UniformSpec.js
var import__27 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Uniform",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("sets float uniform", function() {
      const uniformMap = {
        u: function() {
          return 1;
        }
      };
      const fs = "uniform float u;void main() {   out_FragColor = vec4(u == 1.0); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets vec2 uniform", function() {
      const uniformMap = {
        u: function() {
          return new import__27.Cartesian2(0.25, 0.5);
        }
      };
      const fs = "uniform vec2 u;void main() {   out_FragColor = vec4(u == vec2(0.25, 0.5)); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets vec3 uniform (Cartesian3)", function() {
      const uniformMap = {
        u: function() {
          return new import__27.Cartesian3(0.25, 0.5, 0.75);
        }
      };
      const fs = "uniform vec3 u;void main() {   out_FragColor = vec4(u == vec3(0.25, 0.5, 0.75)); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets vec3 uniform (Color)", function() {
      const uniformMap = {
        u: function() {
          return new import__27.Color(0.25, 0.5, 0.75);
        }
      };
      const fs = "uniform vec3 u;void main() {   out_FragColor = vec4(u == vec3(0.25, 0.5, 0.75)); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets vec4 uniform (Cartesian4)", function() {
      const uniformMap = {
        u: function() {
          return new import__27.Cartesian4(0.25, 0.5, 0.75, 1);
        }
      };
      const fs = "uniform vec4 u;void main() {   out_FragColor = vec4(u == vec4(0.25, 0.5, 0.75, 1.0)); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets vec4 uniform (Color)", function() {
      const uniformMap = {
        u: function() {
          return new import__27.Color(0.25, 0.5, 0.75, 1);
        }
      };
      const fs = "uniform vec4 u;void main() {   out_FragColor = vec4(u == vec4(0.25, 0.5, 0.75, 1.0)); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets int uniform", function() {
      const uniformMap = {
        u: function() {
          return 1;
        }
      };
      const fs = "uniform int u;void main() {   out_FragColor = vec4(u == 1); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets ivec2 uniform", function() {
      const uniformMap = {
        u: function() {
          return new import__27.Cartesian2(1, 2);
        }
      };
      const fs = "uniform ivec2 u;void main() {   out_FragColor = vec4(u == ivec2(1, 2)); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets ivec3 uniform", function() {
      const uniformMap = {
        u: function() {
          return new import__27.Cartesian3(1, 2, 3);
        }
      };
      const fs = "uniform ivec3 u;void main() {   out_FragColor = vec4(u == ivec3(1, 2, 3)); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets ivec4 uniform", function() {
      const uniformMap = {
        u: function() {
          return new import__27.Cartesian4(1, 2, 3, 4);
        }
      };
      const fs = "uniform ivec4 u;void main() {   out_FragColor = vec4(u == ivec4(1, 2, 3, 4)); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets bool uniform", function() {
      const uniformMap = {
        u: function() {
          return true;
        }
      };
      const fs = "uniform bool u;void main() {   out_FragColor = vec4(u); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets bvec2 uniform", function() {
      const uniformMap = {
        u: function() {
          return new import__27.Cartesian2(true, false);
        }
      };
      const fs = "uniform bvec2 u;void main() {   out_FragColor = vec4(u == bvec2(true, false)); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets bvec3 uniform", function() {
      const uniformMap = {
        u: function() {
          return new import__27.Cartesian3(true, false, true);
        }
      };
      const fs = "uniform bvec3 u;void main() {   out_FragColor = vec4(u == bvec3(true, false, true)); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets bvec4 uniform", function() {
      const uniformMap = {
        u: function() {
          return new import__27.Cartesian4(true, false, true, false);
        }
      };
      const fs = "uniform bvec4 u;void main() {   out_FragColor = vec4(u == bvec4(true, false, true, false)); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets mat2 uniform", function() {
      const uniformMap = {
        u: function() {
          return new import__27.Matrix2(1, 2, 3, 4);
        }
      };
      const fs = "uniform mat2 u;void main() {   out_FragColor = vec4(    (u[0].x == 1.0) && (u[1].x == 2.0) &&    (u[0].y == 3.0) && (u[1].y == 4.0)   ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets mat3 uniform", function() {
      const uniformMap = {
        u: function() {
          return new import__27.Matrix3(1, 2, 3, 4, 5, 6, 7, 8, 9);
        }
      };
      const fs = "uniform mat3 u;void main() {   out_FragColor = vec4(    (u[0].x == 1.0) && (u[1].x == 2.0) && (u[2].x == 3.0) &&    (u[0].y == 4.0) && (u[1].y == 5.0) && (u[2].y == 6.0) &&    (u[0].z == 7.0) && (u[1].z == 8.0) && (u[2].z == 9.0)  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets mat4 uniform", function() {
      const uniformMap = {
        u: function() {
          return new import__27.Matrix4(
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            9,
            10,
            11,
            12,
            13,
            14,
            15,
            16
          );
        }
      };
      const fs = "uniform mat4 u;void main() {   out_FragColor = vec4(    (u[0].x == 1.0)  && (u[1].x == 2.0)  && (u[2].x == 3.0)  && (u[3].x == 4.0) &&    (u[0].y == 5.0)  && (u[1].y == 6.0)  && (u[2].y == 7.0)  && (u[3].y == 8.0) &&    (u[0].z == 9.0)  && (u[1].z == 10.0) && (u[2].z == 11.0) && (u[3].z == 12.0) &&    (u[0].w == 13.0) && (u[1].w == 14.0) && (u[2].w == 15.0) && (u[3].w == 16.0)  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets a struct uniform", function() {
      const uniformMap = {
        "u.f": function() {
          return 2.5;
        },
        "u.v": function() {
          return new import__27.Cartesian4(0.25, 0.5, 0.75, 1);
        }
      };
      const fs = "uniform struct { float f; vec4 v; } u;void main() {   out_FragColor = vec4((u.f == 2.5)); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets float uniform array", function() {
      const uniformMap = {
        u: function() {
          return new Float32Array([0.25, 0.5]);
        },
        u2: function() {
          return [1.25, 1.5];
        }
      };
      const fs = "uniform float u[2];uniform float u2[2];void main() {   out_FragColor = vec4(    (u[0] == 0.25) && (u[1] == 0.5) &&    (u2[0] == 1.25) && (u2[1] == 1.5)  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets vec2 uniform array", function() {
      const uniformMap = {
        u: function() {
          return [new import__27.Cartesian2(0.25, 0.5), new import__27.Cartesian2(1.25, 1.5)];
        }
      };
      const fs = "uniform vec2 u[2];void main() {   out_FragColor = vec4(    (u[0] == vec2(0.25, 0.5)) &&    (u[1] == vec2(1.25, 1.5))  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets vec3 uniform array", function() {
      const uniformMap = {
        u: function() {
          return [
            new import__27.Cartesian3(0.25, 0.5, 0.75),
            new import__27.Cartesian3(1.25, 1.5, 1.75)
          ];
        }
      };
      const fs = "uniform vec3 u[2];void main() {   out_FragColor = vec4(    (u[0] == vec3(0.25, 0.5, 0.75)) &&    (u[1] == vec3(1.25, 1.5, 1.75))  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets vec4 uniform array", function() {
      const uniformMap = {
        u: function() {
          return [
            new import__27.Cartesian4(0.25, 0.5, 0.75, 1),
            new import__27.Cartesian4(1.25, 1.5, 1.75, 2)
          ];
        }
      };
      const fs = "uniform vec4 u[2];void main() {   out_FragColor = vec4(    (u[0] == vec4(0.25, 0.5, 0.75, 1.0)) &&    (u[1] == vec4(1.25, 1.5, 1.75, 2.0))  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets int uniform array", function() {
      const uniformMap = {
        u: function() {
          return new Int32Array([1, 2]);
        },
        u2: function() {
          return [3, 4];
        }
      };
      const fs = "uniform int u[2];uniform int u2[2];void main() {   out_FragColor = vec4(    (u[0] == 1) && (u[1] == 2) &&    (u2[0] == 3) && (u2[1] == 4)  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets ivec2 uniform array", function() {
      const uniformMap = {
        u: function() {
          return [new import__27.Cartesian2(1, 2), new import__27.Cartesian2(3, 4)];
        }
      };
      const fs = "uniform ivec2 u[2];void main() {   out_FragColor = vec4(    (u[0] == ivec2(1, 2)) &&    (u[1] == ivec2(3, 4))  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets ivec3 uniform array", function() {
      const uniformMap = {
        u: function() {
          return [new import__27.Cartesian3(1, 2, 3), new import__27.Cartesian3(4, 5, 6)];
        }
      };
      const fs = "uniform ivec3 u[2];void main() {   out_FragColor = vec4(    (u[0] == ivec3(1, 2, 3)) &&    (u[1] == ivec3(4, 5, 6))  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets ivec4 uniform array", function() {
      const uniformMap = {
        u: function() {
          return [new import__27.Cartesian4(1, 2, 3, 4), new import__27.Cartesian4(5, 6, 7, 8)];
        }
      };
      const fs = "uniform ivec4 u[2];void main() {   out_FragColor = vec4(    (u[0] == ivec4(1, 2, 3, 4)) &&    (u[1] == ivec4(5, 6, 7, 8))  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets bool uniform array", function() {
      const uniformMap = {
        u: function() {
          return new Int32Array([1, 0]);
        },
        u2: function() {
          return [0, 1];
        }
      };
      const fs = "uniform bool u[2];uniform bool u2[2];void main() {   out_FragColor = vec4(    u[0] && !u[1] &&    !u2[0] && u2[1]  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets bvec2 uniform array", function() {
      const uniformMap = {
        u: function() {
          return [new import__27.Cartesian2(true, false), new import__27.Cartesian2(false, true)];
        }
      };
      const fs = "uniform bvec2 u[2];void main() {   out_FragColor = vec4(    (u[0] == bvec2(true, false)) &&    (u[1] == bvec2(false, true))  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets bvec3 uniform array", function() {
      const uniformMap = {
        u: function() {
          return [
            new import__27.Cartesian3(true, false, true),
            new import__27.Cartesian3(false, true, false)
          ];
        }
      };
      const fs = "uniform bvec3 u[2];void main() {   out_FragColor = vec4(    (u[0] == bvec3(true, false, true)) &&    (u[1] == bvec3(false, true, false))  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets bvec4 uniform array", function() {
      const uniformMap = {
        u: function() {
          return [
            new import__27.Cartesian4(true, false, true, false),
            new import__27.Cartesian4(false, true, false, true)
          ];
        }
      };
      const fs = "uniform bvec4 u[2];void main() {   out_FragColor = vec4(    (u[0] == bvec4(true, false, true, false)) &&    (u[1] == bvec4(false, true, false, true))  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets mat2 uniform array", function() {
      const uniformMap = {
        u: function() {
          return [
            new import__27.Matrix2(1, 2, 3, 4),
            new import__27.Matrix2(5, 6, 7, 8)
          ];
        }
      };
      const fs = "uniform mat2 u[2];void main() {   out_FragColor = vec4(    ((u[0])[0].x == 1.0) && ((u[0])[1].x == 2.0) &&    ((u[0])[0].y == 3.0) && ((u[0])[1].y == 4.0) &&    ((u[1])[0].x == 5.0) && ((u[1])[1].x == 6.0) &&    ((u[1])[0].y == 7.0) && ((u[1])[1].y == 8.0)   ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets mat3 uniform array", function() {
      const uniformMap = {
        u: function() {
          return [
            new import__27.Matrix3(1, 2, 3, 4, 5, 6, 7, 8, 9),
            new import__27.Matrix3(11, 12, 13, 14, 15, 16, 17, 18, 19)
          ];
        }
      };
      const fs = "uniform mat3 u[2];void main() {   out_FragColor = vec4(    ((u[0])[0].x == 1.0) && ((u[0])[1].x == 2.0) && ((u[0])[2].x == 3.0) &&    ((u[0])[0].y == 4.0) && ((u[0])[1].y == 5.0) && ((u[0])[2].y == 6.0) &&    ((u[0])[0].z == 7.0) && ((u[0])[1].z == 8.0) && ((u[0])[2].z == 9.0) &&    ((u[1])[0].x == 11.0) && ((u[1])[1].x == 12.0) && ((u[1])[2].x == 13.0) &&    ((u[1])[0].y == 14.0) && ((u[1])[1].y == 15.0) && ((u[1])[2].y == 16.0) &&    ((u[1])[0].z == 17.0) && ((u[1])[1].z == 18.0) && ((u[1])[2].z == 19.0)  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("sets mat4 uniform array", function() {
      const uniformMap = {
        u: function() {
          return [
            new import__27.Matrix4(
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              9,
              10,
              11,
              12,
              13,
              14,
              15,
              16
            ),
            new import__27.Matrix4(
              11,
              12,
              13,
              14,
              15,
              16,
              17,
              18,
              19,
              110,
              111,
              112,
              113,
              114,
              115,
              116
            )
          ];
        }
      };
      const fs = "uniform mat4 u[2];void main() {   out_FragColor = vec4(    ((u[0])[0].x == 1.0)  && ((u[0])[1].x == 2.0)  && ((u[0])[2].x == 3.0)  && ((u[0])[3].x == 4.0) &&    ((u[0])[0].y == 5.0)  && ((u[0])[1].y == 6.0)  && ((u[0])[2].y == 7.0)  && ((u[0])[3].y == 8.0) &&    ((u[0])[0].z == 9.0)  && ((u[0])[1].z == 10.0) && ((u[0])[2].z == 11.0) && ((u[0])[3].z == 12.0) &&    ((u[0])[0].w == 13.0) && ((u[0])[1].w == 14.0) && ((u[0])[2].w == 15.0) && ((u[0])[3].w == 16.0) &&    ((u[1])[0].x == 11.0)  && ((u[1])[1].x == 12.0)  && ((u[1])[2].x == 13.0)  && ((u[1])[3].x == 14.0) &&    ((u[1])[0].y == 15.0)  && ((u[1])[1].y == 16.0)  && ((u[1])[2].y == 17.0)  && ((u[1])[3].y == 18.0) &&    ((u[1])[0].z == 19.0)  && ((u[1])[1].z == 110.0) && ((u[1])[2].z == 111.0) && ((u[1])[3].z == 112.0) &&    ((u[1])[0].w == 113.0) && ((u[1])[1].w == 114.0) && ((u[1])[2].w == 115.0) && ((u[1])[3].w == 116.0)  ); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/VertexArrayFacadeSpec.js
var import__28 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/VertexArrayFacade",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("creates a vertex array with static floats", function() {
      const positionIndex = 0;
      const vaf = new import__28.VertexArrayFacade(
        context,
        [
          {
            index: positionIndex,
            componentsPerAttribute: 3,
            componentDatatype: import__28.ComponentDatatype.FLOAT,
            usage: import__28.BufferUsage.STATIC_DRAW
          }
        ],
        1
      );
      const writer = vaf.writers[positionIndex];
      expect(writer).toBeDefined();
      writer(0, 1, 2, 3);
      vaf.commit();
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer).toBeDefined();
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer.sizeInBytes).toEqual(
        1 * 3 * 4
      );
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer.usage).toEqual(
        import__28.BufferUsage.STATIC_DRAW
      );
      expect(vaf.va[0].va.getAttribute(0).componentsPerAttribute).toEqual(3);
      expect(vaf.va[0].va.getAttribute(0).componentDatatype).toEqual(
        import__28.ComponentDatatype.FLOAT
      );
      expect(vaf.va[0].va.getAttribute(0).offsetInBytes).toEqual(0);
      expect(vaf.va[0].va.getAttribute(0).strideInBytes).toEqual(3 * 4);
    });
    it("resizes a vertex array with static floats", function() {
      const positionIndex = 0;
      const vaf = new import__28.VertexArrayFacade(
        context,
        [
          {
            index: positionIndex,
            componentsPerAttribute: 3,
            componentDatatype: import__28.ComponentDatatype.FLOAT,
            usage: import__28.BufferUsage.STATIC_DRAW
          }
        ],
        1
      );
      const writer = vaf.writers[positionIndex];
      expect(writer).toBeDefined();
      writer(0, 1, 2, 3);
      vaf.resize(2);
      writer(1, 1, 2, 3);
      vaf.commit();
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer).toBeDefined();
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer.sizeInBytes).toEqual(
        2 * 3 * 4
      );
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer.usage).toEqual(
        import__28.BufferUsage.STATIC_DRAW
      );
      expect(vaf.va[0].va.getAttribute(0).componentsPerAttribute).toEqual(3);
      expect(vaf.va[0].va.getAttribute(0).componentDatatype).toEqual(
        import__28.ComponentDatatype.FLOAT
      );
      expect(vaf.va[0].va.getAttribute(0).offsetInBytes).toEqual(0);
      expect(vaf.va[0].va.getAttribute(0).strideInBytes).toEqual(3 * 4);
    });
    it("creates a vertex array with static floats and unsigned bytes", function() {
      const positionIndex = 0;
      const colorIndex = 2;
      const vaf = new import__28.VertexArrayFacade(
        context,
        [
          {
            index: positionIndex,
            componentsPerAttribute: 3,
            componentDatatype: import__28.ComponentDatatype.FLOAT,
            usage: import__28.BufferUsage.STATIC_DRAW
          },
          {
            index: colorIndex,
            componentsPerAttribute: 4,
            componentDatatype: import__28.ComponentDatatype.UNSIGNED_BYTE,
            usage: import__28.BufferUsage.STATIC_DRAW
          }
        ],
        1
      );
      const positionWriter = vaf.writers[positionIndex];
      const colorWriter = vaf.writers[colorIndex];
      expect(positionWriter).toBeDefined();
      expect(colorWriter).toBeDefined();
      positionWriter(0, 1, 2, 3);
      colorWriter(0, 0, 255, 0, 255);
      vaf.commit();
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer).toBeDefined();
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer.sizeInBytes).toEqual(
        1 * (3 * 4 + 4 * 1)
      );
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer.usage).toEqual(
        import__28.BufferUsage.STATIC_DRAW
      );
      expect(vaf.va[0].va.getAttribute(0).componentsPerAttribute).toEqual(3);
      expect(vaf.va[0].va.getAttribute(0).componentDatatype).toEqual(
        import__28.ComponentDatatype.FLOAT
      );
      expect(vaf.va[0].va.getAttribute(0).offsetInBytes).toEqual(0);
      expect(vaf.va[0].va.getAttribute(0).strideInBytes).toEqual(3 * 4 + 4 * 1);
      expect(vaf.va[0].va.getAttribute(1).vertexBuffer).toEqual(
        vaf.va[0].va.getAttribute(0).vertexBuffer
      );
      expect(vaf.va[0].va.getAttribute(1).componentsPerAttribute).toEqual(4);
      expect(vaf.va[0].va.getAttribute(1).componentDatatype).toEqual(
        import__28.ComponentDatatype.UNSIGNED_BYTE
      );
      expect(vaf.va[0].va.getAttribute(1).offsetInBytes).toEqual(3 * 4);
      expect(vaf.va[0].va.getAttribute(1).strideInBytes).toEqual(
        vaf.va[0].va.getAttribute(0).strideInBytes
      );
    });
    it("creates a vertex array with static and dynamic attributes", function() {
      const positionIndex = 0;
      const txCoordIndex = 2;
      const vaf = new import__28.VertexArrayFacade(
        context,
        [
          {
            index: positionIndex,
            componentsPerAttribute: 3,
            componentDatatype: import__28.ComponentDatatype.FLOAT,
            usage: import__28.BufferUsage.STATIC_DRAW
          },
          {
            index: txCoordIndex,
            componentsPerAttribute: 2,
            componentDatatype: import__28.ComponentDatatype.UNSIGNED_SHORT,
            usage: import__28.BufferUsage.DYNAMIC_DRAW,
            normalize: true
          }
        ],
        1
      );
      const positionWriter = vaf.writers[positionIndex];
      const txCoordWriter = vaf.writers[txCoordIndex];
      expect(positionWriter).toBeDefined();
      expect(txCoordWriter).toBeDefined();
      positionWriter(0, 1, 2, 3);
      txCoordWriter(0, 32 * 1024, 64 * 1024);
      vaf.commit();
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer).toBeDefined();
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer.sizeInBytes).toEqual(
        1 * (3 * 4)
      );
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer.usage).toEqual(
        import__28.BufferUsage.STATIC_DRAW
      );
      expect(vaf.va[0].va.getAttribute(0).componentsPerAttribute).toEqual(3);
      expect(vaf.va[0].va.getAttribute(0).componentDatatype).toEqual(
        import__28.ComponentDatatype.FLOAT
      );
      expect(vaf.va[0].va.getAttribute(0).offsetInBytes).toEqual(0);
      expect(vaf.va[0].va.getAttribute(0).strideInBytes).toEqual(3 * 4);
      expect(vaf.va[0].va.getAttribute(1).vertexBuffer).toBeDefined();
      expect(vaf.va[0].va.getAttribute(1).vertexBuffer.sizeInBytes).toEqual(
        1 * (2 * 2)
      );
      expect(vaf.va[0].va.getAttribute(1).vertexBuffer.usage).toEqual(
        import__28.BufferUsage.DYNAMIC_DRAW
      );
      expect(vaf.va[0].va.getAttribute(1).componentsPerAttribute).toEqual(2);
      expect(vaf.va[0].va.getAttribute(1).componentDatatype).toEqual(
        import__28.ComponentDatatype.UNSIGNED_SHORT
      );
      expect(vaf.va[0].va.getAttribute(1).offsetInBytes).toEqual(0);
      expect(vaf.va[0].va.getAttribute(1).strideInBytes).toEqual(2 * 2);
    });
    it("sub-commits", function() {
      const positionIndex = 0;
      const temperatureIndex = 2;
      const vaf = new import__28.VertexArrayFacade(
        context,
        [
          {
            index: positionIndex,
            componentsPerAttribute: 3,
            componentDatatype: import__28.ComponentDatatype.FLOAT,
            usage: import__28.BufferUsage.STATIC_DRAW
          },
          {
            index: temperatureIndex,
            componentsPerAttribute: 1,
            componentDatatype: import__28.ComponentDatatype.FLOAT,
            usage: import__28.BufferUsage.STREAM_DRAW
          }
        ],
        2
      );
      const positionWriter = vaf.writers[positionIndex];
      const temperatureWriter = vaf.writers[temperatureIndex];
      expect(positionWriter).toBeDefined();
      expect(temperatureWriter).toBeDefined();
      positionWriter(0, 1, 2, 3);
      temperatureWriter(0, 98.6);
      positionWriter(1, 7, 8, 9);
      temperatureWriter(1, 32);
      vaf.commit();
      positionWriter(0, 10, 20, 30);
      temperatureWriter(0, 37);
      positionWriter(1, 70, 80, 90);
      temperatureWriter(1, 0);
      vaf.commit();
      temperatureWriter(1, 212);
      vaf.subCommit(1, 1);
      vaf.endSubCommits();
      expect(vaf.va[0].va.getAttribute(1).vertexBuffer).toBeDefined();
      expect(vaf.va[0].va.getAttribute(1).vertexBuffer.sizeInBytes).toEqual(
        2 * (3 * 4)
      );
      expect(vaf.va[0].va.getAttribute(1).vertexBuffer.usage).toEqual(
        import__28.BufferUsage.STATIC_DRAW
      );
      expect(vaf.va[0].va.getAttribute(1).componentsPerAttribute).toEqual(3);
      expect(vaf.va[0].va.getAttribute(1).componentDatatype).toEqual(
        import__28.ComponentDatatype.FLOAT
      );
      expect(vaf.va[0].va.getAttribute(1).offsetInBytes).toEqual(0);
      expect(vaf.va[0].va.getAttribute(1).strideInBytes).toEqual(3 * 4);
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer).toBeDefined();
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer.sizeInBytes).toEqual(
        2 * 4
      );
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer.usage).toEqual(
        import__28.BufferUsage.STREAM_DRAW
      );
      expect(vaf.va[0].va.getAttribute(0).componentsPerAttribute).toEqual(1);
      expect(vaf.va[0].va.getAttribute(0).componentDatatype).toEqual(
        import__28.ComponentDatatype.FLOAT
      );
      expect(vaf.va[0].va.getAttribute(0).offsetInBytes).toEqual(0);
      expect(vaf.va[0].va.getAttribute(0).strideInBytes).toEqual(1 * 4);
    });
    it("destroys previous vertex buffers when number of vertices grows", function() {
      const positionIndex = 0;
      const vaf = new import__28.VertexArrayFacade(
        context,
        [
          {
            index: positionIndex,
            componentsPerAttribute: 3,
            componentDatatype: import__28.ComponentDatatype.FLOAT,
            usage: import__28.BufferUsage.STATIC_DRAW
          }
        ],
        1
      );
      const writer = vaf.writers[positionIndex];
      expect(writer).toBeDefined();
      writer(0, 1, 2, 3);
      vaf.commit();
      const vbBeforeResize = vaf.va[0].va.getAttribute(0).vertexBuffer;
      vaf.resize(2);
      writer(1, 1, 2, 3);
      vaf.commit();
      expect(vbBeforeResize.isDestroyed()).toBe(true);
      expect(vaf.va[0].va.getAttribute(0).vertexBuffer).not.toBe(
        vbBeforeResize
      );
    });
    it("is not initially destroyed", function() {
      const positionIndex = 0;
      const vaf = new import__28.VertexArrayFacade(
        context,
        [
          {
            index: positionIndex,
            componentsPerAttribute: 3,
            componentDatatype: import__28.ComponentDatatype.FLOAT,
            usage: import__28.BufferUsage.STATIC_DRAW
          }
        ],
        1
      );
      expect(vaf.isDestroyed()).toBe(false);
    });
    it("throws when constructed without a context", function() {
      expect(function() {
        return new import__28.VertexArrayFacade(void 0, void 0, void 0);
      }).toThrowDeveloperError();
    });
    it("throws when constructed undefined attributes", function() {
      expect(function() {
        return new import__28.VertexArrayFacade(context, void 0, void 0);
      }).toThrowDeveloperError();
    });
    it("throws when constructed without attributes", function() {
      expect(function() {
        return new import__28.VertexArrayFacade(context, []);
      }).toThrowDeveloperError();
    });
    it("throws when constructed with attributes without componentsPerAttribute", function() {
      expect(function() {
        return new import__28.VertexArrayFacade(context, [{}]);
      }).toThrowDeveloperError();
    });
    it("throws when constructed with attributes with an invalid componentDatatype", function() {
      expect(function() {
        return new import__28.VertexArrayFacade(context, [
          {
            componentsPerAttribute: 1,
            componentDatatype: "invalid component datatype"
          }
        ]);
      }).toThrowDeveloperError();
    });
    it("throws when constructed with attributes with an invalid usage", function() {
      expect(function() {
        return new import__28.VertexArrayFacade(context, [
          {
            componentsPerAttribute: 1,
            usage: "invalid component usage"
          }
        ]);
      }).toThrowDeveloperError();
    });
    it("throws when constructed with attributes with duplicate indices", function() {
      expect(function() {
        return new import__28.VertexArrayFacade(context, [
          {
            index: 0,
            componentsPerAttribute: 1
          },
          {
            index: 0,
            componentsPerAttribute: 1
          }
        ]);
      }).toThrowDeveloperError();
    });
    it("subCommit throws when passed an invalid offsetInVertices", function() {
      const positionIndex = 0;
      const vaf = new import__28.VertexArrayFacade(
        context,
        [
          {
            index: positionIndex,
            componentsPerAttribute: 3,
            componentDatatype: import__28.ComponentDatatype.FLOAT,
            usage: import__28.BufferUsage.STATIC_DRAW
          }
        ],
        10
      );
      expect(function() {
        vaf.subCommit(-1, 1);
      }).toThrowDeveloperError();
      expect(function() {
        vaf.subCommit(10, 1);
      }).toThrowDeveloperError();
      expect(function() {
        vaf.subCommit(1, 10);
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/VertexArrayFactorySpec.js
var import__29 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/VertexArrayFactory",
  function() {
    let context;
    let va;
    let sp;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    afterEach(function() {
      va = va && va.destroy();
      sp = sp && sp.destroy();
    });
    it("throws when there is no context", function() {
      expect(function() {
        return import__29.VertexArray.fromGeometry();
      }).toThrowDeveloperError();
    });
    it("creates with no optional arguments", function() {
      va = import__29.VertexArray.fromGeometry({
        context
      });
      expect(va.numberOfAttributes).toEqual(0);
      expect(va.indexBuffer).not.toBeDefined();
    });
    it("creates with no geometry", function() {
      va = import__29.VertexArray.fromGeometry({
        context,
        interleave: true
      });
      expect(va.numberOfAttributes).toEqual(0);
      expect(va.indexBuffer).not.toBeDefined();
    });
    it("creates a single-attribute vertex (non-interleaved)", function() {
      const geometry = new import__29.Geometry({
        attributes: {
          position: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0, 1, 1, 1]
          })
        },
        primitiveType: import__29.PrimitiveType.POINTS
      });
      const va2 = import__29.VertexArray.fromGeometry({
        context,
        geometry,
        attributeLocations: import__29.GeometryPipeline.createAttributeLocations(geometry)
      });
      expect(va2.numberOfAttributes).toEqual(1);
      expect(va2.indexBuffer).not.toBeDefined();
      const position = geometry.attributes.position;
      expect(va2.getAttribute(0).index).toEqual(0);
      expect(va2.getAttribute(0).componentDatatype).toEqual(
        position.componentDatatype
      );
      expect(va2.getAttribute(0).componentsPerAttribute).toEqual(
        position.componentsPerAttribute
      );
      expect(va2.getAttribute(0).offsetInBytes).toEqual(0);
      expect(va2.getAttribute(0).strideInBytes).toEqual(0);
      expect(va2.getAttribute(0).vertexBuffer.usage).toEqual(
        import__29.BufferUsage.DYNAMIC_DRAW
      );
    });
    it("creates a single-attribute vertex (interleaved)", function() {
      const geometry = new import__29.Geometry({
        attributes: {
          position: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0, 1, 1, 1]
          })
        },
        primitiveType: import__29.PrimitiveType.POINTS
      });
      const va2 = import__29.VertexArray.fromGeometry({
        context,
        geometry,
        attributeLocations: import__29.GeometryPipeline.createAttributeLocations(geometry),
        interleave: true,
        bufferUsage: import__29.BufferUsage.STATIC_DRAW
      });
      expect(va2.numberOfAttributes).toEqual(1);
      expect(va2.indexBuffer).not.toBeDefined();
      const position = geometry.attributes.position;
      expect(va2.getAttribute(0).index).toEqual(0);
      expect(va2.getAttribute(0).componentDatatype).toEqual(
        position.componentDatatype
      );
      expect(va2.getAttribute(0).componentsPerAttribute).toEqual(
        position.componentsPerAttribute
      );
      expect(va2.getAttribute(0).offsetInBytes).toEqual(0);
      expect(va2.getAttribute(0).strideInBytes).toEqual(
        import__29.ComponentDatatype.getSizeInBytes(position.componentDatatype) * position.componentsPerAttribute
      );
      expect(va2.getAttribute(0).vertexBuffer.usage).toEqual(
        import__29.BufferUsage.STATIC_DRAW
      );
    });
    it("creates a homogeneous multiple-attribute vertex (non-interleaved)", function() {
      const geometry = new import__29.Geometry({
        attributes: {
          customPosition: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0, 2, 2, 2]
          }),
          customNormal: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [1, 1, 1, 3, 3, 3]
          })
        },
        primitiveType: import__29.PrimitiveType.POINTS
      });
      const va2 = import__29.VertexArray.fromGeometry({
        context,
        geometry,
        attributeLocations: import__29.GeometryPipeline.createAttributeLocations(geometry)
      });
      expect(va2.numberOfAttributes).toEqual(2);
      expect(va2.indexBuffer).not.toBeDefined();
      const position = geometry.attributes.customPosition;
      expect(va2.getAttribute(0).index).toEqual(0);
      expect(va2.getAttribute(0).componentDatatype).toEqual(
        position.componentDatatype
      );
      expect(va2.getAttribute(0).componentsPerAttribute).toEqual(
        position.componentsPerAttribute
      );
      expect(va2.getAttribute(0).offsetInBytes).toEqual(0);
      expect(va2.getAttribute(0).strideInBytes).toEqual(0);
      const normal = geometry.attributes.customNormal;
      expect(va2.getAttribute(1).index).toEqual(1);
      expect(va2.getAttribute(1).componentDatatype).toEqual(
        normal.componentDatatype
      );
      expect(va2.getAttribute(1).componentsPerAttribute).toEqual(
        normal.componentsPerAttribute
      );
      expect(va2.getAttribute(1).offsetInBytes).toEqual(0);
      expect(va2.getAttribute(1).strideInBytes).toEqual(0);
      expect(va2.getAttribute(0).vertexBuffer).not.toBe(
        va2.getAttribute(1).vertexBuffer
      );
    });
    it("creates a homogeneous multiple-attribute vertex (interleaved)", function() {
      const geometry = new import__29.Geometry({
        attributes: {
          customPosition: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0, 2, 2, 2]
          }),
          customNormal: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [1, 1, 1, 3, 3, 3]
          })
        },
        primitiveType: import__29.PrimitiveType.POINTS
      });
      const va2 = import__29.VertexArray.fromGeometry({
        context,
        geometry,
        attributeLocations: import__29.GeometryPipeline.createAttributeLocations(geometry),
        interleave: true
      });
      expect(va2.numberOfAttributes).toEqual(2);
      expect(va2.indexBuffer).not.toBeDefined();
      const position = geometry.attributes.customPosition;
      const normal = geometry.attributes.customNormal;
      const expectedStride = import__29.ComponentDatatype.getSizeInBytes(position.componentDatatype) * position.componentsPerAttribute + import__29.ComponentDatatype.getSizeInBytes(normal.componentDatatype) * normal.componentsPerAttribute;
      expect(va2.getAttribute(0).index).toEqual(0);
      expect(va2.getAttribute(0).componentDatatype).toEqual(
        position.componentDatatype
      );
      expect(va2.getAttribute(0).componentsPerAttribute).toEqual(
        position.componentsPerAttribute
      );
      expect(va2.getAttribute(0).offsetInBytes).toEqual(0);
      expect(va2.getAttribute(0).strideInBytes).toEqual(expectedStride);
      expect(va2.getAttribute(1).index).toEqual(1);
      expect(va2.getAttribute(1).componentDatatype).toEqual(
        normal.componentDatatype
      );
      expect(va2.getAttribute(1).componentsPerAttribute).toEqual(
        normal.componentsPerAttribute
      );
      expect(va2.getAttribute(1).offsetInBytes).toEqual(
        import__29.ComponentDatatype.getSizeInBytes(position.componentDatatype) * position.componentsPerAttribute
      );
      expect(va2.getAttribute(1).strideInBytes).toEqual(expectedStride);
      expect(va2.getAttribute(0).vertexBuffer).toBe(
        va2.getAttribute(1).vertexBuffer
      );
    });
    it("creates a heterogeneous multiple-attribute vertex (interleaved)", function() {
      const geometry = new import__29.Geometry({
        attributes: {
          position: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0, 2, 2, 2]
          }),
          colors: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.UNSIGNED_BYTE,
            componentsPerAttribute: 4,
            values: [1, 1, 1, 1, 2, 2, 2, 2]
          })
        },
        primitiveType: import__29.PrimitiveType.POINTS
      });
      const va2 = import__29.VertexArray.fromGeometry({
        context,
        geometry,
        attributeLocations: import__29.GeometryPipeline.createAttributeLocations(geometry),
        interleave: true
      });
      expect(va2.numberOfAttributes).toEqual(2);
      expect(va2.indexBuffer).not.toBeDefined();
      const position = geometry.attributes.position;
      const colors = geometry.attributes.colors;
      const expectedStride = import__29.ComponentDatatype.getSizeInBytes(position.componentDatatype) * position.componentsPerAttribute + import__29.ComponentDatatype.getSizeInBytes(colors.componentDatatype) * colors.componentsPerAttribute;
      expect(va2.getAttribute(0).index).toEqual(0);
      expect(va2.getAttribute(0).componentDatatype).toEqual(
        position.componentDatatype
      );
      expect(va2.getAttribute(0).componentsPerAttribute).toEqual(
        position.componentsPerAttribute
      );
      expect(va2.getAttribute(0).offsetInBytes).toEqual(0);
      expect(va2.getAttribute(0).strideInBytes).toEqual(expectedStride);
      expect(va2.getAttribute(1).index).toEqual(1);
      expect(va2.getAttribute(1).componentDatatype).toEqual(
        colors.componentDatatype
      );
      expect(va2.getAttribute(1).componentsPerAttribute).toEqual(
        colors.componentsPerAttribute
      );
      expect(va2.getAttribute(1).offsetInBytes).toEqual(
        import__29.ComponentDatatype.getSizeInBytes(position.componentDatatype) * position.componentsPerAttribute
      );
      expect(va2.getAttribute(1).strideInBytes).toEqual(expectedStride);
      expect(va2.getAttribute(0).vertexBuffer).toBe(
        va2.getAttribute(1).vertexBuffer
      );
    });
    it("sorts interleaved attributes from large to small components", function() {
      const geometry = new import__29.Geometry({
        attributes: {
          bytes: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.BYTE,
            componentsPerAttribute: 1,
            values: [0]
          }),
          shorts: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.SHORT,
            componentsPerAttribute: 1,
            values: [1]
          }),
          floats: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 1,
            values: [2]
          })
        },
        primitiveType: import__29.PrimitiveType.POINTS
      });
      const attributeLocations = import__29.GeometryPipeline.createAttributeLocations(
        geometry
      );
      const va2 = import__29.VertexArray.fromGeometry({
        context,
        geometry,
        attributeLocations,
        interleave: true
      });
      expect(va2.numberOfAttributes).toEqual(3);
      const vertexBuffer = va2.getAttribute(0).vertexBuffer;
      expect(vertexBuffer).toBe(va2.getAttribute(1).vertexBuffer);
      expect(vertexBuffer).toBe(va2.getAttribute(2).vertexBuffer);
      expect(vertexBuffer.sizeInBytes).toEqual(8);
      const vs = "in float bytes; in float shorts; in float floats; out vec4 fsColor; void main() {   gl_PointSize = 1.0;   gl_Position = vec4(0.0, 0.0, 0.0, 1.0);   fsColor = vec4((bytes == 0.0) && (shorts == 1.0) && (floats == 2.0)); }";
      const fs = "in vec4 fsColor; void main() {   out_FragColor = fsColor; }";
      sp = import__29.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations
      });
      import__29.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__29.DrawCommand({
        primitiveType: import__29.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va2
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("sorts interleaved attributes from large to small components (2)", function() {
      const geometry = new import__29.Geometry({
        attributes: {
          color: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.UNSIGNED_BYTE,
            componentsPerAttribute: 4,
            normalize: true,
            values: [255, 0, 0, 255, 0, 255, 0, 255]
          }),
          position: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0, 0, 0, 0]
          })
        },
        primitiveType: import__29.PrimitiveType.POINTS
      });
      const attributeLocations = import__29.GeometryPipeline.createAttributeLocations(
        geometry
      );
      const va2 = import__29.VertexArray.fromGeometry({
        context,
        geometry,
        attributeLocations,
        interleave: true
      });
      expect(va2.getAttribute(0).vertexBuffer.sizeInBytes).toEqual(32);
      const vs = "in vec3 position; in vec4 color; out vec4 fsColor; void main() {   gl_PointSize = 1.0;   gl_Position = vec4(position, 1.0);   fsColor = color; }";
      const fs = "in vec4 fsColor; void main() {   out_FragColor = fsColor; }";
      sp = import__29.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations
      });
      import__29.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__29.DrawCommand({
        primitiveType: import__29.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va2,
        offset: 0,
        count: 1
      });
      command.execute(context);
      expect(context).toReadPixels([255, 0, 0, 255]);
      command = new import__29.DrawCommand({
        primitiveType: import__29.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va2,
        offset: 1,
        count: 1
      });
      command.execute(context);
      expect(context).toReadPixels([0, 255, 0, 255]);
    });
    it("sorts interleaved attributes from large to small components (3)", function() {
      const geometry = new import__29.Geometry({
        attributes: {
          unsignedByteAttribute: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.UNSIGNED_BYTE,
            componentsPerAttribute: 2,
            values: [1, 2]
          }),
          unsignedShortAttribute: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.UNSIGNED_SHORT,
            componentsPerAttribute: 1,
            values: [3]
          }),
          byteAttribute: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.BYTE,
            componentsPerAttribute: 1,
            values: [4]
          }),
          shortAttribute: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.SHORT,
            componentsPerAttribute: 1,
            values: [5]
          })
        },
        primitiveType: import__29.PrimitiveType.POINTS
      });
      const attributeLocations = import__29.GeometryPipeline.createAttributeLocations(
        geometry
      );
      const va2 = import__29.VertexArray.fromGeometry({
        context,
        geometry,
        attributeLocations,
        interleave: true
      });
      expect(va2.numberOfAttributes).toEqual(4);
      expect(va2.getAttribute(0).vertexBuffer.sizeInBytes).toEqual(8);
      const vs = "in vec2 unsignedByteAttribute; in float unsignedShortAttribute; in float byteAttribute; in float shortAttribute; out vec4 fsColor; void main() {   gl_PointSize = 1.0;   gl_Position = vec4(0.0, 0.0, 0.0, 1.0);   fsColor = vec4((unsignedByteAttribute.x == 1.0) && (unsignedByteAttribute.y == 2.0) && (unsignedShortAttribute == 3.0) && (byteAttribute == 4.0) && (shortAttribute == 5.0)); }";
      const fs = "in vec4 fsColor; void main() {   out_FragColor = fsColor; }";
      sp = import__29.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations
      });
      import__29.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__29.DrawCommand({
        primitiveType: import__29.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va2
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("creates a custom interleaved vertex", function() {
      const geometry = new import__29.Geometry({
        attributes: {
          position: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0, 0, 0, 0]
          }),
          color: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.UNSIGNED_BYTE,
            componentsPerAttribute: 3,
            normalize: true,
            values: [255, 0, 0, 0, 255, 0]
          }),
          normal: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [1, 0, 0, 0, 1, 0]
          }),
          temperature: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.UNSIGNED_SHORT,
            componentsPerAttribute: 1,
            values: [75, 100]
          })
        },
        primitiveType: import__29.PrimitiveType.POINTS
      });
      const attributeLocations = import__29.GeometryPipeline.createAttributeLocations(
        geometry
      );
      const va2 = import__29.VertexArray.fromGeometry({
        context,
        geometry,
        attributeLocations,
        interleave: true
      });
      expect(va2.getAttribute(0).vertexBuffer.sizeInBytes).toEqual(2 * 32);
      const vs = "in vec3 position; in vec3 color; in vec3 normal; in float temperature; out vec4 fsColor; void main() {   gl_PointSize = 1.0;   gl_Position = vec4(position, 1.0);   if ((normal == vec3(1.0, 0.0, 0.0)) && (temperature == 75.0)) {     fsColor = vec4(color, 1.0);   }   else {    fsColor = vec4(1.0);   }}";
      const fs = "in vec4 fsColor; void main() {   out_FragColor = fsColor; }";
      sp = import__29.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations
      });
      import__29.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__29.DrawCommand({
        primitiveType: import__29.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va2,
        offset: 0,
        count: 1
      });
      command.execute(context);
      expect(context).toReadPixels([255, 0, 0, 255]);
      const vs2 = "in vec3 position; in vec3 color; in vec3 normal; in float temperature; out vec4 fsColor; void main() {   gl_PointSize = 1.0;   gl_Position = vec4(position, 1.0);   if ((normal == vec3(0.0, 1.0, 0.0)) && (temperature == 100.0)) {     fsColor = vec4(color, 1.0);   }   else {    fsColor = vec4(1.0);   }}";
      sp = sp.destroy();
      sp = import__29.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs2,
        fragmentShaderSource: fs,
        attributeLocations
      });
      command = new import__29.DrawCommand({
        primitiveType: import__29.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va2,
        offset: 1,
        count: 1
      });
      command.execute(context);
      expect(context).toReadPixels([0, 255, 0, 255]);
    });
    it("creates an index buffer", function() {
      const geometry = new import__29.Geometry({
        attributes: {},
        indices: [0],
        primitiveType: import__29.PrimitiveType.POINTS
      });
      const va2 = import__29.VertexArray.fromGeometry({
        context,
        geometry
      });
      expect(va2.numberOfAttributes).toEqual(0);
      expect(va2.indexBuffer).toBeDefined();
      expect(va2.indexBuffer.usage).toEqual(import__29.BufferUsage.DYNAMIC_DRAW);
      expect(va2.indexBuffer.indexDatatype).toEqual(
        import__29.IndexDatatype.UNSIGNED_SHORT
      );
      expect(va2.indexBuffer.numberOfIndices).toEqual(geometry.indices.length);
    });
    it("throws with different number of interleaved attributes", function() {
      const geometry = new import__29.Geometry({
        attributes: {
          position: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 1,
            values: [0]
          }),
          normal: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 1,
            values: [1, 2]
          })
        },
        primitiveType: import__29.PrimitiveType.POINTS
      });
      expect(function() {
        return import__29.VertexArray.fromGeometry({
          context,
          geometry,
          interleave: true
        });
      }).toThrowError(import__29.RuntimeError);
    });
    it("throws with duplicate indices", function() {
      const geometry = new import__29.Geometry({
        attributes: {
          position: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 1,
            values: [0]
          }),
          normal: new import__29.GeometryAttribute({
            componentDatatype: import__29.ComponentDatatype.FLOAT,
            componentsPerAttribute: 1,
            values: [1]
          })
        },
        primitiveType: import__29.PrimitiveType.POINTS
      });
      expect(function() {
        return import__29.VertexArray.fromGeometry({
          context,
          geometry,
          attributeLocations: {
            position: 0,
            normal: 0
          }
        });
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/VertexArraySpec.js
var import__30 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/VertexArray",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("binds", function() {
      const positionBuffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: 3,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const attributes = [
        {
          index: 0,
          enabled: true,
          vertexBuffer: positionBuffer,
          componentsPerAttribute: 3,
          componentDatatype: import__30.ComponentDatatype.FLOAT,
          normalize: false,
          offsetInBytes: 0,
          strideInBytes: 0,
          instanceDivisor: 0
          // tightly packed
        }
      ];
      let va = new import__30.VertexArray({
        context,
        attributes
      });
      va._bind();
      va._unBind();
      va = va.destroy();
    });
    it("binds with default values", function() {
      const positionBuffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: 3,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const attributes = [
        {
          vertexBuffer: positionBuffer,
          componentsPerAttribute: 3
        }
      ];
      let va = new import__30.VertexArray({
        context,
        attributes
      });
      expect(va.numberOfAttributes).toEqual(1);
      expect(va.getAttribute(0).index).toEqual(0);
      expect(va.getAttribute(0).enabled).toEqual(true);
      expect(va.getAttribute(0).vertexBuffer).toEqual(positionBuffer);
      expect(va.getAttribute(0).componentsPerAttribute).toEqual(3);
      expect(va.getAttribute(0).componentDatatype).toEqual(
        import__30.ComponentDatatype.FLOAT
      );
      expect(va.getAttribute(0).normalize).toEqual(false);
      expect(va.getAttribute(0).offsetInBytes).toEqual(0);
      expect(va.getAttribute(0).strideInBytes).toEqual(0);
      expect(va.getAttribute(0).instanceDivisor).toEqual(0);
      va._bind();
      va._unBind();
      va = va.destroy();
    });
    it("binds with multiple buffers", function() {
      const attributeSize = 3 * Float32Array.BYTES_PER_ELEMENT;
      const positionBuffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: attributeSize,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const normalBuffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: attributeSize,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const attributes = [
        {
          index: 0,
          vertexBuffer: positionBuffer,
          componentsPerAttribute: 3,
          componentDatatype: import__30.ComponentDatatype.FLOAT
        },
        {
          index: 1,
          vertexBuffer: normalBuffer,
          componentsPerAttribute: 3,
          componentDatatype: import__30.ComponentDatatype.FLOAT
        }
      ];
      let va = new import__30.VertexArray({
        context,
        attributes
      });
      expect(va.numberOfAttributes).toEqual(2);
      va._bind();
      va._unBind();
      va = va.destroy();
    });
    it("binds with interleaved buffer", function() {
      const attributeSize = 3 * Float32Array.BYTES_PER_ELEMENT;
      const buffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: attributeSize,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const attributes = [
        {
          vertexBuffer: buffer,
          componentsPerAttribute: 3,
          componentDatatype: import__30.ComponentDatatype.FLOAT,
          offsetInBytes: 0,
          strideInBytes: 2 * attributeSize
        },
        {
          vertexBuffer: buffer,
          componentsPerAttribute: 3,
          componentDatatype: import__30.ComponentDatatype.FLOAT,
          normalize: true,
          offsetInBytes: attributeSize,
          strideInBytes: 2 * attributeSize
        }
      ];
      let va = new import__30.VertexArray({
        context,
        attributes
      });
      expect(va.numberOfAttributes).toEqual(2);
      va._bind();
      va._unBind();
      va = va.destroy();
    });
    it("adds attributes", function() {
      const positionBuffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: 3,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      let va = new import__30.VertexArray({
        context,
        attributes: [
          {
            vertexBuffer: positionBuffer,
            componentsPerAttribute: 3
          }
        ]
      });
      expect(va.numberOfAttributes).toEqual(1);
      expect(va.getAttribute(0).index).toEqual(0);
      expect(va.getAttribute(0).enabled).toEqual(true);
      expect(va.getAttribute(0).vertexBuffer).toEqual(positionBuffer);
      expect(va.getAttribute(0).componentsPerAttribute).toEqual(3);
      expect(va.getAttribute(0).componentDatatype).toEqual(
        import__30.ComponentDatatype.FLOAT
      );
      expect(va.getAttribute(0).normalize).toEqual(false);
      expect(va.getAttribute(0).offsetInBytes).toEqual(0);
      expect(va.getAttribute(0).strideInBytes).toEqual(0);
      expect(va.getAttribute(0).instanceDivisor).toEqual(0);
      va = va.destroy();
    });
    it("modifies attributes", function() {
      const buffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: 6,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const attributes = [
        {
          vertexBuffer: buffer,
          componentsPerAttribute: 3
        }
      ];
      let va = new import__30.VertexArray({
        context,
        attributes
      });
      expect(va.numberOfAttributes).toEqual(1);
      expect(va.getAttribute(0).enabled).toEqual(true);
      va.getAttribute(0).enabled = false;
      expect(va.getAttribute(0).enabled).toEqual(false);
      va._bind();
      va._unBind();
      va = va.destroy();
    });
    it("renders with a one-component constant value", function() {
      const vs = "in float firefoxWorkaround;in float attr;out vec4 v_color;void main() {   v_color = vec4(attr == 0.5) + vec4(firefoxWorkaround);  gl_PointSize = 1.0;  gl_Position = vec4(0.0, 0.0, 0.0, 1.0);}";
      const fs = "in vec4 v_color;void main() { out_FragColor = v_color; }";
      let sp = import__30.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          firefoxWorkaround: 0,
          attr: 1
        }
      });
      let va = new import__30.VertexArray({
        context,
        attributes: [
          {
            vertexBuffer: import__30.Buffer.createVertexBuffer({
              context,
              sizeInBytes: Float32Array.BYTES_PER_ELEMENT,
              usage: import__30.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 1
          },
          {
            value: [0.5]
          }
        ]
      });
      const command = new import__30.DrawCommand({
        primitiveType: import__30.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        count: 1
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
      sp = sp.destroy();
      va = va.destroy();
    });
    it("renders with a two-component constant value", function() {
      const vs = "in float firefoxWorkaround;in vec2 attr;out vec4 v_color;void main() {   v_color = vec4(attr == vec2(0.25, 0.75)) + vec4(firefoxWorkaround);  gl_PointSize = 1.0;  gl_Position = vec4(0.0, 0.0, 0.0, 1.0);}";
      const fs = "in vec4 v_color;void main() { out_FragColor = v_color; }";
      let sp = import__30.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          firefoxWorkaround: 0,
          attr: 1
        }
      });
      let va = new import__30.VertexArray({
        context,
        attributes: [
          {
            vertexBuffer: import__30.Buffer.createVertexBuffer({
              context,
              sizeInBytes: Float32Array.BYTES_PER_ELEMENT,
              usage: import__30.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 1
          },
          {
            value: [0.25, 0.75]
          }
        ]
      });
      const command = new import__30.DrawCommand({
        primitiveType: import__30.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        count: 1
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
      sp = sp.destroy();
      va = va.destroy();
    });
    it("renders with a three-component constant value", function() {
      const vs = "in float firefoxWorkaround;in vec3 attr;out vec4 v_color;void main() {   v_color = vec4(attr == vec3(0.25, 0.5, 0.75)) + vec4(firefoxWorkaround);  gl_PointSize = 1.0;  gl_Position = vec4(0.0, 0.0, 0.0, 1.0);}";
      const fs = "in vec4 v_color;void main() { out_FragColor = v_color; }";
      let sp = import__30.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          firefoxWorkaround: 0,
          attr: 1
        }
      });
      let va = new import__30.VertexArray({
        context,
        attributes: [
          {
            vertexBuffer: import__30.Buffer.createVertexBuffer({
              context,
              sizeInBytes: Float32Array.BYTES_PER_ELEMENT,
              usage: import__30.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 1
          },
          {
            value: [0.25, 0.5, 0.75]
          }
        ]
      });
      const command = new import__30.DrawCommand({
        primitiveType: import__30.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        count: 1
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
      sp = sp.destroy();
      va = va.destroy();
    });
    it("renders with a four-component constant value", function() {
      const vs = "in float firefoxWorkaround;in vec4 attr;out vec4 v_color;void main() {   v_color = vec4(attr == vec4(0.2, 0.4, 0.6, 0.8)) + vec4(firefoxWorkaround);  gl_PointSize = 1.0;  gl_Position = vec4(0.0, 0.0, 0.0, 1.0);}";
      const fs = "in vec4 v_color;void main() { out_FragColor = v_color; }";
      let sp = import__30.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          firefoxWorkaround: 0,
          attr: 1
        }
      });
      let va = new import__30.VertexArray({
        context,
        attributes: [
          {
            vertexBuffer: import__30.Buffer.createVertexBuffer({
              context,
              sizeInBytes: Float32Array.BYTES_PER_ELEMENT,
              usage: import__30.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 1
          },
          {
            value: [0.2, 0.4, 0.6, 0.8]
          }
        ]
      });
      const command = new import__30.DrawCommand({
        primitiveType: import__30.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        count: 1
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
      sp = sp.destroy();
      va = va.destroy();
    });
    it("renders two vertex arrays with constant values", function() {
      const vs = "in float firefoxWorkaround;in vec4 attr;out vec4 v_color;void main() {   v_color = attr + vec4(firefoxWorkaround);  gl_PointSize = 1.0;  gl_Position = vec4(0.0, 0.0, 0.0, 1.0);}";
      const fs = "in vec4 v_color;void main() { out_FragColor = v_color; }";
      let sp = import__30.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          firefoxWorkaround: 0,
          attr: 1
        }
      });
      const vertexBuffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: Float32Array.BYTES_PER_ELEMENT,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      let vaRed = new import__30.VertexArray({
        context,
        attributes: [
          {
            vertexBuffer,
            componentsPerAttribute: 1
          },
          {
            value: [1, 0, 0, 1]
          }
        ]
      });
      let vaGreen = new import__30.VertexArray({
        context,
        attributes: [
          {
            vertexBuffer,
            componentsPerAttribute: 1
          },
          {
            value: [0, 1, 0, 1]
          }
        ]
      });
      const commandRed = new import__30.DrawCommand({
        primitiveType: import__30.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: vaRed,
        count: 1
      });
      const commandGreen = new import__30.DrawCommand({
        primitiveType: import__30.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: vaGreen,
        count: 1
      });
      commandRed.execute(context);
      expect(context).toReadPixels([255, 0, 0, 255]);
      commandGreen.execute(context);
      expect(context).toReadPixels([0, 255, 0, 255]);
      sp = sp.destroy();
      vaRed = vaRed.destroy();
      vaGreen = vaGreen.destroy();
    });
    it("destroys", function() {
      const va = new import__30.VertexArray({
        context,
        attributes: [
          {
            vertexBuffer: import__30.Buffer.createVertexBuffer({
              context,
              sizeInBytes: new Float32Array([0, 0, 0, 1]).byteLength,
              usage: import__30.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      expect(va.isDestroyed()).toEqual(false);
      va.destroy();
      expect(va.isDestroyed()).toEqual(true);
    });
    it("fails to create (missing vertexBuffer and value)", function() {
      const attributes = [
        {
          componentsPerAttribute: 3
        }
      ];
      expect(function() {
        return new import__30.VertexArray({
          context,
          attributes
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (provides both vertexBuffer and value)", function() {
      const buffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: 3,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const attributes = [
        {
          vertexBuffer: buffer,
          value: [1, 2, 3],
          componentsPerAttribute: 3
        }
      ];
      expect(function() {
        return new import__30.VertexArray({
          context,
          attributes
        });
      }).toThrowDeveloperError();
    });
    it("fails to create with duplicate indices", function() {
      const buffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: 1,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const attributes = [
        {
          index: 1,
          vertexBuffer: buffer,
          componentsPerAttribute: 1
        },
        {
          index: 1,
          vertexBuffer: buffer,
          componentsPerAttribute: 1
        }
      ];
      expect(function() {
        return new import__30.VertexArray({
          context,
          attributes
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (componentsPerAttribute missing)", function() {
      const buffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: 3,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const attributes = [
        {
          vertexBuffer: buffer
        }
      ];
      expect(function() {
        return new import__30.VertexArray({
          context,
          attributes
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (componentsPerAttribute < 1)", function() {
      const attributes = [
        {
          componentsPerAttribute: 0
        }
      ];
      expect(function() {
        return new import__30.VertexArray({
          context,
          attributes
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (componentsPerAttribute > 4)", function() {
      const attributes = [
        {
          componentsPerAttribute: 5
        }
      ];
      expect(function() {
        return new import__30.VertexArray({
          context,
          attributes
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (value.length < 1)", function() {
      const attributes = [
        {
          value: []
        }
      ];
      expect(function() {
        return new import__30.VertexArray({
          context,
          attributes
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (value.length > 4)", function() {
      const attributes = [
        {
          value: [1, 2, 3, 4, 5]
        }
      ];
      expect(function() {
        return new import__30.VertexArray({
          context,
          attributes
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (componentDatatype)", function() {
      const buffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: 3,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const attributes = [
        {
          vertexBuffer: buffer,
          componentsPerAttribute: 3,
          componentDatatype: "invalid component datatype"
        }
      ];
      expect(function() {
        return new import__30.VertexArray({
          context,
          attributes
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (strideInBytes)", function() {
      const buffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: 3,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const attributes = [
        {
          vertexBuffer: buffer,
          componentsPerAttribute: 3,
          strideInBytes: 256
        }
      ];
      expect(function() {
        return new import__30.VertexArray({
          context,
          attributes
        });
      }).toThrowDeveloperError();
    });
    it("fails to get attribute", function() {
      const attributes = [
        {
          value: [0, 0, 0],
          componentsPerAttribute: 3
        }
      ];
      const va = new import__30.VertexArray({
        context,
        attributes
      });
      expect(function() {
        return va.getAttribute();
      }).toThrowDeveloperError();
    });
    it("fails to destroy", function() {
      const attributes = [
        {
          value: [0, 0, 0],
          componentsPerAttribute: 3
        }
      ];
      const va = new import__30.VertexArray({
        context,
        attributes
      });
      va.destroy();
      expect(function() {
        va.destroy();
      }).toThrowDeveloperError();
    });
    it("throws when there is no context", function() {
      expect(function() {
        return new import__30.VertexArray();
      }).toThrowDeveloperError();
    });
    it("throws if instanceDivisor is less than zero", function() {
      const buffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: 3,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const attributes = [
        {
          vertexBuffer: buffer,
          componentsPerAttribute: 3,
          instanceDivisor: -1
        }
      ];
      expect(function() {
        return new import__30.VertexArray({
          context,
          attributes
        });
      }).toThrowDeveloperError();
    });
    it("throws if vertex attribute zero is instanced", function() {
      const buffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: 3,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const attributes = [
        {
          index: 0,
          vertexBuffer: buffer,
          componentsPerAttribute: 3,
          instanceDivisor: 1
        },
        {
          index: 1,
          vertexBuffer: buffer,
          componentsPerAttribute: 3
        }
      ];
      expect(function() {
        return new import__30.VertexArray({
          context,
          attributes
        });
      }).toThrowDeveloperError();
    });
    it("throws if an attribute has an instanceDivisor and is not backed by a buffer", function() {
      const buffer = import__30.Buffer.createVertexBuffer({
        context,
        sizeInBytes: 3,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const attributes = [
        {
          index: 0,
          vertexBuffer: buffer,
          componentsPerAttribute: 3
        },
        {
          index: 1,
          value: [0, 0, 1],
          componentsPerAttribute: 3,
          instanceDivisor: 1
        }
      ];
      expect(function() {
        return new import__30.VertexArray({
          context,
          attributes
        });
      }).toThrowDeveloperError();
    });
    it("throws when instanceDivisor is greater than zero and instancing is disabled", function() {
      const contextWithoutInstancing = createContext_default({
        requestWebgl1: true
      });
      contextWithoutInstancing._instancedArrays = void 0;
      const buffer = import__30.Buffer.createVertexBuffer({
        context: contextWithoutInstancing,
        sizeInBytes: 3,
        usage: import__30.BufferUsage.STATIC_DRAW
      });
      const attributes = [
        {
          index: 0,
          vertexBuffer: buffer,
          componentsPerAttribute: 3
        },
        {
          index: 1,
          vertexBuffer: buffer,
          componentsPerAttribute: 3,
          instanceDivisor: 1
        }
      ];
      expect(function() {
        return new import__30.VertexArray({
          context: contextWithoutInstancing,
          attributes
        });
      }).toThrowDeveloperError();
      contextWithoutInstancing.destroyForSpecs();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/demodernizeShaderSpec.js
var import__31 = __toESM(require_Cesium(), 1);
describe("Renderer/demodernizeShader", () => {
  it("replaces version", () => {
    const input = `#version 300 es
    void main() {}
    `;
    const output = (0, import__31.demodernizeShader)(input, false);
    const expectedVersion = "#version 100";
    expect(output.startsWith(expectedVersion)).toEqual(true);
  });
  it("replaces out_FragData with gl_FragData", () => {
    const input = `#version 300 es
    layout (location = 0) vec4 out_FragData_0;
    layout (location = 1) vec4 out_FragData_1;
    layout (location = 10) vec4 out_FragData_10;
    layout (location = 11) vec4 out_FragData_11;
    
    void main() {
      out_FragData_0 = vec4(0.0);
      out_FragData_1 = vec4(1.0);
      out_FragData_10 = vec4(0.0, 0.0, 0.0, 0.0);
      out_FragData_11 = vec4(1.0, 2.0, 3.0, 4.0);
    }
    `;
    const output = (0, import__31.demodernizeShader)(input, true);
    const expectedVersion = "#version 100";
    expect(output.startsWith(expectedVersion)).toEqual(true);
    expect(output).not.toContain("layout (location = 0) vec4 out_FragData_0");
    expect(output).not.toContain("layout (location = 1) vec4 out_FragData_1");
    expect(output).not.toContain("layout (location = 10) vec4 out_FragData_10");
    expect(output).not.toContain("layout (location = 11) vec4 out_FragData_11");
    expect(output).toContain("gl_FragData[0] = vec4(0.0);");
    expect(output).toContain("gl_FragData[1] = vec4(1.0);");
    expect(output).toContain("gl_FragData[10] = vec4(0.0, 0.0, 0.0, 0.0);");
    expect(output).toContain("gl_FragData[11] = vec4(1.0, 2.0, 3.0, 4.0);");
  });
  it("replaces out_FragColor with gl_FragColor", () => {
    const input = `#version 300 es
    layout (location = 0) vec4 out_FragColor;
    
    void main() {
      out_FragColor = vec4(1.0);
      out_FragColor[0] = 0.0;
      out_FragColor[2] = 2.0;
    }
    `;
    const output = (0, import__31.demodernizeShader)(input, true);
    const expectedVersion = "#version 100";
    expect(output.startsWith(expectedVersion)).toEqual(true);
    expect(output).not.toContain("layout (location = 0) vec4 out_FragColor");
    expect(output).toContain("gl_FragColor = vec4(1.0);");
    expect(output).toContain("gl_FragColor[0] = 0.0;");
    expect(output).toContain("gl_FragColor[2] = 2.0;");
  });
  it("replaces texture with texture2D", () => {
    const input = `#version 300 es
    uniform sampler2D u_texture;
    void main() {
      vec4 tex = texture(u_texture, vec2(0.0));
    }
    `;
    const output = (0, import__31.demodernizeShader)(input, false);
    const expectedVersion = "#version 100";
    expect(output.startsWith(expectedVersion)).toEqual(true);
    expect(output).toContain("vec4 tex = texture2D(u_texture, vec2(0.0));");
  });
  it("replaces in with attribute in vertex shader", () => {
    const input = `#version 300 es
    in float a_float;
    in vec3 a_vec3;
    in mat2 a_mat2;
    void main() {}
    `;
    const output = (0, import__31.demodernizeShader)(input, false);
    const expectedVersion = "#version 100";
    expect(output.startsWith(expectedVersion)).toEqual(true);
    expect(output).toContain("attribute float a_float;");
    expect(output).toContain("attribute vec3 a_vec3;");
    expect(output).toContain("attribute mat2 a_mat2;");
  });
  it("replaces in with varying in fragment shader", () => {
    const input = `#version 300 es
    in float a_float;
    in vec3 a_vec3;
    in mat2 a_mat2;
    void main() {}
    `;
    const output = (0, import__31.demodernizeShader)(input, true);
    const expectedVersion = "#version 100";
    expect(output.startsWith(expectedVersion)).toEqual(true);
    expect(output).toContain("varying float a_float;");
    expect(output).toContain("varying vec3 a_vec3;");
    expect(output).toContain("varying mat2 a_mat2;");
  });
  it("replaces out with varying in vertex shader", () => {
    const input = `#version 300 es
    out float a_float;
    out vec3 a_vec3;
    out mat2 a_mat2;
    void main() {}
    `;
    const output = (0, import__31.demodernizeShader)(input, false);
    const expectedVersion = "#version 100";
    expect(output.startsWith(expectedVersion)).toEqual(true);
    expect(output).toContain("varying float a_float;");
    expect(output).toContain("varying vec3 a_vec3;");
    expect(output).toContain("varying mat2 a_mat2;");
  });
  it("replaces gl_FragDepth with gl_FragDepthEXT", () => {
    const input = `#version 300 es
    void main() {
      gl_FragDepth = vec4(1.0);
      gl_FragDepth += vec4(2.0);
    }
    `;
    const output = (0, import__31.demodernizeShader)(input, true);
    const expectedVersion = "#version 100";
    expect(output.startsWith(expectedVersion)).toEqual(true);
    expect(output).toContain("#extension GL_EXT_frag_depth : enable");
    expect(output).toContain("gl_FragDepthEXT = vec4(1.0);");
    expect(output).toContain("gl_FragDepthEXT += vec4(2.0);");
  });
});

// packages/engine/Specs/Renderer/freezeRenderStateSpec.js
var import__32 = __toESM(require_Cesium(), 1);
describe("Renderer/freezeRenderState", function() {
  it("works as expected", function() {
    const fresh = {
      a: 1,
      b: {
        c: "c"
      },
      _applyFunctions: [function() {
      }]
    };
    const frozen = (0, import__32.freezeRenderState)(fresh);
    expect(Object.isFrozen(frozen)).toBe(true);
    expect(Object.isFrozen(frozen.a)).toBe(true);
    expect(Object.isFrozen(frozen.b)).toBe(true);
    expect(Object.isFrozen(frozen.c)).toBe(true);
    expect(Object.isFrozen(frozen._applyFunctions)).toBe(false);
  });
});

// packages/engine/Specs/Renderer/loadCubeMapSpec.js
var import__33 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/loadCubeMap",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("loads a cube map", function() {
      return (0, import__33.loadCubeMap)(context, {
        positiveX: "./Data/Images/Green.png",
        negativeX: "./Data/Images/Blue.png",
        positiveY: "./Data/Images/Green.png",
        negativeY: "./Data/Images/Blue.png",
        positiveZ: "./Data/Images/Green.png",
        negativeZ: "./Data/Images/Blue.png"
      }).then(function(cm) {
        expect(cm.width).toEqual(1);
        expect(cm.height).toEqual(1);
        const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
        const fs = "uniform samplerCube u_texture;uniform mediump vec3 u_direction;void main() { out_FragColor = czm_textureCube(u_texture, normalize(u_direction)); }";
        const sp = import__33.ShaderProgram.fromCache({
          context,
          vertexShaderSource: vs,
          fragmentShaderSource: fs,
          attributeLocations: {
            position: 0
          }
        });
        const uniformMap = {
          direction: void 0,
          u_texture: function() {
            return cm;
          },
          u_direction: function() {
            return this.direction;
          }
        };
        const va = new import__33.VertexArray({
          context,
          attributes: [
            {
              vertexBuffer: import__33.Buffer.createVertexBuffer({
                context,
                typedArray: new Float32Array([0, 0, 0, 1]),
                usage: import__33.BufferUsage.STATIC_DRAW
              }),
              componentsPerAttribute: 4
            }
          ]
        });
        const command = new import__33.DrawCommand({
          primitiveType: import__33.PrimitiveType.POINTS,
          shaderProgram: sp,
          vertexArray: va,
          uniformMap
        });
        uniformMap.direction = new import__33.Cartesian3(1, 0, 0);
        command.execute(context);
        expect(context).toReadPixels([0, 255, 0, 255]);
        uniformMap.direction = new import__33.Cartesian3(-1, 0, 0);
        command.execute(context);
        expect(context).toReadPixels([0, 0, 255, 255]);
        uniformMap.direction = new import__33.Cartesian3(0, 1, 0);
        command.execute(context);
        expect(context).toReadPixels([0, 255, 0, 255]);
        uniformMap.direction = new import__33.Cartesian3(0, -1, 0);
        command.execute(context);
        expect(context).toReadPixels([0, 0, 255, 255]);
        uniformMap.direction = new import__33.Cartesian3(0, 0, 1);
        command.execute(context);
        expect(context).toReadPixels([0, 255, 0, 255]);
        uniformMap.direction = new import__33.Cartesian3(0, 0, -1);
        command.execute(context);
        expect(context).toReadPixels([0, 0, 255, 255]);
        sp.destroy();
        va.destroy();
        cm.destroy();
      });
    });
    it("calls error function when positiveX does not exist", function() {
      return (0, import__33.loadCubeMap)(context, {
        positiveX: "not.found",
        negativeX: "./Data/Images/Blue.png",
        positiveY: "./Data/Images/Blue.png",
        negativeY: "./Data/Images/Blue.png",
        positiveZ: "./Data/Images/Blue.png",
        negativeZ: "./Data/Images/Blue.png"
      }).then(function(cubeMap) {
        fail("should not be called");
      }).catch(function() {
      });
    });
    it("calls error function when negativeX does not exist", function() {
      return (0, import__33.loadCubeMap)(context, {
        positiveX: "./Data/Images/Blue.png",
        negativeX: "not.found",
        positiveY: "./Data/Images/Blue.png",
        negativeY: "./Data/Images/Blue.png",
        positiveZ: "./Data/Images/Blue.png",
        negativeZ: "./Data/Images/Blue.png"
      }).then(function(cubeMap) {
        fail("should not be called");
      }).catch(function() {
      });
    });
    it("calls error function when positiveY does not exist", function() {
      return (0, import__33.loadCubeMap)(context, {
        positiveX: "./Data/Images/Blue.png",
        negativeX: "./Data/Images/Blue.png",
        positiveY: "not.found",
        negativeY: "./Data/Images/Blue.png",
        positiveZ: "./Data/Images/Blue.png",
        negativeZ: "./Data/Images/Blue.png"
      }).then(function(cubeMap) {
        fail("should not be called");
      }).catch(function() {
      });
    });
    it("calls error function when negativeY does not exist", function() {
      return (0, import__33.loadCubeMap)(context, {
        positiveX: "./Data/Images/Blue.png",
        negativeX: "./Data/Images/Blue.png",
        positiveY: "./Data/Images/Blue.png",
        negativeY: "not.found",
        positiveZ: "./Data/Images/Blue.png",
        negativeZ: "./Data/Images/Blue.png"
      }).then(function(cubeMap) {
        fail("should not be called");
      }).catch(function() {
      });
    });
    it("calls error function when positiveZ does not exist", function() {
      return (0, import__33.loadCubeMap)(context, {
        positiveX: "./Data/Images/Blue.png",
        negativeX: "./Data/Images/Blue.png",
        positiveY: "./Data/Images/Blue.png",
        negativeY: "./Data/Images/Blue.png",
        positiveZ: "not.found",
        negativeZ: "./Data/Images/Blue.png"
      }).then(function(cubeMap) {
        fail("should not be called");
      }).catch(function() {
      });
    });
    it("calls error function when negativeZ does not exist", function() {
      return (0, import__33.loadCubeMap)(context, {
        positiveX: "./Data/Images/Blue.png",
        negativeX: "./Data/Images/Blue.png",
        positiveY: "./Data/Images/Blue.png",
        negativeY: "./Data/Images/Blue.png",
        positiveZ: "./Data/Images/Blue.png",
        negativeZ: "not.found"
      }).then(function(cubeMap) {
        fail("should not be called");
      }).catch(function() {
      });
    });
    it("throws without a context", function() {
      expect(function() {
        (0, import__33.loadCubeMap)(void 0);
      }).toThrowDeveloperError();
    });
    it("throws without urls", function() {
      expect(function() {
        (0, import__33.loadCubeMap)(context);
      }).toThrowDeveloperError();
    });
    it("throws without positiveX", function() {
      expect(function() {
        (0, import__33.loadCubeMap)(context, {
          negativeX: "any.image",
          positiveY: "any.image",
          negativeY: "any.image",
          positiveZ: "any.image",
          negativeZ: "any.image"
        });
      }).toThrowDeveloperError();
    });
    it("throws without negativeX", function() {
      expect(function() {
        (0, import__33.loadCubeMap)(context, {
          positiveX: "any.image",
          positiveY: "any.image",
          negativeY: "any.image",
          positiveZ: "any.image",
          negativeZ: "any.image"
        });
      }).toThrowDeveloperError();
    });
    it("throws without positiveY", function() {
      expect(function() {
        (0, import__33.loadCubeMap)(context, {
          positiveX: "any.image",
          negativeX: "any.image",
          negativeY: "any.image",
          positiveZ: "any.image",
          negativeZ: "any.image"
        });
      }).toThrowDeveloperError();
    });
    it("throws without negativeY", function() {
      expect(function() {
        (0, import__33.loadCubeMap)(context, {
          positiveX: "any.image",
          negativeX: "any.image",
          positiveY: "any.image",
          positiveZ: "any.image",
          negativeZ: "any.image"
        });
      }).toThrowDeveloperError();
    });
    it("throws without positiveZ", function() {
      expect(function() {
        (0, import__33.loadCubeMap)(context, {
          positiveX: "any.image",
          negativeX: "any.image",
          positiveY: "any.image",
          negativeY: "any.image",
          negativeZ: "any.image"
        });
      }).toThrowDeveloperError();
    });
    it("throws without negativeZ", function() {
      expect(function() {
        (0, import__33.loadCubeMap)(context, {
          positiveX: "any.image",
          negativeX: "any.image",
          positiveY: "any.image",
          negativeY: "any.image",
          positiveZ: "any.image"
        });
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Core/ApproximateTerrainHeightsSpec.js
var import__34 = __toESM(require_Cesium(), 1);
describe("Core/ApproximateTerrainHeights", function() {
  beforeAll(function() {
    return import__34.ApproximateTerrainHeights.initialize();
  });
  afterAll(function() {
    import__34.ApproximateTerrainHeights._initPromise = void 0;
    import__34.ApproximateTerrainHeights._terrainHeights = void 0;
  });
  it("initializes", function() {
    return import__34.ApproximateTerrainHeights.initialize().then(function() {
      expect(import__34.ApproximateTerrainHeights._terrainHeights).toBeDefined();
    });
  });
  it("getMinimumMaximumHeights computes minimum and maximum terrain heights", function() {
    const result = import__34.ApproximateTerrainHeights.getMinimumMaximumHeights(
      import__34.Rectangle.fromDegrees(-121, 10, -120, 11)
    );
    expect(result.minimumTerrainHeight).toEqualEpsilon(
      -476.12571188755,
      import__34.Math.EPSILON8
    );
    expect(result.maximumTerrainHeight).toEqualEpsilon(
      -28.53,
      import__34.Math.EPSILON8
    );
  });
  it("getMinimumMaximumHeights throws with no rectangle", function() {
    expect(function() {
      return import__34.ApproximateTerrainHeights.getMinimumMaximumHeights();
    }).toThrowDeveloperError();
  });
  it("getMinimumMaximumHeights throws if ApproximateTerrainHeights was not initialized first", function() {
    const heights = import__34.ApproximateTerrainHeights._terrainHeights;
    import__34.ApproximateTerrainHeights._terrainHeights = void 0;
    expect(function() {
      return import__34.ApproximateTerrainHeights.getMinimumMaximumHeights(
        import__34.Rectangle.fromDegrees(-121, 10, -120, 11)
      );
    });
    import__34.ApproximateTerrainHeights._terrainHeights = heights;
  });
  it("getBoundingSphere computes a bounding sphere", function() {
    const result = import__34.ApproximateTerrainHeights.getBoundingSphere(
      import__34.Rectangle.fromDegrees(-121, 10, -120, 11)
    );
    expect(result.center).toEqualEpsilon(
      new import__34.Cartesian3(
        -3183013849117281e-9,
        -5403772559109628e-9,
        1.1545815821590829e6
      ),
      import__34.Math.EPSILON8
    );
    expect(result.radius).toEqualEpsilon(
      77884.16321007285,
      import__34.Math.EPSILON8
    );
  });
  it("getBoundingSphere throws with no rectangle", function() {
    expect(function() {
      return import__34.ApproximateTerrainHeights.getBoundingSphere();
    }).toThrowDeveloperError();
  });
  it("getBoundingSphere throws if ApproximateTerrainHeights was not initialized first", function() {
    const heights = import__34.ApproximateTerrainHeights._terrainHeights;
    import__34.ApproximateTerrainHeights._terrainHeights = void 0;
    expect(function() {
      return import__34.ApproximateTerrainHeights.getBoundingSphere(
        import__34.Rectangle.fromDegrees(-121, 10, -120, 11)
      );
    });
    import__34.ApproximateTerrainHeights._terrainHeights = heights;
  });
});

// packages/engine/Specs/Core/ArcGISTiledElevationTerrainProviderSpec.js
var import__35 = __toESM(require_Cesium(), 1);

// Specs/pollToPromise.js
var import_engine7 = __toESM(require_Cesium(), 1);
function pollToPromise(f, options) {
  options = (0, import_engine7.defaultValue)(options, import_engine7.defaultValue.EMPTY_OBJECT);
  const pollInterval = (0, import_engine7.defaultValue)(options.pollInterval, 1);
  const timeout = (0, import_engine7.defaultValue)(options.timeout, 5e3);
  return new Promise(function(resolve, reject) {
    const startTimestamp = (0, import_engine7.getTimestamp)();
    const endTimestamp = startTimestamp + timeout;
    function poller() {
      let result = false;
      try {
        result = f();
      } catch (e) {
        reject(e);
        return;
      }
      if (result) {
        resolve();
      } else if ((0, import_engine7.getTimestamp)() > endTimestamp) {
        reject(
          new Error(`Timeout - function did not complete within ${timeout}ms`)
        );
      } else {
        setTimeout(poller, pollInterval);
      }
    }
    poller();
  });
}
var pollToPromise_default = pollToPromise;

// packages/engine/Specs/Core/ArcGISTiledElevationTerrainProviderSpec.js
describe("Core/ArcGISTiledElevationTerrainProvider", function() {
  const lercTileUrl = "Data/Images/Red16x16.png";
  let availability;
  let metadata;
  beforeEach(function() {
    availability = {
      data: []
    };
    availability.data.length = 128 * 128;
    availability.data.fill(1);
    metadata = {
      currentVersion: 10.3,
      serviceDescription: "Test",
      name: "Test",
      description: "Test",
      extent: {
        xmin: -20037507842788246e-9,
        ymin: -20037508659999996e-9,
        xmax: 20037509157211754e-9,
        ymax: 20037508340000004e-9,
        spatialReference: {
          wkid: 102100,
          latestWkid: 3857
        }
      },
      bandCount: 1,
      copyrightText: "Source: USGS, NGA, NASA, CGIAR, GEBCO,N Robinson,NCEAS,NLS,OS,NMA,Geodatastyrelsen and the GIS User Community",
      minValues: [-450],
      maxValues: [8700],
      capabilities: "Image,Tilemap,Mensuration",
      tileInfo: {
        rows: 256,
        cols: 256,
        format: "LERC",
        lods: [
          {
            level: 0,
            resolution: 156543.03392800014,
            scale: 591657527591555e-6
          },
          {
            level: 1,
            resolution: 78271.51696399994,
            scale: 295828763795777e-6
          },
          {
            level: 2,
            resolution: 39135.75848200009,
            scale: 147914381897889e-6
          },
          {
            level: 3,
            resolution: 19567.87924099992,
            scale: 73957190948944e-6
          },
          {
            level: 4,
            resolution: 9783.93962049996,
            scale: 36978595474472e-6
          },
          {
            level: 5,
            resolution: 4891.96981024998,
            scale: 18489297737236e-6
          },
          {
            level: 6,
            resolution: 2445.98490512499,
            scale: 9244648868618e-6
          },
          {
            level: 7,
            resolution: 1222.992452562495,
            scale: 4622324434309e-6
          },
          {
            level: 8,
            resolution: 611.4962262813797,
            scale: 2311162217155e-6
          },
          {
            level: 9,
            resolution: 305.74811314055756,
            scale: 1155581108577e-6
          },
          {
            level: 10,
            resolution: 152.87405657041106,
            scale: 577790.554289
          },
          {
            level: 11,
            resolution: 76.43702828507324,
            scale: 288895.277144
          },
          {
            level: 12,
            resolution: 38.21851414253662,
            scale: 144447.638572
          },
          {
            level: 13,
            resolution: 19.10925707126831,
            scale: 72223.819286
          },
          {
            level: 14,
            resolution: 9.554628535634155,
            scale: 36111.909643
          },
          {
            level: 15,
            resolution: 4.77731426794937,
            scale: 18055.954822
          },
          {
            level: 16,
            resolution: 2.388657133974685,
            scale: 9027.977411
          }
        ]
      },
      spatialReference: {
        wkid: 3857,
        latestWkid: 3857
      }
    };
    import__35.RequestScheduler.clearForSpecs();
    import__35.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
      if (url.indexOf("/tile/") !== -1) {
        import__35.Resource._DefaultImplementations.loadWithXhr(
          lercTileUrl,
          responseType,
          method,
          data,
          headers,
          deferred,
          overrideMimeType
        );
        return;
      }
      if (url.indexOf("/tilemap/") !== -1) {
        setTimeout(function() {
          deferred.resolve(JSON.stringify(availability));
        }, 1);
        return;
      }
      setTimeout(function() {
        deferred.resolve(JSON.stringify(metadata));
      }, 1);
    };
  });
  afterEach(function() {
    import__35.Resource._Implementations.createImage = import__35.Resource._DefaultImplementations.createImage;
    import__35.Resource._Implementations.loadWithXhr = import__35.Resource._DefaultImplementations.loadWithXhr;
  });
  function createRequest() {
    return new import__35.Request({
      throttleByServer: true
    });
  }
  it("conforms to TerrainProvider interface", function() {
    expect(import__35.ArcGISTiledElevationTerrainProvider).toConformToInterface(
      import__35.TerrainProvider
    );
  });
  it("constructor throws if url is not provided", function() {
    expect(function() {
      return new import__35.ArcGISTiledElevationTerrainProvider();
    }).toThrowDeveloperError();
    expect(function() {
      return new import__35.ArcGISTiledElevationTerrainProvider({});
    }).toThrowDeveloperError();
  });
  it("resolves readyPromise", function() {
    const provider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: "made/up/url"
    });
    return provider.readyPromise.then(function(result) {
      expect(result).toBe(true);
      expect(provider.ready).toBe(true);
    });
  });
  it("resolves readyPromise with Resource", function() {
    const resource = new import__35.Resource({
      url: "made/up/url"
    });
    const provider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: resource
    });
    return provider.readyPromise.then(function(result) {
      expect(result).toBe(true);
      expect(provider.ready).toBe(true);
    });
  });
  it("has error event", function() {
    const provider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: "made/up/url"
    });
    expect(provider.errorEvent).toBeDefined();
    expect(provider.errorEvent).toBe(provider.errorEvent);
    return provider.readyPromise;
  });
  it("returns reasonable geometric error for various levels", function() {
    const provider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: "made/up/url"
    });
    return pollToPromise_default(function() {
      return provider.ready;
    }).then(function() {
      expect(provider.getLevelMaximumGeometricError(0)).toBeGreaterThan(0);
      expect(provider.getLevelMaximumGeometricError(0)).toEqualEpsilon(
        provider.getLevelMaximumGeometricError(1) * 2,
        import__35.Math.EPSILON10
      );
      expect(provider.getLevelMaximumGeometricError(1)).toEqualEpsilon(
        provider.getLevelMaximumGeometricError(2) * 2,
        import__35.Math.EPSILON10
      );
    });
  });
  it("getLevelMaximumGeometricError must not be called before isReady returns true", function() {
    const provider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: "made/up/url"
    });
    expect(function() {
      provider.getLevelMaximumGeometricError(0);
    }).toThrowDeveloperError();
    return provider.readyPromise;
  });
  it("getTilingScheme must not be called before isReady returns true", function() {
    const provider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: "made/up/url"
    });
    expect(function() {
      return provider.tilingScheme;
    }).toThrowDeveloperError();
    return provider.readyPromise;
  });
  it("logo is undefined if credit is not provided", function() {
    delete metadata.copyrightText;
    const provider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: "made/up/url"
    });
    return pollToPromise_default(function() {
      return provider.ready;
    }).then(function() {
      expect(provider.credit).toBeUndefined();
    });
  });
  it("logo is defined if credit is provided", function() {
    const provider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: "made/up/url",
      credit: "thanks to our awesome made up contributors!"
    });
    return pollToPromise_default(function() {
      return provider.ready;
    }).then(function() {
      expect(provider.credit).toBeDefined();
    });
  });
  it("does not have a water mask", function() {
    const provider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: "made/up/url"
    });
    expect(provider.hasWaterMask).toBe(false);
    return provider.readyPromise.catch(function(error) {
      expect(error).toBeInstanceOf(import__35.RuntimeError);
    });
  });
  it("is not ready immediately", function() {
    const provider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: "made/up/url"
    });
    expect(provider.ready).toBe(false);
    return provider.readyPromise.catch(function(error) {
      expect(error).toBeInstanceOf(import__35.RuntimeError);
    });
  });
  it("detects WebMercator tiling scheme", function() {
    const baseUrl = "made/up/url";
    const terrainProvider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: baseUrl
    });
    return pollToPromise_default(function() {
      return terrainProvider.ready;
    }).then(function() {
      expect(terrainProvider.tilingScheme).toBeInstanceOf(
        import__35.WebMercatorTilingScheme
      );
    });
  });
  it("detects Geographic tiling scheme", function() {
    const baseUrl = "made/up/url";
    metadata.spatialReference.latestWkid = 4326;
    const terrainProvider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: baseUrl
    });
    return pollToPromise_default(function() {
      return terrainProvider.ready;
    }).then(function() {
      expect(terrainProvider.tilingScheme).toBeInstanceOf(
        import__35.GeographicTilingScheme
      );
    });
  });
  it("raises an error if the SRS is not supported", function() {
    const baseUrl = "made/up/url";
    metadata.spatialReference.latestWkid = 1234;
    const terrainProvider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: baseUrl
    });
    return terrainProvider.readyPromise.then(fail).catch(function(error) {
      expect(error).toBeInstanceOf(import__35.RuntimeError);
    });
  });
  it("raises an error if tileInfo missing", function() {
    const baseUrl = "made/up/url";
    delete metadata.tileInfo;
    const terrainProvider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: baseUrl
    });
    return terrainProvider.readyPromise.then(fail).catch(function(error) {
      expect(error).toBeInstanceOf(import__35.RuntimeError);
    });
  });
  it("checks availability if TileMap capability exists", function() {
    const baseUrl = "made/up/url";
    const terrainProvider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: baseUrl
    });
    return pollToPromise_default(function() {
      return terrainProvider.ready;
    }).then(function() {
      expect(terrainProvider._hasAvailability).toBe(true);
      expect(terrainProvider._tilesAvailable).toBeDefined();
      expect(terrainProvider._tilesAvailablityLoaded).toBeDefined();
    });
  });
  it("does not check availability if TileMap capability is missing", function() {
    const baseUrl = "made/up/url";
    metadata.capabilities = "Image,Mensuration";
    const terrainProvider = new import__35.ArcGISTiledElevationTerrainProvider({
      url: baseUrl
    });
    return pollToPromise_default(function() {
      return terrainProvider.ready;
    }).then(function() {
      expect(terrainProvider._hasAvailability).toBe(false);
      expect(terrainProvider._tilesAvailable).toBeUndefined();
      expect(terrainProvider._tilesAvailablityLoaded).toBeUndefined();
    });
  });
  describe("requestTileGeometry", function() {
    it("must not be called before isReady returns true", function() {
      const terrainProvider = new import__35.ArcGISTiledElevationTerrainProvider({
        url: "made/up/url",
        proxy: new import__35.DefaultProxy("/proxy/")
      });
      expect(function() {
        terrainProvider.requestTileGeometry(0, 0, 0);
      }).toThrowDeveloperError();
      return terrainProvider.readyPromise;
    });
    it("provides HeightmapTerrainData", function() {
      const baseUrl = "made/up/url";
      const terrainProvider = new import__35.ArcGISTiledElevationTerrainProvider({
        url: baseUrl
      });
      return pollToPromise_default(function() {
        return terrainProvider.ready;
      }).then(function() {
        const promise = terrainProvider.requestTileGeometry(0, 0, 0);
        import__35.RequestScheduler.update();
        return promise;
      }).then(function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__35.HeightmapTerrainData);
      });
    });
    it("returns undefined if too many requests are already in progress", function() {
      const baseUrl = "made/up/url";
      const deferreds = [];
      import__35.Resource._Implementations.createImage = function(request, crossOrigin, deferred) {
        deferreds.push(deferred);
      };
      const terrainProvider = new import__35.ArcGISTiledElevationTerrainProvider({
        url: baseUrl
      });
      return pollToPromise_default(function() {
        return terrainProvider.ready;
      }).then(function() {
        let promise;
        let i;
        for (i = 0; i < import__35.RequestScheduler.maximumRequestsPerServer - 1; ++i) {
          const request = new import__35.Request({
            throttle: true,
            throttleByServer: true
          });
          promise = terrainProvider.requestTileGeometry(0, 0, 0, request);
        }
        import__35.RequestScheduler.update();
        expect(promise).toBeDefined();
        promise = terrainProvider.requestTileGeometry(0, 0, 0, createRequest());
        expect(promise).toBeUndefined();
        for (i = 0; i < deferreds.length; ++i) {
          deferreds[i].resolve();
        }
        return Promise.all(
          deferreds.map(function(deferred) {
            return deferred.promise;
          })
        );
      });
    });
  });
});

// packages/engine/Specs/Core/AssociativeArraySpec.js
var import__36 = __toESM(require_Cesium(), 1);
describe("Core/AssociativeArray", function() {
  it("constructor has expected default values", function() {
    const associativeArray = new import__36.AssociativeArray();
    expect(associativeArray.length).toEqual(0);
    expect(associativeArray.values).toEqual([]);
  });
  it("can manipulate values", function() {
    const associativeArray = new import__36.AssociativeArray();
    expect(associativeArray.contains("key1")).toEqual(false);
    associativeArray.set("key1", 1);
    associativeArray.set("key2", 2);
    associativeArray.set("key3", 3);
    expect(associativeArray.get("key1")).toEqual(1);
    expect(associativeArray.get("key2")).toEqual(2);
    expect(associativeArray.get("key3")).toEqual(3);
    expect(associativeArray.length).toEqual(3);
    expect(associativeArray.contains("key1")).toEqual(true);
    expect(associativeArray.contains("key2")).toEqual(true);
    expect(associativeArray.contains("key3")).toEqual(true);
    const values = associativeArray.values;
    expect(values).toContain(1);
    expect(values).toContain(2);
    expect(values).toContain(3);
    expect(values.length).toEqual(3);
    associativeArray.set("key2", 4);
    expect(associativeArray.length).toEqual(3);
    expect(values).toContain(1);
    expect(values).not.toContain(2);
    expect(values).toContain(4);
    expect(values).toContain(3);
    expect(values.length).toEqual(3);
    expect(associativeArray.remove("key1")).toBe(true);
    expect(associativeArray.get("key1")).toBeUndefined();
    expect(associativeArray.contains("key1")).toEqual(false);
    expect(values).not.toContain(1);
    expect(values).toContain(4);
    expect(values).toContain(3);
    expect(values.length).toEqual(2);
    expect(associativeArray.remove("key1")).toBe(false);
    associativeArray.removeAll();
    expect(associativeArray.length).toEqual(0);
    expect(associativeArray.values).toEqual([]);
  });
  it("set throws with undefined key", function() {
    const associativeArray = new import__36.AssociativeArray();
    expect(function() {
      associativeArray.set(void 0, 1);
    }).toThrowDeveloperError();
  });
  it("get throws with undefined key", function() {
    const associativeArray = new import__36.AssociativeArray();
    expect(function() {
      associativeArray.get(void 0);
    }).toThrowDeveloperError();
  });
  it("remove returns false with undefined key", function() {
    const associativeArray = new import__36.AssociativeArray();
    expect(associativeArray.remove(void 0)).toBe(false);
  });
});

// packages/engine/Specs/Core/AttributeCompressionSpec.js
var import__37 = __toESM(require_Cesium(), 1);
describe("Core/AttributeCompression", function() {
  const negativeUnitZ = new import__37.Cartesian3(0, 0, -1);
  it("oct decode(0, 0)", function() {
    const result = new import__37.Cartesian3();
    import__37.AttributeCompression.octDecode(0, 0, result);
    expect(result).toEqual(negativeUnitZ);
  });
  it("oct encode(0, 0, -1)", function() {
    const result = new import__37.Cartesian2();
    import__37.AttributeCompression.octEncode(negativeUnitZ, result);
    expect(result).toEqual(new import__37.Cartesian2(255, 255));
  });
  it("oct encode(0, 0, 1)", function() {
    const result = new import__37.Cartesian2();
    import__37.AttributeCompression.octEncode(import__37.Cartesian3.UNIT_Z, result);
    expect(result).toEqual(new import__37.Cartesian2(128, 128));
  });
  it("oct encode(0, 0, -1) to 4 components", function() {
    const result = new import__37.Cartesian4();
    import__37.AttributeCompression.octEncodeToCartesian4(negativeUnitZ, result);
    expect(result).toEqual(new import__37.Cartesian4(255, 255, 255, 255));
  });
  it("oct encode(0, 0, 1) to 4 components", function() {
    const result = new import__37.Cartesian4();
    import__37.AttributeCompression.octEncodeToCartesian4(import__37.Cartesian3.UNIT_Z, result);
    expect(result).toEqual(new import__37.Cartesian4(128, 0, 128, 0));
  });
  it("oct extents are equal", function() {
    const result = new import__37.Cartesian3();
    import__37.AttributeCompression.octDecode(0, 0, result);
    expect(result).toEqual(negativeUnitZ);
    import__37.AttributeCompression.octDecode(255, 0, result);
    expect(result).toEqual(negativeUnitZ);
    import__37.AttributeCompression.octDecode(255, 255, result);
    expect(result).toEqual(negativeUnitZ);
    import__37.AttributeCompression.octDecode(255, 0, result);
    expect(result).toEqual(negativeUnitZ);
  });
  it("throws oct encode vector undefined", function() {
    let vector;
    const result = new import__37.Cartesian3();
    expect(function() {
      import__37.AttributeCompression.octEncode(vector, result);
    }).toThrowDeveloperError();
  });
  it("throws oct encode result undefined", function() {
    let result;
    expect(function() {
      import__37.AttributeCompression.octEncode(import__37.Cartesian3.UNIT_Z, result);
    }).toThrowDeveloperError();
  });
  it("throws oct encode non unit vector", function() {
    const nonUnitLengthVector = new import__37.Cartesian3(2, 0, 0);
    const result = new import__37.Cartesian2();
    expect(function() {
      import__37.AttributeCompression.octEncode(nonUnitLengthVector, result);
    }).toThrowDeveloperError();
  });
  it("throws oct encode zero length vector", function() {
    const result = new import__37.Cartesian2();
    expect(function() {
      import__37.AttributeCompression.octEncode(import__37.Cartesian3.ZERO, result);
    }).toThrowDeveloperError();
  });
  it("throws oct decode result undefined", function() {
    let result;
    expect(function() {
      import__37.AttributeCompression.octDecode(0, 0, result);
    }).toThrowDeveloperError();
  });
  it("throws oct decode x out of bounds", function() {
    const result = new import__37.Cartesian3();
    expect(function() {
      import__37.AttributeCompression.octDecode(256, 0, result);
    }).toThrowDeveloperError();
  });
  it("throws oct decode y out of bounds", function() {
    const result = new import__37.Cartesian3();
    expect(function() {
      import__37.AttributeCompression.octDecode(0, 256, result);
    }).toThrowDeveloperError();
  });
  it("throws 4-component oct decode out of bounds", function() {
    const result = new import__37.Cartesian3();
    expect(function() {
      import__37.AttributeCompression.octDecodeFromCartesian4(
        new import__37.Cartesian4(256, 0, 0, 0),
        result
      );
    }).toThrowDeveloperError();
    expect(function() {
      import__37.AttributeCompression.octDecodeFromCartesian4(
        new import__37.Cartesian4(0, 256, 0, 0),
        result
      );
    }).toThrowDeveloperError();
    expect(function() {
      import__37.AttributeCompression.octDecodeFromCartesian4(
        new import__37.Cartesian4(0, 0, 256, 0),
        result
      );
    }).toThrowDeveloperError();
    expect(function() {
      import__37.AttributeCompression.octDecodeFromCartesian4(
        new import__37.Cartesian4(0, 0, 0, 256),
        result
      );
    }).toThrowDeveloperError();
  });
  it("oct encoding", function() {
    const epsilon = import__37.Math.EPSILON1;
    const encoded = new import__37.Cartesian2();
    const result = new import__37.Cartesian3();
    let normal = new import__37.Cartesian3(0, 0, 1);
    import__37.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(0, 0, -1);
    import__37.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(0, 1, 0);
    import__37.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(0, -1, 0);
    import__37.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, 0, 0);
    import__37.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, 0, 0);
    import__37.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, 1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, -1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, -1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, 1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, 1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, -1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, 1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, -1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
  });
  it("oct encoding high precision", function() {
    const rangeMax = 4294967295;
    const epsilon = import__37.Math.EPSILON8;
    const encoded = new import__37.Cartesian2();
    const result = new import__37.Cartesian3();
    let normal = new import__37.Cartesian3(0, 0, 1);
    import__37.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__37.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(0, 0, -1);
    import__37.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__37.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(0, 1, 0);
    import__37.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__37.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(0, -1, 0);
    import__37.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__37.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, 0, 0);
    import__37.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__37.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, 0, 0);
    import__37.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__37.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, 1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__37.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, -1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__37.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, -1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__37.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, 1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__37.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, 1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__37.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, -1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__37.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, 1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__37.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, -1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__37.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
  });
  it("oct encoding to 4 components", function() {
    const epsilon = import__37.Math.EPSILON1;
    const encoded = new import__37.Cartesian4();
    const result = new import__37.Cartesian3();
    let normal = new import__37.Cartesian3(0, 0, 1);
    import__37.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(0, 0, -1);
    import__37.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(0, 1, 0);
    import__37.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(0, -1, 0);
    import__37.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, 0, 0);
    import__37.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, 0, 0);
    import__37.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, 1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, -1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, -1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, 1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, 1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, -1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, 1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, -1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__37.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
  });
  it("octFloat encoding", function() {
    const epsilon = import__37.Math.EPSILON1;
    const result = new import__37.Cartesian3();
    let normal = new import__37.Cartesian3(0, 0, 1);
    expect(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(0, 0, -1);
    expect(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(0, 1, 0);
    expect(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(0, -1, 0);
    expect(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, 0, 0);
    expect(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, 0, 0);
    expect(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, 1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    expect(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, -1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    expect(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, -1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    expect(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, 1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    expect(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, 1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    expect(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(1, -1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    expect(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, 1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    expect(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__37.Cartesian3(-1, -1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    expect(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
  });
  it("octFloat encoding is equivalent to oct encoding", function() {
    const encoded = new import__37.Cartesian2();
    const result1 = new import__37.Cartesian3();
    const result2 = new import__37.Cartesian3();
    let normal = new import__37.Cartesian3(0, 0, 1);
    import__37.AttributeCompression.octEncode(normal, encoded);
    import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__37.AttributeCompression.octDecodeFloat(
      import__37.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__37.Cartesian3(0, 0, -1);
    import__37.AttributeCompression.octEncode(normal, encoded);
    import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__37.AttributeCompression.octDecodeFloat(
      import__37.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__37.Cartesian3(0, 1, 0);
    import__37.AttributeCompression.octEncode(normal, encoded);
    import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__37.AttributeCompression.octDecodeFloat(
      import__37.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__37.Cartesian3(0, -1, 0);
    import__37.AttributeCompression.octEncode(normal, encoded);
    import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__37.AttributeCompression.octDecodeFloat(
      import__37.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__37.Cartesian3(1, 0, 0);
    import__37.AttributeCompression.octEncode(normal, encoded);
    import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__37.AttributeCompression.octDecodeFloat(
      import__37.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__37.Cartesian3(-1, 0, 0);
    import__37.AttributeCompression.octEncode(normal, encoded);
    import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__37.AttributeCompression.octDecodeFloat(
      import__37.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__37.Cartesian3(1, 1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__37.AttributeCompression.octDecodeFloat(
      import__37.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__37.Cartesian3(1, -1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__37.AttributeCompression.octDecodeFloat(
      import__37.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__37.Cartesian3(-1, -1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__37.AttributeCompression.octDecodeFloat(
      import__37.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__37.Cartesian3(-1, 1, 1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__37.AttributeCompression.octDecodeFloat(
      import__37.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__37.Cartesian3(1, 1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__37.AttributeCompression.octDecodeFloat(
      import__37.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__37.Cartesian3(1, -1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__37.AttributeCompression.octDecodeFloat(
      import__37.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__37.Cartesian3(-1, 1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__37.AttributeCompression.octDecodeFloat(
      import__37.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__37.Cartesian3(-1, -1, -1);
    import__37.Cartesian3.normalize(normal, normal);
    import__37.AttributeCompression.octEncode(normal, encoded);
    import__37.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__37.AttributeCompression.octDecodeFloat(
      import__37.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
  });
  it("encodeFloat throws without vector", function() {
    expect(function() {
      import__37.AttributeCompression.octEncodeFloat(void 0);
    }).toThrowDeveloperError();
  });
  it("decodeFloat throws without value", function() {
    expect(function() {
      import__37.AttributeCompression.octDecodeFloat(void 0, new import__37.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("decodeFloat throws without result", function() {
    expect(function() {
      import__37.AttributeCompression.octDecodeFloat(0, void 0);
    }).toThrowDeveloperError();
  });
  it("encode and packFloat is equivalent to oct encoding", function() {
    const vector = new import__37.Cartesian3(1, 1, 1);
    import__37.Cartesian3.normalize(vector, vector);
    const encoded = import__37.AttributeCompression.octEncode(vector, new import__37.Cartesian2());
    const encodedFloat = import__37.AttributeCompression.octPackFloat(encoded);
    expect(
      import__37.AttributeCompression.octDecodeFloat(encodedFloat, new import__37.Cartesian3())
    ).toEqual(
      import__37.AttributeCompression.octDecode(encoded.x, encoded.y, new import__37.Cartesian3())
    );
  });
  it("packFloat throws without encoded", function() {
    expect(function() {
      import__37.AttributeCompression.octPackFloat(void 0);
    }).toThrowDeveloperError();
  });
  it("pack is equivalent to oct encoding", function() {
    const x = import__37.Cartesian3.UNIT_X;
    const y = import__37.Cartesian3.UNIT_Y;
    const z = import__37.Cartesian3.UNIT_Z;
    const packed = import__37.AttributeCompression.octPack(x, y, z, new import__37.Cartesian2());
    const decodedX = new import__37.Cartesian3();
    const decodedY = new import__37.Cartesian3();
    const decodedZ = new import__37.Cartesian3();
    import__37.AttributeCompression.octUnpack(packed, decodedX, decodedY, decodedZ);
    expect(decodedX).toEqual(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(x),
        new import__37.Cartesian3()
      )
    );
    expect(decodedY).toEqual(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(y),
        new import__37.Cartesian3()
      )
    );
    expect(decodedZ).toEqual(
      import__37.AttributeCompression.octDecodeFloat(
        import__37.AttributeCompression.octEncodeFloat(z),
        new import__37.Cartesian3()
      )
    );
  });
  it("pack throws without v1", function() {
    expect(function() {
      import__37.AttributeCompression.octPack(
        void 0,
        new import__37.Cartesian3(),
        new import__37.Cartesian3(),
        new import__37.Cartesian2()
      );
    }).toThrowDeveloperError();
  });
  it("pack throws without v2", function() {
    expect(function() {
      import__37.AttributeCompression.octPack(
        new import__37.Cartesian3(),
        void 0,
        new import__37.Cartesian3(),
        new import__37.Cartesian2()
      );
    }).toThrowDeveloperError();
  });
  it("pack throws without v3", function() {
    expect(function() {
      import__37.AttributeCompression.octPack(
        new import__37.Cartesian3(),
        new import__37.Cartesian3(),
        void 0,
        new import__37.Cartesian2()
      );
    }).toThrowDeveloperError();
  });
  it("pack throws without result", function() {
    expect(function() {
      import__37.AttributeCompression.octPack(
        new import__37.Cartesian3(),
        new import__37.Cartesian3(),
        new import__37.Cartesian3(),
        void 0
      );
    }).toThrowDeveloperError();
  });
  it("unpack throws without packed", function() {
    expect(function() {
      import__37.AttributeCompression.octUnpack(
        void 0,
        new import__37.Cartesian3(),
        new import__37.Cartesian3(),
        new import__37.Cartesian3()
      );
    }).toThrowDeveloperError();
  });
  it("unpack throws without v1", function() {
    expect(function() {
      import__37.AttributeCompression.octUnpack(
        new import__37.Cartesian2(),
        void 0,
        new import__37.Cartesian3(),
        new import__37.Cartesian3()
      );
    }).toThrowDeveloperError();
  });
  it("unpack throws without v2", function() {
    expect(function() {
      import__37.AttributeCompression.octUnpack(
        new import__37.Cartesian2(),
        new import__37.Cartesian3(),
        void 0,
        new import__37.Cartesian3()
      );
    }).toThrowDeveloperError();
  });
  it("unpack throws without v3", function() {
    expect(function() {
      import__37.AttributeCompression.octUnpack(
        new import__37.Cartesian2(),
        new import__37.Cartesian3(),
        new import__37.Cartesian3(),
        void 0
      );
    }).toThrowDeveloperError();
  });
  it("compresses texture coordinates", function() {
    const coords = new import__37.Cartesian2(0.5, 0.5);
    expect(
      import__37.AttributeCompression.decompressTextureCoordinates(
        import__37.AttributeCompression.compressTextureCoordinates(coords),
        new import__37.Cartesian2()
      )
    ).toEqualEpsilon(coords, 1 / 4096);
  });
  it("compress texture coordinates throws without texture coordinates", function() {
    expect(function() {
      import__37.AttributeCompression.compressTextureCoordinates(void 0);
    }).toThrowDeveloperError();
  });
  it("decompress texture coordinates throws without encoded texture coordinates", function() {
    expect(function() {
      import__37.AttributeCompression.decompressTextureCoordinates(
        void 0,
        new import__37.Cartesian2()
      );
    }).toThrowDeveloperError();
  });
  it("decompress texture coordinates throws without result", function() {
    expect(function() {
      import__37.AttributeCompression.decompressTextureCoordinates(0, void 0);
    }).toThrowDeveloperError();
  });
  it("compresses/decompresses 1.0", function() {
    const coords = new import__37.Cartesian2(1, 1);
    expect(
      import__37.AttributeCompression.decompressTextureCoordinates(
        import__37.AttributeCompression.compressTextureCoordinates(coords),
        new import__37.Cartesian2()
      )
    ).toEqual(coords);
  });
  it("compresses/decompresses 0.0", function() {
    const coords = new import__37.Cartesian2(1, 1);
    expect(
      import__37.AttributeCompression.decompressTextureCoordinates(
        import__37.AttributeCompression.compressTextureCoordinates(coords),
        new import__37.Cartesian2()
      )
    ).toEqual(coords);
  });
  it("compresses/decompresses 0.5 / 1.0", function() {
    const coords = new import__37.Cartesian2(0.5, 1);
    expect(
      import__37.AttributeCompression.decompressTextureCoordinates(
        import__37.AttributeCompression.compressTextureCoordinates(coords),
        new import__37.Cartesian2()
      )
    ).toEqualEpsilon(coords, 1 / 4095);
  });
  it("compresses/decompresses 1.0 / 0.5", function() {
    const coords = new import__37.Cartesian2(1, 0.5);
    expect(
      import__37.AttributeCompression.decompressTextureCoordinates(
        import__37.AttributeCompression.compressTextureCoordinates(coords),
        new import__37.Cartesian2()
      )
    ).toEqualEpsilon(coords, 1 / 4095);
  });
  it("compresses/decompresses values very close but not equal to 1.0", function() {
    const coords = new import__37.Cartesian2(0.99999999999999, 0.99999999999999);
    expect(
      import__37.AttributeCompression.decompressTextureCoordinates(
        import__37.AttributeCompression.compressTextureCoordinates(coords),
        new import__37.Cartesian2()
      )
    ).toEqualEpsilon(coords, 1 / 4095);
  });
  function zigZag(value) {
    return (value << 1 ^ value >> 15) & 65535;
  }
  const maxShort = 32767;
  function deltaZigZagEncode(uBuffer, vBuffer, heightBuffer) {
    const length2 = uBuffer.length;
    const buffer = new Uint16Array(length2 * ((0, import__37.defined)(heightBuffer) ? 3 : 2));
    let lastU = 0;
    let lastV = 0;
    let lastHeight = 0;
    for (let i = 0; i < length2; ++i) {
      const u2 = uBuffer[i];
      const v2 = vBuffer[i];
      buffer[i] = zigZag(u2 - lastU);
      buffer[i + length2] = zigZag(v2 - lastV);
      lastU = u2;
      lastV = v2;
      if ((0, import__37.defined)(heightBuffer)) {
        const height = heightBuffer[i];
        buffer[i + length2 * 2] = zigZag(height - lastHeight);
        lastHeight = height;
      }
    }
    return buffer;
  }
  it("decodes delta and ZigZag encoded vertices without height", function() {
    const length2 = 10;
    const decodedUBuffer = new Array(length2);
    const decodedVBuffer = new Array(length2);
    for (let i = 0; i < length2; ++i) {
      decodedUBuffer[i] = Math.floor(Math.random() * maxShort);
      decodedVBuffer[i] = Math.floor(Math.random() * maxShort);
    }
    const encoded = deltaZigZagEncode(decodedUBuffer, decodedVBuffer);
    const uBuffer = new Uint16Array(encoded.buffer, 0, length2);
    const vBuffer = new Uint16Array(
      encoded.buffer,
      length2 * Uint16Array.BYTES_PER_ELEMENT,
      length2
    );
    import__37.AttributeCompression.zigZagDeltaDecode(uBuffer, vBuffer);
    expect(uBuffer).toEqual(decodedUBuffer);
    expect(vBuffer).toEqual(decodedVBuffer);
  });
  it("decodes delta and ZigZag encoded vertices with height", function() {
    const length2 = 10;
    const decodedUBuffer = new Array(length2);
    const decodedVBuffer = new Array(length2);
    const decodedHeightBuffer = new Array(length2);
    for (let i = 0; i < length2; ++i) {
      decodedUBuffer[i] = Math.floor(Math.random() * maxShort);
      decodedVBuffer[i] = Math.floor(Math.random() * maxShort);
      decodedHeightBuffer[i] = Math.floor(Math.random() * maxShort);
    }
    const encoded = deltaZigZagEncode(
      decodedUBuffer,
      decodedVBuffer,
      decodedHeightBuffer
    );
    const uBuffer = new Uint16Array(encoded.buffer, 0, length2);
    const vBuffer = new Uint16Array(
      encoded.buffer,
      length2 * Uint16Array.BYTES_PER_ELEMENT,
      length2
    );
    const heightBuffer = new Uint16Array(
      encoded.buffer,
      2 * length2 * Uint16Array.BYTES_PER_ELEMENT,
      length2
    );
    import__37.AttributeCompression.zigZagDeltaDecode(uBuffer, vBuffer, heightBuffer);
    expect(uBuffer).toEqual(decodedUBuffer);
    expect(vBuffer).toEqual(decodedVBuffer);
    expect(heightBuffer).toEqual(decodedHeightBuffer);
  });
  it("throws when zigZagDeltaDecode has an undefined uBuffer", function() {
    expect(function() {
      import__37.AttributeCompression.zigZagDeltaDecode(void 0, new Uint16Array(10));
    }).toThrowDeveloperError();
  });
  it("throws when zigZagDeltaDecode has an undefined vBuffer", function() {
    expect(function() {
      import__37.AttributeCompression.zigZagDeltaDecode(new Uint16Array(10), void 0);
    }).toThrowDeveloperError();
  });
  it("throws when zigZagDeltaDecode has unequal uBuffer and vBuffer length", function() {
    expect(function() {
      import__37.AttributeCompression.zigZagDeltaDecode(
        new Uint16Array(10),
        new Uint16Array(11)
      );
    }).toThrowDeveloperError();
  });
  it("throws when zigZagDeltaDecode has unequal uBuffer, vBuffer, and heightBuffer length", function() {
    expect(function() {
      import__37.AttributeCompression.zigZagDeltaDecode(
        new Uint16Array(10),
        new Uint16Array(10),
        new Uint16Array(11)
      );
    }).toThrowDeveloperError();
  });
  it("throws when dequantize has an undefined typedArray", function() {
    expect(function() {
      import__37.AttributeCompression.dequantize(
        void 0,
        import__37.ComponentDatatype.UNSIGNED_BYTE,
        import__37.AttributeType.VEC3,
        1
      );
    }).toThrowDeveloperError();
  });
  it("throws when dequantize has an undefined componentType", function() {
    expect(function() {
      import__37.AttributeCompression.dequantize(
        new Uint8Array([0, 0, 0, 0]),
        void 0,
        import__37.AttributeType.VEC3,
        1
      );
    }).toThrowDeveloperError();
  });
  it("throws when dequantize has an undefined type", function() {
    expect(function() {
      import__37.AttributeCompression.dequantize(
        new Uint8Array([0, 0, 0, 0]),
        import__37.ComponentDatatype.UNSIGNED_BYTE,
        void 0,
        1
      );
    }).toThrowDeveloperError();
  });
  it("throws when dequantize has an undefined count", function() {
    expect(function() {
      import__37.AttributeCompression.dequantize(
        new Uint8Array([0, 0, 0, 0]),
        import__37.ComponentDatatype.UNSIGNED_BYTE,
        import__37.AttributeType.VEC3,
        void 0
      );
    }).toThrowDeveloperError();
  });
  it("dequantize works with BYTE", function() {
    const input = [-127, -127, -127, 0, 0, 0, 127, 127, 127];
    const expected = [-1, -1, -1, 0, 0, 0, 1, 1, 1];
    const result = import__37.AttributeCompression.dequantize(
      new Int8Array(input),
      import__37.ComponentDatatype.BYTE,
      import__37.AttributeType.VEC3,
      3
    );
    for (let i = 0; i < input.length; i++) {
      expect(result[i]).toEqualEpsilon(expected[i], import__37.Math.EPSILON2);
    }
  });
  it("dequantize works with UNSIGNED_BYTE", function() {
    const input = [0, 0, 0, 127, 127, 127, 255, 255, 255];
    const expected = [0, 0, 0, 0.5, 0.5, 0.5, 1, 1, 1];
    const result = import__37.AttributeCompression.dequantize(
      new Uint8Array(input),
      import__37.ComponentDatatype.UNSIGNED_BYTE,
      import__37.AttributeType.VEC3,
      3
    );
    for (let i = 0; i < input.length; i++) {
      expect(result[i]).toEqualEpsilon(expected[i], import__37.Math.EPSILON2);
    }
  });
  it("dequantize works with SHORT", function() {
    const input = [-32767, -32767, -32767, 0, 0, 0, 32767, 32767, 32767];
    const expected = [-1, -1, -1, 0, 0, 0, 1, 1, 1];
    const result = import__37.AttributeCompression.dequantize(
      new Int16Array(input),
      import__37.ComponentDatatype.SHORT,
      import__37.AttributeType.VEC3,
      3
    );
    for (let i = 0; i < input.length; i++) {
      expect(result[i]).toEqualEpsilon(expected[i], import__37.Math.EPSILON5);
    }
  });
  it("dequantize works with UNSIGNED_SHORT", function() {
    const input = [0, 0, 0, 32767, 32767, 32767, 65535, 65535, 65535];
    const expected = [0, 0, 0, 0.5, 0.5, 0.5, 1, 1, 1];
    const result = import__37.AttributeCompression.dequantize(
      new Uint16Array(input),
      import__37.ComponentDatatype.UNSIGNED_SHORT,
      import__37.AttributeType.VEC3,
      3
    );
    for (let i = 0; i < input.length; i++) {
      expect(result[i]).toEqualEpsilon(expected[i], import__37.Math.EPSILON5);
    }
  });
  it("dequantize works with INT", function() {
    const input = [
      -2147483647,
      -2147483647,
      -2147483647,
      0,
      0,
      0,
      2147483647,
      2147483647,
      2147483647
    ];
    const expected = [-1, -1, -1, 0, 0, 0, 1, 1, 1];
    const result = import__37.AttributeCompression.dequantize(
      new Int32Array(input),
      import__37.ComponentDatatype.INT,
      import__37.AttributeType.VEC3,
      3
    );
    for (let i = 0; i < input.length; i++) {
      expect(result[i]).toEqual(expected[i]);
    }
  });
  it("dequantize works with UNSIGNED_INT", function() {
    const input = [
      0,
      0,
      0,
      2147483647,
      2147483647,
      2147483647,
      4294967295,
      4294967295,
      4294967295
    ];
    const expected = [0, 0, 0, 0.5, 0.5, 0.5, 1, 1, 1];
    const result = import__37.AttributeCompression.dequantize(
      new Uint32Array(input),
      import__37.ComponentDatatype.UNSIGNED_INT,
      import__37.AttributeType.VEC3,
      3
    );
    for (let i = 0; i < input.length; i++) {
      expect(result[i]).toEqual(expected[i]);
    }
  });
  it("decodeRGB565 throws without typedArray", function() {
    expect(function() {
      return import__37.AttributeCompression.decodeRGB565();
    }).toThrowDeveloperError();
  });
  it("decodeRGB565 throws if arrays are the wrong size", function() {
    expect(function() {
      return import__37.AttributeCompression.decodeRGB565(
        new Uint16Array([0]),
        new Float32Array(1)
      );
    }).toThrowDeveloperError();
  });
  it("decodeRGB565 works", function() {
    const input = new Uint16Array([
      0,
      //0b00001_000001_00001
      2081,
      //0b10000_100000_01000
      33800,
      //0b11111_111111_11111
      65535
    ]);
    const expected = new Float32Array([
      0,
      0,
      0,
      1 / 31,
      1 / 63,
      1 / 31,
      16 / 31,
      32 / 63,
      8 / 31,
      31 / 31,
      63 / 63,
      31 / 31
    ]);
    const resultLength = input.length * 3;
    const result = new Float32Array(resultLength);
    import__37.AttributeCompression.decodeRGB565(input, result);
    for (let i = 0; i < resultLength; i++) {
      expect(result[i]).toEqual(expected[i]);
    }
  });
  it("decodeRGB565 creates a result array if not defined", function() {
    const result = import__37.AttributeCompression.decodeRGB565(new Uint16Array([0]));
    expect(result).toEqual(new Float32Array([0, 0, 0]));
  });
});

// packages/engine/Specs/Core/AxisAlignedBoundingBoxSpec.js
var import__38 = __toESM(require_Cesium(), 1);
describe("Core/AxisAlignedBoundingBox", function() {
  const positions = [
    new import__38.Cartesian3(3, -1, -3),
    new import__38.Cartesian3(2, -2, -2),
    new import__38.Cartesian3(1, -3, -1),
    new import__38.Cartesian3(0, 0, 0),
    new import__38.Cartesian3(-1, 1, 1),
    new import__38.Cartesian3(-2, 2, 2),
    new import__38.Cartesian3(-3, 3, 3)
  ];
  const positionsMinimum = new import__38.Cartesian3(-3, -3, -3);
  const positionsMaximum = new import__38.Cartesian3(3, 3, 3);
  const positionsCenter = new import__38.Cartesian3(0, 0, 0);
  it("constructor sets expected default values", function() {
    const box = new import__38.AxisAlignedBoundingBox();
    expect(box.minimum).toEqual(import__38.Cartesian3.ZERO);
    expect(box.maximum).toEqual(import__38.Cartesian3.ZERO);
    expect(box.center).toEqual(import__38.Cartesian3.ZERO);
  });
  it("constructor sets expected parameter values", function() {
    const minimum = new import__38.Cartesian3(1, 2, 3);
    const maximum = new import__38.Cartesian3(4, 5, 6);
    const center = new import__38.Cartesian3(2.5, 3.5, 4.5);
    const box = new import__38.AxisAlignedBoundingBox(minimum, maximum, center);
    expect(box.minimum).toEqual(minimum);
    expect(box.maximum).toEqual(maximum);
    expect(box.center).toEqual(center);
  });
  it("constructor computes center if not supplied", function() {
    const minimum = new import__38.Cartesian3(1, 2, 3);
    const maximum = new import__38.Cartesian3(4, 5, 6);
    const expectedCenter = new import__38.Cartesian3(2.5, 3.5, 4.5);
    const box = new import__38.AxisAlignedBoundingBox(minimum, maximum);
    expect(box.minimum).toEqual(minimum);
    expect(box.maximum).toEqual(maximum);
    expect(box.center).toEqual(expectedCenter);
  });
  it("fromCorners works with a result parameter", function() {
    const minimum = new import__38.Cartesian3(0, 0, 0);
    const maximum = new import__38.Cartesian3(1, 1, 1);
    const expectedCenter = new import__38.Cartesian3(0.5, 0.5, 0.5);
    const box = new import__38.AxisAlignedBoundingBox();
    const result = import__38.AxisAlignedBoundingBox.fromCorners(minimum, maximum, box);
    expect(result.minimum).toEqual(minimum);
    expect(result.maximum).toEqual(maximum);
    expect(result.center).toEqual(expectedCenter);
    expect(result).toBe(box);
  });
  it("fromCorners works without a result parameter", function() {
    const minimum = new import__38.Cartesian3(0, 0, 0);
    const maximum = new import__38.Cartesian3(1, 1, 1);
    const expectedCenter = new import__38.Cartesian3(0.5, 0.5, 0.5);
    const box = import__38.AxisAlignedBoundingBox.fromCorners(minimum, maximum);
    expect(box.minimum).toEqual(minimum);
    expect(box.maximum).toEqual(maximum);
    expect(box.center).toEqual(expectedCenter);
  });
  it("fromCorners throws without a minimum", function() {
    expect(function() {
      import__38.AxisAlignedBoundingBox.fromCorners(void 0, import__38.Cartesian3.ZERO);
    }).toThrowDeveloperError();
  });
  it("fromCorners throws without a maximum", function() {
    expect(function() {
      import__38.AxisAlignedBoundingBox.fromCorners(import__38.Cartesian3.ZERO, void 0);
    }).toThrowDeveloperError();
  });
  it("fromPoints constructs empty box with undefined positions", function() {
    const box = import__38.AxisAlignedBoundingBox.fromPoints(void 0);
    expect(box.minimum).toEqual(import__38.Cartesian3.ZERO);
    expect(box.maximum).toEqual(import__38.Cartesian3.ZERO);
    expect(box.center).toEqual(import__38.Cartesian3.ZERO);
  });
  it("fromPoints constructs empty box with empty positions", function() {
    const box = import__38.AxisAlignedBoundingBox.fromPoints([]);
    expect(box.minimum).toEqual(import__38.Cartesian3.ZERO);
    expect(box.maximum).toEqual(import__38.Cartesian3.ZERO);
    expect(box.center).toEqual(import__38.Cartesian3.ZERO);
  });
  it("fromPoints computes the correct values", function() {
    const box = import__38.AxisAlignedBoundingBox.fromPoints(positions);
    expect(box.minimum).toEqual(positionsMinimum);
    expect(box.maximum).toEqual(positionsMaximum);
    expect(box.center).toEqual(positionsCenter);
  });
  it("clone without a result parameter", function() {
    const box = new import__38.AxisAlignedBoundingBox(
      import__38.Cartesian3.UNIT_Y,
      import__38.Cartesian3.UNIT_X
    );
    const result = box.clone();
    expect(box).not.toBe(result);
    expect(box).toEqual(result);
  });
  it("clone without a result parameter with box of offset center", function() {
    const box = new import__38.AxisAlignedBoundingBox(
      import__38.Cartesian3.UNIT_Y,
      import__38.Cartesian3.UNIT_X,
      import__38.Cartesian3.UNIT_Z
    );
    const result = box.clone();
    expect(box).not.toBe(result);
    expect(box).toEqual(result);
  });
  it("clone with a result parameter", function() {
    const box = new import__38.AxisAlignedBoundingBox(
      import__38.Cartesian3.UNIT_Y,
      import__38.Cartesian3.UNIT_X
    );
    const result = new import__38.AxisAlignedBoundingBox(
      import__38.Cartesian3.ZERO,
      import__38.Cartesian3.UNIT_Z
    );
    const returnedResult = box.clone(result);
    expect(result).toBe(returnedResult);
    expect(box).not.toBe(result);
    expect(box).toEqual(result);
  });
  it('clone works with "this" result parameter', function() {
    const box = new import__38.AxisAlignedBoundingBox(
      import__38.Cartesian3.UNIT_Y,
      import__38.Cartesian3.UNIT_X
    );
    const returnedResult = box.clone(box);
    expect(box).toBe(returnedResult);
    expect(box.minimum).toEqual(import__38.Cartesian3.UNIT_Y);
    expect(box.maximum).toEqual(import__38.Cartesian3.UNIT_X);
  });
  it("equals works in all cases", function() {
    const box = new import__38.AxisAlignedBoundingBox(
      import__38.Cartesian3.UNIT_X,
      import__38.Cartesian3.UNIT_Y,
      import__38.Cartesian3.UNIT_Z
    );
    const bogie = new import__38.Cartesian3(2, 3, 4);
    expect(
      box.equals(
        new import__38.AxisAlignedBoundingBox(
          import__38.Cartesian3.UNIT_X,
          import__38.Cartesian3.UNIT_Y,
          import__38.Cartesian3.UNIT_Z
        )
      )
    ).toEqual(true);
    expect(
      box.equals(
        new import__38.AxisAlignedBoundingBox(bogie, import__38.Cartesian3.UNIT_Y, import__38.Cartesian3.UNIT_Y)
      )
    ).toEqual(false);
    expect(
      box.equals(
        new import__38.AxisAlignedBoundingBox(import__38.Cartesian3.UNIT_X, bogie, import__38.Cartesian3.UNIT_Z)
      )
    ).toEqual(false);
    expect(
      box.equals(
        new import__38.AxisAlignedBoundingBox(import__38.Cartesian3.UNIT_X, import__38.Cartesian3.UNIT_Y, bogie)
      )
    ).toEqual(false);
    expect(box.equals(void 0)).toEqual(false);
  });
  it("computes the bounding box for a single position", function() {
    const box = import__38.AxisAlignedBoundingBox.fromPoints([positions[0]]);
    expect(box.minimum).toEqual(positions[0]);
    expect(box.maximum).toEqual(positions[0]);
    expect(box.center).toEqual(positions[0]);
  });
  it("intersectPlane works with box on the positive side of a plane", function() {
    const box = new import__38.AxisAlignedBoundingBox(
      import__38.Cartesian3.negate(import__38.Cartesian3.UNIT_X, new import__38.Cartesian3()),
      import__38.Cartesian3.ZERO
    );
    const normal = import__38.Cartesian3.negate(import__38.Cartesian3.UNIT_X, new import__38.Cartesian3());
    const position = import__38.Cartesian3.UNIT_X;
    const plane = new import__38.Plane(normal, -import__38.Cartesian3.dot(normal, position));
    expect(box.intersectPlane(plane)).toEqual(import__38.Intersect.INSIDE);
  });
  it("intersectPlane works with box on the negative side of a plane", function() {
    const box = new import__38.AxisAlignedBoundingBox(
      import__38.Cartesian3.negate(import__38.Cartesian3.UNIT_X, new import__38.Cartesian3()),
      import__38.Cartesian3.ZERO
    );
    const normal = import__38.Cartesian3.UNIT_X;
    const position = import__38.Cartesian3.UNIT_X;
    const plane = new import__38.Plane(normal, -import__38.Cartesian3.dot(normal, position));
    expect(box.intersectPlane(plane)).toEqual(import__38.Intersect.OUTSIDE);
  });
  it("intersectPlane works with box intersecting a plane", function() {
    const box = new import__38.AxisAlignedBoundingBox(
      import__38.Cartesian3.ZERO,
      import__38.Cartesian3.multiplyByScalar(import__38.Cartesian3.UNIT_X, 2, new import__38.Cartesian3())
    );
    const normal = import__38.Cartesian3.UNIT_X;
    const position = import__38.Cartesian3.UNIT_X;
    const plane = new import__38.Plane(normal, -import__38.Cartesian3.dot(normal, position));
    expect(box.intersectPlane(plane)).toEqual(import__38.Intersect.INTERSECTING);
  });
  it("clone returns undefined with no parameter", function() {
    expect(import__38.AxisAlignedBoundingBox.clone()).toBeUndefined();
  });
  it("intersectPlane throws without a box", function() {
    const plane = new import__38.Plane(import__38.Cartesian3.UNIT_X, 0);
    expect(function() {
      import__38.AxisAlignedBoundingBox.intersectPlane(void 0, plane);
    }).toThrowDeveloperError();
  });
  it("intersectPlane throws without a plane", function() {
    const box = new import__38.AxisAlignedBoundingBox();
    expect(function() {
      import__38.AxisAlignedBoundingBox.intersectPlane(box, void 0);
    }).toThrowDeveloperError();
  });
});

// packages/engine/Specs/Core/BingMapsGeocoderServiceSpec.js
var import__39 = __toESM(require_Cesium(), 1);
describe("Core/BingMapsGeocoderService", function() {
  afterAll(function() {
    import__39.Resource._Implementations.loadAndExecuteScript = import__39.Resource._DefaultImplementations.loadAndExecuteScript;
  });
  it("returns geocoder results", function() {
    const query = "some query";
    const key = "not_the_real_key;";
    const data = {
      resourceSets: [
        {
          resources: [
            {
              name: "a",
              bbox: [32, 3, 3, 4]
            }
          ]
        }
      ]
    };
    import__39.Resource._Implementations.loadAndExecuteScript = function(url, functionName, deferred) {
      const parsedUrl = new URL(url);
      expect(parsedUrl.searchParams.get("query")).toEqual(query);
      expect(parsedUrl.searchParams.get("key")).toEqual(key);
      expect(parsedUrl.searchParams.get("culture")).toBe(null);
      deferred.resolve(data);
    };
    const service = new import__39.BingMapsGeocoderService({ key });
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(1);
      expect(results[0].displayName).toEqual("a");
      expect(results[0].destination).toBeInstanceOf(import__39.Rectangle);
    });
  });
  it("uses supplied culture", function() {
    const query = "some query";
    const key = "not_the_real_key;";
    const data = {
      resourceSets: [
        {
          resources: [
            {
              name: "a",
              bbox: [32, 3, 3, 4]
            }
          ]
        }
      ]
    };
    import__39.Resource._Implementations.loadAndExecuteScript = function(url, functionName, deferred) {
      const parsedUrl = new URL(url);
      expect(parsedUrl.searchParams.get("query")).toEqual(query);
      expect(parsedUrl.searchParams.get("key")).toEqual(key);
      expect(parsedUrl.searchParams.get("culture")).toEqual("ja");
      deferred.resolve(data);
    };
    const service = new import__39.BingMapsGeocoderService({ key, culture: "ja" });
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(1);
      expect(results[0].displayName).toEqual("a");
      expect(results[0].destination).toBeInstanceOf(import__39.Rectangle);
    });
  });
  it("returns no geocoder results if Bing has no results", function() {
    const query = "some query";
    const data = {
      resourceSets: []
    };
    import__39.Resource._Implementations.loadAndExecuteScript = function(url, functionName, deferred) {
      deferred.resolve(data);
    };
    const service = new import__39.BingMapsGeocoderService({ key: "" });
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(0);
    });
  });
  it("returns no geocoder results if Bing has results but no resources", function() {
    const query = "some query";
    const data = {
      resourceSets: [
        {
          resources: []
        }
      ]
    };
    import__39.Resource._Implementations.loadAndExecuteScript = function(url, functionName, deferred) {
      deferred.resolve(data);
    };
    const service = new import__39.BingMapsGeocoderService({ key: "" });
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(0);
    });
  });
});

// packages/engine/Specs/Core/BoundingRectangleSpec.js
var import__40 = __toESM(require_Cesium(), 1);

// Specs/createPackableSpecs.js
var import_engine8 = __toESM(require_Cesium(), 1);
function createPackableSpecs(packable, instance, packedInstance, namePrefix) {
  namePrefix = (0, import_engine8.defaultValue)(namePrefix, "");
  it(`${namePrefix} can pack`, function() {
    const packedArray = [];
    const returnArray = packable.pack(instance, packedArray);
    expect(returnArray).toBe(packedArray);
    const packedLength = (0, import_engine8.defined)(packable.packedLength) ? packable.packedLength : instance.packedLength;
    expect(packedArray.length).toEqual(packedLength);
    expect(packedArray).toEqualEpsilon(packedInstance, import_engine8.Math.EPSILON15);
  });
  it(`${namePrefix} can roundtrip`, function() {
    const packedArray = [];
    packable.pack(instance, packedArray);
    const result = packable.unpack(packedArray);
    expect(instance).toEqual(result);
  });
  it(`${namePrefix} can unpack`, function() {
    const result = packable.unpack(packedInstance);
    expect(result).toEqual(instance);
  });
  it(`${namePrefix} can pack with startingIndex`, function() {
    const packedArray = [0];
    const expected = packedArray.concat(packedInstance);
    packable.pack(instance, packedArray, 1);
    expect(packedArray).toEqualEpsilon(expected, import_engine8.Math.EPSILON15);
  });
  it(`${namePrefix} can unpack with startingIndex`, function() {
    const packedArray = [0].concat(packedInstance);
    const result = packable.unpack(packedArray, 1);
    expect(instance).toEqual(result);
  });
  it(`${namePrefix} pack throws with undefined value`, function() {
    const array = [];
    expect(function() {
      packable.pack(void 0, array);
    }).toThrowDeveloperError();
  });
  it(`${namePrefix} pack throws with undefined array`, function() {
    expect(function() {
      packable.pack(instance, void 0);
    }).toThrowDeveloperError();
  });
  it(`${namePrefix} unpack throws with undefined array`, function() {
    expect(function() {
      packable.unpack(void 0);
    }).toThrowDeveloperError();
  });
  if (typeof packable.convertPackedArrayForInterpolation === "function") {
    it(`${namePrefix} packs and unpacks for interpolation.`, function() {
      const packedForInterpolation = [];
      packable.convertPackedArrayForInterpolation(
        packedInstance,
        0,
        0,
        packedForInterpolation
      );
      const value = packable.unpackInterpolationResult(
        packedForInterpolation,
        packedInstance,
        0,
        0
      );
      const result = packable.unpack(packedInstance);
      expect(value).toEqual(result);
    });
    it(`${namePrefix} convertPackedArrayForInterpolation throws without array.`, function() {
      expect(function() {
        packable.convertPackedArrayForInterpolation(void 0);
      }).toThrowDeveloperError();
    });
    it(`${namePrefix} unpackInterpolationResult throws without packed array.`, function() {
      expect(function() {
        packable.unpackInterpolationResult(void 0, []);
      }).toThrowDeveloperError();
    });
    it(`${namePrefix} unpackInterpolationResult throws without source array.`, function() {
      expect(function() {
        packable.unpackInterpolationResult([], void 0);
      }).toThrowDeveloperError();
    });
  }
}
var createPackableSpecs_default = createPackableSpecs;

// packages/engine/Specs/Core/BoundingRectangleSpec.js
describe("Core/BoundingRectangle", function() {
  it("default constructor sets expected values", function() {
    const rectangle = new import__40.BoundingRectangle();
    expect(rectangle.x).toEqual(0);
    expect(rectangle.y).toEqual(0);
    expect(rectangle.width).toEqual(0);
    expect(rectangle.height).toEqual(0);
  });
  it("constructor sets expected parameters", function() {
    const rectangle = new import__40.BoundingRectangle(1, 2, 3, 4);
    expect(rectangle.x).toEqual(1);
    expect(rectangle.y).toEqual(2);
    expect(rectangle.width).toEqual(3);
    expect(rectangle.height).toEqual(4);
  });
  it("clone without a result parameter", function() {
    const rectangle = new import__40.BoundingRectangle(1, 2, 3, 4);
    const result = rectangle.clone();
    expect(rectangle).not.toBe(result);
    expect(rectangle).toEqual(result);
  });
  it("clone with a result parameter", function() {
    const rectangle = new import__40.BoundingRectangle(1, 2, 3, 4);
    const result = new import__40.BoundingRectangle(6, 7, 8, 9);
    const returnedResult = rectangle.clone(result);
    expect(result).not.toBe(rectangle);
    expect(result).toEqual(rectangle);
    expect(result).toBe(returnedResult);
  });
  it('clone works with "this" result parameter', function() {
    const rectangle = new import__40.BoundingRectangle(1, 2, 3, 4);
    const returnedResult = rectangle.clone(rectangle);
    expect(rectangle.x).toEqual(1);
    expect(rectangle.y).toEqual(2);
    expect(rectangle.width).toEqual(3);
    expect(rectangle.height).toEqual(4);
    expect(rectangle).toBe(returnedResult);
  });
  it("equals", function() {
    const rectangle = new import__40.BoundingRectangle(1, 2, 3, 4);
    expect(rectangle.equals(new import__40.BoundingRectangle(1, 2, 3, 4))).toEqual(
      true
    );
    expect(rectangle.equals(new import__40.BoundingRectangle(5, 2, 3, 4))).toEqual(
      false
    );
    expect(rectangle.equals(new import__40.BoundingRectangle(1, 6, 3, 4))).toEqual(
      false
    );
    expect(rectangle.equals(new import__40.BoundingRectangle(1, 2, 7, 4))).toEqual(
      false
    );
    expect(rectangle.equals(new import__40.BoundingRectangle(1, 2, 3, 8))).toEqual(
      false
    );
    expect(rectangle.equals(void 0)).toEqual(false);
  });
  const positions = [
    new import__40.Cartesian2(3, -1),
    new import__40.Cartesian2(2, -2),
    new import__40.Cartesian2(1, -3),
    new import__40.Cartesian2(0, 0),
    new import__40.Cartesian2(-1, 1),
    new import__40.Cartesian2(-2, 2),
    new import__40.Cartesian2(-3, 3)
  ];
  it("create axis aligned bounding rectangle", function() {
    const rectangle = import__40.BoundingRectangle.fromPoints(positions);
    expect(rectangle.x).toEqual(-3);
    expect(rectangle.y).toEqual(-3);
    expect(rectangle.width).toEqual(6);
    expect(rectangle.height).toEqual(6);
  });
  it("fromPoints works with a result parameter", function() {
    const result = new import__40.BoundingRectangle();
    const rectangle = import__40.BoundingRectangle.fromPoints(positions, result);
    expect(rectangle).toBe(result);
    expect(rectangle.x).toEqual(-3);
    expect(rectangle.y).toEqual(-3);
    expect(rectangle.width).toEqual(6);
    expect(rectangle.height).toEqual(6);
  });
  it("fromPoints creates an empty rectangle with no positions", function() {
    const rectangle = import__40.BoundingRectangle.fromPoints();
    expect(rectangle.x).toEqual(0);
    expect(rectangle.y).toEqual(0);
    expect(rectangle.width).toEqual(0);
    expect(rectangle.height).toEqual(0);
  });
  it("fromRectangle creates an empty rectangle with no rectangle", function() {
    const rectangle = import__40.BoundingRectangle.fromRectangle();
    expect(rectangle.x).toEqual(0);
    expect(rectangle.y).toEqual(0);
    expect(rectangle.width).toEqual(0);
    expect(rectangle.height).toEqual(0);
  });
  it("create a bounding rectangle from a rectangle", function() {
    const rectangle = import__40.Rectangle.MAX_VALUE;
    const projection = new import__40.GeographicProjection(import__40.Ellipsoid.UNIT_SPHERE);
    const expected = new import__40.BoundingRectangle(
      rectangle.west,
      rectangle.south,
      rectangle.east - rectangle.west,
      rectangle.north - rectangle.south
    );
    expect(import__40.BoundingRectangle.fromRectangle(rectangle, projection)).toEqual(
      expected
    );
  });
  it("fromRectangle works with a result parameter", function() {
    const rectangle = import__40.Rectangle.MAX_VALUE;
    const expected = new import__40.BoundingRectangle(
      rectangle.west,
      rectangle.south,
      rectangle.east - rectangle.west,
      rectangle.north - rectangle.south
    );
    const projection = new import__40.GeographicProjection(import__40.Ellipsoid.UNIT_SPHERE);
    const result = new import__40.BoundingRectangle();
    const returnedResult = import__40.BoundingRectangle.fromRectangle(
      rectangle,
      projection,
      result
    );
    expect(result).toBe(returnedResult);
    expect(returnedResult).toEqual(expected);
  });
  it("intersect works", function() {
    const rectangle1 = new import__40.BoundingRectangle(0, 0, 4, 4);
    const rectangle2 = new import__40.BoundingRectangle(2, 2, 4, 4);
    const rectangle3 = new import__40.BoundingRectangle(-6, 2, 4, 4);
    const rectangle4 = new import__40.BoundingRectangle(8, 2, 4, 4);
    const rectangle5 = new import__40.BoundingRectangle(2, -6, 4, 4);
    const rectangle6 = new import__40.BoundingRectangle(2, 8, 4, 4);
    expect(import__40.BoundingRectangle.intersect(rectangle1, rectangle2)).toEqual(
      import__40.Intersect.INTERSECTING
    );
    expect(import__40.BoundingRectangle.intersect(rectangle1, rectangle3)).toEqual(
      import__40.Intersect.OUTSIDE
    );
    expect(import__40.BoundingRectangle.intersect(rectangle1, rectangle4)).toEqual(
      import__40.Intersect.OUTSIDE
    );
    expect(import__40.BoundingRectangle.intersect(rectangle1, rectangle5)).toEqual(
      import__40.Intersect.OUTSIDE
    );
    expect(import__40.BoundingRectangle.intersect(rectangle1, rectangle6)).toEqual(
      import__40.Intersect.OUTSIDE
    );
  });
  it("union works without a result parameter", function() {
    const rectangle1 = new import__40.BoundingRectangle(2, 0, 1, 1);
    const rectangle2 = new import__40.BoundingRectangle(-2, 0, 1, 2);
    const expected = new import__40.BoundingRectangle(-2, 0, 5, 2);
    const returnedResult = import__40.BoundingRectangle.union(rectangle1, rectangle2);
    expect(returnedResult).toEqual(expected);
  });
  it("union works with a result parameter", function() {
    const rectangle1 = new import__40.BoundingRectangle(2, 0, 1, 1);
    const rectangle2 = new import__40.BoundingRectangle(-2, 0, 1, 2);
    const expected = new import__40.BoundingRectangle(-2, 0, 5, 2);
    const result = new import__40.BoundingRectangle(-1, -1, 10, 10);
    const returnedResult = import__40.BoundingRectangle.union(
      rectangle1,
      rectangle2,
      result
    );
    expect(result).toBe(returnedResult);
    expect(returnedResult).toEqual(expected);
  });
  it("expand works if rectangle needs to grow right", function() {
    const rectangle = new import__40.BoundingRectangle(2, 0, 1, 1);
    const point = new import__40.Cartesian2(4, 0);
    const expected = new import__40.BoundingRectangle(2, 0, 2, 1);
    const result = import__40.BoundingRectangle.expand(rectangle, point);
    expect(result).toEqual(expected);
  });
  it("expand works if rectangle needs x to grow left", function() {
    const rectangle = new import__40.BoundingRectangle(2, 0, 1, 1);
    const point = new import__40.Cartesian2(0, 0);
    const expected = new import__40.BoundingRectangle(0, 0, 3, 1);
    const result = import__40.BoundingRectangle.expand(rectangle, point);
    expect(result).toEqual(expected);
  });
  it("expand works if rectangle needs to grow up", function() {
    const rectangle = new import__40.BoundingRectangle(2, 0, 1, 1);
    const point = new import__40.Cartesian2(2, 2);
    const expected = new import__40.BoundingRectangle(2, 0, 1, 2);
    const result = import__40.BoundingRectangle.expand(rectangle, point);
    expect(result).toEqual(expected);
  });
  it("expand works if rectangle needs x to grow down", function() {
    const rectangle = new import__40.BoundingRectangle(2, 0, 1, 1);
    const point = new import__40.Cartesian2(2, -1);
    const expected = new import__40.BoundingRectangle(2, -1, 1, 2);
    const result = import__40.BoundingRectangle.expand(rectangle, point);
    expect(result).toEqual(expected);
  });
  it("expand works if rectangle does not need to grow", function() {
    const rectangle = new import__40.BoundingRectangle(2, 0, 1, 1);
    const point = new import__40.Cartesian2(2.5, 0.6);
    const expected = new import__40.BoundingRectangle(2, 0, 1, 1);
    const result = import__40.BoundingRectangle.expand(rectangle, point);
    expect(result).toEqual(expected);
  });
  it("expand works with a result parameter", function() {
    const rectangle = new import__40.BoundingRectangle(2, 0, 1, 1);
    const point = new import__40.Cartesian2(2, -1);
    const expected = new import__40.BoundingRectangle(2, -1, 1, 2);
    const result = new import__40.BoundingRectangle();
    const returnedResult = import__40.BoundingRectangle.expand(rectangle, point, result);
    expect(returnedResult).toBe(returnedResult);
    expect(result).toEqual(expected);
  });
  it("clone returns undefined with no parameter", function() {
    expect(import__40.BoundingRectangle.clone()).toBeUndefined();
  });
  it("union throws with no left parameter", function() {
    const right = new import__40.BoundingRectangle(1, 2, 3, 4);
    expect(function() {
      import__40.BoundingRectangle.union(void 0, right);
    }).toThrowDeveloperError();
  });
  it("union throws with no right parameter", function() {
    const left = new import__40.BoundingRectangle(1, 2, 3, 4);
    expect(function() {
      import__40.BoundingRectangle.union(left, void 0);
    }).toThrowDeveloperError();
  });
  it("expand throws with no rectangle parameter", function() {
    const point = new import__40.Cartesian2();
    expect(function() {
      import__40.BoundingRectangle.expand(void 0, point);
    }).toThrowDeveloperError();
  });
  it("expand throws with no point parameter", function() {
    const rectangle = new import__40.BoundingRectangle(1, 2, 3, 4);
    expect(function() {
      import__40.BoundingRectangle.expand(rectangle, void 0);
    }).toThrowDeveloperError();
  });
  it("intersect throws with no left parameter", function() {
    const right = new import__40.BoundingRectangle(1, 2, 3, 4);
    expect(function() {
      import__40.BoundingRectangle.intersect(void 0, right);
    }).toThrowDeveloperError();
  });
  it("intersect throws with no right parameter", function() {
    const left = new import__40.BoundingRectangle(1, 2, 3, 4);
    expect(function() {
      import__40.BoundingRectangle.intersect(left, void 0);
    }).toThrowDeveloperError();
  });
  createPackableSpecs_default(import__40.BoundingRectangle, new import__40.BoundingRectangle(1, 2, 3, 4), [
    1,
    2,
    3,
    4
  ]);
});

// packages/engine/Specs/Core/BoundingSphereSpec.js
var import__41 = __toESM(require_Cesium(), 1);
describe("Core/BoundingSphere", function() {
  const positionsRadius = 1;
  const positionsCenter = new import__41.Cartesian3(10000001, 0, 0);
  const center = new import__41.Cartesian3(1e7, 0, 0);
  function getPositions() {
    return [
      import__41.Cartesian3.add(center, new import__41.Cartesian3(1, 0, 0), new import__41.Cartesian3()),
      import__41.Cartesian3.add(center, new import__41.Cartesian3(2, 0, 0), new import__41.Cartesian3()),
      import__41.Cartesian3.add(center, new import__41.Cartesian3(0, 0, 0), new import__41.Cartesian3()),
      import__41.Cartesian3.add(center, new import__41.Cartesian3(1, 1, 0), new import__41.Cartesian3()),
      import__41.Cartesian3.add(center, new import__41.Cartesian3(1, -1, 0), new import__41.Cartesian3()),
      import__41.Cartesian3.add(center, new import__41.Cartesian3(1, 0, 1), new import__41.Cartesian3()),
      import__41.Cartesian3.add(center, new import__41.Cartesian3(1, 0, -1), new import__41.Cartesian3())
    ];
  }
  function getPositionsAsFlatArray() {
    const positions = getPositions();
    const result = [];
    for (let i = 0; i < positions.length; ++i) {
      result.push(positions[i].x);
      result.push(positions[i].y);
      result.push(positions[i].z);
    }
    return result;
  }
  function getPositionsAsFlatArrayWithStride5() {
    const positions = getPositions();
    const result = [];
    for (let i = 0; i < positions.length; ++i) {
      result.push(positions[i].x);
      result.push(positions[i].y);
      result.push(positions[i].z);
      result.push(1.23);
      result.push(4.56);
    }
    return result;
  }
  function getPositionsAsEncodedFlatArray() {
    const positions = getPositions();
    const high = [];
    const low = [];
    for (let i = 0; i < positions.length; ++i) {
      const encoded = import__41.EncodedCartesian3.fromCartesian(positions[i]);
      high.push(encoded.high.x);
      high.push(encoded.high.y);
      high.push(encoded.high.z);
      low.push(encoded.low.x);
      low.push(encoded.low.y);
      low.push(encoded.low.z);
    }
    return {
      high,
      low
    };
  }
  it("default constructing produces expected values", function() {
    const sphere = new import__41.BoundingSphere();
    expect(sphere.center).toEqual(import__41.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("constructor sets expected values", function() {
    const expectedCenter = new import__41.Cartesian3(1, 2, 3);
    const expectedRadius = 1;
    const sphere = new import__41.BoundingSphere(expectedCenter, expectedRadius);
    expect(sphere.center).toEqual(expectedCenter);
    expect(sphere.radius).toEqual(expectedRadius);
  });
  it("clone without a result parameter", function() {
    const sphere = new import__41.BoundingSphere(new import__41.Cartesian3(1, 2, 3), 4);
    const result = sphere.clone();
    expect(sphere).not.toBe(result);
    expect(sphere).toEqual(result);
  });
  it("clone with a result parameter", function() {
    const sphere = new import__41.BoundingSphere(new import__41.Cartesian3(1, 2, 3), 4);
    const result = new import__41.BoundingSphere();
    const returnedResult = sphere.clone(result);
    expect(result).not.toBe(sphere);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(sphere);
  });
  it('clone works with "this" result parameter', function() {
    const expectedCenter = new import__41.Cartesian3(1, 2, 3);
    const expectedRadius = 1;
    const sphere = new import__41.BoundingSphere(expectedCenter, expectedRadius);
    const returnedResult = sphere.clone(sphere);
    expect(sphere).toBe(returnedResult);
    expect(sphere.center).toEqual(expectedCenter);
    expect(sphere.radius).toEqual(expectedRadius);
  });
  it("clone clones undefined", function() {
    expect(import__41.BoundingSphere.clone(void 0)).toBe(void 0);
  });
  it("equals", function() {
    const sphere = new import__41.BoundingSphere(new import__41.Cartesian3(1, 2, 3), 4);
    expect(
      sphere.equals(new import__41.BoundingSphere(new import__41.Cartesian3(1, 2, 3), 4))
    ).toEqual(true);
    expect(
      sphere.equals(new import__41.BoundingSphere(new import__41.Cartesian3(5, 2, 3), 4))
    ).toEqual(false);
    expect(
      sphere.equals(new import__41.BoundingSphere(new import__41.Cartesian3(1, 6, 3), 4))
    ).toEqual(false);
    expect(
      sphere.equals(new import__41.BoundingSphere(new import__41.Cartesian3(1, 2, 7), 4))
    ).toEqual(false);
    expect(
      sphere.equals(new import__41.BoundingSphere(new import__41.Cartesian3(1, 2, 3), 8))
    ).toEqual(false);
    expect(sphere.equals(void 0)).toEqual(false);
  });
  it("fromPoints without positions returns an empty sphere", function() {
    const sphere = import__41.BoundingSphere.fromPoints();
    expect(sphere.center).toEqual(import__41.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromPoints works with one point", function() {
    const expectedCenter = new import__41.Cartesian3(1, 2, 3);
    const sphere = import__41.BoundingSphere.fromPoints([expectedCenter]);
    expect(sphere.center).toEqual(expectedCenter);
    expect(sphere.radius).toEqual(0);
  });
  it("fromPoints computes a center from points", function() {
    const sphere = import__41.BoundingSphere.fromPoints(getPositions());
    expect(sphere.center).toEqual(positionsCenter);
    expect(sphere.radius).toEqual(positionsRadius);
  });
  it("fromPoints contains all points (naive)", function() {
    const sphere = import__41.BoundingSphere.fromPoints(getPositions());
    const radius = sphere.radius;
    const center2 = sphere.center;
    const r = new import__41.Cartesian3(radius, radius, radius);
    const max = import__41.Cartesian3.add(r, center2, new import__41.Cartesian3());
    const min = import__41.Cartesian3.subtract(center2, r, new import__41.Cartesian3());
    const positions = getPositions();
    const numPositions = positions.length;
    for (let i = 0; i < numPositions; i++) {
      const currentPos = positions[i];
      expect(currentPos.x <= max.x && currentPos.x >= min.x).toEqual(true);
      expect(currentPos.y <= max.y && currentPos.y >= min.y).toEqual(true);
      expect(currentPos.z <= max.z && currentPos.z >= min.z).toEqual(true);
    }
  });
  it("fromPoints contains all points (ritter)", function() {
    const positions = getPositions();
    positions.push(
      new import__41.Cartesian3(1, 1, 1),
      new import__41.Cartesian3(2, 2, 2),
      new import__41.Cartesian3(3, 3, 3)
    );
    const sphere = import__41.BoundingSphere.fromPoints(positions);
    const radius = sphere.radius;
    const center2 = sphere.center;
    const r = new import__41.Cartesian3(radius, radius, radius);
    const max = import__41.Cartesian3.add(r, center2, new import__41.Cartesian3());
    const min = import__41.Cartesian3.subtract(center2, r, new import__41.Cartesian3());
    const numPositions = positions.length;
    for (let i = 0; i < numPositions; i++) {
      const currentPos = positions[i];
      expect(currentPos.x <= max.x && currentPos.x >= min.x).toEqual(true);
      expect(currentPos.y <= max.y && currentPos.y >= min.y).toEqual(true);
      expect(currentPos.z <= max.z && currentPos.z >= min.z).toEqual(true);
    }
  });
  it("fromVertices without positions returns an empty sphere", function() {
    const sphere = import__41.BoundingSphere.fromVertices();
    expect(sphere.center).toEqual(import__41.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromVertices works with one point", function() {
    const expectedCenter = new import__41.Cartesian3(1, 2, 3);
    const sphere = import__41.BoundingSphere.fromVertices([
      expectedCenter.x,
      expectedCenter.y,
      expectedCenter.z
    ]);
    expect(sphere.center).toEqual(expectedCenter);
    expect(sphere.radius).toEqual(0);
  });
  it("fromVertices computes a center from points", function() {
    const sphere = import__41.BoundingSphere.fromVertices(getPositionsAsFlatArray());
    expect(sphere.center).toEqual(positionsCenter);
    expect(sphere.radius).toEqual(positionsRadius);
  });
  it("fromVertices contains all points (naive)", function() {
    const sphere = import__41.BoundingSphere.fromVertices(getPositionsAsFlatArray());
    const radius = sphere.radius;
    const center2 = sphere.center;
    const r = new import__41.Cartesian3(radius, radius, radius);
    const max = import__41.Cartesian3.add(r, center2, new import__41.Cartesian3());
    const min = import__41.Cartesian3.subtract(center2, r, new import__41.Cartesian3());
    const positions = getPositions();
    const numPositions = positions.length;
    for (let i = 0; i < numPositions; i++) {
      const currentPos = positions[i];
      expect(currentPos.x <= max.x && currentPos.x >= min.x).toEqual(true);
      expect(currentPos.y <= max.y && currentPos.y >= min.y).toEqual(true);
      expect(currentPos.z <= max.z && currentPos.z >= min.z).toEqual(true);
    }
  });
  it("fromVertices contains all points (ritter)", function() {
    const positions = getPositionsAsFlatArray();
    positions.push(1, 1, 1, 2, 2, 2, 3, 3, 3);
    const sphere = import__41.BoundingSphere.fromVertices(positions);
    const radius = sphere.radius;
    const center2 = sphere.center;
    const r = new import__41.Cartesian3(radius, radius, radius);
    const max = import__41.Cartesian3.add(r, center2, new import__41.Cartesian3());
    const min = import__41.Cartesian3.subtract(center2, r, new import__41.Cartesian3());
    const numElements = positions.length;
    for (let i = 0; i < numElements; i += 3) {
      expect(positions[i] <= max.x && positions[i] >= min.x).toEqual(true);
      expect(positions[i + 1] <= max.y && positions[i + 1] >= min.y).toEqual(
        true
      );
      expect(positions[i + 2] <= max.z && positions[i + 2] >= min.z).toEqual(
        true
      );
    }
  });
  it("fromVertices works with a stride of 5", function() {
    const sphere = import__41.BoundingSphere.fromVertices(
      getPositionsAsFlatArrayWithStride5(),
      void 0,
      5
    );
    expect(sphere.center).toEqual(positionsCenter);
    expect(sphere.radius).toEqual(positionsRadius);
  });
  it("fromVertices works with defined center", function() {
    const center2 = new import__41.Cartesian3(1, 2, 3);
    const sphere = import__41.BoundingSphere.fromVertices(
      getPositionsAsFlatArrayWithStride5(),
      center2,
      5
    );
    expect(sphere.center).toEqual(
      import__41.Cartesian3.add(positionsCenter, center2, new import__41.Cartesian3())
    );
    expect(sphere.radius).toEqual(positionsRadius);
  });
  it("fromVertices requires a stride of at least 3", function() {
    function callWithStrideOf2() {
      import__41.BoundingSphere.fromVertices(getPositionsAsFlatArray(), void 0, 2);
    }
    expect(callWithStrideOf2).toThrowDeveloperError();
  });
  it("fromVertices fills result parameter if specified", function() {
    const center2 = new import__41.Cartesian3(1, 2, 3);
    const result = new import__41.BoundingSphere();
    const sphere = import__41.BoundingSphere.fromVertices(
      getPositionsAsFlatArrayWithStride5(),
      center2,
      5,
      result
    );
    expect(sphere).toEqual(result);
    expect(result.center).toEqual(
      import__41.Cartesian3.add(positionsCenter, center2, new import__41.Cartesian3())
    );
    expect(result.radius).toEqual(positionsRadius);
  });
  it("fromEncodedCartesianVertices without positions returns an empty sphere", function() {
    const sphere = import__41.BoundingSphere.fromEncodedCartesianVertices();
    expect(sphere.center).toEqual(import__41.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromEncodedCartesianVertices without positions of different lengths returns an empty sphere", function() {
    const positions = getPositionsAsEncodedFlatArray();
    positions.low.length = positions.low.length - 1;
    const sphere = import__41.BoundingSphere.fromEncodedCartesianVertices(
      positions.high,
      positions.low
    );
    expect(sphere.center).toEqual(import__41.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromEncodedCartesianVertices computes a center from points", function() {
    const positions = getPositionsAsEncodedFlatArray();
    const sphere = import__41.BoundingSphere.fromEncodedCartesianVertices(
      positions.high,
      positions.low
    );
    expect(sphere.center).toEqual(positionsCenter);
    expect(sphere.radius).toEqual(positionsRadius);
  });
  it("fromEncodedCartesianVertices contains all points (naive)", function() {
    let positions = getPositionsAsEncodedFlatArray();
    const sphere = import__41.BoundingSphere.fromEncodedCartesianVertices(
      positions.high,
      positions.low
    );
    const radius = sphere.radius;
    const center2 = sphere.center;
    const r = new import__41.Cartesian3(radius, radius, radius);
    const max = import__41.Cartesian3.add(r, center2, new import__41.Cartesian3());
    const min = import__41.Cartesian3.subtract(center2, r, new import__41.Cartesian3());
    positions = getPositions();
    const numPositions = positions.length;
    for (let i = 0; i < numPositions; i++) {
      const currentPos = positions[i];
      expect(currentPos.x <= max.x && currentPos.x >= min.x).toEqual(true);
      expect(currentPos.y <= max.y && currentPos.y >= min.y).toEqual(true);
      expect(currentPos.z <= max.z && currentPos.z >= min.z).toEqual(true);
    }
  });
  it("fromEncodedCartesianVertices contains all points (ritter)", function() {
    const positions = getPositionsAsEncodedFlatArray();
    const appendedPositions = [
      new import__41.Cartesian3(1, 1, 1),
      new import__41.Cartesian3(2, 2, 2),
      new import__41.Cartesian3(3, 3, 3)
    ];
    for (let j = 0; j < appendedPositions.length; ++j) {
      const encoded = import__41.EncodedCartesian3.fromCartesian(
        import__41.Cartesian3.add(appendedPositions[j], center, new import__41.Cartesian3())
      );
      positions.high.push(encoded.high.x);
      positions.high.push(encoded.high.y);
      positions.high.push(encoded.high.z);
      positions.low.push(encoded.low.x);
      positions.low.push(encoded.low.y);
      positions.low.push(encoded.low.z);
    }
    const sphere = import__41.BoundingSphere.fromEncodedCartesianVertices(
      positions.high,
      positions.low
    );
    const radius = sphere.radius;
    const sphereCenter = sphere.center;
    const r = new import__41.Cartesian3(radius, radius, radius);
    const max = import__41.Cartesian3.add(r, sphereCenter, new import__41.Cartesian3());
    const min = import__41.Cartesian3.subtract(sphereCenter, r, new import__41.Cartesian3());
    const numElements = positions.length;
    for (let i = 0; i < numElements; i += 3) {
      expect(positions[i] <= max.x && positions[i] >= min.x).toEqual(true);
      expect(positions[i + 1] <= max.y && positions[i + 1] >= min.y).toEqual(
        true
      );
      expect(positions[i + 2] <= max.z && positions[i + 2] >= min.z).toEqual(
        true
      );
    }
  });
  it("fromEncodedCartesianVertices fills result parameter if specified", function() {
    const positions = getPositionsAsEncodedFlatArray();
    const result = new import__41.BoundingSphere();
    const sphere = import__41.BoundingSphere.fromEncodedCartesianVertices(
      positions.high,
      positions.low,
      result
    );
    expect(sphere).toEqual(result);
    expect(result.center).toEqual(positionsCenter);
    expect(result.radius).toEqual(positionsRadius);
  });
  it("fromRectangle2D creates an empty sphere if no rectangle provided", function() {
    const sphere = import__41.BoundingSphere.fromRectangle2D();
    expect(sphere.center).toEqual(import__41.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromRectangle2D", function() {
    const rectangle = import__41.Rectangle.MAX_VALUE;
    const projection = new import__41.GeographicProjection(import__41.Ellipsoid.UNIT_SPHERE);
    const expected = new import__41.BoundingSphere(
      import__41.Cartesian3.ZERO,
      Math.sqrt(
        rectangle.east * rectangle.east + rectangle.north * rectangle.north
      )
    );
    expect(import__41.BoundingSphere.fromRectangle2D(rectangle, projection)).toEqual(
      expected
    );
  });
  it("fromRectangle3D creates an empty sphere if no rectangle provided", function() {
    const sphere = import__41.BoundingSphere.fromRectangle3D();
    expect(sphere.center).toEqual(import__41.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromRectangle3D", function() {
    const rectangle = import__41.Rectangle.MAX_VALUE;
    const ellipsoid = import__41.Ellipsoid.WGS84;
    const expected = new import__41.BoundingSphere(
      import__41.Cartesian3.ZERO,
      ellipsoid.maximumRadius
    );
    expect(import__41.BoundingSphere.fromRectangle3D(rectangle, ellipsoid)).toEqual(
      expected
    );
  });
  it("fromRectangle3D with height", function() {
    const rectangle = new import__41.Rectangle(0.1, -0.3, 0.2, -0.4);
    const height = 1e5;
    const ellipsoid = import__41.Ellipsoid.WGS84;
    const points = import__41.Rectangle.subsample(rectangle, ellipsoid, height);
    const expected = import__41.BoundingSphere.fromPoints(points);
    expect(
      import__41.BoundingSphere.fromRectangle3D(rectangle, ellipsoid, height)
    ).toEqual(expected);
  });
  it("fromCornerPoints", function() {
    const sphere = import__41.BoundingSphere.fromCornerPoints(
      new import__41.Cartesian3(-1, -0, 0),
      new import__41.Cartesian3(1, 0, 0)
    );
    expect(sphere).toEqual(new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 1));
  });
  it("fromCornerPoints with a result parameter", function() {
    const sphere = new import__41.BoundingSphere();
    const result = import__41.BoundingSphere.fromCornerPoints(
      new import__41.Cartesian3(0, -1, 0),
      new import__41.Cartesian3(0, 1, 0),
      sphere
    );
    expect(result).toBe(sphere);
    expect(result).toEqual(new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 1));
  });
  it("fromCornerPoints throws without corner", function() {
    expect(function() {
      import__41.BoundingSphere.fromCornerPoints();
    }).toThrowDeveloperError();
  });
  it("fromCornerPoints throws without oppositeCorner", function() {
    expect(function() {
      import__41.BoundingSphere.fromCornerPoints(import__41.Cartesian3.UNIT_X);
    }).toThrowDeveloperError();
  });
  it("fromEllipsoid", function() {
    const ellipsoid = import__41.Ellipsoid.WGS84;
    const sphere = import__41.BoundingSphere.fromEllipsoid(ellipsoid);
    expect(sphere.center).toEqual(import__41.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(ellipsoid.maximumRadius);
  });
  it("fromEllipsoid with a result parameter", function() {
    const ellipsoid = import__41.Ellipsoid.WGS84;
    const sphere = new import__41.BoundingSphere(new import__41.Cartesian3(1, 2, 3), 4);
    const result = import__41.BoundingSphere.fromEllipsoid(ellipsoid, sphere);
    expect(result).toBe(sphere);
    expect(result).toEqual(
      new import__41.BoundingSphere(import__41.Cartesian3.ZERO, ellipsoid.maximumRadius)
    );
  });
  it("fromEllipsoid throws without ellipsoid", function() {
    expect(function() {
      import__41.BoundingSphere.fromEllipsoid();
    }).toThrowDeveloperError();
  });
  it("fromBoundingSpheres with undefined returns an empty sphere", function() {
    const sphere = import__41.BoundingSphere.fromBoundingSpheres();
    expect(sphere.center).toEqual(import__41.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromBoundingSpheres with empty array returns an empty sphere", function() {
    const sphere = import__41.BoundingSphere.fromBoundingSpheres([]);
    expect(sphere.center).toEqual(import__41.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromBoundingSpheres works with 1 sphere", function() {
    const one = new import__41.BoundingSphere(new import__41.Cartesian3(1, 2, 3), 4);
    const sphere = import__41.BoundingSphere.fromBoundingSpheres([one]);
    expect(sphere).toEqual(one);
  });
  it("fromBoundingSpheres works with 2 spheres", function() {
    const one = new import__41.BoundingSphere(new import__41.Cartesian3(1, 2, 3), 4);
    const two = new import__41.BoundingSphere(new import__41.Cartesian3(5, 6, 7), 8);
    const sphere = import__41.BoundingSphere.fromBoundingSpheres([one, two]);
    expect(sphere).toEqual(
      import__41.BoundingSphere.union(one, two, new import__41.BoundingSphere())
    );
  });
  it("fromBoundingSpheres works with 3 spheres", function() {
    const one = new import__41.BoundingSphere(new import__41.Cartesian3(0, 0, 0), 1);
    const two = new import__41.BoundingSphere(new import__41.Cartesian3(0, 3, 0), 1);
    const three = new import__41.BoundingSphere(new import__41.Cartesian3(0, 0, 4), 1);
    const expected = new import__41.BoundingSphere(new import__41.Cartesian3(0, 1.5, 2), 3.5);
    const sphere = import__41.BoundingSphere.fromBoundingSpheres([one, two, three]);
    expect(sphere).toEqual(expected);
  });
  it("fromOrientedBoundingBox works with a result", function() {
    const box = import__41.OrientedBoundingBox.fromPoints(getPositions());
    const sphere = new import__41.BoundingSphere();
    import__41.BoundingSphere.fromOrientedBoundingBox(box, sphere);
    expect(sphere.center).toEqual(positionsCenter);
    expect(sphere.radius).toBeGreaterThan(1.5);
    expect(sphere.radius).toBeLessThan(2);
  });
  it("fromOrientedBoundingBox works without a result parameter", function() {
    const box = import__41.OrientedBoundingBox.fromPoints(getPositions());
    const sphere = import__41.BoundingSphere.fromOrientedBoundingBox(box);
    expect(sphere.center).toEqual(positionsCenter);
    expect(sphere.radius).toBeGreaterThan(1.5);
    expect(sphere.radius).toBeLessThan(2);
  });
  it("throws from fromOrientedBoundingBox with undefined orientedBoundingBox parameter", function() {
    expect(function() {
      import__41.BoundingSphere.fromOrientedBoundingBox(void 0);
    }).toThrowDeveloperError();
  });
  it("fromTransformation works with a result parameter", function() {
    const translation = new import__41.Cartesian3(1, 2, 3);
    const rotation = import__41.Quaternion.fromAxisAngle(import__41.Cartesian3.UNIT_Z, 0.4);
    const scale = new import__41.Cartesian3(1, 2, 3);
    const expectedRadius = 0.5 * import__41.Cartesian3.magnitude(scale);
    const transformation = import__41.Matrix4.fromTranslationQuaternionRotationScale(
      translation,
      rotation,
      scale
    );
    const sphere = new import__41.BoundingSphere();
    const result = import__41.BoundingSphere.fromTransformation(transformation, sphere);
    expect(result.center).toEqual(translation);
    expect(result.radius).toEqualEpsilon(expectedRadius, import__41.Math.EPSILON14);
    expect(result).toBe(sphere);
  });
  it("fromTransformation works without a result parameter", function() {
    const translation = new import__41.Cartesian3(1, 2, 3);
    const rotation = import__41.Quaternion.fromAxisAngle(import__41.Cartesian3.UNIT_Z, 0.4);
    const scale = new import__41.Cartesian3(1, 2, 3);
    const expectedRadius = 0.5 * import__41.Cartesian3.magnitude(scale);
    const transformation = import__41.Matrix4.fromTranslationQuaternionRotationScale(
      translation,
      rotation,
      scale
    );
    const sphere = import__41.BoundingSphere.fromTransformation(transformation);
    expect(sphere.center).toEqual(translation);
    expect(sphere.radius).toEqualEpsilon(expectedRadius, import__41.Math.EPSILON14);
  });
  it("fromTransformation works with a transformation that has zero scale", function() {
    const transformation = import__41.Matrix4.fromScale(import__41.Cartesian3.ZERO);
    const sphere = import__41.BoundingSphere.fromTransformation(transformation);
    expect(sphere.center).toEqual(import__41.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("throws from fromTransformation with undefined transformation parameter", function() {
    expect(function() {
      import__41.BoundingSphere.fromTransformation(void 0);
    }).toThrowDeveloperError();
  });
  it("intersectPlane with sphere on the positive side of a plane", function() {
    const sphere = new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 0.5);
    const normal = import__41.Cartesian3.negate(import__41.Cartesian3.UNIT_X, new import__41.Cartesian3());
    const position = import__41.Cartesian3.UNIT_X;
    const plane = new import__41.Plane(normal, -import__41.Cartesian3.dot(normal, position));
    expect(sphere.intersectPlane(plane)).toEqual(import__41.Intersect.INSIDE);
  });
  it("intersectPlane with sphere on the negative side of a plane", function() {
    const sphere = new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 0.5);
    const normal = import__41.Cartesian3.UNIT_X;
    const position = import__41.Cartesian3.UNIT_X;
    const plane = new import__41.Plane(normal, -import__41.Cartesian3.dot(normal, position));
    expect(sphere.intersectPlane(plane)).toEqual(import__41.Intersect.OUTSIDE);
  });
  it("intersectPlane with sphere intersecting a plane", function() {
    const sphere = new import__41.BoundingSphere(import__41.Cartesian3.UNIT_X, 0.5);
    const normal = import__41.Cartesian3.UNIT_X;
    const position = import__41.Cartesian3.UNIT_X;
    const plane = new import__41.Plane(normal, -import__41.Cartesian3.dot(normal, position));
    expect(sphere.intersectPlane(plane)).toEqual(import__41.Intersect.INTERSECTING);
  });
  it("expands to contain another sphere", function() {
    const bs1 = new import__41.BoundingSphere(
      import__41.Cartesian3.negate(import__41.Cartesian3.UNIT_X, new import__41.Cartesian3()),
      1
    );
    const bs2 = new import__41.BoundingSphere(import__41.Cartesian3.UNIT_X, 1);
    const expected = new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 2);
    expect(import__41.BoundingSphere.union(bs1, bs2)).toEqual(expected);
  });
  it("union left sphere encloses right", function() {
    const bs1 = new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 3);
    const bs2 = new import__41.BoundingSphere(import__41.Cartesian3.UNIT_X, 1);
    const union = import__41.BoundingSphere.union(bs1, bs2);
    expect(union).toEqual(bs1);
  });
  it("union of co-located spheres, right sphere encloses left", function() {
    const bs1 = new import__41.BoundingSphere(import__41.Cartesian3.UNIT_X, 1);
    const bs2 = new import__41.BoundingSphere(import__41.Cartesian3.UNIT_X, 2);
    const union = import__41.BoundingSphere.union(bs1, bs2);
    expect(union).toEqual(bs2);
  });
  it("union result parameter is a tight fit", function() {
    const bs1 = new import__41.BoundingSphere(
      import__41.Cartesian3.multiplyByScalar(
        import__41.Cartesian3.negate(import__41.Cartesian3.UNIT_X, new import__41.Cartesian3()),
        3,
        new import__41.Cartesian3()
      ),
      3
    );
    const bs2 = new import__41.BoundingSphere(import__41.Cartesian3.UNIT_X, 1);
    const expected = new import__41.BoundingSphere(
      import__41.Cartesian3.multiplyByScalar(
        import__41.Cartesian3.negate(import__41.Cartesian3.UNIT_X, new import__41.Cartesian3()),
        2,
        new import__41.Cartesian3()
      ),
      4
    );
    import__41.BoundingSphere.union(bs1, bs2, bs1);
    expect(bs1).toEqual(expected);
  });
  it("expands to contain another point", function() {
    const bs = new import__41.BoundingSphere(
      import__41.Cartesian3.negate(import__41.Cartesian3.UNIT_X, new import__41.Cartesian3()),
      1
    );
    const point = import__41.Cartesian3.UNIT_X;
    const expected = new import__41.BoundingSphere(
      import__41.Cartesian3.negate(import__41.Cartesian3.UNIT_X, new import__41.Cartesian3()),
      2
    );
    expect(import__41.BoundingSphere.expand(bs, point)).toEqual(expected);
  });
  it("applies transform", function() {
    const bs = new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 1);
    const transform = import__41.Matrix4.fromTranslation(new import__41.Cartesian3(1, 2, 3));
    const expected = new import__41.BoundingSphere(new import__41.Cartesian3(1, 2, 3), 1);
    expect(import__41.BoundingSphere.transform(bs, transform)).toEqual(expected);
  });
  it("applies scale transform", function() {
    const bs = new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 1);
    const transform = import__41.Matrix4.fromScale(new import__41.Cartesian3(1, 2, 3));
    const expected = new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 3);
    expect(import__41.BoundingSphere.transform(bs, transform)).toEqual(expected);
  });
  it("applies transform without scale", function() {
    const bs = new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 1);
    const transform = import__41.Matrix4.fromTranslation(new import__41.Cartesian3(1, 2, 3));
    const expected = new import__41.BoundingSphere(new import__41.Cartesian3(1, 2, 3), 1);
    expect(import__41.BoundingSphere.transformWithoutScale(bs, transform)).toEqual(
      expected
    );
  });
  it("transformWithoutScale ignores scale", function() {
    const bs = new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 1);
    const transform = import__41.Matrix4.fromScale(new import__41.Cartesian3(1, 2, 3));
    const expected = new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 1);
    expect(import__41.BoundingSphere.transformWithoutScale(bs, transform)).toEqual(
      expected
    );
  });
  it("finds distances", function() {
    const bs = new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 1);
    const position = new import__41.Cartesian3(-2, 1, 0);
    const direction = import__41.Cartesian3.UNIT_X;
    const expected = new import__41.Interval(1, 3);
    expect(
      import__41.BoundingSphere.computePlaneDistances(bs, position, direction)
    ).toEqual(expected);
  });
  it("distance squared to point outside of sphere", function() {
    const bs = new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 1);
    const position = new import__41.Cartesian3(-2, 1, 0);
    const expected = 1.52786405;
    expect(import__41.BoundingSphere.distanceSquaredTo(bs, position)).toEqualEpsilon(
      expected,
      import__41.Math.EPSILON6
    );
  });
  it("distance squared to point inside sphere", function() {
    const bs = new import__41.BoundingSphere(import__41.Cartesian3.ZERO, 1);
    const position = new import__41.Cartesian3(-0.5, 0.5, 0);
    expect(import__41.BoundingSphere.distanceSquaredTo(bs, position)).toEqual(0);
  });
  it("projectTo2D", function() {
    const positions = getPositions();
    const projection = new import__41.GeographicProjection();
    const positions2D = [];
    for (let i = 0; i < positions.length; ++i) {
      const position = positions[i];
      const cartographic = projection.ellipsoid.cartesianToCartographic(
        position
      );
      positions2D.push(projection.project(cartographic));
    }
    const boundingSphere3D = import__41.BoundingSphere.fromPoints(positions);
    const boundingSphere2D = import__41.BoundingSphere.projectTo2D(
      boundingSphere3D,
      projection
    );
    const actualSphere = import__41.BoundingSphere.fromPoints(positions2D);
    actualSphere.center = new import__41.Cartesian3(
      actualSphere.center.z,
      actualSphere.center.x,
      actualSphere.center.y
    );
    expect(boundingSphere2D.center).toEqualEpsilon(
      actualSphere.center,
      import__41.Math.EPSILON6
    );
    expect(boundingSphere2D.radius).toBeGreaterThan(actualSphere.radius);
  });
  it("projectTo2D with result parameter", function() {
    const positions = getPositions();
    const projection = new import__41.GeographicProjection();
    const sphere = new import__41.BoundingSphere();
    const positions2D = [];
    for (let i = 0; i < positions.length; ++i) {
      const position = positions[i];
      const cartographic = projection.ellipsoid.cartesianToCartographic(
        position
      );
      positions2D.push(projection.project(cartographic));
    }
    const boundingSphere3D = import__41.BoundingSphere.fromPoints(positions);
    const boundingSphere2D = import__41.BoundingSphere.projectTo2D(
      boundingSphere3D,
      projection,
      sphere
    );
    const actualSphere = import__41.BoundingSphere.fromPoints(positions2D);
    actualSphere.center = new import__41.Cartesian3(
      actualSphere.center.z,
      actualSphere.center.x,
      actualSphere.center.y
    );
    expect(boundingSphere2D).toBe(sphere);
    expect(boundingSphere2D.center).toEqualEpsilon(
      actualSphere.center,
      import__41.Math.EPSILON6
    );
    expect(boundingSphere2D.radius).toBeGreaterThan(actualSphere.radius);
  });
  it("can pack and unpack", function() {
    const array = [];
    const boundingSphere = new import__41.BoundingSphere();
    boundingSphere.center = new import__41.Cartesian3(1, 2, 3);
    boundingSphere.radius = 4;
    import__41.BoundingSphere.pack(boundingSphere, array);
    expect(array.length).toEqual(import__41.BoundingSphere.packedLength);
    expect(import__41.BoundingSphere.unpack(array)).toEqual(boundingSphere);
  });
  it("can pack and unpack with offset", function() {
    const packed = new Array(3);
    const offset = 3;
    const boundingSphere = new import__41.BoundingSphere();
    boundingSphere.center = new import__41.Cartesian3(1, 2, 3);
    boundingSphere.radius = 4;
    import__41.BoundingSphere.pack(boundingSphere, packed, offset);
    expect(packed.length).toEqual(offset + import__41.BoundingSphere.packedLength);
    const result = new import__41.BoundingSphere();
    const returnedResult = import__41.BoundingSphere.unpack(packed, offset, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqual(boundingSphere);
  });
  it("pack throws with undefined boundingSphere", function() {
    const array = [];
    expect(function() {
      import__41.BoundingSphere.pack(void 0, array);
    }).toThrowDeveloperError();
  });
  it("pack throws with undefined array", function() {
    const boundingSphere = new import__41.BoundingSphere();
    expect(function() {
      import__41.BoundingSphere.pack(boundingSphere, void 0);
    }).toThrowDeveloperError();
  });
  it("unpack throws with undefined array", function() {
    expect(function() {
      import__41.BoundingSphere.unpack(void 0);
    }).toThrowDeveloperError();
  });
  it("static projectTo2D throws without sphere", function() {
    expect(function() {
      import__41.BoundingSphere.projectTo2D();
    }).toThrowDeveloperError();
  });
  it("clone returns undefined with no parameter", function() {
    expect(import__41.BoundingSphere.clone()).toBeUndefined();
  });
  it("union throws with no left parameter", function() {
    const right = new import__41.BoundingSphere();
    expect(function() {
      import__41.BoundingSphere.union(void 0, right);
    }).toThrowDeveloperError();
  });
  it("union throws with no right parameter", function() {
    const left = new import__41.BoundingSphere();
    expect(function() {
      import__41.BoundingSphere.union(left, void 0);
    }).toThrowDeveloperError();
  });
  it("expand throws without a sphere", function() {
    const plane = new import__41.Cartesian3();
    expect(function() {
      import__41.BoundingSphere.expand(void 0, plane);
    }).toThrowDeveloperError();
  });
  it("expand throws without a point", function() {
    const sphere = new import__41.BoundingSphere();
    expect(function() {
      import__41.BoundingSphere.expand(sphere, void 0);
    }).toThrowDeveloperError();
  });
  it("intersectPlane throws without a sphere", function() {
    const plane = new import__41.Plane(import__41.Cartesian3.UNIT_X, 0);
    expect(function() {
      import__41.BoundingSphere.intersectPlane(void 0, plane);
    }).toThrowDeveloperError();
  });
  it("intersectPlane throws without a plane", function() {
    const sphere = new import__41.BoundingSphere();
    expect(function() {
      import__41.BoundingSphere.intersectPlane(sphere, void 0);
    }).toThrowDeveloperError();
  });
  it("transform throws without a sphere", function() {
    expect(function() {
      import__41.BoundingSphere.transform();
    }).toThrowDeveloperError();
  });
  it("transform throws without a transform", function() {
    const sphere = new import__41.BoundingSphere();
    expect(function() {
      import__41.BoundingSphere.transform(sphere);
    }).toThrowDeveloperError();
  });
  it("distanceSquaredTo throws without a sphere", function() {
    expect(function() {
      import__41.BoundingSphere.distanceSquaredTo();
    }).toThrowDeveloperError();
  });
  it("distanceSquaredTo throws without a cartesian", function() {
    expect(function() {
      import__41.BoundingSphere.distanceSquaredTo(new import__41.BoundingSphere());
    }).toThrowDeveloperError();
  });
  it("transformWithoutScale throws without a sphere", function() {
    expect(function() {
      import__41.BoundingSphere.transformWithoutScale();
    }).toThrowDeveloperError();
  });
  it("transformWithoutScale throws without a transform", function() {
    const sphere = new import__41.BoundingSphere();
    expect(function() {
      import__41.BoundingSphere.transformWithoutScale(sphere);
    }).toThrowDeveloperError();
  });
  it("computePlaneDistances throws without a sphere", function() {
    expect(function() {
      import__41.BoundingSphere.computePlaneDistances();
    }).toThrowDeveloperError();
  });
  it("computePlaneDistances throws without a position", function() {
    expect(function() {
      import__41.BoundingSphere.computePlaneDistances(new import__41.BoundingSphere());
    }).toThrowDeveloperError();
  });
  it("computePlaneDistances throws without a direction", function() {
    expect(function() {
      import__41.BoundingSphere.computePlaneDistances(
        new import__41.BoundingSphere(),
        new import__41.Cartesian3()
      );
    }).toThrowDeveloperError();
  });
  it("isOccluded throws without a sphere", function() {
    expect(function() {
      import__41.BoundingSphere.isOccluded();
    }).toThrowDeveloperError();
  });
  it("isOccluded throws without an occluder", function() {
    expect(function() {
      import__41.BoundingSphere.isOccluded(new import__41.BoundingSphere());
    }).toThrowDeveloperError();
  });
  function expectBoundingSphereToContainPoint(boundingSphere, point, projection) {
    const pointInCartesian = projection.project(point);
    let distanceFromCenter = import__41.Cartesian3.magnitude(
      import__41.Cartesian3.subtract(
        pointInCartesian,
        boundingSphere.center,
        new import__41.Cartesian3()
      )
    );
    distanceFromCenter -= import__41.Math.EPSILON9;
    expect(distanceFromCenter).toBeLessThanOrEqual(boundingSphere.radius);
  }
  it("fromRectangleWithHeights2D includes specified min and max heights", function() {
    const rectangle = new import__41.Rectangle(0.1, 0.5, 0.2, 0.6);
    const projection = new import__41.GeographicProjection();
    const minHeight = -327;
    const maxHeight = 2456;
    const boundingSphere = import__41.BoundingSphere.fromRectangleWithHeights2D(
      rectangle,
      projection,
      minHeight,
      maxHeight
    );
    let point = import__41.Rectangle.southwest(rectangle).clone();
    point.height = minHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__41.Rectangle.southwest(rectangle).clone();
    point.height = maxHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__41.Rectangle.northeast(rectangle).clone();
    point.height = minHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__41.Rectangle.northeast(rectangle).clone();
    point.height = maxHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__41.Rectangle.southeast(rectangle).clone();
    point.height = minHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__41.Rectangle.southeast(rectangle).clone();
    point.height = maxHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__41.Rectangle.northwest(rectangle).clone();
    point.height = minHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__41.Rectangle.northwest(rectangle).clone();
    point.height = maxHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__41.Rectangle.center(rectangle).clone();
    point.height = minHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__41.Rectangle.center(rectangle).clone();
    point.height = maxHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__41.Cartographic(
      import__41.Rectangle.center(rectangle).longitude,
      rectangle.south,
      minHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__41.Cartographic(
      import__41.Rectangle.center(rectangle).longitude,
      rectangle.south,
      maxHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__41.Cartographic(
      import__41.Rectangle.center(rectangle).longitude,
      rectangle.north,
      minHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__41.Cartographic(
      import__41.Rectangle.center(rectangle).longitude,
      rectangle.north,
      maxHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__41.Cartographic(
      rectangle.west,
      import__41.Rectangle.center(rectangle).latitude,
      minHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__41.Cartographic(
      rectangle.west,
      import__41.Rectangle.center(rectangle).latitude,
      maxHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__41.Cartographic(
      rectangle.east,
      import__41.Rectangle.center(rectangle).latitude,
      minHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__41.Cartographic(
      rectangle.east,
      import__41.Rectangle.center(rectangle).latitude,
      maxHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
  });
  it("computes the volume of a BoundingSphere", function() {
    const sphere = new import__41.BoundingSphere(new import__41.Cartesian3(), 1);
    const computedVolume = sphere.volume();
    const expectedVolume = 4 / 3 * import__41.Math.PI;
    expect(computedVolume).toEqualEpsilon(expectedVolume, import__41.Math.EPSILON6);
  });
  createPackableSpecs_default(
    import__41.BoundingSphere,
    new import__41.BoundingSphere(new import__41.Cartesian3(1, 2, 3), 4),
    [1, 2, 3, 4]
  );
});

// packages/engine/Specs/Core/BoxGeometrySpec.js
var import__42 = __toESM(require_Cesium(), 1);
describe("Core/BoxGeometry", function() {
  it("constructor throws without maximum corner", function() {
    expect(function() {
      return new import__42.BoxGeometry({
        maximum: new import__42.Cartesian3()
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws without minimum corner", function() {
    expect(function() {
      return new import__42.BoxGeometry({
        minimum: new import__42.Cartesian3()
      });
    }).toThrowDeveloperError();
  });
  it("constructor creates optimized number of positions for VertexFormat.POSITIONS_ONLY", function() {
    const m = import__42.BoxGeometry.createGeometry(
      new import__42.BoxGeometry({
        minimum: new import__42.Cartesian3(-1, -2, -3),
        maximum: new import__42.Cartesian3(1, 2, 3),
        vertexFormat: import__42.VertexFormat.POSITION_ONLY
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(12 * 3);
  });
  it("constructor computes all vertex attributes", function() {
    const minimumCorner = new import__42.Cartesian3(0, 0, 0);
    const maximumCorner = new import__42.Cartesian3(1, 1, 1);
    const m = import__42.BoxGeometry.createGeometry(
      new import__42.BoxGeometry({
        minimum: minimumCorner,
        maximum: maximumCorner,
        vertexFormat: import__42.VertexFormat.ALL
      })
    );
    const numVertices = 24;
    const numTriangles = 12;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.attributes.normal.values.length).toEqual(numVertices * 3);
    expect(m.attributes.tangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.bitangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.st.values.length).toEqual(numVertices * 2);
    expect(m.indices.length).toEqual(numTriangles * 3);
    expect(m.boundingSphere.center).toEqual(import__42.Cartesian3.ZERO);
    expect(m.boundingSphere.radius).toEqual(
      import__42.Cartesian3.magnitude(maximumCorner) * 0.5
    );
  });
  it("computes offset attribute", function() {
    const m = import__42.BoxGeometry.createGeometry(
      new import__42.BoxGeometry({
        minimum: new import__42.Cartesian3(-1, -2, -3),
        maximum: new import__42.Cartesian3(1, 2, 3),
        vertexFormat: import__42.VertexFormat.POSITION_ONLY,
        offsetAttribute: import__42.GeometryOffsetAttribute.ALL
      })
    );
    const numVertices = 8;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("fromDimensions throws without dimensions", function() {
    expect(function() {
      return import__42.BoxGeometry.fromDimensions();
    }).toThrowDeveloperError();
  });
  it("fromDimensions throws with negative dimensions", function() {
    expect(function() {
      return import__42.BoxGeometry.fromDimensions({
        dimensions: new import__42.Cartesian3(1, 2, -1)
      });
    }).toThrowDeveloperError();
  });
  it("fromDimensions", function() {
    const m = import__42.BoxGeometry.createGeometry(
      import__42.BoxGeometry.fromDimensions({
        dimensions: new import__42.Cartesian3(1, 2, 3),
        vertexFormat: import__42.VertexFormat.POSITION_ONLY
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(12 * 3);
  });
  it("fromAxisAlignedBoundingBox throws with no boundingBox", function() {
    expect(function() {
      return import__42.BoxGeometry.fromAxisAlignedBoundingBox(void 0);
    }).toThrowDeveloperError();
  });
  it("fromAxisAlignedBoundingBox", function() {
    const min = new import__42.Cartesian3(-1, -2, -3);
    const max = new import__42.Cartesian3(1, 2, 3);
    const m = import__42.BoxGeometry.fromAxisAlignedBoundingBox(
      new import__42.AxisAlignedBoundingBox(min, max)
    );
    expect(m._minimum).toEqual(min);
    expect(m._maximum).toEqual(max);
  });
  it("undefined is returned if min and max are equal", function() {
    const box = new import__42.BoxGeometry({
      vertexFormat: import__42.VertexFormat.POSITION_ONLY,
      maximum: new import__42.Cartesian3(25e4, 25e4, 25e4),
      minimum: new import__42.Cartesian3(25e4, 25e4, 25e4)
    });
    const geometry = import__42.BoxGeometry.createGeometry(box);
    expect(geometry).toBeUndefined();
  });
  createPackableSpecs_default(
    import__42.BoxGeometry,
    new import__42.BoxGeometry({
      minimum: new import__42.Cartesian3(1, 2, 3),
      maximum: new import__42.Cartesian3(4, 5, 6),
      vertexFormat: import__42.VertexFormat.POSITION_AND_NORMAL
    }),
    [1, 2, 3, 4, 5, 6, 1, 1, 0, 0, 0, 0, -1]
  );
});

// packages/engine/Specs/Core/BoxOutlineGeometrySpec.js
var import__43 = __toESM(require_Cesium(), 1);
describe("Core/BoxOutlineGeometry", function() {
  it("constructor throws without maximum corner", function() {
    expect(function() {
      return new import__43.BoxOutlineGeometry({
        maximum: new import__43.Cartesian3()
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws without minimum corner", function() {
    expect(function() {
      return new import__43.BoxOutlineGeometry({
        minimum: new import__43.Cartesian3()
      });
    }).toThrowDeveloperError();
  });
  it("constructor creates positions", function() {
    const m = import__43.BoxOutlineGeometry.createGeometry(
      new import__43.BoxOutlineGeometry({
        minimum: new import__43.Cartesian3(-1, -2, -3),
        maximum: new import__43.Cartesian3(1, 2, 3)
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(12 * 2);
  });
  it("computes offset attribute", function() {
    const m = import__43.BoxOutlineGeometry.createGeometry(
      new import__43.BoxOutlineGeometry({
        minimum: new import__43.Cartesian3(-1, -2, -3),
        maximum: new import__43.Cartesian3(1, 2, 3),
        offsetAttribute: import__43.GeometryOffsetAttribute.ALL
      })
    );
    const numVertices = 8;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("fromDimensions throws without dimensions", function() {
    expect(function() {
      return import__43.BoxOutlineGeometry.fromDimensions();
    }).toThrowDeveloperError();
  });
  it("fromDimensions throws with negative dimensions", function() {
    expect(function() {
      return import__43.BoxOutlineGeometry.fromDimensions({
        dimensions: new import__43.Cartesian3(1, 2, -1)
      });
    }).toThrowDeveloperError();
  });
  it("fromDimensions", function() {
    const m = import__43.BoxOutlineGeometry.createGeometry(
      import__43.BoxOutlineGeometry.fromDimensions({
        dimensions: new import__43.Cartesian3(1, 2, 3)
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(12 * 2);
  });
  it("fromAxisAlignedBoundingBox throws with no boundingBox", function() {
    expect(function() {
      return import__43.BoxOutlineGeometry.fromAxisAlignedBoundingBox(void 0);
    }).toThrowDeveloperError();
  });
  it("fromAxisAlignedBoundingBox", function() {
    const min = new import__43.Cartesian3(-1, -2, -3);
    const max = new import__43.Cartesian3(1, 2, 3);
    const m = import__43.BoxOutlineGeometry.fromAxisAlignedBoundingBox(
      new import__43.AxisAlignedBoundingBox(min, max)
    );
    expect(m._min).toEqual(min);
    expect(m._max).toEqual(max);
  });
  it("undefined is returned if min and max are equal", function() {
    const box = new import__43.BoxOutlineGeometry({
      maximum: new import__43.Cartesian3(25e4, 25e4, 25e4),
      minimum: new import__43.Cartesian3(25e4, 25e4, 25e4)
    });
    const geometry = import__43.BoxOutlineGeometry.createGeometry(box);
    expect(geometry).toBeUndefined();
  });
  createPackableSpecs_default(
    import__43.BoxOutlineGeometry,
    new import__43.BoxOutlineGeometry({
      minimum: new import__43.Cartesian3(1, 2, 3),
      maximum: new import__43.Cartesian3(4, 5, 6)
    }),
    [1, 2, 3, 4, 5, 6, -1]
  );
});

// packages/engine/Specs/Core/Cartesian2Spec.js
var import__44 = __toESM(require_Cesium(), 1);

// Specs/createPackableArraySpecs.js
var import_engine9 = __toESM(require_Cesium(), 1);
function createPackableArraySpecs(packable, unpackedArray, packedArray, stride, namePrefix) {
  namePrefix = (0, import_engine9.defaultValue)(namePrefix, "");
  it(`${namePrefix} can pack`, function() {
    const actualPackedArray = packable.packArray(unpackedArray);
    expect(actualPackedArray.length).toEqual(packedArray.length);
    expect(actualPackedArray).toEqual(packedArray);
  });
  it(`${namePrefix} can roundtrip`, function() {
    const actualPackedArray = packable.packArray(unpackedArray);
    const result = packable.unpackArray(actualPackedArray);
    expect(result).toEqual(unpackedArray);
  });
  it(`${namePrefix} can unpack`, function() {
    const result = packable.unpackArray(packedArray);
    expect(result).toEqual(unpackedArray);
  });
  it(`${namePrefix} packArray works with typed arrays`, function() {
    const typedArray = new Float64Array(packedArray.length);
    const result = packable.packArray(unpackedArray, typedArray);
    expect(result).toEqual(new Float64Array(packedArray));
  });
  it(`${namePrefix} packArray resizes arrays as needed`, function() {
    const emptyArray = [];
    let result = packable.packArray(unpackedArray, emptyArray);
    expect(result).toEqual(packedArray);
    const largerArray = new Array(packedArray.length + 1).fill(0);
    result = packable.packArray(unpackedArray, largerArray);
    expect(result).toEqual(packedArray);
  });
  it(`${namePrefix} packArray throws with undefined array`, function() {
    expect(function() {
      packable.packArray(void 0);
    }).toThrowDeveloperError();
  });
  it(`${namePrefix} packArray throws for typed arrays of the wrong size`, function() {
    expect(function() {
      const tooSmall = new Float64Array(0);
      packable.packArray(unpackedArray, tooSmall);
    }).toThrowDeveloperError();
    expect(function() {
      const tooBig = new Float64Array(10);
      packable.packArray(unpackedArray, tooBig);
    }).toThrowDeveloperError();
  });
  it(`${namePrefix} unpackArray works for typed arrays`, function() {
    const array = packable.unpackArray(new Float64Array(packedArray));
    expect(array).toEqual(unpackedArray);
  });
  it(`${namePrefix} unpackArray throws with undefined array`, function() {
    expect(function() {
      packable.unpackArray(void 0);
    }).toThrowDeveloperError();
  });
  it(`${namePrefix} unpackArray works with a result parameter`, function() {
    let array = [];
    let result = packable.unpackArray(packedArray, array);
    expect(result).toBe(array);
    expect(result).toEqual(unpackedArray);
    const PackableClass = packable;
    array = new Array(unpackedArray.length);
    for (let i = 0; i < unpackedArray.length; i++) {
      array[i] = new PackableClass();
    }
    result = packable.unpackArray(packedArray, array);
    expect(result).toBe(array);
    expect(result).toEqual(unpackedArray);
  });
  it(`${namePrefix} unpackArray throws with array less than the minimum length`, function() {
    expect(function() {
      packable.unpackArray([1]);
    }).toThrowDeveloperError();
  });
  it("unpackArray throws with array not multiple of stride", function() {
    expect(function() {
      packable.unpackArray(new Array(stride + 1).fill(1));
    }).toThrowDeveloperError();
  });
}
var createPackableArraySpecs_default = createPackableArraySpecs;

// packages/engine/Specs/Core/Cartesian2Spec.js
describe("Core/Cartesian2", function() {
  it("construct with default values", function() {
    const cartesian = new import__44.Cartesian2();
    expect(cartesian.x).toEqual(0);
    expect(cartesian.y).toEqual(0);
  });
  it("construct with only an x value", function() {
    const cartesian = new import__44.Cartesian2(1);
    expect(cartesian.x).toEqual(1);
    expect(cartesian.y).toEqual(0);
  });
  it("construct with all values", function() {
    const cartesian = new import__44.Cartesian2(1, 2);
    expect(cartesian.x).toEqual(1);
    expect(cartesian.y).toEqual(2);
  });
  it("fromArray creates a Cartesian2", function() {
    let cartesian = new import__44.Cartesian2();
    cartesian = import__44.Cartesian2.fromArray([1, 2]);
    expect(cartesian).toEqual(new import__44.Cartesian2(1, 2));
  });
  it("fromArray with an offset creates a Cartesian2", function() {
    let cartesian = new import__44.Cartesian2();
    cartesian = import__44.Cartesian2.fromArray([0, 1, 2, 0], 1);
    expect(cartesian).toEqual(new import__44.Cartesian2(1, 2));
  });
  it("fromArray throws without values", function() {
    expect(function() {
      import__44.Cartesian2.fromArray();
    }).toThrowDeveloperError();
  });
  it("clone with a result parameter", function() {
    const cartesian = new import__44.Cartesian2(1, 2);
    const result = new import__44.Cartesian2();
    const returnedResult = import__44.Cartesian2.clone(cartesian, result);
    expect(cartesian).not.toBe(result);
    expect(result).toBe(returnedResult);
    expect(cartesian).toEqual(result);
  });
  it("clone works with a result parameter that is an input parameter", function() {
    const cartesian = new import__44.Cartesian2(1, 2);
    const returnedResult = import__44.Cartesian2.clone(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
  });
  it("maximumComponent works when X is greater", function() {
    const cartesian = new import__44.Cartesian2(2, 1);
    expect(import__44.Cartesian2.maximumComponent(cartesian)).toEqual(cartesian.x);
  });
  it("maximumComponent works when Y is greater", function() {
    const cartesian = new import__44.Cartesian2(1, 2);
    expect(import__44.Cartesian2.maximumComponent(cartesian)).toEqual(cartesian.y);
  });
  it("minimumComponent works when X is lesser", function() {
    const cartesian = new import__44.Cartesian2(1, 2);
    expect(import__44.Cartesian2.minimumComponent(cartesian)).toEqual(cartesian.x);
  });
  it("minimumComponent works when Y is lesser", function() {
    const cartesian = new import__44.Cartesian2(2, 1);
    expect(import__44.Cartesian2.minimumComponent(cartesian)).toEqual(cartesian.y);
  });
  it("minimumByComponent", function() {
    let first;
    let second;
    let expected;
    const result = new import__44.Cartesian2();
    first = new import__44.Cartesian2(2, 0);
    second = new import__44.Cartesian2(1, 0);
    expected = new import__44.Cartesian2(1, 0);
    expect(import__44.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__44.Cartesian2(1, 0);
    second = new import__44.Cartesian2(2, 0);
    expected = new import__44.Cartesian2(1, 0);
    expect(import__44.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__44.Cartesian2(2, -15);
    second = new import__44.Cartesian2(1, -20);
    expected = new import__44.Cartesian2(1, -20);
    expect(import__44.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__44.Cartesian2(2, -20);
    second = new import__44.Cartesian2(1, -15);
    expected = new import__44.Cartesian2(1, -20);
    expect(import__44.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__44.Cartesian2(2, -15);
    second = new import__44.Cartesian2(1, -20);
    expected = new import__44.Cartesian2(1, -20);
    expect(import__44.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__44.Cartesian2(2, -15);
    second = new import__44.Cartesian2(1, -20);
    expected = new import__44.Cartesian2(1, -20);
    expect(import__44.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent with a result parameter", function() {
    const first = new import__44.Cartesian2(2, 0);
    const second = new import__44.Cartesian2(1, 0);
    const expected = new import__44.Cartesian2(1, 0);
    const result = new import__44.Cartesian2();
    const returnedResult = import__44.Cartesian2.minimumByComponent(first, second, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("minimumByComponent with a result parameter that is an input parameter", function() {
    const first = new import__44.Cartesian2(2, 0);
    const second = new import__44.Cartesian2(1, 0);
    const expected = new import__44.Cartesian2(1, 0);
    expect(import__44.Cartesian2.minimumByComponent(first, second, first)).toEqual(
      expected
    );
    first.x = 1;
    second.x = 2;
    expect(import__44.Cartesian2.minimumByComponent(first, second, second)).toEqual(
      expected
    );
  });
  it("minimumByComponent throws without first", function() {
    expect(function() {
      import__44.Cartesian2.minimumByComponent();
    }).toThrowDeveloperError();
  });
  it("minimumByComponent throws without second", function() {
    expect(function() {
      import__44.Cartesian2.minimumByComponent(new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("minimumByComponent works when first's or second's X is lesser", function() {
    const first = new import__44.Cartesian2(2, 0);
    const second = new import__44.Cartesian2(1, 0);
    const expected = new import__44.Cartesian2(1, 0);
    expect(import__44.Cartesian2.minimumByComponent(first, second, expected)).toEqual(
      expected
    );
    second.x = 3;
    expected.x = 2;
    expect(import__44.Cartesian2.minimumByComponent(first, second, expected)).toEqual(
      expected
    );
  });
  it("minimumByComponent works when first's or second's Y is lesser", function() {
    const first = new import__44.Cartesian2(0, 2);
    const second = new import__44.Cartesian2(0, 1);
    const expected = new import__44.Cartesian2(0, 1);
    const result = new import__44.Cartesian2();
    expect(import__44.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.y = 3;
    expected.y = 2;
    expect(import__44.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent", function() {
    let first;
    let second;
    let expected;
    const result = new import__44.Cartesian2();
    first = new import__44.Cartesian2(2, 0);
    second = new import__44.Cartesian2(1, 0);
    expected = new import__44.Cartesian2(2, 0);
    expect(import__44.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__44.Cartesian2(1, 0);
    second = new import__44.Cartesian2(2, 0);
    expected = new import__44.Cartesian2(2, 0);
    expect(import__44.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__44.Cartesian2(2, -15);
    second = new import__44.Cartesian2(1, -20);
    expected = new import__44.Cartesian2(2, -15);
    expect(import__44.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__44.Cartesian2(2, -20);
    second = new import__44.Cartesian2(1, -15);
    expected = new import__44.Cartesian2(2, -15);
    expect(import__44.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__44.Cartesian2(2, -15);
    second = new import__44.Cartesian2(1, -20);
    expected = new import__44.Cartesian2(2, -15);
    expect(import__44.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__44.Cartesian2(2, -15);
    second = new import__44.Cartesian2(1, -20);
    expected = new import__44.Cartesian2(2, -15);
    expect(import__44.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent with a result parameter", function() {
    const first = new import__44.Cartesian2(2, 0);
    const second = new import__44.Cartesian2(1, 0);
    const expected = new import__44.Cartesian2(2, 0);
    const result = new import__44.Cartesian2();
    const returnedResult = import__44.Cartesian2.maximumByComponent(first, second, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("maximumByComponent with a result parameter that is an input parameter", function() {
    const first = new import__44.Cartesian2(2, 0);
    const second = new import__44.Cartesian2(1, 0);
    const expected = new import__44.Cartesian2(2, 0);
    expect(import__44.Cartesian2.maximumByComponent(first, second, first)).toEqual(
      expected
    );
    first.x = 1;
    second.x = 2;
    expect(import__44.Cartesian2.maximumByComponent(first, second, second)).toEqual(
      expected
    );
  });
  it("maximumByComponent throws without first", function() {
    expect(function() {
      import__44.Cartesian2.maximumByComponent();
    }).toThrowDeveloperError();
  });
  it("maximumByComponent throws without second", function() {
    expect(function() {
      import__44.Cartesian2.maximumByComponent(new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("maximumByComponent works when first's or second's X is greater", function() {
    const first = new import__44.Cartesian2(2, 0);
    const second = new import__44.Cartesian2(1, 0);
    const expected = new import__44.Cartesian2(2, 0);
    const result = new import__44.Cartesian2();
    expect(import__44.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.x = 3;
    expected.x = 3;
    expect(import__44.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent works when first's or second's Y is greater", function() {
    const first = new import__44.Cartesian2(0, 2);
    const second = new import__44.Cartesian2(0, 1);
    const expected = new import__44.Cartesian2(0, 2);
    const result = new import__44.Cartesian2();
    expect(import__44.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.y = 3;
    expected.y = 3;
    expect(import__44.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("clamp", function() {
    let value;
    let min;
    let max;
    let expected;
    const result = new import__44.Cartesian2();
    value = new import__44.Cartesian2(-1, 0);
    min = new import__44.Cartesian2(0, 0);
    max = new import__44.Cartesian2(1, 1);
    expected = new import__44.Cartesian2(0, 0);
    expect(import__44.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
    value = new import__44.Cartesian2(2, 0);
    min = new import__44.Cartesian2(0, 0);
    max = new import__44.Cartesian2(1, 1);
    expected = new import__44.Cartesian2(1, 0);
    expect(import__44.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
    value = new import__44.Cartesian2(0, -1);
    min = new import__44.Cartesian2(0, 0);
    max = new import__44.Cartesian2(1, 1);
    expected = new import__44.Cartesian2(0, 0);
    expect(import__44.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
    value = new import__44.Cartesian2(0, 2);
    min = new import__44.Cartesian2(0, 0);
    max = new import__44.Cartesian2(1, 1);
    expected = new import__44.Cartesian2(0, 1);
    expect(import__44.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
    value = new import__44.Cartesian2(0, 0);
    min = new import__44.Cartesian2(0, 0);
    max = new import__44.Cartesian2(1, 1);
    expected = new import__44.Cartesian2(0, 0);
    expect(import__44.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
    value = new import__44.Cartesian2(0, 0);
    min = new import__44.Cartesian2(0, 0);
    max = new import__44.Cartesian2(1, 1);
    expected = new import__44.Cartesian2(0, 0);
    expect(import__44.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
    value = new import__44.Cartesian2(-2, 3);
    min = new import__44.Cartesian2(0, 0);
    max = new import__44.Cartesian2(1, 1);
    expected = new import__44.Cartesian2(0, 1);
    expect(import__44.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
    value = new import__44.Cartesian2(0, 0);
    min = new import__44.Cartesian2(1, 2);
    max = new import__44.Cartesian2(1, 2);
    expected = new import__44.Cartesian2(1, 2);
    expect(import__44.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
  });
  it("clamp with a result parameter", function() {
    const value = new import__44.Cartesian2(-1, -1);
    const min = new import__44.Cartesian2(0, 0);
    const max = new import__44.Cartesian2(1, 1);
    const expected = new import__44.Cartesian2(0, 0);
    const result = new import__44.Cartesian2();
    const returnedResult = import__44.Cartesian2.clamp(value, min, max, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("clamp with a result parameter that is an input parameter", function() {
    const value = new import__44.Cartesian2(-1, -1);
    const min = new import__44.Cartesian2(0, 0);
    const max = new import__44.Cartesian2(1, 1);
    const expected = new import__44.Cartesian2(0, 0);
    expect(import__44.Cartesian2.clamp(value, min, max, value)).toEqual(expected);
    import__44.Cartesian2.fromElements(-1, -1, value);
    expect(import__44.Cartesian2.clamp(value, min, max, min)).toEqual(expected);
    import__44.Cartesian2.fromElements(0, 0, value);
    expect(import__44.Cartesian2.clamp(value, min, max, max)).toEqual(expected);
  });
  it("clamp throws without value", function() {
    expect(function() {
      import__44.Cartesian2.clamp();
    }).toThrowDeveloperError();
  });
  it("clamp throws without min", function() {
    expect(function() {
      import__44.Cartesian2.clamp(new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("clamp throws without max", function() {
    expect(function() {
      import__44.Cartesian2.clamp(new import__44.Cartesian2(), new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("magnitudeSquared", function() {
    const cartesian = new import__44.Cartesian2(2, 3);
    expect(import__44.Cartesian2.magnitudeSquared(cartesian)).toEqual(13);
  });
  it("magnitude", function() {
    const cartesian = new import__44.Cartesian2(2, 3);
    expect(import__44.Cartesian2.magnitude(cartesian)).toEqual(Math.sqrt(13));
  });
  it("distance", function() {
    const distance = import__44.Cartesian2.distance(
      new import__44.Cartesian2(1, 0),
      new import__44.Cartesian2(2, 0)
    );
    expect(distance).toEqual(1);
  });
  it("distance throws without left", function() {
    expect(function() {
      import__44.Cartesian2.distance();
    }).toThrowDeveloperError();
  });
  it("distance throws without right", function() {
    expect(function() {
      import__44.Cartesian2.distance(import__44.Cartesian2.UNIT_X);
    }).toThrowDeveloperError();
  });
  it("distanceSquared", function() {
    const distanceSquared = import__44.Cartesian2.distanceSquared(
      new import__44.Cartesian2(1, 0),
      new import__44.Cartesian2(3, 0)
    );
    expect(distanceSquared).toEqual(4);
  });
  it("distanceSquared throws without left", function() {
    expect(function() {
      import__44.Cartesian2.distanceSquared();
    }).toThrowDeveloperError();
  });
  it("distanceSquared throws without right", function() {
    expect(function() {
      import__44.Cartesian2.distanceSquared(import__44.Cartesian2.UNIT_X);
    }).toThrowDeveloperError();
  });
  it("normalize works with a result parameter", function() {
    const cartesian = new import__44.Cartesian2(2, 0);
    const expectedResult = new import__44.Cartesian2(1, 0);
    const result = new import__44.Cartesian2();
    const returnedResult = import__44.Cartesian2.normalize(cartesian, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("normalize works with a result parameter that is an input parameter", function() {
    const cartesian = new import__44.Cartesian2(2, 0);
    const expectedResult = new import__44.Cartesian2(1, 0);
    const returnedResult = import__44.Cartesian2.normalize(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("normalize throws with zero vector", function() {
    expect(function() {
      import__44.Cartesian2.normalize(import__44.Cartesian2.ZERO, new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents works with a result parameter", function() {
    const left = new import__44.Cartesian2(2, 3);
    const right = new import__44.Cartesian2(4, 5);
    const result = new import__44.Cartesian2();
    const expectedResult = new import__44.Cartesian2(8, 15);
    const returnedResult = import__44.Cartesian2.multiplyComponents(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("multiplyComponents works with a result parameter that is an input parameter", function() {
    const left = new import__44.Cartesian2(2, 3);
    const right = new import__44.Cartesian2(4, 5);
    const expectedResult = new import__44.Cartesian2(8, 15);
    const returnedResult = import__44.Cartesian2.multiplyComponents(left, right, left);
    expect(left).toBe(returnedResult);
    expect(left).toEqual(expectedResult);
  });
  it("divideComponents works with a result parameter", function() {
    const left = new import__44.Cartesian2(2, 3);
    const right = new import__44.Cartesian2(4, 5);
    const result = new import__44.Cartesian2();
    const expectedResult = new import__44.Cartesian2(0.5, 0.6);
    const returnedResult = import__44.Cartesian2.divideComponents(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("divideComponents works with a result parameter that is an input parameter", function() {
    const left = new import__44.Cartesian2(2, 3);
    const right = new import__44.Cartesian2(4, 5);
    const expectedResult = new import__44.Cartesian2(0.5, 0.6);
    const returnedResult = import__44.Cartesian2.divideComponents(left, right, left);
    expect(left).toBe(returnedResult);
    expect(left).toEqual(expectedResult);
  });
  it("dot", function() {
    const left = new import__44.Cartesian2(2, 3);
    const right = new import__44.Cartesian2(4, 5);
    const expectedResult = 23;
    const result = import__44.Cartesian2.dot(left, right);
    expect(result).toEqual(expectedResult);
  });
  it("cross", function() {
    const left = new import__44.Cartesian2(0, 1);
    const right = new import__44.Cartesian2(1, 0);
    const expectedResult = -1;
    const result = import__44.Cartesian2.cross(left, right);
    expect(result).toEqual(expectedResult);
  });
  it("add works with a result parameter", function() {
    const left = new import__44.Cartesian2(2, 3);
    const right = new import__44.Cartesian2(4, 5);
    const result = new import__44.Cartesian2();
    const expectedResult = new import__44.Cartesian2(6, 8);
    const returnedResult = import__44.Cartesian2.add(left, right, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqual(expectedResult);
  });
  it("add works with a result parameter that is an input parameter", function() {
    const left = new import__44.Cartesian2(2, 3);
    const right = new import__44.Cartesian2(4, 5);
    const expectedResult = new import__44.Cartesian2(6, 8);
    const returnedResult = import__44.Cartesian2.add(left, right, left);
    expect(returnedResult).toBe(left);
    expect(left).toEqual(expectedResult);
  });
  it("subtract works with a result parameter", function() {
    const left = new import__44.Cartesian2(2, 3);
    const right = new import__44.Cartesian2(1, 5);
    const result = new import__44.Cartesian2();
    const expectedResult = new import__44.Cartesian2(1, -2);
    const returnedResult = import__44.Cartesian2.subtract(left, right, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqual(expectedResult);
  });
  it("subtract works with this result parameter", function() {
    const left = new import__44.Cartesian2(2, 3);
    const right = new import__44.Cartesian2(1, 5);
    const expectedResult = new import__44.Cartesian2(1, -2);
    const returnedResult = import__44.Cartesian2.subtract(left, right, left);
    expect(returnedResult).toBe(left);
    expect(left).toEqual(expectedResult);
  });
  it("multiplyByScalar with a result parameter", function() {
    const cartesian = new import__44.Cartesian2(1, 2);
    const result = new import__44.Cartesian2();
    const scalar = 2;
    const expectedResult = new import__44.Cartesian2(2, 4);
    const returnedResult = import__44.Cartesian2.multiplyByScalar(
      cartesian,
      scalar,
      result
    );
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("multiplyByScalar with a result parameter that is an input parameter", function() {
    const cartesian = new import__44.Cartesian2(1, 2);
    const scalar = 2;
    const expectedResult = new import__44.Cartesian2(2, 4);
    const returnedResult = import__44.Cartesian2.multiplyByScalar(
      cartesian,
      scalar,
      cartesian
    );
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("divideByScalar with a result parameter", function() {
    const cartesian = new import__44.Cartesian2(1, 2);
    const result = new import__44.Cartesian2();
    const scalar = 2;
    const expectedResult = new import__44.Cartesian2(0.5, 1);
    const returnedResult = import__44.Cartesian2.divideByScalar(cartesian, scalar, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("divideByScalar with a result parameter that is an input parameter", function() {
    const cartesian = new import__44.Cartesian2(1, 2);
    const scalar = 2;
    const expectedResult = new import__44.Cartesian2(0.5, 1);
    const returnedResult = import__44.Cartesian2.divideByScalar(
      cartesian,
      scalar,
      cartesian
    );
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("negate with a result parameter", function() {
    const cartesian = new import__44.Cartesian2(1, -2);
    const result = new import__44.Cartesian2();
    const expectedResult = new import__44.Cartesian2(-1, 2);
    const returnedResult = import__44.Cartesian2.negate(cartesian, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("negate with a result parameter that is an input parameter", function() {
    const cartesian = new import__44.Cartesian2(1, -2);
    const expectedResult = new import__44.Cartesian2(-1, 2);
    const returnedResult = import__44.Cartesian2.negate(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("abs with a result parameter", function() {
    const cartesian = new import__44.Cartesian2(1, -2);
    const result = new import__44.Cartesian2();
    const expectedResult = new import__44.Cartesian2(1, 2);
    const returnedResult = import__44.Cartesian2.abs(cartesian, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("abs with a result parameter that is an input parameter", function() {
    const cartesian = new import__44.Cartesian2(1, -2);
    const expectedResult = new import__44.Cartesian2(1, 2);
    const returnedResult = import__44.Cartesian2.abs(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("lerp works with a result parameter", function() {
    const start = new import__44.Cartesian2(4, 8);
    const end = new import__44.Cartesian2(8, 20);
    const t = 0.25;
    const result = new import__44.Cartesian2();
    const expectedResult = new import__44.Cartesian2(5, 11);
    const returnedResult = import__44.Cartesian2.lerp(start, end, t, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("lerp works with a result parameter that is an input parameter", function() {
    const start = new import__44.Cartesian2(4, 8);
    const end = new import__44.Cartesian2(8, 20);
    const t = 0.25;
    const expectedResult = new import__44.Cartesian2(5, 11);
    const returnedResult = import__44.Cartesian2.lerp(start, end, t, start);
    expect(start).toBe(returnedResult);
    expect(start).toEqual(expectedResult);
  });
  it("lerp extrapolate forward", function() {
    const start = new import__44.Cartesian2(4, 8);
    const end = new import__44.Cartesian2(8, 20);
    const t = 2;
    const expectedResult = new import__44.Cartesian2(12, 32);
    const result = import__44.Cartesian2.lerp(start, end, t, new import__44.Cartesian2());
    expect(result).toEqual(expectedResult);
  });
  it("lerp extrapolate backward", function() {
    const start = new import__44.Cartesian2(4, 8);
    const end = new import__44.Cartesian2(8, 20);
    const t = -1;
    const expectedResult = new import__44.Cartesian2(0, -4);
    const result = import__44.Cartesian2.lerp(start, end, t, new import__44.Cartesian2());
    expect(result).toEqual(expectedResult);
  });
  it("angleBetween works for right angles", function() {
    const x = import__44.Cartesian2.UNIT_X;
    const y = import__44.Cartesian2.UNIT_Y;
    expect(import__44.Cartesian2.angleBetween(x, y)).toEqual(import__44.Math.PI_OVER_TWO);
    expect(import__44.Cartesian2.angleBetween(y, x)).toEqual(import__44.Math.PI_OVER_TWO);
  });
  it("angleBetween works for acute angles", function() {
    const x = new import__44.Cartesian2(0, 1);
    const y = new import__44.Cartesian2(1, 1);
    expect(import__44.Cartesian2.angleBetween(x, y)).toEqualEpsilon(
      import__44.Math.PI_OVER_FOUR,
      import__44.Math.EPSILON14
    );
    expect(import__44.Cartesian2.angleBetween(y, x)).toEqualEpsilon(
      import__44.Math.PI_OVER_FOUR,
      import__44.Math.EPSILON14
    );
  });
  it("angleBetween works for obtuse angles", function() {
    const x = new import__44.Cartesian2(0, 1);
    const y = new import__44.Cartesian2(-1, -1);
    expect(import__44.Cartesian2.angleBetween(x, y)).toEqualEpsilon(
      import__44.Math.PI * 3 / 4,
      import__44.Math.EPSILON14
    );
    expect(import__44.Cartesian2.angleBetween(y, x)).toEqualEpsilon(
      import__44.Math.PI * 3 / 4,
      import__44.Math.EPSILON14
    );
  });
  it("angleBetween works for zero angles", function() {
    const x = import__44.Cartesian2.UNIT_X;
    expect(import__44.Cartesian2.angleBetween(x, x)).toEqual(0);
  });
  it("most orthogonal angle is x", function() {
    const v2 = new import__44.Cartesian2(0, 1);
    expect(import__44.Cartesian2.mostOrthogonalAxis(v2, new import__44.Cartesian2())).toEqual(
      import__44.Cartesian2.UNIT_X
    );
  });
  it("most orthogonal angle is y", function() {
    const v2 = new import__44.Cartesian2(1, 0);
    expect(import__44.Cartesian2.mostOrthogonalAxis(v2, new import__44.Cartesian2())).toEqual(
      import__44.Cartesian2.UNIT_Y
    );
  });
  it("equals", function() {
    const cartesian = new import__44.Cartesian2(1, 2);
    expect(import__44.Cartesian2.equals(cartesian, new import__44.Cartesian2(1, 2))).toEqual(
      true
    );
    expect(import__44.Cartesian2.equals(cartesian, new import__44.Cartesian2(2, 2))).toEqual(
      false
    );
    expect(import__44.Cartesian2.equals(cartesian, new import__44.Cartesian2(2, 1))).toEqual(
      false
    );
    expect(import__44.Cartesian2.equals(cartesian, void 0)).toEqual(false);
  });
  it("equalsEpsilon", function() {
    let cartesian = new import__44.Cartesian2(1, 2);
    expect(cartesian.equalsEpsilon(new import__44.Cartesian2(1, 2), 0)).toEqual(
      true
    );
    expect(cartesian.equalsEpsilon(new import__44.Cartesian2(1, 2), 1)).toEqual(
      true
    );
    expect(cartesian.equalsEpsilon(new import__44.Cartesian2(2, 2), 1)).toEqual(
      true
    );
    expect(cartesian.equalsEpsilon(new import__44.Cartesian2(1, 3), 1)).toEqual(
      true
    );
    expect(
      cartesian.equalsEpsilon(new import__44.Cartesian2(1, 3), import__44.Math.EPSILON6)
    ).toEqual(false);
    expect(cartesian.equalsEpsilon(void 0, 1)).toEqual(false);
    cartesian = new import__44.Cartesian2(3e6, 4e6);
    expect(
      cartesian.equalsEpsilon(new import__44.Cartesian2(3e6, 4e6), 0)
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__44.Cartesian2(3e6, 40000002e-1),
        import__44.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__44.Cartesian2(30000002e-1, 4e6),
        import__44.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__44.Cartesian2(30000002e-1, 40000002e-1),
        import__44.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__44.Cartesian2(30000002e-1, 40000002e-1),
        import__44.Math.EPSILON9
      )
    ).toEqual(false);
    expect(cartesian.equalsEpsilon(void 0, 1)).toEqual(false);
    expect(import__44.Cartesian2.equalsEpsilon(void 0, cartesian, 1)).toEqual(false);
  });
  it("toString", function() {
    const cartesian = new import__44.Cartesian2(1.123, 2.345);
    expect(cartesian.toString()).toEqual("(1.123, 2.345)");
  });
  it("clone returns undefined with no parameter", function() {
    expect(import__44.Cartesian2.clone()).toBeUndefined();
  });
  it("maximumComponent throws with no parameter", function() {
    expect(function() {
      import__44.Cartesian2.maximumComponent();
    }).toThrowDeveloperError();
  });
  it("minimumComponent throws with no parameter", function() {
    expect(function() {
      import__44.Cartesian2.minimumComponent();
    }).toThrowDeveloperError();
  });
  it("magnitudeSquared throws with no parameter", function() {
    expect(function() {
      import__44.Cartesian2.magnitudeSquared();
    }).toThrowDeveloperError();
  });
  it("magnitude throws with no parameter", function() {
    expect(function() {
      import__44.Cartesian2.magnitude();
    }).toThrowDeveloperError();
  });
  it("normalize throws with no parameter", function() {
    expect(function() {
      import__44.Cartesian2.normalize();
    }).toThrowDeveloperError();
  });
  it("dot throws with no left parameter", function() {
    expect(function() {
      import__44.Cartesian2.dot(void 0, new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("dot throws with no right parameter", function() {
    expect(function() {
      import__44.Cartesian2.dot(new import__44.Cartesian2(), void 0);
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throw with no left parameter", function() {
    const right = new import__44.Cartesian2(4, 5);
    expect(function() {
      import__44.Cartesian2.multiplyComponents(void 0, right);
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throw with no right parameter", function() {
    const left = new import__44.Cartesian2(4, 5);
    expect(function() {
      import__44.Cartesian2.multiplyComponents(left, void 0);
    }).toThrowDeveloperError();
  });
  it("divideComponents throw with no left parameter", function() {
    const right = new import__44.Cartesian2(4, 5);
    expect(function() {
      import__44.Cartesian2.divideComponents(void 0, right);
    }).toThrowDeveloperError();
  });
  it("divideComponents throw with no right parameter", function() {
    const left = new import__44.Cartesian2(4, 5);
    expect(function() {
      import__44.Cartesian2.divideComponents(left, void 0);
    }).toThrowDeveloperError();
  });
  it("add throws with no left parameter", function() {
    expect(function() {
      import__44.Cartesian2.add(void 0, new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("add throws with no right parameter", function() {
    expect(function() {
      import__44.Cartesian2.add(new import__44.Cartesian2(), void 0);
    }).toThrowDeveloperError();
  });
  it("subtract throws with no left parameter", function() {
    expect(function() {
      import__44.Cartesian2.subtract(void 0, new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("subtract throws with no right parameter", function() {
    expect(function() {
      import__44.Cartesian2.subtract(new import__44.Cartesian2(), void 0);
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no cartesian parameter", function() {
    expect(function() {
      import__44.Cartesian2.multiplyByScalar(void 0, 2);
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no scalar parameter", function() {
    expect(function() {
      import__44.Cartesian2.multiplyByScalar(new import__44.Cartesian2(), void 0);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no cartesian parameter", function() {
    expect(function() {
      import__44.Cartesian2.divideByScalar(void 0, 2);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no scalar parameter", function() {
    expect(function() {
      import__44.Cartesian2.divideByScalar(new import__44.Cartesian2(), void 0);
    }).toThrowDeveloperError();
  });
  it("negate throws with no cartesian parameter", function() {
    expect(function() {
      import__44.Cartesian2.negate(void 0);
    }).toThrowDeveloperError();
  });
  it("abs throws with no cartesian parameter", function() {
    expect(function() {
      import__44.Cartesian2.abs(void 0);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no start parameter", function() {
    const end = new import__44.Cartesian2(8, 20);
    const t = 0.25;
    expect(function() {
      import__44.Cartesian2.lerp(void 0, end, t);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no end parameter", function() {
    const start = new import__44.Cartesian2(4, 8);
    const t = 0.25;
    expect(function() {
      import__44.Cartesian2.lerp(start, void 0, t);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no t parameter", function() {
    const start = new import__44.Cartesian2(4, 8);
    const end = new import__44.Cartesian2(8, 20);
    expect(function() {
      import__44.Cartesian2.lerp(start, end, void 0);
    }).toThrowDeveloperError();
  });
  it("angleBetween throws with no left parameter", function() {
    const right = new import__44.Cartesian2(8, 20);
    expect(function() {
      import__44.Cartesian2.angleBetween(void 0, right);
    }).toThrowDeveloperError();
  });
  it("angleBetween throws with no right parameter", function() {
    const left = new import__44.Cartesian2(4, 8);
    expect(function() {
      import__44.Cartesian2.angleBetween(left, void 0);
    }).toThrowDeveloperError();
  });
  it("mostOrthogonalAxis throws with no cartesian parameter", function() {
    expect(function() {
      import__44.Cartesian2.mostOrthogonalAxis(void 0);
    }).toThrowDeveloperError();
  });
  it("fromElements returns a cartesian2 with corrrect coordinates", function() {
    const cartesian2 = import__44.Cartesian2.fromElements(2, 2);
    const expectedResult = new import__44.Cartesian2(2, 2);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("fromElements result param returns cartesian2 with correct coordinates", function() {
    const cartesian2 = new import__44.Cartesian2();
    import__44.Cartesian2.fromElements(2, 2, cartesian2);
    const expectedResult = new import__44.Cartesian2(2, 2);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("minimumByComponent throws with no result", function() {
    expect(function() {
      import__44.Cartesian2.minimumByComponent(new import__44.Cartesian2(), new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("maximumByComponent throws with no result", function() {
    expect(function() {
      import__44.Cartesian2.maximumByComponent(new import__44.Cartesian2(), new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("clamp throws with no result", function() {
    expect(function() {
      import__44.Cartesian2.clamp(new import__44.Cartesian2(), new import__44.Cartesian2(), new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("normalize throws with no result", function() {
    expect(function() {
      import__44.Cartesian2.normalize(new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throws with no result", function() {
    expect(function() {
      import__44.Cartesian2.multiplyComponents(new import__44.Cartesian2(), new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("divideComponents throws with no result", function() {
    expect(function() {
      import__44.Cartesian2.divideComponents(new import__44.Cartesian2(), new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("add throws with no result", function() {
    expect(function() {
      import__44.Cartesian2.add(new import__44.Cartesian2(), new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("subtact throws with no result", function() {
    expect(function() {
      import__44.Cartesian2.subtract(new import__44.Cartesian2(), new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no result", function() {
    expect(function() {
      import__44.Cartesian2.multiplyByScalar(new import__44.Cartesian2(), 2);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no result", function() {
    expect(function() {
      import__44.Cartesian2.divideByScalar(new import__44.Cartesian2(), 2);
    }).toThrowDeveloperError();
  });
  it("negate throws with no result", function() {
    expect(function() {
      import__44.Cartesian2.negate(new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("abs throws with no result", function() {
    expect(function() {
      import__44.Cartesian2.abs(new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("lerp throws with no result", function() {
    expect(function() {
      import__44.Cartesian2.lerp(new import__44.Cartesian2(), new import__44.Cartesian2(), 10);
    }).toThrowDeveloperError();
  });
  it("mostOrthogonalAxis throws with no result", function() {
    expect(function() {
      import__44.Cartesian2.mostOrthogonalAxis(new import__44.Cartesian2());
    }).toThrowDeveloperError();
  });
  createPackableSpecs_default(import__44.Cartesian2, new import__44.Cartesian2(1, 2), [1, 2]);
  createPackableArraySpecs_default(
    import__44.Cartesian2,
    [new import__44.Cartesian2(1, 2), new import__44.Cartesian2(3, 4)],
    [1, 2, 3, 4],
    2
  );
});

// packages/engine/Specs/Core/Cartesian3Spec.js
var import__45 = __toESM(require_Cesium(), 1);
var import__46 = __toESM(require_Cesium(), 1);
describe("Core/Cartesian3", function() {
  it("construct with default values", function() {
    const cartesian2 = new import__45.Cartesian3();
    expect(cartesian2.x).toEqual(0);
    expect(cartesian2.y).toEqual(0);
    expect(cartesian2.z).toEqual(0);
  });
  it("construct with all values", function() {
    const cartesian2 = new import__45.Cartesian3(1, 2, 3);
    expect(cartesian2.x).toEqual(1);
    expect(cartesian2.y).toEqual(2);
    expect(cartesian2.z).toEqual(3);
  });
  const fortyFiveDegrees = Math.PI / 4;
  const sixtyDegrees = Math.PI / 3;
  const cartesian = new import__45.Cartesian3(1, Math.sqrt(3), -2);
  const spherical = {
    clock: sixtyDegrees,
    cone: fortyFiveDegrees + Math.PI / 2,
    magnitude: Math.sqrt(8)
  };
  it("convert Spherical to an existing Cartesian3 instance", function() {
    const existing = new import__45.Cartesian3();
    expect(cartesian).toEqualEpsilon(
      import__45.Cartesian3.fromSpherical(spherical, existing),
      import__46.Math.EPSILON15
    );
    expect(cartesian).toEqualEpsilon(existing, import__46.Math.EPSILON15);
  });
  it("fromArray with an offset creates a Cartesian3", function() {
    const cartesian2 = import__45.Cartesian3.fromArray([0, 1, 2, 3, 0], 1);
    expect(cartesian2).toEqual(new import__45.Cartesian3(1, 2, 3));
  });
  it("fromArray creates a Cartesian3 with a result parameter", function() {
    const cartesian2 = new import__45.Cartesian3();
    const result = import__45.Cartesian3.fromArray([1, 2, 3], 0, cartesian2);
    expect(result).toBe(cartesian2);
    expect(result).toEqual(new import__45.Cartesian3(1, 2, 3));
  });
  it("fromArray throws without values", function() {
    expect(function() {
      import__45.Cartesian3.fromArray();
    }).toThrowDeveloperError();
  });
  it("clone with a result parameter", function() {
    const cartesian2 = new import__45.Cartesian3(1, 2, 3);
    const result = new import__45.Cartesian3();
    const returnedResult = import__45.Cartesian3.clone(cartesian2, result);
    expect(cartesian2).not.toBe(result);
    expect(result).toBe(returnedResult);
    expect(cartesian2).toEqual(result);
  });
  it("clone works with a result parameter that is an input parameter", function() {
    const cartesian2 = new import__45.Cartesian3(1, 2, 3);
    const returnedResult = import__45.Cartesian3.clone(cartesian2, cartesian2);
    expect(cartesian2).toBe(returnedResult);
  });
  it("maximumComponent works when X is greater", function() {
    const cartesian2 = new import__45.Cartesian3(2, 1, 0);
    expect(import__45.Cartesian3.maximumComponent(cartesian2)).toEqual(cartesian2.x);
  });
  it("maximumComponent works when Y is greater", function() {
    const cartesian2 = new import__45.Cartesian3(1, 2, 0);
    expect(import__45.Cartesian3.maximumComponent(cartesian2)).toEqual(cartesian2.y);
  });
  it("maximumComponent works when Z is greater", function() {
    const cartesian2 = new import__45.Cartesian3(1, 2, 3);
    expect(import__45.Cartesian3.maximumComponent(cartesian2)).toEqual(cartesian2.z);
  });
  it("minimumComponent works when X is lesser", function() {
    const cartesian2 = new import__45.Cartesian3(1, 2, 3);
    expect(import__45.Cartesian3.minimumComponent(cartesian2)).toEqual(cartesian2.x);
  });
  it("minimumComponent works when Y is lesser", function() {
    const cartesian2 = new import__45.Cartesian3(2, 1, 3);
    expect(import__45.Cartesian3.minimumComponent(cartesian2)).toEqual(cartesian2.y);
  });
  it("minimumComponent works when Z is lesser", function() {
    const cartesian2 = new import__45.Cartesian3(2, 1, 0);
    expect(import__45.Cartesian3.minimumComponent(cartesian2)).toEqual(cartesian2.z);
  });
  it("minimumByComponent", function() {
    let first;
    let second;
    let expected;
    const result = new import__45.Cartesian3();
    first = new import__45.Cartesian3(2, 0, 0);
    second = new import__45.Cartesian3(1, 0, 0);
    expected = new import__45.Cartesian3(1, 0, 0);
    expect(import__45.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__45.Cartesian3(1, 0, 0);
    second = new import__45.Cartesian3(2, 0, 0);
    expected = new import__45.Cartesian3(1, 0, 0);
    expect(import__45.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__45.Cartesian3(2, -15, 0);
    second = new import__45.Cartesian3(1, -20, 0);
    expected = new import__45.Cartesian3(1, -20, 0);
    expect(import__45.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__45.Cartesian3(2, -20, 0);
    second = new import__45.Cartesian3(1, -15, 0);
    expected = new import__45.Cartesian3(1, -20, 0);
    expect(import__45.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__45.Cartesian3(2, -15, 26.4);
    second = new import__45.Cartesian3(1, -20, 26.5);
    expected = new import__45.Cartesian3(1, -20, 26.4);
    expect(import__45.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__45.Cartesian3(2, -15, 26.5);
    second = new import__45.Cartesian3(1, -20, 26.4);
    expected = new import__45.Cartesian3(1, -20, 26.4);
    expect(import__45.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent with a result parameter", function() {
    const first = new import__45.Cartesian3(2, 0, 0);
    const second = new import__45.Cartesian3(1, 0, 0);
    const expected = new import__45.Cartesian3(1, 0, 0);
    const result = new import__45.Cartesian3();
    const returnedResult = import__45.Cartesian3.minimumByComponent(first, second, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("minimumByComponent with a result parameter that is an input parameter", function() {
    const first = new import__45.Cartesian3(2, 0, 0);
    const second = new import__45.Cartesian3(1, 0, 0);
    const expected = new import__45.Cartesian3(1, 0, 0);
    expect(import__45.Cartesian3.minimumByComponent(first, second, first)).toEqual(
      expected
    );
    first.x = 1;
    second.x = 2;
    expect(import__45.Cartesian3.minimumByComponent(first, second, second)).toEqual(
      expected
    );
  });
  it("minimumByComponent throws without first", function() {
    expect(function() {
      import__45.Cartesian3.minimumByComponent();
    }).toThrowDeveloperError();
  });
  it("minimumByComponent throws without second", function() {
    expect(function() {
      import__45.Cartesian3.minimumByComponent(new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("minimumByComponent works when first's or second's X is lesser", function() {
    const first = new import__45.Cartesian3(2, 0, 0);
    const second = new import__45.Cartesian3(1, 0, 0);
    const expected = new import__45.Cartesian3(1, 0, 0);
    const result = new import__45.Cartesian3();
    expect(import__45.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.x = 3;
    expected.x = 2;
    expect(import__45.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent works when first's or second's Y is lesser", function() {
    const first = new import__45.Cartesian3(0, 2, 0);
    const second = new import__45.Cartesian3(0, 1, 0);
    const expected = new import__45.Cartesian3(0, 1, 0);
    const result = new import__45.Cartesian3();
    expect(import__45.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.y = 3;
    expected.y = 2;
    expect(import__45.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent works when first's or second's Z is lesser", function() {
    const first = new import__45.Cartesian3(0, 0, 2);
    const second = new import__45.Cartesian3(0, 0, 1);
    const expected = new import__45.Cartesian3(0, 0, 1);
    const result = new import__45.Cartesian3();
    expect(import__45.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.z = 3;
    expected.z = 2;
    expect(import__45.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent", function() {
    let first;
    let second;
    let expected;
    const result = new import__45.Cartesian3();
    first = new import__45.Cartesian3(2, 0, 0);
    second = new import__45.Cartesian3(1, 0, 0);
    expected = new import__45.Cartesian3(2, 0, 0);
    expect(import__45.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__45.Cartesian3(1, 0, 0);
    second = new import__45.Cartesian3(2, 0, 0);
    expected = new import__45.Cartesian3(2, 0, 0);
    expect(import__45.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__45.Cartesian3(2, -15, 0);
    second = new import__45.Cartesian3(1, -20, 0);
    expected = new import__45.Cartesian3(2, -15, 0);
    expect(import__45.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__45.Cartesian3(2, -20, 0);
    second = new import__45.Cartesian3(1, -15, 0);
    expected = new import__45.Cartesian3(2, -15, 0);
    expect(import__45.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__45.Cartesian3(2, -15, 26.4);
    second = new import__45.Cartesian3(1, -20, 26.5);
    expected = new import__45.Cartesian3(2, -15, 26.5);
    expect(import__45.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__45.Cartesian3(2, -15, 26.5);
    second = new import__45.Cartesian3(1, -20, 26.4);
    expected = new import__45.Cartesian3(2, -15, 26.5);
    expect(import__45.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent with a result parameter", function() {
    const first = new import__45.Cartesian3(2, 0, 0);
    const second = new import__45.Cartesian3(1, 0, 0);
    const expected = new import__45.Cartesian3(2, 0, 0);
    const result = new import__45.Cartesian3();
    const returnedResult = import__45.Cartesian3.maximumByComponent(first, second, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("maximumByComponent with a result parameter that is an input parameter", function() {
    const first = new import__45.Cartesian3(2, 0, 0);
    const second = new import__45.Cartesian3(1, 0, 0);
    const expected = new import__45.Cartesian3(2, 0, 0);
    expect(import__45.Cartesian3.maximumByComponent(first, second, first)).toEqual(
      expected
    );
    first.x = 1;
    second.x = 2;
    expect(import__45.Cartesian3.maximumByComponent(first, second, second)).toEqual(
      expected
    );
  });
  it("maximumByComponent throws without first", function() {
    expect(function() {
      import__45.Cartesian3.maximumByComponent();
    }).toThrowDeveloperError();
  });
  it("maximumByComponent throws without second", function() {
    expect(function() {
      import__45.Cartesian3.maximumByComponent(new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("maximumByComponent works when first's or second's X is greater", function() {
    const first = new import__45.Cartesian3(2, 0, 0);
    const second = new import__45.Cartesian3(1, 0, 0);
    const expected = new import__45.Cartesian3(2, 0, 0);
    const result = new import__45.Cartesian3();
    expect(import__45.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.x = 3;
    expected.x = 3;
    expect(import__45.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent works when first's or second's Y is greater", function() {
    const first = new import__45.Cartesian3(0, 2, 0);
    const second = new import__45.Cartesian3(0, 1, 0);
    const expected = new import__45.Cartesian3(0, 2, 0);
    const result = new import__45.Cartesian3();
    expect(import__45.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.y = 3;
    expected.y = 3;
    expect(import__45.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent works when first's or second's Z is greater", function() {
    const first = new import__45.Cartesian3(0, 0, 2);
    const second = new import__45.Cartesian3(0, 0, 1);
    const expected = new import__45.Cartesian3(0, 0, 2);
    const result = new import__45.Cartesian3();
    expect(import__45.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.z = 3;
    expected.z = 3;
    expect(import__45.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("clamp", function() {
    let value;
    let min;
    let max;
    let expected;
    const result = new import__45.Cartesian3();
    value = new import__45.Cartesian3(-1, 0, 0);
    min = new import__45.Cartesian3(0, 0, 0);
    max = new import__45.Cartesian3(1, 1, 1);
    expected = new import__45.Cartesian3(0, 0, 0);
    expect(import__45.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
    value = new import__45.Cartesian3(2, 0, 0);
    min = new import__45.Cartesian3(0, 0, 0);
    max = new import__45.Cartesian3(1, 1, 1);
    expected = new import__45.Cartesian3(1, 0, 0);
    expect(import__45.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
    value = new import__45.Cartesian3(0, -1, 0);
    min = new import__45.Cartesian3(0, 0, 0);
    max = new import__45.Cartesian3(1, 1, 1);
    expected = new import__45.Cartesian3(0, 0, 0);
    expect(import__45.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
    value = new import__45.Cartesian3(0, 2, 0);
    min = new import__45.Cartesian3(0, 0, 0);
    max = new import__45.Cartesian3(1, 1, 1);
    expected = new import__45.Cartesian3(0, 1, 0);
    expect(import__45.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
    value = new import__45.Cartesian3(0, 0, -1);
    min = new import__45.Cartesian3(0, 0, 0);
    max = new import__45.Cartesian3(1, 1, 1);
    expected = new import__45.Cartesian3(0, 0, 0);
    expect(import__45.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
    value = new import__45.Cartesian3(0, 0, 2);
    min = new import__45.Cartesian3(0, 0, 0);
    max = new import__45.Cartesian3(1, 1, 1);
    expected = new import__45.Cartesian3(0, 0, 1);
    expect(import__45.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
    value = new import__45.Cartesian3(-2, 3, 4);
    min = new import__45.Cartesian3(0, 0, 0);
    max = new import__45.Cartesian3(1, 1, 1);
    expected = new import__45.Cartesian3(0, 1, 1);
    expect(import__45.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
    value = new import__45.Cartesian3(0, 0, 0);
    min = new import__45.Cartesian3(1, 2, 3);
    max = new import__45.Cartesian3(1, 2, 3);
    expected = new import__45.Cartesian3(1, 2, 3);
    expect(import__45.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
  });
  it("clamp with a result parameter", function() {
    const value = new import__45.Cartesian3(-1, -1, -1);
    const min = new import__45.Cartesian3(0, 0, 0);
    const max = new import__45.Cartesian3(1, 1, 1);
    const expected = new import__45.Cartesian3(0, 0, 0);
    const result = new import__45.Cartesian3();
    const returnedResult = import__45.Cartesian3.clamp(value, min, max, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("clamp with a result parameter that is an input parameter", function() {
    const value = new import__45.Cartesian3(-1, -1, -1);
    const min = new import__45.Cartesian3(0, 0, 0);
    const max = new import__45.Cartesian3(1, 1, 1);
    const expected = new import__45.Cartesian3(0, 0, 0);
    expect(import__45.Cartesian3.clamp(value, min, max, value)).toEqual(expected);
    import__45.Cartesian3.fromElements(-1, -1, -1, value);
    expect(import__45.Cartesian3.clamp(value, min, max, min)).toEqual(expected);
    import__45.Cartesian3.fromElements(0, 0, 0, min);
    expect(import__45.Cartesian3.clamp(value, min, max, max)).toEqual(expected);
  });
  it("clamp throws without value", function() {
    expect(function() {
      import__45.Cartesian3.clamp();
    }).toThrowDeveloperError();
  });
  it("clamp throws without min", function() {
    expect(function() {
      import__45.Cartesian3.clamp(new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("clamp throws without max", function() {
    expect(function() {
      import__45.Cartesian3.clamp(new import__45.Cartesian3(), new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("magnitudeSquared", function() {
    const cartesian2 = new import__45.Cartesian3(3, 4, 5);
    expect(import__45.Cartesian3.magnitudeSquared(cartesian2)).toEqual(50);
  });
  it("magnitude", function() {
    const cartesian2 = new import__45.Cartesian3(3, 4, 5);
    expect(import__45.Cartesian3.magnitude(cartesian2)).toEqual(Math.sqrt(50));
  });
  it("distance", function() {
    const distance = import__45.Cartesian3.distance(
      new import__45.Cartesian3(1, 0, 0),
      new import__45.Cartesian3(2, 0, 0)
    );
    expect(distance).toEqual(1);
  });
  it("distance throws without left", function() {
    expect(function() {
      import__45.Cartesian3.distance();
    }).toThrowDeveloperError();
  });
  it("distance throws without right", function() {
    expect(function() {
      import__45.Cartesian3.distance(import__45.Cartesian3.UNIT_X);
    }).toThrowDeveloperError();
  });
  it("distanceSquared", function() {
    const distanceSquared = import__45.Cartesian3.distanceSquared(
      new import__45.Cartesian3(1, 0, 0),
      new import__45.Cartesian3(3, 0, 0)
    );
    expect(distanceSquared).toEqual(4);
  });
  it("distanceSquared throws without left", function() {
    expect(function() {
      import__45.Cartesian3.distanceSquared();
    }).toThrowDeveloperError();
  });
  it("distanceSquared throws without right", function() {
    expect(function() {
      import__45.Cartesian3.distanceSquared(import__45.Cartesian3.UNIT_X);
    }).toThrowDeveloperError();
  });
  it("normalize works with a result parameter", function() {
    const cartesian2 = new import__45.Cartesian3(2, 0, 0);
    const expectedResult = new import__45.Cartesian3(1, 0, 0);
    const result = new import__45.Cartesian3();
    const returnedResult = import__45.Cartesian3.normalize(cartesian2, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("normalize works with a result parameter that is an input parameter", function() {
    const cartesian2 = new import__45.Cartesian3(2, 0, 0);
    const expectedResult = new import__45.Cartesian3(1, 0, 0);
    const returnedResult = import__45.Cartesian3.normalize(cartesian2, cartesian2);
    expect(cartesian2).toBe(returnedResult);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("normalize throws with zero vector", function() {
    expect(function() {
      import__45.Cartesian3.normalize(import__45.Cartesian3.ZERO, new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents works with a result parameter", function() {
    const left = new import__45.Cartesian3(2, 3, 6);
    const right = new import__45.Cartesian3(4, 5, 7);
    const result = new import__45.Cartesian3();
    const expectedResult = new import__45.Cartesian3(8, 15, 42);
    const returnedResult = import__45.Cartesian3.multiplyComponents(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("multiplyComponents works with a result parameter that is an input parameter", function() {
    const left = new import__45.Cartesian3(2, 3, 6);
    const right = new import__45.Cartesian3(4, 5, 7);
    const expectedResult = new import__45.Cartesian3(8, 15, 42);
    const returnedResult = import__45.Cartesian3.multiplyComponents(left, right, left);
    expect(left).toBe(returnedResult);
    expect(left).toEqual(expectedResult);
  });
  it("divideComponents works with a result parameter", function() {
    const left = new import__45.Cartesian3(2, 3, 6);
    const right = new import__45.Cartesian3(4, 5, 8);
    const result = new import__45.Cartesian3();
    const expectedResult = new import__45.Cartesian3(0.5, 0.6, 0.75);
    const returnedResult = import__45.Cartesian3.divideComponents(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("divideComponents works with a result parameter that is an input parameter", function() {
    const left = new import__45.Cartesian3(2, 3, 6);
    const right = new import__45.Cartesian3(4, 5, 8);
    const expectedResult = new import__45.Cartesian3(0.5, 0.6, 0.75);
    const returnedResult = import__45.Cartesian3.divideComponents(left, right, left);
    expect(left).toBe(returnedResult);
    expect(left).toEqual(expectedResult);
  });
  it("dot", function() {
    const left = new import__45.Cartesian3(2, 3, 6);
    const right = new import__45.Cartesian3(4, 5, 7);
    const expectedResult = 65;
    const result = import__45.Cartesian3.dot(left, right);
    expect(result).toEqual(expectedResult);
  });
  it("add works with a result parameter", function() {
    const left = new import__45.Cartesian3(2, 3, 6);
    const right = new import__45.Cartesian3(4, 5, 7);
    const result = new import__45.Cartesian3();
    const expectedResult = new import__45.Cartesian3(6, 8, 13);
    const returnedResult = import__45.Cartesian3.add(left, right, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqual(expectedResult);
  });
  it("add works with a result parameter that is an input parameter", function() {
    const left = new import__45.Cartesian3(2, 3, 6);
    const right = new import__45.Cartesian3(4, 5, 7);
    const expectedResult = new import__45.Cartesian3(6, 8, 13);
    const returnedResult = import__45.Cartesian3.add(left, right, left);
    expect(returnedResult).toBe(left);
    expect(left).toEqual(expectedResult);
  });
  it("subtract works with a result parameter", function() {
    const left = new import__45.Cartesian3(2, 3, 4);
    const right = new import__45.Cartesian3(1, 5, 7);
    const result = new import__45.Cartesian3();
    const expectedResult = new import__45.Cartesian3(1, -2, -3);
    const returnedResult = import__45.Cartesian3.subtract(left, right, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqual(expectedResult);
  });
  it("subtract works with this result parameter", function() {
    const left = new import__45.Cartesian3(2, 3, 4);
    const right = new import__45.Cartesian3(1, 5, 7);
    const expectedResult = new import__45.Cartesian3(1, -2, -3);
    const returnedResult = import__45.Cartesian3.subtract(left, right, left);
    expect(returnedResult).toBe(left);
    expect(left).toEqual(expectedResult);
  });
  it("multiplyByScalar with a result parameter", function() {
    const cartesian2 = new import__45.Cartesian3(1, 2, 3);
    const result = new import__45.Cartesian3();
    const scalar = 2;
    const expectedResult = new import__45.Cartesian3(2, 4, 6);
    const returnedResult = import__45.Cartesian3.multiplyByScalar(
      cartesian2,
      scalar,
      result
    );
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("multiplyByScalar with a result parameter that is an input parameter", function() {
    const cartesian2 = new import__45.Cartesian3(1, 2, 3);
    const scalar = 2;
    const expectedResult = new import__45.Cartesian3(2, 4, 6);
    const returnedResult = import__45.Cartesian3.multiplyByScalar(
      cartesian2,
      scalar,
      cartesian2
    );
    expect(cartesian2).toBe(returnedResult);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("divideByScalar with a result parameter", function() {
    const cartesian2 = new import__45.Cartesian3(1, 2, 3);
    const result = new import__45.Cartesian3();
    const scalar = 2;
    const expectedResult = new import__45.Cartesian3(0.5, 1, 1.5);
    const returnedResult = import__45.Cartesian3.divideByScalar(cartesian2, scalar, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("divideByScalar with a result parameter that is an input parameter", function() {
    const cartesian2 = new import__45.Cartesian3(1, 2, 3);
    const scalar = 2;
    const expectedResult = new import__45.Cartesian3(0.5, 1, 1.5);
    const returnedResult = import__45.Cartesian3.divideByScalar(
      cartesian2,
      scalar,
      cartesian2
    );
    expect(cartesian2).toBe(returnedResult);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("negate without a result parameter", function() {
    const cartesian2 = new import__45.Cartesian3(1, -2, -5);
    const expectedResult = new import__45.Cartesian3(-1, 2, 5);
    const result = import__45.Cartesian3.negate(cartesian2, new import__45.Cartesian3());
    expect(result).toEqual(expectedResult);
  });
  it("negate with a result parameter", function() {
    const cartesian2 = new import__45.Cartesian3(1, -2, -5);
    const result = new import__45.Cartesian3();
    const expectedResult = new import__45.Cartesian3(-1, 2, 5);
    const returnedResult = import__45.Cartesian3.negate(cartesian2, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("negate with a result parameter that is an input parameter", function() {
    const cartesian2 = new import__45.Cartesian3(1, -2, -5);
    const expectedResult = new import__45.Cartesian3(-1, 2, 5);
    const returnedResult = import__45.Cartesian3.negate(cartesian2, cartesian2);
    expect(cartesian2).toBe(returnedResult);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("abs without a result parameter", function() {
    const cartesian2 = new import__45.Cartesian3(1, -2, -4);
    const expectedResult = new import__45.Cartesian3(1, 2, 4);
    const result = import__45.Cartesian3.abs(cartesian2, new import__45.Cartesian3());
    expect(result).toEqual(expectedResult);
  });
  it("abs with a result parameter", function() {
    const cartesian2 = new import__45.Cartesian3(1, -2, -4);
    const result = new import__45.Cartesian3();
    const expectedResult = new import__45.Cartesian3(1, 2, 4);
    const returnedResult = import__45.Cartesian3.abs(cartesian2, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("abs with a result parameter that is an input parameter", function() {
    const cartesian2 = new import__45.Cartesian3(1, -2, -4);
    const expectedResult = new import__45.Cartesian3(1, 2, 4);
    const returnedResult = import__45.Cartesian3.abs(cartesian2, cartesian2);
    expect(cartesian2).toBe(returnedResult);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("lerp works with a result parameter", function() {
    const start = new import__45.Cartesian3(4, 8, 10);
    const end = new import__45.Cartesian3(8, 20, 20);
    const t = 0.25;
    const result = new import__45.Cartesian3();
    const expectedResult = new import__45.Cartesian3(5, 11, 12.5);
    const returnedResult = import__45.Cartesian3.lerp(start, end, t, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("lerp works with a result parameter that is an input parameter", function() {
    const start = new import__45.Cartesian3(4, 8, 10);
    const end = new import__45.Cartesian3(8, 20, 20);
    const t = 0.25;
    const expectedResult = new import__45.Cartesian3(5, 11, 12.5);
    const returnedResult = import__45.Cartesian3.lerp(start, end, t, start);
    expect(start).toBe(returnedResult);
    expect(start).toEqual(expectedResult);
  });
  it("lerp extrapolate forward", function() {
    const start = new import__45.Cartesian3(4, 8, 10);
    const end = new import__45.Cartesian3(8, 20, 20);
    const t = 2;
    const expectedResult = new import__45.Cartesian3(12, 32, 30);
    const result = import__45.Cartesian3.lerp(start, end, t, new import__45.Cartesian3());
    expect(result).toEqual(expectedResult);
  });
  it("lerp extrapolate backward", function() {
    const start = new import__45.Cartesian3(4, 8, 10);
    const end = new import__45.Cartesian3(8, 20, 20);
    const t = -1;
    const expectedResult = new import__45.Cartesian3(0, -4, 0);
    const result = import__45.Cartesian3.lerp(start, end, t, new import__45.Cartesian3());
    expect(result).toEqual(expectedResult);
  });
  it("angleBetween works for right angles", function() {
    const x = import__45.Cartesian3.UNIT_X;
    const y = import__45.Cartesian3.UNIT_Y;
    expect(import__45.Cartesian3.angleBetween(x, y)).toEqual(import__46.Math.PI_OVER_TWO);
    expect(import__45.Cartesian3.angleBetween(y, x)).toEqual(import__46.Math.PI_OVER_TWO);
  });
  it("angleBetween works for acute angles", function() {
    const x = new import__45.Cartesian3(0, 1, 0);
    const y = new import__45.Cartesian3(1, 1, 0);
    expect(import__45.Cartesian3.angleBetween(x, y)).toEqualEpsilon(
      import__46.Math.PI_OVER_FOUR,
      import__46.Math.EPSILON14
    );
    expect(import__45.Cartesian3.angleBetween(y, x)).toEqualEpsilon(
      import__46.Math.PI_OVER_FOUR,
      import__46.Math.EPSILON14
    );
  });
  it("angleBetween works for obtuse angles", function() {
    const x = new import__45.Cartesian3(0, 1, 0);
    const y = new import__45.Cartesian3(0, -1, -1);
    expect(import__45.Cartesian3.angleBetween(x, y)).toEqualEpsilon(
      import__46.Math.PI * 3 / 4,
      import__46.Math.EPSILON14
    );
    expect(import__45.Cartesian3.angleBetween(y, x)).toEqualEpsilon(
      import__46.Math.PI * 3 / 4,
      import__46.Math.EPSILON14
    );
  });
  it("angleBetween works for zero angles", function() {
    const x = import__45.Cartesian3.UNIT_X;
    expect(import__45.Cartesian3.angleBetween(x, x)).toEqual(0);
  });
  it("most orthogonal angle is x", function() {
    const v2 = new import__45.Cartesian3(0, 1, 2);
    expect(import__45.Cartesian3.mostOrthogonalAxis(v2, new import__45.Cartesian3())).toEqual(
      import__45.Cartesian3.UNIT_X
    );
  });
  it("most orthogonal angle is y", function() {
    const v2 = new import__45.Cartesian3(1, 0, 2);
    expect(import__45.Cartesian3.mostOrthogonalAxis(v2, new import__45.Cartesian3())).toEqual(
      import__45.Cartesian3.UNIT_Y
    );
  });
  it("most orthogonal angle is z", function() {
    let v2 = new import__45.Cartesian3(1, 3, 0);
    expect(import__45.Cartesian3.mostOrthogonalAxis(v2, new import__45.Cartesian3())).toEqual(
      import__45.Cartesian3.UNIT_Z
    );
    v2 = new import__45.Cartesian3(3, 1, 0);
    expect(import__45.Cartesian3.mostOrthogonalAxis(v2, new import__45.Cartesian3())).toEqual(
      import__45.Cartesian3.UNIT_Z
    );
  });
  it("equals", function() {
    const cartesian2 = new import__45.Cartesian3(1, 2, 3);
    expect(import__45.Cartesian3.equals(cartesian2, new import__45.Cartesian3(1, 2, 3))).toEqual(
      true
    );
    expect(import__45.Cartesian3.equals(cartesian2, new import__45.Cartesian3(2, 2, 3))).toEqual(
      false
    );
    expect(import__45.Cartesian3.equals(cartesian2, new import__45.Cartesian3(2, 1, 3))).toEqual(
      false
    );
    expect(import__45.Cartesian3.equals(cartesian2, new import__45.Cartesian3(1, 2, 4))).toEqual(
      false
    );
    expect(import__45.Cartesian3.equals(cartesian2, void 0)).toEqual(false);
  });
  it("equalsEpsilon", function() {
    let cartesian2 = new import__45.Cartesian3(1, 2, 3);
    expect(cartesian2.equalsEpsilon(new import__45.Cartesian3(1, 2, 3), 0)).toEqual(
      true
    );
    expect(cartesian2.equalsEpsilon(new import__45.Cartesian3(1, 2, 3), 1)).toEqual(
      true
    );
    expect(cartesian2.equalsEpsilon(new import__45.Cartesian3(2, 2, 3), 1)).toEqual(
      true
    );
    expect(cartesian2.equalsEpsilon(new import__45.Cartesian3(1, 3, 3), 1)).toEqual(
      true
    );
    expect(cartesian2.equalsEpsilon(new import__45.Cartesian3(1, 2, 4), 1)).toEqual(
      true
    );
    expect(
      cartesian2.equalsEpsilon(
        new import__45.Cartesian3(2, 2, 3),
        import__46.Math.EPSILON6
      )
    ).toEqual(false);
    expect(
      cartesian2.equalsEpsilon(
        new import__45.Cartesian3(1, 3, 3),
        import__46.Math.EPSILON6
      )
    ).toEqual(false);
    expect(
      cartesian2.equalsEpsilon(
        new import__45.Cartesian3(1, 2, 4),
        import__46.Math.EPSILON6
      )
    ).toEqual(false);
    expect(cartesian2.equalsEpsilon(void 0, 1)).toEqual(false);
    cartesian2 = new import__45.Cartesian3(3e6, 4e6, 5e6);
    expect(
      cartesian2.equalsEpsilon(
        new import__45.Cartesian3(3e6, 4e6, 5e6),
        0
      )
    ).toEqual(true);
    expect(
      cartesian2.equalsEpsilon(
        new import__45.Cartesian3(30000002e-1, 4e6, 5e6),
        import__46.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian2.equalsEpsilon(
        new import__45.Cartesian3(3e6, 40000002e-1, 5e6),
        import__46.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian2.equalsEpsilon(
        new import__45.Cartesian3(3e6, 4e6, 50000002e-1),
        import__46.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian2.equalsEpsilon(
        new import__45.Cartesian3(30000002e-1, 40000002e-1, 50000002e-1),
        import__46.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian2.equalsEpsilon(
        new import__45.Cartesian3(30000002e-1, 40000002e-1, 50000002e-1),
        import__46.Math.EPSILON9
      )
    ).toEqual(false);
    expect(cartesian2.equalsEpsilon(void 0, 1)).toEqual(false);
    expect(import__45.Cartesian3.equalsEpsilon(void 0, cartesian2, 1)).toEqual(false);
  });
  it("toString", function() {
    const cartesian2 = new import__45.Cartesian3(1.123, 2.345, 6.789);
    expect(cartesian2.toString()).toEqual("(1.123, 2.345, 6.789)");
  });
  it("cross works with a result parameter", function() {
    const left = new import__45.Cartesian3(1, 2, 5);
    const right = new import__45.Cartesian3(4, 3, 6);
    const result = new import__45.Cartesian3();
    const expectedResult = new import__45.Cartesian3(-3, 14, -5);
    const returnedResult = import__45.Cartesian3.cross(left, right, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqual(expectedResult);
  });
  it("cross works with a result parameter that is an input parameter", function() {
    const left = new import__45.Cartesian3(1, 2, 5);
    const right = new import__45.Cartesian3(4, 3, 6);
    const expectedResult = new import__45.Cartesian3(-3, 14, -5);
    const returnedResult = import__45.Cartesian3.cross(left, right, left);
    expect(returnedResult).toBe(left);
    expect(left).toEqual(expectedResult);
  });
  it("midpoint works with a result parameter", function() {
    const left = new import__45.Cartesian3(0, 0, 6);
    const right = new import__45.Cartesian3(0, 0, -6);
    const result = new import__45.Cartesian3();
    const expectedResult = new import__45.Cartesian3(0, 0, 0);
    const returnedResult = import__45.Cartesian3.midpoint(left, right, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqual(expectedResult);
  });
  it("midpoint throws with no left", function() {
    expect(function() {
      return import__45.Cartesian3.midpoint(void 0, new import__45.Cartesian3(), new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("midpoint throws with no right", function() {
    expect(function() {
      return import__45.Cartesian3.midpoint(new import__45.Cartesian3(), void 0, new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("midpoint throws with no result", function() {
    expect(function() {
      return import__45.Cartesian3.midpoint(new import__45.Cartesian3(), new import__45.Cartesian3(), void 0);
    }).toThrowDeveloperError();
  });
  it("fromSpherical throws with no spherical parameter", function() {
    expect(function() {
      import__45.Cartesian3.fromSpherical(void 0);
    }).toThrowDeveloperError();
  });
  it("fromSpherical work with no result parameter", function() {
    expect(function() {
      import__45.Cartesian3.fromSpherical({
        clock: sixtyDegrees,
        cone: fortyFiveDegrees + Math.PI / 2,
        magnitude: Math.sqrt(8)
      });
    }).not.toThrowDeveloperError();
  });
  it("clone returns undefined with no parameter", function() {
    expect(import__45.Cartesian3.clone()).toBeUndefined();
  });
  it("maximumComponent throws with no parameter", function() {
    expect(function() {
      import__45.Cartesian3.maximumComponent();
    }).toThrowDeveloperError();
  });
  it("minimumComponent throws with no parameter", function() {
    expect(function() {
      import__45.Cartesian3.minimumComponent();
    }).toThrowDeveloperError();
  });
  it("magnitudeSquared throws with no parameter", function() {
    expect(function() {
      import__45.Cartesian3.magnitudeSquared();
    }).toThrowDeveloperError();
  });
  it("magnitude throws with no parameter", function() {
    expect(function() {
      import__45.Cartesian3.magnitude();
    }).toThrowDeveloperError();
  });
  it("normalize throws with no parameter", function() {
    expect(function() {
      import__45.Cartesian3.normalize();
    }).toThrowDeveloperError();
  });
  it("dot throws with no left parameter", function() {
    expect(function() {
      import__45.Cartesian3.dot(void 0, new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throw with no left parameter", function() {
    const right = new import__45.Cartesian3(4, 5, 6);
    expect(function() {
      import__45.Cartesian3.multiplyComponents(void 0, right);
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throw with no right parameter", function() {
    const left = new import__45.Cartesian3(4, 5, 6);
    expect(function() {
      import__45.Cartesian3.multiplyComponents(left, void 0);
    }).toThrowDeveloperError();
  });
  it("divideComponents throw with no left parameter", function() {
    const right = new import__45.Cartesian3(4, 5, 6);
    expect(function() {
      import__45.Cartesian3.divideComponents(void 0, right);
    }).toThrowDeveloperError();
  });
  it("divideComponents throw with no right parameter", function() {
    const left = new import__45.Cartesian3(4, 5, 6);
    expect(function() {
      import__45.Cartesian3.divideComponents(left, void 0);
    }).toThrowDeveloperError();
  });
  it("dot throws with no right parameter", function() {
    expect(function() {
      import__45.Cartesian3.dot(new import__45.Cartesian3(), void 0);
    }).toThrowDeveloperError();
  });
  it("add throws with no left parameter", function() {
    expect(function() {
      import__45.Cartesian3.add(void 0, new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("add throws with no right parameter", function() {
    expect(function() {
      import__45.Cartesian3.add(new import__45.Cartesian3(), void 0);
    }).toThrowDeveloperError();
  });
  it("subtract throws with no left parameter", function() {
    expect(function() {
      import__45.Cartesian3.subtract(void 0, new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("subtract throws with no right parameter", function() {
    expect(function() {
      import__45.Cartesian3.subtract(new import__45.Cartesian3(), void 0);
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no cartesian parameter", function() {
    expect(function() {
      import__45.Cartesian3.multiplyByScalar(void 0, 2);
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no scalar parameter", function() {
    expect(function() {
      import__45.Cartesian3.multiplyByScalar(new import__45.Cartesian3(), void 0);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no cartesian parameter", function() {
    expect(function() {
      import__45.Cartesian3.divideByScalar(void 0, 2);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no scalar parameter", function() {
    expect(function() {
      import__45.Cartesian3.divideByScalar(new import__45.Cartesian3(), void 0);
    }).toThrowDeveloperError();
  });
  it("negate throws with no cartesian parameter", function() {
    expect(function() {
      import__45.Cartesian3.negate(void 0);
    }).toThrowDeveloperError();
  });
  it("abs throws with no cartesian parameter", function() {
    expect(function() {
      import__45.Cartesian3.abs(void 0);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no start parameter", function() {
    const end = new import__45.Cartesian3(8, 20, 6);
    const t = 0.25;
    expect(function() {
      import__45.Cartesian3.lerp(void 0, end, t);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no end parameter", function() {
    const start = new import__45.Cartesian3(4, 8, 6);
    const t = 0.25;
    expect(function() {
      import__45.Cartesian3.lerp(start, void 0, t);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no t parameter", function() {
    const start = new import__45.Cartesian3(4, 8, 6);
    const end = new import__45.Cartesian3(8, 20, 6);
    expect(function() {
      import__45.Cartesian3.lerp(start, end, void 0);
    }).toThrowDeveloperError();
  });
  it("angleBetween throws with no left parameter", function() {
    const right = new import__45.Cartesian3(8, 20, 6);
    expect(function() {
      import__45.Cartesian3.angleBetween(void 0, right);
    }).toThrowDeveloperError();
  });
  it("angleBetween throws with no right parameter", function() {
    const left = new import__45.Cartesian3(4, 8, 6);
    expect(function() {
      import__45.Cartesian3.angleBetween(left, void 0);
    }).toThrowDeveloperError();
  });
  it("mostOrthogonalAxis throws with no cartesian parameter", function() {
    expect(function() {
      import__45.Cartesian3.mostOrthogonalAxis(void 0);
    }).toThrowDeveloperError();
  });
  it("cross throw with no left paramater", function() {
    const right = new import__45.Cartesian3(4, 3, 6);
    expect(function() {
      import__45.Cartesian3.cross(void 0, right);
    }).toThrowDeveloperError();
  });
  it("cross throw with no left paramater", function() {
    const left = new import__45.Cartesian3(1, 2, 5);
    expect(function() {
      import__45.Cartesian3.cross(left, void 0);
    }).toThrowDeveloperError();
  });
  it("fromElements returns a cartesian3 with corrrect coordinates", function() {
    const cartesian2 = import__45.Cartesian3.fromElements(2, 2, 4);
    const expectedResult = new import__45.Cartesian3(2, 2, 4);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("fromElements result param returns cartesian3 with correct coordinates", function() {
    const cartesian3 = new import__45.Cartesian3();
    import__45.Cartesian3.fromElements(2, 2, 4, cartesian3);
    const expectedResult = new import__45.Cartesian3(2, 2, 4);
    expect(cartesian3).toEqual(expectedResult);
  });
  it("fromDegrees", function() {
    const lon = -115;
    const lat = 37;
    const ellipsoid = import__45.Ellipsoid.WGS84;
    const actual = import__45.Cartesian3.fromDegrees(lon, lat);
    const expected = ellipsoid.cartographicToCartesian(
      import__45.Cartographic.fromDegrees(lon, lat)
    );
    expect(actual).toEqual(expected);
  });
  it("fromDegrees with height", function() {
    const lon = -115;
    const lat = 37;
    const height = 1e5;
    const ellipsoid = import__45.Ellipsoid.WGS84;
    const actual = import__45.Cartesian3.fromDegrees(lon, lat, height);
    const expected = ellipsoid.cartographicToCartesian(
      import__45.Cartographic.fromDegrees(lon, lat, height)
    );
    expect(actual).toEqual(expected);
  });
  it("fromDegrees with result", function() {
    const lon = -115;
    const lat = 37;
    const height = 1e5;
    const ellipsoid = import__45.Ellipsoid.WGS84;
    const result = new import__45.Cartesian3();
    const actual = import__45.Cartesian3.fromDegrees(lon, lat, height, ellipsoid, result);
    const expected = ellipsoid.cartographicToCartesian(
      import__45.Cartographic.fromDegrees(lon, lat, height)
    );
    expect(actual).toEqual(expected);
    expect(actual).toBe(result);
  });
  it("fromDegrees throws with no longitude", function() {
    expect(function() {
      import__45.Cartesian3.fromDegrees();
    }).toThrowDeveloperError();
  });
  it("fromDegrees throws with no latitude", function() {
    expect(function() {
      import__45.Cartesian3.fromDegrees(1);
    }).toThrowDeveloperError();
  });
  it("fromRadians", function() {
    const lon = import__46.Math.toRadians(150);
    const lat = import__46.Math.toRadians(-40);
    const ellipsoid = import__45.Ellipsoid.WGS84;
    const actual = import__45.Cartesian3.fromRadians(lon, lat);
    const expected = ellipsoid.cartographicToCartesian(
      new import__45.Cartographic(lon, lat)
    );
    expect(actual).toEqual(expected);
  });
  it("fromRadians with height", function() {
    const lon = import__46.Math.toRadians(150);
    const lat = import__46.Math.toRadians(-40);
    const height = 1e5;
    const ellipsoid = import__45.Ellipsoid.WGS84;
    const actual = import__45.Cartesian3.fromRadians(lon, lat, height);
    const expected = ellipsoid.cartographicToCartesian(
      new import__45.Cartographic(lon, lat, height)
    );
    expect(actual).toEqual(expected);
  });
  it("fromRadians with result", function() {
    const lon = import__46.Math.toRadians(150);
    const lat = import__46.Math.toRadians(-40);
    const height = 1e5;
    const ellipsoid = import__45.Ellipsoid.WGS84;
    const result = new import__45.Cartesian3();
    const actual = import__45.Cartesian3.fromRadians(lon, lat, height, ellipsoid, result);
    const expected = ellipsoid.cartographicToCartesian(
      new import__45.Cartographic(lon, lat, height)
    );
    expect(actual).toEqual(expected);
    expect(actual).toBe(result);
  });
  it("fromRadians throws with no longitude", function() {
    expect(function() {
      import__45.Cartesian3.fromRadians();
    }).toThrowDeveloperError();
  });
  it("fromRadians throws with no latitude", function() {
    expect(function() {
      import__45.Cartesian3.fromRadians(1);
    }).toThrowDeveloperError();
  });
  it("fromDegreesArray", function() {
    const lon1 = 90;
    const lat1 = -70;
    const lon2 = -100;
    const lat2 = 40;
    const ellipsoid = import__45.Ellipsoid.WGS84;
    const actual = import__45.Cartesian3.fromDegreesArray([lon1, lat1, lon2, lat2]);
    const expected = ellipsoid.cartographicArrayToCartesianArray([
      import__45.Cartographic.fromDegrees(lon1, lat1),
      import__45.Cartographic.fromDegrees(lon2, lat2)
    ]);
    expect(actual).toEqual(expected);
  });
  it("fromDegreesArray throws with no positions", function() {
    expect(function() {
      import__45.Cartesian3.fromDegreesArray();
    }).toThrowDeveloperError();
  });
  it("fromDegreesArray throws with positions length < 2", function() {
    expect(function() {
      import__45.Cartesian3.fromDegreesArray([]);
    }).toThrowDeveloperError();
  });
  it("fromDegreesArray throws with positions length not multiple of 2", function() {
    expect(function() {
      import__45.Cartesian3.fromDegreesArray([1, 3, 5]);
    }).toThrowDeveloperError();
  });
  it("fromRadiansArray", function() {
    const lon1 = import__46.Math.toRadians(90);
    const lat1 = import__46.Math.toRadians(-70);
    const lon2 = import__46.Math.toRadians(-100);
    const lat2 = import__46.Math.toRadians(40);
    const ellipsoid = import__45.Ellipsoid.WGS84;
    const actual = import__45.Cartesian3.fromRadiansArray([lon1, lat1, lon2, lat2]);
    const expected = ellipsoid.cartographicArrayToCartesianArray([
      new import__45.Cartographic(lon1, lat1),
      new import__45.Cartographic(lon2, lat2)
    ]);
    expect(actual).toEqual(expected);
  });
  it("fromRadiansArray with result", function() {
    const lon1 = import__46.Math.toRadians(90);
    const lat1 = import__46.Math.toRadians(-70);
    const lon2 = import__46.Math.toRadians(-100);
    const lat2 = import__46.Math.toRadians(40);
    const ellipsoid = import__45.Ellipsoid.WGS84;
    const result = [new import__45.Cartesian3(), new import__45.Cartesian3()];
    const actual = import__45.Cartesian3.fromRadiansArray(
      [lon1, lat1, lon2, lat2],
      ellipsoid,
      result
    );
    const expected = ellipsoid.cartographicArrayToCartesianArray([
      new import__45.Cartographic(lon1, lat1),
      new import__45.Cartographic(lon2, lat2)
    ]);
    expect(result).toEqual(expected);
    expect(actual).toBe(result);
  });
  it("fromRadiansArray throws with no positions", function() {
    expect(function() {
      import__45.Cartesian3.fromRadiansArray();
    }).toThrowDeveloperError();
  });
  it("fromRadiansArray throws with positions length < 2", function() {
    expect(function() {
      import__45.Cartesian3.fromRadiansArray([]);
    }).toThrowDeveloperError();
  });
  it("fromRadiansArray throws with positions length not multiple of 2", function() {
    expect(function() {
      import__45.Cartesian3.fromRadiansArray([1, 3, 5]);
    }).toThrowDeveloperError();
  });
  it("fromDegreesArrayHeights", function() {
    const lon1 = 90;
    const lat1 = -70;
    const alt1 = 2e5;
    const lon2 = -100;
    const lat2 = 40;
    const alt2 = 1e5;
    const ellipsoid = import__45.Ellipsoid.WGS84;
    const actual = import__45.Cartesian3.fromDegreesArrayHeights([
      lon1,
      lat1,
      alt1,
      lon2,
      lat2,
      alt2
    ]);
    const expected = ellipsoid.cartographicArrayToCartesianArray([
      import__45.Cartographic.fromDegrees(lon1, lat1, alt1),
      import__45.Cartographic.fromDegrees(lon2, lat2, alt2)
    ]);
    expect(actual).toEqual(expected);
  });
  it("fromDegreesArrayHeights throws with no positions", function() {
    expect(function() {
      import__45.Cartesian3.fromDegreesArrayHeights();
    }).toThrowDeveloperError();
  });
  it("fromDegreesArrayHeights throws with positions length < 3", function() {
    expect(function() {
      import__45.Cartesian3.fromDegreesArrayHeights([]);
    }).toThrowDeveloperError();
  });
  it("fromDegreesArrayHeights throws with positions length not multiple of 3", function() {
    expect(function() {
      import__45.Cartesian3.fromDegreesArrayHeights([1, 3, 5, 2]);
    }).toThrowDeveloperError();
  });
  it("fromRadiansArrayHeights", function() {
    const lon1 = import__46.Math.toRadians(90);
    const lat1 = import__46.Math.toRadians(-70);
    const alt1 = 2e5;
    const lon2 = import__46.Math.toRadians(-100);
    const lat2 = import__46.Math.toRadians(40);
    const alt2 = 1e5;
    const ellipsoid = import__45.Ellipsoid.WGS84;
    const actual = import__45.Cartesian3.fromRadiansArrayHeights([
      lon1,
      lat1,
      alt1,
      lon2,
      lat2,
      alt2
    ]);
    const expected = ellipsoid.cartographicArrayToCartesianArray([
      new import__45.Cartographic(lon1, lat1, alt1),
      new import__45.Cartographic(lon2, lat2, alt2)
    ]);
    expect(actual).toEqual(expected);
  });
  it("fromRadiansArrayHeights with result", function() {
    const lon1 = import__46.Math.toRadians(90);
    const lat1 = import__46.Math.toRadians(-70);
    const alt1 = 2e5;
    const lon2 = import__46.Math.toRadians(-100);
    const lat2 = import__46.Math.toRadians(40);
    const alt2 = 1e5;
    const ellipsoid = import__45.Ellipsoid.WGS84;
    const result = [new import__45.Cartesian3(), new import__45.Cartesian3()];
    const actual = import__45.Cartesian3.fromRadiansArrayHeights(
      [lon1, lat1, alt1, lon2, lat2, alt2],
      ellipsoid,
      result
    );
    const expected = ellipsoid.cartographicArrayToCartesianArray([
      new import__45.Cartographic(lon1, lat1, alt1),
      new import__45.Cartographic(lon2, lat2, alt2)
    ]);
    expect(result).toEqual(expected);
    expect(actual).toBe(result);
  });
  it("fromRadiansArrayHeights throws with no positions", function() {
    expect(function() {
      import__45.Cartesian3.fromRadiansArrayHeights();
    }).toThrowDeveloperError();
  });
  it("fromRadiansArrayHeights throws with positions length < 3", function() {
    expect(function() {
      import__45.Cartesian3.fromRadiansArrayHeights([]);
    }).toThrowDeveloperError();
  });
  it("fromRadiansArrayHeights throws with positions length not multiple of 3", function() {
    expect(function() {
      import__45.Cartesian3.fromRadiansArrayHeights([1, 3, 5, 2]);
    }).toThrowDeveloperError();
  });
  it("minimumByComponent throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.minimumByComponent(new import__45.Cartesian3(), new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("maximumByComponent throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.maximumByComponent(new import__45.Cartesian3(), new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("clamp throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.clamp(new import__45.Cartesian3(), new import__45.Cartesian3(), new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("normalize throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.normalize(new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.multiplyComponents(new import__45.Cartesian3(), new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("divideComponents throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.divideComponents(new import__45.Cartesian3(), new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("add throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.add(new import__45.Cartesian3(), new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("subtract throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.subtract(new import__45.Cartesian3(), new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.multiplyByScalar(new import__45.Cartesian3(), 5);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.divideByScalar(new import__45.Cartesian3(), 5);
    }).toThrowDeveloperError();
  });
  it("negate throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.negate(new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("abs throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.abs(new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("cross throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.cross(new import__45.Cartesian3(), new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("lerp throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.lerp(new import__45.Cartesian3(), new import__45.Cartesian3(), 10);
    }).toThrowDeveloperError();
  });
  it("mostOrthogonalAxis throws with no result", function() {
    expect(function() {
      import__45.Cartesian3.mostOrthogonalAxis(new import__45.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("projects vector a onto vector b", function() {
    let a = new import__45.Cartesian3(0, 1, 0);
    let b = new import__45.Cartesian3(1, 0, 0);
    let result = import__45.Cartesian3.projectVector(a, b, new import__45.Cartesian3());
    expect(result).toEqual(new import__45.Cartesian3(0, 0, 0));
    a = new import__45.Cartesian3(1, 1, 0);
    b = new import__45.Cartesian3(1, 0, 0);
    result = import__45.Cartesian3.projectVector(a, b, new import__45.Cartesian3());
    expect(result).toEqual(new import__45.Cartesian3(1, 0, 0));
  });
  it("projectVector throws when missing parameters", function() {
    expect(function() {
      return import__45.Cartesian3.projectVector(
        void 0,
        new import__45.Cartesian3(),
        new import__45.Cartesian3()
      );
    }).toThrowDeveloperError();
    expect(function() {
      return import__45.Cartesian3.projectVector(
        new import__45.Cartesian3(),
        void 0,
        new import__45.Cartesian3()
      );
    }).toThrowDeveloperError();
    expect(function() {
      return import__45.Cartesian3.projectVector(
        new import__45.Cartesian3(),
        new import__45.Cartesian3(),
        void 0
      );
    }).toThrowDeveloperError();
  });
  createPackableSpecs_default(import__45.Cartesian3, new import__45.Cartesian3(1, 2, 3), [1, 2, 3]);
  createPackableArraySpecs_default(
    import__45.Cartesian3,
    [new import__45.Cartesian3(1, 2, 3), new import__45.Cartesian3(4, 5, 6)],
    [1, 2, 3, 4, 5, 6],
    3
  );
});

// packages/engine/Specs/Core/Cartesian4Spec.js
var import__47 = __toESM(require_Cesium(), 1);
var import__48 = __toESM(require_Cesium(), 1);
describe("Core/Cartesian4", function() {
  it("construct with default values", function() {
    const cartesian = new import__47.Cartesian4();
    expect(cartesian.x).toEqual(0);
    expect(cartesian.y).toEqual(0);
    expect(cartesian.z).toEqual(0);
    expect(cartesian.w).toEqual(0);
  });
  it("construct with all values", function() {
    const cartesian = new import__47.Cartesian4(1, 2, 3, 4);
    expect(cartesian.x).toEqual(1);
    expect(cartesian.y).toEqual(2);
    expect(cartesian.z).toEqual(3);
    expect(cartesian.w).toEqual(4);
  });
  it("fromArray creates a Cartesian4", function() {
    const cartesian = import__47.Cartesian4.fromArray([1, 2, 3, 4]);
    expect(cartesian).toEqual(new import__47.Cartesian4(1, 2, 3, 4));
  });
  it("fromArray with an offset creates a Cartesian4", function() {
    const cartesian = import__47.Cartesian4.fromArray([0, 1, 2, 3, 4, 0], 1);
    expect(cartesian).toEqual(new import__47.Cartesian4(1, 2, 3, 4));
  });
  it("fromArray creates a Cartesian4 with a result parameter", function() {
    const cartesian = new import__47.Cartesian4();
    const result = import__47.Cartesian4.fromArray([1, 2, 3, 4], 0, cartesian);
    expect(result).toBe(cartesian);
    expect(result).toEqual(new import__47.Cartesian4(1, 2, 3, 4));
  });
  it("fromArray throws without values", function() {
    expect(function() {
      import__47.Cartesian4.fromArray();
    }).toThrowDeveloperError();
  });
  it("fromElements returns a cartesian4 with corrrect coordinates", function() {
    const cartesian4 = import__47.Cartesian4.fromElements(2, 2, 4, 7);
    const expectedResult = new import__47.Cartesian4(2, 2, 4, 7);
    expect(cartesian4).toEqual(expectedResult);
  });
  it("fromElements result param returns cartesian4 with correct coordinates", function() {
    const cartesian4 = new import__47.Cartesian4();
    import__47.Cartesian4.fromElements(2, 2, 4, 7, cartesian4);
    const expectedResult = new import__47.Cartesian4(2, 2, 4, 7);
    expect(cartesian4).toEqual(expectedResult);
  });
  it("fromColor returns a cartesian4 with corrrect coordinates", function() {
    const cartesian4 = import__47.Cartesian4.fromColor(new import__47.Color(1, 2, 3, 4));
    expect(cartesian4).toEqual(new import__47.Cartesian4(1, 2, 3, 4));
  });
  it("fromColor result param returns cartesian4 with correct coordinates", function() {
    const cartesian4 = new import__47.Cartesian4();
    const result = import__47.Cartesian4.fromColor(
      new import__47.Color(1, 2, 3, 4),
      cartesian4
    );
    expect(cartesian4).toBe(result);
    expect(cartesian4).toEqual(new import__47.Cartesian4(1, 2, 3, 4));
  });
  it("fromColor throws without color", function() {
    expect(function() {
      import__47.Cartesian4.fromColor();
    }).toThrowDeveloperError();
  });
  it("clone without a result parameter", function() {
    const cartesian = new import__47.Cartesian4(1, 2, 3, 4);
    const result = import__47.Cartesian4.clone(cartesian, new import__47.Cartesian4());
    expect(cartesian).not.toBe(result);
    expect(cartesian).toEqual(result);
  });
  it("clone with a result parameter", function() {
    const cartesian = new import__47.Cartesian4(1, 2, 3, 4);
    const result = new import__47.Cartesian4();
    const returnedResult = import__47.Cartesian4.clone(cartesian, result);
    expect(cartesian).not.toBe(result);
    expect(result).toBe(returnedResult);
    expect(cartesian).toEqual(result);
  });
  it("clone works with a result parameter that is an input parameter", function() {
    const cartesian = new import__47.Cartesian4(1, 2, 3, 4);
    const returnedResult = import__47.Cartesian4.clone(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
  });
  it("maximumComponent works when X is greater", function() {
    const cartesian = new import__47.Cartesian4(2, 1, 0, -1);
    expect(import__47.Cartesian4.maximumComponent(cartesian)).toEqual(cartesian.x);
  });
  it("maximumComponent works when Y is greater", function() {
    const cartesian = new import__47.Cartesian4(1, 2, 0, -1);
    expect(import__47.Cartesian4.maximumComponent(cartesian)).toEqual(cartesian.y);
  });
  it("maximumComponent works when Z is greater", function() {
    const cartesian = new import__47.Cartesian4(1, 2, 3, -1);
    expect(import__47.Cartesian4.maximumComponent(cartesian)).toEqual(cartesian.z);
  });
  it("maximumComponent works when W is greater", function() {
    const cartesian = new import__47.Cartesian4(1, 2, 3, 4);
    expect(import__47.Cartesian4.maximumComponent(cartesian)).toEqual(cartesian.w);
  });
  it("minimumComponent works when X is lesser", function() {
    const cartesian = new import__47.Cartesian4(1, 2, 3, 4);
    expect(import__47.Cartesian4.minimumComponent(cartesian)).toEqual(cartesian.x);
  });
  it("minimumComponent works when Y is lesser", function() {
    const cartesian = new import__47.Cartesian4(2, 1, 3, 4);
    expect(import__47.Cartesian4.minimumComponent(cartesian)).toEqual(cartesian.y);
  });
  it("minimumComponent works when Z is lesser", function() {
    const cartesian = new import__47.Cartesian4(2, 1, 0, 4);
    expect(import__47.Cartesian4.minimumComponent(cartesian)).toEqual(cartesian.z);
  });
  it("minimumComponent works when W is lesser", function() {
    const cartesian = new import__47.Cartesian4(2, 1, 0, -1);
    expect(import__47.Cartesian4.minimumComponent(cartesian)).toEqual(cartesian.w);
  });
  it("minimumByComponent", function() {
    let first;
    let second;
    let expected;
    const result = new import__47.Cartesian4();
    first = new import__47.Cartesian4(2, 0, 0, 0);
    second = new import__47.Cartesian4(1, 0, 0, 0);
    expected = new import__47.Cartesian4(1, 0, 0, 0);
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__47.Cartesian4(1, 0, 0, 0);
    second = new import__47.Cartesian4(2, 0, 0, 0);
    expected = new import__47.Cartesian4(1, 0, 0, 0);
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__47.Cartesian4(2, -15, 0, 0);
    second = new import__47.Cartesian4(1, -20, 0, 0);
    expected = new import__47.Cartesian4(1, -20, 0, 0);
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__47.Cartesian4(2, -20, 0, 0);
    second = new import__47.Cartesian4(1, -15, 0, 0);
    expected = new import__47.Cartesian4(1, -20, 0, 0);
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__47.Cartesian4(2, -15, 26.4, 0);
    second = new import__47.Cartesian4(1, -20, 26.5, 0);
    expected = new import__47.Cartesian4(1, -20, 26.4, 0);
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__47.Cartesian4(2, -15, 26.5, 0);
    second = new import__47.Cartesian4(1, -20, 26.4, 0);
    expected = new import__47.Cartesian4(1, -20, 26.4, 0);
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__47.Cartesian4(2, -15, 26.4, -450);
    second = new import__47.Cartesian4(1, -20, 26.5, 450);
    expected = new import__47.Cartesian4(1, -20, 26.4, -450);
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__47.Cartesian4(2, -15, 26.5, 450);
    second = new import__47.Cartesian4(1, -20, 26.4, -450);
    expected = new import__47.Cartesian4(1, -20, 26.4, -450);
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent with a result parameter", function() {
    const first = new import__47.Cartesian4(2, 0, 0, 0);
    const second = new import__47.Cartesian4(1, 0, 0, 0);
    const expected = new import__47.Cartesian4(1, 0, 0, 0);
    const result = new import__47.Cartesian4();
    const returnedResult = import__47.Cartesian4.minimumByComponent(first, second, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("minimumByComponent with a result parameter that is an input parameter", function() {
    const first = new import__47.Cartesian4(2, 0, 0, 0);
    const second = new import__47.Cartesian4(1, 0, 0, 0);
    const expected = new import__47.Cartesian4(1, 0, 0, 0);
    expect(import__47.Cartesian4.minimumByComponent(first, second, first)).toEqual(
      expected
    );
    first.x = 1;
    second.x = 2;
    expect(import__47.Cartesian4.minimumByComponent(first, second, second)).toEqual(
      expected
    );
  });
  it("minimumByComponent throws without first", function() {
    expect(function() {
      import__47.Cartesian4.minimumByComponent();
    }).toThrowDeveloperError();
  });
  it("minimumByComponent throws without second", function() {
    expect(function() {
      import__47.Cartesian4.minimumByComponent(new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("minimumByComponent works when first's or second's X is lesser", function() {
    const first = new import__47.Cartesian4(2, 0, 0, 0);
    const second = new import__47.Cartesian4(1, 0, 0, 0);
    const expected = new import__47.Cartesian4(1, 0, 0, 0);
    const result = new import__47.Cartesian4();
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.x = 3;
    expected.x = 2;
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent works when first's or second's Y is lesser", function() {
    const first = new import__47.Cartesian4(0, 2, 0, 0);
    const second = new import__47.Cartesian4(0, 1, 0, 0);
    const expected = new import__47.Cartesian4(0, 1, 0, 0);
    const result = new import__47.Cartesian4();
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.y = 3;
    expected.y = 2;
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent works when first's or second's Z is lesser", function() {
    const first = new import__47.Cartesian4(0, 0, 2, 0);
    const second = new import__47.Cartesian4(0, 0, 1, 0);
    const expected = new import__47.Cartesian4(0, 0, 1, 0);
    const result = new import__47.Cartesian4();
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.z = 3;
    expected.z = 2;
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent works when first's or second's W is lesser", function() {
    const first = new import__47.Cartesian4(0, 0, 0, 2);
    const second = new import__47.Cartesian4(0, 0, 0, 1);
    const expected = new import__47.Cartesian4(0, 0, 0, 1);
    const result = new import__47.Cartesian4();
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.w = 3;
    expected.w = 2;
    expect(import__47.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent", function() {
    let first;
    let second;
    let expected;
    first = new import__47.Cartesian4(2, 0, 0, 0);
    second = new import__47.Cartesian4(1, 0, 0, 0);
    expected = new import__47.Cartesian4(2, 0, 0, 0);
    const result = new import__47.Cartesian4();
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__47.Cartesian4(1, 0, 0, 0);
    second = new import__47.Cartesian4(2, 0, 0, 0);
    expected = new import__47.Cartesian4(2, 0, 0, 0);
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__47.Cartesian4(2, -15, 0, 0);
    second = new import__47.Cartesian4(1, -20, 0, 0);
    expected = new import__47.Cartesian4(2, -15, 0, 0);
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__47.Cartesian4(2, -20, 0, 0);
    second = new import__47.Cartesian4(1, -15, 0, 0);
    expected = new import__47.Cartesian4(2, -15, 0, 0);
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__47.Cartesian4(2, -15, 26.4, 0);
    second = new import__47.Cartesian4(1, -20, 26.5, 0);
    expected = new import__47.Cartesian4(2, -15, 26.5, 0);
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__47.Cartesian4(2, -15, 26.5, 0);
    second = new import__47.Cartesian4(1, -20, 26.4, 0);
    expected = new import__47.Cartesian4(2, -15, 26.5, 0);
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__47.Cartesian4(2, -15, 26.5, 450);
    second = new import__47.Cartesian4(1, -20, 26.4, -450);
    expected = new import__47.Cartesian4(2, -15, 26.5, 450);
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__47.Cartesian4(2, -15, 26.5, -450);
    second = new import__47.Cartesian4(1, -20, 26.4, 450);
    expected = new import__47.Cartesian4(2, -15, 26.5, 450);
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent with a result parameter", function() {
    const first = new import__47.Cartesian4(2, 0, 0, 0);
    const second = new import__47.Cartesian4(1, 0, 0, 0);
    const expected = new import__47.Cartesian4(2, 0, 0, 0);
    const result = new import__47.Cartesian4();
    const returnedResult = import__47.Cartesian4.maximumByComponent(first, second, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("maximumByComponent with a result parameter that is an input parameter", function() {
    const first = new import__47.Cartesian4(2, 0, 0, 0);
    const second = new import__47.Cartesian4(1, 0, 0, 0);
    const expected = new import__47.Cartesian4(2, 0, 0, 0);
    expect(import__47.Cartesian4.maximumByComponent(first, second, first)).toEqual(
      expected
    );
    first.x = 1;
    second.x = 2;
    expect(import__47.Cartesian4.maximumByComponent(first, second, second)).toEqual(
      expected
    );
  });
  it("maximumByComponent with a result parameter that is an input parameter", function() {
    const first = new import__47.Cartesian4(2, 0, 0, 0);
    const second = new import__47.Cartesian4(1, 0, 0, 0);
    const expected = new import__47.Cartesian4(2, 0, 0, 0);
    expect(import__47.Cartesian4.maximumByComponent(first, second, second)).toEqual(
      expected
    );
    first.x = 1;
    second.x = 2;
    expect(import__47.Cartesian4.maximumByComponent(first, second, second)).toEqual(
      expected
    );
  });
  it("maximumByComponent throws without first", function() {
    expect(function() {
      import__47.Cartesian4.maximumByComponent();
    }).toThrowDeveloperError();
  });
  it("maximumByComponent throws without second", function() {
    expect(function() {
      import__47.Cartesian4.maximumByComponent(new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("maximumByComponent works when first's or second's X is greater", function() {
    const first = new import__47.Cartesian4(2, 0, 0, 0);
    const second = new import__47.Cartesian4(1, 0, 0, 0);
    const expected = new import__47.Cartesian4(2, 0, 0, 0);
    const result = new import__47.Cartesian4();
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.x = 3;
    expected.x = 3;
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent works when first's or second's Y is greater", function() {
    const first = new import__47.Cartesian4(0, 2, 0, 0);
    const second = new import__47.Cartesian4(0, 1, 0, 0);
    const expected = new import__47.Cartesian4(0, 2, 0, 0);
    const result = new import__47.Cartesian4();
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.y = 3;
    expected.y = 3;
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent works when first's or second's Z is greater", function() {
    const first = new import__47.Cartesian4(0, 0, 2, 0);
    const second = new import__47.Cartesian4(0, 0, 1, 0);
    const expected = new import__47.Cartesian4(0, 0, 2, 0);
    const result = new import__47.Cartesian4();
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.z = 3;
    expected.z = 3;
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent works when first's or second's W is greater", function() {
    const first = new import__47.Cartesian4(0, 0, 0, 2);
    const second = new import__47.Cartesian4(0, 0, 0, 1);
    const expected = new import__47.Cartesian4(0, 0, 0, 2);
    const result = new import__47.Cartesian4();
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.w = 3;
    expected.w = 3;
    expect(import__47.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("clamp", function() {
    let value;
    let min;
    let max;
    let expected;
    const result = new import__47.Cartesian4();
    value = new import__47.Cartesian4(-1, 0, 0);
    min = new import__47.Cartesian4(0, 0, 0);
    max = new import__47.Cartesian4(1, 1, 1);
    expected = new import__47.Cartesian4(0, 0, 0);
    expect(import__47.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
    value = new import__47.Cartesian4(2, 0, 0);
    min = new import__47.Cartesian4(0, 0, 0);
    max = new import__47.Cartesian4(1, 1, 1);
    expected = new import__47.Cartesian4(1, 0, 0);
    expect(import__47.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
    value = new import__47.Cartesian4(0, -1, 0);
    min = new import__47.Cartesian4(0, 0, 0);
    max = new import__47.Cartesian4(1, 1, 1);
    expected = new import__47.Cartesian4(0, 0, 0);
    expect(import__47.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
    value = new import__47.Cartesian4(0, 2, 0);
    min = new import__47.Cartesian4(0, 0, 0);
    max = new import__47.Cartesian4(1, 1, 1);
    expected = new import__47.Cartesian4(0, 1, 0);
    expect(import__47.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
    value = new import__47.Cartesian4(0, 0, -1);
    min = new import__47.Cartesian4(0, 0, 0);
    max = new import__47.Cartesian4(1, 1, 1);
    expected = new import__47.Cartesian4(0, 0, 0);
    expect(import__47.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
    value = new import__47.Cartesian4(0, 0, 2);
    min = new import__47.Cartesian4(0, 0, 0);
    max = new import__47.Cartesian4(1, 1, 1);
    expected = new import__47.Cartesian4(0, 0, 1);
    expect(import__47.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
    value = new import__47.Cartesian4(-2, 3, 4);
    min = new import__47.Cartesian4(0, 0, 0);
    max = new import__47.Cartesian4(1, 1, 1);
    expected = new import__47.Cartesian4(0, 1, 1);
    expect(import__47.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
    value = new import__47.Cartesian4(0, 0, 0);
    min = new import__47.Cartesian4(1, 2, 3);
    max = new import__47.Cartesian4(1, 2, 3);
    expected = new import__47.Cartesian4(1, 2, 3);
    expect(import__47.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
  });
  it("clamp with a result parameter", function() {
    const value = new import__47.Cartesian4(-1, -1, -1, -1);
    const min = new import__47.Cartesian4(0, 0, 0, 0);
    const max = new import__47.Cartesian4(1, 1, 1, 1);
    const expected = new import__47.Cartesian4(0, 0, 0, 0);
    const result = new import__47.Cartesian4();
    const returnedResult = import__47.Cartesian4.clamp(value, min, max, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("clamp with a result parameter that is an input parameter", function() {
    const value = new import__47.Cartesian4(-1, -1, -1, -1);
    const min = new import__47.Cartesian4(0, 0, 0, 0);
    const max = new import__47.Cartesian4(1, 1, 1, 1);
    const expected = new import__47.Cartesian4(0, 0, 0, 0);
    expect(import__47.Cartesian4.clamp(value, min, max, value)).toEqual(expected);
    import__47.Cartesian4.fromElements(-1, -1, -1, -1, value);
    expect(import__47.Cartesian4.clamp(value, min, max, min)).toEqual(expected);
    import__47.Cartesian4.fromElements(0, 0, 0, 0, min);
    expect(import__47.Cartesian4.clamp(value, min, max, max)).toEqual(expected);
  });
  it("clamp throws without value", function() {
    expect(function() {
      import__47.Cartesian4.clamp();
    }).toThrowDeveloperError();
  });
  it("clamp throws without min", function() {
    expect(function() {
      import__47.Cartesian4.clamp(new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("clamp throws without max", function() {
    expect(function() {
      import__47.Cartesian4.clamp(new import__47.Cartesian4(), new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("magnitudeSquared", function() {
    const cartesian = new import__47.Cartesian4(3, 4, 5, 6);
    expect(import__47.Cartesian4.magnitudeSquared(cartesian)).toEqual(86);
  });
  it("magnitude", function() {
    const cartesian = new import__47.Cartesian4(3, 4, 5, 6);
    expect(import__47.Cartesian4.magnitude(cartesian)).toEqual(Math.sqrt(86));
  });
  it("distance", function() {
    const distance = import__47.Cartesian4.distance(
      new import__47.Cartesian4(1, 0, 0, 0),
      new import__47.Cartesian4(2, 0, 0, 0)
    );
    expect(distance).toEqual(1);
  });
  it("distance throws without left", function() {
    expect(function() {
      import__47.Cartesian4.distance();
    }).toThrowDeveloperError();
  });
  it("distance throws without right", function() {
    expect(function() {
      import__47.Cartesian4.distance(import__47.Cartesian4.UNIT_X);
    }).toThrowDeveloperError();
  });
  it("distanceSquared", function() {
    const distanceSquared = import__47.Cartesian4.distanceSquared(
      new import__47.Cartesian4(1, 0, 0, 0),
      new import__47.Cartesian4(3, 0, 0, 0)
    );
    expect(distanceSquared).toEqual(4);
  });
  it("distanceSquared throws without left", function() {
    expect(function() {
      import__47.Cartesian4.distanceSquared();
    }).toThrowDeveloperError();
  });
  it("distanceSquared throws without right", function() {
    expect(function() {
      import__47.Cartesian4.distanceSquared(import__47.Cartesian4.UNIT_X);
    }).toThrowDeveloperError();
  });
  it("normalize works with a result parameter", function() {
    const cartesian = new import__47.Cartesian4(2, 0, 0, 0);
    const expectedResult = new import__47.Cartesian4(1, 0, 0, 0);
    const result = new import__47.Cartesian4();
    const returnedResult = import__47.Cartesian4.normalize(cartesian, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("normalize works with a result parameter that is an input parameter", function() {
    const cartesian = new import__47.Cartesian4(2, 0, 0, 0);
    const expectedResult = new import__47.Cartesian4(1, 0, 0, 0);
    const returnedResult = import__47.Cartesian4.normalize(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("normalize throws with zero vector", function() {
    expect(function() {
      import__47.Cartesian4.normalize(import__47.Cartesian4.ZERO, new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents works with a result parameter", function() {
    const left = new import__47.Cartesian4(2, 3, 6, 8);
    const right = new import__47.Cartesian4(4, 5, 7, 9);
    const result = new import__47.Cartesian4();
    const expectedResult = new import__47.Cartesian4(8, 15, 42, 72);
    const returnedResult = import__47.Cartesian4.multiplyComponents(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("multiplyComponents works with a result parameter that is an input parameter", function() {
    const left = new import__47.Cartesian4(2, 3, 6, 8);
    const right = new import__47.Cartesian4(4, 5, 7, 9);
    const expectedResult = new import__47.Cartesian4(8, 15, 42, 72);
    const returnedResult = import__47.Cartesian4.multiplyComponents(left, right, left);
    expect(left).toBe(returnedResult);
    expect(left).toEqual(expectedResult);
  });
  it("divideComponents works with a result parameter", function() {
    const left = new import__47.Cartesian4(2, 3, 6, 15);
    const right = new import__47.Cartesian4(4, 5, 8, 2);
    const result = new import__47.Cartesian4();
    const expectedResult = new import__47.Cartesian4(0.5, 0.6, 0.75, 7.5);
    const returnedResult = import__47.Cartesian4.divideComponents(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("divideComponents works with a result parameter that is an input parameter", function() {
    const left = new import__47.Cartesian4(2, 3, 6, 15);
    const right = new import__47.Cartesian4(4, 5, 8, 2);
    const expectedResult = new import__47.Cartesian4(0.5, 0.6, 0.75, 7.5);
    const returnedResult = import__47.Cartesian4.divideComponents(left, right, left);
    expect(left).toBe(returnedResult);
    expect(left).toEqual(expectedResult);
  });
  it("dot", function() {
    const left = new import__47.Cartesian4(2, 3, 6, 8);
    const right = new import__47.Cartesian4(4, 5, 7, 9);
    const expectedResult = 137;
    const result = import__47.Cartesian4.dot(left, right);
    expect(result).toEqual(expectedResult);
  });
  it("add works with a result parameter", function() {
    const left = new import__47.Cartesian4(2, 3, 6, 8);
    const right = new import__47.Cartesian4(4, 5, 7, 9);
    const result = new import__47.Cartesian4();
    const expectedResult = new import__47.Cartesian4(6, 8, 13, 17);
    const returnedResult = import__47.Cartesian4.add(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("add works with a result parameter that is an input parameter", function() {
    const left = new import__47.Cartesian4(2, 3, 6, 8);
    const right = new import__47.Cartesian4(4, 5, 7, 9);
    const expectedResult = new import__47.Cartesian4(6, 8, 13, 17);
    const returnedResult = import__47.Cartesian4.add(left, right, left);
    expect(left).toBe(returnedResult);
    expect(left).toEqual(expectedResult);
  });
  it("subtract works with a result parameter", function() {
    const left = new import__47.Cartesian4(2, 3, 4, 8);
    const right = new import__47.Cartesian4(1, 5, 7, 9);
    const result = new import__47.Cartesian4();
    const expectedResult = new import__47.Cartesian4(1, -2, -3, -1);
    const returnedResult = import__47.Cartesian4.subtract(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("subtract works with this result parameter", function() {
    const left = new import__47.Cartesian4(2, 3, 4, 8);
    const right = new import__47.Cartesian4(1, 5, 7, 9);
    const expectedResult = new import__47.Cartesian4(1, -2, -3, -1);
    const returnedResult = import__47.Cartesian4.subtract(left, right, left);
    expect(returnedResult).toBe(left);
    expect(left).toEqual(expectedResult);
  });
  it("multiplyByScalar with a result parameter", function() {
    const cartesian = new import__47.Cartesian4(1, 2, 3, 4);
    const result = new import__47.Cartesian4();
    const scalar = 2;
    const expectedResult = new import__47.Cartesian4(2, 4, 6, 8);
    const returnedResult = import__47.Cartesian4.multiplyByScalar(
      cartesian,
      scalar,
      result
    );
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("multiplyByScalar with a result parameter that is an input parameter", function() {
    const cartesian = new import__47.Cartesian4(1, 2, 3, 4);
    const scalar = 2;
    const expectedResult = new import__47.Cartesian4(2, 4, 6, 8);
    const returnedResult = import__47.Cartesian4.multiplyByScalar(
      cartesian,
      scalar,
      cartesian
    );
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("divideByScalar with a result parameter", function() {
    const cartesian = new import__47.Cartesian4(1, 2, 3, 4);
    const result = new import__47.Cartesian4();
    const scalar = 2;
    const expectedResult = new import__47.Cartesian4(0.5, 1, 1.5, 2);
    const returnedResult = import__47.Cartesian4.divideByScalar(cartesian, scalar, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("divideByScalar with a result parameter that is an input parameter", function() {
    const cartesian = new import__47.Cartesian4(1, 2, 3, 4);
    const scalar = 2;
    const expectedResult = new import__47.Cartesian4(0.5, 1, 1.5, 2);
    const returnedResult = import__47.Cartesian4.divideByScalar(
      cartesian,
      scalar,
      cartesian
    );
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("negate with a result parameter", function() {
    const cartesian = new import__47.Cartesian4(1, -2, -5, 4);
    const result = new import__47.Cartesian4();
    const expectedResult = new import__47.Cartesian4(-1, 2, 5, -4);
    const returnedResult = import__47.Cartesian4.negate(cartesian, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("negate with a result parameter that is an input parameter", function() {
    const cartesian = new import__47.Cartesian4(1, -2, -5);
    const expectedResult = new import__47.Cartesian4(-1, 2, 5);
    const returnedResult = import__47.Cartesian4.negate(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("abs with a result parameter", function() {
    const cartesian = new import__47.Cartesian4(1, -2, -4, -3);
    const result = new import__47.Cartesian4();
    const expectedResult = new import__47.Cartesian4(1, 2, 4, 3);
    const returnedResult = import__47.Cartesian4.abs(cartesian, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("abs with a result parameter that is an input parameter", function() {
    const cartesian = new import__47.Cartesian4(1, -2, -4, -3);
    const expectedResult = new import__47.Cartesian4(1, 2, 4, 3);
    const returnedResult = import__47.Cartesian4.abs(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("lerp works with a result parameter that is an input parameter", function() {
    const start = new import__47.Cartesian4(4, 8, 10, 20);
    const end = new import__47.Cartesian4(8, 20, 20, 30);
    const t = 0.25;
    const expectedResult = new import__47.Cartesian4(5, 11, 12.5, 22.5);
    const returnedResult = import__47.Cartesian4.lerp(start, end, t, start);
    expect(start).toBe(returnedResult);
    expect(start).toEqual(expectedResult);
  });
  it("lerp extrapolate forward", function() {
    const start = new import__47.Cartesian4(4, 8, 10, 20);
    const end = new import__47.Cartesian4(8, 20, 20, 30);
    const t = 2;
    let result = new import__47.Cartesian4();
    const expectedResult = new import__47.Cartesian4(12, 32, 30, 40);
    result = import__47.Cartesian4.lerp(start, end, t, result);
    expect(result).toEqual(expectedResult);
  });
  it("lerp extrapolate backward", function() {
    const start = new import__47.Cartesian4(4, 8, 10, 20);
    const end = new import__47.Cartesian4(8, 20, 20, 30);
    const t = -1;
    let result = new import__47.Cartesian4();
    const expectedResult = new import__47.Cartesian4(0, -4, 0, 10);
    result = import__47.Cartesian4.lerp(start, end, t, result);
    expect(result).toEqual(expectedResult);
  });
  it("most orthogonal angle is x", function() {
    const v2 = new import__47.Cartesian4(0, 1, 2, 3);
    expect(import__47.Cartesian4.mostOrthogonalAxis(v2, new import__47.Cartesian4())).toEqual(
      import__47.Cartesian4.UNIT_X
    );
  });
  it("most orthogonal angle is y", function() {
    const v2 = new import__47.Cartesian4(1, 0, 2, 3);
    expect(import__47.Cartesian4.mostOrthogonalAxis(v2, new import__47.Cartesian4())).toEqual(
      import__47.Cartesian4.UNIT_Y
    );
  });
  it("most orthogonal angle is z", function() {
    let v2 = new import__47.Cartesian4(2, 3, 0, 1);
    expect(import__47.Cartesian4.mostOrthogonalAxis(v2, new import__47.Cartesian4())).toEqual(
      import__47.Cartesian4.UNIT_Z
    );
    v2 = new import__47.Cartesian4(3, 2, 0, 1);
    expect(import__47.Cartesian4.mostOrthogonalAxis(v2, new import__47.Cartesian4())).toEqual(
      import__47.Cartesian4.UNIT_Z
    );
  });
  it("most orthogonal angle is w", function() {
    let v2 = new import__47.Cartesian4(1, 2, 3, 0);
    expect(import__47.Cartesian4.mostOrthogonalAxis(v2, new import__47.Cartesian4())).toEqual(
      import__47.Cartesian4.UNIT_W
    );
    v2 = new import__47.Cartesian4(2, 3, 1, 0);
    expect(import__47.Cartesian4.mostOrthogonalAxis(v2, new import__47.Cartesian4())).toEqual(
      import__47.Cartesian4.UNIT_W
    );
    v2 = new import__47.Cartesian4(3, 1, 2, 0);
    expect(import__47.Cartesian4.mostOrthogonalAxis(v2, new import__47.Cartesian4())).toEqual(
      import__47.Cartesian4.UNIT_W
    );
    v2 = new import__47.Cartesian4(3, 2, 1, 0);
    expect(import__47.Cartesian4.mostOrthogonalAxis(v2, new import__47.Cartesian4())).toEqual(
      import__47.Cartesian4.UNIT_W
    );
  });
  it("equals", function() {
    const cartesian = new import__47.Cartesian4(1, 2, 3, 4);
    expect(
      import__47.Cartesian4.equals(cartesian, new import__47.Cartesian4(1, 2, 3, 4))
    ).toEqual(true);
    expect(
      import__47.Cartesian4.equals(cartesian, new import__47.Cartesian4(2, 2, 3, 4))
    ).toEqual(false);
    expect(
      import__47.Cartesian4.equals(cartesian, new import__47.Cartesian4(2, 1, 3, 4))
    ).toEqual(false);
    expect(
      import__47.Cartesian4.equals(cartesian, new import__47.Cartesian4(1, 2, 4, 4))
    ).toEqual(false);
    expect(
      import__47.Cartesian4.equals(cartesian, new import__47.Cartesian4(1, 2, 3, 5))
    ).toEqual(false);
    expect(import__47.Cartesian4.equals(cartesian, void 0)).toEqual(false);
  });
  it("equalsEpsilon", function() {
    let cartesian = new import__47.Cartesian4(1, 2, 3, 4);
    expect(
      cartesian.equalsEpsilon(new import__47.Cartesian4(1, 2, 3, 4), 0)
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(new import__47.Cartesian4(1, 2, 3, 4), 1)
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(new import__47.Cartesian4(2, 2, 3, 4), 1)
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(new import__47.Cartesian4(1, 3, 3, 4), 1)
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(new import__47.Cartesian4(1, 2, 4, 4), 1)
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(new import__47.Cartesian4(1, 2, 3, 5), 1)
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__47.Cartesian4(2, 2, 3, 4),
        import__48.Math.EPSILON6
      )
    ).toEqual(false);
    expect(
      cartesian.equalsEpsilon(
        new import__47.Cartesian4(1, 3, 3, 4),
        import__48.Math.EPSILON6
      )
    ).toEqual(false);
    expect(
      cartesian.equalsEpsilon(
        new import__47.Cartesian4(1, 2, 4, 4),
        import__48.Math.EPSILON6
      )
    ).toEqual(false);
    expect(
      cartesian.equalsEpsilon(
        new import__47.Cartesian4(1, 2, 3, 5),
        import__48.Math.EPSILON6
      )
    ).toEqual(false);
    expect(cartesian.equalsEpsilon(void 0, 1)).toEqual(false);
    cartesian = new import__47.Cartesian4(3e6, 4e6, 5e6, 6e6);
    expect(
      cartesian.equalsEpsilon(
        new import__47.Cartesian4(3e6, 4e6, 5e6, 6e6),
        0
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__47.Cartesian4(30000002e-1, 4e6, 5e6, 6e6),
        import__48.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__47.Cartesian4(3e6, 40000002e-1, 5e6, 6e6),
        import__48.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__47.Cartesian4(3e6, 4e6, 50000002e-1, 6e6),
        import__48.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__47.Cartesian4(3e6, 4e6, 5e6, 60000002e-1),
        import__48.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__47.Cartesian4(30000002e-1, 40000002e-1, 50000002e-1, 60000002e-1),
        import__48.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__47.Cartesian4(30000002e-1, 40000002e-1, 50000002e-1, 60000002e-1),
        import__48.Math.EPSILON9
      )
    ).toEqual(false);
    expect(cartesian.equalsEpsilon(void 0, 1)).toEqual(false);
    expect(import__47.Cartesian4.equalsEpsilon(void 0, cartesian, 1)).toEqual(false);
  });
  it("toString", function() {
    const cartesian = new import__47.Cartesian4(1.123, 2.345, 6.789, 6.123);
    expect(cartesian.toString()).toEqual("(1.123, 2.345, 6.789, 6.123)");
  });
  it("clone returns undefined with no parameter", function() {
    expect(import__47.Cartesian4.clone()).toBeUndefined();
  });
  it("maximumComponent throws with no parameter", function() {
    expect(function() {
      import__47.Cartesian4.maximumComponent();
    }).toThrowDeveloperError();
  });
  it("minimumComponent throws with no parameter", function() {
    expect(function() {
      import__47.Cartesian4.minimumComponent();
    }).toThrowDeveloperError();
  });
  it("magnitudeSquared throws with no parameter", function() {
    expect(function() {
      import__47.Cartesian4.magnitudeSquared();
    }).toThrowDeveloperError();
  });
  it("magnitude throws with no parameter", function() {
    expect(function() {
      import__47.Cartesian4.magnitude();
    }).toThrowDeveloperError();
  });
  it("normalize throws with no parameter", function() {
    expect(function() {
      import__47.Cartesian4.normalize();
    }).toThrowDeveloperError();
  });
  it("dot throws with no left parameter", function() {
    expect(function() {
      import__47.Cartesian4.dot(void 0, new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throw with no left parameter", function() {
    const right = new import__47.Cartesian4(4, 5, 6, 7);
    expect(function() {
      import__47.Cartesian4.multiplyComponents(void 0, right);
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throw with no right parameter", function() {
    const left = new import__47.Cartesian4(4, 5, 6, 7);
    expect(function() {
      import__47.Cartesian4.multiplyComponents(left, void 0);
    }).toThrowDeveloperError();
  });
  it("divideComponents throw with no left parameter", function() {
    const right = new import__47.Cartesian4(4, 5, 6, 7);
    expect(function() {
      import__47.Cartesian4.divideComponents(void 0, right);
    }).toThrowDeveloperError();
  });
  it("divideComponents throw with no right parameter", function() {
    const left = new import__47.Cartesian4(4, 5, 6, 7);
    expect(function() {
      import__47.Cartesian4.divideComponents(left, void 0);
    }).toThrowDeveloperError();
  });
  it("dot throws with no right parameter", function() {
    expect(function() {
      import__47.Cartesian4.dot(new import__47.Cartesian4(), void 0);
    }).toThrowDeveloperError();
  });
  it("add throws with no left parameter", function() {
    expect(function() {
      import__47.Cartesian4.add(void 0, new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("add throws with no right parameter", function() {
    expect(function() {
      import__47.Cartesian4.add(new import__47.Cartesian4(), void 0);
    }).toThrowDeveloperError();
  });
  it("subtract throws with no left parameter", function() {
    expect(function() {
      import__47.Cartesian4.subtract(void 0, new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("subtract throws with no right parameter", function() {
    expect(function() {
      import__47.Cartesian4.subtract(new import__47.Cartesian4(), void 0);
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no cartesian parameter", function() {
    expect(function() {
      import__47.Cartesian4.multiplyByScalar(void 0, 2);
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no scalar parameter", function() {
    expect(function() {
      import__47.Cartesian4.multiplyByScalar(new import__47.Cartesian4(), void 0);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no cartesian parameter", function() {
    expect(function() {
      import__47.Cartesian4.divideByScalar(void 0, 2);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no scalar parameter", function() {
    expect(function() {
      import__47.Cartesian4.divideByScalar(new import__47.Cartesian4(), void 0);
    }).toThrowDeveloperError();
  });
  it("negate throws with no cartesian parameter", function() {
    expect(function() {
      import__47.Cartesian4.negate(void 0);
    }).toThrowDeveloperError();
  });
  it("abs throws with no cartesian parameter", function() {
    expect(function() {
      import__47.Cartesian4.abs(void 0);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no start parameter", function() {
    const end = new import__47.Cartesian4(8, 20, 6);
    const t = 0.25;
    expect(function() {
      import__47.Cartesian4.lerp(void 0, end, t);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no end parameter", function() {
    const start = new import__47.Cartesian4(4, 8, 6);
    const t = 0.25;
    expect(function() {
      import__47.Cartesian4.lerp(start, void 0, t);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no t parameter", function() {
    const start = new import__47.Cartesian4(4, 8, 6, 7);
    const end = new import__47.Cartesian4(8, 20, 6, 7);
    expect(function() {
      import__47.Cartesian4.lerp(start, end, void 0);
    }).toThrowDeveloperError();
  });
  it("mostOrthogonalAxis throws with no cartesian parameter", function() {
    expect(function() {
      import__47.Cartesian4.mostOrthogonalAxis(void 0);
    }).toThrowDeveloperError();
  });
  it("minimumByComponent throws with no result", function() {
    expect(function() {
      import__47.Cartesian4.minimumByComponent(new import__47.Cartesian4(), new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("maximumByComponent throws with no result", function() {
    expect(function() {
      import__47.Cartesian4.maximumByComponent(new import__47.Cartesian4(), new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("clamp throws with no result", function() {
    expect(function() {
      import__47.Cartesian4.clamp(new import__47.Cartesian4(), new import__47.Cartesian4(), new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("normalize throws with no result", function() {
    expect(function() {
      import__47.Cartesian4.normalize(new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throws with no result", function() {
    expect(function() {
      import__47.Cartesian4.multiplyComponents(new import__47.Cartesian4(), new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("divideComponents throws with no result", function() {
    expect(function() {
      import__47.Cartesian4.divideComponents(new import__47.Cartesian4(), new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("add throws with no result", function() {
    expect(function() {
      import__47.Cartesian4.add(new import__47.Cartesian4(), new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("subtract throws with no result", function() {
    expect(function() {
      import__47.Cartesian4.subtract(new import__47.Cartesian4(), new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no result", function() {
    expect(function() {
      import__47.Cartesian4.multiplyByScalar(new import__47.Cartesian4(), 2);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no result", function() {
    expect(function() {
      import__47.Cartesian4.divideByScalar(new import__47.Cartesian4(), 2);
    }).toThrowDeveloperError();
  });
  it("negate throws with no result", function() {
    expect(function() {
      import__47.Cartesian4.negate(new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("abs throws with no result", function() {
    expect(function() {
      import__47.Cartesian4.abs(new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("mostOrthogonalAxis throws with no result", function() {
    expect(function() {
      import__47.Cartesian4.mostOrthogonalAxis(new import__47.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("packs and unpacks floating point values for representation as uint8 4-vectors", function() {
    function testFloat(float) {
      const packedFloat = import__47.Cartesian4.packFloat(float);
      expect(0 <= packedFloat.x && packedFloat.x <= 255).toBe(true);
      expect(0 <= packedFloat.y && packedFloat.y <= 255).toBe(true);
      expect(0 <= packedFloat.z && packedFloat.z <= 255).toBe(true);
      expect(0 <= packedFloat.w && packedFloat.w <= 255).toBe(true);
      const unpackedFloat = import__47.Cartesian4.unpackFloat(packedFloat);
      expect(unpackedFloat).toEqual(float);
    }
    function testFloatNaN(float) {
      expect(float).toBeNaN();
      const packedFloat = import__47.Cartesian4.packFloat(float);
      const unpackedFloat = import__47.Cartesian4.unpackFloat(packedFloat);
      expect(unpackedFloat).toBeNaN();
    }
    function testFloatOutOfRange(float) {
      const packedFloat = import__47.Cartesian4.packFloat(float);
      const unpackedFloat = import__47.Cartesian4.unpackFloat(packedFloat);
      expect(unpackedFloat).toEqual(import__48.Math.sign(float) * Infinity);
    }
    testFloat(0);
    testFloat(-1);
    testFloat(1);
    testFloat(123.5);
    testFloat(16777216);
    testFloat(Infinity);
    testFloat(-Infinity);
    testFloatNaN(NaN);
    testFloatOutOfRange(+Number.MAX_VALUE);
    testFloatOutOfRange(-Number.MAX_VALUE);
    const f32 = new Float32Array(1);
    f32[0] = Infinity;
    testFloat(f32[0]);
    f32[0] = -Infinity;
    testFloat(f32[0]);
    f32[0] = NaN;
    testFloatNaN(f32[0]);
  });
  createPackableSpecs_default(import__47.Cartesian4, new import__47.Cartesian4(1, 2, 3, 4), [1, 2, 3, 4]);
  createPackableArraySpecs_default(
    import__47.Cartesian4,
    [new import__47.Cartesian4(1, 2, 3, 4), new import__47.Cartesian4(5, 6, 7, 8)],
    [1, 2, 3, 4, 5, 6, 7, 8],
    4
  );
});

// packages/engine/Specs/Core/CartographicGeocoderServiceSpec.js
var import__49 = __toESM(require_Cesium(), 1);
describe("Core/CartographicGeocoderService", function() {
  const service = new import__49.CartographicGeocoderService();
  it("returns cartesian with matching coordinates for NS/EW input", function() {
    const query = "35N 75W";
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(1);
      expect(results[0].destination).toEqual(
        import__49.Cartesian3.fromDegrees(-75, 35, 300)
      );
    });
  });
  it("returns cartesian with matching coordinates for EW/NS input", function() {
    const query = "75W 35N";
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(1);
      expect(results[0].destination).toEqual(
        import__49.Cartesian3.fromDegrees(-75, 35, 300)
      );
    });
  });
  it("returns cartesian with matching coordinates for long/lat/height input", function() {
    const query = " 1.0, 2.0, 3.0 ";
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(1);
      expect(results[0].destination).toEqual(
        import__49.Cartesian3.fromDegrees(1, 2, 3)
      );
    });
  });
  it("returns cartesian with matching coordinates for long/lat input", function() {
    const query = " 1.0, 2.0 ";
    const defaultHeight = 300;
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(1);
      expect(results[0].destination).toEqual(
        import__49.Cartesian3.fromDegrees(1, 2, defaultHeight)
      );
    });
  });
  it("returns empty array for input with only longitudinal coordinates", function() {
    const query = " 1e 1e ";
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(0);
    });
  });
  it("returns empty array for input with only one NSEW coordinate", function() {
    const query = " 1e 1 ";
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(0);
    });
  });
  it("returns empty array for input with only one number", function() {
    const query = " 2.0 ";
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(0);
    });
  });
  it("returns empty array for with string", function() {
    const query = " aoeu ";
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(0);
    });
  });
});

// packages/engine/Specs/Core/CartographicSpec.js
var import__50 = __toESM(require_Cesium(), 1);
var import__51 = __toESM(require_Cesium(), 1);
describe("Core/Cartographic", function() {
  const surfaceCartesian = new import__50.Cartesian3(
    4.0943277921465295e6,
    1909216404474774e-9,
    4487348408865919e-9
  );
  const surfaceCartographic = new import__50.Cartographic(
    import__51.Math.toRadians(25),
    import__51.Math.toRadians(45),
    0
  );
  it("default constructor sets expected properties", function() {
    const c = new import__50.Cartographic();
    expect(c.longitude).toEqual(0);
    expect(c.latitude).toEqual(0);
    expect(c.height).toEqual(0);
  });
  it("constructor sets expected properties from parameters", function() {
    const c = new import__50.Cartographic(1, 2, 3);
    expect(c.longitude).toEqual(1);
    expect(c.latitude).toEqual(2);
    expect(c.height).toEqual(3);
  });
  it("toCartesian conversion from Cartographic input to Cartesian3 output", function() {
    const lon = import__51.Math.toRadians(150);
    const lat = import__51.Math.toRadians(-40);
    const height = 1e5;
    const ellipsoid = import__50.Ellipsoid.WGS84;
    const actual = import__50.Cartographic.toCartesian(new import__50.Cartographic(lon, lat, height));
    const expected = ellipsoid.cartographicToCartesian(
      new import__50.Cartographic(lon, lat, height)
    );
    expect(actual).toEqual(expected);
  });
  it("fromRadians works without a result parameter", function() {
    const c = import__50.Cartographic.fromRadians(Math.PI / 2, Math.PI / 4, 100);
    expect(c.longitude).toEqual(Math.PI / 2);
    expect(c.latitude).toEqual(Math.PI / 4);
    expect(c.height).toEqual(100);
  });
  it("fromRadians works with a result parameter", function() {
    const result = new import__50.Cartographic();
    const c = import__50.Cartographic.fromRadians(Math.PI / 2, Math.PI / 4, 100, result);
    expect(result).toBe(c);
    expect(c.longitude).toEqual(Math.PI / 2);
    expect(c.latitude).toEqual(Math.PI / 4);
    expect(c.height).toEqual(100);
  });
  it("fromRadians throws without longitude or latitude parameter but defaults altitude", function() {
    expect(function() {
      import__50.Cartographic.fromRadians(void 0, 0);
    }).toThrowDeveloperError();
    expect(function() {
      import__50.Cartographic.fromRadians(0, void 0);
    }).toThrowDeveloperError();
    const c = import__50.Cartographic.fromRadians(Math.PI / 2, Math.PI / 4);
    expect(c.longitude).toEqual(Math.PI / 2);
    expect(c.latitude).toEqual(Math.PI / 4);
    expect(c.height).toEqual(0);
  });
  it("fromDegrees works without a result parameter", function() {
    const c = import__50.Cartographic.fromDegrees(90, 45, 100);
    expect(c.longitude).toEqual(Math.PI / 2);
    expect(c.latitude).toEqual(Math.PI / 4);
    expect(c.height).toEqual(100);
  });
  it("fromDegrees works with a result parameter", function() {
    const result = new import__50.Cartographic();
    const c = import__50.Cartographic.fromDegrees(90, 45, 100, result);
    expect(result).toBe(c);
    expect(c.longitude).toEqual(Math.PI / 2);
    expect(c.latitude).toEqual(Math.PI / 4);
    expect(c.height).toEqual(100);
  });
  it("fromDegrees throws without longitude or latitude parameter but defaults altitude", function() {
    expect(function() {
      import__50.Cartographic.fromDegrees(void 0, 0);
    }).toThrowDeveloperError();
    expect(function() {
      import__50.Cartographic.fromDegrees(0, void 0);
    }).toThrowDeveloperError();
    const c = import__50.Cartographic.fromDegrees(90, 45);
    expect(c.longitude).toEqual(Math.PI / 2);
    expect(c.latitude).toEqual(Math.PI / 4);
    expect(c.height).toEqual(0);
  });
  it("fromCartesian works without a result parameter", function() {
    const ellipsoid = import__50.Ellipsoid.WGS84;
    const c = import__50.Cartographic.fromCartesian(surfaceCartesian, ellipsoid);
    expect(c).toEqualEpsilon(surfaceCartographic, import__51.Math.EPSILON8);
  });
  it("fromCartesian works with a result parameter", function() {
    const ellipsoid = import__50.Ellipsoid.WGS84;
    const result = new import__50.Cartographic();
    const c = import__50.Cartographic.fromCartesian(surfaceCartesian, ellipsoid, result);
    expect(c).toEqualEpsilon(surfaceCartographic, import__51.Math.EPSILON8);
    expect(result).toBe(c);
  });
  it("fromCartesian works without an ellipsoid", function() {
    const c = import__50.Cartographic.fromCartesian(surfaceCartesian);
    expect(c).toEqualEpsilon(surfaceCartographic, import__51.Math.EPSILON8);
  });
  it("fromCartesian throws when there is no cartesian", function() {
    expect(function() {
      import__50.Cartographic.fromCartesian();
    }).toThrowDeveloperError();
  });
  it("fromCartesian works with a value that is above the ellipsoid surface", function() {
    const cartographic1 = import__50.Cartographic.fromDegrees(35.766989, 33.333602, 3e3);
    const cartesian1 = import__50.Cartesian3.fromRadians(
      cartographic1.longitude,
      cartographic1.latitude,
      cartographic1.height
    );
    const cartographic2 = import__50.Cartographic.fromCartesian(cartesian1);
    expect(cartographic2).toEqualEpsilon(cartographic1, import__51.Math.EPSILON8);
  });
  it("fromCartesian works with a value that is bellow the ellipsoid surface", function() {
    const cartographic1 = import__50.Cartographic.fromDegrees(35.766989, 33.333602, -3e3);
    const cartesian1 = import__50.Cartesian3.fromRadians(
      cartographic1.longitude,
      cartographic1.latitude,
      cartographic1.height
    );
    const cartographic2 = import__50.Cartographic.fromCartesian(cartesian1);
    expect(cartographic2).toEqualEpsilon(cartographic1, import__51.Math.EPSILON8);
  });
  it("clone without a result parameter", function() {
    const cartographic = new import__50.Cartographic(1, 2, 3);
    const result = cartographic.clone();
    expect(cartographic).not.toBe(result);
    expect(cartographic).toEqual(result);
  });
  it("clone with a result parameter", function() {
    const cartographic = new import__50.Cartographic(1, 2, 3);
    const result = new import__50.Cartographic();
    const returnedResult = cartographic.clone(result);
    expect(cartographic).not.toBe(result);
    expect(result).toBe(returnedResult);
    expect(cartographic).toEqual(result);
  });
  it('clone works with "this" result parameter', function() {
    const cartographic = new import__50.Cartographic(1, 2, 3);
    const returnedResult = cartographic.clone(cartographic);
    expect(cartographic).toBe(returnedResult);
  });
  it("equals", function() {
    const cartographic = new import__50.Cartographic(1, 2, 3);
    expect(cartographic.equals(new import__50.Cartographic(1, 2, 3))).toEqual(true);
    expect(cartographic.equals(new import__50.Cartographic(2, 2, 3))).toEqual(false);
    expect(cartographic.equals(new import__50.Cartographic(2, 1, 3))).toEqual(false);
    expect(cartographic.equals(new import__50.Cartographic(1, 2, 4))).toEqual(false);
    expect(cartographic.equals(void 0)).toEqual(false);
  });
  it("equalsEpsilon", function() {
    const cartographic = new import__50.Cartographic(1, 2, 3);
    expect(
      cartographic.equalsEpsilon(new import__50.Cartographic(1, 2, 3), 0)
    ).toEqual(true);
    expect(
      cartographic.equalsEpsilon(new import__50.Cartographic(1, 2, 3), 1)
    ).toEqual(true);
    expect(
      cartographic.equalsEpsilon(new import__50.Cartographic(2, 2, 3), 1)
    ).toEqual(true);
    expect(
      cartographic.equalsEpsilon(new import__50.Cartographic(1, 3, 3), 1)
    ).toEqual(true);
    expect(
      cartographic.equalsEpsilon(new import__50.Cartographic(1, 2, 4), 1)
    ).toEqual(true);
    expect(
      cartographic.equalsEpsilon(new import__50.Cartographic(2, 2, 3), 0.99999)
    ).toEqual(false);
    expect(
      cartographic.equalsEpsilon(new import__50.Cartographic(1, 3, 3), 0.99999)
    ).toEqual(false);
    expect(
      cartographic.equalsEpsilon(new import__50.Cartographic(1, 2, 4), 0.99999)
    ).toEqual(false);
    expect(cartographic.equalsEpsilon(void 0, 1)).toEqual(false);
  });
  it("toString", function() {
    const cartographic = new import__50.Cartographic(1.123, 2.345, 6.789);
    expect(cartographic.toString()).toEqual("(1.123, 2.345, 6.789)");
  });
  it("clone returns undefined without cartographic parameter", function() {
    expect(import__50.Cartographic.clone(void 0)).toBeUndefined();
  });
});

// packages/engine/Specs/Core/CatmullRomSplineSpec.js
var import__52 = __toESM(require_Cesium(), 1);
var import__53 = __toESM(require_Cesium(), 1);
describe("Core/CatmullRomSpline", function() {
  let points;
  let times;
  beforeEach(function() {
    points = [
      new import__52.Cartesian3(-1, -1, 0),
      new import__52.Cartesian3(-0.5, -0.125, 0),
      new import__52.Cartesian3(0.5, 0.125, 0),
      new import__52.Cartesian3(1, 1, 0)
    ];
    times = [0, 1, 2, 3];
  });
  it("constructor throws without points or times", function() {
    expect(function() {
      return new import__52.CatmullRomSpline();
    }).toThrowDeveloperError();
  });
  it("constructor throws when control points length is less than 2", function() {
    expect(function() {
      return new import__52.CatmullRomSpline({
        points: [import__52.Cartesian3.ZERO]
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws when times.length is not equal to points.length", function() {
    expect(function() {
      return new import__52.CatmullRomSpline({
        points,
        times: [0, 1]
      });
    }).toThrowDeveloperError();
  });
  it("sets start and end tangents", function() {
    const start = import__52.Cartesian3.subtract(points[1], points[0], new import__52.Cartesian3());
    const end = import__52.Cartesian3.subtract(
      points[points.length - 1],
      points[points.length - 2],
      new import__52.Cartesian3()
    );
    const crs = new import__52.CatmullRomSpline({
      points,
      times,
      firstTangent: start,
      lastTangent: end
    });
    expect(start).toEqual(crs.firstTangent);
    expect(end).toEqual(crs.lastTangent);
  });
  it("computes start and end tangents", function() {
    const controlPoint0 = import__52.Cartesian3.clone(points[0]);
    const controlPoint1 = import__52.Cartesian3.clone(points[1]);
    const controlPoint2 = import__52.Cartesian3.clone(points[2]);
    let start = new import__52.Cartesian3();
    start = import__52.Cartesian3.multiplyByScalar(
      import__52.Cartesian3.subtract(
        import__52.Cartesian3.subtract(
          import__52.Cartesian3.multiplyByScalar(controlPoint1, 2, start),
          controlPoint2,
          start
        ),
        controlPoint0,
        start
      ),
      0.5,
      start
    );
    const controlPointn0 = import__52.Cartesian3.clone(points[points.length - 1]);
    const controlPointn1 = import__52.Cartesian3.clone(points[points.length - 2]);
    const controlPointn2 = import__52.Cartesian3.clone(points[points.length - 3]);
    let end = new import__52.Cartesian3();
    end = import__52.Cartesian3.multiplyByScalar(
      import__52.Cartesian3.add(
        import__52.Cartesian3.subtract(
          controlPointn0,
          import__52.Cartesian3.multiplyByScalar(controlPointn1, 2, end),
          end
        ),
        controlPointn2,
        end
      ),
      0.5,
      end
    );
    const crs = new import__52.CatmullRomSpline({
      points,
      times
    });
    expect(start).toEqual(crs.firstTangent);
    expect(end).toEqual(crs.lastTangent);
  });
  it("evaluate throws without time", function() {
    const crs = new import__52.CatmullRomSpline({
      points,
      times
    });
    expect(function() {
      crs.evaluate();
    }).toThrowDeveloperError();
  });
  it("evaluate throws when time is out of range", function() {
    const crs = new import__52.CatmullRomSpline({
      points,
      times
    });
    expect(function() {
      crs.evaluate(times[0] - 1);
    }).toThrowDeveloperError();
  });
  it("check Catmull-Rom spline against a Hermite spline", function() {
    const crs = new import__52.CatmullRomSpline({
      points,
      times
    });
    const tangents = [crs.firstTangent];
    for (let i = 1; i < points.length - 1; ++i) {
      tangents.push(
        import__52.Cartesian3.multiplyByScalar(
          import__52.Cartesian3.subtract(points[i + 1], points[i - 1], new import__52.Cartesian3()),
          0.5,
          new import__52.Cartesian3()
        )
      );
    }
    tangents.push(crs.lastTangent);
    const hs = import__52.HermiteSpline.createC1({
      points,
      tangents,
      times
    });
    const granularity = 0.5;
    for (let j = times[0]; j <= times[points.length - 1]; j = j + granularity) {
      expect(hs.evaluate(j)).toEqualEpsilon(
        crs.evaluate(j),
        import__53.Math.EPSILON4
      );
    }
  });
  it("evaluate with result parameter", function() {
    const crs = new import__52.CatmullRomSpline({
      points,
      times
    });
    const result = new import__52.Cartesian3();
    const point = crs.evaluate(times[0], result);
    expect(point).toBe(result);
    expect(result).toEqual(points[0]);
  });
  it("spline with 2 control points defaults to lerp", function() {
    points = points.slice(0, 2);
    times = times.slice(0, 2);
    const crs = new import__52.CatmullRomSpline({
      points,
      times
    });
    const t = (times[0] + times[1]) * 0.5;
    expect(crs.evaluate(t)).toEqual(
      import__52.Cartesian3.lerp(points[0], points[1], t, new import__52.Cartesian3())
    );
  });
  it("spline with 2 control points defaults to lerp and result parameter", function() {
    points = points.slice(0, 2);
    times = times.slice(0, 2);
    const crs = new import__52.CatmullRomSpline({
      points,
      times
    });
    const t = (times[0] + times[1]) * 0.5;
    const result = new import__52.Cartesian3();
    const actual = crs.evaluate(t, result);
    expect(actual).toBe(result);
    expect(actual).toEqual(
      import__52.Cartesian3.lerp(points[0], points[1], t, new import__52.Cartesian3())
    );
  });
});

// packages/engine/Specs/Core/CesiumTerrainProviderSpec.js
var import__54 = __toESM(require_Cesium(), 1);
var import__55 = __toESM(require_Cesium(), 1);
describe("Core/CesiumTerrainProvider", function() {
  beforeEach(function() {
    import__54.RequestScheduler.clearForSpecs();
  });
  afterEach(function() {
    import__54.Resource._Implementations.loadWithXhr = import__54.Resource._DefaultImplementations.loadWithXhr;
  });
  function returnTileJson(path) {
    const oldLoad = import__54.Resource._Implementations.loadWithXhr;
    import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
      if (url.indexOf("layer.json") >= 0) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          path,
          responseType,
          method,
          data,
          headers,
          deferred
        );
      } else {
        return oldLoad(
          url,
          responseType,
          method,
          data,
          headers,
          deferred,
          overrideMimeType
        );
      }
    };
  }
  function returnHeightmapTileJson() {
    return returnTileJson(
      "Data/CesiumTerrainTileJson/StandardHeightmap.tile.json"
    );
  }
  function returnQuantizedMeshTileJson() {
    return returnTileJson("Data/CesiumTerrainTileJson/QuantizedMesh.tile.json");
  }
  function returnVertexNormalTileJson() {
    return returnTileJson("Data/CesiumTerrainTileJson/VertexNormals.tile.json");
  }
  function returnOctVertexNormalTileJson() {
    return returnTileJson(
      "Data/CesiumTerrainTileJson/OctVertexNormals.tile.json"
    );
  }
  function returnWaterMaskTileJson() {
    return returnTileJson("Data/CesiumTerrainTileJson/WaterMask.tile.json");
  }
  function returnPartialAvailabilityTileJson() {
    return returnTileJson(
      "Data/CesiumTerrainTileJson/PartialAvailability.tile.json"
    );
  }
  function returnParentUrlTileJson() {
    const paths = [
      "Data/CesiumTerrainTileJson/ParentUrl.tile.json",
      "Data/CesiumTerrainTileJson/Parent.tile.json"
    ];
    let i = 0;
    const oldLoad = import__54.Resource._Implementations.loadWithXhr;
    import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
      if (url.indexOf("layer.json") >= 0) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          paths[i++],
          responseType,
          method,
          data,
          headers,
          deferred
        );
      } else {
        return oldLoad(
          url,
          responseType,
          method,
          data,
          headers,
          deferred,
          overrideMimeType
        );
      }
    };
  }
  function returnMetadataAvailabilityTileJson() {
    return returnTileJson(
      "Data/CesiumTerrainTileJson/MetadataAvailability.tile.json"
    );
  }
  function waitForTile(level, x, y, requestNormals, requestWaterMask, f) {
    const terrainProvider = new import__54.CesiumTerrainProvider({
      url: "made/up/url",
      requestVertexNormals: requestNormals,
      requestWaterMask
    });
    return terrainProvider.readyPromise.then(function() {
      return terrainProvider.requestTileGeometry(level, x, y);
    }).then(f).catch(function(error) {
      expect("requestTileGeometry").toBe("returning a tile.");
    });
  }
  function createRequest() {
    return new import__54.Request({
      throttleByServer: true
    });
  }
  it("conforms to TerrainProvider interface", function() {
    expect(import__54.CesiumTerrainProvider).toConformToInterface(import__54.TerrainProvider);
  });
  it("constructor throws if url is not provided", function() {
    expect(function() {
      return new import__54.CesiumTerrainProvider();
    }).toThrowDeveloperError();
    expect(function() {
      return new import__54.CesiumTerrainProvider({});
    }).toThrowDeveloperError();
  });
  it("resolves readyPromise", function() {
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url"
    });
    return provider.readyPromise.then(function(result) {
      expect(result).toBe(true);
      expect(provider.ready).toBe(true);
    });
  });
  it("resolves readyPromise when url promise is used", function() {
    const provider = new import__54.CesiumTerrainProvider({
      url: Promise.resolve("made/up/url")
    });
    return provider.readyPromise.then(function(result) {
      expect(result).toBe(true);
      expect(provider.ready).toBe(true);
    });
  });
  it("resolves readyPromise with Resource", function() {
    const resource = new import__54.Resource({
      url: "made/up/url"
    });
    const provider = new import__54.CesiumTerrainProvider({
      url: resource
    });
    return provider.readyPromise.then(function(result) {
      expect(result).toBe(true);
      expect(provider.ready).toBe(true);
    });
  });
  it("rejects readyPromise when url rejects", function() {
    const provider = new import__54.CesiumTerrainProvider({
      url: Promise.reject(new Error("my message"))
    });
    return provider.readyPromise.then(function() {
      fail("should not resolve");
    }).catch(function(result) {
      expect(result.message).toBe("my message");
      expect(provider.ready).toBe(false);
    });
  });
  it("uses geographic tiling scheme by default", function() {
    returnHeightmapTileJson();
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url"
    });
    return pollToPromise_default(function() {
      return provider.ready;
    }).then(function() {
      expect(provider.tilingScheme).toBeInstanceOf(import__54.GeographicTilingScheme);
    });
  });
  it("can use a custom ellipsoid", function() {
    returnHeightmapTileJson();
    const ellipsoid = new import__54.Ellipsoid(1, 2, 3);
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url",
      ellipsoid
    });
    return pollToPromise_default(function() {
      return provider.ready;
    }).then(function() {
      expect(provider.tilingScheme.ellipsoid).toEqual(ellipsoid);
    });
  });
  it("has error event", function() {
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url"
    });
    return pollToPromise_default(function() {
      return provider.ready;
    }).then(function() {
      expect(provider.errorEvent).toBeDefined();
      expect(provider.errorEvent).toBe(provider.errorEvent);
    });
  });
  it("returns reasonable geometric error for various levels", function() {
    returnQuantizedMeshTileJson();
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url"
    });
    return provider.readyPromise.then(function() {
      expect(provider.getLevelMaximumGeometricError(0)).toBeGreaterThan(0);
      expect(provider.getLevelMaximumGeometricError(0)).toEqualEpsilon(
        provider.getLevelMaximumGeometricError(1) * 2,
        import__55.Math.EPSILON10
      );
      expect(provider.getLevelMaximumGeometricError(1)).toEqualEpsilon(
        provider.getLevelMaximumGeometricError(2) * 2,
        import__55.Math.EPSILON10
      );
    });
  });
  it("logo is undefined if credit is not provided", function() {
    returnHeightmapTileJson();
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url"
    });
    return pollToPromise_default(function() {
      return provider.ready;
    }).then(function() {
      expect(provider.credit).toBeUndefined();
    });
  });
  it("logo is defined if credit is provided", function() {
    returnHeightmapTileJson();
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url",
      credit: "thanks to our awesome made up contributors!"
    });
    return pollToPromise_default(function() {
      return provider.ready;
    }).then(function() {
      expect(provider.credit).toBeDefined();
    });
  });
  it("has a water mask", function() {
    returnHeightmapTileJson();
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url"
    });
    return pollToPromise_default(function() {
      return provider.ready;
    }).then(function() {
      expect(provider.hasWaterMask).toBe(true);
    });
  });
  it("has vertex normals", function() {
    returnOctVertexNormalTileJson();
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url",
      requestVertexNormals: true
    });
    return pollToPromise_default(function() {
      return provider.ready;
    }).then(function() {
      expect(provider.requestVertexNormals).toBe(true);
      expect(provider.hasVertexNormals).toBe(true);
    });
  });
  it("does not request vertex normals", function() {
    returnOctVertexNormalTileJson();
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url",
      requestVertexNormals: false
    });
    return pollToPromise_default(function() {
      return provider.ready;
    }).then(function() {
      expect(provider.requestVertexNormals).toBe(false);
      expect(provider.hasVertexNormals).toBe(false);
    });
  });
  it("requests parent layer.json", function() {
    returnParentUrlTileJson();
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url",
      requestVertexNormals: true,
      requestWaterMask: true
    });
    return provider.readyPromise.then(function() {
      expect(provider._tileCredits[0].html).toBe(
        "This is a child tileset! This amazing data is courtesy The Amazing Data Source!"
      );
      expect(provider.requestVertexNormals).toBe(true);
      expect(provider.requestWaterMask).toBe(true);
      expect(provider.hasVertexNormals).toBe(false);
      expect(provider.hasWaterMask).toBe(true);
      expect(provider.availability.isTileAvailable(1, 2, 1)).toBe(true);
      expect(provider.availability.isTileAvailable(1, 3, 1)).toBe(true);
      expect(provider.availability.isTileAvailable(2, 0, 0)).toBe(false);
      const layers = provider._layers;
      expect(layers.length).toBe(2);
      expect(layers[0].hasVertexNormals).toBe(false);
      expect(layers[0].hasWaterMask).toBe(true);
      expect(layers[0].availability.isTileAvailable(1, 2, 1)).toBe(true);
      expect(layers[0].availability.isTileAvailable(1, 3, 1)).toBe(false);
      expect(layers[0].availability.isTileAvailable(2, 0, 0)).toBe(false);
      expect(layers[1].hasVertexNormals).toBe(false);
      expect(layers[1].hasWaterMask).toBe(false);
      expect(layers[1].availability.isTileAvailable(1, 2, 1)).toBe(true);
      expect(layers[1].availability.isTileAvailable(1, 3, 1)).toBe(true);
      expect(layers[1].availability.isTileAvailable(2, 0, 0)).toBe(false);
    });
  });
  it("raises an error if layer.json does not specify a format", function() {
    returnTileJson("Data/CesiumTerrainTileJson/NoFormat.tile.json");
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url"
    });
    let errorListenerCalled = false;
    const errorMatcher = function(event) {
      expect(event.message).toContain("format is not specified");
      errorListenerCalled = true;
      provider.errorEvent.removeEventListener(errorMatcher);
    };
    provider.errorEvent.addEventListener(errorMatcher);
    return provider.readyPromise.then(fail).catch((e) => {
      expect(errorListenerCalled).toBe(true);
      expect(e.message).toContain("An error occurred while accessing");
    });
  });
  it("raises an error if layer.json specifies an unknown format", function() {
    returnTileJson("Data/CesiumTerrainTileJson/InvalidFormat.tile.json");
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url"
    });
    let errorListenerCalled = false;
    const errorMatcher = function(event) {
      expect(event.message).toContain("invalid or not supported");
      errorListenerCalled = true;
      provider.errorEvent.removeEventListener(errorMatcher);
    };
    provider.errorEvent.addEventListener(errorMatcher);
    return provider.readyPromise.then(fail).catch((e) => {
      expect(errorListenerCalled).toBe(true);
      expect(e.message).toContain("An error occurred while accessing");
    });
  });
  it("raises an error if layer.json does not specify quantized-mesh 1.x format", function() {
    returnTileJson("Data/CesiumTerrainTileJson/QuantizedMesh2.0.tile.json");
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url"
    });
    let errorListenerCalled = false;
    const errorMatcher = function(event) {
      expect(event.message).toContain("invalid or not supported");
      errorListenerCalled = true;
      provider.errorEvent.removeEventListener(errorMatcher);
    };
    provider.errorEvent.addEventListener(errorMatcher);
    return provider.readyPromise.then(fail).catch((e) => {
      expect(errorListenerCalled).toBe(true);
      expect(e.message).toContain("An error occurred while accessing");
    });
  });
  it("supports quantized-mesh1.x minor versions", function() {
    returnTileJson("Data/CesiumTerrainTileJson/QuantizedMesh1.1.tile.json");
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url"
    });
    const errorListener = jasmine.createSpy("error");
    provider.errorEvent.addEventListener(errorListener);
    return pollToPromise_default(function() {
      return provider.ready;
    }).then(function() {
      expect(errorListener).not.toHaveBeenCalled();
    });
  });
  it("raises an error if layer.json does not specify a tiles property", function() {
    returnTileJson("Data/CesiumTerrainTileJson/NoTiles.tile.json");
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url"
    });
    let errorListenerCalled = false;
    const errorMatcher = function(event) {
      expect(event.message).toContain(
        "does not specify any tile URL templates"
      );
      errorListenerCalled = true;
      provider.errorEvent.removeEventListener(errorMatcher);
    };
    provider.errorEvent.addEventListener(errorMatcher);
    return provider.readyPromise.then(fail).catch((e) => {
      expect(errorListenerCalled).toBe(true);
      expect(e.message).toContain("An error occurred while accessing");
    });
  });
  it("raises an error if layer.json tiles property is an empty array", function() {
    returnTileJson("Data/CesiumTerrainTileJson/EmptyTilesArray.tile.json");
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url"
    });
    let errorListenerCalled = false;
    const errorMatcher = function(event) {
      expect(event.message).toContain(
        "does not specify any tile URL templates"
      );
      errorListenerCalled = true;
      provider.errorEvent.removeEventListener(errorMatcher);
    };
    provider.errorEvent.addEventListener(errorMatcher);
    return provider.readyPromise.then(fail).catch((e) => {
      expect(errorListenerCalled).toBe(true);
      expect(e.message).toContain("An error occurred while accessing");
    });
  });
  it("uses attribution specified in layer.json", function() {
    returnTileJson("Data/CesiumTerrainTileJson/WithAttribution.tile.json");
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url"
    });
    return pollToPromise_default(function() {
      return provider.ready;
    }).then(function() {
      expect(provider._tileCredits[0].html).toBe(
        "This amazing data is courtesy The Amazing Data Source!"
      );
    });
  });
  it("do not add blank attribution if layer.json does not have one", function() {
    returnTileJson("Data/CesiumTerrainTileJson/WaterMask.tile.json");
    const provider = new import__54.CesiumTerrainProvider({
      url: "made/up/url"
    });
    return pollToPromise_default(function() {
      return provider.ready;
    }).then(function() {
      expect(provider._tileCredit).toBeUndefined();
    });
  });
  it("The undefined availability tile is returned at level 0", function() {
    const layer = {
      availabilityLevels: 10
    };
    expect(
      import__54.CesiumTerrainProvider._getAvailabilityTile(layer, 0, 0, 0)
    ).toBeUndefined();
    expect(
      import__54.CesiumTerrainProvider._getAvailabilityTile(layer, 1, 0, 0)
    ).toBeUndefined();
  });
  it("The correct availability tile is computed in first level", function() {
    const layer = {
      availabilityLevels: 10
    };
    expect(import__54.CesiumTerrainProvider._getAvailabilityTile(layer, 1, 1, 1)).toEqual({
      level: 0,
      x: 0,
      y: 0
    });
    expect(import__54.CesiumTerrainProvider._getAvailabilityTile(layer, 4, 2, 2)).toEqual({
      level: 0,
      x: 1,
      y: 0
    });
    expect(
      import__54.CesiumTerrainProvider._getAvailabilityTile(layer, 80, 50, 10)
    ).toEqual({
      level: 0,
      x: 0,
      y: 0
    });
  });
  it("The correct availability tile is computed in second level", function() {
    const layer = {
      availabilityLevels: 10
    };
    const expected = {
      level: 10,
      x: 80,
      y: 50
    };
    const xs = [expected.x, expected.x];
    const ys = [expected.y, expected.y];
    for (let i = 0; i < 10; ++i) {
      xs[0] *= 2;
      ys[0] *= 2;
      xs[1] = xs[1] * 2 + 1;
      ys[1] = ys[1] * 2 + 1;
    }
    expect(
      import__54.CesiumTerrainProvider._getAvailabilityTile(layer, xs[0], ys[0], 20)
    ).toEqual(expected);
    expect(
      import__54.CesiumTerrainProvider._getAvailabilityTile(layer, xs[1], ys[1], 20)
    ).toEqual(expected);
  });
  describe("requestTileGeometry", function() {
    it("uses multiple urls specified in layer.json", function() {
      returnTileJson("Data/CesiumTerrainTileJson/MultipleUrls.tile.json");
      const provider = new import__54.CesiumTerrainProvider({
        url: "made/up/url"
      });
      spyOn(import__54.Resource._Implementations, "loadWithXhr").and.callThrough();
      return provider.readyPromise.then(function() {
        return provider.requestTileGeometry(0, 0, 0);
      }).catch(function() {
        expect(
          import__54.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo0.com");
        return provider.requestTileGeometry(1, 0, 0);
      }).catch(function() {
        expect(
          import__54.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo1.com");
        return provider.requestTileGeometry(1, -1, 0);
      }).catch(function() {
        expect(
          import__54.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo2.com");
        return provider.requestTileGeometry(1, 0, 1);
      }).catch(function() {
        expect(
          import__54.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo3.com");
      });
    });
    it("supports scheme-less template URLs in layer.json resolved with absolute URL", function() {
      returnTileJson("Data/CesiumTerrainTileJson/MultipleUrls.tile.json");
      const url = (0, import__54.getAbsoluteUri)("Data/CesiumTerrainTileJson");
      const provider = new import__54.CesiumTerrainProvider({
        url
      });
      spyOn(import__54.Resource._Implementations, "loadWithXhr").and.callThrough();
      return provider.readyPromise.then(function() {
        return provider.requestTileGeometry(0, 0, 0);
      }).catch(function() {
        expect(
          import__54.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo0.com");
        return provider.requestTileGeometry(1, 0, 0);
      }).catch(function() {
        expect(
          import__54.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo1.com");
        return provider.requestTileGeometry(1, -1, 0);
      }).catch(function() {
        expect(
          import__54.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo2.com");
        return provider.requestTileGeometry(1, 0, 1);
      }).catch(function() {
        expect(
          import__54.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo3.com");
      });
    });
    it("provides HeightmapTerrainData", function() {
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        return import__54.Resource._DefaultImplementations.loadWithXhr(
          "Data/EarthOrientationParameters/IcrfToFixedStkComponentsRotationData.json",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnHeightmapTileJson();
      return waitForTile(0, 0, 0, false, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__54.HeightmapTerrainData);
      });
    });
    it("provides QuantizedMeshTerrainData", function() {
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnQuantizedMeshTileJson();
      return waitForTile(0, 0, 0, false, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__54.QuantizedMeshTerrainData);
      });
    });
    it("provides QuantizedMeshTerrainData with 32bit indices", function() {
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.32bitIndices.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnQuantizedMeshTileJson();
      return waitForTile(0, 0, 0, false, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__54.QuantizedMeshTerrainData);
        expect(loadedData._indices.BYTES_PER_ELEMENT).toBe(4);
      });
    });
    it("provides QuantizedMeshTerrainData with VertexNormals", function() {
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.vertexnormals.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnVertexNormalTileJson();
      return waitForTile(0, 0, 0, true, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__54.QuantizedMeshTerrainData);
        expect(loadedData._encodedNormals).toBeDefined();
      });
    });
    it("provides QuantizedMeshTerrainData with WaterMask", function() {
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.watermask.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnWaterMaskTileJson();
      return waitForTile(0, 0, 0, false, true, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__54.QuantizedMeshTerrainData);
        expect(loadedData._waterMask).toBeDefined();
      });
    });
    it("provides QuantizedMeshTerrainData with VertexNormals and WaterMask", function() {
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.octvertexnormals.watermask.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnWaterMaskTileJson();
      return waitForTile(0, 0, 0, true, true, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__54.QuantizedMeshTerrainData);
        expect(loadedData._encodedNormals).toBeDefined();
        expect(loadedData._waterMask).toBeDefined();
      });
    });
    it("provides QuantizedMeshTerrainData with OctVertexNormals", function() {
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.octvertexnormals.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnOctVertexNormalTileJson();
      return waitForTile(0, 0, 0, true, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__54.QuantizedMeshTerrainData);
        expect(loadedData._encodedNormals).toBeDefined();
      });
    });
    it("provides QuantizedMeshTerrainData with VertexNormals and unknown extensions", function() {
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.vertexnormals.unknownext.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnVertexNormalTileJson();
      return waitForTile(0, 0, 0, true, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__54.QuantizedMeshTerrainData);
        expect(loadedData._encodedNormals).toBeDefined();
      });
    });
    it("provides QuantizedMeshTerrainData with OctVertexNormals and unknown extensions", function() {
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.octvertexnormals.unknownext.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnOctVertexNormalTileJson();
      return waitForTile(0, 0, 0, true, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__54.QuantizedMeshTerrainData);
        expect(loadedData._encodedNormals).toBeDefined();
      });
    });
    it("provides QuantizedMeshTerrainData with unknown extension", function() {
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.unknownext.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnOctVertexNormalTileJson();
      return waitForTile(0, 0, 0, false, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__54.QuantizedMeshTerrainData);
      });
    });
    it("provides QuantizedMeshTerrainData with Metadata availability", function() {
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.metadataavailability.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnMetadataAvailabilityTileJson();
      const terrainProvider = new import__54.CesiumTerrainProvider({
        url: "made/up/url"
      });
      return pollToPromise_default(function() {
        return terrainProvider.ready;
      }).then(function() {
        expect(terrainProvider.hasMetadata).toBe(true);
        expect(terrainProvider._layers[0].availabilityLevels).toBe(10);
        expect(terrainProvider.availability.isTileAvailable(0, 0, 0)).toBe(
          true
        );
        expect(terrainProvider.availability.isTileAvailable(0, 1, 0)).toBe(
          true
        );
        expect(terrainProvider.availability.isTileAvailable(1, 0, 0)).toBe(
          false
        );
        return terrainProvider.requestTileGeometry(0, 0, 0);
      }).then(function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__54.QuantizedMeshTerrainData);
        expect(terrainProvider.availability.isTileAvailable(1, 0, 0)).toBe(
          true
        );
      });
    });
    it("returns undefined if too many requests are already in progress", function() {
      const baseUrl = "made/up/url";
      const deferreds = [];
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        deferreds.push(deferred);
      };
      returnHeightmapTileJson();
      const terrainProvider = new import__54.CesiumTerrainProvider({
        url: baseUrl
      });
      return pollToPromise_default(function() {
        return terrainProvider.ready;
      }).then(function() {
        let promise;
        let i;
        for (i = 0; i < import__54.RequestScheduler.maximumRequestsPerServer; ++i) {
          const request = new import__54.Request({
            throttle: true,
            throttleByServer: true
          });
          promise = terrainProvider.requestTileGeometry(0, 0, 0, request).then(fail).catch((e) => {
            expect(e.message).toContain("Mesh buffer doesn't exist.");
          });
        }
        import__54.RequestScheduler.update();
        expect(promise).toBeDefined();
        promise = terrainProvider.requestTileGeometry(0, 0, 0, createRequest());
        expect(promise).toBeUndefined();
        for (i = 0; i < deferreds.length; ++i) {
          deferreds[i].resolve();
        }
      });
    });
    it("supports getTileDataAvailable()", function() {
      const baseUrl = "made/up/url";
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnQuantizedMeshTileJson();
      const terrainProvider = new import__54.CesiumTerrainProvider({
        url: baseUrl
      });
      return pollToPromise_default(function() {
        return terrainProvider.ready;
      }).then(function() {
        expect(terrainProvider.getTileDataAvailable(0, 0, 0)).toBe(true);
        expect(terrainProvider.getTileDataAvailable(0, 0, 2)).toBe(false);
      });
    });
    it("getTileDataAvailable() converts xyz to tms", function() {
      const baseUrl = "made/up/url";
      returnPartialAvailabilityTileJson();
      const terrainProvider = new import__54.CesiumTerrainProvider({
        url: baseUrl
      });
      return pollToPromise_default(function() {
        return terrainProvider.ready;
      }).then(function() {
        expect(terrainProvider.getTileDataAvailable(1, 3, 2)).toBe(true);
        expect(terrainProvider.getTileDataAvailable(1, 0, 2)).toBe(false);
      });
    });
    it("getTileDataAvailable() with Metadata availability", function() {
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.metadataavailability.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnMetadataAvailabilityTileJson();
      const terrainProvider = new import__54.CesiumTerrainProvider({
        url: "made/up/url"
      });
      return pollToPromise_default(function() {
        return terrainProvider.ready;
      }).then(function() {
        expect(terrainProvider.getTileDataAvailable(0, 0, 0)).toBe(true);
        expect(terrainProvider.getTileDataAvailable(0, 0, 1)).toBeUndefined();
        return terrainProvider.requestTileGeometry(0, 0, 0);
      }).then(function() {
        expect(terrainProvider.getTileDataAvailable(0, 0, 1)).toBe(true);
      });
    });
    it("supports a query string in the base URL", function() {
      import__54.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__54.Resource._DefaultImplementations.loadWithXhr(
          "Data/EarthOrientationParameters/IcrfToFixedStkComponentsRotationData.json",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnHeightmapTileJson();
      return waitForTile(0, 0, 0, false, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__54.HeightmapTerrainData);
      });
    });
    it("Uses query parameter extensions for ion resource", function() {
      const terrainProvider = new import__54.CesiumTerrainProvider({
        url: import__54.IonResource.fromAssetId(1),
        requestVertexNormals: true,
        requestWaterMask: true
      });
      return pollToPromise_default(function() {
        return terrainProvider.ready;
      }).then(function() {
        const getDerivedResource = spyOn(
          import__54.IonResource.prototype,
          "getDerivedResource"
        ).and.callThrough();
        terrainProvider.requestTileGeometry(0, 0, 0);
        const options = getDerivedResource.calls.argsFor(0)[0];
        expect(options.queryParameters.extensions).toEqual(
          "octvertexnormals-watermask-metadata"
        );
      });
    });
  });
});

// packages/engine/Specs/Core/CheckSpec.js
var import__56 = __toESM(require_Cesium(), 1);
describe("Core/Check", function() {
  describe("type checks", function() {
    it("Check.typeOf.bool does not throw when passed a boolean", function() {
      expect(function() {
        import__56.Check.typeOf.bool("bool", true);
      }).not.toThrowDeveloperError();
    });
    it("Check.typeOf.bool throws when passed a non-boolean", function() {
      expect(function() {
        import__56.Check.typeOf.bool("mockName", {});
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.bool("mockName", []);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.bool("mockName", 1);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.bool("mockName", "snth");
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.bool("mockName", function() {
          return true;
        });
      }).toThrowDeveloperError();
    });
    it("Check.typeOf.bigint does not throw when passed a bigint", function() {
      if (!import__56.FeatureDetection.supportsBigInt()) {
        return;
      }
      expect(function() {
        import__56.Check.typeOf.bigint("bigint", BigInt());
      }).not.toThrowDeveloperError();
    });
    it("Check.typeOf.bigint throws when passed a non-bigint", function() {
      if (!import__56.FeatureDetection.supportsBigInt()) {
        return;
      }
      expect(function() {
        import__56.Check.typeOf.bigint("mockName", {});
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.bigint("mockName", []);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.bigint("mockName", 1);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.bigint("mockName", true);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.bigint("mockName", "snth");
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.bigint("mockName", function() {
          return true;
        });
      }).toThrowDeveloperError();
    });
    it("Check.typeOf.func does not throw when passed a function", function() {
      expect(function() {
        import__56.Check.typeOf.func("mockName", function() {
          return true;
        });
      }).not.toThrowDeveloperError();
    });
    it("Check.typeOf.func throws when passed a non-function", function() {
      expect(function() {
        import__56.Check.typeOf.func("mockName", {});
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.func("mockName", [2]);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.func("mockName", 1);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.func("mockName", "snth");
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.func("mockName", true);
      }).toThrowDeveloperError();
    });
    it("Check.typeOf.object does not throw when passed object", function() {
      expect(function() {
        import__56.Check.typeOf.object("mockName", {});
      }).not.toThrowDeveloperError();
    });
    it("Check.typeOf.object throws when passed non-object", function() {
      expect(function() {
        import__56.Check.typeOf.object("mockName", "snth");
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.object("mockName", true);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.object("mockName", 1);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.object("mockName", function() {
          return true;
        });
      }).toThrowDeveloperError();
    });
    it("Check.typeOf.number does not throw when passed number", function() {
      expect(function() {
        import__56.Check.typeOf.number("mockName", 2);
      }).not.toThrowDeveloperError();
    });
    it("Check.typeOf.number throws when passed non-number", function() {
      expect(function() {
        import__56.Check.typeOf.number("mockName", "snth");
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.number("mockName", true);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.number("mockName", {});
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.number("mockName", [2]);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.number("mockName", function() {
          return true;
        });
      }).toThrowDeveloperError();
    });
    it("Check.typeOf.string does not throw when passed a string", function() {
      expect(function() {
        import__56.Check.typeOf.string("mockName", "s");
      }).not.toThrowDeveloperError();
    });
    it("Check.typeOf.string throws on non-string", function() {
      expect(function() {
        import__56.Check.typeOf.string("mockName", {});
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.string("mockName", true);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.string("mockName", 1);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.string("mockName", [2]);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.string("mockName", function() {
          return true;
        });
      }).toThrowDeveloperError();
    });
  });
  describe("Check.defined", function() {
    it("does not throw unless passed value that is undefined or null", function() {
      expect(function() {
        import__56.Check.defined("mockName", {});
      }).not.toThrowDeveloperError();
      expect(function() {
        import__56.Check.defined("mockName", []);
      }).not.toThrowDeveloperError();
      expect(function() {
        import__56.Check.defined("mockName", 2);
      }).not.toThrowDeveloperError();
      expect(function() {
        import__56.Check.defined("mockName", function() {
          return true;
        });
      }).not.toThrowDeveloperError();
      expect(function() {
        import__56.Check.defined("mockName", "snt");
      }).not.toThrowDeveloperError();
    });
    it("throws when passed undefined", function() {
      expect(function() {
        import__56.Check.defined("mockName", void 0);
      }).toThrowDeveloperError();
    });
  });
  describe("Check.typeOf.number.lessThan", function() {
    it("throws if test is equal to limit", function() {
      expect(function() {
        import__56.Check.typeOf.number.lessThan("mockName", 3, 3);
      }).toThrowDeveloperError();
    });
    it("throws if test is greater than limit", function() {
      expect(function() {
        import__56.Check.typeOf.number.lessThan("mockName", 4, 3);
      }).toThrowDeveloperError();
    });
    it("does not throw if test is less than limit", function() {
      expect(function() {
        import__56.Check.typeOf.number.lessThan("mockName", 2, 3);
      }).not.toThrowDeveloperError();
    });
  });
  describe("Check.typeOf.number.lessThanOrEquals", function() {
    it("throws if test is greater than limit", function() {
      expect(function() {
        import__56.Check.typeOf.number.lessThanOrEquals("mockName", 4, 3);
      }).toThrowDeveloperError();
    });
    it("does not throw if test is equal to limit", function() {
      expect(function() {
        import__56.Check.typeOf.number.lessThanOrEquals("mockName", 3, 3);
      }).not.toThrowDeveloperError();
    });
    it("does not throw if test is less than limit", function() {
      expect(function() {
        import__56.Check.typeOf.number.lessThanOrEquals("mockName", 2, 3);
      }).not.toThrowDeveloperError();
    });
  });
  describe("Check.typeOf.number.equals", function() {
    it("throws if either value is not a number", function() {
      expect(function() {
        import__56.Check.typeOf.number.equals("mockName1", "mockname2", "a", 3);
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.number.equals("mockName1", "mockname2", 3, "a");
      }).toThrowDeveloperError();
      expect(function() {
        import__56.Check.typeOf.number.equals("mockName1", "mockname2", "b", "a");
      }).toThrowDeveloperError();
    });
    it("throws if both the values are a number but not equal", function() {
      expect(function() {
        import__56.Check.typeOf.number.equals("mockName1", "mockName2", 1, 4);
      }).toThrowDeveloperError();
    });
    it("does not throw if both values are a number and are equal", function() {
      expect(function() {
        import__56.Check.typeOf.number.equal("mockName1", "mockName2", 3, 3);
      }).not.toThrowDeveloperError();
    });
  });
  describe("Check.typeOf.number.greaterThan", function() {
    it("throws if test is equal to limit", function() {
      expect(function() {
        import__56.Check.typeOf.number.greaterThan("mockName", 3, 3);
      }).toThrowDeveloperError();
    });
    it("throws if test is less than limit", function() {
      expect(function() {
        import__56.Check.typeOf.number.greaterThan("mockName", 2, 3);
      }).toThrowDeveloperError();
    });
    it("does not throw if test is greater than limit", function() {
      expect(function() {
        import__56.Check.typeOf.number.greaterThan("mockName", 4, 3);
      }).not.toThrowDeveloperError();
    });
  });
  describe("Check.typeOf.number.greaterThanOrEquals", function() {
    it("throws if test is less than limit", function() {
      expect(function() {
        import__56.Check.typeOf.number.greaterThanOrEquals("mockName", 2, 3);
      }).toThrowDeveloperError();
    });
    it("does not throw if test is equal to limit", function() {
      expect(function() {
        import__56.Check.typeOf.number.greaterThanOrEquals("mockName", 3, 3);
      }).not.toThrowDeveloperError();
    });
    it("does not throw if test is greater than limit", function() {
      expect(function() {
        import__56.Check.typeOf.number.greaterThanOrEquals("mockName", 4, 3);
      }).not.toThrowDeveloperError();
    });
  });
});

// packages/engine/Specs/Core/CircleGeometrySpec.js
var import__57 = __toESM(require_Cesium(), 1);
var import__58 = __toESM(require_Cesium(), 1);
describe("Core/CircleGeometry", function() {
  it("throws without a center", function() {
    expect(function() {
      return new import__57.CircleGeometry({
        radius: 1
      });
    }).toThrowDeveloperError();
  });
  it("throws without a radius", function() {
    expect(function() {
      return new import__57.CircleGeometry({
        center: import__57.Cartesian3.fromDegrees(0, 0)
      });
    }).toThrowDeveloperError();
  });
  it("throws with a negative granularity", function() {
    expect(function() {
      return new import__57.CircleGeometry({
        center: import__57.Cartesian3.fromDegrees(0, 0),
        radius: 1,
        granularity: -1
      });
    }).toThrowDeveloperError();
  });
  it("computes positions", function() {
    const m = import__57.CircleGeometry.createGeometry(
      new import__57.CircleGeometry({
        vertexFormat: import__57.VertexFormat.POSITION_ONLY,
        ellipsoid: import__57.Ellipsoid.WGS84,
        center: import__57.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1
      })
    );
    const numVertices = 16;
    const numTriangles = 22;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
    expect(m.boundingSphere.radius).toEqual(1);
  });
  it("compute all vertex attributes", function() {
    const m = import__57.CircleGeometry.createGeometry(
      new import__57.CircleGeometry({
        vertexFormat: import__57.VertexFormat.ALL,
        ellipsoid: import__57.Ellipsoid.WGS84,
        center: import__57.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1
      })
    );
    const numVertices = 16;
    const numTriangles = 22;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.attributes.st.values.length).toEqual(numVertices * 2);
    expect(m.attributes.normal.values.length).toEqual(numVertices * 3);
    expect(m.attributes.tangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.bitangent.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("computes positions extruded", function() {
    const m = import__57.CircleGeometry.createGeometry(
      new import__57.CircleGeometry({
        vertexFormat: import__57.VertexFormat.POSITION_ONLY,
        ellipsoid: import__57.Ellipsoid.WGS84,
        center: import__57.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1,
        extrudedHeight: 1e4
      })
    );
    const numVertices = 48;
    const numTriangles = 60;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("compute all vertex attributes extruded", function() {
    const m = import__57.CircleGeometry.createGeometry(
      new import__57.CircleGeometry({
        vertexFormat: import__57.VertexFormat.ALL,
        ellipsoid: import__57.Ellipsoid.WGS84,
        center: import__57.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1,
        extrudedHeight: 1e4
      })
    );
    const numVertices = 48;
    const numTriangles = 60;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.attributes.st.values.length).toEqual(numVertices * 2);
    expect(m.attributes.normal.values.length).toEqual(numVertices * 3);
    expect(m.attributes.tangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.bitangent.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("compute texture coordinates with rotation", function() {
    const m = import__57.CircleGeometry.createGeometry(
      new import__57.CircleGeometry({
        vertexFormat: import__57.VertexFormat.POSITION_AND_ST,
        ellipsoid: import__57.Ellipsoid.WGS84,
        center: import__57.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1,
        stRotation: import__58.Math.PI_OVER_TWO
      })
    );
    const positions = m.attributes.position.values;
    const st = m.attributes.st.values;
    const length2 = st.length;
    expect(positions.length).toEqual(3 * 16);
    expect(length2).toEqual(2 * 16);
    expect(m.indices.length).toEqual(3 * 22);
    expect(st[length2 - 2]).toEqualEpsilon(0.5, import__58.Math.EPSILON2);
    expect(st[length2 - 1]).toEqualEpsilon(0, import__58.Math.EPSILON2);
  });
  it("undefined is returned if radius is equal to or less than zero", function() {
    const circle0 = new import__57.CircleGeometry({
      center: import__57.Cartesian3.fromDegrees(-75.59777, 40.03883),
      radius: 0
    });
    const circle1 = new import__57.CircleGeometry({
      center: import__57.Cartesian3.fromDegrees(-75.59777, 40.03883),
      radius: -10
    });
    const geometry0 = import__57.CircleGeometry.createGeometry(circle0);
    const geometry1 = import__57.CircleGeometry.createGeometry(circle1);
    expect(geometry0).toBeUndefined();
    expect(geometry1).toBeUndefined();
  });
  it("computing rectangle property", function() {
    const center2 = import__57.Cartesian3.fromDegrees(-75.59777, 40.03883);
    const ellipse = new import__57.CircleGeometry({
      center: center2,
      radius: 1e3
    });
    const r = ellipse.rectangle;
    expect(r.north).toEqualEpsilon(0.698966597893341, import__58.Math.EPSILON15);
    expect(r.south).toEqualEpsilon(0.698652226072367, import__58.Math.EPSILON15);
    expect(r.east).toEqualEpsilon(-1.3192254919753026, import__58.Math.EPSILON15);
    expect(r.west).toEqualEpsilon(-1.3196344953554853, import__58.Math.EPSILON15);
  });
  it("computing textureCoordinateRotationPoints property", function() {
    const center2 = import__57.Cartesian3.fromDegrees(0, 0);
    const ellipse = new import__57.CircleGeometry({
      center: center2,
      radius: 1e3,
      stRotation: import__58.Math.toRadians(90)
    });
    const textureCoordinateRotationPoints = ellipse.textureCoordinateRotationPoints;
    expect(textureCoordinateRotationPoints.length).toEqual(6);
    expect(textureCoordinateRotationPoints[0]).toEqualEpsilon(
      0,
      import__58.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[1]).toEqualEpsilon(
      1,
      import__58.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[2]).toEqualEpsilon(
      1,
      import__58.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[3]).toEqualEpsilon(
      1,
      import__58.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[4]).toEqualEpsilon(
      0,
      import__58.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[5]).toEqualEpsilon(
      0,
      import__58.Math.EPSILON7
    );
  });
  const center = import__57.Cartesian3.fromDegrees(0, 0);
  const ellipsoid = import__57.Ellipsoid.WGS84;
  const packableInstance = new import__57.CircleGeometry({
    vertexFormat: import__57.VertexFormat.POSITION_AND_ST,
    ellipsoid,
    center,
    granularity: 0.1,
    radius: 1,
    stRotation: import__58.Math.PI_OVER_TWO
  });
  const packedInstance = [
    center.x,
    center.y,
    center.z,
    ellipsoid.radii.x,
    ellipsoid.radii.y,
    ellipsoid.radii.z,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    import__58.Math.PI_OVER_TWO,
    0,
    0.1,
    0,
    0,
    -1
  ];
  createPackableSpecs_default(import__57.CircleGeometry, packableInstance, packedInstance);
});

// packages/engine/Specs/Core/CircleOutlineGeometrySpec.js
var import__59 = __toESM(require_Cesium(), 1);
describe("Core/CircleOutlineGeometry", function() {
  it("throws without a center", function() {
    expect(function() {
      return new import__59.CircleOutlineGeometry({
        radius: 1
      });
    }).toThrowDeveloperError();
  });
  it("throws without a radius", function() {
    expect(function() {
      return new import__59.CircleOutlineGeometry({
        center: import__59.Cartesian3.fromDegrees(0, 0)
      });
    }).toThrowDeveloperError();
  });
  it("throws with a negative granularity", function() {
    expect(function() {
      return new import__59.CircleOutlineGeometry({
        center: import__59.Cartesian3.fromDegrees(0, 0),
        radius: 1,
        granularity: -1
      });
    }).toThrowDeveloperError();
  });
  it("computes positions", function() {
    const m = import__59.CircleOutlineGeometry.createGeometry(
      new import__59.CircleOutlineGeometry({
        ellipsoid: import__59.Ellipsoid.WGS84,
        center: import__59.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(8 * 2);
    expect(m.boundingSphere.radius).toEqual(1);
  });
  it("computes positions extruded", function() {
    const m = import__59.CircleOutlineGeometry.createGeometry(
      new import__59.CircleOutlineGeometry({
        ellipsoid: import__59.Ellipsoid.WGS84,
        center: import__59.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1,
        extrudedHeight: 5
      })
    );
    expect(m.attributes.position.values.length).toEqual(16 * 3);
    expect(m.indices.length).toEqual(24 * 2);
  });
  it("computes positions extruded, no lines between top and bottom", function() {
    const m = import__59.CircleOutlineGeometry.createGeometry(
      new import__59.CircleOutlineGeometry({
        ellipsoid: import__59.Ellipsoid.WGS84,
        center: import__59.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1,
        extrudedHeight: 1e4,
        numberOfVerticalLines: 0
      })
    );
    expect(m.attributes.position.values.length).toEqual(16 * 3);
    expect(m.indices.length).toEqual(16 * 2);
  });
  it("undefined is returned if radius is equal to or less than zero", function() {
    const circleOutline0 = new import__59.CircleOutlineGeometry({
      center: import__59.Cartesian3.fromDegrees(-75.59777, 40.03883),
      radius: 0
    });
    const circleOutline1 = new import__59.CircleOutlineGeometry({
      center: import__59.Cartesian3.fromDegrees(-75.59777, 40.03883),
      radius: -10
    });
    const geometry0 = import__59.CircleOutlineGeometry.createGeometry(circleOutline0);
    const geometry1 = import__59.CircleOutlineGeometry.createGeometry(circleOutline1);
    expect(geometry0).toBeUndefined();
    expect(geometry1).toBeUndefined();
  });
  const center = new import__59.Cartesian3(8, 9, 10);
  const ellipsoid = new import__59.Ellipsoid(11, 12, 13);
  let packableInstance = new import__59.CircleOutlineGeometry({
    ellipsoid,
    center,
    granularity: 1,
    radius: 2,
    numberOfVerticalLines: 4,
    height: 5,
    extrudedHeight: 7
  });
  let packedInstance = [
    center.x,
    center.y,
    center.z,
    ellipsoid.radii.x,
    ellipsoid.radii.y,
    ellipsoid.radii.z,
    2,
    2,
    0,
    7,
    1,
    5,
    4,
    -1
  ];
  createPackableSpecs_default(
    import__59.CircleOutlineGeometry,
    packableInstance,
    packedInstance,
    "extruded"
  );
  packableInstance = new import__59.CircleOutlineGeometry({
    ellipsoid,
    center,
    granularity: 1,
    radius: 2,
    numberOfVerticalLines: 4,
    height: 5
  });
  packedInstance = [
    center.x,
    center.y,
    center.z,
    ellipsoid.radii.x,
    ellipsoid.radii.y,
    ellipsoid.radii.z,
    2,
    2,
    0,
    5,
    1,
    5,
    4,
    -1
  ];
  createPackableSpecs_default(
    import__59.CircleOutlineGeometry,
    packableInstance,
    packedInstance,
    "at height"
  );
});

// packages/engine/Specs/Core/ClockSpec.js
var import__60 = __toESM(require_Cesium(), 1);
describe("Core/Clock", function() {
  it("sets default parameters when constructed", function() {
    const clock = new import__60.Clock();
    expect(clock.stopTime).toEqual(
      import__60.JulianDate.addDays(clock.startTime, 1, new import__60.JulianDate())
    );
    expect(clock.startTime).toEqual(clock.currentTime);
    expect(clock.multiplier).toEqual(1);
    expect(clock.clockStep).toEqual(import__60.ClockStep.SYSTEM_CLOCK_MULTIPLIER);
    expect(clock.clockRange).toEqual(import__60.ClockRange.UNBOUNDED);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
  });
  it("sets provided constructor parameters correctly", function() {
    const start = new import__60.JulianDate(12);
    const stop = new import__60.JulianDate(112);
    const currentTime = new import__60.JulianDate(13);
    const step = import__60.ClockStep.TICK_DEPENDENT;
    const range = import__60.ClockRange.LOOP_STOP;
    const multiplier = 1.5;
    let clock = new import__60.Clock({
      startTime: start,
      stopTime: stop,
      currentTime,
      clockStep: step,
      multiplier,
      clockRange: range
    });
    expect(clock.startTime).toEqual(start);
    expect(clock.startTime).not.toBe(start);
    expect(clock.stopTime).toEqual(stop);
    expect(clock.stopTime).not.toBe(stop);
    expect(clock.currentTime).toEqual(currentTime);
    expect(clock.currentTime).not.toBe(currentTime);
    expect(clock.clockStep).toEqual(step);
    expect(clock.clockRange).toEqual(range);
    expect(clock.multiplier).toEqual(multiplier);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
    clock = new import__60.Clock({
      canAnimate: false
    });
    expect(clock.canAnimate).toEqual(false);
    clock = new import__60.Clock({
      shouldAnimate: true
    });
    expect(clock.shouldAnimate).toEqual(true);
  });
  it("works when constructed with no currentTime parameter", function() {
    const start = new import__60.JulianDate(12);
    const stop = new import__60.JulianDate(112);
    const step = import__60.ClockStep.TICK_DEPENDENT;
    const range = import__60.ClockRange.LOOP_STOP;
    const multiplier = 1.5;
    const clock = new import__60.Clock({
      startTime: start,
      stopTime: stop,
      clockStep: step,
      multiplier,
      clockRange: range
    });
    expect(clock.startTime).toEqual(start);
    expect(clock.stopTime).toEqual(stop);
    expect(clock.currentTime).toEqual(start);
    expect(clock.clockStep).toEqual(step);
    expect(clock.clockRange).toEqual(range);
    expect(clock.multiplier).toEqual(multiplier);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
  });
  it("works when constructed with no startTime parameter", function() {
    const stop = new import__60.JulianDate(112);
    const currentTime = new import__60.JulianDate(13);
    const step = import__60.ClockStep.TICK_DEPENDENT;
    const range = import__60.ClockRange.LOOP_STOP;
    const multiplier = 1.5;
    const clock = new import__60.Clock({
      stopTime: stop,
      currentTime,
      clockStep: step,
      multiplier,
      clockRange: range
    });
    expect(clock.startTime).toEqual(currentTime);
    expect(clock.stopTime).toEqual(stop);
    expect(clock.currentTime).toEqual(currentTime);
    expect(clock.clockStep).toEqual(step);
    expect(clock.clockRange).toEqual(range);
    expect(clock.multiplier).toEqual(multiplier);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
  });
  it("works when constructed with no startTime or stopTime", function() {
    const currentTime = new import__60.JulianDate(12);
    const step = import__60.ClockStep.TICK_DEPENDENT;
    const range = import__60.ClockRange.LOOP_STOP;
    const multiplier = 1.5;
    const clock = new import__60.Clock({
      currentTime,
      clockStep: step,
      multiplier,
      clockRange: range
    });
    const expectedStop = import__60.JulianDate.addDays(currentTime, 1, new import__60.JulianDate());
    expect(clock.startTime).toEqual(currentTime);
    expect(clock.stopTime).toEqual(expectedStop);
    expect(clock.currentTime).toEqual(currentTime);
    expect(clock.clockStep).toEqual(step);
    expect(clock.clockRange).toEqual(range);
    expect(clock.multiplier).toEqual(multiplier);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
  });
  it("works when constructed with no startTime or currentTime", function() {
    const stop = new import__60.JulianDate(13);
    const step = import__60.ClockStep.TICK_DEPENDENT;
    const range = import__60.ClockRange.LOOP_STOP;
    const multiplier = 1.5;
    const clock = new import__60.Clock({
      stopTime: stop,
      clockStep: step,
      multiplier,
      clockRange: range
    });
    const expectedStart = import__60.JulianDate.addDays(stop, -1, new import__60.JulianDate());
    expect(clock.startTime).toEqual(expectedStart);
    expect(clock.stopTime).toEqual(stop);
    expect(clock.currentTime).toEqual(expectedStart);
    expect(clock.clockStep).toEqual(step);
    expect(clock.clockRange).toEqual(range);
    expect(clock.multiplier).toEqual(multiplier);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
  });
  it("works when constructed with no currentTime or stopTime", function() {
    const start = new import__60.JulianDate(12);
    const step = import__60.ClockStep.TICK_DEPENDENT;
    const range = import__60.ClockRange.LOOP_STOP;
    const multiplier = 1.5;
    const clock = new import__60.Clock({
      startTime: start,
      clockStep: step,
      multiplier,
      clockRange: range
    });
    const expectedStop = import__60.JulianDate.addDays(start, 1, new import__60.JulianDate());
    expect(clock.startTime).toEqual(start);
    expect(clock.stopTime).toEqual(expectedStop);
    expect(clock.currentTime).toEqual(start);
    expect(clock.clockStep).toEqual(step);
    expect(clock.clockRange).toEqual(range);
    expect(clock.multiplier).toEqual(multiplier);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
  });
  it("works when constructed with no stopTime parameter", function() {
    const start = new import__60.JulianDate(12);
    const currentTime = new import__60.JulianDate(12);
    const step = import__60.ClockStep.TICK_DEPENDENT;
    const range = import__60.ClockRange.LOOP_STOP;
    const multiplier = 1.5;
    const clock = new import__60.Clock({
      startTime: start,
      currentTime,
      clockStep: step,
      multiplier,
      clockRange: range
    });
    const expectedStop = import__60.JulianDate.addDays(start, 1, new import__60.JulianDate());
    expect(clock.startTime).toEqual(start);
    expect(clock.stopTime).toEqual(expectedStop);
    expect(clock.currentTime).toEqual(currentTime);
    expect(clock.clockStep).toEqual(step);
    expect(clock.clockRange).toEqual(range);
    expect(clock.multiplier).toEqual(multiplier);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
  });
  it("throws when constructed if start time is after stop time", function() {
    const start = new import__60.JulianDate(1);
    const stop = new import__60.JulianDate(0);
    expect(function() {
      return new import__60.Clock({
        startTime: start,
        stopTime: stop
      });
    }).toThrowDeveloperError();
  });
  it("animates forward in TICK_DEPENDENT mode", function() {
    const start = new import__60.JulianDate(0);
    const stop = new import__60.JulianDate(1);
    let currentTime = new import__60.JulianDate(0.5);
    const multiplier = 1.5;
    const clock = new import__60.Clock({
      startTime: start,
      stopTime: stop,
      currentTime,
      clockStep: import__60.ClockStep.TICK_DEPENDENT,
      multiplier,
      clockRange: import__60.ClockRange.LOOP_STOP,
      shouldAnimate: true
    });
    expect(clock.currentTime).toEqual(currentTime);
    currentTime = import__60.JulianDate.addSeconds(
      currentTime,
      multiplier,
      new import__60.JulianDate()
    );
    expect(currentTime).toEqual(clock.tick());
    expect(clock.currentTime).toEqual(currentTime);
    currentTime = import__60.JulianDate.addSeconds(
      currentTime,
      multiplier,
      new import__60.JulianDate()
    );
    expect(currentTime).toEqual(clock.tick());
    expect(clock.currentTime).toEqual(currentTime);
  });
  it("animates backwards in TICK_DEPENDENT mode", function() {
    const start = new import__60.JulianDate(0);
    const stop = new import__60.JulianDate(1);
    let currentTime = new import__60.JulianDate(0.5);
    const multiplier = -1.5;
    const clock = new import__60.Clock({
      startTime: start,
      stopTime: stop,
      currentTime,
      clockStep: import__60.ClockStep.TICK_DEPENDENT,
      multiplier,
      clockRange: import__60.ClockRange.LOOP_STOP,
      shouldAnimate: true
    });
    expect(clock.currentTime).toEqual(currentTime);
    currentTime = import__60.JulianDate.addSeconds(
      currentTime,
      multiplier,
      new import__60.JulianDate()
    );
    expect(currentTime).toEqual(clock.tick());
    expect(clock.currentTime).toEqual(currentTime);
    currentTime = import__60.JulianDate.addSeconds(
      currentTime,
     