/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.solver;

import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.optimize.TransformFilterPlacement;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPeek;
import org.apache.jena.sparql.engine.main.OpExecutor;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderProc;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.util.iterator.Filter;
import org.rdfhdt.hdtjena.HDTGraph;
import org.rdfhdt.hdtjena.HDTJenaConstants;
import org.rdfhdt.hdtjena.bindings.HDTId;
import org.rdfhdt.hdtjena.solver.HDTSolverLib;

public class OpExecutorHDT
extends OpExecutor {
    public static final OpExecutorFactory opExecFactoryHDT = new OpExecutorFactory(){

        @Override
        public OpExecutor create(ExecutionContext execCxt) {
            return new OpExecutorHDT(execCxt);
        }
    };
    private boolean isForHDT;
    private static OpExecutorFactory plainFactory = new OpExecutorPlainFactoryHDT();

    protected OpExecutorHDT(ExecutionContext execCtx) {
        super(execCtx);
        this.isForHDT = execCtx.getActiveGraph() instanceof HDTGraph;
    }

    @Override
    protected QueryIterator execute(OpDistinct opDistinct, QueryIterator input) {
        return super.execute(opDistinct, input);
    }

    @Override
    protected QueryIterator execute(OpReduced opReduced, QueryIterator input) {
        return super.execute(opReduced, input);
    }

    @Override
    protected QueryIterator execute(OpFilter opFilter, QueryIterator input) {
        if (!this.isForHDT) {
            return super.execute(opFilter, input);
        }
        if (OpBGP.isBGP(opFilter.getSubOp())) {
            HDTGraph graph = (HDTGraph)this.execCxt.getActiveGraph();
            OpBGP opBGP = (OpBGP)opFilter.getSubOp();
            return OpExecutorHDT.executeBGP(graph, opBGP, input, opFilter.getExprs(), this.execCxt);
        }
        return super.execute(opFilter, input);
    }

    @Override
    protected QueryIterator execute(OpBGP opBGP, QueryIterator input) {
        if (!this.isForHDT) {
            return super.execute(opBGP, input);
        }
        HDTGraph graph = (HDTGraph)this.execCxt.getActiveGraph();
        return OpExecutorHDT.executeBGP(graph, opBGP, input, null, this.execCxt);
    }

    private static QueryIterator executeBGP(HDTGraph graph, OpBGP opBGP, QueryIterator input, ExprList exprs, ExecutionContext execCxt) {
        return OpExecutorHDT.optimizeExecuteTriples(graph, input, opBGP.getPattern(), exprs, execCxt);
    }

    private static QueryIterator optimizeExecuteTriples(HDTGraph graph, QueryIterator input, BasicPattern pattern, ExprList exprs, ExecutionContext execCxt) {
        ReorderTransformation transform;
        if (!input.hasNext()) {
            return input;
        }
        if (pattern.size() >= 2 && (transform = graph.getReorderTransform()) != null) {
            QueryIterPeek peek = QueryIterPeek.create(input, execCxt);
            input = peek;
            pattern = OpExecutorHDT.reorder(pattern, peek, transform);
        }
        Op op = null;
        op = exprs != null ? TransformFilterPlacement.transform(exprs, pattern) : new OpBGP(pattern);
        return OpExecutorHDT.plainExecute(op, input, execCxt);
    }

    private static QueryIterator plainExecute(Op op, QueryIterator input, ExecutionContext execCxt) {
        ExecutionContext ec2 = new ExecutionContext(execCxt);
        ec2.setExecutor(plainFactory);
        return QC.execute(op, input, ec2);
    }

    private static BasicPattern reorder(BasicPattern pattern, QueryIterPeek peek, ReorderTransformation transform) {
        if (transform != null) {
            if (!peek.hasNext()) {
                throw new ARQInternalErrorException("Peek iterator is already empty");
            }
            BasicPattern pattern2 = Substitute.substitute(pattern, peek.peek());
            ReorderProc proc = transform.reorderIndexes(pattern2);
            pattern = proc.reorder(pattern);
        }
        return pattern;
    }

    private static class OpExecutorPlainHDT
    extends OpExecutor {
        Filter<Tuple<HDTId>> filter;

        public OpExecutorPlainHDT(ExecutionContext execCxt) {
            super(execCxt);
            this.filter = (Filter)execCxt.getContext().get(HDTJenaConstants.FILTER_SYMBOL);
        }

        @Override
        public QueryIterator execute(OpBGP opBGP, QueryIterator input) {
            Graph g = this.execCxt.getActiveGraph();
            if (g instanceof HDTGraph) {
                BasicPattern bgp = opBGP.getPattern();
                Explain.explain("Execute", bgp, this.execCxt.getContext());
                return HDTSolverLib.execute((HDTGraph)g, bgp, input, this.filter, this.execCxt);
            }
            Log.warn(this, "Non-HDTGraph passed to OpExecutorPlainHDT");
            return super.execute(opBGP, input);
        }
    }

    private static class OpExecutorPlainFactoryHDT
    implements OpExecutorFactory {
        private OpExecutorPlainFactoryHDT() {
        }

        @Override
        public OpExecutor create(ExecutionContext execCxt) {
            return new OpExecutorPlainHDT(execCxt);
        }
    }
}

