/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.cache;

import org.apache.jena.graph.Node;
import org.rdfhdt.hdtjena.cache.DictionaryCache;

public class DictionaryCacheArray
implements DictionaryCache {
    private Node[] array = null;
    final int capacity;
    int numentries = 0;

    public DictionaryCacheArray(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public Node get(int id) {
        if (this.array == null) {
            return null;
        }
        if (id > this.array.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[id - 1];
    }

    @Override
    public void put(int id, Node node) {
        if (this.array == null) {
            this.array = new Node[this.capacity];
        }
        if (this.array[id - 1] == null) {
            ++this.numentries;
        }
        this.array[id - 1] = node;
    }

    @Override
    public int size() {
        return this.numentries;
    }

    @Override
    public void clear() {
        this.array = null;
    }
}

