/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena;

import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Node;
import org.rdfhdt.hdt.compact.sequence.Sequence;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.Triples;
import org.rdfhdt.hdt.triples.impl.BitmapTriples;
import org.rdfhdt.hdtjena.HDTGraph;
import org.rdfhdt.hdtjena.NodeDictionary;

public class HDTStatistics
implements GraphStatisticsHandler {
    private final NodeDictionary nodeDictionary;
    private final Triples triples;
    private final HDT hdt;

    public HDTStatistics(HDTGraph graph) {
        this.nodeDictionary = graph.getNodeDictionary();
        this.hdt = graph.getHDT();
        this.triples = this.hdt.getTriples();
    }

    @Override
    public long getStatistic(Node subject, Node predicate, Node object) {
        int s = this.nodeDictionary.getIntID(subject, TripleComponentRole.SUBJECT);
        int p = this.nodeDictionary.getIntID(predicate, TripleComponentRole.PREDICATE);
        int o = this.nodeDictionary.getIntID(object, TripleComponentRole.OBJECT);
        if (s < 0 || p < 0 || o < 0) {
            return 0L;
        }
        if (p > 0 && s == 0 && o == 0 && this.triples instanceof BitmapTriples) {
            Sequence predCount = ((BitmapTriples)this.triples).getPredicateCount();
            if (predCount != null) {
                return predCount.get(p - 1);
            }
            return this.triples.getNumberOfElements() / this.hdt.getDictionary().getNpredicates();
        }
        IteratorTripleID it = this.triples.search(new TripleID(s, p, o));
        return it.estimatedNumResults();
    }
}

