/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena;

import java.io.IOException;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdtjena.HDTGraph;
import org.rdfhdt.hdtjena.HDTJenaConstants;

public class HDTGraphAssembler
extends AssemblerBase
implements Assembler {
    private static boolean initialized;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        Assembler.general.implementWith(HDTJenaConstants.tGraphHDT, new HDTGraphAssembler());
    }

    @Override
    public Model open(Assembler a, Resource root2, Mode mode) {
        String file = GraphUtils.getStringValue(root2, HDTJenaConstants.pFileName);
        boolean loadInMemory = Boolean.parseBoolean(GraphUtils.getStringValue(root2, HDTJenaConstants.pKeepInMemory));
        try {
            HDT hdt = loadInMemory ? HDTManager.loadIndexedHDT(file, null) : HDTManager.mapIndexedHDT(file, null);
            HDTGraph graph = new HDTGraph(hdt);
            return ModelFactory.createModelForGraph(graph);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new AssemblerException(root2, "Error reading HDT file: " + file + " / " + e2.toString());
        }
    }
}

