/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena;

import java.io.IOException;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdtjena.HDTCapabilities;
import org.rdfhdt.hdtjena.HDTStatistics;
import org.rdfhdt.hdtjena.NodeDictionary;
import org.rdfhdt.hdtjena.solver.HDTJenaIterator;
import org.rdfhdt.hdtjena.solver.HDTQueryEngine;
import org.rdfhdt.hdtjena.solver.OpExecutorHDT;
import org.rdfhdt.hdtjena.solver.ReorderTransformationHDT;

public class HDTGraph
extends GraphBase {
    private static HDTCapabilities capabilities = new HDTCapabilities();
    private HDT hdt;
    private NodeDictionary nodeDictionary;
    private ReorderTransformation reorderTransform;
    private HDTStatistics hdtStatistics;
    private long numSearches;
    private boolean closeAfter;

    public HDTGraph(HDT hdt) {
        this(hdt, false);
    }

    public HDTGraph(HDT hdt, boolean close) {
        this.hdt = hdt;
        this.nodeDictionary = new NodeDictionary(hdt.getDictionary());
        this.hdtStatistics = new HDTStatistics(this);
        this.reorderTransform = new ReorderTransformationHDT(this);
        this.closeAfter = close;
    }

    public HDT getHDT() {
        return this.hdt;
    }

    public NodeDictionary getNodeDictionary() {
        return this.nodeDictionary;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple jenaTriple) {
        TripleID triplePatID = this.nodeDictionary.getTriplePatID(jenaTriple);
        IteratorTripleID hdtIterator = this.hdt.getTriples().search(triplePatID);
        ++this.numSearches;
        return new HDTJenaIterator(this.nodeDictionary, hdtIterator);
    }

    public long getNumSearches() {
        return this.numSearches;
    }

    @Override
    public GraphStatisticsHandler getStatisticsHandler() {
        return this.hdtStatistics;
    }

    @Override
    public Capabilities getCapabilities() {
        return capabilities;
    }

    public ReorderTransformation getReorderTransform() {
        return this.reorderTransform;
    }

    @Override
    protected int graphBaseSize() {
        return (int)this.hdt.getTriples().getNumberOfElements();
    }

    @Override
    public void close() {
        super.close();
        if (this.closeAfter) {
            try {
                this.hdt.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    static {
        QC.setFactory(ARQ.getContext(), OpExecutorHDT.opExecFactoryHDT);
        HDTQueryEngine.register();
    }
}

