/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ExternalDecompressStream
extends InputStream {
    private InputStream in;
    private Process process;
    public static final String[] GZIP = new String[]{"gzip", "-c", "-d"};
    public static final String[] PIGZ = new String[]{"pigz", "-c", "-d"};
    public static final String[] BZIP2 = new String[]{"bzip2", "-c", "-d"};
    public static final String[] PBZIP2 = new String[]{"pbzip2", "-c", "-d"};
    public static final String[] SNZIP = new String[]{"snzip", "-c", "-d"};

    public ExternalDecompressStream(File inFile, String[] cmd) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectInput(inFile);
        this.process = pb.start();
        this.in = this.process.getInputStream();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        byte[] buf = new byte[(int)(n < 8192L ? n : 8192L)];
        return this.in.read(buf);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        try {
            this.process.waitFor();
            this.process.getOutputStream().close();
            this.process.getErrorStream().close();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }
}

