/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.crc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rdfhdt.hdt.util.crc.CRC;

public class CRC8
implements CRC {
    byte crc8;
    private static final byte[] crc8_table = new byte[]{0, 7, 14, 9, 28, 27, 18, 21, 56, 63, 54, 49, 36, 35, 42, 45, 112, 119, 126, 121, 108, 107, 98, 101, 72, 79, 70, 65, 84, 83, 90, 93, -32, -25, -18, -23, -4, -5, -14, -11, -40, -33, -42, -47, -60, -61, -54, -51, -112, -105, -98, -103, -116, -117, -126, -123, -88, -81, -90, -95, -76, -77, -70, -67, -57, -64, -55, -50, -37, -36, -43, -46, -1, -8, -15, -10, -29, -28, -19, -22, -73, -80, -71, -66, -85, -84, -91, -94, -113, -120, -127, -122, -109, -108, -99, -102, 39, 32, 41, 46, 59, 60, 53, 50, 31, 24, 17, 22, 3, 4, 13, 10, 87, 80, 89, 94, 75, 76, 69, 66, 111, 104, 97, 102, 115, 116, 125, 122, -119, -114, -121, -128, -107, -110, -101, -100, -79, -74, -65, -72, -83, -86, -93, -92, -7, -2, -9, -16, -27, -30, -21, -20, -63, -58, -49, -56, -35, -38, -45, -44, 105, 110, 103, 96, 117, 114, 123, 124, 81, 86, 95, 88, 77, 74, 67, 68, 25, 30, 23, 16, 5, 2, 11, 12, 33, 38, 47, 40, 61, 58, 51, 52, 78, 73, 64, 71, 82, 85, 92, 91, 118, 113, 120, 127, 106, 109, 100, 99, 62, 57, 48, 55, 34, 37, 44, 43, 6, 1, 8, 15, 26, 29, 20, 19, -82, -87, -96, -89, -78, -75, -68, -69, -106, -111, -104, -97, -118, -115, -124, -125, -34, -39, -48, -41, -62, -59, -52, -53, -26, -31, -24, -17, -6, -3, -12, -13};

    @Override
    public void update(byte[] buffer, int offset, int length) {
        int i = offset;
        int len = length;
        while (len-- != 0) {
            this.crc8 = crc8_table[(this.crc8 ^ buffer[i]) & 0xFF];
            ++i;
        }
    }

    @Override
    public void update(byte data) {
        this.crc8 = crc8_table[(this.crc8 ^ data) & 0xFF];
    }

    @Override
    public void writeCRC(OutputStream out) throws IOException {
        out.write(this.crc8);
    }

    @Override
    public boolean readAndCheck(InputStream in) throws IOException {
        int val = in.read();
        if (val == -1) {
            throw new IOException("Could not read from input.");
        }
        byte othercrc = (byte)(val & 0xFF);
        return othercrc == this.crc8;
    }

    @Override
    public long getValue() {
        return this.crc8;
    }

    @Override
    public void reset() {
        this.crc8 = 0;
    }

    @Override
    public int compareTo(CRC o) {
        if (o instanceof CRC8) {
            return ((CRC8)o).crc8 - this.crc8;
        }
        throw new RuntimeException("Cannot compare CRC's of different types");
    }

    public String toString() {
        return Long.toHexString(this.getValue() & 0xFFL);
    }
}

