/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util;

import java.io.PrintStream;

public class Statistics {
    double maxObservedValue;
    double minObservedValue;
    double maxVal;
    double total;
    long totalLong;
    long number;
    double meanAccum;
    double deviationAccum;

    public Statistics() {
        this.reset();
    }

    public void reset() {
        this.number = 0L;
        this.minObservedValue = Double.MAX_VALUE;
        this.maxObservedValue = -1.7976931348623157E308;
        this.total = 0.0;
        this.totalLong = 0L;
        this.meanAccum = 0.0;
        this.deviationAccum = 0.0;
    }

    public void process(long val) {
        this.totalLong += val;
        this.process((double)val);
    }

    public void process(double val) {
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            return;
        }
        ++this.number;
        this.minObservedValue = Math.min(this.minObservedValue, val);
        this.maxObservedValue = Math.max(this.maxObservedValue, val);
        this.total += val;
        this.meanAccum += val;
        this.deviationAccum += val * val;
    }

    public void dump(PrintStream out) {
        out.println("# Number: " + this.getNumber());
        out.println("# Min: " + this.getMinvalue());
        out.println("# Max: " + this.getMaxvalue());
        out.println("# Mean: " + this.getAverage());
        out.println("# Deviation: " + this.getDeviation());
        out.println("# Total: " + this.total);
    }

    public double getMaxvalue() {
        return this.maxObservedValue;
    }

    public double getMinvalue() {
        return this.minObservedValue;
    }

    public double getAverage() {
        return this.meanAccum / (double)this.number;
    }

    public double getDeviation() {
        double average = this.getAverage();
        double deviation = this.deviationAccum / (double)this.number - average * average;
        deviation = Math.sqrt(deviation);
        return deviation;
    }

    public double getTotal() {
        return this.total;
    }

    public long getTotalLong() {
        return this.totalLong;
    }

    public long getNumber() {
        return this.number;
    }
}

