/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util;

import java.io.PrintStream;
import org.rdfhdt.hdt.util.StringUtil;

public class Histogram {
    int[] data;
    int numBands;
    double maxObservedValue;
    double minObservedValue;
    double maxVal;
    double total;
    long totalLong;
    long number;
    double mean;
    double deviation;
    double fisher;

    public Histogram(double maxVal, int numBands) {
        this.numBands = numBands;
        this.reset();
        this.maxVal = maxVal;
    }

    public void reset() {
        this.data = new int[this.numBands];
        this.number = 0L;
        this.minObservedValue = Double.MAX_VALUE;
        this.maxObservedValue = -1.7976931348623157E308;
        this.total = 0.0;
        this.totalLong = 0L;
        this.mean = 0.0;
        this.deviation = 0.0;
        this.fisher = 0.0;
    }

    public void process(long val) {
        this.totalLong += val;
        this.process((double)val);
    }

    public void process(double val) {
        ++this.number;
        this.minObservedValue = Math.min(this.minObservedValue, val);
        this.maxObservedValue = Math.max(this.maxObservedValue, val);
        this.total += val;
        this.mean += val;
        this.deviation += val * val;
        this.fisher += val * val * val;
        int pos = (int)(val * (double)(this.numBands - 1) / this.maxVal);
        if (pos < 0) {
            pos = 0;
        }
        if (pos >= this.data.length) {
            pos = this.data.length - 1;
        }
        int n = pos;
        this.data[n] = this.data[n] + 1;
    }

    public void end() {
        this.mean /= (double)this.number;
        this.deviation = this.deviation / (double)this.number - this.mean * this.mean;
        this.deviation = Math.sqrt(this.deviation);
        this.fisher = this.fisher / (double)this.number - this.mean * this.mean * this.mean;
        this.fisher = this.fisher / this.deviation * this.deviation * this.deviation;
    }

    public void dump(PrintStream out) {
        this.end();
        for (int i = 0; (double)i <= this.maxObservedValue && i < this.data.length; ++i) {
            out.println(i + " " + this.data[i] + " (" + StringUtil.getPercent(this.data[i], this.number) + ")");
        }
        out.println("# Number: " + this.number++);
        out.println("# Min: " + this.minObservedValue);
        out.println("# Max: " + this.maxObservedValue);
        out.println("# Mean: " + this.mean);
        out.println("# Deviation: " + this.deviation);
        out.println("# Total: " + this.total);
    }

    public int getNumBands() {
        return this.numBands;
    }

    public double getMaxvalue() {
        return this.maxObservedValue;
    }

    public double getMinvalue() {
        return this.minObservedValue;
    }

    public double getAverage() {
        return this.mean;
    }

    public double getDeviation() {
        return this.deviation;
    }

    public double getFisher() {
        return this.fisher;
    }

    public double getTotal() {
        return this.total;
    }

    public long getTotalLong() {
        return this.totalLong;
    }

    public long getNumber() {
        return this.number;
    }

    public int getValue(int num) {
        return this.data[num];
    }
}

