/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitUtil {
    private BitUtil() {
    }

    public static final int log2(long n) {
        int b = 0;
        while (n != 0L) {
            ++b;
            n >>>= 1;
        }
        return b;
    }

    public static final long maxVal(int numbits) {
        return -1L << numbits ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static final long readLowerBitsByteAligned(long numbits, InputStream in) throws IOException {
        int bitsRead = 0;
        long value = 0L;
        while ((long)bitsRead < numbits) {
            long readByte = in.read();
            if (readByte == -1L) {
                throw new EOFException();
            }
            value |= readByte << bitsRead;
            bitsRead += 8;
        }
        return value;
    }

    public static final void writeLowerBitsByteAligned(long value, long numbits, OutputStream out) throws IOException {
        while (numbits > 0L) {
            out.write((int)(value & 0xFFL));
            value >>>= 8;
            numbits -= 8L;
        }
    }

    public static final int select1(long value, int rank) {
        int bitpos = 0;
        while (rank > 0 && value != 0L) {
            rank = (int)((long)rank - (value & 1L));
            ++bitpos;
            value >>>= 1;
        }
        return bitpos;
    }

    public static final int select0(long value, int rank) {
        int bitpos = 0;
        while (rank > 0) {
            rank = (int)((long)rank - ((value ^ 1L) & 1L));
            ++bitpos;
            value >>>= 1;
        }
        return bitpos;
    }
}

