/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.bitmap.Bitmap375;
import org.rdfhdt.hdt.compact.bitmap.BitmapFactory;
import org.rdfhdt.hdt.compact.sequence.Sequence;
import org.rdfhdt.hdt.compact.sequence.SequenceFactory;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64Map;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.triples.impl.BitmapTriples;
import org.rdfhdt.hdt.triples.impl.PredicateIndex;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.StopWatch;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.listener.IntermediateListener;
import org.rdfhdt.hdt.util.listener.ListenerUtil;

class PredicateIndexArray
implements PredicateIndex {
    BitmapTriples triples;
    Sequence array;
    Bitmap bitmap;

    public PredicateIndexArray(BitmapTriples triples) {
        this.triples = triples;
    }

    private final long calculatePos(int pred) {
        if (pred <= 1) {
            return 0L;
        }
        return this.bitmap.select1(pred - 1) + 1L;
    }

    @Override
    public long getNumOcurrences(int pred) {
        return this.bitmap.select1(pred) - this.bitmap.select1(pred - 1);
    }

    @Override
    public long getOccurrence(int pred, long occ) {
        return this.array.get(this.calculatePos(pred) + occ - 1L);
    }

    @Override
    public void load(InputStream input) throws IOException {
        this.bitmap = BitmapFactory.createBitmap(input);
        this.bitmap.load(input, null);
        this.array = SequenceFactory.createStream(input);
        this.array.load(input, null);
    }

    @Override
    public void save(OutputStream out) throws IOException {
        this.bitmap.save(out, null);
        this.array.save(out, null);
    }

    @Override
    public void generate(ProgressListener listener) {
        IntermediateListener iListener = new IntermediateListener(listener);
        StopWatch st = new StopWatch();
        SequenceLog64 predCount = new SequenceLog64(BitUtil.log2(this.triples.seqY.getNumberOfElements()));
        long maxCount = 0L;
        for (long i = 0L; i < this.triples.seqY.getNumberOfElements(); ++i) {
            long count;
            long val = this.triples.seqY.get(i);
            if (predCount.getNumberOfElements() < val) {
                predCount.resize(val);
            }
            maxCount = (count = predCount.get(val - 1L) + 1L) > maxCount ? count : maxCount;
            predCount.set(val - 1L, count);
            ListenerUtil.notifyCond(iListener, "Counting appearances of predicates", i, this.triples.seqY.getNumberOfElements(), 20000.0f);
        }
        predCount.aggresiveTrimToSize();
        Bitmap375 bitmap = new Bitmap375(this.triples.seqY.getNumberOfElements());
        long tempCountPred = 0L;
        for (long i = 0L; i < predCount.getNumberOfElements(); ++i) {
            bitmap.set((tempCountPred += predCount.get(i)) - 1L, true);
            ListenerUtil.notifyCond(iListener, "Creating Predicate bitmap", i, predCount.getNumberOfElements(), 100000.0f);
        }
        bitmap.set(this.triples.seqY.getNumberOfElements() - 1L, true);
        System.out.println("Predicate Bitmap in " + st.stopAndShow());
        st.reset();
        predCount = null;
        SequenceLog64 array = new SequenceLog64(BitUtil.log2(this.triples.seqY.getNumberOfElements()), this.triples.seqY.getNumberOfElements());
        array.resize(this.triples.seqY.getNumberOfElements());
        SequenceLog64 insertArray = new SequenceLog64(BitUtil.log2(this.triples.seqY.getNumberOfElements()), bitmap.countOnes());
        insertArray.resize(bitmap.countOnes());
        for (long i = 0L; i < this.triples.seqY.getNumberOfElements(); ++i) {
            long predicateValue = this.triples.seqY.get(i);
            long insertBase = predicateValue == 1L ? 0L : bitmap.select1(predicateValue - 1L) + 1L;
            long insertOffset = insertArray.get(predicateValue - 1L);
            insertArray.set(predicateValue - 1L, insertOffset + 1L);
            array.set(insertBase + insertOffset, i);
            ListenerUtil.notifyCond(iListener, "Generating predicate references", i, this.triples.seqY.getNumberOfElements(), 100000.0f);
        }
        this.array = array;
        this.bitmap = bitmap;
        System.out.println("Count predicates in " + st.stopAndShow());
    }

    @Override
    public void mapIndex(CountInputStream input, File f, ProgressListener listener) throws IOException {
        this.bitmap = BitmapFactory.createBitmap(input);
        this.bitmap.load(input, null);
        this.array = new SequenceLog64Map(input, f);
    }
}

