/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import org.rdfhdt.hdt.compact.bitmap.AdjacencyList;
import org.rdfhdt.hdt.compact.sequence.DeflateIntegerIterator;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.impl.BitmapTriples;
import org.rdfhdt.hdt.triples.impl.TripleOrderConvert;

public class BitmapTriplesIteratorYFOQ
implements IteratorTripleID {
    private BitmapTriples triples;
    private TripleID pattern;
    private TripleID returnTriple;
    private int patY;
    private AdjacencyList adjY;
    private AdjacencyList adjZ;
    private long posY;
    private long posZ;
    private long prevZ;
    private long nextZ;
    private long maxZ;
    private int x;
    private int y;
    private int z;
    private long numOccurrences;
    private long numOccurrence;
    DeflateIntegerIterator index;

    BitmapTriplesIteratorYFOQ(BitmapTriples triples, TripleID pattern) {
        this.triples = triples;
        this.pattern = new TripleID(pattern);
        this.returnTriple = new TripleID();
        TripleOrderConvert.swapComponentOrder(this.pattern, TripleComponentOrder.SPO, triples.order);
        this.patY = this.pattern.getPredicate();
        if (this.patY == 0) {
            throw new IllegalArgumentException("This structure is not meant to process this pattern");
        }
        this.adjY = new AdjacencyList(triples.seqY, triples.bitmapY);
        this.adjZ = new AdjacencyList(triples.seqZ, triples.bitmapZ);
        this.numOccurrences = triples.predicateIndex.getNumOcurrences(this.patY);
        this.maxZ = triples.adjZ.getNumberOfElements();
        this.goToStart();
    }

    private void updateOutput() {
        this.returnTriple.setAll(this.x, this.y, this.z);
        TripleOrderConvert.swapComponentOrder(this.returnTriple, this.triples.order, TripleComponentOrder.SPO);
    }

    @Override
    public boolean hasNext() {
        return this.posZ < this.maxZ && this.numOccurrence < this.numOccurrences || this.posZ <= this.nextZ;
    }

    @Override
    public TripleID next() {
        if (this.posZ > this.nextZ) {
            ++this.numOccurrence;
            this.posY = this.triples.predicateIndex.getOccurrence(this.patY, this.numOccurrence);
            this.posZ = this.prevZ = this.adjZ.find(this.posY);
            this.nextZ = this.adjZ.last(this.posY);
            this.x = (int)this.adjY.findListIndex(this.posY) + 1;
            this.y = (int)this.adjY.get(this.posY);
            this.z = (int)this.adjZ.get(this.posZ);
        } else {
            this.z = (int)this.adjZ.get(this.posZ);
        }
        ++this.posZ;
        this.updateOutput();
        return this.returnTriple;
    }

    @Override
    public boolean hasPrevious() {
        return this.numOccurrence > 1L || this.posZ >= this.prevZ;
    }

    @Override
    public TripleID previous() {
        if (this.posZ <= this.prevZ) {
            --this.numOccurrence;
            this.posY = this.triples.predicateIndex.getOccurrence(this.patY, this.numOccurrence);
            this.prevZ = this.adjZ.find(this.posY);
            this.posZ = this.nextZ = this.adjZ.last(this.posY);
            this.x = (int)this.adjY.findListIndex(this.posY) + 1;
            this.y = (int)this.adjY.get(this.posY);
            this.z = (int)this.adjZ.get(this.posZ);
        } else {
            this.z = (int)this.adjZ.get(this.posZ);
            --this.posZ;
        }
        this.updateOutput();
        return this.returnTriple;
    }

    @Override
    public void goToStart() {
        this.numOccurrence = 1L;
        this.posY = this.triples.predicateIndex.getOccurrence(this.patY, this.numOccurrence);
        this.posZ = this.prevZ = this.adjZ.find(this.posY);
        this.nextZ = this.adjZ.last(this.posY);
        this.x = (int)this.adjY.findListIndex(this.posY) + 1;
        this.y = (int)this.adjY.get(this.posY);
        this.z = (int)this.adjZ.get(this.posZ);
    }

    @Override
    public long estimatedNumResults() {
        return this.triples.predicateCount.get(this.patY - 1);
    }

    @Override
    public ResultEstimationType numResultEstimation() {
        return ResultEstimationType.UNKNOWN;
    }

    @Override
    public boolean canGoTo() {
        return false;
    }

    @Override
    public void goTo(long pos) {
        if (!this.canGoTo()) {
            throw new IllegalAccessError("Cannot goto on this bitmaptriples pattern");
        }
    }

    @Override
    public TripleComponentOrder getOrder() {
        return this.triples.order;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

