/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples;

import org.rdfhdt.hdt.hdt.HDTFactory;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.TriplesPrivate;
import org.rdfhdt.hdt.triples.impl.BitmapTriples;
import org.rdfhdt.hdt.triples.impl.TriplesList;

public class TriplesFactory {
    public static final String TEMP_TRIPLES_IMPL_LIST = "list";

    private TriplesFactory() {
    }

    public static TempTriples createTempTriples(HDTOptions spec) {
        String triplesImpl = spec.get("tempTriples.impl");
        if (triplesImpl == null || triplesImpl.equals("") || TEMP_TRIPLES_IMPL_LIST.equals(triplesImpl)) {
            return new TriplesList(spec);
        }
        return HDTFactory.getTempFactory().getTriples(spec);
    }

    public static TriplesPrivate createTriples(HDTOptions spec) {
        String type = spec.get("triples.format");
        if (type == null) {
            return new BitmapTriples(spec);
        }
        if ("<http://purl.org/HDT/hdt#triplesList>".equals(type)) {
            return new TriplesList(spec);
        }
        if ("<http://purl.org/HDT/hdt#triplesBitmap>".equals(type)) {
            return new BitmapTriples(spec);
        }
        return new BitmapTriples(spec);
    }

    public static TriplesPrivate createTriples(ControlInfo ci) {
        String format = ci.getFormat();
        if ("<http://purl.org/HDT/hdt#triplesList>".equals(format)) {
            return new TriplesList(new HDTSpecification());
        }
        if ("<http://purl.org/HDT/hdt#triplesBitmap>".equals(format)) {
            return new BitmapTriples();
        }
        throw new IllegalArgumentException("No implementation for Triples type: " + format);
    }
}

