/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples;

public final class TripleID
implements Comparable<TripleID> {
    private int subject;
    private int predicate;
    private int object;

    public TripleID() {
    }

    public TripleID(int subject, int predicate, int object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public TripleID(TripleID other) {
        this.subject = other.subject;
        this.predicate = other.predicate;
        this.object = other.object;
    }

    public int getSubject() {
        return this.subject;
    }

    public void setSubject(int subject) {
        this.subject = subject;
    }

    public int getObject() {
        return this.object;
    }

    public void setObject(int object) {
        this.object = object;
    }

    public int getPredicate() {
        return this.predicate;
    }

    public void setPredicate(int predicate) {
        this.predicate = predicate;
    }

    public void setAll(int subject, int predicate, int object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public void assign(TripleID replacement) {
        this.subject = replacement.getSubject();
        this.object = replacement.getObject();
        this.predicate = replacement.getPredicate();
    }

    public void clear() {
        this.object = 0;
        this.predicate = 0;
        this.subject = 0;
    }

    public String toString() {
        return Integer.toString(this.subject) + " " + this.predicate + " " + this.object;
    }

    public boolean equals(TripleID other) {
        return this.subject == other.subject && this.predicate == other.predicate && this.object == other.object;
    }

    @Override
    public int compareTo(TripleID other) {
        int result = this.subject - other.subject;
        if (result == 0) {
            result = this.predicate - other.predicate;
            if (result == 0) {
                return this.object - other.object;
            }
            return result;
        }
        return result;
    }

    public boolean match(TripleID pattern) {
        int subjectPattern = pattern.getSubject();
        int predicatePattern = pattern.getPredicate();
        int objectPattern = pattern.getObject();
        return !(subjectPattern != 0 && this.subject != subjectPattern || predicatePattern != 0 && this.predicate != predicatePattern || objectPattern != 0 && this.object != objectPattern);
    }

    public boolean isEmpty() {
        return this.subject == 0 && this.predicate == 0 && this.object == 0;
    }

    public boolean isValid() {
        return this.subject > 0 && this.predicate > 0 && this.object > 0;
    }

    public String getPatternString() {
        return "" + (this.subject == 0 ? (char)'?' : 'S') + (this.predicate == 0 ? (char)'?' : 'P') + (this.object == 0 ? (char)'?' : 'O');
    }

    public static int size() {
        return 24;
    }
}

