/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.triples.TripleString;

public class RDFParserRIOT
implements RDFParserCallback,
StreamRDF {
    private RDFParserCallback.RDFCallback callback;
    private TripleString triple = new TripleString();

    @Override
    public void doParse(String fileName, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        this.callback = callback;
        try {
            BufferedInputStream input = fileName.equals("-") ? new BufferedInputStream(System.in) : (fileName.endsWith(".gz") ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(fileName))) : new BufferedInputStream(new FileInputStream(fileName)));
            switch (notation) {
                case NTRIPLES: {
                    RDFDataMgr.parse((StreamRDF)this, input, Lang.NTRIPLES);
                    break;
                }
                case RDFXML: {
                    RDFDataMgr.parse((StreamRDF)this, input, baseUri, Lang.RDFXML);
                    break;
                }
                case TURTLE: {
                    RDFDataMgr.parse((StreamRDF)this, input, baseUri, Lang.TURTLE);
                    break;
                }
                default: {
                    throw new NotImplementedException("Parser not found for format " + (Object)((Object)notation));
                }
            }
        }
        catch (FileNotFoundException e2) {
            throw new ParserException();
        }
        catch (Exception e3) {
            throw new ParserException();
        }
    }

    @Override
    public void doParse(InputStream input, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        this.callback = callback;
        try {
            switch (notation) {
                case NTRIPLES: {
                    RDFDataMgr.parse((StreamRDF)this, input, Lang.NTRIPLES);
                    break;
                }
                case RDFXML: {
                    RDFDataMgr.parse((StreamRDF)this, input, baseUri, Lang.RDFXML);
                    break;
                }
                case TURTLE: 
                case N3: {
                    RDFDataMgr.parse((StreamRDF)this, input, baseUri, Lang.TURTLE);
                    break;
                }
                default: {
                    throw new NotImplementedException("Parser not found for format " + (Object)((Object)notation));
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new ParserException();
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void triple(Triple parsedTriple) {
        this.triple.setAll(parsedTriple.getSubject().toString(), parsedTriple.getPredicate().toString(), parsedTriple.getObject().toString());
        this.callback.processTriple(this.triple, 0L);
    }

    @Override
    public void quad(Quad quad) {
        this.triple.setAll(quad.getSubject().toString(), quad.getPredicate().toString(), quad.getObject().toString());
        this.callback.processTriple(this.triple, 0L);
    }

    @Override
    public void base(String base) {
    }

    @Override
    public void prefix(String prefix, String iri2) {
    }

    @Override
    public void finish() {
    }
}

