/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf;

import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.parsers.RDFParserRAR;
import org.rdfhdt.hdt.rdf.parsers.RDFParserRIOT;
import org.rdfhdt.hdt.rdf.parsers.RDFParserSimple;
import org.rdfhdt.hdt.rdf.parsers.RDFParserTar;

public class RDFParserFactory {
    private RDFParserFactory() {
    }

    public static RDFParserCallback getParserCallback(RDFNotation notation) {
        if (notation == RDFNotation.NTRIPLES) {
            return new RDFParserSimple();
        }
        if (notation == RDFNotation.NTRIPLES || notation == RDFNotation.TURTLE || notation == RDFNotation.N3 || notation == RDFNotation.RDFXML) {
            return new RDFParserRIOT();
        }
        if (notation == RDFNotation.TAR) {
            return new RDFParserTar();
        }
        if (notation == RDFNotation.RAR) {
            return new RDFParserRAR();
        }
        throw new NotImplementedException("Parser not found for notation: " + (Object)((Object)notation));
    }
}

