/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Comparator;
import java.util.Iterator;
import org.rdfhdt.hdt.exceptions.NotImplementedException;

public class MergedIterator<T>
implements Iterator<T> {
    private Iterator<T> left;
    private Iterator<T> right;
    private T currentLeft;
    private T currentRight;
    private Comparator<T> comparator;
    private Annotator<T> annotator;

    public MergedIterator(Iterator<T> left, Iterator<T> right, Comparator<T> comparator) {
        this(left, right, comparator, null);
    }

    public MergedIterator(Iterator<T> left, Iterator<T> right, Comparator<T> comparator, Annotator<T> annotator) {
        this.left = left;
        this.right = right;
        this.comparator = comparator;
        this.annotator = annotator;
        this.advanceLeft();
        this.advanceRight();
    }

    @Override
    public boolean hasNext() {
        return this.currentLeft != null || this.currentRight != null;
    }

    private T advanceLeft() {
        T tmp = this.currentLeft;
        this.currentLeft = this.left.hasNext() ? this.left.next() : null;
        return tmp;
    }

    private T advanceRight() {
        T tmp = this.currentRight;
        this.currentRight = this.right.hasNext() ? this.right.next() : null;
        return tmp;
    }

    @Override
    public T next() {
        if (this.currentLeft != null && this.currentRight == null) {
            return this.advanceLeft();
        }
        if (this.currentLeft == null && this.currentRight != null) {
            return this.advanceRight();
        }
        int cmp = this.comparator.compare(this.currentLeft, this.currentRight);
        if (cmp == 0) {
            if (this.annotator != null) {
                this.annotator.annotate(this.currentLeft, Pos.BOTH);
            }
            this.advanceRight();
            return this.advanceLeft();
        }
        if (cmp > 0) {
            if (this.annotator != null) {
                this.annotator.annotate(this.currentLeft, Pos.LEFT);
            }
            return this.advanceLeft();
        }
        if (this.annotator != null) {
            this.annotator.annotate(this.currentLeft, Pos.RIGHT);
        }
        return this.advanceRight();
    }

    @Override
    public void remove() {
        throw new NotImplementedException();
    }

    public static interface Annotator<T> {
        public void annotate(T var1, Pos var2);
    }

    public static enum Pos {
        LEFT,
        RIGHT,
        BOTH;

    }
}

