/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl;

import java.io.File;
import java.io.IOException;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.TempHDT;
import org.rdfhdt.hdt.hdt.TempHDTImporter;
import org.rdfhdt.hdt.hdt.impl.ModeOfLoading;
import org.rdfhdt.hdt.hdt.impl.TempHDTImpl;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.RDFParserFactory;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.RDFInfo;
import org.rdfhdt.hdt.util.listener.ListenerUtil;

public class TempHDTImporterTwoPass
implements TempHDTImporter {
    @Override
    public TempHDT loadFromRDF(HDTOptions specs, String filename, String baseUri, RDFNotation notation, ProgressListener listener) throws IOException, ParserException {
        RDFParserCallback parser = RDFParserFactory.getParserCallback(notation);
        if (!RDFInfo.triplesSet(specs) && "list".equals(specs.get("tempTriples.impl"))) {
            RDFInfo.setTriples(RDFInfo.countLines(filename, parser, notation), specs);
        }
        RDFInfo.setSizeInBytes(new File(filename).length(), specs);
        TempHDTImpl modHDT = new TempHDTImpl(specs, baseUri, ModeOfLoading.TWO_PASS);
        TempDictionary dictionary = modHDT.getDictionary();
        TempTriples triples = modHDT.getTriples();
        dictionary.startProcessing();
        parser.doParse(filename, baseUri, notation, (RDFParserCallback.RDFCallback)new DictionaryAppender(dictionary, listener));
        dictionary.endProcessing();
        modHDT.reorganizeDictionary(listener);
        parser.doParse(filename, baseUri, notation, (RDFParserCallback.RDFCallback)new TripleAppender2(dictionary, triples, listener));
        modHDT.reorganizeTriples(listener);
        return modHDT;
    }

    class TripleAppender2
    implements RDFParserCallback.RDFCallback {
        TempDictionary dict;
        TempTriples triples;
        ProgressListener listener;
        long count;

        public TripleAppender2(TempDictionary dict, TempTriples triples, ProgressListener listener) {
            this.dict = dict;
            this.triples = triples;
            this.listener = listener;
        }

        @Override
        public void processTriple(TripleString triple, long pos) {
            this.triples.insert(this.dict.stringToId(triple.getSubject(), TripleComponentRole.SUBJECT), this.dict.stringToId(triple.getPredicate(), TripleComponentRole.PREDICATE), this.dict.stringToId(triple.getObject(), TripleComponentRole.OBJECT));
            ++this.count;
            ListenerUtil.notifyCond(this.listener, "Generating triples " + this.count + " triples processed.", this.count, 0.0f, 100.0f);
        }
    }

    class DictionaryAppender
    implements RDFParserCallback.RDFCallback {
        TempDictionary dict;
        ProgressListener listener;
        long count;

        DictionaryAppender(TempDictionary dict, ProgressListener listener) {
            this.dict = dict;
            this.listener = listener;
        }

        @Override
        public void processTriple(TripleString triple, long pos) {
            this.dict.insert(triple.getSubject(), TripleComponentRole.SUBJECT);
            this.dict.insert(triple.getPredicate(), TripleComponentRole.PREDICATE);
            this.dict.insert(triple.getObject(), TripleComponentRole.OBJECT);
            ++this.count;
            ListenerUtil.notifyCond(this.listener, "Generating dictionary " + this.count + " triples processed.", this.count, 0.0f, 100.0f);
        }

        public long getCount() {
            return this.count;
        }
    }
}

