/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.dictionary.DictionaryFactory;
import org.rdfhdt.hdt.dictionary.DictionaryPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.hdt.HDTPrivate;
import org.rdfhdt.hdt.hdt.TempHDT;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.header.HeaderFactory;
import org.rdfhdt.hdt.header.HeaderPrivate;
import org.rdfhdt.hdt.iterator.DictionaryTranslateIterator;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.triples.Triples;
import org.rdfhdt.hdt.triples.TriplesFactory;
import org.rdfhdt.hdt.triples.TriplesPrivate;
import org.rdfhdt.hdt.util.StringUtil;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.IntermediateListener;

public class HDTImpl
implements HDTPrivate {
    private HDTOptions spec;
    protected HeaderPrivate header;
    protected DictionaryPrivate dictionary;
    protected TriplesPrivate triples;
    private String hdtFileName;
    private String baseUri;
    private boolean isMapped;

    private void createComponents() {
        this.header = HeaderFactory.createHeader(this.spec);
        this.dictionary = DictionaryFactory.createDictionary(this.spec);
        this.triples = TriplesFactory.createTriples(this.spec);
    }

    @Override
    public void populateHeaderStructure(String baseUri) {
        this.header.insert((CharSequence)baseUri, (CharSequence)"<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>", "<http://purl.org/HDT/hdt#Dataset>");
        this.header.insert((CharSequence)baseUri, (CharSequence)"<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>", "<http://rdfs.org/ns/void#Dataset>");
        this.header.insert((CharSequence)baseUri, (CharSequence)"<http://rdfs.org/ns/void#triples>", this.triples.getNumberOfElements());
        this.header.insert((CharSequence)baseUri, (CharSequence)"<http://rdfs.org/ns/void#properties>", this.dictionary.getNpredicates());
        this.header.insert((CharSequence)baseUri, (CharSequence)"<http://rdfs.org/ns/void#distinctSubjects>", this.dictionary.getNsubjects());
        this.header.insert((CharSequence)baseUri, (CharSequence)"<http://rdfs.org/ns/void#distinctObjects>", this.dictionary.getNobjects());
        String formatNode = "_:format";
        String dictNode = "_:dictionary";
        String triplesNode = "_:triples";
        String statisticsNode = "_:statistics";
        String publicationInfoNode = "_:publicationInformation";
        this.header.insert((CharSequence)baseUri, (CharSequence)"<http://purl.org/HDT/hdt#formatInformation>", formatNode);
        this.header.insert((CharSequence)formatNode, (CharSequence)"<http://purl.org/HDT/hdt#dictionary>", dictNode);
        this.header.insert((CharSequence)formatNode, (CharSequence)"<http://purl.org/HDT/hdt#triples>", triplesNode);
        this.header.insert((CharSequence)baseUri, (CharSequence)"<http://purl.org/HDT/hdt#statisticalInformation>", statisticsNode);
        this.header.insert((CharSequence)baseUri, (CharSequence)"<http://purl.org/HDT/hdt#publicationInformation>", publicationInfoNode);
        this.dictionary.populateHeader(this.header, dictNode);
        this.triples.populateHeader(this.header, triplesNode);
        this.header.insert((CharSequence)statisticsNode, (CharSequence)"<http://purl.org/HDT/hdt#hdtSize>", this.getDictionary().size() + this.getTriples().size());
        this.header.insert((CharSequence)publicationInfoNode, (CharSequence)"<http://purl.org/dc/terms/issued>", StringUtil.formatDate(new Date()));
    }

    public HDTImpl(HDTOptions spec) {
        this.spec = spec;
        this.createComponents();
    }

    @Override
    public void loadFromHDT(InputStream input, ProgressListener listener) throws IOException {
        ControlInformation ci = new ControlInformation();
        IntermediateListener iListener = new IntermediateListener(listener);
        ci.clear();
        ci.load(input);
        String hdtFormat = ci.getFormat();
        if (!hdtFormat.equals("<http://purl.org/HDT/hdt#HDTv1>")) {
            throw new IllegalFormatException("This software cannot open this version of HDT File");
        }
        ci.clear();
        ci.load(input);
        iListener.setRange(0.0f, 5.0f);
        this.header = HeaderFactory.createHeader(ci);
        this.header.load(input, ci, iListener);
        try {
            IteratorTripleString it = this.header.search("", "<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>", "<http://purl.org/HDT/hdt#Dataset>");
            if (it.hasNext()) {
                this.baseUri = ((TripleString)it.next()).getSubject().toString();
            }
        }
        catch (NotFoundException e2) {
            e2.printStackTrace();
        }
        ci.clear();
        ci.load(input);
        iListener.setRange(5.0f, 60.0f);
        this.dictionary = DictionaryFactory.createDictionary(ci);
        this.dictionary.load(input, ci, iListener);
        ci.clear();
        ci.load(input);
        iListener.setRange(60.0f, 100.0f);
        this.triples = TriplesFactory.createTriples(ci);
        this.triples.load(input, ci, iListener);
    }

    @Override
    public void loadFromHDT(String hdtFileName, ProgressListener listener) throws IOException {
        InputStream in = hdtFileName.endsWith(".gz") ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(hdtFileName))) : new CountInputStream(new BufferedInputStream(new FileInputStream(hdtFileName)));
        this.loadFromHDT(in, listener);
        in.close();
        this.hdtFileName = hdtFileName;
    }

    @Override
    public void mapFromHDT(File f, long offset, ProgressListener listener) throws IOException {
        this.hdtFileName = f.toString();
        this.isMapped = true;
        if (this.hdtFileName.endsWith(".gz")) {
            File old = f;
            this.hdtFileName = this.hdtFileName.substring(0, this.hdtFileName.length() - 3);
            f = new File(this.hdtFileName);
            if (!f.exists()) {
                System.err.println("We cannot map a gzipped HDT, decompressing into " + this.hdtFileName + " first.");
                IOUtil.decompressGzip(old, f);
                System.err.println("Gzipped HDT successfully decompressed. You might want to delete " + old.getAbsolutePath() + " to save disk space.");
            } else {
                System.err.println("We cannot map a gzipped HDT, using " + this.hdtFileName + " instead.");
            }
        }
        CountInputStream input = new CountInputStream(new BufferedInputStream(new FileInputStream(this.hdtFileName)));
        ControlInformation ci = new ControlInformation();
        IntermediateListener iListener = new IntermediateListener(listener);
        ci.clear();
        ci.load(input);
        String hdtFormat = ci.getFormat();
        if (!hdtFormat.equals("<http://purl.org/HDT/hdt#HDTv1>")) {
            throw new IllegalFormatException("This software cannot open this version of HDT File");
        }
        ci.clear();
        ci.load(input);
        iListener.setRange(0.0f, 5.0f);
        this.header = HeaderFactory.createHeader(ci);
        this.header.load(input, ci, iListener);
        try {
            IteratorTripleString it = this.header.search("", "<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>", "<http://purl.org/HDT/hdt#Dataset>");
            if (it.hasNext()) {
                this.baseUri = ((TripleString)it.next()).getSubject().toString();
            }
        }
        catch (NotFoundException e2) {
            e2.printStackTrace();
        }
        ci.clear();
        input.mark(1024);
        ci.load(input);
        input.reset();
        iListener.setRange(5.0f, 60.0f);
        this.dictionary = DictionaryFactory.createDictionary(ci);
        this.dictionary.mapFromFile(input, f, iListener);
        ci.clear();
        input.mark(1024);
        ci.load(input);
        input.reset();
        iListener.setRange(60.0f, 100.0f);
        this.triples = TriplesFactory.createTriples(ci);
        this.triples.mapFromFile(input, f, iListener);
        input.close();
    }

    @Override
    public void saveToHDT(OutputStream output, ProgressListener listener) throws IOException {
        ControlInformation ci = new ControlInformation();
        IntermediateListener iListener = new IntermediateListener(listener);
        ci.clear();
        ci.setType(ControlInfo.Type.GLOBAL);
        ci.setFormat("<http://purl.org/HDT/hdt#HDTv1>");
        ci.save(output);
        ci.clear();
        ci.setType(ControlInfo.Type.HEADER);
        this.header.save(output, ci, iListener);
        ci.clear();
        ci.setType(ControlInfo.Type.DICTIONARY);
        this.dictionary.save(output, ci, iListener);
        ci.clear();
        ci.setType(ControlInfo.Type.TRIPLES);
        this.triples.save(output, ci, iListener);
    }

    @Override
    public void saveToHDT(String fileName, ProgressListener listener) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileName));
        this.saveToHDT(out, listener);
        ((OutputStream)out).close();
        this.hdtFileName = fileName;
    }

    @Override
    public IteratorTripleString search(CharSequence subject, CharSequence predicate, CharSequence object) throws NotFoundException {
        TripleID triple = new TripleID(this.dictionary.stringToId(subject, TripleComponentRole.SUBJECT), this.dictionary.stringToId(predicate, TripleComponentRole.PREDICATE), this.dictionary.stringToId(object, TripleComponentRole.OBJECT));
        if (triple.getSubject() == -1 || triple.getPredicate() == -1 || triple.getObject() == -1) {
            throw new NotFoundException("String not found in dictionary");
        }
        return new DictionaryTranslateIterator(this.triples.search(triple), this.dictionary, subject, predicate, object);
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public Dictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public Triples getTriples() {
        return this.triples;
    }

    @Override
    public long size() {
        return this.dictionary.size() + this.triples.size();
    }

    public void loadFromModifiableHDT(TempHDT modHdt, ProgressListener listener) {
        modHdt.reorganizeDictionary(listener);
        modHdt.reorganizeTriples(listener);
        TempTriples modifiableTriples = modHdt.getTriples();
        TempDictionary modifiableDictionary = modHdt.getDictionary();
        if (this.triples.getClass().equals(modifiableTriples.getClass())) {
            this.triples = modifiableTriples;
        } else {
            this.triples.load(modifiableTriples, listener);
        }
        if (this.dictionary.getClass().equals(modifiableDictionary.getClass())) {
            this.dictionary = (DictionaryPrivate)((Object)modifiableDictionary);
        } else {
            this.dictionary.load(modifiableDictionary, listener);
        }
        this.baseUri = modHdt.getBaseURI();
    }

    @Override
    public void loadOrCreateIndex(ProgressListener listener) {
        ControlInformation ci = new ControlInformation();
        String indexName = this.hdtFileName + ".index";
        indexName = indexName.replaceAll("\\.hdt\\.gz", "hdt");
        try {
            CountInputStream in = new CountInputStream(new BufferedInputStream(new FileInputStream(indexName)));
            ci.load(in);
            if (this.isMapped) {
                this.triples.mapIndex(in, new File(indexName), ci, listener);
            } else {
                this.triples.loadIndex(in, ci, listener);
            }
            in.close();
        }
        catch (Exception e2) {
            System.out.println("Could not read .hdt.index, Generating a new one.");
            this.triples.generateIndex(listener);
            try {
                FileOutputStream out = new FileOutputStream(indexName);
                ci.clear();
                this.triples.saveIndex(out, ci, listener);
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getBaseURI() {
        return this.baseUri;
    }

    protected void setTriples(TriplesPrivate triples) {
        this.triples = triples;
    }

    @Override
    public void close() throws IOException {
        this.dictionary.close();
        this.triples.close();
    }
}

