/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.Sequence;
import org.rdfhdt.hdt.compact.sequence.SequenceFactory;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.exceptions.CRCException;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCInputStream;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.string.ByteStringUtil;
import org.rdfhdt.hdt.util.string.CompactString;
import org.rdfhdt.hdt.util.string.ReplazableString;

public class PFCDictionarySectionMap
implements DictionarySectionPrivate,
Closeable {
    public static final int TYPE_INDEX = 2;
    public static final int DEFAULT_BLOCK_SIZE = 16;
    private static final int BLOCKS_PER_BYTEBUFFER = 50000;
    protected FileChannel ch;
    protected ByteBuffer[] buffers;
    long[] posFirst;
    protected int blocksize;
    protected int numstrings;
    protected Sequence blocks;
    protected long dataSize;
    private File f;
    private long startOffset;
    private long endOffset;

    public PFCDictionarySectionMap(CountInputStream input, File f) throws IOException {
        this.f = f;
        this.startOffset = input.getTotalBytes();
        CRCInputStream crcin = new CRCInputStream(input, new CRC8());
        int type = crcin.read();
        if (type != 2) {
            throw new IllegalFormatException("Trying to read a DictionarySectionPFC from data that is not of the suitable type");
        }
        this.numstrings = (int)VByte.decode(crcin);
        this.dataSize = VByte.decode(crcin);
        this.blocksize = (int)VByte.decode(crcin);
        if (!crcin.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading Dictionary Section Plain Front Coding Header.");
        }
        this.blocks = SequenceFactory.createStream(input, f);
        long base = input.getTotalBytes();
        IOUtil.skip(crcin, this.dataSize + 4L);
        this.endOffset = input.getTotalBytes();
        this.ch = new FileInputStream(f).getChannel();
        int block = 0;
        int buffer = 0;
        long numBlocks = this.blocks.getNumberOfElements();
        long bytePos = 0L;
        long numBuffers = 1L + numBlocks / 50000L;
        this.buffers = new ByteBuffer[(int)numBuffers];
        this.posFirst = new long[(int)numBuffers];
        while ((long)block < numBlocks - 1L) {
            int nextBlock = (int)Math.min(numBlocks - 1L, (long)(block + 50000));
            long nextBytePos = this.blocks.get(nextBlock);
            this.buffers[buffer] = this.ch.map(FileChannel.MapMode.READ_ONLY, base + bytePos, nextBytePos - bytePos);
            this.buffers[buffer].order(ByteOrder.LITTLE_ENDIAN);
            this.posFirst[buffer] = bytePos;
            bytePos = nextBytePos;
            block += 50000;
            ++buffer;
        }
    }

    protected int locateBlock(CharSequence str2) {
        int high;
        if (this.blocks.getNumberOfElements() == 0L) {
            return -1;
        }
        int low = 0;
        int max2 = high = (int)this.blocks.getNumberOfElements() - 1;
        while (low <= high) {
            int cmp;
            int mid = low + (high - low) / 2;
            if (mid == max2) {
                cmp = -1;
            } else {
                ByteBuffer buffer = this.buffers[mid / 50000];
                cmp = ByteStringUtil.strcmp(str2, buffer, (int)(this.blocks.get(mid) - this.posFirst[mid / 50000]));
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public int locate(CharSequence str2) {
        int idblock;
        if (this.buffers == null || this.blocks == null) {
            return 0;
        }
        int blocknum = this.locateBlock(str2);
        if (blocknum >= 0) {
            return blocknum * this.blocksize + 1;
        }
        if ((blocknum = -blocknum - 2) >= 0 && (idblock = this.locateInBlock(blocknum, str2)) != 0) {
            return blocknum * this.blocksize + idblock + 1;
        }
        return 0;
    }

    public int locateInBlock(int block, CharSequence str2) {
        if ((long)block >= this.blocks.getNumberOfElements()) {
            return 0;
        }
        ReplazableString tempString = new ReplazableString();
        int idInBlock = 0;
        int cshared = 0;
        ByteBuffer buffer = this.buffers[block / 50000].duplicate();
        buffer.position((int)(this.blocks.get(block) - this.posFirst[block / 50000]));
        try {
            if (!buffer.hasRemaining()) {
                return 0;
            }
            tempString.replace(buffer, 0);
            ++idInBlock;
            while (idInBlock < this.blocksize && buffer.hasRemaining()) {
                long delta = VByte.decode(buffer);
                tempString.replace(buffer, (int)delta);
                if (delta >= (long)cshared) {
                    if ((cshared += ByteStringUtil.longestCommonPrefix(tempString, str2, cshared)) == str2.length() && tempString.length() == str2.length()) {
                        return idInBlock;
                    }
                } else {
                    return 0;
                }
                ++idInBlock;
            }
            return 0;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    @Override
    public CharSequence extract(int id) {
        if (this.buffers == null || this.blocks == null) {
            return null;
        }
        if (id < 1 || id > this.numstrings) {
            return null;
        }
        int block = (id - 1) / this.blocksize;
        ByteBuffer buffer = this.buffers[block / 50000].duplicate();
        buffer.position((int)(this.blocks.get(block) - this.posFirst[block / 50000]));
        try {
            ReplazableString tempString = new ReplazableString();
            tempString.replace(buffer, 0);
            int stringid = (id - 1) % this.blocksize;
            for (int i = 0; i < stringid; ++i) {
                long delta = VByte.decode(buffer);
                tempString.replace(buffer, (int)delta);
            }
            return new CompactString(tempString).getDelayed();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    @Override
    public long size() {
        return this.dataSize + this.blocks.size();
    }

    @Override
    public int getNumberOfElements() {
        return this.numstrings;
    }

    public Iterator<CharSequence> getSortedEntries() {
        return new Iterator<CharSequence>(){
            int id;
            ReplazableString tempString = new ReplazableString();
            int bytebufferIndex;
            ByteBuffer buffer;
            {
                this.buffer = PFCDictionarySectionMap.this.buffers[0].duplicate();
            }

            @Override
            public boolean hasNext() {
                return this.id < PFCDictionarySectionMap.this.getNumberOfElements();
            }

            @Override
            public CharSequence next() {
                if (!this.buffer.hasRemaining()) {
                    this.buffer = PFCDictionarySectionMap.this.buffers[++this.bytebufferIndex].duplicate();
                    this.buffer.rewind();
                }
                try {
                    if (this.id % PFCDictionarySectionMap.this.blocksize == 0) {
                        this.tempString.replace(this.buffer, 0);
                    } else {
                        long delta = VByte.decode(this.buffer);
                        this.tempString.replace(this.buffer, (int)delta);
                    }
                    ++this.id;
                    return new CompactString(this.tempString).getDelayed();
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }

    @Override
    public void load(TempDictionarySection other, ProgressListener listener) {
        throw new NotImplementedException();
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.f));
        IOUtil.skip(in, this.startOffset);
        IOUtil.copyStream(in, output, this.endOffset - this.startOffset);
        ((InputStream)in).close();
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        throw new NotImplementedException();
    }
}

