/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.listener.ProgressListener;

public class DictionarySectionCacheAll
implements DictionarySectionPrivate {
    final int CACHE_ENTRIES = 128;
    private DictionarySectionPrivate child;
    private boolean preload;
    Map<CharSequence, Integer> cacheString;
    CharSequence[] cacheID;

    public DictionarySectionCacheAll(DictionarySectionPrivate child, boolean preload) {
        this.child = child;
        this.preload = preload;
        this.cacheString = new HashMap<CharSequence, Integer>(child.getNumberOfElements() * 2);
        this.cacheID = new CharSequence[child.getNumberOfElements()];
        if (preload) {
            Iterator<? extends CharSequence> it = child.getSortedEntries();
            int pos = 0;
            while (it.hasNext()) {
                this.cacheID[pos] = it.next();
                this.cacheString.put(this.cacheID[pos], pos);
                ++pos;
            }
        }
    }

    @Override
    public int locate(CharSequence s) {
        Integer o = this.cacheString.get(s);
        if (o == null) {
            o = this.child.locate(s);
            this.cacheString.put(s, o);
        }
        return o;
    }

    @Override
    public final CharSequence extract(int pos) {
        if (this.preload) {
            return this.cacheID[pos - 1];
        }
        if (pos == 0) {
            return null;
        }
        CharSequence o = this.cacheID[pos - 1];
        if (o == null) {
            this.cacheID[pos - 1] = o = this.child.extract(pos);
        }
        return o;
    }

    @Override
    public long size() {
        return this.child.size();
    }

    @Override
    public int getNumberOfElements() {
        return this.child.getNumberOfElements();
    }

    @Override
    public Iterator<? extends CharSequence> getSortedEntries() {
        return this.child.getSortedEntries();
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        this.child.save(output, listener);
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        this.child.load(input, listener);
    }

    @Override
    public void load(TempDictionarySection other, ProgressListener listener) {
        this.child.load(other, listener);
    }

    @Override
    public void close() throws IOException {
        this.cacheString = null;
        this.cacheID = null;
        this.child.close();
    }
}

