/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.util.Iterator;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.enums.DictionarySectionRole;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.TempTriples;

public abstract class BaseTempDictionary
implements TempDictionary {
    HDTOptions spec;
    protected boolean isOrganized;
    protected TempDictionarySection subjects;
    protected TempDictionarySection predicates;
    protected TempDictionarySection objects;
    protected TempDictionarySection shared;

    public BaseTempDictionary(HDTOptions spec) {
        this.spec = spec;
    }

    @Override
    public int insert(CharSequence str2, TripleComponentRole position) {
        switch (position) {
            case SUBJECT: {
                this.isOrganized = false;
                return this.subjects.add(str2);
            }
            case PREDICATE: {
                this.isOrganized = false;
                return this.predicates.add(str2);
            }
            case OBJECT: {
                this.isOrganized = false;
                return this.objects.add(str2);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void reorganize() {
        Iterator<? extends CharSequence> itSubj = this.subjects.getEntries();
        while (itSubj.hasNext()) {
            CharSequence str2 = itSubj.next();
            if (str2.length() <= 0 || str2.charAt(0) == '\"' || this.objects.locate(str2) == 0) continue;
            this.shared.add(str2);
        }
        Iterator<? extends CharSequence> itShared = this.shared.getEntries();
        while (itShared.hasNext()) {
            CharSequence sharedStr = itShared.next();
            this.subjects.remove(sharedStr);
            this.objects.remove(sharedStr);
        }
        this.shared.sort();
        this.subjects.sort();
        this.objects.sort();
        this.predicates.sort();
        this.isOrganized = true;
    }

    @Override
    public void reorganize(TempTriples triples) {
        throw new NotImplementedException();
    }

    @Override
    public boolean isOrganized() {
        return this.isOrganized;
    }

    @Override
    public void clear() {
        this.subjects.clear();
        this.predicates.clear();
        this.shared.clear();
        this.objects.clear();
    }

    @Override
    public TempDictionarySection getSubjects() {
        return this.subjects;
    }

    @Override
    public TempDictionarySection getPredicates() {
        return this.predicates;
    }

    @Override
    public TempDictionarySection getObjects() {
        return this.objects;
    }

    @Override
    public TempDictionarySection getShared() {
        return this.shared;
    }

    protected int getGlobalId(int id, DictionarySectionRole position) {
        switch (position) {
            case SUBJECT: 
            case OBJECT: {
                return this.shared.getNumberOfElements() + id;
            }
            case PREDICATE: 
            case SHARED: {
                return id;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int stringToId(CharSequence str2, TripleComponentRole position) {
        if (str2 == null || str2.length() == 0) {
            return 0;
        }
        int ret = 0;
        switch (position) {
            case SUBJECT: {
                ret = this.shared.locate(str2);
                if (ret != 0) {
                    return this.getGlobalId(ret, DictionarySectionRole.SHARED);
                }
                ret = this.subjects.locate(str2);
                if (ret != 0) {
                    return this.getGlobalId(ret, DictionarySectionRole.SUBJECT);
                }
                return -1;
            }
            case PREDICATE: {
                ret = this.predicates.locate(str2);
                if (ret != 0) {
                    return this.getGlobalId(ret, DictionarySectionRole.PREDICATE);
                }
                return -1;
            }
            case OBJECT: {
                ret = this.shared.locate(str2);
                if (ret != 0) {
                    return this.getGlobalId(ret, DictionarySectionRole.SHARED);
                }
                ret = this.objects.locate(str2);
                if (ret != 0) {
                    return this.getGlobalId(ret, DictionarySectionRole.OBJECT);
                }
                return -1;
            }
        }
        throw new IllegalArgumentException();
    }
}

