/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import org.rdfhdt.hdt.dictionary.DictionaryPrivate;
import org.rdfhdt.hdt.dictionary.DictionarySection;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.enums.DictionarySectionRole;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.util.string.CompactString;

public abstract class BaseDictionary
implements DictionaryPrivate {
    protected HDTOptions spec;
    protected DictionarySectionPrivate subjects;
    protected DictionarySectionPrivate predicates;
    protected DictionarySectionPrivate objects;
    protected DictionarySectionPrivate shared;

    public BaseDictionary(HDTOptions spec) {
        this.spec = spec;
    }

    protected int getGlobalId(int id, DictionarySectionRole position) {
        switch (position) {
            case SUBJECT: 
            case OBJECT: {
                return this.shared.getNumberOfElements() + id;
            }
            case PREDICATE: 
            case SHARED: {
                return id;
            }
        }
        throw new IllegalArgumentException();
    }

    protected int getLocalId(int id, TripleComponentRole position) {
        switch (position) {
            case SUBJECT: 
            case OBJECT: {
                if (id <= this.shared.getNumberOfElements()) {
                    return id;
                }
                return id - this.shared.getNumberOfElements();
            }
            case PREDICATE: {
                return id;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int stringToId(CharSequence str2, TripleComponentRole position) {
        if (str2 == null || str2.length() == 0) {
            return 0;
        }
        if (str2 instanceof String) {
            str2 = new CompactString(str2);
        }
        int ret = 0;
        switch (position) {
            case SUBJECT: {
                ret = this.shared.locate(str2);
                if (ret != 0) {
                    return this.getGlobalId(ret, DictionarySectionRole.SHARED);
                }
                ret = this.subjects.locate(str2);
                if (ret != 0) {
                    return this.getGlobalId(ret, DictionarySectionRole.SUBJECT);
                }
                return -1;
            }
            case PREDICATE: {
                ret = this.predicates.locate(str2);
                if (ret != 0) {
                    return this.getGlobalId(ret, DictionarySectionRole.PREDICATE);
                }
                return -1;
            }
            case OBJECT: {
                if (str2.charAt(0) != '\"' && (ret = this.shared.locate(str2)) != 0) {
                    return this.getGlobalId(ret, DictionarySectionRole.SHARED);
                }
                ret = this.objects.locate(str2);
                if (ret != 0) {
                    return this.getGlobalId(ret, DictionarySectionRole.OBJECT);
                }
                return -1;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long getNumberOfElements() {
        return this.subjects.getNumberOfElements() + this.predicates.getNumberOfElements() + this.objects.getNumberOfElements() + this.shared.getNumberOfElements();
    }

    @Override
    public long size() {
        return this.subjects.size() + this.predicates.size() + this.objects.size() + this.shared.size();
    }

    @Override
    public long getNsubjects() {
        return this.subjects.getNumberOfElements() + this.shared.getNumberOfElements();
    }

    @Override
    public long getNpredicates() {
        return this.predicates.getNumberOfElements();
    }

    @Override
    public long getNobjects() {
        return this.objects.getNumberOfElements() + this.shared.getNumberOfElements();
    }

    @Override
    public long getNshared() {
        return this.shared.getNumberOfElements();
    }

    @Override
    public DictionarySection getSubjects() {
        return this.subjects;
    }

    @Override
    public DictionarySection getPredicates() {
        return this.predicates;
    }

    @Override
    public DictionarySection getObjects() {
        return this.objects;
    }

    @Override
    public DictionarySection getShared() {
        return this.shared;
    }

    private DictionarySectionPrivate getSection(int id, TripleComponentRole role) {
        switch (role) {
            case SUBJECT: {
                if (id <= this.shared.getNumberOfElements()) {
                    return this.shared;
                }
                return this.subjects;
            }
            case PREDICATE: {
                return this.predicates;
            }
            case OBJECT: {
                if (id <= this.shared.getNumberOfElements()) {
                    return this.shared;
                }
                return this.objects;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public CharSequence idToString(int id, TripleComponentRole role) {
        DictionarySectionPrivate section = this.getSection(id, role);
        int localId = this.getLocalId(id, role);
        return section.extract(localId);
    }
}

