/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.sequence;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.DynamicSequence;
import org.rdfhdt.hdt.exceptions.CRCException;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCInputStream;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import pl.edu.icm.jlargearrays.LargeArrayUtils;
import pl.edu.icm.jlargearrays.LongLargeArray;

public class SequenceLog64Big
implements DynamicSequence {
    private static final byte W = 64;
    private static final int INDEX = 0x40000000;
    LongLargeArray data;
    private int numbits;
    private long numentries = 0L;
    private long maxvalue;

    public SequenceLog64Big() {
        this(64);
    }

    public SequenceLog64Big(int numbits) {
        this(numbits, 0L);
    }

    public SequenceLog64Big(int numbits, long capacity) {
        this.numbits = numbits;
        this.maxvalue = BitUtil.maxVal(numbits);
        long size = SequenceLog64Big.numWordsFor(numbits, capacity);
        LongLargeArray.setMaxSizeOf32bitArray(0x40000000);
        this.data = new LongLargeArray(Math.max((int)size, 1));
    }

    public SequenceLog64Big(int numbits, long capacity, boolean initialize) {
        this(numbits, capacity);
        if (initialize) {
            this.numentries = capacity;
        }
    }

    public static final long numWordsFor(int bitsField, long total) {
        return ((long)bitsField * total + 63L) / 64L;
    }

    public static final long lastWordNumBits(int bitsField, long total) {
        long totalBits = (long)bitsField * total;
        if (totalBits == 0L) {
            return 0L;
        }
        return (totalBits - 1L) % 64L + 1L;
    }

    public static final long lastWordNumBytes(int bitsField, long total) {
        return (SequenceLog64Big.lastWordNumBits(bitsField, total) - 1L) / 8L + 1L;
    }

    public static final long numBytesFor(int bitsField, long total) {
        return ((long)bitsField * total + 7L) / 8L;
    }

    private static final long getField(LongLargeArray data, int bitsField, long index) {
        long result;
        if (bitsField == 0) {
            return 0L;
        }
        long bitPos = index * (long)bitsField;
        long i = bitPos / 64L;
        long j = bitPos % 64L;
        if (j + (long)bitsField <= 64L) {
            result = data.get(i) << (int)(64L - j - (long)bitsField) >>> 64 - bitsField;
        } else {
            result = data.get(i) >>> (int)j;
            result |= data.get(i + 1L) << (int)(128L - j - (long)bitsField) >>> 64 - bitsField;
        }
        return result;
    }

    private static final void setField(LongLargeArray data, int bitsField, long index, long value) {
        if (bitsField == 0) {
            return;
        }
        long bitPos = index * (long)bitsField;
        long i = bitPos / 64L;
        long j = bitPos % 64L;
        long mask = (-1L << bitsField ^ 0xFFFFFFFFFFFFFFFFL) << (int)j;
        data.set(i, data.getLong(i) & (mask ^ 0xFFFFFFFFFFFFFFFFL) | value << (int)j);
        if (j + (long)bitsField > 64L) {
            mask = -1L << (int)((long)bitsField + j - 64L);
            data.set(i + 1L, data.get(i + 1L) & mask | value >>> (int)(64L - j));
        }
    }

    private final void resizeArray(long size) {
        LongLargeArray a = new LongLargeArray(size);
        if (size < this.data.length()) {
            LargeArrayUtils.arraycopy(this.data, 0L, a, 0L, size);
        } else {
            LargeArrayUtils.arraycopy(this.data, 0L, a, 0L, this.data.length());
        }
        this.data = a;
    }

    @Override
    public void add(Iterator<Long> elements) {
        long max2 = 0L;
        this.numentries = 0L;
        while (elements.hasNext()) {
            long val = elements.next();
            max2 = val > max2 ? val : max2;
            ++this.numentries;
        }
        this.numbits = BitUtil.log2(max2);
        long size = SequenceLog64Big.numWordsFor(this.numbits, this.numentries);
        this.data = new LongLargeArray(size);
        int count = 0;
        while (elements.hasNext()) {
            long element = elements.next();
            assert (element <= this.maxvalue);
            SequenceLog64Big.setField(this.data, this.numbits, count, element);
            ++count;
        }
    }

    public void addIntegers(ArrayList<Integer> elements) {
        long max2 = 0L;
        this.numentries = 0L;
        for (int i = 0; i < elements.size(); ++i) {
            long val = elements.get(i).longValue();
            max2 = val > max2 ? val : max2;
            ++this.numentries;
        }
        this.numbits = BitUtil.log2(max2);
        long size = SequenceLog64Big.numWordsFor(this.numbits, this.numentries);
        this.data = new LongLargeArray(size);
        int count = 0;
        for (int i = 0; i < elements.size(); ++i) {
            long element = elements.get(i).longValue();
            assert (element <= this.maxvalue);
            SequenceLog64Big.setField(this.data, this.numbits, count, element);
            ++count;
        }
    }

    @Override
    public long get(long position) {
        if (position < 0L || position >= this.numentries) {
            // empty if block
        }
        return SequenceLog64Big.getField(this.data, this.numbits, position);
    }

    @Override
    public void set(long position, long value) {
        SequenceLog64Big.setField(this.data, this.numbits, position, value);
    }

    @Override
    public void append(long value) {
        long neededSize = SequenceLog64Big.numWordsFor(this.numbits, this.numentries + 1L);
        if (this.data.length() < neededSize) {
            this.resizeArray(this.data.length() * 2L);
        }
        this.set(this.numentries, value);
        ++this.numentries;
    }

    @Override
    public void aggresiveTrimToSize() {
        long max2 = 0L;
        for (long i = 0L; i < this.numentries; ++i) {
            long value = this.get(i);
            max2 = value > max2 ? value : max2;
        }
        int newbits = BitUtil.log2(max2);
        assert (newbits <= this.numbits);
        if (newbits != this.numbits) {
            for (long i = 0L; i < this.numentries; ++i) {
                long value = SequenceLog64Big.getField(this.data, this.numbits, i);
                SequenceLog64Big.setField(this.data, newbits, i, value);
            }
            this.numbits = newbits;
            this.maxvalue = BitUtil.maxVal(this.numbits);
            long totalSize = SequenceLog64Big.numWordsFor(this.numbits, this.numentries);
            if (totalSize != this.data.length()) {
                this.resizeArray((int)totalSize);
            }
        }
    }

    @Override
    public void trimToSize() {
        this.resizeArray(SequenceLog64Big.numWordsFor(this.numbits, this.numentries));
    }

    public void resize(long numentries) {
        this.numentries = numentries;
        this.resizeArray(SequenceLog64Big.numWordsFor(this.numbits, numentries));
    }

    @Override
    public long getNumberOfElements() {
        return this.numentries;
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        CRCOutputStream out = new CRCOutputStream(output, new CRC8());
        out.write(1);
        out.write(this.numbits);
        VByte.encode(out, this.numentries);
        out.writeCRC();
        out.setCRC(new CRC32());
        long numwords = SequenceLog64Big.numWordsFor(this.numbits, this.numentries);
        for (long i = 0L; i < numwords - 1L; ++i) {
            IOUtil.writeLong(out, this.data.getLong(i));
        }
        if (numwords > 0L) {
            long lastWordUsedBits = SequenceLog64Big.lastWordNumBits(this.numbits, this.numentries);
            BitUtil.writeLowerBitsByteAligned(this.data.get(numwords - 1L), lastWordUsedBits, out);
        }
        out.writeCRC();
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        CRCInputStream in = new CRCInputStream(input, new CRC8());
        int type = in.read();
        if (type != 1) {
            throw new IllegalFormatException("Trying to read a LogArray but the data is not LogArray");
        }
        this.numbits = in.read();
        this.numentries = VByte.decode(in);
        if (!in.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading LogArray64 header.");
        }
        if (this.numbits > 64) {
            throw new IllegalFormatException("LogArray64 cannot deal with more than 64bit per entry");
        }
        in.setCRC(new CRC32());
        long numwords = SequenceLog64Big.numWordsFor(this.numbits, this.numentries);
        this.data = new LongLargeArray(numwords);
        for (long i = 0L; i < numwords - 1L; ++i) {
            this.data.set(i, IOUtil.readLong(in));
        }
        if (numwords > 0L) {
            long lastWordUsed = SequenceLog64Big.lastWordNumBits(this.numbits, this.numentries);
            this.data.set(numwords - 1L, BitUtil.readLowerBitsByteAligned(lastWordUsed, in));
        }
        if (!in.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading LogArray64 data.");
        }
    }

    @Override
    public long size() {
        return SequenceLog64Big.numBytesFor(this.numbits, this.numentries);
    }

    public long getRealSize() {
        return this.data.length() * 8L;
    }

    public int getNumBits() {
        return this.numbits;
    }

    @Override
    public String getType() {
        return "<http://purl.org/HDT/hdt#seqLog>";
    }

    @Override
    public void close() throws IOException {
        this.data = null;
    }
}

