/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionFactoryAuto;
import org.apache.jena.sparql.function.StandardFunctions;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappedLoader;

public class FunctionRegistry {
    Map<String, FunctionFactory> registry = new HashMap<String, FunctionFactory>();
    Set<String> attemptedLoads = new HashSet<String>();

    public static synchronized FunctionRegistry standardRegistry() {
        FunctionRegistry reg = new FunctionRegistry();
        StandardFunctions.loadStdDefs(reg);
        return reg;
    }

    public static synchronized FunctionRegistry get() {
        FunctionRegistry reg = FunctionRegistry.get(ARQ.getContext());
        if (reg == null) {
            reg = FunctionRegistry.standardRegistry();
            FunctionRegistry.set(ARQ.getContext(), reg);
        }
        return reg;
    }

    public static FunctionRegistry get(Context context) {
        if (context == null) {
            return null;
        }
        return (FunctionRegistry)context.get(ARQConstants.registryFunctions);
    }

    public static void set(Context context, FunctionRegistry reg) {
        context.set(ARQConstants.registryFunctions, reg);
    }

    public void put(String uri, FunctionFactory f) {
        this.registry.put(uri, f);
    }

    public void put(String uri, Class<?> funcClass) {
        if (!Function.class.isAssignableFrom(funcClass)) {
            Log.warn(this, "Class " + funcClass.getName() + " is not a Function");
            return;
        }
        this.registry.put(uri, new FunctionFactoryAuto(funcClass));
    }

    public FunctionFactory get(String uri) {
        FunctionFactory function = this.registry.get(uri);
        if (function != null) {
            return function;
        }
        if (this.attemptedLoads.contains(uri)) {
            return null;
        }
        Class<?> functionClass = MappedLoader.loadClass(uri, Function.class);
        if (functionClass == null) {
            return null;
        }
        this.put(uri, functionClass);
        this.attemptedLoads.add(uri);
        return this.registry.get(uri);
    }

    public boolean isRegistered(String uri) {
        return this.registry.containsKey(uri);
    }

    public FunctionFactory remove(String uri) {
        return this.registry.remove(uri);
    }

    public Iterator<String> keys() {
        return this.registry.keySet().iterator();
    }
}

