/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EmptyStackException;
import java.util.List;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction0;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprFunction3;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformOp;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.ExprWalker;
import org.apache.jena.sparql.expr.NodeValue;

public class ExprTransformer {
    private static ExprTransformer singleton = new ExprTransformer();

    public static ExprTransformer get() {
        return singleton;
    }

    public static Expr transform(ExprTransform transform, Expr expr) {
        return ExprTransformer.get().transformation(transform, expr);
    }

    public static ExprList transform(ExprTransform transform, ExprList exprList) {
        return ExprTransformer.get().transformation(transform, exprList);
    }

    private Expr transformation(ExprTransform transform, Expr expr) {
        ApplyExprTransformVisitor v = new ApplyExprTransformVisitor(transform);
        return this.transformation(v, expr);
    }

    private ExprList transformation(ExprTransform transform, ExprList exprList) {
        ApplyExprTransformVisitor v = new ApplyExprTransformVisitor(transform);
        ExprList exprList2 = new ExprList();
        for (Expr expr : exprList) {
            Expr expr2 = this.transformation(v, expr);
            exprList2.add(expr2);
        }
        return exprList2;
    }

    private Expr transformation(ApplyExprTransformVisitor applyVisitor, Expr expr) {
        ExprWalker.walk(applyVisitor, expr);
        return applyVisitor.result();
    }

    public static class ApplyExprTransformVisitor
    implements ExprVisitor {
        private ExprTransform transform;
        private final Deque<Expr> stack = new ArrayDeque<Expr>();

        final Expr result() {
            if (this.stack.size() != 1) {
                Log.warn(this, "Stack is not aligned (size = " + this.stack.size() + ")");
                if (this.stack.isEmpty()) {
                    return null;
                }
            }
            return this.stack.pop();
        }

        ApplyExprTransformVisitor(ExprTransform transform) {
            this.transform = transform;
        }

        @Override
        public void startVisit() {
        }

        @Override
        public void finishVisit() {
        }

        @Override
        public void visit(ExprFunction0 func) {
            Expr e2 = func.apply(this.transform);
            ApplyExprTransformVisitor.push(this.stack, e2);
        }

        @Override
        public void visit(ExprFunction1 func) {
            Expr e1 = ApplyExprTransformVisitor.pop(this.stack);
            Expr e2 = func.apply(this.transform, e1);
            ApplyExprTransformVisitor.push(this.stack, e2);
        }

        @Override
        public void visit(ExprFunction2 func) {
            Expr e2 = ApplyExprTransformVisitor.pop(this.stack);
            Expr e1 = ApplyExprTransformVisitor.pop(this.stack);
            Expr e3 = func.apply(this.transform, e1, e2);
            ApplyExprTransformVisitor.push(this.stack, e3);
        }

        @Override
        public void visit(ExprFunction3 func) {
            Expr e3 = ApplyExprTransformVisitor.pop(this.stack);
            Expr e2 = ApplyExprTransformVisitor.pop(this.stack);
            Expr e1 = ApplyExprTransformVisitor.pop(this.stack);
            Expr e4 = func.apply(this.transform, e1, e2, e3);
            ApplyExprTransformVisitor.push(this.stack, e4);
        }

        @Override
        public void visit(ExprFunctionN func) {
            ExprList x = this.process(func.getArgs());
            Expr e2 = func.apply(this.transform, x);
            ApplyExprTransformVisitor.push(this.stack, e2);
        }

        private ExprList process(List<Expr> exprList) {
            int N = exprList.size();
            ArrayList<Expr> x = new ArrayList<Expr>(N);
            for (Expr anExprList : exprList) {
                Expr e2 = ApplyExprTransformVisitor.pop(this.stack);
                x.add(0, e2);
            }
            return new ExprList(x);
        }

        @Override
        public void visit(ExprFunctionOp funcOp) {
            ExprList x = null;
            if (funcOp.getArgs() != null) {
                x = this.process(funcOp.getArgs());
            }
            Op op = funcOp.getGraphPattern();
            if (this.transform instanceof ExprTransformOp) {
                ExprTransformOp t = (ExprTransformOp)this.transform;
                op = Transformer.transform(t.getTransform(), op);
            }
            Expr e2 = funcOp.apply(this.transform, x, op);
            ApplyExprTransformVisitor.push(this.stack, e2);
        }

        @Override
        public void visit(NodeValue nv) {
            Expr e2 = nv.apply(this.transform);
            ApplyExprTransformVisitor.push(this.stack, e2);
        }

        @Override
        public void visit(ExprVar var) {
            Expr e2 = var.apply(this.transform);
            ApplyExprTransformVisitor.push(this.stack, e2);
        }

        @Override
        public void visit(ExprAggregator eAgg) {
            Expr e2 = eAgg.apply(this.transform);
            ApplyExprTransformVisitor.push(this.stack, e2);
        }

        private static void push(Deque<Expr> stack, Expr value) {
            stack.push(value);
        }

        private static Expr pop(Deque<Expr> stack) {
            try {
                Expr e2 = stack.pop();
                if (e2 == NodeValue.nvNothing) {
                    e2 = null;
                }
                return e2;
            }
            catch (EmptyStackException ex) {
                System.err.println("Empty stack");
                return null;
            }
        }
    }
}

