/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.ConstAssembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.assemblers.AssemblerGroup;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sparql.core.assembler.DatasetNullAssembler;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappingRegistry;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sparql.util.TypeNotUniqueException;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.system.JenaSystem;

public class AssemblerUtils {
    private static boolean initialized = false;

    public static PrefixMapping readPrefixMapping(String file) {
        PrefixMapping pm = (PrefixMapping)AssemblerUtils.build(file, JA.PrefixMapping);
        return pm;
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        AssemblerUtils.registerWith(ConstAssembler.general());
    }

    public static void registerWith(AssemblerGroup g) {
        g.implementWith(DatasetAssembler.getType(), new DatasetAssembler());
        g.implementWith(DatasetNullAssembler.getType(), new DatasetNullAssembler());
    }

    private static void assemblerClass(AssemblerGroup g, Resource r, Assembler a) {
        g.implementWith(r, a);
    }

    public static Object build(String assemblerFile, String typeURI) {
        Resource type = ResourceFactory.createResource(typeURI);
        return AssemblerUtils.build(assemblerFile, type);
    }

    public static Object build(String assemblerFile, Resource type) {
        if (assemblerFile == null) {
            throw new ARQException("No assembler file");
        }
        Model spec = null;
        try {
            spec = RDFDataMgr.loadModel(assemblerFile);
        }
        catch (Exception ex) {
            throw new ARQException("Failed reading assembler description: " + ex.getMessage());
        }
        Resource root2 = null;
        try {
            root2 = GraphUtils.findRootByType(spec, type);
            if (root2 == null) {
                return null;
            }
        }
        catch (TypeNotUniqueException ex) {
            throw new ARQException("Multiple types for: " + DatasetAssemblerVocab.tDataset);
        }
        return Assembler.general.open(root2);
    }

    public static void setContext(Resource r, Context context) {
        String qs = "PREFIX ja: <" + JA.getURI() + ">\nSELECT * { ?x ja:context [ ja:cxtName ?name ; ja:cxtValue ?value ] }";
        QuerySolutionMap qsm = new QuerySolutionMap();
        qsm.add("x", r);
        QueryExecution qExec = QueryExecutionFactory.create(qs, r.getModel(), (QuerySolution)qsm);
        ResultSet rs = qExec.execSelect();
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            String name = soln.getLiteral("name").getLexicalForm();
            String value = soln.getLiteral("value").getLexicalForm();
            name = MappingRegistry.mapPrefixName(name);
            Symbol symbol = Symbol.create(name);
            if ("undef".equalsIgnoreCase(value)) {
                context.remove(symbol);
                continue;
            }
            context.set(symbol, value);
        }
    }

    static {
        JenaSystem.init();
    }
}

