/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphCollection;

public class DatasetGraphMap
extends DatasetGraphCollection {
    private Map<Node, Graph> graphs = new HashMap<Node, Graph>();
    private Graph defaultGraph;

    public DatasetGraphMap(Graph defaultGraph) {
        this.defaultGraph = defaultGraph;
    }

    public DatasetGraphMap(DatasetGraph dsg) {
        this(dsg.getDefaultGraph());
        Iterator<Node> names = dsg.listGraphNodes();
        while (names.hasNext()) {
            Node gn = names.next();
            this.addGraph(gn, dsg.getGraph(gn));
        }
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return this.graphs.containsKey(graphNode);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.defaultGraph;
    }

    @Override
    public Graph getGraph(Node graphNode) {
        Graph g = this.graphs.get(graphNode);
        if (g == null && (g = this.getGraphCreate()) != null) {
            this.addGraph(graphNode, g);
        }
        return g;
    }

    protected Graph getGraphCreate() {
        return null;
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        this.graphs.put(graphName, graph);
    }

    @Override
    public void removeGraph(Node graphName) {
        this.graphs.remove(graphName);
    }

    @Override
    public void setDefaultGraph(Graph g) {
        this.defaultGraph = g;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.graphs.keySet().iterator();
    }

    @Override
    public long size() {
        return this.graphs.size();
    }

    @Override
    public void close() {
        this.defaultGraph.close();
        for (Graph graph : this.graphs.values()) {
            graph.close();
        }
        super.close();
    }
}

