/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Blank;
import org.apache.jena.graph.Node_Literal;
import org.apache.jena.graph.Node_URI;
import org.apache.jena.graph.impl.LiteralLabelFactory;
import org.rdfhdt.hdtjena.CustomDatatype;

public class JenaNodeCreator {
    private JenaNodeCreator() {
    }

    public static Node createAnon() {
        return new Node_Blank(BlankNodeId.create());
    }

    public static Node createAnon(CharSequence x) {
        return new Node_Blank(BlankNodeId.create(x.toString()));
    }

    public static Node createLiteral(CharSequence x) {
        String str2 = x.toString();
        int len = str2.length();
        String literal = "";
        String datatype = "";
        String lang = "";
        int next = 0;
        for (int i = len - 1; i > 0; --i) {
            char cur = str2.charAt(i);
            if (cur == '\"') {
                if (next == 64) {
                    literal = str2.substring(1, i);
                    lang = str2.substring(i + 2, len);
                    return new Node_Literal(LiteralLabelFactory.create(literal, lang));
                }
                literal = str2.substring(1, i);
                return new Node_Literal(LiteralLabelFactory.create(literal, "", false));
            }
            if (cur == '^' && next == 94 && str2.charAt(i - 1) == '\"') {
                literal = str2.substring(1, i - 1);
                datatype = str2.charAt(i + 2) == '<' && str2.charAt(len - 1) == '>' ? str2.substring(i + 3, len - 1) : str2.substring(i + 2, len);
                RDFDatatype rdfDataType = TypeMapper.getInstance().getTypeByName(datatype);
                if (rdfDataType == null) {
                    rdfDataType = new CustomDatatype(datatype);
                    TypeMapper.getInstance().registerDatatype(rdfDataType);
                }
                return new Node_Literal(LiteralLabelFactory.create(literal, rdfDataType));
            }
            next = cur;
        }
        return new Node_Literal(LiteralLabelFactory.create(str2.substring(1, len - 2), "", false));
    }

    public static Node createURI(CharSequence x) {
        return new Node_URI(x.toString());
    }
}

