/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web.auth;

import java.net.URI;
import java.util.Map;
import org.apache.jena.atlas.web.auth.AbstractScopedAuthenticator;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.engine.http.Service;
import org.apache.jena.sparql.util.Context;

public class ServiceAuthenticator
extends AbstractScopedAuthenticator<Context> {
    private Context context;
    private String username;
    private char[] password;

    public ServiceAuthenticator() {
        this(ARQ.getContext(), null, null);
    }

    public ServiceAuthenticator(String username, char[] password) {
        this(ARQ.getContext(), username, password);
    }

    public ServiceAuthenticator(Context context) {
        this(context, null, null);
    }

    public ServiceAuthenticator(Context context, String username, char[] password) {
        this.context = context;
        this.username = username;
        this.password = password;
    }

    private Map<String, Context> getServiceContextMap() {
        return (Map)this.context.get(Service.serviceContext);
    }

    @Override
    protected Context getCredentials(URI target) {
        Map<String, Context> serviceContextMap = this.getServiceContextMap();
        if (serviceContextMap == null) {
            return null;
        }
        return serviceContextMap.get(target.toString());
    }

    @Override
    protected String getUserNameFromCredentials(Context credentials) {
        if (credentials != null) {
            return credentials.getAsString(Service.queryAuthUser);
        }
        return this.username;
    }

    @Override
    protected char[] getPasswordFromCredentials(Context credentials) {
        if (credentials != null) {
            String pwd = credentials.getAsString(Service.queryAuthPwd);
            return pwd != null ? pwd.toCharArray() : null;
        }
        return this.password;
    }
}

