/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import java.io.IOException;
import java.io.Serializable;

public class StdValueInstantiator
extends ValueInstantiator
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String _valueTypeDesc;
    protected final boolean _cfgEmptyStringsAsObjects;
    protected AnnotatedWithParams _defaultCreator;
    protected AnnotatedWithParams _withArgsCreator;
    protected CreatorProperty[] _constructorArguments;
    protected JavaType _delegateType;
    protected AnnotatedWithParams _delegateCreator;
    protected CreatorProperty[] _delegateArguments;
    protected AnnotatedWithParams _fromStringCreator;
    protected AnnotatedWithParams _fromIntCreator;
    protected AnnotatedWithParams _fromLongCreator;
    protected AnnotatedWithParams _fromDoubleCreator;
    protected AnnotatedWithParams _fromBooleanCreator;
    protected AnnotatedParameter _incompleteParameter;

    public StdValueInstantiator(DeserializationConfig deserializationConfig, Class<?> clazz) {
        this._cfgEmptyStringsAsObjects = deserializationConfig == null ? false : deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        this._valueTypeDesc = clazz == null ? "UNKNOWN TYPE" : clazz.getName();
    }

    public StdValueInstantiator(DeserializationConfig deserializationConfig, JavaType javaType) {
        this._cfgEmptyStringsAsObjects = deserializationConfig == null ? false : deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        this._valueTypeDesc = javaType == null ? "UNKNOWN TYPE" : javaType.toString();
    }

    protected StdValueInstantiator(StdValueInstantiator stdValueInstantiator) {
        this._cfgEmptyStringsAsObjects = stdValueInstantiator._cfgEmptyStringsAsObjects;
        this._valueTypeDesc = stdValueInstantiator._valueTypeDesc;
        this._defaultCreator = stdValueInstantiator._defaultCreator;
        this._constructorArguments = stdValueInstantiator._constructorArguments;
        this._withArgsCreator = stdValueInstantiator._withArgsCreator;
        this._delegateType = stdValueInstantiator._delegateType;
        this._delegateCreator = stdValueInstantiator._delegateCreator;
        this._delegateArguments = stdValueInstantiator._delegateArguments;
        this._fromStringCreator = stdValueInstantiator._fromStringCreator;
        this._fromIntCreator = stdValueInstantiator._fromIntCreator;
        this._fromLongCreator = stdValueInstantiator._fromLongCreator;
        this._fromDoubleCreator = stdValueInstantiator._fromDoubleCreator;
        this._fromBooleanCreator = stdValueInstantiator._fromBooleanCreator;
    }

    public void configureFromObjectSettings(AnnotatedWithParams annotatedWithParams, AnnotatedWithParams annotatedWithParams2, JavaType javaType, CreatorProperty[] creatorPropertyArray, AnnotatedWithParams annotatedWithParams3, CreatorProperty[] creatorPropertyArray2) {
        this._defaultCreator = annotatedWithParams;
        this._delegateCreator = annotatedWithParams2;
        this._delegateType = javaType;
        this._delegateArguments = creatorPropertyArray;
        this._withArgsCreator = annotatedWithParams3;
        this._constructorArguments = creatorPropertyArray2;
    }

    public void configureFromStringCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromStringCreator = annotatedWithParams;
    }

    public void configureFromIntCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromIntCreator = annotatedWithParams;
    }

    public void configureFromLongCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromLongCreator = annotatedWithParams;
    }

    public void configureFromDoubleCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromDoubleCreator = annotatedWithParams;
    }

    public void configureFromBooleanCreator(AnnotatedWithParams annotatedWithParams) {
        this._fromBooleanCreator = annotatedWithParams;
    }

    public void configureIncompleteParameter(AnnotatedParameter annotatedParameter) {
        this._incompleteParameter = annotatedParameter;
    }

    @Override
    public String getValueTypeDesc() {
        return this._valueTypeDesc;
    }

    @Override
    public boolean canCreateFromString() {
        return this._fromStringCreator != null;
    }

    @Override
    public boolean canCreateFromInt() {
        return this._fromIntCreator != null;
    }

    @Override
    public boolean canCreateFromLong() {
        return this._fromLongCreator != null;
    }

    @Override
    public boolean canCreateFromDouble() {
        return this._fromDoubleCreator != null;
    }

    @Override
    public boolean canCreateFromBoolean() {
        return this._fromBooleanCreator != null;
    }

    @Override
    public boolean canCreateUsingDefault() {
        return this._defaultCreator != null;
    }

    @Override
    public boolean canCreateUsingDelegate() {
        return this._delegateType != null;
    }

    @Override
    public boolean canCreateFromObjectWith() {
        return this._withArgsCreator != null;
    }

    @Override
    public JavaType getDelegateType(DeserializationConfig deserializationConfig) {
        return this._delegateType;
    }

    @Override
    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig deserializationConfig) {
        return this._constructorArguments;
    }

    @Override
    public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._defaultCreator == null) {
            throw new IllegalStateException("No default constructor for " + this.getValueTypeDesc());
        }
        try {
            return this._defaultCreator.call();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw this.wrapException(exceptionInInitializerError);
        }
        catch (Exception exception) {
            throw this.wrapException(exception);
        }
    }

    @Override
    public Object createFromObjectWith(DeserializationContext deserializationContext, Object[] objectArray) throws IOException, JsonProcessingException {
        if (this._withArgsCreator == null) {
            throw new IllegalStateException("No with-args constructor for " + this.getValueTypeDesc());
        }
        try {
            return this._withArgsCreator.call(objectArray);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw this.wrapException(exceptionInInitializerError);
        }
        catch (Exception exception) {
            throw this.wrapException(exception);
        }
    }

    @Override
    public Object createUsingDelegate(DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        if (this._delegateCreator == null) {
            throw new IllegalStateException("No delegate constructor for " + this.getValueTypeDesc());
        }
        try {
            if (this._delegateArguments == null) {
                return this._delegateCreator.call1(object);
            }
            int n = this._delegateArguments.length;
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                CreatorProperty creatorProperty = this._delegateArguments[i];
                objectArray[i] = creatorProperty == null ? object : deserializationContext.findInjectableValue(creatorProperty.getInjectableValueId(), creatorProperty, null);
            }
            return this._delegateCreator.call(objectArray);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw this.wrapException(exceptionInInitializerError);
        }
        catch (Exception exception) {
            throw this.wrapException(exception);
        }
    }

    @Override
    public Object createFromString(DeserializationContext deserializationContext, String string) throws IOException, JsonProcessingException {
        if (this._fromStringCreator != null) {
            try {
                return this._fromStringCreator.call1(string);
            }
            catch (Exception exception) {
                throw this.wrapException(exception);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                throw this.wrapException(exceptionInInitializerError);
            }
        }
        return this._createFromStringFallbacks(deserializationContext, string);
    }

    @Override
    public Object createFromInt(DeserializationContext deserializationContext, int n) throws IOException, JsonProcessingException {
        try {
            if (this._fromIntCreator != null) {
                return this._fromIntCreator.call1(n);
            }
            if (this._fromLongCreator != null) {
                return this._fromLongCreator.call1(n);
            }
        }
        catch (Exception exception) {
            throw this.wrapException(exception);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw this.wrapException(exceptionInInitializerError);
        }
        throw new JsonMappingException("Can not instantiate value of type " + this.getValueTypeDesc() + " from Integral number (" + n + "); no single-int-arg constructor/factory method");
    }

    @Override
    public Object createFromLong(DeserializationContext deserializationContext, long l) throws IOException, JsonProcessingException {
        try {
            if (this._fromLongCreator != null) {
                return this._fromLongCreator.call1(l);
            }
        }
        catch (Exception exception) {
            throw this.wrapException(exception);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw this.wrapException(exceptionInInitializerError);
        }
        throw new JsonMappingException("Can not instantiate value of type " + this.getValueTypeDesc() + " from Long integral number (" + l + "); no single-long-arg constructor/factory method");
    }

    @Override
    public Object createFromDouble(DeserializationContext deserializationContext, double d) throws IOException, JsonProcessingException {
        try {
            if (this._fromDoubleCreator != null) {
                return this._fromDoubleCreator.call1(d);
            }
        }
        catch (Exception exception) {
            throw this.wrapException(exception);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw this.wrapException(exceptionInInitializerError);
        }
        throw new JsonMappingException("Can not instantiate value of type " + this.getValueTypeDesc() + " from Floating-point number (" + d + "); no one-double/Double-arg constructor/factory method");
    }

    @Override
    public Object createFromBoolean(DeserializationContext deserializationContext, boolean bl) throws IOException, JsonProcessingException {
        try {
            if (this._fromBooleanCreator != null) {
                return this._fromBooleanCreator.call1(bl);
            }
        }
        catch (Exception exception) {
            throw this.wrapException(exception);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw this.wrapException(exceptionInInitializerError);
        }
        throw new JsonMappingException("Can not instantiate value of type " + this.getValueTypeDesc() + " from Boolean value (" + bl + "); no single-boolean/Boolean-arg constructor/factory method");
    }

    @Override
    public AnnotatedWithParams getDelegateCreator() {
        return this._delegateCreator;
    }

    @Override
    public AnnotatedWithParams getDefaultCreator() {
        return this._defaultCreator;
    }

    @Override
    public AnnotatedWithParams getWithArgsCreator() {
        return this._withArgsCreator;
    }

    @Override
    public AnnotatedParameter getIncompleteParameter() {
        return this._incompleteParameter;
    }

    protected Object _createFromStringFallbacks(DeserializationContext deserializationContext, String string) throws IOException, JsonProcessingException {
        if (this._fromBooleanCreator != null) {
            String string2 = string.trim();
            if ("true".equals(string2)) {
                return this.createFromBoolean(deserializationContext, true);
            }
            if ("false".equals(string2)) {
                return this.createFromBoolean(deserializationContext, false);
            }
        }
        if (this._cfgEmptyStringsAsObjects && string.length() == 0) {
            return null;
        }
        throw new JsonMappingException("Can not instantiate value of type " + this.getValueTypeDesc() + " from String value ('" + string + "'); no single-String constructor/factory method");
    }

    protected JsonMappingException wrapException(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof JsonMappingException) {
            return (JsonMappingException)throwable;
        }
        return new JsonMappingException("Instantiation of " + this.getValueTypeDesc() + " value failed: " + throwable.getMessage(), throwable);
    }
}

