/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.CmdARQ;
import java.io.IOException;
import java.util.List;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.modify.request.UpdateWriter;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.util.FileUtils;

public class uparse
extends CmdARQ {
    protected static final ArgDecl fileArg = new ArgDecl(true, "file", "update");
    protected static final ArgDecl syntaxArg = new ArgDecl(true, "syntax", "syn");
    protected static final ArgDecl argDeclPrint = new ArgDecl(true, "print");
    List<String> requestFiles = null;
    protected Syntax updateSyntax = null;
    private boolean printUpdate = false;
    private boolean printNone = false;
    static final String divider = "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
    static boolean needDivider = false;

    public static void main(String ... argv) {
        new uparse(argv).mainRun();
    }

    protected uparse(String[] argv) {
        super(argv);
        super.add(fileArg, "--file=FILE", "Update commands to parse");
        super.add(syntaxArg, "--syntax=name", "Update syntax");
        super.add(argDeclPrint, "--print", "Print in various forms [update, none]");
    }

    @Override
    protected void processModulesAndArgs() {
        this.requestFiles = this.getValues(fileArg);
        super.processModulesAndArgs();
        if (this.cmdStrictMode) {
            this.updateSyntax = Syntax.syntaxSPARQL_11;
        }
        if (super.contains(syntaxArg)) {
            String s = super.getValue(syntaxArg);
            Syntax syn = Syntax.lookup(s);
            if (syn == null) {
                super.cmdError("Unrecognized syntax: " + s);
            }
            this.updateSyntax = syn;
        }
        for (String arg : this.getValues(argDeclPrint)) {
            if (arg.equalsIgnoreCase("query")) {
                this.printUpdate = true;
                continue;
            }
            if (arg.equalsIgnoreCase("none")) {
                this.printNone = true;
                continue;
            }
            throw new CmdException("Not a recognized print form: " + arg + " : Choices are: update, none");
        }
        if (!this.printUpdate && !this.printNone) {
            this.printUpdate = true;
        }
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --file=<request file> | <update string>";
    }

    @Override
    protected void exec() {
        Syntax syntax;
        for (String filename : this.requestFiles) {
            String x;
            syntax = this.updateSyntax;
            if (syntax == null) {
                syntax = Syntax.guessUpdateFileSyntax(filename);
            }
            if ((x = this.oneFile(filename)) == null) continue;
            this.execOne(x, syntax);
        }
        for (String x : this.positionals) {
            syntax = this.updateSyntax;
            if (this.matchesIndirect(x)) {
                if (syntax == null) {
                    syntax = Syntax.guessUpdateFileSyntax(x);
                }
                x = this.indirect(x);
            }
            if (syntax == null) {
                syntax = Syntax.defaultUpdateSyntax;
            }
            this.execOne(x, syntax);
        }
    }

    private String oneFile(String filename) {
        uparse.divider();
        try {
            return FileUtils.readWholeFileAsUTF8(filename);
        }
        catch (IOException ex) {
            System.err.println("No such file: " + filename);
            return null;
        }
    }

    private void execOne(String updateString, Syntax syntax) {
        UpdateRequest req;
        try {
            req = UpdateFactory.create(updateString, syntax);
        }
        catch (QueryParseException ex) {
            System.err.print("Parse error: ");
            System.err.println(ex.getMessage());
            return;
        }
        if (this.printUpdate) {
            System.out.print(req);
        }
        if (this.printNone) {
            return;
        }
        IndentedLineBuffer w = new IndentedLineBuffer();
        UpdateWriter.output(req, w);
        String updateString2 = w.asString();
        UpdateRequest req2 = null;
        try {
            req2 = UpdateFactory.create(updateString2, syntax);
        }
        catch (QueryParseException ex) {
            System.err.println("Can not reparse update after serialization");
            System.err.println(updateString2);
        }
        if (!req.equalTo(req2)) {
            System.err.println("Reparsed update does not .equalTo original parsed request");
        }
    }

    private static void divider() {
        if (needDivider) {
            System.out.println(divider);
        }
        needDivider = true;
    }
}

