# Changelog

All notable changes to this project will be documented in this file. See [standard-version](https://github.com/conventional-changelog/standard-version) for commit guidelines.

### 7.7.2 (2023-01-02)

### 7.7.1 (2022-11-17)

## 7.7.0 (2022-11-17)


### Features

* **location:** add methods to get latitude and longitude in different formats ([ab0d3c5](https://github.com/andrmoel/astronomy-bundle-js/commit/ab0d3c537d836ac28e728b5593e133763bdcd81d))

## 7.6.0 (2022-11-17)


### Features

* **angle-calc:** add decimal2degreeMinutes and decimal2degreeMinutesSeconds ([9c22d1e](https://github.com/andrmoel/astronomy-bundle-js/commit/9c22d1e0a71c207dd9d867bb00bc6aab694e513c))

### 7.5.6 (2022-11-14)

### 7.5.5 (2022-06-13)

### 7.5.4 (2022-05-23)

### 7.5.3 (2022-02-26)

### 7.5.2 (2022-02-26)

### 7.5.1 (2022-02-23)

## 7.5.0 (2022-02-23)


### Features

* **moon:** calculate golden handle ([3a90ecb](https://github.com/andrmoel/astronomy-bundle-js/commit/3a90ecb825fa0c5a6543dfb646f68d2592f34d6c))

## 7.4.0 (2022-02-23)


### Features

* **moon:** calculate lunar x ([ce4c070](https://github.com/andrmoel/astronomy-bundle-js/commit/ce4c070e1d7fa8211e85d88445e4f686e8aed9e6))

## 7.3.0 (2022-02-23)


### Features

* **moon:** calculate lunar x ([ab8aabf](https://github.com/andrmoel/astronomy-bundle-js/commit/ab8aabf07f3568fb0bb615947ed48fd6492acab9))

### 7.2.3 (2022-02-22)

### 7.2.2 (2022-02-22)

### 7.2.1 (2022-02-22)

## 7.2.0 (2022-02-22)


### Features

* **moon:** get selenographic location of sun ([d8a0c68](https://github.com/andrmoel/astronomy-bundle-js/commit/d8a0c6890231d2fb0563fe7091e57e8af825462d))

### 7.1.2 (2022-02-22)

### 7.1.1 (2022-02-21)

## 7.1.0 (2022-02-21)


### Features

* **moon:** calculate libration ([bc8720c](https://github.com/andrmoel/astronomy-bundle-js/commit/bc8720c1d4d1e25bff6d02c8823bf0b07ab821c2))

### 7.0.16 (2022-02-21)

### 7.0.15 (2022-02-19)

### 7.0.14 (2022-02-19)

### 7.0.13 (2022-02-19)

### 7.0.12 (2022-02-18)

### 7.0.11 (2022-02-18)

### 7.0.10 (2022-02-18)

### 7.0.9 (2022-02-16)

### 7.0.8 (2022-02-16)

### 7.0.7 (2022-02-06)

### 7.0.6 (2022-02-06)

### 7.0.5 (2022-02-06)

### 7.0.4 (2022-02-06)

### 7.0.3 (2022-02-06)

### 7.0.2 (2022-02-05)

### 7.0.1 (2022-02-05)

## 7.0.0 (2022-02-05)


### ⚠ BREAKING CHANGES

* **eslint:** change enum keys from camelCase to PascalCase

* **eslint:** add eslint config for TypeScript ([9cb4c62](https://github.com/andrmoel/astronomy-bundle-js/commit/9cb4c6280b1162c1c43dfabc736a35d5cbb73859))

### 6.9.3 (2021-12-28)

### 6.9.2 (2021-12-28)

### 6.9.1 (2021-12-27)

## 6.9.0 (2021-12-27)


### Features

* **solar-eclipse:** get obscuration ([6cf8fef](https://github.com/andrmoel/astronomy-bundle-js/commit/6cf8fef8f0933de65c608891b1988f1891ad98cf))

## 6.8.0 (2021-12-27)


### Features

* **solar-eclipse:** add observational circumstances ([045c418](https://github.com/andrmoel/astronomy-bundle-js/commit/045c4180880749c1d7292dad19555032c061e066))

### 6.7.10 (2021-12-27)

### 6.7.9 (2021-12-27)

### 6.7.8 (2021-12-27)

### 6.7.7 (2021-12-23)

### 6.7.6 (2021-12-23)

### 6.7.5 (2021-12-22)

### 6.7.4 (2021-12-22)

### 6.7.3 (2021-12-22)

### 6.7.2 (2021-10-13)

### 6.7.1 (2021-10-08)

## 6.7.0 (2021-10-08)


### Features

* **location:** calculate distance between two locations ([03eca26](https://github.com/andrmoel/astronomy-bundle-js/commit/03eca265221a3e5e819e36134f9c35499b1e745f))

### 6.6.10 (2021-10-08)

### 6.6.9 (2021-10-08)

### 6.6.8 (2021-10-08)

### 6.6.7 (2021-10-08)

### 6.6.6 (2021-10-08)


### Bug Fixes

* **codecov:** ignore loadBesselianElements function ([673cc16](https://github.com/andrmoel/astronomy-bundle-js/commit/673cc16520efb306d66e2606619a1f571c9e7235))

### 6.6.5 (2021-10-08)

### 6.6.4 (2021-10-08)

### 6.6.3 (2021-10-06)

### 6.6.2 (2021-10-05)


### Bug Fixes

* **node:** upgrade dependencies ([126d4c4](https://github.com/andrmoel/astronomy-bundle-js/commit/126d4c42ce7681a5d4f4350c688f809bdd137c8c))

### 6.6.1 (2021-06-17)

## 6.6.0 (2021-06-17)


### Features

* **moon:** add new calculations for apparent magnitude ([e1b943e](https://github.com/andrmoel/astronomy-bundle-js/commit/e1b943ee724bde54cd9dbdca6096eab81025ba75))

### 6.5.1 (2021-06-12)

## 6.5.0 (2021-05-11)


### Features

* **solar-eclipse:** calculate solar eclipse circumstances for maximum eclipse ([127902b](https://github.com/andrmoel/astronomy-bundle-js/commit/127902bf6b7699cc0185f4d4b6a41b41abeef588))

### 6.4.4 (2021-05-11)

### 6.4.3 (2021-05-11)

### 6.4.2 (2021-05-01)

### 6.4.1 (2021-05-01)


### Bug Fixes

* **solar-eclipse:** add besselian elements to release ([b079554](https://github.com/andrmoel/astronomy-bundle-js/commit/b079554625cefd26cb2a69e423007d669331c10b))

## 6.4.0 (2021-05-01)


### Features

* **solar-eclipse:** load besselian elements from year 1500 to 2500 ([6ffefe3](https://github.com/andrmoel/astronomy-bundle-js/commit/6ffefe381fa4f23f086f75c429a9b4e809005a89))

### 6.3.5 (2021-04-30)

### 6.3.4 (2021-04-27)

### 6.3.3 (2021-04-27)

### 6.3.2 (2021-04-26)

### 6.3.1 (2021-04-26)


### Bug Fixes

* **solar-eclipse:** remove file extension for dynamic import of besselian elements ([7bdbc2c](https://github.com/andrmoel/astronomy-bundle-js/commit/7bdbc2c1c1bf8679d5b0ca3384c64de511303e21))

## 6.3.0 (2021-04-26)


### Features

* **solar-eclipse:** get location of greatest eclipse ([28b41f4](https://github.com/andrmoel/astronomy-bundle-js/commit/28b41f4e3e42c097a06c5d63605c8a67d142747b))

## 6.2.0 (2021-04-24)


### Features

* **time-of-interest:** add method getString() ([58ccb39](https://github.com/andrmoel/astronomy-bundle-js/commit/58ccb39c49b5df5fa999e748d65ddaac4db3151d))

## 6.1.0 (2021-04-24)


### Features

* **besselian-elements:** add function to download besselian elements from NASA's website ([9c7eaaa](https://github.com/andrmoel/astronomy-bundle-js/commit/9c7eaaa6295332c126162949bdb3f72fcd16bc9a))

### 6.0.24 (2021-04-24)


### Bug Fixes

* **github-actions:** add readme to release ([1a7b0c1](https://github.com/andrmoel/astronomy-bundle-js/commit/1a7b0c18f0b30308a391463b412d3facda98e025))

### 6.0.23 (2021-04-24)

### 6.0.22 (2021-04-24)

### 6.0.21 (2021-04-24)

### 6.0.20 (2021-04-24)

### 6.0.19 (2021-04-24)

### 6.0.18 (2021-04-24)

### 6.0.17 (2021-04-24)

### 6.0.16 (2021-04-24)

### 6.0.15 (2021-04-24)

### 6.0.14 (2021-04-22)

### 6.0.13 (2021-04-22)

### 6.0.12 (2021-04-22)

### 6.0.11 (2021-04-22)

### 6.0.10 (2021-04-21)

### 6.0.9 (2021-04-21)

### 6.0.8 (2021-04-20)

### 6.0.7 (2021-04-20)

### 6.0.6 (2021-04-20)

### 6.0.5 (2021-04-19)

### 6.0.4 (2021-02-07)

### 6.0.3 (2021-02-07)

### 6.0.2 (2021-02-07)

### 6.0.1 (2021-02-07)

## 6.0.0 (2021-02-07)


### ⚠ BREAKING CHANGES

* **typescript:** changed parameters in coordinate calculations functions

* **typescript:** use of types instead of interfaces ([e67e35b](https://github.com/andrmoel/astronomy-bundle-js/commit/e67e35ba4ad0740a40c0e99be3cdc4530a6ad9fa))

## 5.19.0 (2021-01-19)


### Features

* **star:** add coordinate calculations for stars ([47ff8e3](https://github.com/andrmoel/astronomy-bundle-js/commit/47ff8e37403cd293a6f03316c64a950631b99f6d))

### 5.18.2 (2021-01-18)

### 5.18.1 (2021-01-18)

## 5.18.0 (2021-01-18)


### Features

* **precession:** add functions to calculate precession ([fca422a](https://github.com/andrmoel/astronomy-bundle-js/commit/fca422ae6b84636ba77853bb60566a57ee66e99b))

### 5.17.10 (2021-01-18)

### 5.17.9 (2021-01-18)

### 5.17.8 (2020-12-28)


### Bug Fixes

* **typescript:** async cannot be used in abstract functions ([74ade1f](https://github.com/andrmoel/astronomy-bundle-js/commit/74ade1fd27e16d2462c80a85a86ba98ae86158b2))

### 5.17.7 (2020-12-06)


### Bug Fixes

* **rise-set:** calculate case when rise and transit are very close ([fce58fd](https://github.com/andrmoel/astronomy-bundle-js/commit/fce58fdc706dac2197a13ac3f2560a62cf26953b))

### 5.17.6 (2020-12-05)


### Bug Fixes

* **rise-set:** local hour angle must be between -180 and 180 deg ([25818ab](https://github.com/andrmoel/astronomy-bundle-js/commit/25818aba0bc29727f809a673240b52e9641f5eca))

### 5.17.5 (2020-12-05)


### Bug Fixes

* **rise-set:** throw error when no transit on given day is possible ([b7db39f](https://github.com/andrmoel/astronomy-bundle-js/commit/b7db39fdd11c9a06621396fe4d1382fc4e0e1d93))

### 5.17.4 (2020-12-05)

### 5.17.3 (2020-12-04)

### 5.17.2 (2020-12-03)

### 5.17.1 (2020-12-01)

## 5.17.0 (2020-11-26)


### Features

* **astronomical-object:** add method getName() ([3cb99ae](https://github.com/andrmoel/astronomy-bundle-js/commit/3cb99aecf0da586f301bf1f84f0693eb8837d7cb))

## 5.16.0 (2020-11-25)


### Features

* **conjunction:** add calculation for conjunction in longitude ([a28de85](https://github.com/andrmoel/astronomy-bundle-js/commit/a28de85b367ec09fae35e24b389f9960c942de44))

## 5.15.0 (2020-11-25)


### Features

* **vsop87:** add short theory for faster calculations ([47c729f](https://github.com/andrmoel/astronomy-bundle-js/commit/47c729f4420b637d037268388ca66c9987e8ce68))

### 5.14.3 (2020-11-24)

### 5.14.2 (2020-11-23)

### 5.14.1 (2020-11-23)

## 5.14.0 (2020-11-23)


### Features

* calculate elongation ([b09fe61](https://github.com/andrmoel/astronomy-bundle-js/commit/b09fe61396b9bb07288685ac35fd4f8dba12ab64))

## 5.13.0 (2020-11-23)


### Features

* **planets:** add methods getPositionAngleOfBrightLimb and isWaxing ([ffb1aaa](https://github.com/andrmoel/astronomy-bundle-js/commit/ffb1aaac181f843dad09bce5a7b0db106cf49681))

### 5.12.1 (2020-11-23)


### Bug Fixes

* rename getTopocentricEclipticSphericalCoordinates to getTopocentricEquatorialSphericalCoordinates ([23fa824](https://github.com/andrmoel/astronomy-bundle-js/commit/23fa824bb5a14acbc9be186fbe42a45435a85fd9))

## 5.12.0 (2020-11-23)


### Features

* **sun:** add method to get topocentric angular diameter ([c3dee28](https://github.com/andrmoel/astronomy-bundle-js/commit/c3dee28c472227fc7056a2c35d497d235c6e7bf4))

### 5.11.1 (2020-11-23)

## 5.11.0 (2020-11-23)


### Features

* **moon:** add physical observation data for topocentric observer ([465f048](https://github.com/andrmoel/astronomy-bundle-js/commit/465f048c6f77b88d6de707e193df1f2b50f88423))

### 5.10.1 (2020-11-21)


### Bug Fixes

* **coordinate-calc:** azimuth is measured from north instead of south ([56b84d1](https://github.com/andrmoel/astronomy-bundle-js/commit/56b84d1aa62b5cb0c080e0c00437a933524a95f9))

## 5.10.0 (2020-11-21)


### Features

* add method to get apparent topocentric coordinates ([f5e4cc3](https://github.com/andrmoel/astronomy-bundle-js/commit/f5e4cc36ceb59e03ddc9fbedc06404ed7166952f))

## 5.9.0 (2020-11-21)


### Features

* provide methods to get topocentric coordinates ([961c516](https://github.com/andrmoel/astronomy-bundle-js/commit/961c516a83c51b889a8aaee5fd4c1f6c44947fb6))

### 5.8.1 (2020-11-21)

## 5.8.0 (2020-11-20)


### Features

* **sun:** calculate rise and set for upper limb ([d390a08](https://github.com/andrmoel/astronomy-bundle-js/commit/d390a08a31a79daffd6f66d7b5fe942645609396))

### 5.7.4 (2020-11-20)


### Bug Fixes

* **rise-set:** consider when rise or set happens the day before ([dff7e19](https://github.com/andrmoel/astronomy-bundle-js/commit/dff7e19e0003366fd11951c99e87cca281210776))

### 5.7.3 (2020-11-20)


### Bug Fixes

* **rise-set:** fix 360 crossing in interpolating right ascension ([dc73a34](https://github.com/andrmoel/astronomy-bundle-js/commit/dc73a341379e1caab1690c6456d599a97daa2533))

### 5.7.2 (2020-11-20)


### Bug Fixes

* **rise-set:** consider when rise or set happens the next day ([8dd179f](https://github.com/andrmoel/astronomy-bundle-js/commit/8dd179f26f99bda8df99af2813a057da23fa0bc2))

### 5.7.1 (2020-11-20)


### Bug Fixes

* **rise-set:** fix interpolation when right ascension crosses 360° angle ([7461ebd](https://github.com/andrmoel/astronomy-bundle-js/commit/7461ebd2da53e6ddaf221a89ef19d7864b71de8d))

## 5.7.0 (2020-11-20)


### Features

* **rise-set:** calculate set and rise of sun, moon and planets ([4b21e3f](https://github.com/andrmoel/astronomy-bundle-js/commit/4b21e3fc1a6fbf43037bfed8f7dd34131de6de03))

### 5.6.2 (2020-11-20)

### 5.6.1 (2020-11-20)

## 5.6.0 (2020-11-18)


### Features

* **rise-set:** calculate transit of sun, moon and planets ([608e464](https://github.com/andrmoel/astronomy-bundle-js/commit/608e464ad5390aca3ef9b0f8c44eb9c0914d89ca))

### 5.5.3 (2020-11-17)

### 5.5.2 (2020-11-17)

### 5.5.1 (2020-11-17)

## 5.5.0 (2020-11-17)


### Features

* **moon:** get position angle of bright limb and check if moon is waxing ([72c74c0](https://github.com/andrmoel/astronomy-bundle-js/commit/72c74c069a6e78c5a16dc58b1990f83d28633882))

### 5.4.1 (2020-11-16)


### Bug Fixes

* **moon:** fix false method name for getApparentMagnitude ([8af2e6a](https://github.com/andrmoel/astronomy-bundle-js/commit/8af2e6a42f78d901eded67a26b83a0d53a46ab89))

## 5.4.0 (2020-11-16)


### Features

* **magnitude:** calculate apparent magnitude of moon and planets ([277d974](https://github.com/andrmoel/astronomy-bundle-js/commit/277d97426a20646450e966d106f4ef4f1f909bf6))

### 5.3.1 (2020-11-15)

## 5.3.0 (2020-11-15)


### Features

* **astronomical-object:** add new method getApparentGeocentricEclipticRectangularCoordinates ([ecf0e55](https://github.com/andrmoel/astronomy-bundle-js/commit/ecf0e55eaea97ad978832e0477f02c7c18232a82))

## 5.2.0 (2020-11-14)


### Features

* **sun:** return zero values for heliocentric position of sun ([c72ce61](https://github.com/andrmoel/astronomy-bundle-js/commit/c72ce61c85055b567004ab2722799ad36f3460cf))

## 5.1.0 (2020-11-14)


### Features

* calculate apparent position of moon, sun and planets ([243c400](https://github.com/andrmoel/astronomy-bundle-js/commit/243c400855ec729a0f66949b479669de762cb1ff))

## 5.0.0 (2020-11-14)


### ⚠ BREAKING CHANGES

* **planets:** Rename existing coordinate methods for planets, moon and sun

### Features

* **planets:** add more coordinate methods and rename existing methods ([7a2f3ed](https://github.com/andrmoel/astronomy-bundle-js/commit/7a2f3edf9d2c6341fc50c801f0f7e4e576ae2dc9))

### 4.1.2 (2020-11-12)

### 4.1.1 (2020-11-12)

## 4.1.0 (2020-11-12)


### Features

* **conjunction:** calculate conjunction in right ascension ([01a0e05](https://github.com/andrmoel/astronomy-bundle-js/commit/01a0e050812f7e8e40aa4ae08fb545bbb3a50274))

## 4.0.0 (2020-11-12)


### ⚠ BREAKING CHANGES

* **moon:** Moon methods will return a Promise

* **moon:** return Promise when calculating position ([943a7f1](https://github.com/andrmoel/astronomy-bundle-js/commit/943a7f19adafaee1b24b9591aed1803e0a7fa8d0))

### 3.4.1 (2020-11-11)

## 3.4.0 (2020-11-08)


### Features

* **solar-eclipse:** check if solar eclipse exists ([0ad149a](https://github.com/andrmoel/astronomy-bundle-js/commit/0ad149aa03ae8e892e5f0a816f132545ee6e8b23))

## 3.3.0 (2020-11-07)


### Features

* **angle-calc:** allow short notation of angles ([4885d8f](https://github.com/andrmoel/astronomy-bundle-js/commit/4885d8fdb8319701eb522301e993c09f7af3abfb))

## 3.2.0 (2020-11-07)


### Features

* **sun:** use VSOP87 theory to calculate position of the sun ([5d1d31b](https://github.com/andrmoel/astronomy-bundle-js/commit/5d1d31b83b0cdde410187b482ef70307c22910f9))

### 3.1.1 (2020-11-07)

## 3.1.0 (2020-11-07)


### Features

* **earth:** calculate earth position with VSOP87 instead of using planet calculation ([0058e28](https://github.com/andrmoel/astronomy-bundle-js/commit/0058e288ad6d4b7b30467baa2ff1c905250c7b67))

### 3.0.2 (2020-11-07)

### 3.0.1 (2020-11-07)


### Bug Fixes

* **observation-calc:** phase angle must be normalized to base 180° ([81f7c50](https://github.com/andrmoel/astronomy-bundle-js/commit/81f7c506e189bab37d1bce833fcc14f48ac73b0a))

## 3.0.0 (2020-11-07)


### ⚠ BREAKING CHANGES

* **moon:** Rename method

* **moon:** rename getIllumination method to getIlluminatedFraction ([f35e761](https://github.com/andrmoel/astronomy-bundle-js/commit/f35e761acfe709483b1664ba80d45283bc9dcfaf))

## 2.29.0 (2020-11-07)


### Features

* **moon:** add method for angular diameter ([b3a1778](https://github.com/andrmoel/astronomy-bundle-js/commit/b3a1778e2799102b37a27f08928b68ccef8306f8))

### 2.28.1 (2020-11-06)

## 2.28.0 (2020-11-06)


### Features

* **planets:** add methods to get distance to earth and angle diameter ([a56deb9](https://github.com/andrmoel/astronomy-bundle-js/commit/a56deb986ee71f52a9776551493380f935dfab62))

## 2.27.0 (2020-11-06)


### Features

* **planets:** add methods to calculate phase angle and illuminated fraction ([b3ad920](https://github.com/andrmoel/astronomy-bundle-js/commit/b3ad92086b134a4ba19eb4eabf573064576d5233))

### 2.26.1 (2020-11-06)

## 2.26.0 (2020-11-05)


### Features

* **planets:** add new method to calculate apparent geocentric equatorial coordinates ([67b7492](https://github.com/andrmoel/astronomy-bundle-js/commit/67b7492582c4fb3d52c4804b8d2c0f594973b4f4))

### 2.25.2 (2020-11-05)

### 2.25.1 (2020-11-04)

## 2.25.0 (2020-11-04)


### Features

* **cache:** add calculation cache ([ad38ca7](https://github.com/andrmoel/astronomy-bundle-js/commit/ad38ca779b978877709d9cebb6109425a8357eff))

### 2.24.1 (2020-11-01)

## 2.24.0 (2020-11-01)


### Features

* **moon:** add calculations for upcoming moon phases ([3e63bd1](https://github.com/andrmoel/astronomy-bundle-js/commit/3e63bd17d4540a0593b6bb29173f8f64b0f2ad64))

## 2.23.0 (2020-11-01)


### Features

* **time-of-interest:** add function to get year in decimal ([e60f44d](https://github.com/andrmoel/astronomy-bundle-js/commit/e60f44d374459c4c15b9a7f7dc1bf9a9ffbd19dd))

### 2.22.1 (2020-11-01)

## 2.22.0 (2020-11-01)


### Features

* **moon:** add calculation of phase angle and illumination ([23175c4](https://github.com/andrmoel/astronomy-bundle-js/commit/23175c41ab3af5413e5af407fbfc0b61ba62a9b4))

## 2.21.0 (2020-10-26)


### Features

* **angle:** format angle string with spaces ([7323dde](https://github.com/andrmoel/astronomy-bundle-js/commit/7323dde182042c9116873cbca59c1893cd6e6075))

### 2.20.2 (2020-10-26)

### 2.20.1 (2020-10-26)

## 2.20.0 (2020-10-26)


### Features

* **earth:** add earh object with nutation and obliquity calculations ([548bd68](https://github.com/andrmoel/astronomy-bundle-js/commit/548bd6864b1472428409ca39acee082297895c75))

### 2.19.5 (2020-10-26)

### 2.19.4 (2020-10-26)

### 2.19.3 (2020-10-26)

### 2.19.2 (2020-10-26)

### 2.19.1 (2020-10-26)

## 2.19.0 (2020-10-25)


### Features

* **time:** add calculations for LMST and LAST ([ee7d941](https://github.com/andrmoel/astronomy-bundle-js/commit/ee7d94147ad5665b291a91a3195aa0b23ba78e76))

## 2.18.0 (2020-10-25)


### Features

* **time:** add greenwich sidereal time and deltaT calculations ([271432c](https://github.com/andrmoel/astronomy-bundle-js/commit/271432cc3684673a30c2d882c1c13d9ad4d23f49))

## 2.17.0 (2020-10-25)


### Features

* **time:** add greenwich sidereal time and deltaT calculations ([9a5c5a9](https://github.com/andrmoel/astronomy-bundle-js/commit/9a5c5a9e2d2ed04035d07cd43f971858b5cd47fe))

## 2.16.0 (2020-10-25)


### Features

* **time-of-interest:** add date functions ([7cb214d](https://github.com/andrmoel/astronomy-bundle-js/commit/7cb214d763bffe0eaddb234bb7018e914ea9dd7c))

### 2.15.4 (2020-10-25)

### 2.15.3 (2020-10-24)

### 2.15.2 (2020-10-23)

### 2.15.1 (2020-10-23)

## 2.15.0 (2020-10-23)


### Features

* **moon:** add coordinate function to moon object ([dd9a4c3](https://github.com/andrmoel/astronomy-bundle-js/commit/dd9a4c3b59d5ccd4e2d6f7a60288018831585d70))

## 2.14.0 (2020-10-23)


### Features

* **moon:** add calculation of radius vector ([3628726](https://github.com/andrmoel/astronomy-bundle-js/commit/3628726201617964616bf7f21b275f669583fd79))

## 2.13.0 (2020-10-23)


### Features

* **coordinates:** transform ecliptic to equatorial and vice versa ([fc29114](https://github.com/andrmoel/astronomy-bundle-js/commit/fc2911424cf32403b0e20a3885dda305b508c5ec))

### 2.12.1 (2020-10-23)

## 2.12.0 (2020-10-22)


### Features

* **sun:** add sun object ([e146123](https://github.com/andrmoel/astronomy-bundle-js/commit/e146123bc8e981d64f5264704b81756a36a4ab2f))

## 2.11.0 (2020-10-22)


### Features

* **sun:** add calculations for right scension and declination ([9424c87](https://github.com/andrmoel/astronomy-bundle-js/commit/9424c871360efcbcc5b86146fff592cbffae9d0a))

## 2.10.0 (2020-10-22)


### Features

* **time-of-interest:** create time of interest from default export ([0577954](https://github.com/andrmoel/astronomy-bundle-js/commit/0577954c052b191ed71d6c6459f97d55bed62af4))

## 2.9.0 (2020-10-22)


### Features

* **time-of-interest:** create time of interest from default export ([990844f](https://github.com/andrmoel/astronomy-bundle-js/commit/990844fb9270c5f15549e1bd0ad07c47451131eb))

### 2.8.3 (2020-10-22)

### 2.8.2 (2020-10-22)

### 2.8.1 (2020-10-22)

## 2.8.0 (2020-10-22)


### Features

* **astronomical-object:** use current time when creating astronomical object ([13d81f3](https://github.com/andrmoel/astronomy-bundle-js/commit/13d81f320ca98dc59cfe998ec683171ebc550382))

## 2.7.0 (2020-10-22)


### Features

* **moon:** create moon object ([0a3cc34](https://github.com/andrmoel/astronomy-bundle-js/commit/0a3cc3432f608ae825b9414d04c5865533987e46))

### 2.6.1 (2020-10-21)

## 2.6.0 (2020-10-21)


### Features

* **time-of-interest:** add time of interest ([ff858b0](https://github.com/andrmoel/astronomy-bundle-js/commit/ff858b04a9c75586b850f85be0f327ba0330291a))

### 2.5.9 (2020-10-21)

### 2.5.8 (2020-10-21)


### Bug Fixes

* **github-actions:** lib directory does not exists anymore ([a19f376](https://github.com/andrmoel/astronomy-bundle-js/commit/a19f376c8d9c69fd15733fcdfab2466017bede9b))

### 2.5.7 (2020-10-21)

### 2.5.6 (2020-10-21)

### 2.5.5 (2020-10-21)

### 2.5.4 (2020-10-21)

### 2.5.3 (2020-10-19)

### 2.5.2 (2020-10-19)

### 2.5.1 (2020-10-19)


### Bug Fixes

* **earth:** add earth constants ([c6a1fbf](https://github.com/andrmoel/astronomy-bundle-js/commit/c6a1fbf6a85b5f81f2e89dd7d774aa7a317e37a5))

## 2.5.0 (2020-10-19)


### Features

* **moon:** calculate mean elongation, mean anomaly and argument of latitude ([a3acb78](https://github.com/andrmoel/astronomy-bundle-js/commit/a3acb78aea34cd4f7273709b2af2fca22fe074bc))

## 2.4.0 (2020-10-19)


### Features

* **sun:** add sun calculations ([a903533](https://github.com/andrmoel/astronomy-bundle-js/commit/a903533996a01f4714ebc34d5165699012096527))

## 2.3.0 (2020-10-19)


### Features

* **time:** add time function to calculate julian day ([fb624dc](https://github.com/andrmoel/astronomy-bundle-js/commit/fb624dca7617efabc3a38e245b478c5dbf940574))

## 2.2.0 (2020-10-19)


### Features

* **angle:** transform into time and angle string ([2f64dc8](https://github.com/andrmoel/astronomy-bundle-js/commit/2f64dc807398fb8a75d37c5b52178244320b0844))

### 2.1.2 (2020-10-19)

### 2.1.1 (2020-10-19)

## 2.1.0 (2020-10-19)


### Features

* **angle:** add angle functions ([a4d9a02](https://github.com/andrmoel/astronomy-bundle-js/commit/a4d9a020764cb2053ffcefb7c83fbbadc791270e))

### 2.0.2 (2020-10-16)

### 2.0.1 (2020-10-16)

## 2.0.0 (2020-10-16)


### ⚠ BREAKING CHANGES

* **node:** use astronomy-bundle instead of astronomy-bundle-js

* **node:** rename package ([6ddf574](https://github.com/andrmoel/astronomy-bundle-js/commit/6ddf574710cdecd11f6170cc8b1a91a071520222))

### 1.0.5 (2020-10-15)

### 1.0.4 (2020-10-15)

### 1.0.3 (2020-10-15)

### 1.0.2 (2020-10-15)


### Bug Fixes

* **github-actions:** fix syntax in github-actions ([3534be2](https://github.com/andrmoel/astronomy-bundle-js/commit/3534be260845629f94c913b8336e8aabb6cdb0ec))

### 1.0.1 (2020-10-15)
