<!DOCTYPE html>
<html>
  <head>
    <title>DUMMY PRODUCTS PAGE</title>
    <script src="3b-products.js"></script>
    <link rel="stylesheet" href="3c-products.css"/>
  </head>
  <body>
    <div id="demo"><?php
    // (A) CORE LIBRARY + USER ID
    require "2-core.php";
    $uid = 901; // FIXED FOR DEMO, USE SESSION USER ID IN YOUR PROJECT

    // (B) UPDATE STAR RATINGS
    if (isset($_POST["pid"]) && isset($_POST["stars"])) {
      if ($_STARS->save($_POST["pid"], $uid, $_POST["stars"])) {
        echo "<div class='note'>Rating Updated</div>";
      } else { echo "<div class='note'>$_STARS->error</div>"; }
    }

    // (C) GET RATINGS
    $average = $_STARS->avg(); // AVERAGE RATINGS
    $ratings = $_STARS->get($uid); // RATINGS BY CURRENT USER

    // (D) OUTPUT DUMMY PRODUCTS
    $products = [
      "1" => ["name" => "Foo Bar", "price" => 123.45],
      "2" => ["name" => "Fork Bar", "price" => 24.56],
      "3" => ["name" => "Goo Bar", "price" => 8.76],
      "4" => ["name" => "Joo Bar", "price" => 2.57]
    ];
    foreach ($products as $pid=>$pdt) { ?>
    <div class="pRow">
      <div class="pName"><?=$pdt["name"]?></div>
      <div class="pPrice">$<?=$pdt["price"]?></div>
      <div class="pDesc">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>
      <div class="pReview">Customer Review</div>
      <div class="pStar" data-pid="<?=$pid?>"><?php
        $rate = isset($ratings[$pid]) ? $ratings[$pid] : 0 ;
        for ($i=1; $i<=5; $i++) {
          $css = $i<=$rate ? "star" : "star blank" ;
          echo "<div class='$css' data-i='$i'></div>";
        }
      ?></div>
      <div class="pStat">
        <?=$average[$pid]["avg"]?> out of 5 stars.
      </div>
      <div class="pStat">
        <?=$average[$pid]["num"]?> customer ratings.
      </div>
    </div>
    <?php }
    ?></div>

    <!-- (E) HIDDEN FORM TO UPDATE STAR RATING -->
    <form id="ninForm" method="post" target="_self">
      <input id="ninPdt" type="hidden" name="pid"/>
      <input id="ninStar" type="hidden" name="stars"/>
    </form>
  </body>
</html>
