<?php
	class Ajout
	{
		var $liste_sites;
		var $liste_noire;
		
		function Ajout()
		{
			$this->liste_sites = new Liens('txt/liens.txt');
			$this->liste_noire = new ListeNoire('txt/liste_noire.txt');
		}
		
		function ajouterSiteGet()
		{
			$this->liste_sites->ajouterLien($_GET['url'], $_GET['titre'], $_GET['description'], $_GET['mail'], $_GET['retour']);
			
			$erreur = null;
			
			if($_GET['mail'] != null)
			{
				$titre = (get_magic_quotes_gpc() == OUI) ? stripslashes($_GET['titre']) : $_GET['titre'];
				
				$headers  = 'MIME-Version: 1.0' . "\r\n";
				$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
				$headers .= 'From: ' . $GLOBALS['config']['mail_admin'] . "\r\n";
				$headers .= 'Reply-To: ' . $GLOBALS['config']['mail_admin'] . "\r\n";
				$headers .= 'X-Mailer: PHP/' . phpversion();
				
				if(!mail($_GET['mail'], 'Le site a t accept sur ' . $GLOBALS['config']['nom_du_site'] . ' !', 'Flicitations ! Votre site ' . $titre . ' a t ajout sur ' . $GLOBALS['config']['nom_du_site'] . ' !', $headers))
					$erreur = 'Le site a t ajout, mais une erreur est survenue lors de l\'envoi du mail !';
			}
			
			$this->liste_sites->enregistrer();
			
			return $erreur;
		}
		
		function ajouterSite()
		{
			$erreur = null;
			
			$url = $_POST['url'];
			if(!preg_match('#^https?://#',$url) OR strlen($url) < 12)
				$erreur = 'Merci d\'entrer une url valide !';
			
			$titre = (get_magic_quotes_gpc() == OUI) ? stripslashes($_POST['titre']) : $_POST['titre'];
			if($titre == null)
				$erreur = 'Merci d\'entrer un titre !';
			
			$description = (get_magic_quotes_gpc() == OUI) ? stripslashes($_POST['description']) : $_POST['description'];
			if($description == null)
				$erreur = 'Merci d\'entrer une description !';
			
			$url_retour = $_POST['url_retour'];
			if($_POST['lien_retour'] != 'on')
			{
				if($url_retour != null)
				{
					if($GLOBALS['config']['lien_retour'] == PARTOUT AND (!preg_match('#^https?://#', $url_retour) OR strlen($url_retour) < 12))
						$erreur = 'Merci d\'entrer une url valide de la page contenant le lien de retour !';
					if($GLOBALS['config']['lien_retour'] == ACCUEIL)
						$url_retour = preg_replace('#^http(s)?://([^/]+)/?.*$#', 'http$1://$2', $url_retour);
				}
			}
			
			$mail = $_POST['mail'];
			if(!preg_match('#^[a-z0-9._-]+@[a-z0-9._-]{2,}\.[a-z]{2,4}$#', $mail) AND $mail != null)
				$erreur = 'Merci d\'entrer une adresse e-mail valide !';
			
			if($this->liste_noire->estPresent($url) AND $erreur == null)
				$erreur = 'Ce site est sur liste noire. Voulez-vous quand mme l\'ajouter ? <a href="?url=' . urlencode($url) . '&titre=' . urlencode($titre) . '&description=' . urlencode($description) . '&mail=' . urlencode($mail) . '&retour=' . urlencode($retour) . '">Oui, je veux</a>';
			
			if($this->liste_sites->estPresent($url,false))
				$erreur = 'Ce site est dj inscrit !';
			
			if($erreur == null)
			{
				if($url_retour != null)
				{
					$chargement = file_get_contents($url_retour);
					if(!$chargement)
						$erreur = 'Impossible de charger l\'url contenant le lien de retour !';
					if(!preg_match('#<a href="' . $GLOBALS['config']['url_du_site_principal'] . '">#i',$chargement))
						$erreur = 'Le lien de retour n\'est pas prsent sur la page spcifie !';
				}
				
				if($erreur == null)
				{
					$this->liste_sites->ajouterLien($url,$titre,$description,$mail,$url_retour);
					
					if($mail != null)
					{
						$headers  = 'MIME-Version: 1.0' . "\r\n";
						$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
						$headers .= 'From: ' . $GLOBALS['config']['mail_admin'] . "\r\n";
						$headers .= 'Reply-To: ' . $GLOBALS['config']['mail_admin'] . "\r\n";
						$headers .= 'X-Mailer: PHP/' . phpversion();
						
						if(!mail($mail, 'Le site a t accept sur ' . $GLOBALS['config']['nom_du_site'] . ' !', 'Flicitations ! Votre site a t ajout sur ' . $GLOBALS['config']['nom_du_site'] . ' !', $headers))
							$erreur = 'Le site a t ajout, mais une erreur est survenue lors de l\'envoie du mail !';
					}
					
					$this->liste_sites->enregistrer();
				}
			}
			
			if($erreur == null)
				return '<span class="title">Flicitations</span><hr />Le site a t ajout avec succs !<br /><br />';
			
			return '<span class="title">Erreur</span><hr />' . $erreur . '<br /><br />';
		}
	}
?>