<?php
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Suppression d'une personne</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   include 'INCLUDE/POO_include_sprog_commun_web.php';
   define("CONTEXTE","Suppression");
   // -- Fonction de chargement dynamique des classes ---
   function __autoload($NomClasse) {
     require $NomClasse . '_Classe.php';
   }
   // --- Récupération des objets LPers ---
   if (isset($_SESSION['ListeDesPersonnes'])) {
      $ListeDesPersonnes = $_SESSION['ListeDesPersonnes'];
   }
   $nbpersonnes = $ListeDesPersonnes->CompteLPers();
   // --------------------------------------------------------------
   // Cette page peut être appelée de plusieurs manières différentes
   // --------------------------------------------------------------
   if (!empty($_POST['ConfirmerSuppression']))
   {
    // --------------------------------------------------------------
    // Traitement de la réponse à la confirmation de suppression
    // --------------------------------------------------------------
    $RepSuppr=$_POST['RepSuppr'];
    // --- Protection de l'injection HTML ---
    $RepSuppr = strip_tags($RepSuppr);
    if ($RepSuppr == "oui")
    {// --------------------------------
     // La réponse est oui : on supprime
     // --------------------------------
     $NumSuppr=$_SESSION['NumSuppr'];
     $UnePersonne      = $ListeDesPersonnes->GetUnePersonne($NumSuppr);
     $ListeUnePersonne = new LPers()   ;
     $ListeUnePersonne->AjoutUnePersonne($UnePersonne,$NumSuppr) ;
     $ListeUnePersonne->AfficheLPers("Cette personne a &eacute;t&eacute; supprim&eacute;e") ;
     unset($ListeUnePersonne);
     $ListeDesPersonnes->SupprLPers($NumSuppr);
     $_SESSION['ListeDesPersonnes']=$ListeDesPersonnes ;
     // -- on memorise qu'il faut faire une sauvegarde --
     $_SESSION['sauvegarde_a_faire']=true ;
    }
    else
    {
     // ------------------------------------
     // La réponse est non : on ne fait rien
     // ------------------------------------
      $messageTexte="Aucune personne n'a &eacute;t&eacute; supprim&eacute;e !";
      AffichMessage(CONTEXTE,$messageTexte);
    }
   }
   elseif (!empty($_POST['ChoixSupprPersonne']))
   {
    // --------------------------------------------------------------
    // cas où la personne à supprimer a été sélectionnée
    // on demande la confirmation de la suppression
    // --------------------------------------------------------------
    if ((empty($_POST['NumSuppr'])) && ($_POST['NumSuppr'] != 0))
    {
      $messageTexte="Aucune personne n'a &eacute;t&eacute; s&eacute;lectionn&eacute;e !";
      AffichMessage(CONTEXTE,$messageTexte);
    }
    else
    {
     $NumSuppr=$_POST['NumSuppr']             ;
     // --- Protection de l'injection HTML ---
     $NumSuppr = strip_tags($NumSuppr);
     $_SESSION['NumSuppr']=$NumSuppr;
     $UnePersonne      = $ListeDesPersonnes->GetUnePersonne($NumSuppr);
     $ListeUnePersonne = new LPers()   ;
     $ListeUnePersonne->AjoutUnePersonne($UnePersonne,$NumSuppr) ;
     $ListeUnePersonne->AfficheLPers("Cette personne va &ecirc;tre supprim&eacute;e") ;
     unset($ListeUnePersonne);
     ?>
     <br/>
     <!-- <form action="POO_suppression_web.php" method="post"> -->
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
     <fieldset>
      <legend>Confirmation de la suppression</legend><br/>
      Merci de confirmer la suppression de cette personne :<br/>
      Oui <input type="radio" name="RepSuppr" value="oui"> 
      Non <input type="radio" name="RepSuppr" value="non" checked="checked"> <br/><br/>
      <input type="submit" name="ConfirmerSuppression" value="Confirmer" />
      </fieldset>
     </form>
     <?php
    }
   }
   elseif (!empty($_POST['RechercherCritere']))
   {
    // --------------------------------------------------------------
    // cas où le formulaire de saisie a été validé et on appelle
    // une nouvelle fois ce programme avec les données du formulaire
    // on affiche un formulaire pour sélectionner la personne à supprimer
    // parmi la liste des personnes affichées
    // --------------------------------------------------------------
    if (empty($_POST['ValRech']))
    {
      $messageTexte="Aucune valeur de recherche n'a &eacute;t&eacute; saisie !";
      AffichMessage(CONTEXTE,$messageTexte);
    }
    else
    {
     $CritRech = $_POST['CritRech'];
     $ValRech  = $_POST['ValRech'] ;
     // --- Protection de l'injection HTML ---
     $CritRech = strip_tags($CritRech);
     $ValRech  = strip_tags($ValRech) ;
     if (($CritRech == "Nom") || ($CritRech == "Prenom") )
     { // normamisation
       $ValRech=normalisation_nom($ValRech) ;
     }
     // --- Recherche ---
     $TabCriteres=array($CritRech,$ValRech);
     $ListeDesPersonnes->RechCritLPers($TabCriteres);
     $nb_personnes_trouvees=$ListeDesPersonnes->CompteLRechPers();
     if ($nb_personnes_trouvees == 0)
     {
      $messageTexte="La recherche pour $CritRech=$ValRech n'a trouv&eacute; aucune personne !";
      AffichMessage(CONTEXTE,$messageTexte);
     }
     else
     {
       $ListeDesPersonnes->AfficheLRechPers("Liste des personnes trouvées");
       // affichage du formulaire de saisie de la personne à supprimer
        ?>
        <br/>
        <!-- <form action="POO_suppression_web.php" method="post"> -->
        <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
         <fieldset>
         <legend>Saisissez le Num&eacute;ro de la personne &agrave; supprimer :</legend><br/>
         Entrez le <b>Num&eacute;ro</b> de la personne &agrave; supprimer : <input type="text" name="NumSuppr" size="20" maxlength="20" autofocus/><br/><br/>
         <input type="submit" name="ChoixSupprPersonne" value="Supprimer" />
         <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
         <input type="reset" value="Effacer le formulaire" />
         </fieldset>
        </form>
        <?php
     }
    }
   }
   else
   {
    // -----------------------------------------------
    // cas où on doit afficher le formulaire de saisie
    // pour rechercher la personne à supprimer
    // -----------------------------------------------
    if ($nbpersonnes == 0)
    {
      $messageTexte="Actuellement il n'y a aucune personne en mémoire !";
      AffichMessage(CONTEXTE,$messageTexte);
    }
    else
    {  // --- formulaire de saisie des informations pour la recherche
       formulaire_saisie_criteres() ;
    }
   }
   // ----------------------------------
   // -- lien pour retourner au menu ---
   // ----------------------------------
   include 'INCLUDE/POO_include_retour_menu_web.php';
   ?>
 </body>
</html>
