<?php
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Sauvegarde de la liste des personnes</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   include 'INCLUDE/POO_include_sprog_commun_web.php';
   define("CONTEXTE","Sauvegarde");
   // -- Fonction de chargement dynamique des classes ---
   function __autoload($NomClasse) {
     require $NomClasse . '_Classe.php';
   }
   // --- Récupération des objets LPers ---
   if (isset($_SESSION['ListeDesPersonnes'])) {
      $ListeDesPersonnes = $_SESSION['ListeDesPersonnes'];
   }
   // ------------------------------------------------------------------------------
   // Si l'affichage de la page provient d'un sauvegarder, on effectue la sauvegarde
   // ------------------------------------------------------------------------------
   if (!empty($_POST['sauvegarder']))
   { // --- on récupère le nom du fichier ---
     if (isset($_POST['NomFichier'])) $NomFichier = $_POST['NomFichier'] ;
     else $NomFichier     = ''     ;
     // --- Prétraitement du nom du fichier ---
     $NomFichier = pretraitement_nomF($NomFichier);
     if (empty($NomFichier))
     {
       $messageTexte="Sauvegarde impossible, le nom du fichier n'est pas indiqu&eacute; !";
       AffichMessage(CONTEXTE,$messageTexte);
     }
     else
     {
      // --- Construction du nom du fichier ---
      $NomFichier = construction_nomF($NomFichier);
      // --- Tri du tableau ---
      $ListeDesPersonnes->TriLPers();
      $_SESSION['ListeDesPersonnes'] = $ListeDesPersonnes ; 
      // --- Appel de la procédure de sauvegarde ---
      $nb_sauvegardes=$ListeDesPersonnes->SauveLPers($NomFichier) ;
      
echo "nb_sauvegardes=$nb_sauvegardes".WEB_EOL; 
      
      if ($nb_sauvegardes == AUCUN)
      {
       $tab_erreurs      = error_get_last()       ;
       $erreur_type      = $tab_erreurs['type']   ;
       $erreur_message   = $tab_erreurs['message'];
       $erreur_programme = $tab_erreurs['file']   ;
       $erreur_ligne     = $tab_erreurs['line']   ;
       $messageTexte="Erreur de sauvegarde dans le fichier $NomFichier".WEB_EOL;
       $messageTexte.="Erreur code : ".$erreur_type.WEB_EOL;
       $messageTexte.=$erreur_message.WEB_EOL;
      }
      else
      {
       $_SESSION['sauvegarde_a_faire']=false;
       $messageTexte="Sauvegarde de $nb_sauvegardes personnes dans le fichier $NomFichier";
      }
      AffichMessage(CONTEXTE,$messageTexte);
     }
   }
   // ---------------------------------------------------
   // Affichage du formulaire de saisie du nom du fichier
   // ---------------------------------------------------
   else
   {
    if (isset($_SESSION['ListeDesPersonnes'])) // on vérifie que la liste des personne existe = au moins une saisie
    {
      $nb_sauvegardes=$ListeDesPersonnes->CompteLPers();
      if ($nb_sauvegardes != 0)
      {// -- on affiche le formulaire de saisie du nom du fichier de sauvegarde    
       ?>
       <br/>
       <!-- <form action="POO_sauvegarde_web.php" method="post"> -->
       <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
        <fieldset>
        <legend>Saisissez le nom du fichier de sauvegarde :</legend><br/>
        Entrez le nom du fichier (ex : liste_personnes) : <input type="text" name="NomFichier" size="20" maxlength="20" autofocus/><br/><br/>
        <input type="submit" name="sauvegarder" value="Sauvegarder cette liste" />
        <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
        <input type="reset" value="Effacer le nom du fichier" />
        </fieldset>
       </form>
       <?php
      }
      else
      {
       $messageTexte="Aucune donn&eacute;e &agrave; sauvegarder";
       AffichMessage(CONTEXTE,$messageTexte);
      }
    }
    else
    {
       $messageTexte="Aucune donn&eacute;e &agrave; sauvegarder";
       AffichMessage(CONTEXTE,$messageTexte);
    }
   }
   // ----------------------------------
   // -- lien pour retourner au menu ---
   // ----------------------------------
   include 'INCLUDE/POO_include_retour_menu_web.php';
   ?>
 </body>
</html>