<?php
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Saisie de plusieurs personnes</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
	<link href="CSS/presentation_liste_personnes.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   include 'INCLUDE/POO_include_sprog_commun_web.php';
   define("CONTEXTE","Saisie");
   // -- Fonction de chargement dynamique des classes ---
   function __autoload($NomClasse) {
     require $NomClasse . '_Classe.php';
   }
   // --- Récupération ou création des objets LPers ---
   if (isset($_SESSION['ListeDesPersonnes']))
      $ListeDesPersonnes = $_SESSION['ListeDesPersonnes'];
   else {
       $ListeDesPersonnes = new LPers();
       $_SESSION['ListeDesPersonnes'] = $ListeDesPersonnes ; 
   }
   if (isset($_SESSION['ListeDeLaSaisie']))
      $ListeDeLaSaisie = $_SESSION['ListeDeLaSaisie'];
   else {
       $ListeDeLaSaisie = new LPers();
       $_SESSION['ListeDeLaSaisie'] = $ListeDeLaSaisie ; 
   }       
   if (!empty($_POST['terminer']))
   {
    // ----------------------------------
    // --- cas de la fin de la saisie ---
    // ----------------------------------
    if ($ListeDeLaSaisie->CompteLPers() != 0) {
       $ListeDeLaSaisie->TriLPers();
       $ListeDesPersonnes->AjoutLPers($ListeDeLaSaisie);      
    }
    $ListeDeLaSaisie->AfficheLPers("Liste des personnes saisies");
    $ListeDesPersonnes->TriLPers();
    unset($ListeDeLaSaisie);
    unset($_SESSION['ListeDeLaSaisie']);
    // --- Lien pour le retour au menu principal ---
    include 'INCLUDE/POO_include_retour_menu_web.php';
   }
   // -----------------------------------------------------------------------
   // sinon on affiche le formulaire et les informations complémentaires 
   // -----------------------------------------------------------------------
   else   
   {
     ?>
     <!-- --------------------------------
          --- on affiche le formulaire ---
          -------------------------------- -->
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
      <fieldset>
      <legend>Saisissez les donn&eacute;es d'une nouvelle personne :</legend><br/>
      Entrez un nom : <input type="text" name="Nom" size="20" maxlength="20" placeholder="Dupont de Nemours"/><br/><br/>
      Entrez un pr&eacute;nom : <input type="text" name="Prenom" size="40" maxlength="40" placeholder="Jean Charles"/><br/><br/>
      Entrez un &acirc;ge : <input type="text" name="Age" size="3" maxlength="3" pattern="[1-9][0-9]{1,3}" placeholder="28"/><br/><br/>
      <input type="submit" name="valider" value="Valider cette personne" />
      <!-- on ajoute le bouton terminer pour terminer la saisie  -->
      <input type="reset" value="Effacer le formulaire" />
      <input type="submit" name="terminer" value="Terminer la Saisie" />
      </fieldset>
     </form>
     <?php
      include 'INCLUDE/POO_include_retour_menu_web.php';
     // -----------------------------------------------------------------
     // on affiche sous le formulaire le résultat du traitement précédent
     // - soit le rangement dans le tableau ListeDesPersonnes
     // - soit un message d'erreur (sauf pour le premier affichage) 
     // -----------------------------------------------------------------
     // --- on récupère les valeurs saisies ---
     if (isset($_POST['Nom'])) $Nom = $_POST['Nom'] ;
     else $Nom     = ''     ;
     if (isset($_POST['Prenom'])) $Prenom = $_POST['Prenom'] ;
     else $Prenom     = ''  ;
     if (isset($_POST['Age'])) $Age = $_POST['Age'] ;
     else $Age     = ''     ;
     // --- Protection de l'injection HTML ---
     $Nom    = strip_tags($Nom)    ;
     $Prenom = strip_tags($Prenom) ;
     $Age    = strip_tags($Age)    ;    
     // --- On conserve les valeurs initiales ---
     $InitNom    = $Nom    ;
     $InitPrenom = $Prenom ;
     $InitAge    = $Age    ;
     // si ce n'est pas la première saisie
     if ($_SESSION['Afficher_Messages_Champs'])
     {// ---------------------------------------
      // on vérifie qu'il n'y a aucun champ vide
      // ---------------------------------------
      if (!empty($InitNom) && !empty($InitPrenom) && !empty($InitAge))
      {// ---------------------------------------
       // on vérifie la validité des chaque champ
       // ---------------------------------------
       $retourValidationAge    = true ;
       $retourValidationNom    = true ;
       $retourValidationPrenom = true ;
       if (!empty($InitAge))
       {
        $InitAge=normalisation_numerique($InitAge)   ;
        $retourValidationAge=validation_Age($InitAge);
        if ($retourValidationAge)
        {
         $Age  = intval($InitAge) ;
        }
       }
       if (!empty($InitNom))
       {
        $InitNom=normalisation_nom($InitNom) ;
        $retourValidationNom=!empty($InitNom);
        if ($retourValidationNom)
        {
         $Nom  = $InitNom ;
        }
       }
       if (!empty($InitPrenom))
       {
        $InitPrenom=normalisation_nom($InitPrenom) ;
        $retourValidationPrenom=!empty($InitPrenom);
        if ($retourValidationPrenom)
        {
         $Prenom  = $InitPrenom ;
        }
       }
       // -------------------------------
       // si tous les champs sont valides
       // -------------------------------
       if (($retourValidationAge) && ($retourValidationNom) && ($retourValidationPrenom) )
       {
         $UnePersonne      = new Personne($Nom,$Prenom,$Age);
         $ListeUnePersonne = new LPers()   ;
         $ListeUnePersonne->AjoutUnePersonne($UnePersonne,CASE_NON_DEFINIE) ;
         $ListeUnePersonne->AfficheLPers("Derni&egrave;re personne saisie") ;
         unset($ListeUnePersonne);
         // -----------------------------------------------------------------
         // --- Rangement dans le tableau ListeDesPersonnes de la session ---
         // -----------------------------------------------------------------
         if (! isset($ListeDeLaSaisie))
            $ListeDeLaSaisie = new LPers()   ;
         $ListeDeLaSaisie->AjoutUnePersonne($UnePersonne,CASE_NON_DEFINIE) ;
         unset($UnePersonne);
         $_SESSION['ListeDeLaSaisie']=$ListeDeLaSaisie ;
         // -- on memorise qu'il faut faire une sauvegarde --
         $_SESSION['sauvegarde_a_faire']=true ;
       }
      }
      // -----------------------------------------------------------------
      // on affiche les éventuels messages d'erreur en cas de champs vides
      // -----------------------------------------------------------------
      else
      {
       $messageTexte="";
       if (empty($InitID))     $messageTexte.="Le champ Identifiant est vide".WEB_EOL;
       if (empty($InitNom))    $messageTexte.="Le champ Nom est vide".WEB_EOL;
       if (empty($InitPrenom)) $messageTexte.="Le champ Pr&eacute;nom est vide".WEB_EOL;
       if (empty($InitAge))    $messageTexte.="Le champ Age est vide".WEB_EOL;
       if ($InitAge == 0)      $messageTexte.="Le champ Age est invalide".WEB_EOL;
       AffichMessage(CONTEXTE,$messageTexte);
      }
     }
     // ------------------------------------------------------------------
     // ce n'est pas la première saisie : la variable indiquant d'afficher
     // les éventuels messages d'erreur est positionnée
     // ------------------------------------------------------------------
     else
     {
      $_SESSION['Afficher_Messages_Champs']=true;
     }
   }
   ?>
 </body>
</html>
