<?php
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Recherche par nom</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   include 'INCLUDE/POO_include_sprog_commun_web.php';
   define("CONTEXTE","Recherche par nom");
   // -- Fonction de chargement dynamique des classes ---
   function __autoload($NomClasse) {
     require $NomClasse . '_Classe.php';
   }
   // --- Récupération des objets LPers ---
   if (isset($_SESSION['ListeDesPersonnes'])) {
      $ListeDesPersonnes = $_SESSION['ListeDesPersonnes'];
   }
   $nbpersonnes = $ListeDesPersonnes->CompteLPers();
   // --------------------------------------------------------------
   // Cette page peut être appelée de deux manières différentes :
   // - une première fois : le formulaire doit être renseigné
   // - une deuxième fois : le formulaire a été renseigné et les valeurs sont transmises
   // --------------------------------------------------------------
   if (!empty($_POST['rechercher_nom']))
   {// --------------------------------------------------------------
    // cas où le formulaire a été validé et on appelle
    // une nouvelle fois ce programme avec les données du formulaire
    // --------------------------------------------------------------
     if (empty($_POST['NomRech']))
     {
      $messageTexte="Aucun nom n'a &eacute;t&eacute; saisi !";
      AffichMessage(CONTEXTE,$messageTexte);
     }
     else
     {
      $nom_recherche=$_POST['NomRech'];
      // --- Protection de l'injection HTML ---
      $nom_recherche = strip_tags($nom_recherche);
      $nom_recherche=normalisation_nom($nom_recherche) ;
      // --- recherche ---
      $TabCriteres=array('Nom',$nom_recherche);
      $ListeDesPersonnes->RechCritLPers($TabCriteres);
      $nb_personnes_trouvees=$ListeDesPersonnes->CompteLRechPers();
      if ($nb_personnes_trouvees == 0)
      {
       $messageTexte="La personne ayant le nom $nom_recherche n'a pas &eacute;t&eacute; trouv&eacute;e !";
       AffichMessage(CONTEXTE,$messageTexte);
      }
      else
      {
       $ListeDesPersonnes->AfficheLRechPers("Liste des personnes trouvées");
      }
     }
   }
   else
   {
    // -----------------------------------------------
    // cas où on doit afficher le formulaire de saisie
    // -----------------------------------------------
    if ($nbpersonnes == 0)
    {
       $messageTexte="Actuellement il n'y a aucune personne en mémoire !";
       AffichMessage(CONTEXTE,$messageTexte);
    }
    else
    {  // --- formulaire de saisie des informations pour la recherche
       ?>
       <br/>
       <!-- <form action="POO_recherche_nom_web.php" method="post"> -->
       <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
        <fieldset>
        <legend>Saisissez le nom de la personne &agrave; rechercher :</legend><br/>
        Entrez un nom (ex : Dupont) : <input type="text" name="NomRech" size="20" maxlength="20" autofocus/><br/><br/>
        <input type="submit" name="rechercher_nom" value="Rechercher" />
        <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
        <input type="reset" value="Effacer le formulaire" />
        </fieldset>
       </form>
       <?php
    }
   }
   // ----------------------------------
   // -- lien pour retourner au menu ---
   // ----------------------------------
   include 'INCLUDE/POO_include_retour_menu_web.php';
   ?>
 </body>
</html>
