<?php
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Recherche selon crit&egrave;res</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   include 'INCLUDE/POO_include_sprog_commun_web.php';
   define("CONTEXTE","Recherche par nom");
   // -- Fonction de chargement dynamique des classes ---
   function __autoload($NomClasse) {
     require $NomClasse . '_Classe.php';
   }
   // --- Récupération des objets LPers ---
   if (isset($_SESSION['ListeDesPersonnes'])) {
      $ListeDesPersonnes = $_SESSION['ListeDesPersonnes'];
   }
   $nbpersonnes = $ListeDesPersonnes->CompteLPers();
   // --------------------------------------------------------------
   // Cette page peut être appelée de deux manières différentes :
   // - une première fois : le formulaire doit être renseigné
   // - une deuxième fois : le formulaire a été renseigné et les valeurs sont transmises
   // --------------------------------------------------------------
   if (!empty($_POST['RechercherCritere']))
   {// --------------------------------------------------------------
    // cas où le formulaire a été validé et on appelle
    // une nouvelle fois ce programme avec les données du formulaire
    // --------------------------------------------------------------  
    $CritRech = $_POST['CritRech'];
    $ValRech  = $_POST['ValRech'] ;
    if (empty($_POST['ValRech']))
    {
      $messageTexte="Aucune valeur de recherche n'a &eacute;t&eacute; saisie ! ";
      AffichMessage(CONTEXTE,$messageTexte);
    }
    else
    {
     // --- Protection de l'injection HTML ---
     $CritRech = strip_tags($CritRech);
     $ValRech  = strip_tags($ValRech) ;
     if (($CritRech == "Nom") || ($CritRech == "Prenom") )
     { // normalisation
       $ValRech=normalisation_nom($ValRech) ;
     }
     // --- recherche ---
     $TabCriteres=array($CritRech,$ValRech);
     $ListeDesPersonnes->RechCritLPers($TabCriteres);
     $nb_personnes_trouvees=$ListeDesPersonnes->CompteLRechPers();
     if ($nb_personnes_trouvees == 0)
     {
      $messageTexte="La recherche pour $CritRech=$ValRech n'a trouv&eacute; aucune personne ! ";
      AffichMessage(CONTEXTE,$messageTexte);
     }
     else
     {
       $ListeDesPersonnes->AfficheLRechPers("Liste des personnes trouvées");
     }
    }
   }
   else
   {// -----------------------------------------------
    // cas où on doit afficher le formulaire de saisie
    // -----------------------------------------------
    if ($nbpersonnes == 0)
    {
      $messageTexte="Actuellement il n'y a aucune personne en mémoire !";
      AffichMessage(CONTEXTE,$messageTexte);
    }
    else
    {  // --- formulaire de saisie des informations pour la recherche
       formulaire_saisie_criteres() ;
    }
   }
   // ----------------------------------
   // -- lien pour retourner au menu ---
   // ----------------------------------
   include 'INCLUDE/POO_include_retour_menu_web.php';
   ?>
 </body>
</html>
