<?php
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Quitter</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   if (!isset($_SESSION['sauvegarde_a_faire'])) $sauvegarde_a_faire=false;
   else $sauvegarde_a_faire=$_SESSION['sauvegarde_a_faire'];
   include 'INCLUDE/POO_include_sprog_commun_web.php';
   define("CONTEXTE","Fin de session");
   // -- Fonction de chargement dynamique des classes ---
   function __autoload($NomClasse) {
     require $NomClasse . '_Classe.php';
   }
   // --- Récupération des objets LPers ---
   if (isset($_SESSION['ListeDesPersonnes'])) {
      $ListeDesPersonnes = $_SESSION['ListeDesPersonnes'];
   }
   $nbpersonnes = $ListeDesPersonnes->CompteLPers();
   if ($sauvegarde_a_faire)
   {// -------------------------------------------------------
    // traitement du cas où les données ont été modifiées
    // il faut vérifier si une sauvegarde doit être faite avant le chargement
    // -------------------------------------------------------
    if (!empty($_POST['verif_sauvegarde']))
    {// -------------------------------------------------------
     // cas où la sauvegarde a peut être été demandée et le nom du fichier indiqué
     // -------------------------------------------------------
     // --- On récupère la réponse ---
     $Reponse_Sauvegarde    = $_POST['Reponse_Sauvegarde']    ;
     // --- Protection de l'injection HTML ---
     $Reponse_Sauvegarde = strip_tags($Reponse_Sauvegarde);
     if ($Reponse_Sauvegarde == "oui")
     { // ----------------------------
       // La sauvegarde a été demandée
       // ----------------------------
       // --- on récupère le nom du fichier ---
       if (isset($_POST['NomFichier'])) $NomFichier = $_POST['NomFichier'] ;
       else $NomFichier     = ''     ;
       // --- Protection de l'injection HTML ---
       $NomFichier = strip_tags($NomFichier);
       if (empty($NomFichier))
       {
        $messageTexte="Sauvegarde impossible, le nom du fichier n'est pas indiqu&eacute; !";
        AffichMessage(CONTEXTE,$messageTexte);
        redirection_delai("quitter","POO_quitter_web.php",5);
       }
       else
       {
        // --- Construction du nom du fichier ---
        $NomFichier = construction_nomF($NomFichier);
        // --- Tri du tableau ---
        $ListeDesPersonnes->TriLPers();
        $_SESSION['ListeDesPersonnes'] = $ListeDesPersonnes ; 
        // --- Appel de la procédure de sauvegarde ---
        $nb_sauvegardes=$ListeDesPersonnes->SauveLPers($NomFichier) ;
        $_SESSION['sauvegarde_a_faire']=false;
        $messageTexte="Sauvegarde de $nb_sauvegardes personnes dans le fichier $NomFichier";
        AffichMessage(CONTEXTE,$messageTexte);
        redirection_delai("quitter","POO_quitter_web.php",5);
       }
     }
     else
     {  // ----------------------------------
        // La sauvegarde n'a pas été demandée 
        // ----------------------------------
        $messageTexte="Aucune sauvegarde des donn&eacute;es actuelles avant le chargement du fichier !";
        AffichMessage(CONTEXTE,$messageTexte);
        $_SESSION['sauvegarde_a_faire']=false;
        redirection_delai("quitter","POO_quitter_web.php",5);
     }
    }
    else
    {
     // --------------------------------------------------------------------------
     // formulaire pour la confirmation de la sauvegarde avant chargement
     // --------------------------------------------------------------------------
     ?>
     <!-- <form action="POO_quitter_web.php" method="post"> -->
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
     <fieldset>
     <legend>Attention les données ont été modifiées. !</legend><br/>
     Voulez-vous sauvegarder les données actuelles avant de quitter la session ?<br/>
     Oui <input type="radio" name="Reponse_Sauvegarde" value="oui" checked="checked"> 
     Non <input type="radio" name="Reponse_Sauvegarde" value="non"> <br/><br/>
     Si oui, entrez le nom du fichier (ex : liste_personnes) : <input type="text" name="NomFichier" size="20" maxlength="20" autofocus/><br/><br/>
     <input type="submit" name="verif_sauvegarde" value="Valider" />
     <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
     <input type="reset" value="Effacer la sélection" />
     </fieldset>
     </form>
     <?php
    }
    // ----------------------------------
    // -- lien pour retourner au menu ---
    // ----------------------------------
    include 'INCLUDE/POO_include_retour_menu_web.php';
   }
   // ----------------------------------------------------------
   // sinon on affiche le texte au revoir
   // ----------------------------------------------------------
   else   
   {
    $messageTexte="Au revoir !";
    AffichMessage(CONTEXTE,$messageTexte);
    // Suppression des varaibles de session
    session_destroy() ;
   }
   ?>
 </body>
</html>
