<?php
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Modification d'un personne</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   include 'INCLUDE/POO_include_sprog_commun_web.php';
   define("CONTEXTE","Modification");
   // -- Fonction de chargement dynamique des classes ---
   function __autoload($NomClasse) {
     require $NomClasse . '_Classe.php';
   }
   // --- Récupération des objets LPers ---
   if (isset($_SESSION['ListeDesPersonnes'])) {
      $ListeDesPersonnes = $_SESSION['ListeDesPersonnes'];
   }
   $nbpersonnes = $ListeDesPersonnes->CompteLPers();
   if (!empty($_POST['ValModifPersonne']))
   {
    // --------------------------------------------------------------
    // cas où les données des champs ont été saisies
    // on traite ces données et on modifie la personne
    // --------------------------------------------------------------
    $NumModif=$_SESSION['NumModif'];
    $une_personne=$ListeDesPersonnes->GetUnePersonne($NumModif);
    $Nom=$une_personne->_nom;
    $Prenom=$une_personne->_prenom;
    $Age=$une_personne->_age;    
    // --- on récupère les valeurs saisies ---
    if (isset($_POST['NouvNom'])) $NouvNom = $_POST['NouvNom'] ;
    else $NouvNom     = ''     ;
    if (isset($_POST['NouvPrenom'])) $NouvPrenom = $_POST['NouvPrenom'] ;
    else $NouvPrenom     = ''  ;
    if (isset($_POST['NouvAge'])) $NouvAge = $_POST['NouvAge'] ;
    else $NouvAge     = ''     ;
    // --- Protection de l'injection HTML ---
    $NouvNom    = strip_tags($NouvNom)   ;
    $NouvPrenom = strip_tags($NouvPrenom);
    $NouvAge    = strip_tags($NouvAge)   ;  
    // -----------------------------------------------
    // on vérifie qu'il y a au moins un champ non vide
    // -----------------------------------------------
    if (!empty($NouvNom) || !empty($NouvPrenom) || !empty($NouvAge))
    {
      // ---------------------------------------
      // on vérifie la validité de chaque champ
      // ---------------------------------------
      $retourValidationAge=true;
      $retourValidationNom=true;
      $retourValidationPrenom=true;
      if ( (!empty($NouvAge)) && ($Age!=normalisation_numerique($NouvAge)))
      {
       $NouvAge=normalisation_numerique($NouvAge);
       $retourValidationAge=validation_Age($NouvAge);
       if ($retourValidationAge)
       {
        $Age  = intval($NouvAge)   ;
       }
      }
      if ( (!empty($NouvNom)) && ($Nom!=normalisation_nom($NouvNom)))
      {
       $NouvNom=normalisation_nom($NouvNom);
       $retourValidationNom=!empty($NouvNom);
       if ($retourValidationNom)
       {
        $Nom  = $NouvNom   ;
       }
      }
      if ( (!empty($NouvPrenom)) && ($Prenom!=normalisation_nom($NouvPrenom)))
      {
       $NouvPrenom=normalisation_nom($NouvPrenom);
       $retourValidationPrenom=!empty($NouvPrenom);
       if ($retourValidationPrenom)
       {
        $Prenom  = $NouvPrenom   ;
       }
      }
      // ----------------------------------------------------
      // vérification du résultat de la validation des champs
      // ----------------------------------------------------
      if ((!$retourValidationAge) || (!$retourValidationNom) || (!$retourValidationPrenom) )
      {
        // -------------------------------
        // si un des champs est invalide
        // -------------------------------
        redirection_delai("modification","POO_modification_web.php",15);
      }
      else
      {
        // -------------------------------
        // si tous les champs sont valides
        // on met a jour le tableau des personnes
        // -------------------------------
        $UnePersonne      = new Personne($Nom,$Prenom,$Age);
        $ListeUnePersonne = new LPers()   ;
        $ListeUnePersonne->AjoutUnePersonne($UnePersonne,$NumModif) ;
        $ListeUnePersonne->AfficheLPers("Personne modifi&eacute;e") ;
        unset($ListeUnePersonne);
        $ListeDesPersonnes->AjoutUnePersonne($UnePersonne,$NumModif) ;
        // -- on memorise qu'il faut faire une sauvegarde --
        $_SESSION['sauvegarde_a_faire']=true ;

      }
    }
    else
    {
      $messageTexte="Pas de modification : tous les champs sont vides !";
      AffichMessage(CONTEXTE,$messageTexte);
    }
   }
   elseif (!empty($_POST['ChoixModifPersonne']))
   {
    // --------------------------------------------------------------
    // cas où la personne à modifier a été sélectionnée
    // on doit saisir les valeurs des champs
    // --------------------------------------------------------------
    if ((empty($_POST['NumModif'])) && ($_POST['NumModif'] != 0))
    {
      $messageTexte="Aucune personne n'a &eacute;t&eacute; s&eacute;lectionn&eacute;e !";
      AffichMessage(CONTEXTE,$messageTexte);
    }
    else
    {
     $NumModif=$_POST['NumModif']             ;
     // --- Protection de l'injection HTML ---
     $NumModif = strip_tags($NumModif);
     $_SESSION['NumModif']=$NumModif;
     $UnePersonne = $ListeDesPersonnes->GetUnePersonne($NumModif);
     $ListeUnePersonne = new LPers()   ;
     $ListeUnePersonne->AjoutUnePersonne($UnePersonne,$NumModif) ;
     $ListeUnePersonne->AfficheLPers("Cette personne va &ecirc;tre modifi&eacute;e") ;
     unset($ListeUnePersonne);
     // --- on affiche le formulaire pour saisir les valeurs de remplacement ---
     ?>
     <br/>
     <!-- <form action="POO_modification_web.php" method="post"> -->
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
       <fieldset>
       <legend>Saisissez les nouvelles valeurs :</legend><br/>
       <b>ATTENTION</b> : un champ non renseign&eacute; (vide) laisse la valeur inchang&eacute;e !
       <table summary="Tableau de modification">
        <caption>&nbsp;</caption>
        <thead>
         <tr>
         <!-- entête du tableau -->
          <th>Nouveau Nom</th>
          <th>Nouveau Pr&eacute;nom</th>
          <th>Nouvel Age</th>
         </tr>
        </thead>
        <tr>
          <td><input type="text" name="NouvNom" size="20" maxlength="20" placeholder="Dupont de Nemours"/></td>
          <td><input type="text" name="NouvPrenom" size="40" maxlength="40" placeholder="Jean Charles"/></td>
          <td><input type="text" name="NouvAge" size="3" maxlength="3" pattern="[1-9][0-9]{1,3}" placeholder="28" /></td>
        </tr>
       </table>
       <br/><br/>
       <input type="submit" name="ValModifPersonne" value="Modifier cette personne" />
       <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
       <input type="reset" value="Effacer le formulaire" />
       </fieldset>
     </form>
     <?php
    }
   }
   elseif (!empty($_POST['RechercherCritere']))
   {
    // --------------------------------------------------------------
    // cas où les critères de recherhe on été saisis
    // on affiche un formulaire pour sélectionner la personne à modifier
    // parmi la liste des personnes affichées
    // --------------------------------------------------------------
    if (empty($_POST['ValRech']))
    {
      $messageTexte="Aucune valeur de recherche n'a &eacute;t&eacute; saisie !";
      AffichMessage(CONTEXTE,$messageTexte);
    }
    else
    {
     $CritRech = $_POST['CritRech'];
     $ValRech  = $_POST['ValRech'] ;
     // --- Protection de l'injection HTML ---
     $CritRech = strip_tags($CritRech);
     $ValRech  = strip_tags($ValRech) ;
     if (($CritRech == "Nom") || ($CritRech == "Prenom") )
     { // normamisation
       $ValRech=normalisation_nom($ValRech) ;
     }
     // --- Recherche ---
     $TabCriteres=array($CritRech,$ValRech);
     $ListeDesPersonnes->RechCritLPers($TabCriteres);
     $nb_personnes_trouvees=$ListeDesPersonnes->CompteLRechPers();
     if ($nb_personnes_trouvees == 0)
     {
      $messageTexte="La recherche pour $CritRech=$ValRech n'a trouv&eacute; aucune personne !";
      AffichMessage(CONTEXTE,$messageTexte);
     }
     else
     {
      $ListeDesPersonnes->AfficheLRechPers("Liste des personnes trouvées");
      // affichage du formulaire de saisie de la personne à modifier
      ?>
      <br/>
      <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
      <fieldset>
      <legend>Saisissez le Num&eacute;ro de la personne &agrave; modifier :</legend><br/>
      Entrez le <b>Num&eacute;ro</b> de la personne &agrave; modifier : <input type="text" name="NumModif" size="20" maxlength="20" autofocus/><br/><br/>
      <input type="submit" name="ChoixModifPersonne" value="Modifier" />
      <input type="reset" value="Effacer le formulaire" />
      </fieldset>
      </form>
      <?php
     }
    }
   }
   else
   {
    // -----------------------------------------------
    // cas où on doit afficher le formulaire de saisie
    // des critères de recherche pour la personne à modifier
    // -----------------------------------------------
    if ($nbpersonnes == 0)
    {
      $messageTexte="Actuellement il n'y a aucune personne en mémoire !";
      AffichMessage(CONTEXTE,$messageTexte);
    }
    else
    {  // --- formulaire de saisie des informations pour la recherche
       formulaire_saisie_criteres() ;
    }
   }
   // ----------------------------------
   // -- lien pour retourner au menu ---
   // ----------------------------------
   include 'INCLUDE/POO_include_retour_menu_web.php';
   ?>
 </body>
</html>
