<?php
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Chargement fichier de personnes</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   include 'INCLUDE/POO_include_sprog_commun_web.php';
   define("CONTEXTE","Chargement");
   // -- Fonction de chargement dynamique des classes ---
   function __autoload($NomClasse) {
     require $NomClasse . '_Classe.php';
   }
   // --- Récupération des objets LPers ---
   if (isset($_SESSION['ListeDesPersonnes'])) {
      $ListeDesPersonnes = $_SESSION['ListeDesPersonnes'];
   }
   if (!isset($_SESSION['sauvegarde_a_faire'])) $sauvegarde_a_faire=false;
   else $sauvegarde_a_faire=$_SESSION['sauvegarde_a_faire'];
   if ($sauvegarde_a_faire)
   {
    // -------------------------------------------------------
    // traitement du cas où les données ont été modifiées
    // il faut vérifier si une sauvegarde doit être faite avant le chargement
    // -------------------------------------------------------
    if (!empty($_POST['verif_sauvegarde']))
    {
     // -------------------------------------------------------
     // cas où la sauvegarde a peut être été demandée et le nom du fichier indiqué
     // -------------------------------------------------------
     // --- on récupère la réponse ---
     $Reponse_Sauvegarde    = $_POST['Reponse_Sauvegarde']    ;
     // --- Protection de l'injection HTML ---
     $Reponse_Sauvegarde    = strip_tags($Reponse_Sauvegarde)    ;
     if ($Reponse_Sauvegarde == "oui")
     {
       // ----------------------------
       // La sauvegarde a été demandée 
       // ----------------------------
       // --- on récupère le nom du fichier ---
       if (isset($_POST['NomFichier'])) $NomFichier = $_POST['NomFichier'] ;
       else $NomFichier     = ''     ;
       // --- Prétraitement du nom du fichier ---
       $NomFichier = pretraitement_nomF($NomFichier);
       if (empty($NomFichier))
       {
        $messageTexte="Sauvegarde impossible, le nom du fichier n'est pas indiqu&eacute; !";
        AffichMessage(CONTEXTE,$messageTexte);
        redirection_delai("chargement","POO_chargement_web.php",5);
       }
       else
       {
        // --- Construction du nom du fichier ---
        $NomFichier = construction_nomF($NomFichier);
        // --- Tri du tableau ---
        $ListeDesPersonnes->TriLPers();
        $_SESSION['ListeDesPersonnes'] = $ListeDesPersonnes ; 
        // --- Appel de la procédure de sauvegarde ---
        $nb_sauvegardes=$ListeDesPersonnes->SauveLPers($NomFichier) ;
        $_SESSION['sauvegarde_a_faire']=false;
        $messageTexte="Sauvegarde de $nb_sauvegardes personnes dans le fichier $NomFichier";
        AffichMessage(CONTEXTE,$messageTexte);
        redirection_delai("chargement","POO_chargement_web.php",5);
       }
     }
     else
     {
        // ----------------------------------
        // La sauvegarde n'a pas été demandée 
        // ----------------------------------
        $messageTexte="Aucune sauvegarde des donn&eacute;es actuelles avant le chargement du fichier !";
        AffichMessage(CONTEXTE,$messageTexte);
        $_SESSION['sauvegarde_a_faire']=false;
        redirection_delai("chargement","POO_chargement_web.php",5);
     }
    }
    else
    {
     // --------------------------------------------------------------------------
     // Formulaire pour la confirmation de la sauvegarde avant chargement
     // --------------------------------------------------------------------------
     ?>
     <!-- <form action="POO_chargement_web.php" method="post"> -->
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
     <fieldset>
     <legend>Attention les données ont été modifiées. !</legend><br/>
     Voulez-vous sauvegarder les données actuelles avant de charger le fichier ?<br/>
     Oui <input type="radio" name="Reponse_Sauvegarde" value="oui" checked="checked"> 
     Non <input type="radio" name="Reponse_Sauvegarde" value="non"> <br/><br/>
     Si oui, entrez le nom du fichier (ex : liste_personnes) : <input type="text" name="NomFichier" size="20" maxlength="20" autofocus/><br/><br/>
     <input type="submit" name="verif_sauvegarde" value="Valider" />
     <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
     <input type="reset" value="Effacer la sélection" />
     </fieldset>
     </form>
     <?php
    }
   }
   // --------------------------------------------------------------------------
   // si l'affichage de la page provient d'un charger, on effectue le chargement
   // --------------------------------------------------------------------------
   elseif (!empty($_POST['charger']))
   {
     // --- On récupère le nom du fichier ---
     if (isset($_POST['NomFichier'])) $NomFichier = $_POST['NomFichier'] ;
     else $NomFichier     = ''     ;
     // --- Protection de l'injection HTML ---
     $NomFichier    = strip_tags($NomFichier)    ;
     if (empty($NomFichier))
     {
        $messageTexte="Chargement impossible, le nom du fichier n'est pas indiqu&eacute; !";
        AffichMessage(CONTEXTE,$messageTexte);
     }
     else
     {// --- Construction du nom du fichier ---
      $NomFichier = construction_nomF($NomFichier);
      // --- Appel de la procédure de chargement ---
      $nb_charges=$ListeDesPersonnes->ChargeLPers($NomFichier) ;
      if ($nb_charges != 0)
      {
       $messageTexte="Chargement de $nb_charges personnes depuis le fichier $NomFichier";
       AffichMessage(CONTEXTE,$messageTexte);
      }
     }
   }
   // ------------------------------------------------------------------------
   // sinon on affiche le formulaire de saisie du nom du fichier de chargement
   // ------------------------------------------------------------------------
   else   
   {
     $Repertoire_recherche="../Sauvegardes";
     $tab_liste_fichiers=Liste_fichiers($Repertoire_recherche);
     if (count($tab_liste_fichiers)==0)
     {
      $messageTexte="Aucun fichier trouvé dans le répertoire $Repertoire_recherche !";
      AffichMessage(CONTEXTE,$messageTexte);
     }
     else
     {
     ?>
     <br/>
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
      <fieldset>
      <legend>Saisissez le nom du fichier &agrave; charger :</legend><br/>
      Liste des fichiers trouv&eacute;s : 
      <select name="NomFichier" size="1">
      <?php
      foreach($tab_liste_fichiers as $valNomFichier)
      {
       echo "<option>";
       echo $valNomFichier;
       echo "</option>";
      }
      ?>
      </select><br/><br/>
      <input type="submit" name="charger" value="Charger le fichier" />
      </fieldset>
     </form>
     <?php
     }
   }
   // ----------------------------------
   // -- lien pour retourner au menu ---
   // ----------------------------------
   include 'INCLUDE/POO_include_retour_menu_web.php';
   ?>
 </body>
</html>
