<?php
 // ====================
 // === Classe LPers ===
 // ====================
 class LPers {
  const NON_TROUVE       = '-1' ;
  const CASE_NON_DEFINIE = '-1' ;
  const AUCUN            = -1 ;
  // Propriétés
  private $_LP = array(); // Liste des personnes
  private $_LR = array(); // Liste de recherche
  // ------------------------------  
  // -- __get et __set méthodes magiques --
  public function __get($propriete) {
    if (property_exists($this, $propriete)) {
      return $this->$propriete;
    }
  }
  // ------------------------------  
  public function __set($propriete, $valeur) {
   if (property_exists($this, $propriete)) {
    if ($propriete=="_LP") {
      $this->_LP=$valeur;
    }
    if ($propriete=="_LR") {
      $this->_LR=$valeur;
    }
   }
  }
  // ------------------------------  
  // Méthode pour compter les personnes
  public function CompteLPers() {
     return count($this->_LP);
  } // Fin de CompteLPers
  // ------------------------------  
  // Méthode pour compter les personnes de la liste de recherche
  public function CompteLRechPers() {
     return count($this->_LR);
  } // Fin de CompteLRechPers
  // ------------------------------  
  // Méthode pour ajouter une personne
  public function AjoutUnePersonne($Pers,$num) {
     if ($num == CASE_NON_DEFINIE )
       $this->_LP[]=$Pers;
     else
     {
       unset($this->_LP[$num]);
       $this->_LP[$num]=$Pers;
     }
     
  } // Fin de AjoutUnePersonne
  // ------------------------------  
  // Méthode pour ajouter une personne
  public function GetUnePersonne($num) {
     return $this->_LP[$num];     
  } // Fin de GetUnePersonne
  // ------------------------------  
  // Méthode d'affichage de la liste des personnes
  public function AfficheLPers($titre) {
    $this->AfficheUneListe($titre,$this->_LP,false);
  } // Fin de AfficheLPers
  // ==================================================
  // --- fonction outil d'affichage d'une personne  ---
  // ==================================================
  private function AfficheUneListe($titre,$ListeP,$AffIndice) {
   // entête de l'affichage
   ?>
   <table summary="Tableau de r&eacute;sultat">
   <caption><?php echo $titre;?></caption>
   <thead>
    <tr>
    <!-- entête du tableau -->
     <?php
     if ($AffIndice)  echo "<th>ID</th>";
     ?>
     <th>Nom</th>
     <th>Pr&eacute;nom</th>
     <th>Age</th>
    </tr>
   </thead>
   <?php
   if (count($ListeP) ==0) {
    echo "<td colspan=\"4\"><b>Aucune donn&eacute;e &agrave; afficher</b></td>";
   }
   else {
    foreach($ListeP as $indice => $Pers) {
      echo "<tr>";
      if ($AffIndice)  echo "<td>$indice</td>";
      $Pers->Affiche($indice);
      echo "</tr>";
    }
   } 
   ?>
   </table>
   <?php
  } // Fin de AfficheUneListe
  // ==================================================
  // --- fonction outil d'ajout d'une liste de personne  ---
  // ==================================================
  public function AjoutLPers($ListeP) {
   if (count($ListeP) != 0) {
    $LP_ListeP=$ListeP->_LP;
    foreach($LP_ListeP as $indice => $Pers)
        $this->_LP[]=$Pers;
   } 
   ?>
   </table>
   <?php
  } // Fin de AjoutLPers
  // ==================================================
  // --- fonction outil d'ajout d'une liste de personne  ---
  // ==================================================
  public function TriLPers() {
     usort($this->_LP, 'comparer');
  } // Fin de TriLPers
  // ==================================================
  // --- Méthode de sauvegarde de la liste des personnes  ---
  // ==================================================
  public function SauveLPers($NomF) {
   try {
    $nbpers=count($this->_LP);
    if ($nbpers == 0)
       throw new Exception("Aucune personne à sauvegarder !");
    if (empty($NomF))
       throw new Exception("Erreur : Nom du fichier incorrect !");
    // Sérialisation et sauvegarde
    $ChaineLPers1 = serialize($this->_LP) ;
    $nb_ecrits=@file_put_contents($NomF,$ChaineLPers1);
    if (! $nb_ecrits) $nb_ecrits=self::AUCUN;
    else $nb_ecrits=$nbpers;
   }
   catch(Exception $e){
       $messageTexte=$e->getMessage();
       AffichMessage("Sauvegarde",$messageTexte);
   }
   finally {
     return $nb_ecrits ;
   }   
  } // Fin de SauveLPers
  // ==================================================
  // --- Méthode de sauvegarde de la liste des personnes  ---
  // ==================================================
   public function ChargeLPers($NomF) {
   try {
    $nblues=0;
    if (empty($NomF))
       throw new Exception("Erreur : Nom du fichier incorrect !");
    if (file_exists($NomF)) {
     $ChaineLPers = @file_get_contents($NomF) ;
     if (! $ChaineLPers) $nblues=self::AUCUN;
     else
     {
      $this->_LP  = unserialize($ChaineLPers);
      $nblues=count($this->_LP);
     }
    }
    else
           throw new Exception("Erreur : Fichier $NomF non trouvé !");
   }
   catch(Exception $e){
      $messageTexte=$e->getMessage();
      AffichMessage("Chargement",$messageTexte);
   }
   finally {
     return $nblues ;
   }   
  } // Fin de ChargeLPers
  // =====================================================
  // --- Méthode d'affichage de la liste de recherche  ---
  // =====================================================
  public function AfficheLRechPers($titre) {
   if (count($this->_LR) == 0) {
       $messageTexte="Aucune personne à afficher !";
       AffichMessage("Recherche",$messageTexte);
   }
   else {
       $this->AfficheUneListe($titre,$this->_LR,true);
   }
  } // Fin de AfficheLRechPers
  // =====================================================
  // --- Méthode de recherche selon critère  ---
  // =====================================================
  public function RechCritLPers(Array $TabCriteres) {
   $CritRech=$TabCriteres[0]; $ValRech=$TabCriteres[1];
   if ($CritRech != self::NON_TROUVE) {
    unset($this->_LR)   ;
    $this->_LR = array(); // liste de recherche vidée
    $numcase = self::NON_TROUVE ;
    switch($CritRech) {
      case 'ID'    : $ValRech=intval($ValRech);     break;
      case 'Nom'   : $ValRech=strtoupper($ValRech); break;
      case 'Prenom': $ValRech=strtoupper($ValRech); break;
      case 'Age'   : $ValRech=intval($ValRech);     break;
    }
    foreach($this->_LP as $indice => $Pers) {
     $trouveID     = ($CritRech=='ID')&&($ValRech==$indice);
     $trouveNom    = ($CritRech=='Nom')&&($ValRech==$Pers->_nom);
     $trouvePrenom = ($CritRech=='Prenom')&&($ValRech==$Pers->_prenom);
     $trouveAge    = ($CritRech=='Age')&&($ValRech==$Pers->_age);
     $trouve = $trouveID || $trouveNom || $trouvePrenom || $trouveAge ;
     if ($trouve) {
      $this->_LR[$indice] = $Pers ;
      $numcase = $indice          ;
     }
    }
   }  
  } // Fin de RechCritLPers
  // =====================================================
  // --- Méthode d'affichage de la liste de recherche  ---
  // =====================================================
  public function SupprLPers($num) {
   if (count($this->_LP) == 0) {
       $messageTexte="Aucune personne à supprimer !";
       AffichMessage("Suppression",$messageTexte);
   }
   else {
     unset($this->_LP[$num]);
   }
  } // Fin de SupprLPers
 } // Fin de la classe LPers
?>
