<?php
define("MAXID","1000000");
define("MAXAGE","120");
define("WEB_EOL","<br/>");
define("CASE_NON_DEFINIE","-1");
define("AUCUN","-1");
// =================================================
// --- fonction outil de suppression des accents ---
// =================================================
function supprime_accent($chaine)
{
  // tableau des caractères accentués à remplacer
  $caracteres_a_remplacer     = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'ß', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'Ā', 'ā', 'Ă', 'ă', 'Ą', 'ą', 'Ć', 'ć', 'Ĉ', 'ĉ', 'Ċ', 'ċ', 'Č', 'č', 'Ď', 'ď', 'Đ', 'đ', 'Ē', 'ē', 'Ĕ', 'ĕ', 'Ė', 'ė', 'Ę', 'ę', 'Ě', 'ě', 'Ĝ', 'ĝ', 'Ğ', 'ğ', 'Ġ', 'ġ', 'Ģ', 'ģ', 'Ĥ', 'ĥ', 'Ħ', 'ħ', 'Ĩ', 'ĩ', 'Ī', 'ī', 'Ĭ', 'ĭ', 'Į', 'į', 'İ', 'ı', 'Ĳ', 'ĳ', 'Ĵ', 'ĵ', 'Ķ', 'ķ', 'Ĺ', 'ĺ', 'Ļ', 'ļ', 'Ľ', 'ľ', 'Ŀ', 'ŀ', 'Ł', 'ł', 'Ń', 'ń', 'Ņ', 'ņ', 'Ň', 'ň', 'ŉ', 'Ō', 'ō', 'Ŏ', 'ŏ', 'Ő', 'ő', 'Œ', 'œ', 'Ŕ', 'ŕ', 'Ŗ', 'ŗ', 'Ř', 'ř', 'Ś', 'ś', 'Ŝ', 'ŝ', 'Ş', 'ş', 'Š', 'š', 'Ţ', 'ţ', 'Ť', 'ť', 'Ŧ', 'ŧ', 'Ũ', 'ũ', 'Ū', 'ū', 'Ŭ', 'ŭ', 'Ů', 'ů', 'Ű', 'ű', 'Ų', 'ų', 'Ŵ', 'ŵ', 'Ŷ', 'ŷ', 'Ÿ', 'Ź', 'ź', 'Ż', 'ż', 'Ž', 'ž', 'ſ', 'ƒ', 'Ơ', 'ơ', 'Ư', 'ư', 'Ǎ', 'ǎ', 'Ǐ', 'ǐ', 'Ǒ', 'ǒ', 'Ǔ', 'ǔ', 'Ǖ', 'ǖ', 'Ǘ', 'ǘ', 'Ǚ', 'ǚ', 'Ǜ', 'ǜ', 'Ǻ', 'ǻ', 'Ǽ', 'ǽ', 'Ǿ', 'ǿ');
  // tableau des caractères sans accent de remplacement
  $caracteres_de_remplacement = array('A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'l', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o');
  // retour de la fonction
  return str_replace($caracteres_a_remplacer, $caracteres_de_remplacement, $chaine);
}
// =================================================
// --- fonction outil de normalisation des noms  ---
// =================================================
function normalisation_nom($chaine)
{
 // tableau des motifs de recherche
 $tab_motif=array('/[^a-zA-Z -]/', '/[ -]+/', '/^-|-$/');
 // tableau des caract&egrave;res de remplacement
 $tab_remplacement=array('', '-', '')     ;
 // chaine de caract&egrave;res sur laquelle s'effectue le remplacement
 $chaine_contexte=supprime_accent($chaine);
 // retour de la fonction
 return strtoupper(preg_replace($tab_motif,$tab_remplacement, $chaine_contexte));
}
// =================================================
// --- fonction outil de normalisation des numériques  ---
// =================================================
function normalisation_numerique($numero)
{
 // tableau des motifs de recherche
 $tab_motif=array('/[^0-9,.]/');
 // tableau des caract&egrave;res de remplacement
 $tab_remplacement=array('')     ;
 // retour de la fonction
 $numero_retour=intval(preg_replace($tab_motif,$tab_remplacement, $numero));
 return $numero_retour;
}
// =============================================================
// --- fonction outil de normalisation des noms de fichiers  ---
// =============================================================
function normalisation_fichier($nomf)
{
  // tableau des motifs de recherche
  $tab_motif=array('/[^a-zA-Z0-9 ._-]/','/[ -]+/','/^-|-$/');
  // tableau des caract&egrave;res de remplacement
  $tab_remplacement=array('', '-', '')   ;
  // remplacement des caracteres non autoris&eacute;s  et suppression des accents
  $nomf_retour=strtolower(preg_replace($tab_motif,$tab_remplacement,supprime_accent($nomf)));
  $nomf_retour=str_replace('-','_',$nomf_retour);
  // suppression de l'&eacute;ventuelle extension
  $elements_chemin=pathinfo($nomf_retour);
  $nomf_retour=$elements_chemin['filename'];
  // -- on pr&eacute;pare le nom du r&eacute;pertoire de sauvegarde ---
  $repertoire_courant=realpath(".")      ;
  $repertoire_sauvegarde="../Sauvegardes/"  ;
  // -- on traite le nom du fichier ---
  $nomf_retour=$repertoire_sauvegarde.$nomf_retour.".txt";
  return $nomf_retour;
}
// ===============================
// --- Validation du champ Age ---
// ===============================
function validation_Age($Age)
{
 $erreur=false;
 $erreurEntete="Erreur : champ Age <?php echo $Age; ?>";
 if (($Age == 0) || (!(($Age >0)&&($Age <MAXAGE))))
 {
  $erreur=true;
  $val=MAXAGE;
  $erreurMessage="Le champ Age est invalide ($Age). Il doit être compris entre 1 et $val ans";
 }
 if ($erreur)
 {
  ?>
  <fieldset>
  <legend><?php echo $erreurEntete ?></legend><br/>
  <?php
  if (!empty($erreurMessage)) echo $erreurMessage;
  ?>
  <br/>
  </fieldset>
  <?php
 }
 return !$erreur;
}
// ====================================================
// --- fonction de compraison des noms de personne  ---
// ====================================================
function comparer($a, $b) {
    return strcmp($a->_nom, $b->_nom);
} 
// ==========================================
// --- Redirection vers URL avec un délai --- 
// ==========================================
function redirection_delai($texte_page,$page_web, $delai_secondes)
{
 $delai_microsecondes=$delai_secondes*1000;
 echo "<h2>".$texte_page."  dans ".$delai_secondes." secondes ...</h3><br/>";
 // --- javascript d'attente de 5 secondes avant de rediriger vers la page de chargement --- 
 echo "<script type=\"text/javascript\">
          setInterval(function () {
            window.location = '".$page_web."';
          }, ".$delai_microsecondes.");
        </script>";
}
// ========================================
// --- Redirection vers URL immédiate   --- 
// ========================================
function redirection_immediate($page_web)
{// --- rediriger vers la page de chargement --- 
 //echo'<script>window.location="'.$page_web.'";</script>';
 print('<meta http-equiv="refresh" content="0;URL='.$page_web.'">');
}
// ========================================
// --- Prétaritement du nom du fichier   --- 
// ========================================
function pretraitement_nomF($NomFichier)
{ $NomFichier    = strip_tags($NomFichier)    ; // Protection de l'injection HTML
  $NomFichier    = trim($NomFichier)                          ;   
  $NomFichier    = preg_replace('/\s{2,}/', ' ', $NomFichier) ;
  $NomFichier    = strtolower($NomFichier)                    ;   
  $NomFichier    = str_replace(' ', '_', $NomFichier)         ;   
  return $NomFichier;
}
// ========================================
// --- Prétaritement du nom du fichier   --- 
// ========================================
function construction_nomF($NomFichier)
{// On prépare le nom du répertoire de sauvegarde
 $RepCourant=realpath(".");
 $RepSauv="../Sauvegardes/";
 // On génère le nom du fichier
 $ElementsChemin=pathinfo($NomFichier);
 $NomFichier=$RepSauv.$ElementsChemin['filename'].".txt";
 return $NomFichier;
}
// ==========================================
// --- Liste des fichiers d'un répertoire ---
// ===========================================
function Liste_fichiers($Repertoire_recherche)
{
  $tab_liste_fichiers=array();
  if($Repertoire = opendir($Repertoire_recherche))
  {
    while(false !== ($FicRep = readdir($Repertoire)))
    {
      if (!is_dir($FicRep))
      {
       $tab_liste_fichiers[]=$FicRep;
      }
    }
  }
  return $tab_liste_fichiers;
}
// ================================================================
// --- fonction outil du formulaire de séclection des critères  ---
// ================================================================
function formulaire_saisie_criteres()
{
 ?>
 <br/>
 <!-- <form action="POO_modification_web.php" method="post"> -->
 <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
 <fieldset>
 <legend>Saisissez les crit&egrave;res de recherche :</legend><br/>
 S&eacute;lectionnez le crit&egrave;re de recherche : <br/><br/>
 Identifiant <input type="radio" name="CritRech" value="ID"> 
 Nom <input type="radio" name="CritRech" value="Nom" checked="checked"> 
 Pr&eacute;nom <input type="radio" name="CritRech" value="Prenom"> 
 Age <input type="radio" name="CritRech" value="Age"> <br/><br/>
 Entrez la valeur selon le crit&egrave;re : <input type="text" name="ValRech" size="20" maxlength="20" autofocus/><br/><br/>
 <input type="submit" name="RechercherCritere" value="Rechercher" />
 <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
 <input type="reset" value="Effacer le formulaire" />
 </fieldset>
 </form>
 <?php
}
// ================================================================
// --- fonction outil d'affcichage des messages d'erreurs  ---
// ================================================================
function AffichMessage($titreM,$messageTexte)
{
 ?>
 <fieldset>
 <legend><?php echo $titreM;?></legend><br/>
 <b><?php echo $messageTexte;?></b><br />
 </fieldset>
 <?php
}
?>

