<?php
 // =======================
 // === Classe Personne ===
 // =======================
 class Personne {
   // -- Déclaration de deux constantes --
   const AGE_MIN = 1     ;      
   const AGE_MAX = 120   ;     
   // -- Les propriétés  --
   private $_nom    ;
   private $_prenom ;
   private $_age    ;
   // ------------------------------  
   // -- __get et __set méthodes magiques --
   public function __get($propriete) {
     if (property_exists($this, $propriete)) {
       return $this->$propriete;
     }
   }
   // ------------------------------  
   public function __set($propriete, $valeur) {
     if (property_exists($this, $propriete)) {
       if ($propriete=="age") {
         if (($valeur>=self::AGE_MIN)&&($valeur<self::AGE_MAX))
           $this->_age=intval(trim($valeur));
       }
       else {
         $this->$propriete = strtoupper(trim($valeur));
       }
     }
   }
   // ------------------------------  
   // -- Méthode de saisie d'une personne --
   public function Saisie() {
     try {
      echo "Entrez un nom (vide pour fin)    : "   ;
      $this->_nom    = fgets(STDIN);
      $this->_nom=trim($this->_nom);
      if (empty($this->_nom)) throw new Exception();
      echo "Entrez un prénom (vide pour fin) : "   ;
      $this->_prenom = fgets(STDIN)      ;
      $this->_prenom=trim($this->_prenom);
      if (empty($this->_prenom)) throw new Exception();
      echo "Entrez un âge (vide pour fin)    : "      ;
      $this->_age = fgets(STDIN)        ;
      $this->_age = intval($this->_age) ;
      if ($this->_age <= 0) throw new Exception();
      // traitement des données
      $this->_nom = strtoupper($this->_nom)      ;
      $this->_prenom = strtoupper($this->_prenom);
     }
     catch(Exception $e){
       $this->_nom    = null ;
       $this->_prenom = null ;
       $this->_age    = 0    ;
     }
   }
   // ------------------------------  
   // -- Méthode d'affichage d'une personne --
   public function Affiche() {
     echo $this->_nom."\t".$this->_prenom."\t".$this->_age;
     echo PHP_EOL ;
   }
 }
?>
