<?php
 // ====================
 // === Classe LPers ===
 // ====================
 class LPers {
  const NON_TROUVE = '-1' ;
  const REP_SAUVE  = "../../Sauvegardes/" ;
  // Propriétés
  private $_LP = array();// Liste des personnes
  private $_LR = array();// Liste de recherche
  // ------------------------------  
  // Méthode de saisie de la liste des personnes
  public function SaisieLPers() {
   $nom="";
   while(!(is_null($nom))) {
     $Pers = new Personne();
     $Pers->Saisie()       ; 
     $nom = $Pers->_nom    ; 
     if(!(is_null($nom))) $this->_LP[]=$Pers;
   }
  } // Fin de SaisieLPers
  // ------------------------------  
  // Méthode d'affichage de la liste des personnes
  public function AfficheLPers() {
   if (count($this->_LP) == 0) {
    echo "Aucune personne à afficher !".PHP_EOL;
   }
   else {
    $this->AfficheTabPersonnes($this->_LP);
   }
  } // Fin de AfficheLPers
  // ------------------------------  
  // Méthode d'affichage de la liste de recherche
  public function AfficheLRechPers() {
   if (count($this->_LR) == 0) {
    echo "Aucune personne à afficher !".PHP_EOL;
   }
   else {
    $this->AfficheTabPersonnes($this->_LR);
   }
  } // Fin de AfficheLRechPers
  // ------------------------------  
  // Méthode outils d'affichage d'une liste de personnes
  private function AfficheTabPersonnes($ListeP) {
    // entête de l'affichage
    echo "----------------------------\n";
    echo "ID :\tNom\tPrénom\tAge\n";
    echo "----------------------------\n";
    foreach($ListeP as $indice => $Pers) {
     echo "$indice :\t";
     $Pers->Affiche();
    }
    echo "----------------------------\n";
  } // Fin de AfficheTabPersonnes
  // ------------------------------  
  // Méthode de sauvegarde de la liste des personnes
  public function SauveLPers() {
   try {
    $nbpers=count($this->_LP);
    if ($nbpers == 0)
       throw new Exception("Aucune personne à sauvegarder !");
    echo "Nom du fichier de sauvegarde : ";
    $NomF = fgets(STDIN);
    $NomF = trim($NomF) ;
    if (empty($NomF))
       throw new Exception("Erreur : Nom du fichier incorrect !");
    // Construction du nom du fichier
    $NomF = self::REP_SAUVE.$NomF;
    // Sérialisation et sauvegarde
    $ChaineLPers1 = serialize($this->_LP) ;
    file_put_contents($NomF,$ChaineLPers1);
    echo $nbpers." personne(s) sauvegardée(s) dans le fichier ".$NomF.PHP_EOL;
   }
   catch(Exception $e){
    echo $e->getMessage().PHP_EOL;
   }
  } // Fin de SauveLPers
  // ------------------------------  
  // Méthode de chargement de la liste des personnes
  public function ChargeLPers() {
   try {
    echo "Nom du fichier à charger : ";
    $NomF = fgets(STDIN);
    $NomF = trim($NomF) ;
    if (empty($NomF))
       throw new Exception("Erreur : Nom du fichier incorrect !");
    // Construction du nom du fichier
    $NomF = self::REP_SAUVE.$NomF;
    // Sérialisation et sauvegarde
    if (file_exists($NomF)) {
     $ChaineLPers = file_get_contents($NomF) ;
     $this->_LP   = unserialize($ChaineLPers);
     $nbpers=count($this->_LP);
     echo $nbpers." personne(s) lue(s) à partir du fichier ".$NomF.PHP_EOL;
    }
    else
     echo "Fichier $NomF non trouvé !".PHP_EOL;
   }
   catch(Exception $e){
    echo $e->getMessage().PHP_EOL;
   }
  } // Fin de ChargeLPers
  // ------------------------------  
  // Méthode de choix du critère  
  public function ChoixCritere() {
    $TabCritRetour=array();
    $this->_LR = array(); // liste de recherche vidée
    echo "Critère de recherche : ".PHP_EOL; ;
    echo "    -a- Identifiant (ID)".PHP_EOL ;
    echo "    -b- Nom".PHP_EOL              ;
    echo "    -c- Prénom".PHP_EOL           ;
    echo "    -d- Age".PHP_EOL              ;
    echo "Entrez le critère (a,b,c ou d) : ";
    fscanf(STDIN,"%s",$critere);
    $critere = $critere[0]     ;
    switch ($critere) {
      case 'a' : echo "Identifiant : "; break;
      case 'b' : echo "Nom         : "; break;
      case 'c' : echo "Prénom      : "; break;
      case 'd' : echo "Age         : "; break;
      default  : echo "Choix erroné !".PHP_EOL; break;  
    }
    if (($critere >='a') && ($critere <='d')) {
      $valeur_recherche=fgets(STDIN);
      $valeur_recherche=trim($valeur_recherche);
      if (strlen($valeur_recherche) == 0) {
       $TabCritRetour[0] = self::NON_TROUVE;
       $TabCritRetour[1] = 0               ;
      }
      else {
      $TabCritRetour[0] = $critere         ;
      $TabCritRetour[1] = $valeur_recherche;
      }
    }
    else {
      $TabCritRetour[0] = self::NON_TROUVE;
      $TabCritRetour[1] = 0               ;
    }
    return $TabCritRetour;  
  } // Fin de ChoixCritere
  // ------------------------------  
  // Méthode de recherche selon critère  
  public function RechCritLPers(Array $TabC) {
   $CritRech = $TabC[0]; $ValRech  = $TabC[1];
   if ($CritRech != self::NON_TROUVE) {
    $this->_LR = array(); // liste de recherche vidée
    $numcase = self::NON_TROUVE ;
    switch($CritRech) {
      case 'a':$ValRech=intval($ValRech);break;
      case 'b':$ValRech=strtoupper($ValRech);break;
      case 'c':$ValRech=strtoupper($ValRech);break;
      case 'd':$ValRech=intval($ValRech);break;
    }
    foreach($this->_LP as $indice => $Pers) {
     $trouvea = ($CritRech=='a')&&($ValRech==$indice);
     $trouveb = ($CritRech=='b')&&($ValRech==$Pers->_nom);
     $trouvec = ($CritRech=='c')&&($ValRech==$Pers->_prenom);
     $trouved = ($CritRech=='d')&&($ValRech==$Pers->_age);
     $trouve = $trouvea || $trouveb || $trouvec || $trouved ;
     if ($trouve) {
      $this->_LR[$indice] = $Pers ;
      $numcase = indice           ;
     }
    }
    if ($numcase == self::NON_TROUVE)
      echo "$ValRech pas trouvé !".PHP_EOL;
   }  
  } // Fin de RechCritLPers
  // ------------------------------  
  // Méthode de suppression d'une personne 
  public function SupprimePers() {
   $nbpers=count($this->_LR);
   if ($nbpers==0)
    echo "Aucune suppression !".PHP_EOL;
   else {
    echo "Sélectionnez l'ID de la personne à supprimer : ";
    $numero = fgets(STDIN)   ;
    $numero = trim($numero)  ;
    if (strlen($numero)==0) $numero=self::NON_TROUVE;
    $numero = intval($numero) ;
    $NumOK=array_key_exists($numero,$this->_LR);
    if (!($NumOK)) echo "Aucune sélection".PHP_EOL;
    else {
     $TabSupp[$numero] = $this->_LP[$numero] ;
     $this->AfficheTabPersonnes($TabSupp)    ;
     echo "Confirmez la suppression (o/n) : ";
     fscanf(STDIN,"%s",$reponse)             ;
     if ($reponse == "o") {
      unset($this->_LP[$numero]);   
      echo "Suppression effectuée !".PHP_EOL   ;   
     }
     else {
       echo "Aucune donnée supprimée !".PHP_EOL;
     }
    }
   }
  } // Fin de SupprimePers
  // ------------------------------  
  // Méthode de modification d'une personne 
  public function ModifiePers() {
   $nbpers=count($this->_LR);
   if ($nbpers==0)
    echo "Aucune modification !".PHP_EOL;
   else {
    echo "Sélectionnez l'ID de la personne à modifier : ";
    $numero = fgets(STDIN)    ;
    $numero = trim($numero)   ;
    if (strlen($numero)==0) $numero=self::NON_TROUVE;
    $numero = intval($numero) ;
    $NumOK=array_key_exists($numero,$this->_LR);
    if (!($NumOK)) echo "Aucune sélection".PHP_EOL;
    else {
     $TabMod[$numero] = $this->_LP[$numero]   ;
     $this->AfficheTabPersonnes($TabMod)      ;
     echo "Confirmez la modification (o/n) : ";
     fscanf(STDIN,"%s",$reponse);
     if ($reponse == "o") {
       echo "Saisissez les nouvelles informations (vide pour inchangé) !".PHP_EOL;
       // --- saisie du nom ---
       fprintf(STDOUT, "Nom    actuel : %-20s - Nouveau Nom    : ",$this->_LP[$numero]->_nom);
       $entree=fgets(STDIN)                ;
       // normalisation_nom du nom
       $entree=strtoupper(trim($entree))   ;
       // on vérifie que la saisie n'est pas vide
       if (!empty($entree)) {
         $this->_LP[$numero]->_nom=$entree ;
       }else {
         echo "Pas de modification du nom".PHP_EOL;
       }
       // --- saisie du prénom ---
       fprintf(STDOUT, "Prénom actuel : %-20s - Nouveau Prénom : ",$this->_LP[$numero]->_prenom);
       $entree=fgets(STDIN)                   ;
       // normalisation du prénom
       $entree=strtoupper(trim($entree))      ;
       // on vérifie que la saisie n'est pas vide
       if (!empty($entree)) {
         $this->_LP[$numero]->_prenom=$entree ;
       }else {
         echo "Pas de modification du prénom".PHP_EOL;
       }
       // --- saisie de l'âge ---
       fprintf(STDOUT, "Age    actuel : %-20d - Nouvel Age     : ",$this->_LP[$numero]->_age);
       $entree=fgets(STDIN)                ;
       // normalisation du prénom
       $entree=intval(trim($entree))       ;
       // on vérifie que la saisie n'est pas vide
       if (!empty($entree)) {
         $this->_LP[$numero]->_age=$entree ;
       }else {
         echo "Pas de modification de l'âge".PHP_EOL;
       }
     }
     else { 
       echo "Aucune donnée modifiée !".PHP_EOL;
     } // Fin reponse == 'o'
    } // Fin empty(numero)
   } // Fin nbpers == 0
  } // Fin ModifiePers 
 } // Fin de la classe LPers
?>
